from typing import ClassVar, Tuple, Callable

from pyonear.crypto_hash import CryptoHash

class Direction:
    Left: ClassVar["Direction"]
    Right: ClassVar["Direction"]
    def __eq__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __int__(self) -> int: ...

class MerklePathItem:
    __hash__: ClassVar[None]  # type: ignore
    direction: Direction
    hash: CryptoHash
    def __init__(self, hash: CryptoHash, direction: Direction) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "MerklePathItem": ...
    @staticmethod
    def from_json(raw: str) -> "MerklePathItem": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...
