from typing import ClassVar, Union, Tuple, Sequence, List, Callable
from pathlib import Path

from pyonear.account_id import AccountId

class ED25519PublicKey:
    LENGTH: ClassVar[int]
    def __hash__(self) -> int: ...
    def __init__(self, key_bytes: Union[bytes, Sequence[int]]) -> None: ...
    @staticmethod
    def empty() -> "ED25519PublicKey": ...
    @staticmethod
    def from_bytes(data: bytes) -> "ED25519PublicKey": ...
    @staticmethod
    def from_json(raw: str) -> "ED25519PublicKey": ...
    @staticmethod
    def from_seed(seed: str) -> "ED25519PublicKey": ...
    @staticmethod
    def from_str(s: str) -> "ED25519PublicKey": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class ED25519SecretKey:
    LENGTH: ClassVar[int]
    def __hash__(self) -> int: ...
    def __init__(self, key_bytes: Union[bytes, Sequence[int]]) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "ED25519SecretKey": ...
    @staticmethod
    def from_json(raw: str) -> "ED25519SecretKey": ...
    @staticmethod
    def from_random() -> "ED25519SecretKey": ...
    @staticmethod
    def from_seed(seed: str) -> "ED25519SecretKey": ...
    @staticmethod
    def from_str(s: str) -> "ED25519SecretKey": ...
    def public_key(self) -> ED25519PublicKey: ...
    def sign(self, data: bytes) -> ED25519Signature: ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class ED25519Signature:
    LENGTH: ClassVar[int]
    def __hash__(self) -> int: ...
    def __init__(self, sig_bytes: Union[bytes, Sequence[int]]) -> None: ...
    @staticmethod
    def empty() -> "ED25519Signature": ...
    @staticmethod
    def from_bytes(data: bytes) -> "ED25519Signature": ...
    @staticmethod
    def from_json(raw: str) -> "ED25519Signature": ...
    @staticmethod
    def from_str(s: str) -> "ED25519Signature": ...
    def to_json(self) -> str: ...
    def verify(self, data: bytes, public_key: ED25519PublicKey) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class EmptySigner:
    @staticmethod
    def public_key() -> ED25519PublicKey: ...
    @staticmethod
    def sign() -> ED25519Signature: ...
    @staticmethod
    def verify(data: bytes, signature: Signature) -> bool: ...

class KeyType:
    ED25519: ClassVar["KeyType"]
    SECP256K1: ClassVar["KeyType"]
    def __hash__(self) -> int: ...
    def __eq__(self, other) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __int__(self) -> int: ...

class Secp256K1PublicKey:
    LENGTH: ClassVar[int]
    def __hash__(self) -> int: ...
    def __init__(self, key_bytes: Union[bytes, Sequence[int]]) -> None: ...
    @staticmethod
    def empty() -> "Secp256K1PublicKey": ...
    @staticmethod
    def from_bytes(data: bytes) -> "Secp256K1PublicKey": ...
    @staticmethod
    def from_json(raw: str) -> "Secp256K1PublicKey": ...
    @staticmethod
    def from_str(s: str) -> "Secp256K1PublicKey": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class Secp256K1SecretKey:
    LENGTH: ClassVar[int]
    def __hash__(self) -> int: ...
    def __init__(self, key_bytes: Union[bytes, Sequence[int]]) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "Secp256K1SecretKey": ...
    @staticmethod
    def from_json(raw: str) -> "Secp256K1SecretKey": ...
    @staticmethod
    def from_random() -> "Secp256K1SecretKey": ...
    @staticmethod
    def from_seed(seed: str) -> "Secp256K1SecretKey": ...
    @staticmethod
    def from_str(s: str) -> "Secp256K1SecretKey": ...
    def public_key(self) -> Secp256K1PublicKey: ...
    def sign(self, data: bytes) -> Secp256K1Signature: ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class Secp256K1Signature:
    LENGTH: ClassVar[int]
    def __hash__(self) -> int: ...
    def __init__(self, sig_bytes: Union[bytes, Sequence[int]]) -> None: ...
    def check_signature_values(self, reject_upper: bool) -> bool: ...
    @staticmethod
    def empty() -> "Secp256K1Signature": ...
    @staticmethod
    def from_bytes(data: bytes) -> "Secp256K1Signature": ...
    @staticmethod
    def from_json(raw: str) -> "Secp256K1Signature": ...
    @staticmethod
    def from_str(s: str) -> "Secp256K1Signature": ...
    def recover(self, msg: bytes) -> Secp256K1PublicKey: ...
    def to_json(self) -> str: ...
    def verify(self, data: bytes, public_key: Secp256K1PublicKey) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

PublicKey = Union[ED25519PublicKey, Secp256K1PublicKey]
SecretKey = Union[ED25519SecretKey, Secp256K1SecretKey]
Signature = Union[ED25519Signature, Secp256K1Signature]

class InMemorySigner:
    account_id: AccountId
    public_key: PublicKey
    secret_key: SecretKey

    def __init__(
        self, account_id: AccountId, public_key: PublicKey, secret_key: SecretKey
    ) -> None: ...
    def compute_vrf_with_proof(self) -> Tuple[List[int], List[int]]: ...
    @staticmethod
    def from_bytes(data: bytes) -> "InMemorySigner": ...
    @staticmethod
    def from_file(path: Path) -> "InMemorySigner": ...
    @staticmethod
    def from_json(raw: str) -> "InMemorySigner": ...
    @staticmethod
    def from_random(account_id: AccountId, key_type: KeyType) -> "InMemorySigner": ...
    @staticmethod
    def from_secret_key(
        account_id: AccountId, secret_key: SecretKey
    ) -> "InMemorySigner": ...
    @staticmethod
    def from_seed(seed: str) -> "InMemorySigner": ...
    def sign(self, data: bytes) -> Signature: ...
    def to_json(self) -> str: ...
    def verify(self, data: bytes, signature: Signature) -> bool: ...
    def write_to_file(self, path: Path) -> None: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class KeyFile:
    account_id: AccountId
    public_key: PublicKey
    secret_key: SecretKey

    def __init__(
        self, account_id: AccountId, public_key: PublicKey, secret_key: SecretKey
    ) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "KeyFile": ...
    @staticmethod
    def from_file(path: Path) -> "KeyFile": ...
    @staticmethod
    def from_json(raw: str) -> "KeyFile": ...
    def to_json(self) -> str: ...
    def write_to_file(self, path: Path) -> None: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

Signer = Union[InMemorySigner, EmptySigner]
