from typing import ClassVar, Union, Sequence, Tuple, Callable

class AccountId:
    MAX_LEN: ClassVar[int]
    MIN_LEN: ClassVar[int]
    def __init__(self, account_id: str) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "AccountId": ...
    @staticmethod
    def from_json(raw: str) -> "AccountId": ...
    def is_implicit(self) -> bool: ...
    def is_sub_account_of(self, parent: "AccountId") -> bool: ...
    def is_system(self) -> bool: ...
    def is_top_level(self) -> bool: ...
    def to_json(self) -> str: ...
    @staticmethod
    def validate(account_id: str) -> None: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...
    def __hash__(self) -> int: ...
