from transformers import Pipeline
import numpy as np
"""文本分类模型的pipline
"""
class TextClassificationPipeline(Pipeline):
   
    def __init__(self, return_all_scores: bool = False, **kwargs):
        super().__init__(**kwargs)

        # self.check_model_type(
        #     TF_MODEL_FOR_SEQUENCE_CLASSIFICATION_MAPPING
        #     if self.framework == "tf"
        #     else MODEL_FOR_SEQUENCE_CLASSIFICATION_MAPPING
        # )

        self.return_all_scores = return_all_scores

    def __call__(self, *args, **kwargs):
        """
        Classify the text(s) given as inputs.

        Args:
            args (:obj:`str` or :obj:`List[str]`):
                One or several texts (or one list of prompts) to classify.

        Return:
            A list or a list of list of :obj:`dict`: Each result comes as list of dictionaries with the following keys:

            - **label** (:obj:`str`) -- The label predicted.
            - **score** (:obj:`float`) -- The corresponding probability.

            If ``self.return_all_scores=True``, one such dictionary is returned per label.
        """
        outputs = super().__call__(*args, **kwargs)

        if self.model.config.num_labels == 1:
            scores = 1.0 / (1.0 + np.exp(-outputs))
        else:
            scores = np.exp(outputs) / np.exp(outputs).sum(-1, keepdims=True)
        if self.return_all_scores:
            return [
                [{"label": self.model.config.id2label[i], "score": score.item()} for i, score in enumerate(item)]
                for item in scores
            ]
        else:
            return [
                {"label": self.model.config.id2label[item.argmax()], "score": item.max().item()} for item in scores
            ]
