from .service_caller import DesignerServiceCaller


class _DesignerServiceCallerFactory:

    caller_cache_by_workspace_id = {}

    @staticmethod
    def get_instance(workspace, from_cli=False):
        """Get a instance of designer service caller.

        :param workspace: workspace
        :param from_cli: mark if this service caller is used from cli.
        """
        workspace_id = workspace._workspace_id
        cache = _DesignerServiceCallerFactory.caller_cache_by_workspace_id
        if workspace_id not in cache:
            cache[workspace_id] = DesignerServiceCaller(workspace)
        if from_cli:
            cache[workspace_id]._set_from_cli_for_telemetry()
        return cache[workspace_id]
