# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse

from .. import models


class ModuleWithAuthOperations(object):
    """ModuleWithAuthOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def register_module(
            self, subscription_id, resource_group_name, workspace_name, validate_only=False, anonymous_registration=False, upgrade_if_exists=False, set_as_default_version=True, include_run_setting_params=True, overwrite_module_version=None, get_yaml=False, x_ms_github_token=None, x_ms_github_code=None, snapshot_source_zip_file=None, properties=None, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param validate_only:
        :type validate_only: bool
        :param anonymous_registration:
        :type anonymous_registration: bool
        :param upgrade_if_exists:
        :type upgrade_if_exists: bool
        :param set_as_default_version:
        :type set_as_default_version: bool
        :param include_run_setting_params:
        :type include_run_setting_params: bool
        :param overwrite_module_version:
        :type overwrite_module_version: str
        :param get_yaml:
        :type get_yaml: bool
        :param x_ms_github_token:
        :type x_ms_github_token: str
        :param x_ms_github_code:
        :type x_ms_github_code: str
        :param snapshot_source_zip_file:
        :type snapshot_source_zip_file: str
        :param properties: ModuleSourceType: string, YamlFile: string,
         DevopsArtifactsZipUrl: string, ModuleWorkingMechanism: string,
         IsPrivateRepo: boolean
        :type properties: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ModuleDto or ClientRawResponse if raw=true
        :rtype: ~designer.models.ModuleDto or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.register_module.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if validate_only is not None:
            query_parameters['validateOnly'] = self._serialize.query("validate_only", validate_only, 'bool')
        if anonymous_registration is not None:
            query_parameters['anonymousRegistration'] = self._serialize.query("anonymous_registration", anonymous_registration, 'bool')
        if upgrade_if_exists is not None:
            query_parameters['upgradeIfExists'] = self._serialize.query("upgrade_if_exists", upgrade_if_exists, 'bool')
        if set_as_default_version is not None:
            query_parameters['setAsDefaultVersion'] = self._serialize.query("set_as_default_version", set_as_default_version, 'bool')
        if include_run_setting_params is not None:
            query_parameters['includeRunSettingParams'] = self._serialize.query("include_run_setting_params", include_run_setting_params, 'bool')
        if overwrite_module_version is not None:
            query_parameters['overwriteModuleVersion'] = self._serialize.query("overwrite_module_version", overwrite_module_version, 'str')
        if get_yaml is not None:
            query_parameters['getYaml'] = self._serialize.query("get_yaml", get_yaml, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)
        if x_ms_github_token is not None:
            header_parameters['x-ms-github-token'] = self._serialize.header("x_ms_github_token", x_ms_github_token, 'str')
        if x_ms_github_code is not None:
            header_parameters['x-ms-github-code'] = self._serialize.header("x_ms_github_code", x_ms_github_code, 'str')

        # Construct form data
        form_data_content = {
            'SnapshotSourceZipFile': snapshot_source_zip_file,
            'properties': properties,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 302]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ModuleDto', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    register_module.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}'}

    def list_modules(
            self, subscription_id, resource_group_name, workspace_name, continuation_token=None, continuation_token1=None, count=500, active_only=True, module_scope="2", include_empty_namespace=False, include_run_setting_params=True, order_by="Name", search_string=None, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param continuation_token:
        :type continuation_token: str
        :param continuation_token1:
        :type continuation_token1: str
        :param count:
        :type count: int
        :param active_only:
        :type active_only: bool
        :param module_scope: Possible values include: 'All', 'Global',
         'Workspace', 'Anonymous', 'Step'
        :type module_scope: str or ~designer.models.ModuleScope
        :param include_empty_namespace:
        :type include_empty_namespace: bool
        :param include_run_setting_params:
        :type include_run_setting_params: bool
        :param order_by:
        :type order_by: str
        :param search_string:
        :type search_string: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PaginatedModuleDtoList or ClientRawResponse if raw=true
        :rtype: ~designer.models.PaginatedModuleDtoList or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.list_modules.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if continuation_token is not None:
            query_parameters['continuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str')
        if count is not None:
            query_parameters['count'] = self._serialize.query("count", count, 'int')
        if active_only is not None:
            query_parameters['activeOnly'] = self._serialize.query("active_only", active_only, 'bool')
        if module_scope is not None:
            query_parameters['ModuleScope'] = self._serialize.query("module_scope", module_scope, 'str')
        if include_empty_namespace is not None:
            query_parameters['includeEmptyNamespace'] = self._serialize.query("include_empty_namespace", include_empty_namespace, 'bool')
        if include_run_setting_params is not None:
            query_parameters['includeRunSettingParams'] = self._serialize.query("include_run_setting_params", include_run_setting_params, 'bool')
        if order_by is not None:
            query_parameters['orderBy'] = self._serialize.query("order_by", order_by, 'str')
        if search_string is not None:
            query_parameters['searchString'] = self._serialize.query("search_string", search_string, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)
        if continuation_token1 is not None:
            header_parameters['continuationToken'] = self._serialize.header("continuation_token1", continuation_token1, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PaginatedModuleDtoList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_modules.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}'}

    def upgrade_module(
            self, subscription_id, resource_group_name, workspace_name, module_namespace, module_name, validate_only=False, overwrite_module_version=None, x_ms_github_token=None, x_ms_github_code=None, snapshot_source_zip_file=None, properties=None, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param module_namespace:
        :type module_namespace: str
        :param module_name:
        :type module_name: str
        :param validate_only:
        :type validate_only: bool
        :param overwrite_module_version:
        :type overwrite_module_version: str
        :param x_ms_github_token:
        :type x_ms_github_token: str
        :param x_ms_github_code:
        :type x_ms_github_code: str
        :param snapshot_source_zip_file:
        :type snapshot_source_zip_file: str
        :param properties: SetAsDefaultVersion: boolean, ModuleSourceType:
         string, YamlFile: string, DevopsArtifactsZipUrl: string,
         ModuleWorkingMechanism: string, IsPrivateRepo: boolean
        :type properties: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ModuleDto or ClientRawResponse if raw=true
        :rtype: ~designer.models.ModuleDto or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.upgrade_module.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str'),
            'moduleNamespace': self._serialize.url("module_namespace", module_namespace, 'str'),
            'moduleName': self._serialize.url("module_name", module_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if validate_only is not None:
            query_parameters['validateOnly'] = self._serialize.query("validate_only", validate_only, 'bool')
        if overwrite_module_version is not None:
            query_parameters['overwriteModuleVersion'] = self._serialize.query("overwrite_module_version", overwrite_module_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)
        if x_ms_github_token is not None:
            header_parameters['x-ms-github-token'] = self._serialize.header("x_ms_github_token", x_ms_github_token, 'str')
        if x_ms_github_code is not None:
            header_parameters['x-ms-github-code'] = self._serialize.header("x_ms_github_code", x_ms_github_code, 'str')

        # Construct form data
        form_data_content = {
            'SnapshotSourceZipFile': snapshot_source_zip_file,
            'properties': properties,
        }

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 302]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ModuleDto', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    upgrade_module.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/namespaces/{moduleNamespace}/modules/{moduleName}'}

    def get_module(
            self, subscription_id, resource_group_name, workspace_name, module_namespace, module_name, version=None, include_run_setting_params=True, get_yaml=False, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param module_namespace:
        :type module_namespace: str
        :param module_name:
        :type module_name: str
        :param version:
        :type version: str
        :param include_run_setting_params:
        :type include_run_setting_params: bool
        :param get_yaml:
        :type get_yaml: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ModuleDto or ClientRawResponse if raw=true
        :rtype: ~designer.models.ModuleDto or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_module.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str'),
            'moduleNamespace': self._serialize.url("module_namespace", module_namespace, 'str'),
            'moduleName': self._serialize.url("module_name", module_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if version is not None:
            query_parameters['version'] = self._serialize.query("version", version, 'str')
        if include_run_setting_params is not None:
            query_parameters['includeRunSettingParams'] = self._serialize.query("include_run_setting_params", include_run_setting_params, 'bool')
        if get_yaml is not None:
            query_parameters['getYaml'] = self._serialize.query("get_yaml", get_yaml, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ModuleDto', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_module.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/namespaces/{moduleNamespace}/modules/{moduleName}'}

    def update_module(
            self, subscription_id, resource_group_name, workspace_name, module_namespace, module_name, body=None, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param module_namespace:
        :type module_namespace: str
        :param module_name:
        :type module_name: str
        :param body:
        :type body: ~designer.models.UpdateModuleRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ModuleDto or ClientRawResponse if raw=true
        :rtype: ~designer.models.ModuleDto or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.update_module.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str'),
            'moduleNamespace': self._serialize.url("module_namespace", module_namespace, 'str'),
            'moduleName': self._serialize.url("module_name", module_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'UpdateModuleRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ModuleDto', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_module.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/namespaces/{moduleNamespace}/modules/{moduleName}'}

    def get_module_versions(
            self, subscription_id, resource_group_name, workspace_name, module_namespace, module_name, include_run_setting_params=True, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param module_namespace:
        :type module_namespace: str
        :param module_name:
        :type module_name: str
        :param include_run_setting_params:
        :type include_run_setting_params: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: dict or ClientRawResponse if raw=true
        :rtype: dict[str, ~designer.models.ModuleDto] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_module_versions.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str'),
            'moduleNamespace': self._serialize.url("module_namespace", module_namespace, 'str'),
            'moduleName': self._serialize.url("module_name", module_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_run_setting_params is not None:
            query_parameters['includeRunSettingParams'] = self._serialize.query("include_run_setting_params", include_run_setting_params, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('{ModuleDto}', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_module_versions.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/namespaces/{moduleNamespace}/modules/{moduleName}/versions'}

    def get_module_snapshot_url(
            self, subscription_id, resource_group_name, workspace_name, module_namespace, module_name, version=None, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param module_namespace:
        :type module_namespace: str
        :param module_name:
        :type module_name: str
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: str or ClientRawResponse if raw=true
        :rtype: str or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_module_snapshot_url.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str'),
            'moduleNamespace': self._serialize.url("module_namespace", module_namespace, 'str'),
            'moduleName': self._serialize.url("module_name", module_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if version is not None:
            query_parameters['version'] = self._serialize.query("version", version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('str', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_module_snapshot_url.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/namespaces/{moduleNamespace}/modules/{moduleName}/snapshotUrl'}

    def get_module_yaml(
            self, subscription_id, resource_group_name, workspace_name, module_namespace, module_name, version=None, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param module_namespace:
        :type module_namespace: str
        :param module_name:
        :type module_name: str
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: str or ClientRawResponse if raw=true
        :rtype: str or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_module_yaml.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str'),
            'moduleNamespace': self._serialize.url("module_namespace", module_namespace, 'str'),
            'moduleName': self._serialize.url("module_name", module_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if version is not None:
            query_parameters['version'] = self._serialize.query("version", version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('str', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_module_yaml.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/namespaces/{moduleNamespace}/modules/{moduleName}/yaml'}

    def validate_module(
            self, subscription_id, resource_group_name, workspace_name, x_ms_github_token=None, x_ms_github_code=None, snapshot_source_zip_file=None, properties=None, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param x_ms_github_token:
        :type x_ms_github_token: str
        :param x_ms_github_code:
        :type x_ms_github_code: str
        :param snapshot_source_zip_file:
        :type snapshot_source_zip_file: str
        :param properties: ModuleSourceType: string, YamlFile: string,
         DevopsArtifactsZipUrl: string, ModuleWorkingMechanism: string,
         IsPrivateRepo: boolean
        :type properties: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ModuleDtoWithValidateStatus or ClientRawResponse if raw=true
        :rtype: ~designer.models.ModuleDtoWithValidateStatus or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.validate_module.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)
        if x_ms_github_token is not None:
            header_parameters['x-ms-github-token'] = self._serialize.header("x_ms_github_token", x_ms_github_token, 'str')
        if x_ms_github_code is not None:
            header_parameters['x-ms-github-code'] = self._serialize.header("x_ms_github_code", x_ms_github_code, 'str')

        # Construct form data
        form_data_content = {
            'SnapshotSourceZipFile': snapshot_source_zip_file,
            'properties': properties,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 302]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ModuleDtoWithValidateStatus', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    validate_module.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/validate'}

    def parse_module(
            self, subscription_id, resource_group_name, workspace_name, x_ms_github_token=None, x_ms_github_code=None, snapshot_source_zip_file=None, properties=None, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param x_ms_github_token:
        :type x_ms_github_token: str
        :param x_ms_github_code:
        :type x_ms_github_code: str
        :param snapshot_source_zip_file:
        :type snapshot_source_zip_file: str
        :param properties: ModuleSourceType: string, YamlFile: string,
         DevopsArtifactsZipUrl: string, ModuleWorkingMechanism: string,
         IsPrivateRepo: boolean
        :type properties: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ModuleDto or ClientRawResponse if raw=true
        :rtype: ~designer.models.ModuleDto or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.parse_module.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)
        if x_ms_github_token is not None:
            header_parameters['x-ms-github-token'] = self._serialize.header("x_ms_github_token", x_ms_github_token, 'str')
        if x_ms_github_code is not None:
            header_parameters['x-ms-github-code'] = self._serialize.header("x_ms_github_code", x_ms_github_code, 'str')

        # Construct form data
        form_data_content = {
            'SnapshotSourceZipFile': snapshot_source_zip_file,
            'properties': properties,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 302]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ModuleDto', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    parse_module.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/parse'}

    def get_default_version_of_modules(
            self, subscription_id, resource_group_name, workspace_name, body=None, custom_headers=None, raw=False, **operation_config):
        """

        :param subscription_id: The Azure Subscription ID.
        :type subscription_id: str
        :param resource_group_name: The Name of the resource group in which
         the workspace is located.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param body:
        :type body: list[~designer.models.AmlModuleNameMetaInfo]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~designer.models.AmlModuleNameAndDefaultVersion] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<designer.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_default_version_of_modules.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, '[AmlModuleNameMetaInfo]')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[AmlModuleNameAndDefaultVersion]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_default_version_of_modules.metadata = {'url': '/module/v1.0/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/defaultVersion'}
