# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PipelineRun(Model):
    """PipelineRun.

    :param pipeline_id:
    :type pipeline_id: str
    :param run_source:
    :type run_source: str
    :param run_type: Possible values include: 'HTTP', 'SDK', 'Schedule',
     'Portal'
    :type run_type: str or ~designer.models.RunType
    :param parameters: This is a dictionary
    :type parameters: dict[str, str]
    :param data_path_assignments: This is a dictionary
    :type data_path_assignments: dict[str, ~designer.models.LegacyDataPath]
    :param data_set_definition_value_assignment: This is a dictionary
    :type data_set_definition_value_assignment: dict[str,
     ~designer.models.DataSetDefinitionValue]
    :param total_steps:
    :type total_steps: int
    :param logs: This is a dictionary
    :type logs: dict[str, str]
    :param description:
    :type description: str
    :param run_number:
    :type run_number: int
    :param status_code: Possible values include: 'NotStarted', 'InDraft',
     'Preparing', 'Running', 'Failed', 'Finished', 'Canceled', 'Throttled',
     'Unknown'
    :type status_code: str or ~designer.models.PipelineStatusCode
    :param run_status: Possible values include: 'NotStarted', 'Starting',
     'Provisioning', 'Preparing', 'Queued', 'Running', 'Finalizing',
     'CancelRequested', 'Completed', 'Failed', 'Canceled', 'NotResponding'
    :type run_status: str or ~designer.models.RunStatus
    :param status_detail:
    :type status_detail: str
    :param start_time:
    :type start_time: datetime
    :param end_time:
    :type end_time: datetime
    :param graph_id:
    :type graph_id: str
    :param experiment_id:
    :type experiment_id: str
    :param experiment_name:
    :type experiment_name: str
    :param is_experiment_archived:
    :type is_experiment_archived: bool
    :param submitted_by:
    :type submitted_by: str
    :param tags: This is a dictionary
    :type tags: dict[str, str]
    :param step_tags: This is a dictionary
    :type step_tags: dict[str, str]
    :param properties: This is a dictionary
    :type properties: dict[str, str]
    :param aether_start_time:
    :type aether_start_time: datetime
    :param aether_end_time:
    :type aether_end_time: datetime
    :param run_history_start_time:
    :type run_history_start_time: datetime
    :param run_history_end_time:
    :type run_history_end_time: datetime
    :param unique_child_run_compute_targets:
    :type unique_child_run_compute_targets: list[str]
    :param entity_status: Possible values include: 'Active', 'Deprecated',
     'Disabled'
    :type entity_status: str or ~designer.models.EntityStatus
    :param id:
    :type id: str
    :param etag:
    :type etag: str
    :param created_date:
    :type created_date: datetime
    :param last_modified_date:
    :type last_modified_date: datetime
    """

    _validation = {
        'unique_child_run_compute_targets': {'unique': True},
    }

    _attribute_map = {
        'pipeline_id': {'key': 'pipelineId', 'type': 'str'},
        'run_source': {'key': 'runSource', 'type': 'str'},
        'run_type': {'key': 'runType', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'data_path_assignments': {'key': 'dataPathAssignments', 'type': '{LegacyDataPath}'},
        'data_set_definition_value_assignment': {'key': 'dataSetDefinitionValueAssignment', 'type': '{DataSetDefinitionValue}'},
        'total_steps': {'key': 'totalSteps', 'type': 'int'},
        'logs': {'key': 'logs', 'type': '{str}'},
        'description': {'key': 'description', 'type': 'str'},
        'run_number': {'key': 'runNumber', 'type': 'int'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'run_status': {'key': 'runStatus', 'type': 'str'},
        'status_detail': {'key': 'statusDetail', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'graph_id': {'key': 'graphId', 'type': 'str'},
        'experiment_id': {'key': 'experimentId', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'is_experiment_archived': {'key': 'isExperimentArchived', 'type': 'bool'},
        'submitted_by': {'key': 'submittedBy', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'step_tags': {'key': 'stepTags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'aether_start_time': {'key': 'aetherStartTime', 'type': 'iso-8601'},
        'aether_end_time': {'key': 'aetherEndTime', 'type': 'iso-8601'},
        'run_history_start_time': {'key': 'runHistoryStartTime', 'type': 'iso-8601'},
        'run_history_end_time': {'key': 'runHistoryEndTime', 'type': 'iso-8601'},
        'unique_child_run_compute_targets': {'key': 'uniqueChildRunComputeTargets', 'type': '[str]'},
        'entity_status': {'key': 'entityStatus', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'last_modified_date': {'key': 'lastModifiedDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(PipelineRun, self).__init__(**kwargs)
        self.pipeline_id = kwargs.get('pipeline_id', None)
        self.run_source = kwargs.get('run_source', None)
        self.run_type = kwargs.get('run_type', None)
        self.parameters = kwargs.get('parameters', None)
        self.data_path_assignments = kwargs.get('data_path_assignments', None)
        self.data_set_definition_value_assignment = kwargs.get('data_set_definition_value_assignment', None)
        self.total_steps = kwargs.get('total_steps', None)
        self.logs = kwargs.get('logs', None)
        self.description = kwargs.get('description', None)
        self.run_number = kwargs.get('run_number', None)
        self.status_code = kwargs.get('status_code', None)
        self.run_status = kwargs.get('run_status', None)
        self.status_detail = kwargs.get('status_detail', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.graph_id = kwargs.get('graph_id', None)
        self.experiment_id = kwargs.get('experiment_id', None)
        self.experiment_name = kwargs.get('experiment_name', None)
        self.is_experiment_archived = kwargs.get('is_experiment_archived', None)
        self.submitted_by = kwargs.get('submitted_by', None)
        self.tags = kwargs.get('tags', None)
        self.step_tags = kwargs.get('step_tags', None)
        self.properties = kwargs.get('properties', None)
        self.aether_start_time = kwargs.get('aether_start_time', None)
        self.aether_end_time = kwargs.get('aether_end_time', None)
        self.run_history_start_time = kwargs.get('run_history_start_time', None)
        self.run_history_end_time = kwargs.get('run_history_end_time', None)
        self.unique_child_run_compute_targets = kwargs.get('unique_child_run_compute_targets', None)
        self.entity_status = kwargs.get('entity_status', None)
        self.id = kwargs.get('id', None)
        self.etag = kwargs.get('etag', None)
        self.created_date = kwargs.get('created_date', None)
        self.last_modified_date = kwargs.get('last_modified_date', None)
