# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from azure.ml.component._restclients.exceptions import wrap_methods_with_decorator
from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.exceptions import HttpOperationError
from .operations.computes_operations import ComputesOperations
from .operations.data_sets_operations import DataSetsOperations
from .operations.experiments_operations import ExperimentsOperations
from .operations.module_operations import ModuleOperations
from .operations.modules_operations import ModulesOperations
from .operations.module_with_auth_operations import ModuleWithAuthOperations
from .operations.packages_operations import PackagesOperations
from .operations.pipeline_drafts_operations import PipelineDraftsOperations
from .operations.pipeline_endpoints_operations import PipelineEndpointsOperations
from .operations.pipeline_runs_operations import PipelineRunsOperations
from .operations.published_pipelines_operations import PublishedPipelinesOperations
from .operations.real_time_endpoints_operations import RealTimeEndpointsOperations
from .operations.samples_operations import SamplesOperations
from . import models


class DesignerServiceClientConfiguration(Configuration):
    """Configuration for DesignerServiceClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):
        if not base_url:
            base_url = 'http://localhost'

        super(DesignerServiceClientConfiguration, self).__init__(base_url)
        # timeout for http caller to 200s since MT timeout is 180s
        # TODO: verify if this works
        self.connection.timeout = 200
        self.add_user_agent('designerserviceclient/{}'.format(VERSION))


class DesignerServiceClient(SDKClient):
    """DesignerServiceClient

    :ivar config: Configuration for client.
    :vartype config: DesignerServiceClientConfiguration

    :ivar computes: Computes operations
    :vartype computes: designer.operations.ComputesOperations
    :ivar data_sets: DataSets operations
    :vartype data_sets: designer.operations.DataSetsOperations
    :ivar experiments: Experiments operations
    :vartype experiments: designer.operations.ExperimentsOperations
    :ivar module: Module operations
    :vartype module: designer.operations.ModuleOperations
    :ivar modules: Modules operations
    :vartype modules: designer.operations.ModulesOperations
    :ivar module_with_auth: ModuleWithAuth operations
    :vartype module_with_auth: designer.operations.ModuleWithAuthOperations
    :ivar packages: Packages operations
    :vartype packages: designer.operations.PackagesOperations
    :ivar pipeline_drafts: PipelineDrafts operations
    :vartype pipeline_drafts: designer.operations.PipelineDraftsOperations
    :ivar pipeline_endpoints: PipelineEndpoints operations
    :vartype pipeline_endpoints: designer.operations.PipelineEndpointsOperations
    :ivar pipeline_runs: PipelineRuns operations
    :vartype pipeline_runs: designer.operations.PipelineRunsOperations
    :ivar published_pipelines: PublishedPipelines operations
    :vartype published_pipelines: designer.operations.PublishedPipelinesOperations
    :ivar real_time_endpoints: RealTimeEndpoints operations
    :vartype real_time_endpoints: designer.operations.RealTimeEndpointsOperations
    :ivar samples: Samples operations
    :vartype samples: designer.operations.SamplesOperations

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):
        self.config = DesignerServiceClientConfiguration(base_url)
        super(DesignerServiceClient, self).__init__(None, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '1.0.0'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        # Had to wrap exceptions here since all operation classes are auto generated.
        # TODO: find a better way to wrap
        self.computes = ComputesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.computes)
        self.data_sets = DataSetsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.data_sets)
        self.experiments = ExperimentsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.experiments)
        self.module = ModuleOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.module)
        self.modules = ModulesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.modules)
        self.module_with_auth = ModuleWithAuthOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.module_with_auth)
        self.packages = PackagesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.packages)
        self.pipeline_drafts = PipelineDraftsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.pipeline_drafts)
        self.pipeline_endpoints = PipelineEndpointsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.pipeline_endpoints)
        self.pipeline_runs = PipelineRunsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.pipeline_runs)
        self.published_pipelines = PublishedPipelinesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.published_pipelines)
        self.real_time_endpoints = RealTimeEndpointsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.real_time_endpoints)
        self.samples = SamplesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        wrap_methods_with_decorator(self.samples)
