# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['src', 'src.transformer']

package_data = \
{'': ['*']}

install_requires = \
['feature-engine==1.5.2',
 'joblib==1.2.0',
 'numpy==1.23.5',
 'pandas==1.5.2',
 'phonenumbers==8.13.2',
 'scikit-learn==1.2.0']

setup_kwargs = {
    'name': 'sk-transformers',
    'version': '0.5.0',
    'description': 'A collection of various scikit-learn transformers for all kinds of preprocessing and feature engineering',
    'long_description': '![The machine](https://raw.githubusercontent.com/chrislemke/sk-transformers/master/docs/assets/images/image.png)\n\n# sk-transformers\n### A collection of various scikit-learn transformers for all kinds of preprocessing and feature engineering steps 🛠\n\n[![testing](https://github.com/chrislemke/sk-transformers/actions/workflows/testing.yml/badge.svg?branch=main)](https://github.com/chrislemke/sk-transformers/actions/workflows/testing.yml)\n[![codecov](https://codecov.io/github/chrislemke/sk-transformers/branch/main/graph/badge.svg?token=LJLXQXX6M8)](https://codecov.io/github/chrislemke/sk-transformers)\n[![deploy package](https://github.com/chrislemke/sk-transformers/actions/workflows/deploy-package.yml/badge.svg)](https://github.com/chrislemke/sk-transformers/actions/workflows/deploy-package.yml)\n[![pypi](https://img.shields.io/pypi/v/sk-transformers)](https://pypi.org/project/sk-transformers/)\n![python version](https://img.shields.io/pypi/pyversions/sk-transformers?logo=python&logoColor=yellow)\n[![downloads](https://img.shields.io/pypi/dm/sk-transformers)](https://pypistats.org/packages/sk-transformers)\n[![docs](https://img.shields.io/badge/docs-mkdoks%20material-blue)](https://chrislemke.github.io/sk-transformers/)\n[![license](https://img.shields.io/github/license/chrislemke/sk-transformers)](https://github.com/chrislemke/sk-transformers/blob/main/LICENSE)\n[![mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)\n[![black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://pycqa.github.io/isort/)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n## Introduction\nEvery data tabular is different. Every column needs to be treated differently. [Scikit-learn](https://scikit-learn.org/stable/index.html) has a nice [collection of dataset transformers](https://scikit-learn.org/stable/data_transforms.html). But the possibilities of data transformation are infinite - one collection is simply not enough. This project provides a brought collection of data transformers. The idea is simple. It is like a well-equipped toolbox 🧰: You always find the tool you need and sometimes you get inspired by seeing a tool you did not know before. Please feel free to [contribute](https://chrislemke.github.io/sk-transformers/CONTRIBUTING/) your tools and ideas.\n\n## Installation\nIf you are using [Poetry](https://python-poetry.org/), you can install the package with the following command:\n```bash\npoetry add sk_transformers\n```\nIf you are using [pip](https://pypi.org/project/pip/), you can install the package with the following command:\n```bash\npip install sk_transformers\n```\n\n## installing dependencies\nWith [Poetry](https://python-poetry.org/):\n```bash\npoetry install\n```\nWith [pip](https://pypi.org/project/pip/):\n```bash\npip install -r requirements.txt\n```\n\n## The transformers\nData preprocessing often involves similar processes. No matter whether it\'s manipulating strings or numbers, etc. [Scikit-learn\'s pipeline](https://scikit-learn.org/stable/modules/compose.html#combining-estimators) implementation makes it easy to structure and sequence such preprocessing processes. To take advantage of this, the [`transformers`](https://github.com/chrislemke/sk-transformers/tree/main/sk-transformers/transformer) contain multiple methods that can be easily pipelined to simplify preprocessing. The list of transformers is open and will be extended permanently. Feel free to [contribute](https://chrislemke.github.io/sk-transformers/CONTRIBUTING/)! 🛠\n\n### Usage\nLet\'s assume you want to use some method from [NumPy\'s mathematical functions](https://numpy.org/doc/stable/reference/routines.math.html), to sum up the values of column `foo` and column `bar`. You could\nuse the [`MathExpressionTransformer`](https://chrislemke.github.io/sk-transformers/number_transformer-reference/#sk-transformers.transformer.number_transformer.MathExpressionTransformer):\n```python\nfrom sk_transformers import MathExpressionTransformer\nimport pandas as pd\nX = pd.DataFrame({"foo": [1, 2, 3], "bar": [4, 5, 6]})\ntransformer = MathExpressionTransformer([("foo", "np.sum", "bar", {"axis": 0})])\ntransformer.fit_transform(X).to_numpy()\n```\n```\narray([[1, 4, 5],\n       [2, 5, 7],\n       [3, 6, 9]])\n```\nEven if we only pass one tuple to the transformer - in this example. Like with most other transformers the idea is to simplify preprocessing by giving the possibility to operate on multiple columns at the same time. In this case, the [`MathExpressionTransformer`](https://chrislemke.github.io/sk-transformers/number_transformer-reference/#sk-transformers.transformer.number_transformer.MathExpressionTransformer) has created an extra column with the name `foo_sum_bar`.\n\n## Contributing\nWe\'re all kind of in the same boat. Preprocessing/feature engineering in data science is somehow very individual - every feature is different and must be handled and processed differently. But somehow we all have the same problems: sometimes date columns have to be changed. Sometimes strings have to be formatted, sometimes durations have to be calculated, etc. There is a huge number of preprocessing possibilities but we all use the same tools.\n\n[Scikit-learns pipelines](https://scikit-learn.org/stable/modules/generated/sklearn.pipeline.Pipeline.html) help to use formalized functions. So why not also share these so-called transformers with others? This open source project has the goal to collect useful preprocessing pipeline steps. Let us all collect what we used for preprocessing and share it with others. This way we can all benefit from each other\'s work and save a lot of time. So if you have a preprocessing step that you use regularly, please feel free to contribute it to this project. The idea is that this is not only a toolbox but also an inspiration for what is possible. Maybe you have not thought about this preprocessing step before.\n\nPlease check out the [guide](https://chrislemke.github.io/sk-transformers/CONTRIBUTING/) on how to contribute to this project.\n\n## Further information\nFor further information, please refer to the [documentation](https://chrislemke.github.io/sk-transformers/).\n',
    'author': 'Christopher Lemke',
    'author_email': 'chris@syhbl.mozmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://chrislemke.github.io/sk-transformers/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.12',
}


setup(**setup_kwargs)
