"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class FargateToSqs extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        if (props.queuePermissions) {
            defaults.CheckListValues(['Read', 'Write'], props.queuePermissions, 'queue permission');
        }
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.SQS);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        // Setup the SQS Queue
        [this.sqsQueue] = defaults.buildQueue(this, `${id}-queue`, {
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            existingQueueObj: props.existingQueueObj,
            enableEncryptionWithCustomerManagedKey: props.enableEncryptionWithCustomerManagedKey,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        // Enable message send and receive permissions for Fargate service by default
        if (props.queuePermissions) {
            if (props.queuePermissions.includes('Read')) {
                this.sqsQueue.grantConsumeMessages(this.service.taskDefinition.taskRole);
            }
            if (props.queuePermissions.includes('Write')) {
                this.sqsQueue.grantSendMessages(this.service.taskDefinition.taskRole);
            }
        }
        else {
            this.sqsQueue.grantSendMessages(this.service.taskDefinition.taskRole);
        }
        // Setting environment variables
        const queueArnEnvironmentVariableName = props.queueArnEnvironmentVariableName || 'SQS_QUEUE_ARN';
        this.container.addEnvironment(queueArnEnvironmentVariableName, this.sqsQueue.queueArn);
        const queueUrlEnvironmentVariableName = props.queueUrlEnvironmentVariableName || 'SQS_QUEUE_URL';
        this.container.addEnvironment(queueUrlEnvironmentVariableName, this.sqsQueue.queueUrl);
    }
}
exports.FargateToSqs = FargateToSqs;
_a = JSII_RTTI_SYMBOL_1;
FargateToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-sqs.FargateToSqs", version: "2.28.0" };
//# sourceMappingURL=data:application/json;base64,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