def compute_epsg(lon: float, lat: float) -> int:
    """
    Compute the EPSG code of the UTM zone which contains
    the point with given longitude and latitude
    Args:
        lon (float): longitude of the point
        lat (float): latitude of the point
    Returns:
        int: EPSG code
    """
    # UTM zone number starts from 1 at longitude -180,
    # and increments by 1 every 6 degrees of longitude
    zone = int((lon + 180) // 6 + 1)

    # EPSG = CONST + ZONE where CONST is
    # - 32600 for positive latitudes
    # - 32700 for negative latitudes
    const = 32600 if lat > 0 else 32700
    return const + zone