# LanGauge
LanGauage: NLP experiment platform. To be open-sourced publicly (Apache 2.0 or similar).

## Architecture
![architecture](images/arc.png)

## What is it?
Natural Language Processing (NLP) is one of the most important fields of research in today’s world. It has many applications such as chatbots, sentiment analysis, and document classification. 

LanGauge is a web application leveraging Natural Language Processing (NLP) to reduce the time spent analyzing medical research papers in an easy-to-use fashion. This free, open-source platform helps researchers in fields such as drug discovery curate their data to secure and scale the development of health solution. An example application would be enhancing COVID-19 research using multiple NLP models on medical datasets.  

We want to use the language processing models to “gauge” the usefulness of open-source medical datasets for the researchers.  

## How to run the project using pip ?
 1. Create (or navigate to) a folder you would like to use with LanGauge and create a virtual environment
 
    On Linux use
    ```bash
    python3 -m venv env
    ```
    and activate it using
    ```bash
    source env/bin/activate
    ```
 2. Install using
    ```bash
    pip install langauge
    ```
 3. Now, Run the following command line instruction 
     for starting the front end
     ```
     langauge ui [OPTIONS]
     
     Options:
     -h, --host TEXT          The network address to listen on (default:
                              127.0.0.1). Use 0.0.0.0 to bind to all addresses if
                              you want to access the tracking server from other
                              machines.

     -p, --port INTEGER       The UI port to configure on (default:8080)

     -b --backend TEXT        The backend address & port to listen on
                              requests (default: 127.0.0.1:5000).
                              
     --help                   Show this message and exit.
     ```

     and for the backend use

     ```
     langauge backend [OPTIONS]
     
     Options:
     -bp, --backendport INTEGER  The backend port to configure on (default:5000)
     ```

## or using docker-compose?
 1. Clone the repository.
 ```bash
 git clone https://github.com/flapmx/LanGauge-INTERNAL.git
 ```
 2. Ensure you have docker and docker-compose installed.
    
 3. Move to langauge directory
 ```bash
 cd langauge
 ```
 
 4. Build and Launch the project
 ```bash
 docker-compose up --build -d
 ```
 
## How to access the application?
 1. http://localhost:8080 for the React front end
 2. http://localhost:5000 for the Flask back end
 3. http://localhost:5555 for the monitoring Celery

## How to shut down?
```bash
 docker-compose down
 ```
