# Generated by Django 3.2.7 on 2022-06-13 15:15

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import mojec_core.app.models.base


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('phoneNumber', models.CharField(blank=True, db_column='phoneNumber', max_length=11, null=True, unique=True)),
                ('emailVerified', models.BooleanField(blank=True, db_column='emailVerified', null=True)),
                ('phoneNumberVerified', models.BooleanField(blank=True, db_column='phoneNumberVerified', null=True)),
                ('verified', models.BooleanField(blank=True, null=True)),
                ('verificationMode', models.CharField(blank=True, db_column='verificationMode', max_length=255, null=True)),
                ('platform', models.CharField(blank=True, max_length=15, null=True)),
                ('active', models.BooleanField(blank=True, null=True)),
                ('bankAccountNumber', models.CharField(blank=True, db_column='bankAccountNumber', max_length=11, null=True)),
                ('isOnboardingComplete', models.BooleanField(db_column='isOnboardingComplete', default=False)),
                ('onboardingStage', models.CharField(blank=True, db_column='onboardingStage', max_length=100, null=True)),
                ('imageUrl', models.TextField(blank=True, db_column='imageUrl', null=True)),
                ('bankAccountName', models.CharField(blank=True, db_column='bankAccountName', max_length=255, null=True)),
                ('bvn', models.CharField(blank=True, max_length=11, null=True)),
                ('bankCode', models.CharField(blank=True, db_column='bankCode', max_length=10, null=True)),
                ('sbcId', models.UUIDField(blank=True, null=True)),
                ('fcmToken', models.JSONField(blank=True, db_column='fcmToken', null=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'db_table': 'Users',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Cart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('totalAmount', models.DecimalField(db_column='totalAmount', decimal_places=2, default=0, max_digits=15)),
                ('status', models.TextField(blank=True, null=True)),
                ('transactionRef', models.CharField(blank=True, db_column='transactionRef', max_length=255, null=True)),
                ('deliveryAddress', models.TextField(blank=True, db_column='deliveryAddress', null=True)),
            ],
            options={
                'db_table': 'Carts',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Conversation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('participants', models.ManyToManyField(blank=True, null=True, related_name='conversations', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'Conversations',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Disco',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('location', models.TextField(blank=True, null=True)),
                ('status', models.CharField(blank=True, max_length=30, null=True)),
            ],
            options={
                'db_table': 'Discos',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='MeansOfIdentification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('active', models.BooleanField(default=True)),
            ],
            options={
                'db_table': 'MeansOfIdentifications',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='PaymentType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(blank=True, max_length=255, null=True)),
                ('path', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'PaymentTypes',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='PaymentVendor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(blank=True, max_length=255, null=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('accountNo', models.CharField(blank=True, db_column='accountNo', max_length=255, null=True)),
                ('accountName', models.CharField(blank=True, db_column='accountName', max_length=255, null=True)),
                ('paths', models.CharField(blank=True, max_length=255, null=True)),
                ('ref', models.CharField(blank=True, max_length=255, null=True)),
                ('logo', models.CharField(blank=True, max_length=255, null=True)),
                ('credential', models.JSONField()),
                ('url', models.URLField()),
            ],
            options={
                'db_table': 'PaymentVendors',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('productName', models.CharField(max_length=255)),
                ('description', models.CharField(max_length=255)),
                ('quantity', models.IntegerField(default=1)),
                ('price', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('status', models.CharField(blank=True, max_length=30, null=True)),
            ],
            options={
                'db_table': 'Products',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='UserAddress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('text', models.TextField()),
            ],
            options={
                'abstract': False,
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='VerificationType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('active', models.BooleanField(blank=True, null=True)),
            ],
            options={
                'db_table': 'VerificationTypes',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Wallet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('recipientCode', models.CharField(blank=True, db_column='recipientCode', max_length=255, null=True)),
                ('recipient', models.JSONField(blank=True, null=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('balance', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='wallet', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'Wallets',
            },
        ),
        migrations.CreateModel(
            name='WorkOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(blank=True, null=True)),
                ('orderId', models.CharField(db_column='orderId', max_length=30)),
                ('assessmentReport', models.TextField(blank=True, db_column='assessmentReport', null=True)),
                ('completionReport', models.TextField(blank=True, db_column='completionReport', null=True)),
                ('transactionReference', models.TextField(blank=True, db_column='transactionReference', null=True)),
                ('generalStatus', models.TextField(blank=True, db_column='generalStatus', null=True)),
                ('noteForAgent', models.TextField(blank=True, db_column='noteForAgent', null=True)),
                ('additionalNote', models.TextField(blank=True, db_column='additionalNote', null=True)),
                ('date', models.DateTimeField()),
                ('fee', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('totalAmount', models.DecimalField(db_column='totalAmount', decimal_places=2, default=0, max_digits=15)),
                ('actualServiceCharge', models.DecimalField(db_column='actualServiceCharge', decimal_places=2, default=0, max_digits=15)),
                ('remainingServiceCharge', models.DecimalField(db_column='remainingServiceCharge', decimal_places=2, default=0, max_digits=15)),
                ('remainingtotalAmount', models.DecimalField(db_column='remainingtotalAmount', decimal_places=2, default=0, max_digits=15)),
                ('totalMaterialsFee', models.DecimalField(db_column='totalMaterialsFee', decimal_places=2, default=0, max_digits=15)),
                ('isCommitmentFeePaid', models.BooleanField(blank=True, db_column='isCommitmentFeePaid', null=True)),
                ('agentEnroute', models.BooleanField(blank=True, db_column='agentEnroute', null=True)),
                ('agentArrived', models.BooleanField(blank=True, db_column='agentArrived', null=True)),
                ('isAssessmentCompleted', models.BooleanField(blank=True, db_column='isAssessmentCompleted', null=True)),
                ('paymentCompleted', models.BooleanField(blank=True, db_column='paymentCompleted', null=True)),
                ('jobStartedAt', models.DateTimeField(blank=True, db_column='jobStartedAt', null=True)),
                ('jobCompletedAt', models.DateTimeField(blank=True, db_column='jobCompletedAt', null=True)),
                ('isAgentJobComplete', models.BooleanField(blank=True, db_column='isAgentJobComplete', null=True)),
                ('customerCompletionConfirmation', models.BooleanField(blank=True, db_column='customerCompletionConfirmation', null=True)),
                ('isAgentReview', models.BooleanField(db_column='isAgentReview', default=False)),
                ('isCustomerReview', models.BooleanField(db_column='isCustomerReview', default=False)),
                ('paymentJson', models.TextField(blank=True, db_column='paymentJson', null=True)),
                ('agentEnrouteAt', models.DateTimeField(blank=True, db_column='agentEnrouteAt', null=True)),
                ('agentArrivedAt', models.DateTimeField(blank=True, db_column='agentArrivedAt', null=True)),
                ('address', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.useraddress')),
                ('agent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='workorders_agent_set', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'WorkOrders',
            },
        ),
        migrations.CreateModel(
            name='WorkOrderService',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'WorkOrderServices',
            },
        ),
        migrations.CreateModel(
            name='WorkOrderStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(blank=True, max_length=50, null=True)),
                ('currentStatus', models.BooleanField(db_column='currentStatus', default=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('workOrder', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.workorder')),
            ],
            options={
                'db_table': 'WorkOrderStatuses',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='WorkOrderServiceCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField(blank=True, null=True)),
                ('chargeType', models.TextField(blank=True, db_column='chargeType', null=True)),
                ('commission', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('serviceCharge', models.DecimalField(db_column='serviceCharge', decimal_places=2, default=0, max_digits=15)),
                ('commitmentFee', models.DecimalField(db_column='commitmentFee', decimal_places=2, default=0, max_digits=15)),
                ('status', models.CharField(blank=True, max_length=100, null=True)),
                ('serviceId', models.ForeignKey(blank=True, db_column='serviceId', null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.workorderservice')),
            ],
            options={
                'db_table': 'WOServiceCategories',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='WorkOrderMaterial',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('item', models.UUIDField(blank=True, null=True)),
                ('quantity', models.IntegerField(default=1)),
                ('price', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('productName', models.TextField(blank=True, db_column='productName', null=True)),
                ('workOrder', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.workorder')),
            ],
            options={
                'db_table': 'WorkOrderMaterials',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.AddField(
            model_name='workorder',
            name='serviceSubCategory',
            field=models.ForeignKey(blank=True, db_column='serviceSubCategory', null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.workorderservicecategory'),
        ),
        migrations.CreateModel(
            name='WalletHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('type', models.CharField(blank=True, max_length=30, null=True)),
                ('requestJson', models.JSONField(blank=True, db_column='requestJSON', null=True)),
                ('transferCode', models.CharField(blank=True, db_column='transferCode', max_length=255, null=True)),
                ('isCompleted', models.BooleanField(db_column='isCompleted', default=False)),
                ('wallet', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.wallet')),
            ],
            options={
                'db_table': 'WalletHistories',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Verification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(blank=True, db_column='userName', max_length=255, null=True)),
                ('meansOfIdentificationId', models.IntegerField(blank=True, db_column='meansOfIdentificationId', null=True)),
                ('meansOfIdentificationName', models.CharField(blank=True, db_column='meansOfIdentificationName', max_length=255, null=True)),
                ('active', models.BooleanField(default=False)),
                ('type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.verificationtype')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='verifications', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'Verifications',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='TransactionLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('transactionRef', models.CharField(max_length=255, unique=True)),
                ('paymentRef', models.CharField(blank=True, db_column='paymentRef', max_length=255, null=True)),
                ('serviceDescription', models.TextField(blank=True, db_column='serviceDescription', null=True)),
                ('platform', models.CharField(blank=True, max_length=30, null=True)),
                ('requestJson', models.JSONField(blank=True, db_column='requestJSON', null=True)),
                ('responseJson', models.JSONField(blank=True, db_column='responseJSON', null=True)),
                ('amount', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('isPaid', models.BooleanField(default=False)),
                ('status', models.CharField(blank=True, max_length=30, null=True)),
                ('vendorStatus', models.CharField(blank=True, max_length=30, null=True)),
                ('callbackJson', models.JSONField(blank=True, db_column='callbackJSON', null=True)),
                ('verifyJson', models.JSONField(blank=True, db_column='verifyJSON', null=True)),
                ('webhookJson', models.JSONField(blank=True, db_column='webhookJSON', null=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('paymentType', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.paymenttype')),
                ('paymentVendor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.paymentvendor')),
                ('recipient', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='received_transactions', to=settings.AUTH_USER_MODEL)),
                ('service', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.workorderservice')),
            ],
            options={
                'db_table': 'TransactionLogs',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Survey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('responseTime', models.IntegerField(db_column='responseTime', default=0)),
                ('professionalism', models.IntegerField(default=0)),
                ('serviceQuality', models.IntegerField(db_column='serviceQuality', default=0)),
                ('review', models.TextField(blank=True, null=True)),
                ('rating', models.IntegerField(default=0)),
                ('workOrder', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.workorder')),
            ],
            options={
                'db_table': 'Surveys',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Purchase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.IntegerField(default=1)),
                ('amount', models.DecimalField(decimal_places=2, default=0, max_digits=12)),
                ('cart', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.cart')),
                ('product', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.product')),
            ],
            options={
                'db_table': 'Purchases',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('orderId', models.CharField(blank=True, db_column='orderId', max_length=255, null=True)),
                ('transactionRef', models.CharField(blank=True, db_column='transactionRef', max_length=255, null=True)),
                ('paymentRef', models.CharField(blank=True, db_column='paymentRef', max_length=255, null=True)),
                ('paymentJson', models.JSONField(blank=True, db_column='paymentJSON', null=True)),
                ('channel', models.CharField(blank=True, max_length=255, null=True)),
                ('paymentType', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.paymenttype')),
                ('paymentVendor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.paymentvendor')),
                ('transactionLog', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.transactionlog')),
            ],
            options={
                'db_table': 'Payments',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='NextOfKin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('address', models.CharField(blank=True, max_length=255, null=True)),
                ('relationship', models.CharField(max_length=30)),
                ('phoneNumber', models.CharField(blank=True, db_column='phoneNumber', max_length=11, null=True)),
                ('active', models.BooleanField(default=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='nextofkins', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'NextOfKins',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='MeterRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.IntegerField(default=1)),
                ('phone', models.CharField(blank=True, max_length=11, null=True)),
                ('account', models.CharField(blank=True, max_length=255, null=True)),
                ('address', models.TextField(blank=True, null=True)),
                ('disco', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.disco')),
            ],
            options={
                'db_table': 'MeterRequests',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.TextField()),
                ('type', models.CharField(max_length=30)),
                ('conversation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='messages', to='app.conversation')),
                ('sender', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='messages', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'Messages',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Expertise',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('active', models.BooleanField(blank=True, null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='expertises', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'Expertises',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Documentation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(blank=True, null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='documentations', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'Documentations',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reference', models.CharField(blank=True, max_length=255, null=True)),
                ('filename', models.CharField(blank=True, db_column='fileName', max_length=255, null=True)),
                ('type', models.CharField(blank=True, max_length=30, null=True)),
                ('workOrder', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.workorder')),
            ],
            options={
                'db_table': 'Documents',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
        migrations.CreateModel(
            name='Card',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('signature', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.CharField(blank=True, max_length=255, null=True)),
                ('authorization', models.JSONField(blank=True, null=True)),
                ('paymentVendor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.paymentvendor')),
            ],
            options={
                'db_table': 'Cards',
            },
            #bases=(models.Model, mojec_core.app.models.base.BaseModelAbstract),
        ),
    ]
