# WanPy: A Wannier Tight-Binding Model Based Numerical Package

## Requirements
- python>=3.11
- numpy
- scipy
- sympy
- pandas
- mpi4py
- h5py
- fortio
- hatch
- spglib>=2.3.0
- matplotlib (optional)
- phonopy (optional; required by findmsg)
- pymatgen (optional; required by wpyplotband)

## Installation
Create a Conda environment and install wanpy:
```bash
conda create -n wanpy numpy scipy pandas sympy h5py mpi4py fortio hatch spglib matplotlib
conda activate wanpy 
pip install wanpy 
````
Note for compatibility with srun, it is recommended to use MPICH:
```bash
conda install -c conda-forge mpi4py==3.1.4 mpich
```

create a symbolic link for wanpyProjects at `~/opt/wanpyProjects`:
```bash
wanpy-postinstall
````
(Optional) Configure Environment Variables
If you are installing wanpy on a personal computer, you may want to set environment variables for convenience:
```bash
export WANPY_ROOT_DIR="your_work_dir"  # Set a default working directory for WanPy  
export PYGUI="True"  # Enable GUI features if applicable  
```

## Get start
```bash
# show usage
wanpy -h

# collect Wannier TB data to a single .h5 file
wanpy htb

# Collect Wannier TB data to a single .h5 file
wanpy wannier

# Write _hr.dat and _r.dat (optional) from .h5 file
wanpy write_dat

# Twist the order of .amn (uudd or udud) 
wanpy twist_amn

# compare Wannier and VASP band structure. support HSE type calculation. 
wpyplotband

# check job status
statistic_cores ...
```

## Collect Wannier TB data

WanPy need to collect necessary Wannier TB data into a single `.h5` file as the input for further calculations. This can be done by: 

**Method 1 (recommended)**: from `wanpy wannier`, this will need `POSCAR .nnkp, .wout, .chk, .eig`, and `WAVECAR` if  `--spn`. The `nnkp` file can be obtained by: 

```bash
$ wannier90.x -pp wannier90.win 
```

To start collecting dat:

```bash
# start to collect Wannier TB data 
wanpy wannier [options]

# For detail of options, see
wanpy wannier -h

```



**Method 2**: from `wanpy htb`, this will need at least `POSCAR, .wout, _hr.dat `. The files `.nnkp`,  `_r.dat`, `_wsvec.dat`, and `_spin.dat` are optional. 

```bash
# start to collect Wannier TB data 
wanpy htb [options]

# For detail of options, see
wanpy htb -h

```



**Symmetric Wannier tight-binding models (SWTB)**

The SWTB can be obtained during collecting Wannier TB data. Set symmetry related parameters in `symmetry.in`, then start to get SWTB with an additional tag `--symmetry`

```bash
wanpy wannier --symmetry [options]
```

See [Comput. Phys. Commun. 270, 108153 (2022)](https://www.sciencedirect.com/science/article/abs/pii/S0010465521002654) [(arXiv:2012.08871)](https://arxiv.org/abs/2105.09504) for detail. 



**Important notice:**

- WanPy uses uudd order of Wannier orbitals for its internal calculations, which is the default setting when using v1.2 of `wannier_setup`. If a higher version vasp2wannier interface was used, one should utilize `wanpy twist_amn` to reorganize the .amn file into the uudd order and then redo the disentanglement. 

- `wannier_center_def` must be specified to excute  `wanpy wannier`. The available options are `poscar` and `ws`. By using `wannier_center_def = poscar`, the wannier centers will align with `POSCAR`. For `wannier_center_def = ws`, the wannier centers will be refined in range of `[-0.5, 0.5)`. For example, if `.amn` file is generated by VASP 5.4.4, set `wannier_center_def = poscar`. If `.amn` file is generated by VASP 6.4.3, set `wannier_center_def = ws`.

  

**Template input file for generating htb.h5:**

This template file can also be produced by executing `wanpy wannier --temp`: 

```bash
# Input file for building symmetric Wannier TB model

# Choose method, default is kspace
symmetric_method = rspace   # Options: {rspace, kspace}
rspace_use_ngridR = F       # use ngridR to resample the TB model, default is False

# Choose between manually setting symmops or automatically detecting symmops from magmoms
parse_symmetry = man        # Options: {man, auto}

# Choose how wannier centers are defined in calculating .amn
# Options: {poscar, ws}
#   poscar: the same as poscar. Use this if amn is generated by VASP 5.4.4 (see mlwf.F for details). 
#   ws: refined in range of [-0.5, 0.5). Use this if amn is generated by VASP 6.4.3 (see mlwf.F for details). 
wannier_center_def = poscar 

ngridR = 12 12 1            # in kspace method, use a slightly larger value than the original TB model 

# Parameters used when parse_symmetry = auto
symprec = 1e-5
&magmoms
0 0 1
0 0 -1
/

# Parameters used when parse_symmetry = man
&symmops
# TR  det  alpha  nx  ny  nz  taux  tauy  tauz
  0   1    0      0   0   1   0     0     0   # e
  0   1    180    0   0   1   0.5   0.5   0   # c2z
# Anti-unitary symmetry operations
  1   1    0      0   0   1   0.5   0.5   0   # T
  1   1    180    0   0   1   0     0     0   # Tc2z
/
```

