# MIT LICENSE
#
# Copyright 1997 - 2020 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from uhd_restpy.base import Base
from uhd_restpy.files import Files


class InterestedVlanList(Base):
    """Fabric-Path Interested Vlans
    The InterestedVlanList class encapsulates a required interestedVlanList resource which will be retrieved from the server every time the property is accessed.
    """

    __slots__ = ()
    _SDM_NAME = 'interestedVlanList'
    _SDM_ATT_MAP = {
        'Active': 'active',
        'Count': 'count',
        'DescriptiveName': 'descriptiveName',
        'IncludeInLSP': 'includeInLSP',
        'IncludeInMGroupPDU': 'includeInMGroupPDU',
        'M4BitEnabled': 'm4BitEnabled',
        'M6BitEnabled': 'm6BitEnabled',
        'Name': 'name',
        'Nickname': 'nickname',
        'NoOfSpanningTreeRoots': 'noOfSpanningTreeRoots',
        'StartSpanningTreeRootBridgeId': 'startSpanningTreeRootBridgeId',
        'StartVlanId': 'startVlanId',
        'VlanCount': 'vlanCount',
        'VlanIdIncr': 'vlanIdIncr',
    }

    def __init__(self, parent):
        super(InterestedVlanList, self).__init__(parent)

    @property
    def Active(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): Activate/Deactivate Configuration
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Active']))

    @property
    def Count(self):
        """
        Returns
        -------
        - number: Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.
        """
        return self._get_attribute(self._SDM_ATT_MAP['Count'])

    @property
    def DescriptiveName(self):
        """
        Returns
        -------
        - str: Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context
        """
        return self._get_attribute(self._SDM_ATT_MAP['DescriptiveName'])

    @property
    def IncludeInLSP(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): Include in LSP
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['IncludeInLSP']))

    @property
    def IncludeInMGroupPDU(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): Include in MGROUP-PDU
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['IncludeInMGroupPDU']))

    @property
    def M4BitEnabled(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): M4 Bit Enabled
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['M4BitEnabled']))

    @property
    def M6BitEnabled(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): M6 Bit Enabled
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['M6BitEnabled']))

    @property
    def Name(self):
        """
        Returns
        -------
        - str: Name of NGPF element, guaranteed to be unique in Scenario
        """
        return self._get_attribute(self._SDM_ATT_MAP['Name'])
    @Name.setter
    def Name(self, value):
        self._set_attribute(self._SDM_ATT_MAP['Name'], value)

    @property
    def Nickname(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): Nickname
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Nickname']))

    @property
    def NoOfSpanningTreeRoots(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): No. of Spanning Tree Roots
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['NoOfSpanningTreeRoots']))

    @property
    def StartSpanningTreeRootBridgeId(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): Start Spanning Tree Root Bridge ID
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['StartSpanningTreeRootBridgeId']))

    @property
    def StartVlanId(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): Start Vlan Id
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['StartVlanId']))

    @property
    def VlanCount(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): Vlan Count
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['VlanCount']))

    @property
    def VlanIdIncr(self):
        """
        Returns
        -------
        - obj(uhd_restpy.multivalue.Multivalue): Vlan Id Increment
        """
        from uhd_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['VlanIdIncr']))

    def update(self, Name=None):
        """Updates interestedVlanList resource on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args
        ----
        - Name (str): Name of NGPF element, guaranteed to be unique in Scenario

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._update(self._map_locals(self._SDM_ATT_MAP, locals()))

    def get_device_ids(self, PortNames=None, Active=None, IncludeInLSP=None, IncludeInMGroupPDU=None, M4BitEnabled=None, M6BitEnabled=None, Nickname=None, NoOfSpanningTreeRoots=None, StartSpanningTreeRootBridgeId=None, StartVlanId=None, VlanCount=None, VlanIdIncr=None):
        """Base class infrastructure that gets a list of interestedVlanList device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args
        ----
        - PortNames (str): optional regex of port names
        - Active (str): optional regex of active
        - IncludeInLSP (str): optional regex of includeInLSP
        - IncludeInMGroupPDU (str): optional regex of includeInMGroupPDU
        - M4BitEnabled (str): optional regex of m4BitEnabled
        - M6BitEnabled (str): optional regex of m6BitEnabled
        - Nickname (str): optional regex of nickname
        - NoOfSpanningTreeRoots (str): optional regex of noOfSpanningTreeRoots
        - StartSpanningTreeRootBridgeId (str): optional regex of startSpanningTreeRootBridgeId
        - StartVlanId (str): optional regex of startVlanId
        - VlanCount (str): optional regex of vlanCount
        - VlanIdIncr (str): optional regex of vlanIdIncr

        Returns
        -------
        - list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())
