# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ScimV2PatchOperation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ScimV2PatchOperation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'op': 'str',
            'path': 'str',
            'value': 'JsonNode'
        }

        self.attribute_map = {
            'op': 'op',
            'path': 'path',
            'value': 'value'
        }

        self._op = None
        self._path = None
        self._value = None

    @property
    def op(self):
        """
        Gets the op of this ScimV2PatchOperation.
        The PATCH operation to perform.

        :return: The op of this ScimV2PatchOperation.
        :rtype: str
        """
        return self._op

    @op.setter
    def op(self, op):
        """
        Sets the op of this ScimV2PatchOperation.
        The PATCH operation to perform.

        :param op: The op of this ScimV2PatchOperation.
        :type: str
        """
        allowed_values = ["add", "replace", "remove"]
        if op.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for op -> " + op
            self._op = "outdated_sdk_version"
        else:
            self._op = op

    @property
    def path(self):
        """
        Gets the path of this ScimV2PatchOperation.
        The attribute path that describes the target of the operation. Required for a \"remove\" operation.

        :return: The path of this ScimV2PatchOperation.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Sets the path of this ScimV2PatchOperation.
        The attribute path that describes the target of the operation. Required for a \"remove\" operation.

        :param path: The path of this ScimV2PatchOperation.
        :type: str
        """
        
        self._path = path

    @property
    def value(self):
        """
        Gets the value of this ScimV2PatchOperation.
        The value to set in the path.

        :return: The value of this ScimV2PatchOperation.
        :rtype: JsonNode
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ScimV2PatchOperation.
        The value to set in the path.

        :param value: The value of this ScimV2PatchOperation.
        :type: JsonNode
        """
        
        self._value = value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

