# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['reportseff']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.0,<8.0']

entry_points = \
{'console_scripts': ['reportseff = reportseff.console:main']}

setup_kwargs = {
    'name': 'reportseff',
    'version': '0.4.0',
    'description': 'Tablular seff output',
    'long_description': "[![Tests](https://github.com/troycomi/reportseff/workflows/Tests/badge.svg)](https://github.com/troycomi/reportseff/actions?workflow=Tests)\n[![codecov](https://codecov.io/gh/troycomi/reportseff/branch/main/graph/badge.svg)](https://codecov.io/gh/troycomi/reportseff)\n\n# reportseff\n\n> A python script for tabular display of slurm efficiency information\n\n## Usage\n### Installation\n`reportseff` runs on python >= 3.7.\nThe only external dependency is click (>= 7.0).\nCalling\n```\npip install git+https://github.com/troycomi/reportseff\n```\nwill create command line bindings and install click.\n\n### Sample Usage\n#### Single job\nCalling reportseff with a single jobid will provide equivalent information to\nseff for that job.  `reportseff 24371789` and `reportseff map_fastq_24371789`\nproduce the following output:\n<pre><b>\n      JobID      State          Elapsed   CPUEff   MemEff  </b>\n   24371789    COMPLETED       03:08:03   71.2%    45.7%\n</pre>\n\n#### Single array job\nProviding either the raw job id or the array job id will get efficiency\ninformation for a single element of the array job.  `reportseff 24220929_421`\nand `reportseff 24221219` generate:\n<pre><b>\n          JobID      State          Elapsed    CPUEff   MemEff  </b>\n   24220929_421    COMPLETED       00:09:34    99.0%    34.6%\n</pre>\n\n#### Array job group\nIf the base job id of an array is provided, all elements of the array will\nbe added to the output. `reportseff 24220929`\n<pre><b>\n          JobID      State          Elapsed    CPUEff   MemEff  </b>\n     24220929_1    COMPLETED       00:10:43    99.2%    33.4%\n    24220929_11    COMPLETED       00:10:10    99.2%    37.5%\n    24220929_21    COMPLETED       00:09:25    98.8%    36.1%\n    24220929_31    COMPLETED       00:09:19    98.9%    33.3%\n    24220929_41    COMPLETED       00:09:23    98.9%    33.3%\n    24220929_51    COMPLETED       00:08:02    98.5%    36.3%\n\t...\n   24220929_951    COMPLETED       00:25:12    99.5%    33.5%\n   24220929_961    COMPLETED       00:39:26    99.7%    34.1%\n   24220929_971    COMPLETED       00:24:11    99.5%    34.2%\n   24220929_981    COMPLETED       00:24:50    99.5%    44.3%\n   24220929_991    COMPLETED       00:13:05    98.7%    33.7%\n</pre>\n\n#### Glob expansion of slurm outputs\nBecause slurm output files can act as job id inputs, the following can\nget all seff information for a given job name:\n\n<pre>slurm_out  ❯❯❯ reportseff split_ubam_24\\*<b>\n                 JobID      State          Elapsed   CPUEff   MemEff  </b>\n   split_ubam_24342816    COMPLETED       23:30:32   99.9%    4.5%\n   split_ubam_24342914    COMPLETED       22:40:51   99.9%    4.6%\n   split_ubam_24393599    COMPLETED       23:43:36   99.4%    4.4%\n   split_ubam_24393655    COMPLETED       21:36:58   99.3%    4.5%\n   split_ubam_24418960     RUNNING        02:53:11    ---      ---\n   split_ubam_24419972     RUNNING        01:26:26    ---      ---\n</pre>\n\n#### No arguments\nWithout arguments, reportseff will try to find slurm output files in the\ncurrent directory.  Combine with `watch` to monitor job progress:\n`watch -cn 300 reportseff --modified-sort`\n<pre><b>\n                    JobID           State          Elapsed   CPUEff   MemEff  </b>\n      split_ubam_24418960          RUNNING        02:56:14    ---      ---\n   fastq_to_ubam_24419971          RUNNING        01:29:29    ---      ---\n      split_ubam_24419972          RUNNING        01:29:29    ---      ---\n   fastq_to_ubam_24393600         COMPLETED     1-02:00:47   58.3%    41.1%\n       map_fastq_24419330          RUNNING        02:14:53    ---      ---\n       map_fastq_24419323          RUNNING        02:15:24    ---      ---\n       map_fastq_24419324          RUNNING        02:15:24    ---      ---\n       map_fastq_24419322          RUNNING        02:15:24    ---      ---\n   mark_adapters_24418437         COMPLETED       01:29:23   99.8%    48.2%\n   mark_adapters_24418436         COMPLETED       01:29:03   99.9%    47.4%\n</pre>\n\n#### Filtering slurm output files\nOne useful application of reportseff is filtering a directory of slurm output\nfiles based on the state or time since running.  Additionally, if only the\njobid is specified as a format output, the filenames will be returned in a\npipe-friendly manner:\n<pre>old_runs   ❯❯❯ reportseff --since d=4 --state Timeout\n<b>\n                   JobID   State      Elapsed  CPUEff   MemEff </b>\n  call_variants_31550458  TIMEOUT    20:05:17  99.5%     0.0%\n  call_variants_31550474  TIMEOUT    20:05:17  99.6%     0.0%\n  call_variants_31550500  TIMEOUT    20:05:08  99.7%     0.0%\nold_runs   ❯❯❯ reportseff --since d=4 --state Timeout --format jobid\ncall_variants_31550458\ncall_variants_31550474\ncall_variants_31550500\n</pre>\nTo find all lines with `output:` in jobs which have timed out or failed\nin the last 4 days:\n```\nreportseff --since 'd=4' --state TO,F --format jobid | xargs grep output:\n```\n\n### Arguments\nJobs can be passed as arguments in the following ways:\n- Job ID such as 1234567.  If the id is part of an array job, only the element\nfor that ID will be displayed.  If the id is the base part of an array job,\nall elements in the array will be displayed.\n- Array Job ID such as 1234567\\_89.  Will display only the element specified.\n- Slurm output file.  Format must be BASE\\_%A\\_%a.  BASE is optional as is a\n'.out' suffix.  Unix glob expansions can also be used to filter which jobs\nare displayed.\n- From current directory.  If no argument is supplied, reportseff will attempt\nto find slurm output files in the current directory as described above.\n- Supplying a directory as a single argument will override the current\ndirectory to check for slurm outputs.\n\n### Options\n- --color/--no-color: Force color output or not.  By default, will force color\n  output.  With the no-color flag, click will strip color codes for everything\n  besides stdout.\n- --modified-sort: Instead of sorting by filename/jobid, sort by last\n  modification time of the slurm output file.\n- --debug: Write sacct result to stderr.\n- --user: Ignore job arguments and instead query sacct with provided user.\n  Returns all jobs from the last week.\n- --state: Output only jobs with states matching one of the provided options.\n  Accepts comma separated values of job codes (e.g. 'R') or full names\n  (e.g. RUNNING).  Case insensitive.\n- --format: Provide a comma separated list of columns to produce. Prefixing the\n  argument with `+` adds the specified values to the defaults.  Values can\n  be any valid column name to sacct and the custom efficiency values: TimeEff,\n  cpuEff, MemEff.  Can also optionally set alignment (<, ^, >) and maximum width.\n  Default is center-aligned with a width of the maximum column entry.  For\n  example, `--format 'jobid%>,state%10,memeff%<5'` produces 3 columns with:\n  - JobId aligned right, width set automatically\n  - State with width 10 (center aligned by default)\n  - MemEff aligned left, width 5\n- --since: Limit results to those occurring after the specified time.  Accepts\n  sacct formats and a comma separated list of key/value pairs.  To get jobs in\n  the last hour and a half, can pass `h=1,m=30`.\n\n## Contributions\nBug reports, pull requests, and any feedback are welcome!  Prior to submitting\na pull request, be sure any new features have been tested and all unit tests\nare passing.  In the cloned repo, the test environment can be setup with:\n```\nconda create -n reportseff-dev\nconda activate reportseff-dev\nconda install -y -c conda-forge click pytest pytest-cov pytest-mock pytest-flake8\npytest --flake8 --cov\n```\n\n## Acknowledgements\nThe code for calling sacct and parsing the returning information was taken\nfrom [Slurmee](https://github.com/PrincetonUniversity/slurmee).\n",
    'author': 'Troy Comi',
    'author_email': 'troycomi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/troycomi/reportseff',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
