VC-2 Conformance Testing Software
=================================

This repository contains software tools for checking the conformance of VC-2
video codec implementations to the [SMPTE ST 2042-1 (VC-2) family of
standards](https://ieeexplore.ieee.org/document/7967896).

Getting started
---------------

The VC-2 conformance software manual walks through the process of installing
and using these tools to test the conformance of a VC-2 codec implementation.
You can read the manual online using one of the links below:

* [**VC-2 conformance software manual (HTML version)**](https://bbc.github.io/vc2_conformance/)
* [**VC-2 conformance software manual (PDF version)**](https://bbc.github.io/vc2_conformance/vc2_conformance_manual.pdf)


See also
--------

This software builds on the following support libraries:

* [`vc2_data_tables`](https://github.com/bbc/vc2_data_tables): Data tables and
  constant definitions from the VC-2 standard.

* [`vc2_bit_widths`](https://github.com/bbc/vc2_bit_widths) Mathematical
  routines for computing near worst case signals for VC-2 codecs.

* [`vc2_conformance_data`](https://github.com/bbc/vc2_conformance_data): Data
  files (e.g. test pictures) used in the conformance testing process.

This software's test suite implements a formal verification processes to ensure
consistency with the VC-2 specification. This process uses code generated by
the [`vc2_pseudocode_parser`](https://github.com/bbc/vc2_pseudocode_parser)
package.


Developers
----------

The [developer's manual for this
software](https://bbc.github.io/vc2_conformance/developer_guide/index.html)
includes a detailed overview of the construction and design of this software,
including [instructions for setting up a development
installation](https://bbc.github.io/vc2_conformance/developer_guide/index.html).


License
-------

This software is distributed under the [GNU General Public License version
3](./LICENSE.txt), &copy; BBC 2021.
