"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.md5hash = void 0;
const helpers_internal_1 = require("aws-cdk-lib/core/lib/helpers-internal");
function md5hash(obj) {
    if (!obj || (typeof (obj) === 'object' && Object.keys(obj).length === 0)) {
        throw new Error('Cannot compute md5 hash for falsy object');
    }
    return (0, helpers_internal_1.md5hash)(JSON.stringify(obj));
}
exports.md5hash = md5hash;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGFzaC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImhhc2gudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNEVBQTJFO0FBRTNFLFNBQWdCLE9BQU8sQ0FBQyxHQUFRO0lBQzlCLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQyxPQUFNLENBQUMsR0FBRyxDQUFDLEtBQUssUUFBUSxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQyxFQUFFO1FBQ3ZFLE1BQU0sSUFBSSxLQUFLLENBQUMsMENBQTBDLENBQUMsQ0FBQztLQUM3RDtJQUNELE9BQU8sSUFBQSwwQkFBTyxFQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztBQUN0QyxDQUFDO0FBTEQsMEJBS0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBtZDVoYXNoIGFzIGNvcmVNZDUgfSBmcm9tICdhd3MtY2RrLWxpYi9jb3JlL2xpYi9oZWxwZXJzLWludGVybmFsJztcblxuZXhwb3J0IGZ1bmN0aW9uIG1kNWhhc2gob2JqOiBhbnkpOiBzdHJpbmcge1xuICBpZiAoIW9iaiB8fCAodHlwZW9mKG9iaikgPT09ICdvYmplY3QnICYmIE9iamVjdC5rZXlzKG9iaikubGVuZ3RoID09PSAwKSkge1xuICAgIHRocm93IG5ldyBFcnJvcignQ2Fubm90IGNvbXB1dGUgbWQ1IGhhc2ggZm9yIGZhbHN5IG9iamVjdCcpO1xuICB9XG4gIHJldHVybiBjb3JlTWQ1KEpTT04uc3RyaW5naWZ5KG9iaikpO1xufVxuIl19