from copy import deepcopy


class ServiceFixtureFactory(object):
    @classmethod
    def service_document(self):
        return deepcopy(SERVICE_DOC)


SERVICE_DOC = {
    "@context": "https://swordapp.github.io/swordv3/swordv3.jsonld",
    "@id": "http://example.com/service-document",
    "@type": "ServiceDocument",
    "dc:title": "Site Name",
    "dcterms:abstract": "Site Description",
    "root": "http://example.com/service-document",
    "acceptDeposits": True,
    "version": "http://purl.org/net/sword/3.0",
    "maxUploadSize": 16777216000,
    "maxByReferenceSize": 30000000000000000,
    "maxAssembledSize": 30000000000000,
    "maxSegments": 1000,
    "accept": ["*/*"],
    "acceptArchiveFormat": ["application/zip"],
    "acceptPackaging": ["*"],
    "acceptMetadata": ["http://purl.org/net/sword/3.0/types/Metadata"],
    "collectionPolicy": {
        "@id": "http://www.myorg.ac.uk/collectionpolicy",
        "description": "....",
    },
    "treatment": {"@id": "http://www.myorg.ac.uk/treatment", "description": "..."},
    "staging": "http://example.com/staging",
    "stagingMaxIdle": 3600,
    "byReferenceDeposit": True,
    "onBehalfOf": True,
    "digest": ["SHA-256", "SHA", "MD5"],
    "authentication": ["Basic", "OAuth", "Digest", "APIKey"],
    "services": [
        {
            "@id": "http://swordapp.org/deposit/43",
            "dc:title": "Deposit Service Name",
            "dcterms:abstract": "Deposit Service Description",
            "root": "http://example.com/service-document",
            "parent": "http://example.com/service-document",
            "acceptDeposits": True,
            "services": [],
        }
    ],
}
