from dissect.cstruct import cstruct

from dissect.eventlog.wevt import header_dev
from dissect.eventlog.wevt_object import wevt_object_def

definitions = cstruct()
definitions.load(header_dev + wevt_object_def)


def create_header(type, **kwargs):
    """Create any header type in definitions"""
    return getattr(definitions, type)(**kwargs)


def create_header_type(type, **kwargs):
    data_offset = kwargs.get("data_offset")
    if not data_offset:
        kwargs.pop("data_offset", None)

    header_type = create_header(type, **kwargs)
    header_type.data_offset = kwargs.get("data_offset", len(header_type))
    return header_type.dumps()


def create_data_item(data: str):
    data_length = len(data) * 2
    padding = 8 - (data_length % 8)
    size = data_length + padding + 4  # It's 8 byte aligned
    const_data_item = create_header("DATA_ITEM", size=size, name=data + "\x00" * padding)
    return const_data_item.dumps()


CHAN_HEADER = (
    b"\x43\x48\x41\x4E\x30\x01\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00"
    b"\xE4\x03\x00\x00\x10\x00\x00\x00\x02\x00\x00\x90\x00\x00\x00\x00"
    b"\x34\x04\x00\x00\x11\x00\x00\x00\x03\x00\x00\x90\x00\x00\x00\x00"
    b"\x80\x04\x00\x00\x12\x00\x00\x00\x04\x00\x00\x90"
)


CHAN_DATA = (
    b"\x50\x00\x00\x00"
    b"\x4D\x00\x69\x00\x63\x00\x72\x00\x6F\x00\x73\x00\x6F\x00\x66\x00"
    b"\x74\x00\x2D\x00\x57\x00\x69\x00\x6E\x00\x64\x00\x6F\x00\x77\x00"
    b"\x73\x00\x2D\x00\x4B\x00\x65\x00\x72\x00\x6E\x00\x65\x00\x6C\x00"
    b"\x2D\x00\x57\x00\x44\x00\x49\x00\x2F\x00\x41\x00\x6E\x00\x61\x00"
    b"\x6C\x00\x79\x00\x74\x00\x69\x00\x63\x00\x00\x00\x4C\x00\x00\x00"
    b"\x4D\x00\x69\x00\x63\x00\x72\x00\x6F\x00\x73\x00\x6F\x00\x66\x00"
    b"\x74\x00\x2D\x00\x57\x00\x69\x00\x6E\x00\x64\x00\x6F\x00\x77\x00"
    b"\x73\x00\x2D\x00\x4B\x00\x65\x00\x72\x00\x6E\x00\x65\x00\x6C\x00"
    b"\x2D\x00\x57\x00\x44\x00\x49\x00\x2F\x00\x44\x00\x65\x00\x62\x00"
    b"\x75\x00\x67\x00\x00\x00\x00\x00\x58\x00\x00\x00\x4D\x00\x69\x00"
    b"\x63\x00\x72\x00\x6F\x00\x73\x00\x6F\x00\x66\x00\x74\x00\x2D\x00"
    b"\x57\x00\x69\x00\x6E\x00\x64\x00\x6F\x00\x77\x00\x73\x00\x2D\x00"
    b"\x4B\x00\x65\x00\x72\x00\x6E\x00\x65\x00\x6C\x00\x2D\x00\x57\x00"
    b"\x44\x00\x49\x00\x2F\x00\x4F\x00\x70\x00\x65\x00\x72\x00\x61\x00"
    b"\x74\x00\x69\x00\x6F\x00\x6E\x00\x61\x00\x6C\x00\x00\x00\x00\x00"
)


TTBL_HEADER = b"\x54\x54\x42\x4C\xF8\x13\x00\x00\x0a\x00\x00\x00"


TEMP_HEADER = (
    b"\x54\x45\x4d\x50\x2c\x01\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00"
    b"\x58\x0f\x00\x00\x01\x00\x00\x00\xda\x88\x36\x4d\x18\x19\x68\x59"
    b"\xc9\xd8\x46\x97\xe3\x90\x8d\xbf\x0f\x01\x01\x00\x01\xff\xff\xa0"
    b"\x00\x00\x00\x44\x82\x09\x00\x45\x00\x76\x00\x65\x00\x6e\x00\x74"
    b"\x00\x44\x00\x61\x00\x74\x00\x61\x00\x00\x00\x02\x41\xff\xff\x3f"
    b"\x00\x00\x00\x8a\x6f\x04\x00\x44\x00\x61\x00\x74\x00\x61\x00\x00"
    b"\x00\x27\x00\x00\x00\x06\x4b\x95\x04\x00\x4e\x00\x61\x00\x6d\x00"
    b"\x65\x00\x00\x00\x05\x01\x0a\x00\x50\x00\x72\x00\x6f\x00\x76\x00"
    b"\x69\x00\x64\x00\x65\x00\x72\x00\x49\x00\x44\x00\x02\x0d\x00\x00"
    b"\x0f\x04\x41\xff\xff\x39\x00\x00\x00\x8a\x6f\x04\x00\x44\x00\x61"
    b"\x00\x74\x00\x61\x00\x00\x00\x21\x00\x00\x00\x06\x4b\x95\x04\x00"
    b"\x4e\x00\x61\x00\x6d\x00\x65\x00\x00\x00\x05\x01\x07\x00\x45\x00"
    b"\x76\x00\x65\x00\x6e\x00\x74\x00\x49\x00\x44\x00\x02\x0d\x01\x00"
    b"\x06\x04\x04\x00\x00\x00\x00\x00\x0f\x0e\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x80\x0f\x00\x00\x00\x00\x00\x00\x06\x06\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x9c\x0f\x00\x00\x1c\x00\x00\x00"
    b"\x50\x00\x72\x00\x6f\x00\x76\x00\x69\x00\x64\x00\x65\x00\x72\x00"
    b"\x49\x00\x44\x00\x00\x00\x00\x00\x14\x00\x00\x00\x45\x00\x76\x00"
    b"\x65\x00\x6e\x00\x74\x00\x49\x00\x44\x00\x00\x00"
)
