# Generated by Django 2.2.5 on 2019-09-23 02:33

import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='ArchiveSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_time', models.DateTimeField(auto_now_add=True)),
                ('schedule_time', models.DateTimeField()),
                ('run_time', models.DateTimeField(blank=True, null=True)),
                ('success', models.BooleanField(null=True)),
                ('next_duration', models.DurationField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HouseKeepSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_time', models.DateTimeField(auto_now_add=True)),
                ('schedule_time', models.DateTimeField()),
                ('run_time', models.DateTimeField(blank=True, null=True)),
                ('success', models.BooleanField(null=True)),
                ('next_duration', models.DurationField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HouseKeepTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_time', models.DateTimeField(auto_now_add=True)),
                ('update_time', models.DateTimeField(auto_now=True)),
                ('task_name', models.CharField(blank=True, max_length=50)),
                ('date_field', models.CharField(default='add_time', max_length=50)),
                ('keep_day_count', models.PositiveIntegerField(default=30)),
                ('keep_null', models.BooleanField(default=False)),
                ('enabled', models.BooleanField(default=True)),
                ('batch_size', models.PositiveIntegerField(default=10000)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
        ),
        migrations.CreateModel(
            name='HouseKeepRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_time', models.DateTimeField(auto_now_add=True)),
                ('success', models.BooleanField(null=True)),
                ('remarks', django.contrib.postgres.fields.ArrayField(base_field=models.TextField(), default=list, size=None)),
                ('task', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_ops.HouseKeepTask')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ArchiveTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_time', models.DateTimeField(auto_now_add=True)),
                ('update_time', models.DateTimeField(auto_now=True)),
                ('task_name', models.CharField(blank=True, max_length=50)),
                ('date_field', models.CharField(default='add_time', max_length=50)),
                ('extra_fields', django.contrib.postgres.fields.jsonb.JSONField(blank=True, help_text='["user__username", "user__profile__ref_user_id"]')),
                ('exclude_fields', django.contrib.postgres.fields.jsonb.JSONField(blank=True, help_text='["play_type_name", "play_radio_name", "try_count"]')),
                ('select_related', django.contrib.postgres.fields.jsonb.JSONField(blank=True, help_text='["user", "user__profile"]')),
                ('keep_day_count', models.PositiveIntegerField(default=30, help_text='value < 30 will be ignored!')),
                ('enabled', models.BooleanField(default=True)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
        ),
        migrations.CreateModel(
            name='ArchiveRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_time', models.DateTimeField(auto_now_add=True)),
                ('success', models.BooleanField(null=True)),
                ('remarks', django.contrib.postgres.fields.ArrayField(base_field=models.TextField(), default=list, size=None)),
                ('task', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_ops.ArchiveTask')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
