# Stubs for transactions (Python 3)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.

from typing import Any, Optional, Union, Text, Tuple, TypeVar, List, Dict, Type

from pynamodb.expressions.condition import Condition
from pynamodb.models import _ModelFuture

from inpynamodb.connection import AsyncConnection
from inpynamodb.models import Model


KeyType = Union[Text, bytes, float, int, Tuple]
ModelType = TypeVar('ModelType', bound=Model)


class Transaction:
    _connection: AsyncConnection
    _return_consumed_capacity: Optional[Any]

    def __init__(self, connection: AsyncConnection, return_consumed_capacity: Optional[Any] = ...) -> None: ...
    async def __aenter__(self) -> Transaction: ...
    async def __aexit__(self, exc_type, exc_val, exc_tb) -> Any: ...
    async def _commit(self) -> Any: ...

class TransactGet(Transaction):
    _get_items: List[Dict]
    _futures = List[_ModelFuture]
    _results: List[Dict]

    def _update_futures(self) -> None: ...
    async def get(self, model_cls: Type[ModelType], hash_key: KeyType, range_key: Optional[KeyType] = ...) -> _ModelFuture: ...


class TransactWrite(Transaction):
    _condition_check_items: List[Dict]
    _delete_items: List[Dict]
    _put_items: List[Dict]
    _update_items: List[Dict]
    _client_request_token: Optional[str]
    _return_item_collection_metrics: Optional[Any]

    def __init__(self, connection: AsyncConnection, return_consumed_capacity: Optional[Any] = ..., client_request_token: Optional[Text] = ..., return_item_collection_metrics: Optional[Text] = ...) -> None: ...
    async def condition_check(self, model_cls: Type[ModelType], hash_key: KeyType, range_key: Optional[KeyType] = ..., condition: Condition = ...) -> None: ...
    async def delete(self, model: ModelType, condition: Optional[Condition] = ...) -> None: ...
    async def save(self, model: ModelType, condition: Optional[Condition] = ..., return_values: Optional[Any] = ...) -> None: ...
    async def update(self, model: ModelType, actions: List[Any], condition: Optional[Condition] = ..., return_values: Optional[Any] = ...) -> None: ...
