# Stubs for models (Python 3)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.
from pynamodb.exceptions import DoesNotExist as DoesNotExist
from pynamodb.expressions.condition import Condition

from pynamodb.models import MetaModel, Model as PynamoDBModel
from typing import Any, Dict, Optional, Text, TypeVar, Union, Tuple, Type, Iterable, Sequence, Iterator, Generic, List

from inpynamodb.connection import TableConnection
from inpynamodb.pagination import ResultIterator

log: Any

_T = TypeVar('_T', bound='Model')
KeyType = Union[Text, bytes, float, int, Tuple]


class ModelContextManager(Generic[_T]):
    model: Type[_T]
    auto_commit: bool
    max_operations: int
    pending_operations: List[Dict[Text, Any]]
    def __init__(self, model: Type[_T], auto_commit: bool = ...) -> None: ...
    async def __aenter__(self) -> ModelContextManager[_T]: ...


class BatchWrite(Generic[_T], ModelContextManager[_T]):
    async def save(self, put_item: _T) -> None: ...
    async def delete(self, del_item: _T) -> None: ...
    async def __aenter__(self) -> BatchWrite[_T]: ...
    async def __aexit__(self, exc_type, exc_val, exc_tb) -> None: ...
    pending_operations: Any
    async def commit(self) -> None: ...


class Model(PynamoDBModel, metaclass=MetaModel):
    DoesNotExist = DoesNotExist
    attribute_values: Dict[Text, Any]
    _hash_keyname: Optional[str]
    _range_keyname: Optional[str]
    _connection: Optional[TableConnection]

    def __init__(self, hash_key: Optional[Any] = ..., range_key: Optional[Any] = ..., _user_instantiated: bool = ..., **attributes: Any) -> None: ...
    @classmethod
    async def batch_get(cls: Type[_T], items: Iterable[Union[KeyType, Iterable[KeyType]]], consistent_read: Optional[bool] = ..., attributes_to_get: Optional[Sequence[Text]] = ...) -> Iterator[_T]: ...
    @classmethod
    def batch_write(cls: Type[_T], auto_commit: bool = ...) -> BatchWrite[_T]: ...
    async def delete(self, condition: Optional[Any] = ...) -> Any: ...
    async def update(self, actions: List[Any], condition: Optional[Condition] = ...) -> Any: ...
    async def save(self, condition: Optional[Condition] = ...) -> Dict[str, Any]: ...
    async def refresh(self, consistent_read: bool = ...): ...
    @classmethod
    async def get(cls: Type[_T], hash_key: KeyType, range_key: Optional[KeyType] = ..., consistent_read: bool = ..., attributes_to_get: Optional[Any] = ...) -> _T: ...
    @classmethod
    async def count(
        cls: Type[_T],
        hash_key: Optional[KeyType] = ...,
        range_key_condition: Optional[Condition] = ...,
        filter_condition: Optional[Condition] = ...,
        consistent_read: bool = ...,
        index_name: Optional[Text] = ...,
        limit: Optional[int] = ...,
        rate_limit: Optional[float] = ...,
    ) -> int: ...
    @classmethod
    async def query(
        cls: Type[_T],
        hash_key: KeyType,
        range_key_condition: Optional[Condition] = ...,
        filter_condition: Optional[Condition] = ...,
        consistent_read: bool = ...,
        index_name: Optional[Text] = ...,
        scan_index_forward: Optional[Any] = ...,
        limit: Optional[int] = ...,
        last_evaluated_key: Optional[Dict[Text, Dict[Text, Any]]] = ...,
        attributes_to_get: Optional[Iterable[Text]] = ...,
        page_size: Optional[int] = ...,
        rate_limit: Optional[float] = ...,
    ) -> ResultIterator[_T]: ...

    @classmethod
    async def scan(
        cls: Type[_T],
        filter_condition: Optional[Condition] = ...,
        segment: Optional[int] = ...,
        total_segments: Optional[int] = ...,
        limit: Optional[int] = ...,
        last_evaluated_key: Optional[Dict[str, Dict[str, Any]]] = ...,
        page_size: Optional[int] = ...,
        consistent_read: Optional[bool] = ...,
        index_name: Optional[str] = ...,
        rate_limit: Optional[float] = ...,
    ) -> ResultIterator[_T]: ...
    @classmethod
    async def exists(cls: Type[_T]) -> bool: ...
    @classmethod
    async def delete_table(cls): ...
    @classmethod
    async def describe_table(cls): ...
    @classmethod
    async def create_table(
        cls: Type[_T],
        wait: bool = ...,
        read_capacity_units: Optional[Any] = ...,
        write_capacity_units: Optional[Any] = ...,
        billing_mode: Optional[Any] = ...,
        ignore_update_ttl_errors: bool = ...
    ): ...
    @classmethod
    async def update_ttl(cls, ignore_update_ttl_errors: bool): ...
    @classmethod
    async def dumps(cls): ...
    @classmethod
    async def dump(cls, filename): ...
    @classmethod
    async def loads(cls, data): ...
    @classmethod
    async def load(cls, filename): ...
    @classmethod
    async def _get_connection(cls) -> TableConnection: ...
