CREATE TABLE IF NOT EXISTS `fs_tns_spectra` (
  `primaryId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'An internal counter',
  `TNSId` varchar(45) NOT NULL,
  `TNSuser` varchar(45) DEFAULT NULL,
  `dateCreated` datetime DEFAULT CURRENT_TIMESTAMP,
  `exptime` double DEFAULT NULL,
  `obsdate` datetime DEFAULT NULL,
  `reportAddedDate` datetime DEFAULT NULL,
  `specType` varchar(100) DEFAULT NULL,
  `survey` varchar(100) DEFAULT NULL,
  `telescope` varchar(100) DEFAULT NULL,
  `transRedshift` double DEFAULT NULL,
  `updated` tinyint(4) DEFAULT '0',
  `dateLastModified` datetime DEFAULT NULL,
  `remarks` VARCHAR(800) NULL DEFAULT NULL,
  `sourceComment` VARCHAR(800) NULL DEFAULT NULL,
  PRIMARY KEY (`primaryId`),
  UNIQUE KEY `u_tnsid_survey_obsdate` (`TNSId`,`survey`,`obsdate`),
  UNIQUE KEY `u_id_user_obsdate` (`TNSId`,`TNSuser`,`obsdate`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=latin1;
            
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020aczg" ,"saurabh" ,null ,"2020-12-20 11:15:22" ,"2020-12-20 17:56:36" ,"SN Ia" ,"SIRAH" ,"Lick-3m_KAST" ,"0.025", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `TNSuser`="saurabh", `exptime`=null, `obsdate`="2020-12-20 11:15:22", `reportAddedDate`="2020-12-20 17:56:36", `specType`="SN Ia", `survey`="SIRAH", `telescope`="Lick-3m_KAST", `transRedshift`="0.025" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acsn" ,"lgalbany" ,"1200" ,"2020-12-18 15:12:51" ,"2020-12-18 16:41:47" ,"SN Ia" ,null ,"CMO-2.5m_TDS" ,"0.06", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsn", `TNSuser`="lgalbany", `exptime`="1200", `obsdate`="2020-12-18 15:12:51", `reportAddedDate`="2020-12-18 16:41:47", `specType`="SN Ia", `survey`=null, `telescope`="CMO-2.5m_TDS", `transRedshift`="0.06" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acpc" ,"linatoma" ,"2700" ,"2020-12-16 22:02:00" ,"2020-12-17 00:16:40" ,"SN Ia" ,"Padova-Asiago" ,"Ekar_AFOSC" ,"0.051371", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpc", `TNSuser`="linatoma", `exptime`="2700", `obsdate`="2020-12-16 22:02:00", `reportAddedDate`="2020-12-17 00:16:40", `specType`="SN Ia", `survey`="Padova-Asiago", `telescope`="Ekar_AFOSC", `transRedshift`="0.051371" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acpb" ,"ZTF_Bot1" ,"2700" ,"2020-12-17 02:50:01" ,"2020-12-20 16:02:08" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.0388224", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2020-12-17 02:50:01", `reportAddedDate`="2020-12-20 16:02:08", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.0388224" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acpb" ,"ZTF_Bot1" ,"2700" ,"2020-12-17 02:50:01" ,"2020-12-20 16:02:08" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.0388224", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2020-12-17 02:50:01", `reportAddedDate`="2020-12-20 16:02:08", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.0388224" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020aceg" ,"ZTF_Bot1" ,"2700" ,"2020-12-18 11:10:03" ,"2020-12-18 18:14:22" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.06", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2020-12-18 11:10:03", `reportAddedDate`="2020-12-18 18:14:22", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.06" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acef" ,"ePESSTOplus_Bot1" ,"900" ,"2020-12-16 07:58:23" ,"2020-12-16 15:15:04" ,"SN Ia-91T-like" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.065", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `TNSuser`="ePESSTOplus_Bot1", `exptime`="900", `obsdate`="2020-12-16 07:58:23", `reportAddedDate`="2020-12-16 15:15:04", `specType`="SN Ia-91T-like", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.065" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020aced" ,"ZTF_Bot1" ,"2700" ,"2020-12-16 07:19:26" ,"2020-12-20 09:42:07" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.067", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2020-12-16 07:19:26", `reportAddedDate`="2020-12-20 09:42:07", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.067" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acbm" ,"ePESSTOplus_Bot1" ,"300" ,"2020-12-15 03:27:54" ,"2020-12-15 15:59:13" ,"SN II" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.021", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `TNSuser`="ePESSTOplus_Bot1", `exptime`="300", `obsdate`="2020-12-15 03:27:54", `reportAddedDate`="2020-12-15 15:59:13", `specType`="SN II", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.021" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acbc" ,"UCSCTr_Bot1" ,"1200" ,"2020-12-11 00:00:00" ,"2020-12-12 01:17:42" ,"SN Ia" ,"UCSC" ,"Keck1_LRIS" ,"0.13", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbc", `TNSuser`="UCSCTr_Bot1", `exptime`="1200", `obsdate`="2020-12-11 00:00:00", `reportAddedDate`="2020-12-12 01:17:42", `specType`="SN Ia", `survey`="UCSC", `telescope`="Keck1_LRIS", `transRedshift`="0.13" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acat" ,"ePESSTOplus_Bot1" ,"1800" ,"2020-12-10 07:21:47" ,"2020-12-10 12:41:27" ,"SN IIb" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.0079", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `TNSuser`="ePESSTOplus_Bot1", `exptime`="1800", `obsdate`="2020-12-10 07:21:47", `reportAddedDate`="2020-12-10 12:41:27", `specType`="SN IIb", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.0079" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020abpt" ,"rcartier" ,null ,"2020-12-07 00:00:00" ,"2020-12-09 11:27:07" ,"SN Ia" ,null ,"Magellan-Baade_IMACS" ,"0.139", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpt", `TNSuser`="rcartier", `exptime`=null, `obsdate`="2020-12-07 00:00:00", `reportAddedDate`="2020-12-09 11:27:07", `specType`="SN Ia", `survey`=null, `telescope`="Magellan-Baade_IMACS", `transRedshift`="0.139" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020abmp" ,"rcartier" ,null ,"2020-12-07 00:00:00" ,"2020-12-09 11:29:24" ,"SN Ic" ,null ,"Magellan-Baade_IMACS" ,"0.058", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `TNSuser`="rcartier", `exptime`=null, `obsdate`="2020-12-07 00:00:00", `reportAddedDate`="2020-12-09 11:29:24", `specType`="SN Ic", `survey`=null, `telescope`="Magellan-Baade_IMACS", `transRedshift`="0.058" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020aauc" ,"ZTF_Bot1" ,"5700" ,"2020-12-14 06:58:10" ,"2020-12-18 15:49:18" ,"SN Ic" ,"ZTF" ,"Lick-3m_KAST" ,"0.03339", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `TNSuser`="ZTF_Bot1", `exptime`="5700", `obsdate`="2020-12-14 06:58:10", `reportAddedDate`="2020-12-18 15:49:18", `specType`="SN Ic", `survey`="ZTF", `telescope`="Lick-3m_KAST", `transRedshift`="0.03339" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020zpi" ,"ePESSTOplus_Bot1" ,"1500" ,"2020-11-17 05:31:34" ,"2020-11-17 16:51:15" ,"SN Ia" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.04", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `TNSuser`="ePESSTOplus_Bot1", `exptime`="1500", `obsdate`="2020-11-17 05:31:34", `reportAddedDate`="2020-11-17 16:51:15", `specType`="SN Ia", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.04" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020zka" ,"ePESSTOplus_Bot1" ,"900" ,"2020-11-22 08:48:49" ,"2020-11-22 17:37:44" ,"SN Ia" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.095", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `TNSuser`="ePESSTOplus_Bot1", `exptime`="900", `obsdate`="2020-11-22 08:48:49", `reportAddedDate`="2020-11-22 17:37:44", `specType`="SN Ia", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.095" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020yzs" ,"jhinkle" ,"2420" ,"2020-11-08 07:24:14" ,"2020-11-08 08:50:44" ,"SN Ia" ,"SCAT" ,"UH88_SNIFS" ,"0.0672", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yzs", `TNSuser`="jhinkle", `exptime`="2420", `obsdate`="2020-11-08 07:24:14", `reportAddedDate`="2020-11-08 08:50:44", `specType`="SN Ia", `survey`="SCAT", `telescope`="UH88_SNIFS", `transRedshift`="0.0672" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020yyk" ,"ePESSTOplus_Bot1" ,"1499" ,"2020-11-06 01:52:26" ,"2020-11-06 22:04:27" ,"SN Ia-91T-like" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.08", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `TNSuser`="ePESSTOplus_Bot1", `exptime`="1499", `obsdate`="2020-11-06 01:52:26", `reportAddedDate`="2020-11-06 22:04:27", `specType`="SN Ia-91T-like", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.08" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020ypm" ,"REFITT_BOT" ,"600" ,"2020-11-09 03:34:56" ,"2020-11-16 21:29:09" ,"SN Ia" ,"REFITT" ,"SOAR_Goodman" ,"0.135", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ypm", `TNSuser`="REFITT_BOT", `exptime`="600", `obsdate`="2020-11-09 03:34:56", `reportAddedDate`="2020-11-16 21:29:09", `specType`="SN Ia", `survey`="REFITT", `telescope`="SOAR_Goodman", `transRedshift`="0.135" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020yhy" ,"LinYan" ,null ,"2020-11-18 00:00:00" ,"2020-12-02 05:05:24" ,"SN IIn" ,"ZTF" ,"P200_DBSP" ,"0.106", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhy", `TNSuser`="LinYan", `exptime`=null, `obsdate`="2020-11-18 00:00:00", `reportAddedDate`="2020-12-02 05:05:24", `specType`="SN IIn", `survey`="ZTF", `telescope`="P200_DBSP", `transRedshift`="0.106" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020xyk" ,"ePESSTOplus_Bot1" ,"900" ,"2020-10-25 03:15:03" ,"2020-10-25 18:42:26" ,"SN II" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.0187", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `TNSuser`="ePESSTOplus_Bot1", `exptime`="900", `obsdate`="2020-10-25 03:15:03", `reportAddedDate`="2020-10-25 18:42:26", `specType`="SN II", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.0187" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020xyk" ,"ePESSTOplus_Bot1" ,"2250" ,"2020-10-23 05:21:20" ,"2020-10-25 18:42:26" ,"SN II" ,"ZTF" ,"P60_SEDM" ,"0.0187", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `TNSuser`="ePESSTOplus_Bot1", `exptime`="2250", `obsdate`="2020-10-23 05:21:20", `reportAddedDate`="2020-10-25 18:42:26", `specType`="SN II", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.0187" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020xyk" ,"ePESSTOplus_Bot1" ,"1800" ,"2020-10-23 07:41:05" ,"2020-10-25 18:42:26" ,"SN II" ,"SCAT" ,"UH88_SNIFS" ,"0.0187", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `TNSuser`="ePESSTOplus_Bot1", `exptime`="1800", `obsdate`="2020-10-23 07:41:05", `reportAddedDate`="2020-10-25 18:42:26", `specType`="SN II", `survey`="SCAT", `telescope`="UH88_SNIFS", `transRedshift`="0.0187" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020wie" ,"ZTF_Bot1" ,"2250" ,"2020-10-16 09:06:59" ,"2020-10-17 22:14:19" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.07", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `TNSuser`="ZTF_Bot1", `exptime`="2250", `obsdate`="2020-10-16 09:06:59", `reportAddedDate`="2020-10-17 22:14:19", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.07" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020wie" ,"ZTF_Bot1" ,"2100" ,"2020-10-15 14:03:50" ,"2020-10-17 22:14:19" ,"SN Ia" ,"SCAT" ,"UH88_SNIFS" ,"0.07", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `TNSuser`="ZTF_Bot1", `exptime`="2100", `obsdate`="2020-10-15 14:03:50", `reportAddedDate`="2020-10-17 22:14:19", `specType`="SN Ia", `survey`="SCAT", `telescope`="UH88_SNIFS", `transRedshift`="0.07" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020wcj" ,"ePESSTOplus_Bot1" ,"599" ,"2020-10-25 06:30:06" ,"2020-10-25 18:42:26" ,"SN Ia" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.0237", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `TNSuser`="ePESSTOplus_Bot1", `exptime`="599", `obsdate`="2020-10-25 06:30:06", `reportAddedDate`="2020-10-25 18:42:26", `specType`="SN Ia", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.0237" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020wcj" ,"ePESSTOplus_Bot1" ,"1500" ,"2020-10-17 00:59:20" ,"2020-10-25 18:42:26" ,"SN Ia" ,null ,"LT_SPRAT" ,"0.0237", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `TNSuser`="ePESSTOplus_Bot1", `exptime`="1500", `obsdate`="2020-10-17 00:59:20", `reportAddedDate`="2020-10-25 18:42:26", `specType`="SN Ia", `survey`=null, `telescope`="LT_SPRAT", `transRedshift`="0.0237" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020wcj" ,"ePESSTOplus_Bot1" ,"1800" ,"2020-10-16 04:59:13" ,"2020-10-25 18:42:26" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.0237", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `TNSuser`="ePESSTOplus_Bot1", `exptime`="1800", `obsdate`="2020-10-16 04:59:13", `reportAddedDate`="2020-10-25 18:42:26", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.0237" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020uxz" ,"etienne17" ,"7200" ,"2020-11-22 00:00:00" ,"2020-11-24 15:59:28" ,"SN Ia" ,null ,"Other_Other" ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `TNSuser`="etienne17", `exptime`="7200", `obsdate`="2020-11-22 00:00:00", `reportAddedDate`="2020-11-24 15:59:28", `specType`="SN Ia", `survey`=null, `telescope`="Other_Other", `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020uxz" ,"etienne17" ,"3000" ,"2020-10-18 23:30:00" ,"2020-11-24 15:59:28" ,"SN Ia" ,null ,"Other_Other" ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `TNSuser`="etienne17", `exptime`="3000", `obsdate`="2020-10-18 23:30:00", `reportAddedDate`="2020-11-24 15:59:28", `specType`="SN Ia", `survey`=null, `telescope`="Other_Other", `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020uxz" ,"etienne17" ,"1800" ,"2020-10-05 16:44:03" ,"2020-11-24 15:59:28" ,"SN Ia" ,"Global SN Project" ,"FTS_FLOYDS-S" ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `TNSuser`="etienne17", `exptime`="1800", `obsdate`="2020-10-05 16:44:03", `reportAddedDate`="2020-11-24 15:59:28", `specType`="SN Ia", `survey`="Global SN Project", `telescope`="FTS_FLOYDS-S", `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020ugz" ,"ZTF_Bot1" ,"2250" ,"2020-09-29 10:58:29" ,"2020-09-29 21:12:24" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.047", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ugz", `TNSuser`="ZTF_Bot1", `exptime`="2250", `obsdate`="2020-09-29 10:58:29", `reportAddedDate`="2020-09-29 21:12:24", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.047" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020uas" ,"shubhamsrivastav" ,"2000" ,"2020-10-09 01:24:26" ,"2020-10-16 11:05:40" ,"SN Ib/c" ,null ,"LT_SPRAT" ,"0.024", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uas", `TNSuser`="shubhamsrivastav", `exptime`="2000", `obsdate`="2020-10-09 01:24:26", `reportAddedDate`="2020-10-16 11:05:40", `specType`="SN Ib/c", `survey`=null, `telescope`="LT_SPRAT", `transRedshift`="0.024" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020pub" ,"ZTF_Bot1" ,"2700" ,"2020-12-15 12:01:30" ,"2020-12-20 15:42:05" ,"SN II" ,"ZTF" ,"P60_SEDM" ,"0.011", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2020-12-15 12:01:30", `reportAddedDate`="2020-12-20 15:42:05", `specType`="SN II", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.011" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020noz" ,"georgios_dimitriadis" ,null ,"2020-07-25 00:00:00" ,"2020-07-25 15:40:23" ,"SN IIn" ,"UCSC" ,"Keck1_LRIS" ,"0.025", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020noz", `TNSuser`="georgios_dimitriadis", `exptime`=null, `obsdate`="2020-07-25 00:00:00", `reportAddedDate`="2020-07-25 15:40:23", `specType`="SN IIn", `survey`="UCSC", `telescope`="Keck1_LRIS", `transRedshift`="0.025" ;