CREATE TABLE IF NOT EXISTS `fs_tns_sources` (
  `primaryId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'An internal counter',
  `TNSId` varchar(20) NOT NULL,
  `TNSName` varchar(20) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `decDeg` double DEFAULT NULL,
  `decSex` varchar(45) DEFAULT NULL,
  `discDate` datetime DEFAULT NULL,
  `discMag` double DEFAULT NULL,
  `discMagFilter` varchar(45) DEFAULT NULL,
  `discSurvey` varchar(100) DEFAULT NULL,
  `discoveryName` varchar(100) DEFAULT NULL,
  `objectUrl` varchar(200) DEFAULT NULL,
  `raDeg` double DEFAULT NULL,
  `raSex` varchar(45) DEFAULT NULL,
  `specType` varchar(100) DEFAULT NULL,
  `transRedshift` double DEFAULT NULL,
  `updated` tinyint(4) DEFAULT '0',
  `dateLastModified` datetime DEFAULT NULL,
  `hostName` VARCHAR(100) NULL DEFAULT NULL,
  `hostRedshift` DOUBLE NULL DEFAULT NULL, 
  `survey` VARCHAR(100) NULL DEFAULT NULL,
  PRIMARY KEY (`primaryId`),
  UNIQUE KEY `tnsid` (`TNSId`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=latin1;
            
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adiw" ,"AT2020adiw" ,"-5.105392" ,"-05:06:19.41" ,"2020-12-15 06:08:26.304" ,"20.4894" ,"r-ZTF" ,"ZTF" ,"ZTF20acxwbrk" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adiw" ,"74.3581917" ,"04:57:25.966" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiw", `TNSName`="AT2020adiw", `decDeg`="-5.105392", `decSex`="-05:06:19.41", `discDate`="2020-12-15 06:08:26.304", `discMag`="20.4894", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxwbrk", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adiw", `raDeg`="74.3581917", `raSex`="04:57:25.966", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adiv" ,"AT2020adiv" ,"30.235961" ,"+30:14:09.46" ,"2020-09-16 11:49:29.280" ,"20.4881" ,"r-ZTF" ,"ZTF" ,"ZTF20accxjsv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adiv" ,"90.8291875" ,"06:03:19.005" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiv", `TNSName`="AT2020adiv", `decDeg`="30.235961", `decSex`="+30:14:09.46", `discDate`="2020-09-16 11:49:29.280", `discMag`="20.4881", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20accxjsv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adiv", `raDeg`="90.8291875", `raSex`="06:03:19.005", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adiu" ,"AT2020adiu" ,"-16.352289" ,"-16:21:08.24" ,"2020-12-21 06:02:28.608" ,"19.9292" ,"g-ZTF" ,"ZTF" ,"ZTF20aczaawu" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adiu" ,"53.508408333333335" ,"03:34:02.018" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiu", `TNSName`="AT2020adiu", `decDeg`="-16.352289", `decSex`="-16:21:08.24", `discDate`="2020-12-21 06:02:28.608", `discMag`="19.9292", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20aczaawu", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adiu", `raDeg`="53.508408333333335", `raSex`="03:34:02.018", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adit" ,"AT2020adit" ,"16.408986" ,"+16:24:32.35" ,"2020-12-20 09:50:53.376" ,"20.3972" ,"g-ZTF" ,"ZTF" ,"ZTF20aczediz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adit" ,"155.8007917" ,"10:23:12.190" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adit", `TNSName`="AT2020adit", `decDeg`="16.408986", `decSex`="+16:24:32.35", `discDate`="2020-12-20 09:50:53.376", `discMag`="20.3972", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20aczediz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adit", `raDeg`="155.8007917", `raSex`="10:23:12.190", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adis" ,"AT2020adis" ,"35.896744" ,"+35:53:48.28" ,"2020-12-19 12:06:31.392" ,"20.0874" ,"g-ZTF" ,"ZTF" ,"ZTF20aczgoml" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adis" ,"226.09784583" ,"15:04:23.483" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adis", `TNSName`="AT2020adis", `decDeg`="35.896744", `decSex`="+35:53:48.28", `discDate`="2020-12-19 12:06:31.392", `discMag`="20.0874", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20aczgoml", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adis", `raDeg`="226.09784583", `raSex`="15:04:23.483", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adir" ,"AT2020adir" ,"6.85897" ,"+06:51:32.30" ,"2020-12-16 09:42:15.840" ,"19.8826" ,"r-ZTF" ,"ZTF" ,"ZTF20acwvkve" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adir" ,"137.32285417" ,"09:09:17.485" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adir", `TNSName`="AT2020adir", `decDeg`="6.85897", `decSex`="+06:51:32.30", `discDate`="2020-12-16 09:42:15.840", `discMag`="19.8826", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwvkve", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adir", `raDeg`="137.32285417", `raSex`="09:09:17.485", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adiq" ,"AT2020adiq" ,"-44.32415" ,"-44:19:26.94" ,"2020-12-20 05:49:55.200" ,"18.754" ,"orange-ATLAS" ,"ATLAS" ,"ATLAS20bhfg" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adiq" ,"10.3514" ,"00:41:24.336" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiq", `TNSName`="AT2020adiq", `decDeg`="-44.32415", `decSex`="-44:19:26.94", `discDate`="2020-12-20 05:49:55.200", `discMag`="18.754", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bhfg", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adiq", `raDeg`="10.3514", `raSex`="00:41:24.336", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adip" ,"AT2020adip" ,"4.55494" ,"+04:33:17.80" ,"2020-12-11 05:29:45.600" ,"18.806" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bhoo" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adip" ,"325.1162083" ,"21:40:27.890" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adip", `TNSName`="AT2020adip", `decDeg`="4.55494", `decSex`="+04:33:17.80", `discDate`="2020-12-11 05:29:45.600", `discMag`="18.806", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bhoo", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adip", `raDeg`="325.1162083", `raSex`="21:40:27.890", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adio" ,"AT2020adio" ,"-40.857989" ,"-40:51:28.76" ,"2020-12-10 05:42:43.200" ,"18.949" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bhfj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adio" ,"348.036417" ,"23:12:08.740" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adio", `TNSName`="AT2020adio", `decDeg`="-40.857989", `decSex`="-40:51:28.76", `discDate`="2020-12-10 05:42:43.200", `discMag`="18.949", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bhfj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adio", `raDeg`="348.036417", `raSex`="23:12:08.740", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adin" ,"AT2020adin" ,"-34.791175" ,"-34:47:28.23" ,"2020-12-14 08:21:07.200" ,"19.145" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bhft" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adin" ,"49.7014667" ,"03:18:48.352" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adin", `TNSName`="AT2020adin", `decDeg`="-34.791175", `decSex`="-34:47:28.23", `discDate`="2020-12-14 08:21:07.200", `discMag`="19.145", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bhft", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adin", `raDeg`="49.7014667", `raSex`="03:18:48.352", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adim" ,"AT2020adim" ,"-17.07458" ,"-17:04:28.50" ,"2020-12-10 10:01:55.200" ,"19.587" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bhfw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adim" ,"84.11560417" ,"05:36:27.745" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adim", `TNSName`="AT2020adim", `decDeg`="-17.07458", `decSex`="-17:04:28.50", `discDate`="2020-12-10 10:01:55.200", `discMag`="19.587", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bhfw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adim", `raDeg`="84.11560417", `raSex`="05:36:27.745", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adil" ,"AT2020adil" ,"-34.1791" ,"-34:10:44.76" ,"2020-12-10 14:21:07.200" ,"19.331" ,"orange-ATLAS" ,"ATLAS" ,"ATLAS20bhhb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adil" ,"150.31860417" ,"10:01:16.465" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adil", `TNSName`="AT2020adil", `decDeg`="-34.1791", `decSex`="-34:10:44.76", `discDate`="2020-12-10 14:21:07.200", `discMag`="19.331", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bhhb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adil", `raDeg`="150.31860417", `raSex`="10:01:16.465", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adik" ,"AT2020adik" ,"-13.911925" ,"-13:54:42.93" ,"2020-12-19 12:01:26.400" ,"19.71" ,"g-ZTF" ,"ZTF" ,"ZTF20aczfwjj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adik" ,"187.84842083" ,"12:31:23.621" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adik", `TNSName`="AT2020adik", `decDeg`="-13.911925", `decSex`="-13:54:42.93", `discDate`="2020-12-19 12:01:26.400", `discMag`="19.71", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20aczfwjj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adik", `raDeg`="187.84842083", `raSex`="12:31:23.621", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adij" ,"AT2020adij" ,"45.34378" ,"+45:20:37.60" ,"2020-12-17 11:22:58.656" ,"19.501" ,"g-ZTF" ,"ZTF" ,"ZTF20acyybwo" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adij" ,"184.0139417" ,"12:16:03.346" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adij", `TNSName`="AT2020adij", `decDeg`="45.34378", `decSex`="+45:20:37.60", `discDate`="2020-12-17 11:22:58.656", `discMag`="19.501", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyybwo", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adij", `raDeg`="184.0139417", `raSex`="12:16:03.346", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adii" ,"AT2020adii" ,"59.954461" ,"+59:57:16.06" ,"2020-12-20 09:45:14.688" ,"18.4092" ,"g-ZTF" ,"ZTF" ,"ZTF20acywbes" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adii" ,"164.97255416666667" ,"10:59:53.413" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adii", `TNSName`="AT2020adii", `decDeg`="59.954461", `decSex`="+59:57:16.06", `discDate`="2020-12-20 09:45:14.688", `discMag`="18.4092", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acywbes", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adii", `raDeg`="164.97255416666667", `raSex`="10:59:53.413", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adih" ,"AT2020adih" ,"38.461964" ,"+38:27:43.07" ,"2020-12-19 12:13:16.608" ,"19.74" ,"g-ZTF" ,"ZTF" ,"ZTF20acxzkds" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adih" ,"226.2742167" ,"15:05:05.812" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adih", `TNSName`="AT2020adih", `decDeg`="38.461964", `decSex`="+38:27:43.07", `discDate`="2020-12-19 12:13:16.608", `discMag`="19.74", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxzkds", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adih", `raDeg`="226.2742167", `raSex`="15:05:05.812", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adig" ,"AT2020adig" ,"-11.371294" ,"-11:22:16.66" ,"2020-12-10 13:13:48.864" ,"19.65" ,"r-ZTF" ,"ZTF" ,"ZTF20abgoagd" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adig" ,"206.924325" ,"13:47:41.838" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adig", `TNSName`="AT2020adig", `decDeg`="-11.371294", `decSex`="-11:22:16.66", `discDate`="2020-12-10 13:13:48.864", `discMag`="19.65", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20abgoagd", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adig", `raDeg`="206.924325", `raSex`="13:47:41.838", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adif" ,"AT2020adif" ,"-2.423792" ,"-02:25:25.65" ,"2020-12-21 10:04:18.624" ,"19.59" ,"r-ZTF" ,"ZTF" ,"ZTF20aczefjj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adif" ,"174.392975" ,"11:37:34.314" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adif", `TNSName`="AT2020adif", `decDeg`="-2.423792", `decSex`="-02:25:25.65", `discDate`="2020-12-21 10:04:18.624", `discMag`="19.59", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20aczefjj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adif", `raDeg`="174.392975", `raSex`="11:37:34.314", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adie" ,"AT2020adie" ,"-6.166394" ,"-06:09:59.02" ,"2020-12-21 11:13:39.648" ,"19.5" ,"g-ZTF" ,"ZTF" ,"ZTF20acrsbgc" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adie" ,"189.105525" ,"12:36:25.326" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adie", `TNSName`="AT2020adie", `decDeg`="-6.166394", `decSex`="-06:09:59.02", `discDate`="2020-12-21 11:13:39.648", `discMag`="19.5", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acrsbgc", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adie", `raDeg`="189.105525", `raSex`="12:36:25.326", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adid" ,"AT2020adid" ,"-15.181364" ,"-15:10:52.91" ,"2020-12-11 15:23:02.400" ,"18.983" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bhnb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adid" ,"197.300917" ,"13:09:12.220" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adid", `TNSName`="AT2020adid", `decDeg`="-15.181364", `decSex`="-15:10:52.91", `discDate`="2020-12-11 15:23:02.400", `discMag`="18.983", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bhnb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adid", `raDeg`="197.300917", `raSex`="13:09:12.220", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adic" ,"AT2020adic" ,"-31.330475" ,"-31:19:49.71" ,"2020-12-12 07:00:28.800" ,"19.447" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bhnk" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adic" ,"23.5452625" ,"01:34:10.863" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adic", `TNSName`="AT2020adic", `decDeg`="-31.330475", `decSex`="-31:19:49.71", `discDate`="2020-12-12 07:00:28.800", `discMag`="19.447", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bhnk", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adic", `raDeg`="23.5452625", `raSex`="01:34:10.863", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adib" ,"AT2020adib" ,"-26.197789" ,"-26:11:52.04" ,"2020-12-12 08:38:24.000" ,"19.263" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bhnm" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adib" ,"51.5380375" ,"03:26:09.129" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adib", `TNSName`="AT2020adib", `decDeg`="-26.197789", `decSex`="-26:11:52.04", `discDate`="2020-12-12 08:38:24.000", `discMag`="19.263", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bhnm", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adib", `raDeg`="51.5380375", `raSex`="03:26:09.129", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adia" ,"AT2020adia" ,"-46.63194" ,"-46:37:55.00" ,"2020-12-21 07:10:17.184" ,"17.1" ,"Clear-" ,"MASTER" ,"MASTER OT J141825.72-463755.0" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adia" ,"214.60716666666667" ,"14:18:25.720" ,"MASTER" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adia", `TNSName`="AT2020adia", `decDeg`="-46.63194", `decSex`="-46:37:55.00", `discDate`="2020-12-21 07:10:17.184", `discMag`="17.1", `discMagFilter`="Clear-", `discSurvey`="MASTER", `discoveryName`="MASTER OT J141825.72-463755.0", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adia", `raDeg`="214.60716666666667", `raSex`="14:18:25.720", `reportingSurvey`="MASTER", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhz" ,"AT2020adhz" ,"42.694886" ,"+42:41:41.59" ,"2020-12-20 12:08:38.400" ,"20.05" ,"r-ZTF" ,"ZTF" ,"ZTF20acyybvq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhz" ,"185.84962917" ,"12:23:23.911" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhz", `TNSName`="AT2020adhz", `decDeg`="42.694886", `decSex`="+42:41:41.59", `discDate`="2020-12-20 12:08:38.400", `discMag`="20.05", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyybvq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhz", `raDeg`="185.84962917", `raSex`="12:23:23.911", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhy" ,"AT2020adhy" ,"20.416747" ,"+20:25:00.29" ,"2020-12-19 03:44:38.400" ,"18.48" ,"g-ZTF" ,"ZTF" ,"ZTF20acympvl" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhy" ,"323.24955" ,"21:32:59.892" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhy", `TNSName`="AT2020adhy", `decDeg`="20.416747", `decSex`="+20:25:00.29", `discDate`="2020-12-19 03:44:38.400", `discMag`="18.48", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acympvl", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhy", `raDeg`="323.24955", `raSex`="21:32:59.892", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhx" ,"AT2020adhx" ,"-27.429319" ,"-27:25:45.55" ,"2020-12-16 04:31:37.632" ,"19.75" ,"g-ZTF" ,"ZTF" ,"ZTF20acynjyj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhx" ,"32.45649583" ,"02:09:49.559" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhx", `TNSName`="AT2020adhx", `decDeg`="-27.429319", `decSex`="-27:25:45.55", `discDate`="2020-12-16 04:31:37.632", `discMag`="19.75", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acynjyj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhx", `raDeg`="32.45649583", `raSex`="02:09:49.559", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhw" ,"AT2020adhw" ,"7.03095" ,"+07:01:51.42" ,"2020-12-11 05:03:39.168" ,"20.13" ,"g-ZTF" ,"ZTF" ,"ZTF20acvziru" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhw" ,"47.7246167" ,"03:10:53.908" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhw", `TNSName`="AT2020adhw", `decDeg`="7.03095", `decSex`="+07:01:51.42", `discDate`="2020-12-11 05:03:39.168", `discMag`="20.13", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acvziru", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhw", `raDeg`="47.7246167", `raSex`="03:10:53.908", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhv" ,"AT2020adhv" ,"9.947836" ,"+09:56:52.21" ,"2020-12-19 06:54:01.728" ,"19.51" ,"r-ZTF" ,"ZTF" ,"ZTF17aabvqrn" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhv" ,"31.125054166666665" ,"02:04:30.013" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhv", `TNSName`="AT2020adhv", `decDeg`="9.947836", `decSex`="+09:56:52.21", `discDate`="2020-12-19 06:54:01.728", `discMag`="19.51", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF17aabvqrn", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhv", `raDeg`="31.125054166666665", `raSex`="02:04:30.013", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhu" ,"AT2020adhu" ,"35.105036" ,"+35:06:18.13" ,"2020-12-21 02:55:57.216" ,"19.54" ,"g-ZTF" ,"ZTF" ,"ZTF20acxuibv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhu" ,"343.16740417" ,"22:52:40.177" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhu", `TNSName`="AT2020adhu", `decDeg`="35.105036", `decSex`="+35:06:18.13", `discDate`="2020-12-21 02:55:57.216", `discMag`="19.54", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxuibv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhu", `raDeg`="343.16740417", `raSex`="22:52:40.177", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adht" ,"AT2020adht" ,"16.52039" ,"+16:31:13.40" ,"2020-12-16 04:07:15.744" ,"19.9" ,"g-ZTF" ,"ZTF" ,"ZTF20acxnsim" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adht" ,"5.6583375" ,"00:22:38.001" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adht", `TNSName`="AT2020adht", `decDeg`="16.52039", `decSex`="+16:31:13.40", `discDate`="2020-12-16 04:07:15.744", `discMag`="19.9", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxnsim", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adht", `raDeg`="5.6583375", `raSex`="00:22:38.001", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhs" ,"AT2020adhs" ,"10.862225" ,"+10:51:44.01" ,"2020-12-19 06:54:44.928" ,"19.41" ,"r-ZTF" ,"ZTF" ,"ZTF20acxcwkr" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhs" ,"43.541245833333335" ,"02:54:09.899" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhs", `TNSName`="AT2020adhs", `decDeg`="10.862225", `decSex`="+10:51:44.01", `discDate`="2020-12-19 06:54:44.928", `discMag`="19.41", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxcwkr", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhs", `raDeg`="43.541245833333335", `raSex`="02:54:09.899", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhr" ,"AT2020adhr" ,"18.454589" ,"+18:27:16.52" ,"2020-12-16 02:38:05.856" ,"19.66" ,"r-ZTF" ,"ZTF" ,"ZTF20acwzxxy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhr" ,"343.67512917" ,"22:54:42.031" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhr", `TNSName`="AT2020adhr", `decDeg`="18.454589", `decSex`="+18:27:16.52", `discDate`="2020-12-16 02:38:05.856", `discMag`="19.66", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwzxxy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhr", `raDeg`="343.67512917", `raSex`="22:54:42.031", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhq" ,"AT2020adhq" ,"10.530186" ,"+10:31:48.67" ,"2020-12-16 04:06:35.136" ,"19.68" ,"g-ZTF" ,"ZTF" ,"ZTF20acxuxdd" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhq" ,"358.7877875" ,"23:55:09.069" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhq", `TNSName`="AT2020adhq", `decDeg`="10.530186", `decSex`="+10:31:48.67", `discDate`="2020-12-16 04:06:35.136", `discMag`="19.68", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxuxdd", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhq", `raDeg`="358.7877875", `raSex`="23:55:09.069", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhp" ,"AT2020adhp" ,"30.598758" ,"+30:35:55.53" ,"2020-12-19 04:20:10.752" ,"19.47" ,"g-ZTF" ,"ZTF" ,"ZTF20acxuhys" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhp" ,"340.8147" ,"22:43:15.528" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhp", `TNSName`="AT2020adhp", `decDeg`="30.598758", `decSex`="+30:35:55.53", `discDate`="2020-12-19 04:20:10.752", `discMag`="19.47", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxuhys", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhp", `raDeg`="340.8147", `raSex`="22:43:15.528", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adho" ,"AT2020adho" ,"0.007253" ,"+00:00:26.11" ,"2020-12-16 02:14:34.944" ,"19.18" ,"r-ZTF" ,"ZTF" ,"ZTF20acxnjat" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adho" ,"328.983225" ,"21:55:55.974" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adho", `TNSName`="AT2020adho", `decDeg`="0.007253", `decSex`="+00:00:26.11", `discDate`="2020-12-16 02:14:34.944", `discMag`="19.18", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxnjat", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adho", `raDeg`="328.983225", `raSex`="21:55:55.974", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhn" ,"AT2020adhn" ,"-24.100078" ,"-24:06:00.28" ,"2020-12-19 04:39:24.192" ,"19.04" ,"g-ZTF" ,"ZTF" ,"ZTF20acxbskl" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhn" ,"7.087" ,"00:28:20.880" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhn", `TNSName`="AT2020adhn", `decDeg`="-24.100078", `decSex`="-24:06:00.28", `discDate`="2020-12-19 04:39:24.192", `discMag`="19.04", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxbskl", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhn", `raDeg`="7.087", `raSex`="00:28:20.880", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhm" ,"AT2020adhm" ,"0.278414" ,"+00:16:42.29" ,"2020-12-21 02:18:29.952" ,"17.29" ,"g-ZTF" ,"ZTF" ,"ZTF19aazlvbw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhm" ,"329.84927083" ,"21:59:23.825" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhm", `TNSName`="AT2020adhm", `decDeg`="0.278414", `decSex`="+00:16:42.29", `discDate`="2020-12-21 02:18:29.952", `discMag`="17.29", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF19aazlvbw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhm", `raDeg`="329.84927083", `raSex`="21:59:23.825", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhl" ,"AT2020adhl" ,"18.372831" ,"+18:22:22.19" ,"2020-11-15 12:09:51.000" ,"20.414" ,"g-ZTF" ,"ZTF" ,"ZTF20acrjifk" ,"SDSS J113115.07+182236.8" ,"0.132187" ,"http://wis-tns.weizmann.ac.il/object/2020adhl" ,"172.80527917" ,"11:31:13.267" ,"SGLF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhl", `TNSName`="AT2020adhl", `decDeg`="18.372831", `decSex`="+18:22:22.19", `discDate`="2020-11-15 12:09:51.000", `discMag`="20.414", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acrjifk", `hostName`="SDSS J113115.07+182236.8", `hostRedshift`="0.132187", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhl", `raDeg`="172.80527917", `raSex`="11:31:13.267", `reportingSurvey`="SGLF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhk" ,"AT2020adhk" ,"18.740322" ,"+18:44:25.16" ,"2020-11-24 12:39:57.000" ,"19.58" ,"g-ZTF" ,"ZTF" ,"ZTF20actoakk" ,"SDSS J130043.79+184424.5" ,"0.132769" ,"http://wis-tns.weizmann.ac.il/object/2020adhk" ,"195.18315" ,"13:00:43.956" ,"SGLF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhk", `TNSName`="AT2020adhk", `decDeg`="18.740322", `decSex`="+18:44:25.16", `discDate`="2020-11-24 12:39:57.000", `discMag`="19.58", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20actoakk", `hostName`="SDSS J130043.79+184424.5", `hostRedshift`="0.132769", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhk", `raDeg`="195.18315", `raSex`="13:00:43.956", `reportingSurvey`="SGLF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhj" ,"AT2020adhj" ,"-43.846064" ,"-43:50:45.83" ,"2020-12-20 07:35:02.400" ,"18.893" ,"orange-ATLAS" ,"ATLAS" ,"ATLAS20birq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhj" ,"32.70264583" ,"02:10:48.635" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhj", `TNSName`="AT2020adhj", `decDeg`="-43.846064", `decSex`="-43:50:45.83", `discDate`="2020-12-20 07:35:02.400", `discMag`="18.893", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20birq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhj", `raDeg`="32.70264583", `raSex`="02:10:48.635", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhi" ,"AT2020adhi" ,"-16.756828" ,"-16:45:24.58" ,"2020-12-20 06:56:09.600" ,"19.177" ,"orange-ATLAS" ,"ATLAS, ZTF" ,"ATLAS20birp" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhi" ,"22.605566666666668" ,"01:30:25.336" ,"ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhi", `TNSName`="AT2020adhi", `decDeg`="-16.756828", `decSex`="-16:45:24.58", `discDate`="2020-12-20 06:56:09.600", `discMag`="19.177", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS, ZTF", `discoveryName`="ATLAS20birp", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhi", `raDeg`="22.605566666666668", `raSex`="01:30:25.336", `reportingSurvey`="ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhh" ,"AT2020adhh" ,"28.969592" ,"+28:58:10.53" ,"2020-12-17 07:28:42.000" ,"21" ,"V-crts-CRTS" ,"CRTS, ZTF" ,null ,"UGC 3142" ,"0.02166" ,"http://wis-tns.weizmann.ac.il/object/2020adhh" ,"70.942417" ,"04:43:46.180" ,"SNHunt, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhh", `TNSName`="AT2020adhh", `decDeg`="28.969592", `decSex`="+28:58:10.53", `discDate`="2020-12-17 07:28:42.000", `discMag`="21", `discMagFilter`="V-crts-CRTS", `discSurvey`="CRTS, ZTF", `discoveryName`=null, `hostName`="UGC 3142", `hostRedshift`="0.02166", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhh", `raDeg`="70.942417", `raSex`="04:43:46.180", `reportingSurvey`="SNHunt, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhg" ,"AT2020adhg" ,"-41.831103" ,"-41:49:51.97" ,"2020-12-20 07:14:52.800" ,"18.719" ,"orange-ATLAS" ,"ATLAS" ,"ATLAS20birn" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhg" ,"31.551141666666666" ,"02:06:12.274" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhg", `TNSName`="AT2020adhg", `decDeg`="-41.831103", `decSex`="-41:49:51.97", `discDate`="2020-12-20 07:14:52.800", `discMag`="18.719", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20birn", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhg", `raDeg`="31.551141666666666", `raSex`="02:06:12.274", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhf" ,"AT2020adhf" ,"-18.437394" ,"-18:26:14.62" ,"2020-12-14 13:27:50.400" ,"19.477" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20biij" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhf" ,"142.43579583" ,"09:29:44.591" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhf", `TNSName`="AT2020adhf", `decDeg`="-18.437394", `decSex`="-18:26:14.62", `discDate`="2020-12-14 13:27:50.400", `discMag`="19.477", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20biij", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhf", `raDeg`="142.43579583", `raSex`="09:29:44.591", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhe" ,"AT2020adhe" ,"-49.18792" ,"-49:11:16.50" ,"2020-12-14 15:21:36.000" ,"17.554" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bigq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhe" ,"174.9351583" ,"11:39:44.438" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhe", `TNSName`="AT2020adhe", `decDeg`="-49.18792", `decSex`="-49:11:16.50", `discDate`="2020-12-14 15:21:36.000", `discMag`="17.554", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bigq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhe", `raDeg`="174.9351583", `raSex`="11:39:44.438", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhd" ,"AT2020adhd" ,"27.97492" ,"+27:58:29.70" ,"2020-12-14 11:22:33.600" ,"19.479" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20biht" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhd" ,"131.5429333" ,"08:46:10.304" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhd", `TNSName`="AT2020adhd", `decDeg`="27.97492", `decSex`="+27:58:29.70", `discDate`="2020-12-14 11:22:33.600", `discMag`="19.479", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20biht", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhd", `raDeg`="131.5429333", `raSex`="08:46:10.304", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhc" ,"AT2020adhc" ,"-22.047794" ,"-22:02:52.06" ,"2020-12-14 14:15:21.600" ,"19.53" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20biis" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhc" ,"155.1977167" ,"10:20:47.452" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhc", `TNSName`="AT2020adhc", `decDeg`="-22.047794", `decSex`="-22:02:52.06", `discDate`="2020-12-14 14:15:21.600", `discMag`="19.53", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20biis", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhc", `raDeg`="155.1977167", `raSex`="10:20:47.452", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adhb" ,"AT2020adhb" ,"-41.00247" ,"-41:00:08.90" ,"2020-12-14 14:38:24.000" ,"19.33" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bilc" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adhb" ,"166.5931625" ,"11:06:22.359" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhb", `TNSName`="AT2020adhb", `decDeg`="-41.00247", `decSex`="-41:00:08.90", `discDate`="2020-12-14 14:38:24.000", `discMag`="19.33", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bilc", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adhb", `raDeg`="166.5931625", `raSex`="11:06:22.359", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adha" ,"AT2020adha" ,"26.116081" ,"+26:06:57.89" ,"2020-12-14 14:41:16.800" ,"19.341" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bije" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adha" ,"189.63589583" ,"12:38:32.615" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adha", `TNSName`="AT2020adha", `decDeg`="26.116081", `decSex`="+26:06:57.89", `discDate`="2020-12-14 14:41:16.800", `discMag`="19.341", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bije", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adha", `raDeg`="189.63589583", `raSex`="12:38:32.615", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgz" ,"AT2020adgz" ,"17.046669" ,"+17:02:48.01" ,"2020-12-14 12:46:04.800" ,"19.764" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bika" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgz" ,"154.92152917" ,"10:19:41.167" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgz", `TNSName`="AT2020adgz", `decDeg`="17.046669", `decSex`="+17:02:48.01", `discDate`="2020-12-14 12:46:04.800", `discMag`="19.764", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bika", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgz", `raDeg`="154.92152917", `raSex`="10:19:41.167", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgy" ,"AT2020adgy" ,"-42.605294" ,"-42:36:19.06" ,"2020-12-14 15:15:50.400" ,"18.302" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bigr" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgy" ,"192.06092917" ,"12:48:14.623" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgy", `TNSName`="AT2020adgy", `decDeg`="-42.605294", `decSex`="-42:36:19.06", `discDate`="2020-12-14 15:15:50.400", `discMag`="18.302", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bigr", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgy", `raDeg`="192.06092917", `raSex`="12:48:14.623", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgx" ,"AT2020adgx" ,"33.84861" ,"+33:50:55.00" ,"2020-12-14 12:24:28.800" ,"19.7" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bikd" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgx" ,"158.98105416666667" ,"10:35:55.453" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgx", `TNSName`="AT2020adgx", `decDeg`="33.84861", `decSex`="+33:50:55.00", `discDate`="2020-12-14 12:24:28.800", `discMag`="19.7", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bikd", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgx", `raDeg`="158.98105416666667", `raSex`="10:35:55.453", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgw" ,"AT2020adgw" ,"-40.292453" ,"-40:17:32.83" ,"2020-12-14 14:21:07.200" ,"19.314" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20biks" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgw" ,"160.9993417" ,"10:43:59.842" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgw", `TNSName`="AT2020adgw", `decDeg`="-40.292453", `decSex`="-40:17:32.83", `discDate`="2020-12-14 14:21:07.200", `discMag`="19.314", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20biks", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgw", `raDeg`="160.9993417", `raSex`="10:43:59.842", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgv" ,"AT2020adgv" ,"-44.021186" ,"-44:01:16.27" ,"2020-12-14 10:16:19.200" ,"19.311" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bijg" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgv" ,"78.12364583" ,"05:12:29.675" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgv", `TNSName`="AT2020adgv", `decDeg`="-44.021186", `decSex`="-44:01:16.27", `discDate`="2020-12-14 10:16:19.200", `discMag`="19.311", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bijg", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgv", `raDeg`="78.12364583", `raSex`="05:12:29.675", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgu" ,"AT2020adgu" ,"2.128367" ,"+02:07:42.12" ,"2020-12-17 07:55:12.000" ,"19.636" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bioi" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgu" ,"39.4080667" ,"02:37:37.936" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgu", `TNSName`="AT2020adgu", `decDeg`="2.128367", `decSex`="+02:07:42.12", `discDate`="2020-12-17 07:55:12.000", `discMag`="19.636", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bioi", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgu", `raDeg`="39.4080667", `raSex`="02:37:37.936", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgt" ,"AT2020adgt" ,"66.748686" ,"+66:44:55.27" ,"2020-12-17 11:24:00.000" ,"19.37" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20biop" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgt" ,"92.37522083" ,"06:09:30.053" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgt", `TNSName`="AT2020adgt", `decDeg`="66.748686", `decSex`="+66:44:55.27", `discDate`="2020-12-17 11:24:00.000", `discMag`="19.37", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20biop", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgt", `raDeg`="92.37522083", `raSex`="06:09:30.053", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgs" ,"AT2020adgs" ,"52.719172" ,"+52:43:09.02" ,"2020-12-19 14:51:21.600" ,"19.407" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bire" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgs" ,"122.65097083" ,"08:10:36.233" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgs", `TNSName`="AT2020adgs", `decDeg`="52.719172", `decSex`="+52:43:09.02", `discDate`="2020-12-19 14:51:21.600", `discMag`="19.407", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bire", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgs", `raDeg`="122.65097083", `raSex`="08:10:36.233", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgr" ,"AT2020adgr" ,"12.879794" ,"+12:52:47.26" ,"2020-12-15 06:11:31.200" ,"20.49" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mlr" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgr" ,"2.6874541666666665" ,"00:10:44.989" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgr", `TNSName`="AT2020adgr", `decDeg`="12.879794", `decSex`="+12:52:47.26", `discDate`="2020-12-15 06:11:31.200", `discMag`="20.49", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mlr", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgr", `raDeg`="2.6874541666666665", `raSex`="00:10:44.989", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgq" ,"AT2020adgq" ,"-7.869519" ,"-07:52:10.27" ,"2020-12-10 10:26:24.000" ,"20.36" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mlq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgq" ,"77.1872625" ,"05:08:44.943" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgq", `TNSName`="AT2020adgq", `decDeg`="-7.869519", `decSex`="-07:52:10.27", `discDate`="2020-12-10 10:26:24.000", `discMag`="20.36", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mlq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgq", `raDeg`="77.1872625", `raSex`="05:08:44.943", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgp" ,"AT2020adgp" ,"-18.435928" ,"-18:26:09.34" ,"2020-12-19 03:05:36.960" ,"19.4988" ,"r-ZTF" ,"ZTF" ,"ZTF20acymtod" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgp" ,"8.191379166666668" ,"00:32:45.931" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgp", `TNSName`="AT2020adgp", `decDeg`="-18.435928", `decSex`="-18:26:09.34", `discDate`="2020-12-19 03:05:36.960", `discMag`="19.4988", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acymtod", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgp", `raDeg`="8.191379166666668", `raSex`="00:32:45.931", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgo" ,"AT2020adgo" ,"1.067883" ,"+01:04:04.38" ,"2020-11-20 04:03:56.160" ,"19.0261" ,"g-ZTF" ,"ZTF" ,"ZTF20acymsyv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgo" ,"358.2713917" ,"23:53:05.134" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgo", `TNSName`="AT2020adgo", `decDeg`="1.067883", `decSex`="+01:04:04.38", `discDate`="2020-11-20 04:03:56.160", `discMag`="19.0261", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acymsyv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgo", `raDeg`="358.2713917", `raSex`="23:53:05.134", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgn" ,"AT2020adgn" ,"5.310653" ,"+05:18:38.35" ,"2020-12-19 08:37:58.944" ,"19.3039" ,"g-ZTF" ,"ZTF" ,"ZTF20acyppyp" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgn" ,"118.49307917" ,"07:53:58.339" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgn", `TNSName`="AT2020adgn", `decDeg`="5.310653", `decSex`="+05:18:38.35", `discDate`="2020-12-19 08:37:58.944", `discMag`="19.3039", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyppyp", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgn", `raDeg`="118.49307917", `raSex`="07:53:58.339", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgm" ,"AT2020adgm" ,"-53.07261" ,"-53:04:21.40" ,"2020-12-20 06:28:48.000" ,"17.4" ,"g-Sloan" ,"ASAS-SN" ,"ASASSN-20qc" ,"WISEA J041302.39-530422.2" ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgm" ,"63.26049166666667" ,"04:13:02.518" ,"ASAS-SN" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgm", `TNSName`="AT2020adgm", `decDeg`="-53.07261", `decSex`="-53:04:21.40", `discDate`="2020-12-20 06:28:48.000", `discMag`="17.4", `discMagFilter`="g-Sloan", `discSurvey`="ASAS-SN", `discoveryName`="ASASSN-20qc", `hostName`="WISEA J041302.39-530422.2", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgm", `raDeg`="63.26049166666667", `raSex`="04:13:02.518", `reportingSurvey`="ASAS-SN", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgl" ,"AT2020adgl" ,"5.666681" ,"+05:40:00.05" ,"2020-11-20 11:57:58.176" ,"20.2682" ,"g-ZTF" ,"ZTF" ,"ZTF20acymcnb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgl" ,"159.61887083" ,"10:38:28.529" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgl", `TNSName`="AT2020adgl", `decDeg`="5.666681", `decSex`="+05:40:00.05", `discDate`="2020-11-20 11:57:58.176", `discMag`="20.2682", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acymcnb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgl", `raDeg`="159.61887083", `raSex`="10:38:28.529", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgk" ,"AT2020adgk" ,"63.194261" ,"+63:11:39.34" ,"2020-12-19 07:53:45.600" ,"18.13" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acypdlh" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgk" ,"92.3856917" ,"06:09:32.566" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgk", `TNSName`="AT2020adgk", `decDeg`="63.194261", `decSex`="+63:11:39.34", `discDate`="2020-12-19 07:53:45.600", `discMag`="18.13", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acypdlh", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgk", `raDeg`="92.3856917", `raSex`="06:09:32.566", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgj" ,"AT2020adgj" ,"-9.033044" ,"-09:01:58.96" ,"2020-12-15 06:14:24.000" ,"20.12" ,"r-ZTF" ,"ZTF" ,"ZTF20acxpvhu" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgj" ,"83.4112125" ,"05:33:38.691" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgj", `TNSName`="AT2020adgj", `decDeg`="-9.033044", `decSex`="-09:01:58.96", `discDate`="2020-12-15 06:14:24.000", `discMag`="20.12", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxpvhu", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgj", `raDeg`="83.4112125", `raSex`="05:33:38.691", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgi" ,"AT2020adgi" ,"-11.914097" ,"-11:54:50.75" ,"2020-12-10 07:26:24.000" ,"20.38" ,"r-ZTF" ,"ZTF" ,"ZTF20acwmfpw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgi" ,"100.2584833" ,"06:41:02.036" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgi", `TNSName`="AT2020adgi", `decDeg`="-11.914097", `decSex`="-11:54:50.75", `discDate`="2020-12-10 07:26:24.000", `discMag`="20.38", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwmfpw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgi", `raDeg`="100.2584833", `raSex`="06:41:02.036", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgh" ,"AT2020adgh" ,"-15.224031" ,"-15:13:26.51" ,"2020-12-15 09:02:52.800" ,"19.35" ,"g-ZTF" ,"ZTF" ,"ZTF20acywnjy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgh" ,"120.7393167" ,"08:02:57.436" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgh", `TNSName`="AT2020adgh", `decDeg`="-15.224031", `decSex`="-15:13:26.51", `discDate`="2020-12-15 09:02:52.800", `discMag`="19.35", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acywnjy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgh", `raDeg`="120.7393167", `raSex`="08:02:57.436", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgg" ,"AT2020adgg" ,"18.047225" ,"+18:02:50.01" ,"2020-10-15 10:56:38.400" ,"20.2" ,"g-ZTF" ,"ZTF" ,"ZTF20acnviht" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgg" ,"124.2132417" ,"08:16:51.178" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgg", `TNSName`="AT2020adgg", `decDeg`="18.047225", `decSex`="+18:02:50.01", `discDate`="2020-10-15 10:56:38.400", `discMag`="20.2", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acnviht", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgg", `raDeg`="124.2132417", `raSex`="08:16:51.178", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgf" ,"AT2020adgf" ,"-51.1526" ,"-51:09:09.36" ,"2020-12-18 19:40:48.000" ,"18.1" ,"g-Sloan" ,"ASAS-SN" ,"ASASSN-20qb" ,"WISEA J051414.04-510859.3" ,"0.060092" ,"http://wis-tns.weizmann.ac.il/object/2020adgf" ,"78.55102916666667" ,"05:14:12.247" ,"ASAS-SN" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgf", `TNSName`="AT2020adgf", `decDeg`="-51.1526", `decSex`="-51:09:09.36", `discDate`="2020-12-18 19:40:48.000", `discMag`="18.1", `discMagFilter`="g-Sloan", `discSurvey`="ASAS-SN", `discoveryName`="ASASSN-20qb", `hostName`="WISEA J051414.04-510859.3", `hostRedshift`="0.060092", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgf", `raDeg`="78.55102916666667", `raSex`="05:14:12.247", `reportingSurvey`="ASAS-SN", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adge" ,"AT2020adge" ,"-36.157197" ,"-36:09:25.91" ,"2020-12-20 06:38:52.800" ,"18.734" ,"orange-ATLAS" ,"ATLAS" ,"ATLAS20biri" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adge" ,"13.4416917" ,"00:53:46.006" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adge", `TNSName`="AT2020adge", `decDeg`="-36.157197", `decSex`="-36:09:25.91", `discDate`="2020-12-20 06:38:52.800", `discMag`="18.734", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20biri", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adge", `raDeg`="13.4416917", `raSex`="00:53:46.006", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgd" ,"AT2020adgd" ,"48.550619" ,"+48:33:02.23" ,"2020-12-17 11:51:21.600" ,"19.701" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20biom" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgd" ,"122.3250375" ,"08:09:18.009" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgd", `TNSName`="AT2020adgd", `decDeg`="48.550619", `decSex`="+48:33:02.23", `discDate`="2020-12-17 11:51:21.600", `discMag`="19.701", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20biom", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgd", `raDeg`="122.3250375", `raSex`="08:09:18.009", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgc" ,"AT2020adgc" ,"-28.448433" ,"-28:26:54.36" ,"2020-12-20 07:36:28.800" ,"17.889" ,"orange-ATLAS" ,"ATLAS" ,"ATLAS20birg" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgc" ,"41.9041625" ,"02:47:36.999" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgc", `TNSName`="AT2020adgc", `decDeg`="-28.448433", `decSex`="-28:26:54.36", `discDate`="2020-12-20 07:36:28.800", `discMag`="17.889", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20birg", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgc", `raDeg`="41.9041625", `raSex`="02:47:36.999", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adgb" ,"AT2020adgb" ,"63.15328" ,"+63:09:11.80" ,"2020-12-17 14:31:12.000" ,"19.378" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20biow" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adgb" ,"159.43134166666667" ,"10:37:43.522" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgb", `TNSName`="AT2020adgb", `decDeg`="63.15328", `decSex`="+63:09:11.80", `discDate`="2020-12-17 14:31:12.000", `discMag`="19.378", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20biow", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adgb", `raDeg`="159.43134166666667", `raSex`="10:37:43.522", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adga" ,"AT2020adga" ,"56.574467" ,"+56:34:28.08" ,"2020-12-17 12:18:43.200" ,"19.497" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bioy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adga" ,"133.4353" ,"08:53:44.472" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adga", `TNSName`="AT2020adga", `decDeg`="56.574467", `decSex`="+56:34:28.08", `discDate`="2020-12-17 12:18:43.200", `discMag`="19.497", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bioy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adga", `raDeg`="133.4353", `raSex`="08:53:44.472", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfz" ,"AT2020adfz" ,"-4.632656" ,"-04:37:57.56" ,"2020-12-17 09:46:04.800" ,"19.458" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20biqb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfz" ,"68.3904625" ,"04:33:33.711" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfz", `TNSName`="AT2020adfz", `decDeg`="-4.632656", `decSex`="-04:37:57.56", `discDate`="2020-12-17 09:46:04.800", `discMag`="19.458", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20biqb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfz", `raDeg`="68.3904625", `raSex`="04:33:33.711", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfy" ,"AT2020adfy" ,"52.363858" ,"+52:21:49.89" ,"2020-12-17 12:18:43.200" ,"19.474" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS20bioh" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfy" ,"136.58307083" ,"09:06:19.937" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfy", `TNSName`="AT2020adfy", `decDeg`="52.363858", `decSex`="+52:21:49.89", `discDate`="2020-12-17 12:18:43.200", `discMag`="19.474", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS20bioh", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfy", `raDeg`="136.58307083", `raSex`="09:06:19.937", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfx" ,"AT2020adfx" ,"31.129947" ,"+31:07:47.81" ,"2020-11-16 06:59:02.400" ,"21.98" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mll" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfx" ,"32.15553333333333" ,"02:08:37.328" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfx", `TNSName`="AT2020adfx", `decDeg`="31.129947", `decSex`="+31:07:47.81", `discDate`="2020-11-16 06:59:02.400", `discMag`="21.98", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mll", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfx", `raDeg`="32.15553333333333", `raSex`="02:08:37.328", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfw" ,"AT2020adfw" ,"-1.311697" ,"-01:18:42.11" ,"2020-12-06 05:25:26.400" ,"20.98" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mlk" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfw" ,"333.1661417" ,"22:12:39.874" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfw", `TNSName`="AT2020adfw", `decDeg`="-1.311697", `decSex`="-01:18:42.11", `discDate`="2020-12-06 05:25:26.400", `discMag`="20.98", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mlk", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfw", `raDeg`="333.1661417", `raSex`="22:12:39.874", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfv" ,"AT2020adfv" ,"39.769808" ,"+39:46:11.31" ,"2020-12-15 13:10:10.272" ,"20.23" ,"g-ZTF" ,"ZTF" ,"ZTF20acyxzzf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfv" ,"205.6764" ,"13:42:42.336" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfv", `TNSName`="AT2020adfv", `decDeg`="39.769808", `decSex`="+39:46:11.31", `discDate`="2020-12-15 13:10:10.272", `discMag`="20.23", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyxzzf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfv", `raDeg`="205.6764", `raSex`="13:42:42.336", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfu" ,"AT2020adfu" ,"20.336964" ,"+20:20:13.07" ,"2020-12-15 12:57:41.184" ,"19.38" ,"g-ZTF" ,"ZTF" ,"ZTF20acxtdtv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfu" ,"223.72997917" ,"14:54:55.195" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfu", `TNSName`="AT2020adfu", `decDeg`="20.336964", `decSex`="+20:20:13.07", `discDate`="2020-12-15 12:57:41.184", `discMag`="19.38", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxtdtv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfu", `raDeg`="223.72997917", `raSex`="14:54:55.195", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adft" ,"AT2020adft" ,"27.85619" ,"+27:51:22.30" ,"2020-12-20 12:21:42.048" ,"19.27" ,"r-ZTF" ,"ZTF" ,"ZTF18acycwvv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adft" ,"217.8673833" ,"14:31:28.172" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adft", `TNSName`="AT2020adft", `decDeg`="27.85619", `decSex`="+27:51:22.30", `discDate`="2020-12-20 12:21:42.048", `discMag`="19.27", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18acycwvv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adft", `raDeg`="217.8673833", `raSex`="14:31:28.172", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfs" ,"AT2020adfs" ,"11.174275" ,"+11:10:27.39" ,"2020-12-20 12:23:04.128" ,"19.34" ,"r-ZTF" ,"ZTF" ,"ZTF18acuehzf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfs" ,"225.7987" ,"15:03:11.688" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfs", `TNSName`="AT2020adfs", `decDeg`="11.174275", `decSex`="+11:10:27.39", `discDate`="2020-12-20 12:23:04.128", `discMag`="19.34", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18acuehzf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfs", `raDeg`="225.7987", `raSex`="15:03:11.688", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfr" ,"AT2020adfr" ,"6.102964" ,"+06:06:10.67" ,"2020-12-15 13:03:10.368" ,"20.01" ,"g-ZTF" ,"ZTF" ,"ZTF20acyyaiq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfr" ,"211.9310125" ,"14:07:43.443" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfr", `TNSName`="AT2020adfr", `decDeg`="6.102964", `decSex`="+06:06:10.67", `discDate`="2020-12-15 13:03:10.368", `discMag`="20.01", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyyaiq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfr", `raDeg`="211.9310125", `raSex`="14:07:43.443", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfq" ,"AT2020adfq" ,"-1.413464" ,"-01:24:48.47" ,"2020-12-15 12:34:30.144" ,"20.18" ,"g-ZTF" ,"ZTF" ,"ZTF20acymcuj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfq" ,"180.37672083" ,"12:01:30.413" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfq", `TNSName`="AT2020adfq", `decDeg`="-1.413464", `decSex`="-01:24:48.47", `discDate`="2020-12-15 12:34:30.144", `discMag`="20.18", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acymcuj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfq", `raDeg`="180.37672083", `raSex`="12:01:30.413", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfp" ,"AT2020adfp" ,"16.877447" ,"+16:52:38.81" ,"2020-12-15 12:57:41.184" ,"19.91" ,"g-ZTF" ,"ZTF" ,"ZTF20acykoxy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfp" ,"221.9542083" ,"14:47:49.010" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfp", `TNSName`="AT2020adfp", `decDeg`="16.877447", `decSex`="+16:52:38.81", `discDate`="2020-12-15 12:57:41.184", `discMag`="19.91", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acykoxy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfp", `raDeg`="221.9542083", `raSex`="14:47:49.010", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfo" ,"AT2020adfo" ,"10.04067" ,"+10:02:26.40" ,"2020-12-15 12:38:38.112" ,"19.6" ,"g-ZTF" ,"ZTF" ,"ZTF20acxtdcl" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfo" ,"183.8678583" ,"12:15:28.286" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfo", `TNSName`="AT2020adfo", `decDeg`="10.04067", `decSex`="+10:02:26.40", `discDate`="2020-12-15 12:38:38.112", `discMag`="19.6", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxtdcl", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfo", `raDeg`="183.8678583", `raSex`="12:15:28.286", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfn" ,"AT2020adfn" ,"-1.417592" ,"-01:25:03.33" ,"2020-12-15 12:34:30.144" ,"19.57" ,"g-ZTF" ,"ZTF" ,"ZTF20acxsnpk" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfn" ,"180.16552917" ,"12:00:39.727" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfn", `TNSName`="AT2020adfn", `decDeg`="-1.417592", `decSex`="-01:25:03.33", `discDate`="2020-12-15 12:34:30.144", `discMag`="19.57", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxsnpk", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfn", `raDeg`="180.16552917", `raSex`="12:00:39.727", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfm" ,"AT2020adfm" ,"33.865372" ,"+33:51:55.34" ,"2020-12-17 12:22:18.336" ,"19.45" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acliffw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfm" ,"177.3603167" ,"11:49:26.476" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfm", `TNSName`="AT2020adfm", `decDeg`="33.865372", `decSex`="+33:51:55.34", `discDate`="2020-12-17 12:22:18.336", `discMag`="19.45", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acliffw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfm", `raDeg`="177.3603167", `raSex`="11:49:26.476", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfl" ,"AT2020adfl" ,"1.638739" ,"+01:38:19.46" ,"2020-12-11 10:39:06.048" ,"20.33" ,"g-ZTF" ,"ZTF" ,"ZTF20acwxwcd" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfl" ,"155.83547917" ,"10:23:20.515" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfl", `TNSName`="AT2020adfl", `decDeg`="1.638739", `decSex`="+01:38:19.46", `discDate`="2020-12-11 10:39:06.048", `discMag`="20.33", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwxwcd", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfl", `raDeg`="155.83547917", `raSex`="10:23:20.515", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfk" ,"AT2020adfk" ,"-27.792681" ,"-27:47:33.65" ,"2020-12-19 04:43:40.800" ,"18.76" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fur" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfk" ,"190.57279166666666" ,"12:42:17.470" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfk", `TNSName`="AT2020adfk", `decDeg`="-27.792681", `decSex`="-27:47:33.65", `discDate`="2020-12-19 04:43:40.800", `discMag`="18.76", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fur", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfk", `raDeg`="190.57279166666666", `raSex`="12:42:17.470", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfj" ,"AT2020adfj" ,"76.84617" ,"+76:50:46.20" ,"2020-12-20 08:44:09.600" ,"17.81" ,"g-ZTF" ,"ZTF" ,"ZTF20acyqzeu" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfj" ,"161.977125" ,"10:47:54.510" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfj", `TNSName`="AT2020adfj", `decDeg`="76.84617", `decSex`="+76:50:46.20", `discDate`="2020-12-20 08:44:09.600", `discMag`="17.81", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyqzeu", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfj", `raDeg`="161.977125", `raSex`="10:47:54.510", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfi" ,"AT2020adfi" ,"8.394431" ,"+08:23:39.95" ,"2020-12-06 08:21:07.200" ,"21.67" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mli" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfi" ,"28.343670833333334" ,"01:53:22.481" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfi", `TNSName`="AT2020adfi", `decDeg`="8.394431", `decSex`="+08:23:39.95", `discDate`="2020-12-06 08:21:07.200", `discMag`="21.67", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mli", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfi", `raDeg`="28.343670833333334", `raSex`="01:53:22.481", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfh" ,"AT2020adfh" ,"24.77397" ,"+24:46:26.30" ,"2020-12-11 12:25:12.864" ,"20.36" ,"r-ZTF" ,"ZTF" ,"ZTF20acwylnq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfh" ,"170.660917" ,"11:22:38.620" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfh", `TNSName`="AT2020adfh", `decDeg`="24.77397", `decSex`="+24:46:26.30", `discDate`="2020-12-11 12:25:12.864", `discMag`="20.36", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwylnq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfh", `raDeg`="170.660917", `raSex`="11:22:38.620", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfg" ,"AT2020adfg" ,"8.467019" ,"+08:28:01.27" ,"2020-12-15 07:47:33.216" ,"20.03" ,"g-ZTF" ,"ZTF" ,"ZTF20acxglpx" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfg" ,"71.3565667" ,"04:45:25.576" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfg", `TNSName`="AT2020adfg", `decDeg`="8.467019", `decSex`="+08:28:01.27", `discDate`="2020-12-15 07:47:33.216", `discMag`="20.03", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxglpx", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfg", `raDeg`="71.3565667", `raSex`="04:45:25.576", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adff" ,"AT2020adff" ,"7.442186" ,"+07:26:31.87" ,"2020-12-11 07:17:44.736" ,"19.95" ,"r-ZTF" ,"ZTF" ,"ZTF20acwjrim" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adff" ,"74.635475" ,"04:58:32.514" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adff", `TNSName`="AT2020adff", `decDeg`="7.442186", `decSex`="+07:26:31.87", `discDate`="2020-12-11 07:17:44.736", `discMag`="19.95", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwjrim", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adff", `raDeg`="74.635475", `raSex`="04:58:32.514", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfe" ,"AT2020adfe" ,"23.952503" ,"+23:57:09.01" ,"2020-12-16 03:07:12.000" ,"19.82" ,"r-ZTF" ,"ZTF" ,"ZTF20acxncha" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfe" ,"4.9795583" ,"00:19:55.094" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfe", `TNSName`="AT2020adfe", `decDeg`="23.952503", `decSex`="+23:57:09.01", `discDate`="2020-12-16 03:07:12.000", `discMag`="19.82", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxncha", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfe", `raDeg`="4.9795583", `raSex`="00:19:55.094", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfd" ,"AT2020adfd" ,"-43.26497" ,"-43:15:53.90" ,"2020-12-17 05:55:12.288" ,"17.3" ,"Clear-" ,"MASTER" ,"MASTER OT J071942.54-431553.9" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfd" ,"109.92725" ,"07:19:42.540" ,"MASTER" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfd", `TNSName`="AT2020adfd", `decDeg`="-43.26497", `decSex`="-43:15:53.90", `discDate`="2020-12-17 05:55:12.288", `discMag`="17.3", `discMagFilter`="Clear-", `discSurvey`="MASTER", `discoveryName`="MASTER OT J071942.54-431553.9", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfd", `raDeg`="109.92725", `raSex`="07:19:42.540", `reportingSurvey`="MASTER", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfc" ,"AT2020adfc" ,"26.01953" ,"+26:01:10.30" ,"2020-12-19 05:03:21.888" ,"11.9" ,"Clear-" ,"MASTER" ,"MASTER OT J060948.76+260110.3" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfc" ,"92.453167" ,"06:09:48.760" ,"MASTER" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfc", `TNSName`="AT2020adfc", `decDeg`="26.01953", `decSex`="+26:01:10.30", `discDate`="2020-12-19 05:03:21.888", `discMag`="11.9", `discMagFilter`="Clear-", `discSurvey`="MASTER", `discoveryName`="MASTER OT J060948.76+260110.3", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfc", `raDeg`="92.453167", `raSex`="06:09:48.760", `reportingSurvey`="MASTER", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfb" ,"AT2020adfb" ,"9.024964" ,"+09:01:29.87" ,"2020-12-19 05:29:01.000" ,"19.7616" ,"g-ZTF" ,"ZTF" ,"ZTF20acyntiu" ,"WISEA J024234.88+090126.6" ,null ,"http://wis-tns.weizmann.ac.il/object/2020adfb" ,"40.64607917" ,"02:42:35.059" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfb", `TNSName`="AT2020adfb", `decDeg`="9.024964", `decSex`="+09:01:29.87", `discDate`="2020-12-19 05:29:01.000", `discMag`="19.7616", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyntiu", `hostName`="WISEA J024234.88+090126.6", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfb", `raDeg`="40.64607917", `raSex`="02:42:35.059", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adfa" ,"AT2020adfa" ,"40.9325" ,"+40:55:57.00" ,"2020-12-19 13:10:20.001" ,"19.4256" ,"r-ZTF" ,"ZTF" ,"ZTF20acyrupb" ,"WISEA J153551.88+405558.7" ,"0.033059" ,"http://wis-tns.weizmann.ac.il/object/2020adfa" ,"233.96714166666666" ,"15:35:52.114" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfa", `TNSName`="AT2020adfa", `decDeg`="40.9325", `decSex`="+40:55:57.00", `discDate`="2020-12-19 13:10:20.001", `discMag`="19.4256", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyrupb", `hostName`="WISEA J153551.88+405558.7", `hostRedshift`="0.033059", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adfa", `raDeg`="233.96714166666666", `raSex`="15:35:52.114", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adez" ,"AT2020adez" ,"36.9334" ,"+36:56:00.24" ,"2020-12-19 07:47:39.998" ,"19.9794" ,"r-ZTF" ,"ZTF" ,"ZTF20acypagb" ,"SDSS J071800.79+365559.9" ,"0.191" ,"http://wis-tns.weizmann.ac.il/object/2020adez" ,"109.50385417" ,"07:18:00.925" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adez", `TNSName`="AT2020adez", `decDeg`="36.9334", `decSex`="+36:56:00.24", `discDate`="2020-12-19 07:47:39.998", `discMag`="19.9794", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acypagb", `hostName`="SDSS J071800.79+365559.9", `hostRedshift`="0.191", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adez", `raDeg`="109.50385417", `raSex`="07:18:00.925", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adey" ,"AT2020adey" ,"59.403794" ,"+59:24:13.66" ,"2020-12-19 12:10:34.003" ,"19.4806" ,"g-ZTF" ,"ZTF" ,"ZTF20acyroek" ,"MCG +10-23-012" ,"0.0602" ,"http://wis-tns.weizmann.ac.il/object/2020adey" ,"239.75827917" ,"15:59:01.987" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adey", `TNSName`="AT2020adey", `decDeg`="59.403794", `decSex`="+59:24:13.66", `discDate`="2020-12-19 12:10:34.003", `discMag`="19.4806", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyroek", `hostName`="MCG +10-23-012", `hostRedshift`="0.0602", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adey", `raDeg`="239.75827917", `raSex`="15:59:01.987", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adex" ,"AT2020adex" ,"61.001506" ,"+61:00:05.42" ,"2020-12-19 12:10:34.003" ,"18.9701" ,"g-ZTF" ,"ZTF" ,"ZTF20acyrody" ,"SDSS J153003.58+610008.3" ,"0.092" ,"http://wis-tns.weizmann.ac.il/object/2020adex" ,"232.51442917" ,"15:30:03.463" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adex", `TNSName`="AT2020adex", `decDeg`="61.001506", `decSex`="+61:00:05.42", `discDate`="2020-12-19 12:10:34.003", `discMag`="18.9701", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyrody", `hostName`="SDSS J153003.58+610008.3", `hostRedshift`="0.092", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adex", `raDeg`="232.51442917", `raSex`="15:30:03.463", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adew" ,"AT2020adew" ,"39.797367" ,"+39:47:50.52" ,"2020-12-19 09:52:49.999" ,"19.9508" ,"r-ZTF" ,"ZTF" ,"ZTF20acyqnim" ,"SDSS J091428.49+394750.2" ,"0.672" ,"http://wis-tns.weizmann.ac.il/object/2020adew" ,"138.61874583333332" ,"09:14:28.499" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adew", `TNSName`="AT2020adew", `decDeg`="39.797367", `decSex`="+39:47:50.52", `discDate`="2020-12-19 09:52:49.999", `discMag`="19.9508", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyqnim", `hostName`="SDSS J091428.49+394750.2", `hostRedshift`="0.672", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adew", `raDeg`="138.61874583333332", `raSex`="09:14:28.499", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adev" ,"AT2020adev" ,"35.473208" ,"+35:28:23.55" ,"2020-12-19 12:07:52.003" ,"18.7486" ,"g-ZTF" ,"ZTF" ,"ZTF20acyrodz" ,"SDSS J155347.27+352827.6" ,"0.072" ,"http://wis-tns.weizmann.ac.il/object/2020adev" ,"238.4493375" ,"15:53:47.841" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adev", `TNSName`="AT2020adev", `decDeg`="35.473208", `decSex`="+35:28:23.55", `discDate`="2020-12-19 12:07:52.003", `discMag`="18.7486", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyrodz", `hostName`="SDSS J155347.27+352827.6", `hostRedshift`="0.072", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adev", `raDeg`="238.4493375", `raSex`="15:53:47.841", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adeu" ,"AT2020adeu" ,"19.218781" ,"+19:13:07.61" ,"2020-12-19 11:36:27.999" ,"19.9268" ,"g-ZTF" ,"ZTF" ,"ZTF20acyrhbo" ,"SDSS J093946.33+191309.0" ,"0.073" ,"http://wis-tns.weizmann.ac.il/object/2020adeu" ,"144.9422083" ,"09:39:46.130" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeu", `TNSName`="AT2020adeu", `decDeg`="19.218781", `decSex`="+19:13:07.61", `discDate`="2020-12-19 11:36:27.999", `discMag`="19.9268", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyrhbo", `hostName`="SDSS J093946.33+191309.0", `hostRedshift`="0.073", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adeu", `raDeg`="144.9422083", `raSex`="09:39:46.130", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adet" ,"AT2020adet" ,"12.937247" ,"+12:56:14.09" ,"2020-12-19 12:03:03.004" ,"20.3201" ,"g-ZTF" ,"ZTF" ,"ZTF20acyrsry" ,"WISEA J124959.08+125609.9" ,"0.083072" ,"http://wis-tns.weizmann.ac.il/object/2020adet" ,"192.49674166666668" ,"12:49:59.218" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adet", `TNSName`="AT2020adet", `decDeg`="12.937247", `decSex`="+12:56:14.09", `discDate`="2020-12-19 12:03:03.004", `discMag`="20.3201", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyrsry", `hostName`="WISEA J124959.08+125609.9", `hostRedshift`="0.083072", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adet", `raDeg`="192.49674166666668", `raSex`="12:49:59.218", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020ades" ,"AT2020ades" ,"13.275622" ,"+13:16:32.24" ,"2020-12-18 11:40:33.004" ,"20.3631" ,"g-ZTF" ,"ZTF" ,"ZTF20acymbxe" ,"WISEA J092353.10+131630.0" ,"0.080046" ,"http://wis-tns.weizmann.ac.il/object/2020ades" ,"140.970825" ,"09:23:52.998" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ades", `TNSName`="AT2020ades", `decDeg`="13.275622", `decSex`="+13:16:32.24", `discDate`="2020-12-18 11:40:33.004", `discMag`="20.3631", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acymbxe", `hostName`="WISEA J092353.10+131630.0", `hostRedshift`="0.080046", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020ades", `raDeg`="140.970825", `raSex`="09:23:52.998", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020ader" ,"AT2020ader" ,"14.31561" ,"+14:18:56.20" ,"2020-12-16 02:35:21.998" ,"20.205" ,"r-ZTF" ,"ZTF" ,"ZTF20acydasr" ,"SDSS J234844.75+141851.2" ,"0.096" ,"http://wis-tns.weizmann.ac.il/object/2020ader" ,"357.18536666666665" ,"23:48:44.488" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ader", `TNSName`="AT2020ader", `decDeg`="14.31561", `decSex`="+14:18:56.20", `discDate`="2020-12-16 02:35:21.998", `discMag`="20.205", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acydasr", `hostName`="SDSS J234844.75+141851.2", `hostRedshift`="0.096", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020ader", `raDeg`="357.18536666666665", `raSex`="23:48:44.488", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adeq" ,"AT2020adeq" ,"-18.1177" ,"-18:07:03.72" ,"2020-12-16 04:33:38.998" ,"20.0231" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acynllu" ,"WISEA J011305.44-180700.3" ,null ,"http://wis-tns.weizmann.ac.il/object/2020adeq" ,"18.273525" ,"01:13:05.646" ,"ALeRCE, ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeq", `TNSName`="AT2020adeq", `decDeg`="-18.1177", `decSex`="-18:07:03.72", `discDate`="2020-12-16 04:33:38.998", `discMag`="20.0231", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acynllu", `hostName`="WISEA J011305.44-180700.3", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adeq", `raDeg`="18.273525", `raSex`="01:13:05.646", `reportingSurvey`="ALeRCE, ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adep" ,"AT2020adep" ,"23.9479" ,"+23:56:52.44" ,"2020-12-16 04:10:06.004" ,"20.1901" ,"g-ZTF" ,"ZTF" ,"ZTF20acymxip" ,"SDSS J233242.45+235655.7" ,"0.115" ,"http://wis-tns.weizmann.ac.il/object/2020adep" ,"353.1762417" ,"23:32:42.298" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adep", `TNSName`="AT2020adep", `decDeg`="23.9479", `decSex`="+23:56:52.44", `discDate`="2020-12-16 04:10:06.004", `discMag`="20.1901", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acymxip", `hostName`="SDSS J233242.45+235655.7", `hostRedshift`="0.115", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adep", `raDeg`="353.1762417", `raSex`="23:32:42.298", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adeo" ,"AT2020adeo" ,"23.550422" ,"+23:33:01.52" ,"2020-12-16 05:16:12.999" ,"20.3341" ,"r-ZTF" ,"ZTF" ,"ZTF20acynqpx" ,"IC 0189" ,"0.041185" ,"http://wis-tns.weizmann.ac.il/object/2020adeo" ,"30.4742375" ,"02:01:53.817" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeo", `TNSName`="AT2020adeo", `decDeg`="23.550422", `decSex`="+23:33:01.52", `discDate`="2020-12-16 05:16:12.999", `discMag`="20.3341", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acynqpx", `hostName`="IC 0189", `hostRedshift`="0.041185", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adeo", `raDeg`="30.4742375", `raSex`="02:01:53.817", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aden" ,"AT2020aden" ,"-15.405492" ,"-15:24:19.77" ,"2020-12-16 03:30:34.004" ,"19.6701" ,"r-ZTF" ,"ZTF" ,"ZTF20acynlkj" ,"WISEA J010801.10-152419.6" ,"0.055008" ,"http://wis-tns.weizmann.ac.il/object/2020aden" ,"17.004170833333333" ,"01:08:01.001" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aden", `TNSName`="AT2020aden", `decDeg`="-15.405492", `decSex`="-15:24:19.77", `discDate`="2020-12-16 03:30:34.004", `discMag`="19.6701", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acynlkj", `hostName`="WISEA J010801.10-152419.6", `hostRedshift`="0.055008", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aden", `raDeg`="17.004170833333333", `raSex`="01:08:01.001", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adem" ,"AT2020adem" ,"53.772447" ,"+53:46:20.81" ,"2020-12-16 09:27:05.996" ,"20.3559" ,"r-ZTF" ,"ZTF" ,"ZTF20acxxwun" ,"WISEA J082424.36+534620.8" ,"0.099141" ,"http://wis-tns.weizmann.ac.il/object/2020adem" ,"126.10125" ,"08:24:24.300" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adem", `TNSName`="AT2020adem", `decDeg`="53.772447", `decSex`="+53:46:20.81", `discDate`="2020-12-16 09:27:05.996", `discMag`="20.3559", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxxwun", `hostName`="WISEA J082424.36+534620.8", `hostRedshift`="0.099141", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adem", `raDeg`="126.10125", `raSex`="08:24:24.300", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adel" ,"AT2020adel" ,"50.735467" ,"+50:44:07.68" ,"2020-12-16 08:17:01.003" ,"20.5077" ,"g-ZTF" ,"ZTF" ,"ZTF20acyoltw" ,"WISEA J070050.82+504407.0" ,null ,"http://wis-tns.weizmann.ac.il/object/2020adel" ,"105.2116333" ,"07:00:50.792" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adel", `TNSName`="AT2020adel", `decDeg`="50.735467", `decSex`="+50:44:07.68", `discDate`="2020-12-16 08:17:01.003", `discMag`="20.5077", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyoltw", `hostName`="WISEA J070050.82+504407.0", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adel", `raDeg`="105.2116333", `raSex`="07:00:50.792", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adek" ,"AT2020adek" ,"79.649736" ,"+79:38:59.05" ,"2020-12-15 09:20:55.997" ,"20.6508" ,"g-ZTF" ,"ZTF" ,"ZTF20acyqlyg" ,"WISEA J091936.55+793856.4" ,null ,"http://wis-tns.weizmann.ac.il/object/2020adek" ,"139.8980667" ,"09:19:35.536" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adek", `TNSName`="AT2020adek", `decDeg`="79.649736", `decSex`="+79:38:59.05", `discDate`="2020-12-15 09:20:55.997", `discMag`="20.6508", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyqlyg", `hostName`="WISEA J091936.55+793856.4", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adek", `raDeg`="139.8980667", `raSex`="09:19:35.536", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adej" ,"AT2020adej" ,"62.044094" ,"+62:02:38.74" ,"2020-12-07 11:44:09.600" ,"20.96" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mlh" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adej" ,"135.35414583" ,"09:01:24.995" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adej", `TNSName`="AT2020adej", `decDeg`="62.044094", `decSex`="+62:02:38.74", `discDate`="2020-12-07 11:44:09.600", `discMag`="20.96", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mlh", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adej", `raDeg`="135.35414583", `raSex`="09:01:24.995", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adei" ,"AT2020adei" ,"-6.207403" ,"-06:12:26.65" ,"2020-12-07 07:03:21.600" ,"20.58" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mlg" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adei" ,"34.00887083" ,"02:16:02.129" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adei", `TNSName`="AT2020adei", `decDeg`="-6.207403", `decSex`="-06:12:26.65", `discDate`="2020-12-07 07:03:21.600", `discMag`="20.58", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mlg", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adei", `raDeg`="34.00887083", `raSex`="02:16:02.129", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adeh" ,"AT2020adeh" ,"5.788886" ,"+05:47:19.99" ,"2020-12-08 08:48:28.800" ,"22.14" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mlf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adeh" ,"60.0739083" ,"04:00:17.738" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeh", `TNSName`="AT2020adeh", `decDeg`="5.788886", `decSex`="+05:47:19.99", `discDate`="2020-12-08 08:48:28.800", `discMag`="22.14", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mlf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adeh", `raDeg`="60.0739083", `raSex`="04:00:17.738", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adeg" ,"AT2020adeg" ,"-10.945622" ,"-10:56:44.24" ,"2020-12-07 08:00:57.600" ,"20.59" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mle" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adeg" ,"47.6073875" ,"03:10:25.773" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeg", `TNSName`="AT2020adeg", `decDeg`="-10.945622", `decSex`="-10:56:44.24", `discDate`="2020-12-07 08:00:57.600", `discMag`="20.59", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mle", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adeg", `raDeg`="47.6073875", `raSex`="03:10:25.773", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adef" ,"AT2020adef" ,"-10.63165" ,"-10:37:53.94" ,"2020-12-06 06:48:57.600" ,"21.72" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mld" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adef" ,"15.7539375" ,"01:03:00.945" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adef", `TNSName`="AT2020adef", `decDeg`="-10.63165", `decSex`="-10:37:53.94", `discDate`="2020-12-06 06:48:57.600", `discMag`="21.72", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mld", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adef", `raDeg`="15.7539375", `raSex`="01:03:00.945", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adee" ,"AT2020adee" ,"8.726206" ,"+08:43:34.34" ,"2020-12-06 07:56:38.400" ,"20.83" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mlc" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adee" ,"20.3596125" ,"01:21:26.307" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adee", `TNSName`="AT2020adee", `decDeg`="8.726206", `decSex`="+08:43:34.34", `discDate`="2020-12-06 07:56:38.400", `discMag`="20.83", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mlc", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adee", `raDeg`="20.3596125", `raSex`="01:21:26.307", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aded" ,"AT2020aded" ,"63.045011" ,"+63:02:42.04" ,"2020-12-07 11:47:02.400" ,"20.55" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mlb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aded" ,"128.6579" ,"08:34:37.896" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aded", `TNSName`="AT2020aded", `decDeg`="63.045011", `decSex`="+63:02:42.04", `discDate`="2020-12-07 11:47:02.400", `discMag`="20.55", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mlb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aded", `raDeg`="128.6579", `raSex`="08:34:37.896", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adec" ,"AT2020adec" ,"-2.534711" ,"-02:32:04.96" ,"2020-12-07 07:04:48.000" ,"20.48" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adec" ,"35.0264375" ,"02:20:06.345" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adec", `TNSName`="AT2020adec", `decDeg`="-2.534711", `decSex`="-02:32:04.96", `discDate`="2020-12-07 07:04:48.000", `discMag`="20.48", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adec", `raDeg`="35.0264375", `raSex`="02:20:06.345", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adeb" ,"AT2020adeb" ,"27.326731" ,"+27:19:36.23" ,"2020-12-07 05:45:36.000" ,"21.68" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mky" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adeb" ,"35.252525" ,"02:21:00.606" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeb", `TNSName`="AT2020adeb", `decDeg`="27.326731", `decSex`="+27:19:36.23", `discDate`="2020-12-07 05:45:36.000", `discMag`="21.68", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mky", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adeb", `raDeg`="35.252525", `raSex`="02:21:00.606", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adea" ,"AT2020adea" ,"4.949606" ,"+04:56:58.58" ,"2020-12-12 05:00:57.600" ,"20.98" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adea" ,"1.1068166666666666" ,"00:04:25.636" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adea", `TNSName`="AT2020adea", `decDeg`="4.949606", `decSex`="+04:56:58.58", `discDate`="2020-12-12 05:00:57.600", `discMag`="20.98", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adea", `raDeg`="1.1068166666666666", `raSex`="00:04:25.636", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addz" ,"AT2020addz" ,"3.783969" ,"+03:47:02.29" ,"2020-12-12 05:08:09.600" ,"21.03" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addz" ,"6.72012917" ,"00:26:52.831" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addz", `TNSName`="AT2020addz", `decDeg`="3.783969", `decSex`="+03:47:02.29", `discDate`="2020-12-12 05:08:09.600", `discMag`="21.03", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addz", `raDeg`="6.72012917", `raSex`="00:26:52.831", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addy" ,"AT2020addy" ,"-14.217094" ,"-14:13:01.54" ,"2020-12-12 14:35:31.200" ,"21.17" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mku" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addy" ,"171.87383333333332" ,"11:27:29.720" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addy", `TNSName`="AT2020addy", `decDeg`="-14.217094", `decSex`="-14:13:01.54", `discDate`="2020-12-12 14:35:31.200", `discMag`="21.17", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mku", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addy", `raDeg`="171.87383333333332", `raSex`="11:27:29.720", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addx" ,"AT2020addx" ,"-11.911836" ,"-11:54:42.61" ,"2020-12-07 08:16:47.000" ,"21.39" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkt" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addx" ,"59.420775" ,"03:57:40.986" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addx", `TNSName`="AT2020addx", `decDeg`="-11.911836", `decSex`="-11:54:42.61", `discDate`="2020-12-07 08:16:47.000", `discMag`="21.39", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkt", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addx", `raDeg`="59.420775", `raSex`="03:57:40.986", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addw" ,"AT2020addw" ,"-15.102992" ,"-15:06:10.77" ,"2020-12-06 06:34:33.600" ,"21.58" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mks" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addw" ,"20.49704583" ,"01:21:59.291" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addw", `TNSName`="AT2020addw", `decDeg`="-15.102992", `decSex`="-15:06:10.77", `discDate`="2020-12-06 06:34:33.600", `discMag`="21.58", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mks", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addw", `raDeg`="20.49704583", `raSex`="01:21:59.291", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addv" ,"AT2020addv" ,"-13.029653" ,"-13:01:46.75" ,"2020-12-06 06:27:21.600" ,"21.54" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addv" ,"15.28509583" ,"01:01:08.423" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addv", `TNSName`="AT2020addv", `decDeg`="-13.029653", `decSex`="-13:01:46.75", `discDate`="2020-12-06 06:27:21.600", `discMag`="21.54", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addv", `raDeg`="15.28509583", `raSex`="01:01:08.423", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addu" ,"AT2020addu" ,"24.902672" ,"+24:54:09.62" ,"2020-12-12 07:33:36.000" ,"20.9" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkp" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addu" ,"19.23539583" ,"01:16:56.495" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addu", `TNSName`="AT2020addu", `decDeg`="24.902672", `decSex`="+24:54:09.62", `discDate`="2020-12-12 07:33:36.000", `discMag`="20.9", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkp", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addu", `raDeg`="19.23539583", `raSex`="01:16:56.495", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addt" ,"AT2020addt" ,"-1.520364" ,"-01:31:13.31" ,"2020-12-10 07:55:12.000" ,"21.01" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mko" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addt" ,"52.71840417" ,"03:30:52.417" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addt", `TNSName`="AT2020addt", `decDeg`="-1.520364", `decSex`="-01:31:13.31", `discDate`="2020-12-10 07:55:12.000", `discMag`="21.01", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mko", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addt", `raDeg`="52.71840417", `raSex`="03:30:52.417", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adds" ,"AT2020adds" ,"28.018225" ,"+28:01:05.61" ,"2020-12-07 05:24:00.000" ,"21.58" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkk" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adds" ,"31.8315625" ,"02:07:19.575" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adds", `TNSName`="AT2020adds", `decDeg`="28.018225", `decSex`="+28:01:05.61", `discDate`="2020-12-07 05:24:00.000", `discMag`="21.58", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkk", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adds", `raDeg`="31.8315625", `raSex`="02:07:19.575", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addr" ,"AT2020addr" ,"55.984458" ,"+55:59:04.05" ,"2020-11-17 10:51:18.720" ,"19.7628" ,"g-ZTF" ,"ZTF" ,"ZTF20acyjafq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addr" ,"121.22002083" ,"08:04:52.805" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addr", `TNSName`="AT2020addr", `decDeg`="55.984458", `decSex`="+55:59:04.05", `discDate`="2020-11-17 10:51:18.720", `discMag`="19.7628", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyjafq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addr", `raDeg`="121.22002083", `raSex`="08:04:52.805", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addq" ,"AT2020addq" ,"41.191703" ,"+41:11:30.13" ,"2020-12-12 05:10:26.976" ,"20.462" ,"r-ZTF" ,"ZTF" ,"ZTF20acydtwu" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addq" ,"10.853770833333334" ,"00:43:24.905" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addq", `TNSName`="AT2020addq", `decDeg`="41.191703", `decSex`="+41:11:30.13", `discDate`="2020-12-12 05:10:26.976", `discMag`="20.462", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acydtwu", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addq", `raDeg`="10.853770833333334", `raSex`="00:43:24.905", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addp" ,"AT2020addp" ,"-8.420239" ,"-08:25:12.86" ,"2020-12-16 04:35:00.672" ,"19.8115" ,"g-ZTF" ,"ZTF" ,"ZTF20acycunv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addp" ,"6.434675" ,"00:25:44.322" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addp", `TNSName`="AT2020addp", `decDeg`="-8.420239", `decSex`="-08:25:12.86", `discDate`="2020-12-16 04:35:00.672", `discMag`="19.8115", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acycunv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addp", `raDeg`="6.434675", `raSex`="00:25:44.322", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addo" ,"AT2020addo" ,"-1.870786" ,"-01:52:14.83" ,"2020-12-06 05:31:12.000" ,"20.51" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addo" ,"344.09087083" ,"22:56:21.809" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addo", `TNSName`="AT2020addo", `decDeg`="-1.870786", `decSex`="-01:52:14.83", `discDate`="2020-12-06 05:31:12.000", `discMag`="20.51", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addo", `raDeg`="344.09087083", `raSex`="22:56:21.809", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addn" ,"AT2020addn" ,"-6.095919" ,"-06:05:45.31" ,"2020-12-06 05:34:04.800" ,"20.23" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mki" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addn" ,"338.8115875" ,"22:35:14.781" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addn", `TNSName`="AT2020addn", `decDeg`="-6.095919", `decSex`="-06:05:45.31", `discDate`="2020-12-06 05:34:04.800", `discMag`="20.23", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mki", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addn", `raDeg`="338.8115875", `raSex`="22:35:14.781", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addm" ,"AT2020addm" ,"-6.892625" ,"-06:53:33.45" ,"2020-12-06 05:51:21.600" ,"21.6" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkh" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addm" ,"338.9091875" ,"22:35:38.205" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addm", `TNSName`="AT2020addm", `decDeg`="-6.892625", `decSex`="-06:53:33.45", `discDate`="2020-12-06 05:51:21.600", `discMag`="21.6", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkh", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addm", `raDeg`="338.9091875", `raSex`="22:35:38.205", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addl" ,"AT2020addl" ,"26.696275" ,"+26:41:46.59" ,"2020-12-07 05:26:52.800" ,"20.39" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkg" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addl" ,"34.4263167" ,"02:17:42.316" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addl", `TNSName`="AT2020addl", `decDeg`="26.696275", `decSex`="+26:41:46.59", `discDate`="2020-12-07 05:26:52.800", `discMag`="20.39", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkg", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addl", `raDeg`="34.4263167", `raSex`="02:17:42.316", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addk" ,"AT2020addk" ,"-10.486772" ,"-10:29:12.38" ,"2020-12-06 06:40:19.200" ,"21.52" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addk" ,"24.9460875" ,"01:39:47.061" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addk", `TNSName`="AT2020addk", `decDeg`="-10.486772", `decSex`="-10:29:12.38", `discDate`="2020-12-06 06:40:19.200", `discMag`="21.52", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addk", `raDeg`="24.9460875", `raSex`="01:39:47.061", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addj" ,"AT2020addj" ,"-9.221308" ,"-09:13:16.71" ,"2020-12-07 08:05:16.800" ,"21.2" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkc" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addj" ,"48.79917916666667" ,"03:15:11.803" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addj", `TNSName`="AT2020addj", `decDeg`="-9.221308", `decSex`="-09:13:16.71", `discDate`="2020-12-07 08:05:16.800", `discMag`="21.2", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkc", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addj", `raDeg`="48.79917916666667", `raSex`="03:15:11.803", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addi" ,"AT2020addi" ,"18.853178" ,"+18:51:11.44" ,"2020-12-12 07:30:43.200" ,"20.74" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mkb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addi" ,"18.750420833333333" ,"01:15:00.101" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addi", `TNSName`="AT2020addi", `decDeg`="18.853178", `decSex`="+18:51:11.44", `discDate`="2020-12-12 07:30:43.200", `discMag`="20.74", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mkb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addi", `raDeg`="18.750420833333333", `raSex`="01:15:00.101", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addh" ,"AT2020addh" ,"-1.448822" ,"-01:26:55.76" ,"2020-12-07 07:13:26.400" ,"21.93" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mka" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addh" ,"41.11747917" ,"02:44:28.195" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addh", `TNSName`="AT2020addh", `decDeg`="-1.448822", `decSex`="-01:26:55.76", `discDate`="2020-12-07 07:13:26.400", `discMag`="21.93", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mka", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addh", `raDeg`="41.11747917", `raSex`="02:44:28.195", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addg" ,"AT2020addg" ,"-19.953969" ,"-19:57:14.29" ,"2020-12-12 09:04:19.200" ,"21.48" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addg" ,"74.52705416666667" ,"04:58:06.493" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addg", `TNSName`="AT2020addg", `decDeg`="-19.953969", `decSex`="-19:57:14.29", `discDate`="2020-12-12 09:04:19.200", `discMag`="21.48", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addg", `raDeg`="74.52705416666667", `raSex`="04:58:06.493", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addf" ,"AT2020addf" ,"-14.279328" ,"-14:16:45.58" ,"2020-12-12 14:31:12.000" ,"20.79" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjx" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addf" ,"177.6966333" ,"11:50:47.192" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addf", `TNSName`="AT2020addf", `decDeg`="-14.279328", `decSex`="-14:16:45.58", `discDate`="2020-12-12 14:31:12.000", `discMag`="20.79", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjx", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addf", `raDeg`="177.6966333", `raSex`="11:50:47.192", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adde" ,"AT2020adde" ,"-1.449336" ,"-01:26:57.61" ,"2020-12-06 05:28:19.200" ,"20.98" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adde" ,"336.969775" ,"22:27:52.746" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adde", `TNSName`="AT2020adde", `decDeg`="-1.449336", `decSex`="-01:26:57.61", `discDate`="2020-12-06 05:28:19.200", `discMag`="20.98", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adde", `raDeg`="336.969775", `raSex`="22:27:52.746", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addd" ,"AT2020addd" ,"16.0571" ,"+16:03:25.56" ,"2020-12-08 06:05:45.600" ,"21.58" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mju" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addd" ,"45.9668875" ,"03:03:52.053" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addd", `TNSName`="AT2020addd", `decDeg`="16.0571", `decSex`="+16:03:25.56", `discDate`="2020-12-08 06:05:45.600", `discMag`="21.58", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mju", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addd", `raDeg`="45.9668875", `raSex`="03:03:52.053", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addc" ,"AT2020addc" ,"-8.282742" ,"-08:16:57.87" ,"2020-12-07 08:15:21.600" ,"21.51" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjt" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addc" ,"59.84337917" ,"03:59:22.411" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addc", `TNSName`="AT2020addc", `decDeg`="-8.282742", `decSex`="-08:16:57.87", `discDate`="2020-12-07 08:15:21.600", `discMag`="21.51", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjt", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addc", `raDeg`="59.84337917", `raSex`="03:59:22.411", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020addb" ,"AT2020addb" ,"23.643617" ,"+23:38:37.02" ,"2020-12-06 12:18:54.432" ,"19.955" ,"g-ZTF" ,"ZTF" ,"ZTF20acvkvfj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020addb" ,"182.97178333333332" ,"12:11:53.228" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addb", `TNSName`="AT2020addb", `decDeg`="23.643617", `decSex`="+23:38:37.02", `discDate`="2020-12-06 12:18:54.432", `discMag`="19.955", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acvkvfj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020addb", `raDeg`="182.97178333333332", `raSex`="12:11:53.228", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adda" ,"AT2020adda" ,"-11.314017" ,"-11:18:50.46" ,"2020-12-10 10:26:24.000" ,"20.69" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjs" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adda" ,"78.2805917" ,"05:13:07.342" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adda", `TNSName`="AT2020adda", `decDeg`="-11.314017", `decSex`="-11:18:50.46", `discDate`="2020-12-10 10:26:24.000", `discMag`="20.69", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjs", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adda", `raDeg`="78.2805917", `raSex`="05:13:07.342", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcz" ,"AT2020adcz" ,"-9.763039" ,"-09:45:46.94" ,"2020-12-06 06:30:14.400" ,"20.82" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjr" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcz" ,"14.7945917" ,"00:59:10.702" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcz", `TNSName`="AT2020adcz", `decDeg`="-9.763039", `decSex`="-09:45:46.94", `discDate`="2020-12-06 06:30:14.400", `discMag`="20.82", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjr", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcz", `raDeg`="14.7945917", `raSex`="00:59:10.702", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcy" ,"AT2020adcy" ,"-40.489981" ,"-40:29:23.93" ,"2020-12-18 13:24:57.600" ,"18.89" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fuq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcy" ,"130.6177083" ,"08:42:28.250" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcy", `TNSName`="AT2020adcy", `decDeg`="-40.489981", `decSex`="-40:29:23.93", `discDate`="2020-12-18 13:24:57.600", `discMag`="18.89", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fuq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcy", `raDeg`="130.6177083", `raSex`="08:42:28.250", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcx" ,"AT2020adcx" ,"38.16914" ,"+38:10:08.90" ,"2020-12-18 02:36:57.600" ,"14.06" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fup" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcx" ,"306.217917" ,"20:24:52.300" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcx", `TNSName`="AT2020adcx", `decDeg`="38.16914", `decSex`="+38:10:08.90", `discDate`="2020-12-18 02:36:57.600", `discMag`="14.06", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fup", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcx", `raDeg`="306.217917", `raSex`="20:24:52.300", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcw" ,"AT2020adcw" ,"37.03355" ,"+37:02:00.78" ,"2020-12-17 20:42:43.200" ,"15.96" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fuo" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcw" ,"297.6185" ,"19:50:28.440" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcw", `TNSName`="AT2020adcw", `decDeg`="37.03355", `decSex`="+37:02:00.78", `discDate`="2020-12-17 20:42:43.200", `discMag`="15.96", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fuo", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcw", `raDeg`="297.6185", `raSex`="19:50:28.440", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcv" ,"AT2020adcv" ,"37.242569" ,"+37:14:33.25" ,"2020-12-17 20:26:52.800" ,"17.61" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fum" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcv" ,"320.9505" ,"21:23:48.120" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcv", `TNSName`="AT2020adcv", `decDeg`="37.242569", `decSex`="+37:14:33.25", `discDate`="2020-12-17 20:26:52.800", `discMag`="17.61", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fum", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcv", `raDeg`="320.9505", `raSex`="21:23:48.120", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcu" ,"AT2020adcu" ,"35.877761" ,"+35:52:39.94" ,"2020-12-18 14:55:40.800" ,"17.97" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fui" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcu" ,"282.080417" ,"18:48:19.300" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcu", `TNSName`="AT2020adcu", `decDeg`="35.877761", `decSex`="+35:52:39.94", `discDate`="2020-12-18 14:55:40.800", `discMag`="17.97", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fui", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcu", `raDeg`="282.080417", `raSex`="18:48:19.300", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adct" ,"AT2020adct" ,"35.070331" ,"+35:04:13.19" ,"2020-11-21 22:40:48.000" ,"15.82" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fuh" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adct" ,"284.779" ,"18:59:06.960" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adct", `TNSName`="AT2020adct", `decDeg`="35.070331", `decSex`="+35:04:13.19", `discDate`="2020-11-21 22:40:48.000", `discMag`="15.82", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fuh", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adct", `raDeg`="284.779", `raSex`="18:59:06.960", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcs" ,"AT2020adcs" ,"-12.839231" ,"-12:50:21.23" ,"2020-12-18 04:20:38.400" ,"18.51" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fug" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcs" ,"206.0037083" ,"13:44:00.890" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcs", `TNSName`="AT2020adcs", `decDeg`="-12.839231", `decSex`="-12:50:21.23", `discDate`="2020-12-18 04:20:38.400", `discMag`="18.51", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fug", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcs", `raDeg`="206.0037083", `raSex`="13:44:00.890", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcr" ,"AT2020adcr" ,"-5.799644" ,"-05:47:58.72" ,"2020-12-10 13:15:10.080" ,"15.98" ,"r-ZTF" ,"ZTF" ,"ZTF18acvjwtz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcr" ,"222.8435875" ,"14:51:22.461" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcr", `TNSName`="AT2020adcr", `decDeg`="-5.799644", `decSex`="-05:47:58.72", `discDate`="2020-12-10 13:15:10.080", `discMag`="15.98", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18acvjwtz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcr", `raDeg`="222.8435875", `raSex`="14:51:22.461", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcq" ,"AT2020adcq" ,"-11.0057" ,"-11:00:20.52" ,"2020-12-10 13:14:30.336" ,"15.69" ,"r-ZTF" ,"ZTF" ,"ZTF18acvjpck" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcq" ,"218.3757333" ,"14:33:30.176" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcq", `TNSName`="AT2020adcq", `decDeg`="-11.0057", `decSex`="-11:00:20.52", `discDate`="2020-12-10 13:14:30.336", `discMag`="15.69", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18acvjpck", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcq", `raDeg`="218.3757333", `raSex`="14:33:30.176", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcp" ,"AT2020adcp" ,"19.524878" ,"+19:31:29.56" ,"2020-12-16 04:53:37.000" ,"20.337" ,"g-ZTF" ,"ZTF" ,"ZTF20acynaba" ,"SDSS J011356.58+193131.0" ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcp" ,"18.4851625" ,"01:13:56.439" ,"SGLF, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcp", `TNSName`="AT2020adcp", `decDeg`="19.524878", `decSex`="+19:31:29.56", `discDate`="2020-12-16 04:53:37.000", `discMag`="20.337", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acynaba", `hostName`="SDSS J011356.58+193131.0", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcp", `raDeg`="18.4851625", `raSex`="01:13:56.439", `reportingSurvey`="SGLF, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adco" ,"AT2020adco" ,"-5.727308" ,"-05:43:38.31" ,"2020-12-12 13:26:36.960" ,"19.2" ,"r-ZTF" ,"ZTF" ,"ZTF19aacitvp" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adco" ,"211.7641083" ,"14:07:03.386" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adco", `TNSName`="AT2020adco", `decDeg`="-5.727308", `decSex`="-05:43:38.31", `discDate`="2020-12-12 13:26:36.960", `discMag`="19.2", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF19aacitvp", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adco", `raDeg`="211.7641083", `raSex`="14:07:03.386", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcn" ,"AT2020adcn" ,"-15.395753" ,"-15:23:44.71" ,"2020-12-12 14:22:33.600" ,"20.7" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjp" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcn" ,"166.3197125" ,"11:05:16.731" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcn", `TNSName`="AT2020adcn", `decDeg`="-15.395753", `decSex`="-15:23:44.71", `discDate`="2020-12-12 14:22:33.600", `discMag`="20.7", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjp", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcn", `raDeg`="166.3197125", `raSex`="11:05:16.731", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcm" ,"AT2020adcm" ,"5.046672" ,"+05:02:48.02" ,"2020-12-06 08:00:57.600" ,"21.1" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjo" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcm" ,"25.53995417" ,"01:42:09.589" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcm", `TNSName`="AT2020adcm", `decDeg`="5.046672", `decSex`="+05:02:48.02", `discDate`="2020-12-06 08:00:57.600", `discMag`="21.1", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjo", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcm", `raDeg`="25.53995417", `raSex`="01:42:09.589", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcl" ,"AT2020adcl" ,"11.673875" ,"+11:40:25.95" ,"2020-12-11 12:08:38.400" ,"20.36" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjn" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcl" ,"143.5820875" ,"09:34:19.701" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcl", `TNSName`="AT2020adcl", `decDeg`="11.673875", `decSex`="+11:40:25.95", `discDate`="2020-12-11 12:08:38.400", `discMag`="20.36", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjn", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcl", `raDeg`="143.5820875", `raSex`="09:34:19.701", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adck" ,"AT2020adck" ,"-16.940086" ,"-16:56:24.31" ,"2020-12-06 06:34:33.600" ,"21.68" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjl" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adck" ,"19.593333" ,"01:18:22.400" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adck", `TNSName`="AT2020adck", `decDeg`="-16.940086", `decSex`="-16:56:24.31", `discDate`="2020-12-06 06:34:33.600", `discMag`="21.68", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjl", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adck", `raDeg`="19.593333", `raSex`="01:18:22.400", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcj" ,"AT2020adcj" ,"-15.270464" ,"-15:16:13.67" ,"2020-12-07 08:19:40.800" ,"21.77" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjk" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcj" ,"56.1483583" ,"03:44:35.606" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcj", `TNSName`="AT2020adcj", `decDeg`="-15.270464", `decSex`="-15:16:13.67", `discDate`="2020-12-07 08:19:40.800", `discMag`="21.77", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjk", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcj", `raDeg`="56.1483583", `raSex`="03:44:35.606", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adci" ,"AT2020adci" ,"-4.999294" ,"-04:59:57.46" ,"2020-12-06 05:19:40.800" ,"20.41" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mji" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adci" ,"330.84844583" ,"22:03:23.627" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adci", `TNSName`="AT2020adci", `decDeg`="-4.999294", `decSex`="-04:59:57.46", `discDate`="2020-12-06 05:19:40.800", `discMag`="20.41", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mji", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adci", `raDeg`="330.84844583", `raSex`="22:03:23.627", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adch" ,"AT2020adch" ,"-15.588733" ,"-15:35:19.44" ,"2020-11-08 09:25:55.200" ,"21.76" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjg" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adch" ,"54.02079166666667" ,"03:36:04.990" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adch", `TNSName`="AT2020adch", `decDeg`="-15.588733", `decSex`="-15:35:19.44", `discDate`="2020-11-08 09:25:55.200", `discMag`="21.76", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjg", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adch", `raDeg`="54.02079166666667", `raSex`="03:36:04.990", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcg" ,"AT2020adcg" ,"-3.5221" ,"-03:31:19.56" ,"2020-12-06 05:31:12.000" ,"20.58" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcg" ,"344.5844333" ,"22:58:20.264" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcg", `TNSName`="AT2020adcg", `decDeg`="-3.5221", `decSex`="-03:31:19.56", `discDate`="2020-12-06 05:31:12.000", `discMag`="20.58", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcg", `raDeg`="344.5844333", `raSex`="22:58:20.264", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcf" ,"AT2020adcf" ,"-27.471994" ,"-27:28:19.18" ,"2020-04-25 05:35:25.152" ,"19.86" ,"r-ZTF" ,"ZTF" ,"ZTF20aavgeip" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcf" ,"155.5056583" ,"10:22:01.358" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcf", `TNSName`="AT2020adcf", `decDeg`="-27.471994", `decSex`="-27:28:19.18", `discDate`="2020-04-25 05:35:25.152", `discMag`="19.86", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20aavgeip", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcf", `raDeg`="155.5056583", `raSex`="10:22:01.358", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adce" ,"AT2020adce" ,"-1.71906" ,"-01:43:08.60" ,"2020-12-06 05:31:12.000" ,"21.12" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mje" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adce" ,"343.4946375" ,"22:53:58.713" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adce", `TNSName`="AT2020adce", `decDeg`="-1.71906", `decSex`="-01:43:08.60", `discDate`="2020-12-06 05:31:12.000", `discMag`="21.12", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mje", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adce", `raDeg`="343.4946375", `raSex`="22:53:58.713", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcd" ,"AT2020adcd" ,"-3.0539" ,"-03:03:14.04" ,"2020-12-07 07:09:07.200" ,"21.35" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjd" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcd" ,"42.014175" ,"02:48:03.402" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcd", `TNSName`="AT2020adcd", `decDeg`="-3.0539", `decSex`="-03:03:14.04", `discDate`="2020-12-07 07:09:07.200", `discMag`="21.35", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjd", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcd", `raDeg`="42.014175", `raSex`="02:48:03.402", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcc" ,"AT2020adcc" ,"19.733467" ,"+19:44:00.48" ,"2020-11-17 10:40:48.000" ,"21.27" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjc" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcc" ,"32.35574583" ,"02:09:25.379" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcc", `TNSName`="AT2020adcc", `decDeg`="19.733467", `decSex`="+19:44:00.48", `discDate`="2020-11-17 10:40:48.000", `discMag`="21.27", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjc", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcc", `raDeg`="32.35574583", `raSex`="02:09:25.379", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adcb" ,"AT2020adcb" ,"5.564592" ,"+05:33:52.53" ,"2020-12-19 04:26:24.000" ,"18.62" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acynjjo" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adcb" ,"338.5270083" ,"22:34:06.482" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcb", `TNSName`="AT2020adcb", `decDeg`="5.564592", `decSex`="+05:33:52.53", `discDate`="2020-12-19 04:26:24.000", `discMag`="18.62", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acynjjo", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adcb", `raDeg`="338.5270083", `raSex`="22:34:06.482", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adca" ,"AT2020adca" ,"-23.00936" ,"-23:00:33.70" ,"2020-12-19 03:04:19.200" ,"18.88" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acymtcs" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adca" ,"8.965" ,"00:35:51.600" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adca", `TNSName`="AT2020adca", `decDeg`="-23.00936", `decSex`="-23:00:33.70", `discDate`="2020-12-19 03:04:19.200", `discMag`="18.88", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acymtcs", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adca", `raDeg`="8.965", `raSex`="00:35:51.600", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbz" ,"AT2020adbz" ,"81.395558" ,"+81:23:44.01" ,"2020-12-19 05:31:12.000" ,"19.2" ,"g-ZTF" ,"ZTF" ,"ZTF20acynudw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbz" ,"327.0006333" ,"21:48:00.152" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbz", `TNSName`="AT2020adbz", `decDeg`="81.395558", `decSex`="+81:23:44.01", `discDate`="2020-12-19 05:31:12.000", `discMag`="19.2", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acynudw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbz", `raDeg`="327.0006333", `raSex`="21:48:00.152", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adby" ,"AT2020adby" ,"53.57356" ,"+53:34:24.80" ,"2020-12-16 09:22:59.808" ,"19.93" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acxjekh" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adby" ,"108.9927083" ,"07:15:58.250" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adby", `TNSName`="AT2020adby", `decDeg`="53.57356", `decSex`="+53:34:24.80", `discDate`="2020-12-16 09:22:59.808", `discMag`="19.93", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acxjekh", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adby", `raDeg`="108.9927083", `raSex`="07:15:58.250", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbx" ,"AT2020adbx" ,"-12.669642" ,"-12:40:10.71" ,"2020-12-19 05:42:39.744" ,"19.22" ,"g-ZTF" ,"ZTF" ,"ZTF20acxooam" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbx" ,"62.349275" ,"04:09:23.826" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbx", `TNSName`="AT2020adbx", `decDeg`="-12.669642", `decSex`="-12:40:10.71", `discDate`="2020-12-19 05:42:39.744", `discMag`="19.22", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxooam", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbx", `raDeg`="62.349275", `raSex`="04:09:23.826", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbw" ,"AT2020adbw" ,"46.281617" ,"+46:16:53.82" ,"2020-12-16 05:25:28.128" ,"18.4" ,"r-ZTF" ,"ZTF" ,"ZTF18acdygrx" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbw" ,"28.344575" ,"01:53:22.698" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbw", `TNSName`="AT2020adbw", `decDeg`="46.281617", `decSex`="+46:16:53.82", `discDate`="2020-12-16 05:25:28.128", `discMag`="18.4", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18acdygrx", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbw", `raDeg`="28.344575", `raSex`="01:53:22.698", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbv" ,"AT2020adbv" ,"79.803864" ,"+79:48:13.91" ,"2020-12-12 04:59:27.744" ,"19.79" ,"r-ZTF" ,"ZTF" ,"ZTF20acxcbvp" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbv" ,"16.97405417" ,"01:07:53.773" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbv", `TNSName`="AT2020adbv", `decDeg`="79.803864", `decSex`="+79:48:13.91", `discDate`="2020-12-12 04:59:27.744", `discMag`="19.79", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxcbvp", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbv", `raDeg`="16.97405417", `raSex`="01:07:53.773", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbu" ,"AT2020adbu" ,"-0.508533" ,"-00:30:30.72" ,"2020-12-19 04:34:38.208" ,"19.6" ,"g-ZTF" ,"ZTF" ,"ZTF20acwsoaw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbu" ,"26.4224875" ,"01:45:41.397" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbu", `TNSName`="AT2020adbu", `decDeg`="-0.508533", `decSex`="-00:30:30.72", `discDate`="2020-12-19 04:34:38.208", `discMag`="19.6", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwsoaw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbu", `raDeg`="26.4224875", `raSex`="01:45:41.397", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbt" ,"AT2020adbt" ,"-9.65305" ,"-09:39:10.98" ,"2020-11-25 06:33:12.384" ,"19.01" ,"r-ZTF" ,"ZTF" ,"ZTF19aablblo" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbt" ,"41.20292083" ,"02:44:48.701" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbt", `TNSName`="AT2020adbt", `decDeg`="-9.65305", `decSex`="-09:39:10.98", `discDate`="2020-11-25 06:33:12.384", `discMag`="19.01", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF19aablblo", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbt", `raDeg`="41.20292083", `raSex`="02:44:48.701", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbs" ,"AT2020adbs" ,"-12.911283" ,"-12:54:40.62" ,"2020-12-06 03:43:49.152" ,"19.66" ,"g-ZTF" ,"ZTF" ,"ZTF18abuozmg" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbs" ,"28.04535417" ,"01:52:10.885" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbs", `TNSName`="AT2020adbs", `decDeg`="-12.911283", `decSex`="-12:54:40.62", `discDate`="2020-12-06 03:43:49.152", `discMag`="19.66", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18abuozmg", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbs", `raDeg`="28.04535417", `raSex`="01:52:10.885", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbr" ,"AT2020adbr" ,"-19.864958" ,"-19:51:53.85" ,"2020-12-16 06:35:45.312" ,"18.18" ,"g-ZTF" ,"ZTF" ,"ZTF20actpcbb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbr" ,"35.279" ,"02:21:06.960" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbr", `TNSName`="AT2020adbr", `decDeg`="-19.864958", `decSex`="-19:51:53.85", `discDate`="2020-12-16 06:35:45.312", `discMag`="18.18", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20actpcbb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbr", `raDeg`="35.279", `raSex`="02:21:06.960", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbq" ,"AT2020adbq" ,"4.794994" ,"+04:47:41.98" ,"2020-12-04 10:45:07.200" ,"20.35" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mjb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbq" ,"70.9859333" ,"04:43:56.624" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbq", `TNSName`="AT2020adbq", `decDeg`="4.794994", `decSex`="+04:47:41.98", `discDate`="2020-12-04 10:45:07.200", `discMag`="20.35", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbq", `raDeg`="70.9859333", `raSex`="04:43:56.624", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbp" ,"AT2020adbp" ,"41.146775" ,"+41:08:48.39" ,"2020-07-13 11:07:47.136" ,"20.3577" ,"r-ZTF" ,"ZTF" ,"ZTF20abhtvor" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbp" ,"10.5024833" ,"00:42:00.596" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbp", `TNSName`="AT2020adbp", `decDeg`="41.146775", `decSex`="+41:08:48.39", `discDate`="2020-07-13 11:07:47.136", `discMag`="20.3577", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20abhtvor", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbp", `raDeg`="10.5024833", `raSex`="00:42:00.596", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbo" ,"AT2020adbo" ,"71.848003" ,"+71:50:52.81" ,"2020-12-11 11:53:41.568" ,"20.4302" ,"r-ZTF" ,"ZTF" ,"ZTF20acxsywg" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbo" ,"202.1811625" ,"13:28:43.479" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbo", `TNSName`="AT2020adbo", `decDeg`="71.848003", `decSex`="+71:50:52.81", `discDate`="2020-12-11 11:53:41.568", `discMag`="20.4302", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxsywg", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbo", `raDeg`="202.1811625", `raSex`="13:28:43.479", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbn" ,"AT2020adbn" ,"-10.969081" ,"-10:58:08.69" ,"2020-12-11 07:06:59.328" ,"20.7212" ,"r-ZTF" ,"ZTF" ,"ZTF20acxpmnx" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbn" ,"69.0718125" ,"04:36:17.235" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbn", `TNSName`="AT2020adbn", `decDeg`="-10.969081", `decSex`="-10:58:08.69", `discDate`="2020-12-11 07:06:59.328", `discMag`="20.7212", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxpmnx", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbn", `raDeg`="69.0718125", `raSex`="04:36:17.235", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbm" ,"AT2020adbm" ,"-16.457531" ,"-16:27:27.11" ,"2020-12-16 12:29:55.003" ,"19.2245" ,"r-ZTF" ,"ZTF" ,"ZTF20acxzlrc" ,"2MASX J12580806-1627140" ,"0.042132" ,"http://wis-tns.weizmann.ac.il/object/2020adbm" ,"194.5323875" ,"12:58:07.773" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbm", `TNSName`="AT2020adbm", `decDeg`="-16.457531", `decSex`="-16:27:27.11", `discDate`="2020-12-16 12:29:55.003", `discMag`="19.2245", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxzlrc", `hostName`="2MASX J12580806-1627140", `hostRedshift`="0.042132", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbm", `raDeg`="194.5323875", `raSex`="12:58:07.773", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbl" ,"AT2020adbl" ,"-7.007978" ,"-07:00:28.72" ,"2020-12-16 10:04:22.002" ,"20.311" ,"g-ZTF" ,"ZTF" ,"ZTF20acylmhd" ,"SDSS J082252.40-070026.5" ,"0.112" ,"http://wis-tns.weizmann.ac.il/object/2020adbl" ,"125.7183917" ,"08:22:52.414" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbl", `TNSName`="AT2020adbl", `decDeg`="-7.007978", `decSex`="-07:00:28.72", `discDate`="2020-12-16 10:04:22.002", `discMag`="20.311", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acylmhd", `hostName`="SDSS J082252.40-070026.5", `hostRedshift`="0.112", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbl", `raDeg`="125.7183917", `raSex`="08:22:52.414", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbk" ,"AT2020adbk" ,"31.103411" ,"+31:06:12.28" ,"2020-12-16 08:35:39.002" ,"19.8786" ,"g-ZTF" ,"ZTF" ,"ZTF20acxqnhn" ,"SDSS J081925.47+310610.5" ,"0.12" ,"http://wis-tns.weizmann.ac.il/object/2020adbk" ,"124.85608333333333" ,"08:19:25.460" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `TNSName`="AT2020adbk", `decDeg`="31.103411", `decSex`="+31:06:12.28", `discDate`="2020-12-16 08:35:39.002", `discMag`="19.8786", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxqnhn", `hostName`="SDSS J081925.47+310610.5", `hostRedshift`="0.12", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbk", `raDeg`="124.85608333333333", `raSex`="08:19:25.460", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbj" ,"AT2020adbj" ,"17.304978" ,"+17:18:17.92" ,"2020-12-16 08:10:09.998" ,"20.477" ,"g-ZTF" ,"ZTF" ,"ZTF20acyloou" ,"WISEA J071431.91+171813.0" ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbj" ,"108.63339583" ,"07:14:32.015" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbj", `TNSName`="AT2020adbj", `decDeg`="17.304978", `decSex`="+17:18:17.92", `discDate`="2020-12-16 08:10:09.998", `discMag`="20.477", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acyloou", `hostName`="WISEA J071431.91+171813.0", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbj", `raDeg`="108.63339583", `raSex`="07:14:32.015", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbi" ,"AT2020adbi" ,"22.635933" ,"+22:38:09.36" ,"2020-12-13 10:58:03.996" ,"20.5257" ,"g-ZTF" ,"ZTF" ,"ZTF20acylvtk" ,"WISEA J084827.77+223801.1" ,"0.083346" ,"http://wis-tns.weizmann.ac.il/object/2020adbi" ,"132.1173417" ,"08:48:28.162" ,"ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbi", `TNSName`="AT2020adbi", `decDeg`="22.635933", `decSex`="+22:38:09.36", `discDate`="2020-12-13 10:58:03.996", `discMag`="20.5257", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acylvtk", `hostName`="WISEA J084827.77+223801.1", `hostRedshift`="0.083346", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbi", `raDeg`="132.1173417", `raSex`="08:48:28.162", `reportingSurvey`="ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbh" ,"AT2020adbh" ,"46.475381" ,"+46:28:31.37" ,"2020-11-15 12:20:38.112" ,"20.3297" ,"g-ZTF" ,"ZTF" ,"ZTF20acqvgaz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbh" ,"182.169417" ,"12:08:40.660" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbh", `TNSName`="AT2020adbh", `decDeg`="46.475381", `decSex`="+46:28:31.37", `discDate`="2020-11-15 12:20:38.112", `discMag`="20.3297", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acqvgaz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbh", `raDeg`="182.169417", `raSex`="12:08:40.660", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbg" ,"AT2020adbg" ,"21.233297" ,"+21:13:59.87" ,"2020-11-17 05:25:26.400" ,"20.66" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mja" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbg" ,"18.515275" ,"01:14:03.666" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbg", `TNSName`="AT2020adbg", `decDeg`="21.233297", `decSex`="+21:13:59.87", `discDate`="2020-11-17 05:25:26.400", `discMag`="20.66", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mja", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbg", `raDeg`="18.515275", `raSex`="01:14:03.666", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbf" ,"AT2020adbf" ,"-10.981375" ,"-10:58:52.95" ,"2020-11-20 11:19:40.800" ,"21.98" ,"w-PS1" ,"Pan-STARRS1" ,"PS20miy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbf" ,"52.16127083333333" ,"03:28:38.705" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbf", `TNSName`="AT2020adbf", `decDeg`="-10.981375", `decSex`="-10:58:52.95", `discDate`="2020-11-20 11:19:40.800", `discMag`="21.98", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20miy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbf", `raDeg`="52.16127083333333", `raSex`="03:28:38.705", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbe" ,"AT2020adbe" ,"47.828539" ,"+47:49:42.74" ,"2020-12-07 14:42:43.200" ,"19.68" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mix" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbe" ,"139.805625" ,"09:19:13.350" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbe", `TNSName`="AT2020adbe", `decDeg`="47.828539", `decSex`="+47:49:42.74", `discDate`="2020-12-07 14:42:43.200", `discMag`="19.68", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mix", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbe", `raDeg`="139.805625", `raSex`="09:19:13.350", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbd" ,"AT2020adbd" ,"18.360314" ,"+18:21:37.13" ,"2020-12-11 10:40:27.264" ,"20.0185" ,"g-ZTF" ,"ZTF" ,"ZTF20acwxgcy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbd" ,"155.80098333333333" ,"10:23:12.236" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbd", `TNSName`="AT2020adbd", `decDeg`="18.360314", `decSex`="+18:21:37.13", `discDate`="2020-12-11 10:40:27.264", `discMag`="20.0185", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwxgcy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbd", `raDeg`="155.80098333333333", `raSex`="10:23:12.236", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbc" ,"AT2020adbc" ,"-15.957953" ,"-15:57:28.63" ,"2020-12-02 03:32:12.768" ,"19.2689" ,"r-ZTF" ,"ZTF" ,"ZTF19acttscy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbc" ,"1.3708083333333334" ,"00:05:28.994" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbc", `TNSName`="AT2020adbc", `decDeg`="-15.957953", `decSex`="-15:57:28.63", `discDate`="2020-12-02 03:32:12.768", `discMag`="19.2689", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF19acttscy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbc", `raDeg`="1.3708083333333334", `raSex`="00:05:28.994", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbb" ,"AT2020adbb" ,"-23.79333" ,"-23:47:36.00" ,"2020-11-16 12:03:19.584" ,"17.8158" ,"r-ZTF" ,"ZTF" ,"ZTF20acxroig" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adbb" ,"107.1008583" ,"07:08:24.206" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbb", `TNSName`="AT2020adbb", `decDeg`="-23.79333", `decSex`="-23:47:36.00", `discDate`="2020-11-16 12:03:19.584", `discMag`="17.8158", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxroig", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adbb", `raDeg`="107.1008583", `raSex`="07:08:24.206", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adba" ,"AT2020adba" ,"-23.13431" ,"-23:08:03.50" ,"2020-12-07 10:03:50.112" ,"17.7986" ,"r-ZTF" ,"ZTF" ,"ZTF20acxrpri" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adba" ,"96.18549583" ,"06:24:44.519" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adba", `TNSName`="AT2020adba", `decDeg`="-23.13431", `decSex`="-23:08:03.50", `discDate`="2020-12-07 10:03:50.112", `discMag`="17.7986", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxrpri", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adba", `raDeg`="96.18549583", `raSex`="06:24:44.519", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adaz" ,"AT2020adaz" ,"-0.899653" ,"-00:53:58.75" ,"2020-12-10 12:54:43.200" ,"21.35" ,"w-PS1" ,"Pan-STARRS1" ,"PS20miv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adaz" ,"135.280925" ,"09:01:07.422" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaz", `TNSName`="AT2020adaz", `decDeg`="-0.899653", `decSex`="-00:53:58.75", `discDate`="2020-12-10 12:54:43.200", `discMag`="21.35", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20miv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adaz", `raDeg`="135.280925", `raSex`="09:01:07.422", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aday" ,"AT2020aday" ,"5.753144" ,"+05:45:11.32" ,"2020-12-12 12:56:09.600" ,"20.54" ,"w-PS1" ,"Pan-STARRS1" ,"PS20miu" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aday" ,"122.1012875" ,"08:08:24.309" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aday", `TNSName`="AT2020aday", `decDeg`="5.753144", `decSex`="+05:45:11.32", `discDate`="2020-12-12 12:56:09.600", `discMag`="20.54", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20miu", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aday", `raDeg`="122.1012875", `raSex`="08:08:24.309", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adax" ,"AT2020adax" ,"8.495869" ,"+08:29:45.13" ,"2020-12-02 11:12:28.800" ,"20.45" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mis" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adax" ,"41.63710416666667" ,"02:46:32.905" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adax", `TNSName`="AT2020adax", `decDeg`="8.495869", `decSex`="+08:29:45.13", `discDate`="2020-12-02 11:12:28.800", `discMag`="20.45", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mis", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adax", `raDeg`="41.63710416666667", `raSex`="02:46:32.905", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adaw" ,"AT2020adaw" ,"15.024892" ,"+15:01:29.61" ,"2020-12-08 07:19:12.000" ,"20.56" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mir" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adaw" ,"13.334379166666666" ,"00:53:20.251" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaw", `TNSName`="AT2020adaw", `decDeg`="15.024892", `decSex`="+15:01:29.61", `discDate`="2020-12-08 07:19:12.000", `discMag`="20.56", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mir", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adaw", `raDeg`="13.334379166666666", `raSex`="00:53:20.251", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adav" ,"AT2020adav" ,"13.835961" ,"+13:50:09.46" ,"2020-12-08 06:00:00.000" ,"21.09" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mip" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adav" ,"37.60740416666667" ,"02:30:25.777" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adav", `TNSName`="AT2020adav", `decDeg`="13.835961", `decSex`="+13:50:09.46", `discDate`="2020-12-08 06:00:00.000", `discMag`="21.09", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mip", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adav", `raDeg`="37.60740416666667", `raSex`="02:30:25.777", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adau" ,"AT2020adau" ,"-13.310742" ,"-13:18:38.67" ,"2020-12-12 14:22:33.600" ,"20.96" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mio" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adau" ,"170.6009375" ,"11:22:24.225" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adau", `TNSName`="AT2020adau", `decDeg`="-13.310742", `decSex`="-13:18:38.67", `discDate`="2020-12-12 14:22:33.600", `discMag`="20.96", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mio", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adau", `raDeg`="170.6009375", `raSex`="11:22:24.225", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adat" ,"AT2020adat" ,"42.494767" ,"+42:29:41.16" ,"2020-11-28 14:42:43.200" ,"19.99" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20min" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adat" ,"138.160825" ,"09:12:38.598" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adat", `TNSName`="AT2020adat", `decDeg`="42.494767", `decSex`="+42:29:41.16", `discDate`="2020-11-28 14:42:43.200", `discMag`="19.99", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20min", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adat", `raDeg`="138.160825", `raSex`="09:12:38.598", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adas" ,"AT2020adas" ,"49.441256" ,"+49:26:28.52" ,"2020-12-07 14:45:36.000" ,"20.27" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mim" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adas" ,"141.499975" ,"09:25:59.994" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adas", `TNSName`="AT2020adas", `decDeg`="49.441256", `decSex`="+49:26:28.52", `discDate`="2020-12-07 14:45:36.000", `discMag`="20.27", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mim", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adas", `raDeg`="141.499975", `raSex`="09:25:59.994", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adar" ,"AT2020adar" ,"6.774742" ,"+06:46:29.07" ,"2020-12-12 05:09:36.000" ,"21.14" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mil" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adar" ,"9.394558333333332" ,"00:37:34.694" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adar", `TNSName`="AT2020adar", `decDeg`="6.774742", `decSex`="+06:46:29.07", `discDate`="2020-12-12 05:09:36.000", `discMag`="21.14", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mil", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adar", `raDeg`="9.394558333333332", `raSex`="00:37:34.694", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adaq" ,"AT2020adaq" ,"1.545436" ,"+01:32:43.57" ,"2020-12-12 04:59:31.200" ,"21.45" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mik" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adaq" ,"1.66007917" ,"00:06:38.419" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaq", `TNSName`="AT2020adaq", `decDeg`="1.545436", `decSex`="+01:32:43.57", `discDate`="2020-12-12 04:59:31.200", `discMag`="21.45", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mik", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adaq", `raDeg`="1.66007917", `raSex`="00:06:38.419", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adap" ,"AT2020adap" ,"-5.081117" ,"-05:04:52.02" ,"2020-12-07 07:12:00.000" ,"21.16" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mij" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adap" ,"45.71759583" ,"03:02:52.223" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adap", `TNSName`="AT2020adap", `decDeg`="-5.081117", `decSex`="-05:04:52.02", `discDate`="2020-12-07 07:12:00.000", `discMag`="21.16", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mij", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adap", `raDeg`="45.71759583", `raSex`="03:02:52.223", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adao" ,"AT2020adao" ,"-10.314939" ,"-10:18:53.78" ,"2020-12-12 14:28:19.200" ,"21.06" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mii" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adao" ,"176.57515417" ,"11:46:18.037" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adao", `TNSName`="AT2020adao", `decDeg`="-10.314939", `decSex`="-10:18:53.78", `discDate`="2020-12-12 14:28:19.200", `discMag`="21.06", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mii", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adao", `raDeg`="176.57515417", `raSex`="11:46:18.037", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adan" ,"AT2020adan" ,"2.255356" ,"+02:15:19.28" ,"2020-09-19 13:37:55.200" ,"21.09" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mih" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adan" ,"48.47870417" ,"03:13:54.889" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adan", `TNSName`="AT2020adan", `decDeg`="2.255356", `decSex`="+02:15:19.28", `discDate`="2020-09-19 13:37:55.200", `discMag`="21.09", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mih", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adan", `raDeg`="48.47870417", `raSex`="03:13:54.889", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adam" ,"AT2020adam" ,"-10.753186" ,"-10:45:11.47" ,"2020-11-20 10:40:48.000" ,"21.78" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mig" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adam" ,"52.97972917" ,"03:31:55.135" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adam", `TNSName`="AT2020adam", `decDeg`="-10.753186", `decSex`="-10:45:11.47", `discDate`="2020-11-20 10:40:48.000", `discMag`="21.78", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mig", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adam", `raDeg`="52.97972917", `raSex`="03:31:55.135", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adal" ,"AT2020adal" ,"62.574869" ,"+62:34:29.53" ,"2020-12-06 14:13:55.200" ,"20.68" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mif" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adal" ,"178.910275" ,"11:55:38.466" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adal", `TNSName`="AT2020adal", `decDeg`="62.574869", `decSex`="+62:34:29.53", `discDate`="2020-12-06 14:13:55.200", `discMag`="20.68", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mif", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adal", `raDeg`="178.910275", `raSex`="11:55:38.466", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adak" ,"AT2020adak" ,"61.762742" ,"+61:45:45.87" ,"2020-12-06 14:13:55.200" ,"20.23" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mic" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adak" ,"170.7817875" ,"11:23:07.629" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adak", `TNSName`="AT2020adak", `decDeg`="61.762742", `decSex`="+61:45:45.87", `discDate`="2020-12-06 14:13:55.200", `discMag`="20.23", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mic", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adak", `raDeg`="170.7817875", `raSex`="11:23:07.629", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adaj" ,"AT2020adaj" ,"-3.632564" ,"-03:37:57.23" ,"2020-12-07 06:59:02.400" ,"21.23" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mia" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adaj" ,"29.38432917" ,"01:57:32.239" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaj", `TNSName`="AT2020adaj", `decDeg`="-3.632564", `decSex`="-03:37:57.23", `discDate`="2020-12-07 06:59:02.400", `discMag`="21.23", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mia", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adaj", `raDeg`="29.38432917", `raSex`="01:57:32.239", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adai" ,"AT2020adai" ,"15.842317" ,"+15:50:32.34" ,"2020-12-08 07:19:12.000" ,"20.93" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mhz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adai" ,"13.48535" ,"00:53:56.484" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adai", `TNSName`="AT2020adai", `decDeg`="15.842317", `decSex`="+15:50:32.34", `discDate`="2020-12-08 07:19:12.000", `discMag`="20.93", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adai", `raDeg`="13.48535", `raSex`="00:53:56.484", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adah" ,"AT2020adah" ,"0.51025" ,"+00:30:36.90" ,"2020-12-11 19:30:25.056" ,"20.58" ,"Clear-" ,"GSNST" ,"GSNST-20dk" ,"2MASX J00162059+0030313" ,"0.15396" ,"http://wis-tns.weizmann.ac.il/object/2020adah" ,"4.0825" ,"00:16:19.800" ,"GSNST" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adah", `TNSName`="AT2020adah", `decDeg`="0.51025", `decSex`="+00:30:36.90", `discDate`="2020-12-11 19:30:25.056", `discMag`="20.58", `discMagFilter`="Clear-", `discSurvey`="GSNST", `discoveryName`="GSNST-20dk", `hostName`="2MASX J00162059+0030313", `hostRedshift`="0.15396", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adah", `raDeg`="4.0825", `raSex`="00:16:19.800", `reportingSurvey`="GSNST", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adag" ,"AT2020adag" ,"2.134481" ,"+02:08:04.13" ,"2020-12-17 06:57:36.000" ,"18.1" ,"g-Sloan" ,"ASAS-SN" ,"ASASSN-20qa" ,"WISEA J014527.26+020803.3" ,null ,"http://wis-tns.weizmann.ac.il/object/2020adag" ,"26.36345" ,"01:45:27.228" ,"ASAS-SN" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adag", `TNSName`="AT2020adag", `decDeg`="2.134481", `decSex`="+02:08:04.13", `discDate`="2020-12-17 06:57:36.000", `discMag`="18.1", `discMagFilter`="g-Sloan", `discSurvey`="ASAS-SN", `discoveryName`="ASASSN-20qa", `hostName`="WISEA J014527.26+020803.3", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adag", `raDeg`="26.36345", `raSex`="01:45:27.228", `reportingSurvey`="ASAS-SN", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adaf" ,"AT2020adaf" ,"-61.555769" ,"-61:33:20.77" ,"2020-12-14 01:55:12.000" ,"17.9" ,"g-Sloan" ,"ASAS-SN" ,"ASASSN-20pz" ,"ESO 115-IG 010 NED02" ,"0.048597" ,"http://wis-tns.weizmann.ac.il/object/2020adaf" ,"36.28247083" ,"02:25:07.793" ,"ASAS-SN" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaf", `TNSName`="AT2020adaf", `decDeg`="-61.555769", `decSex`="-61:33:20.77", `discDate`="2020-12-14 01:55:12.000", `discMag`="17.9", `discMagFilter`="g-Sloan", `discSurvey`="ASAS-SN", `discoveryName`="ASASSN-20pz", `hostName`="ESO 115-IG 010 NED02", `hostRedshift`="0.048597", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adaf", `raDeg`="36.28247083", `raSex`="02:25:07.793", `reportingSurvey`="ASAS-SN", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adae" ,"AT2020adae" ,"19.859931" ,"+19:51:35.75" ,"2020-12-12 07:45:07.200" ,"20.56" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mhx" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adae" ,"26.3889583" ,"01:45:33.350" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adae", `TNSName`="AT2020adae", `decDeg`="19.859931", `decSex`="+19:51:35.75", `discDate`="2020-12-12 07:45:07.200", `discMag`="20.56", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhx", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adae", `raDeg`="26.3889583", `raSex`="01:45:33.350", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adad" ,"AT2020adad" ,"36.369614" ,"+36:22:10.61" ,"2020-11-25 15:30:14.400" ,"20.97" ,"z-Sloan" ,"Pan-STARRS1" ,"PS20mhw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adad" ,"116.09579166666667" ,"07:44:22.990" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adad", `TNSName`="AT2020adad", `decDeg`="36.369614", `decSex`="+36:22:10.61", `discDate`="2020-11-25 15:30:14.400", `discMag`="20.97", `discMagFilter`="z-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adad", `raDeg`="116.09579166666667", `raSex`="07:44:22.990", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adac" ,"AT2020adac" ,"49.406381" ,"+49:24:22.97" ,"2020-12-07 14:45:36.000" ,"20.88" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mhu" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adac" ,"143.9419333" ,"09:35:46.064" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adac", `TNSName`="AT2020adac", `decDeg`="49.406381", `decSex`="+49:24:22.97", `discDate`="2020-12-07 14:45:36.000", `discMag`="20.88", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhu", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adac", `raDeg`="143.9419333", `raSex`="09:35:46.064", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adab" ,"AT2020adab" ,"-14.004197" ,"-14:00:15.11" ,"2020-12-07 08:03:50.400" ,"21.98" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mht" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adab" ,"48.291925" ,"03:13:10.062" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adab", `TNSName`="AT2020adab", `decDeg`="-14.004197", `decSex`="-14:00:15.11", `discDate`="2020-12-07 08:03:50.400", `discMag`="21.98", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mht", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adab", `raDeg`="48.291925", `raSex`="03:13:10.062", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adaa" ,"AT2020adaa" ,"31.667956" ,"+31:40:04.64" ,"2020-12-07 11:28:19.200" ,"20.91" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mhs" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020adaa" ,"119.22757083" ,"07:56:54.617" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaa", `TNSName`="AT2020adaa", `decDeg`="31.667956", `decSex`="+31:40:04.64", `discDate`="2020-12-07 11:28:19.200", `discMag`="20.91", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhs", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020adaa", `raDeg`="119.22757083", `raSex`="07:56:54.617", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczz" ,"AT2020aczz" ,"40.592114" ,"+40:35:31.61" ,"2020-12-06 15:38:52.800" ,"20.36" ,"z-Sloan" ,"Pan-STARRS1" ,"PS20mhr" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczz" ,"192.0123375" ,"12:48:02.961" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczz", `TNSName`="AT2020aczz", `decDeg`="40.592114", `decSex`="+40:35:31.61", `discDate`="2020-12-06 15:38:52.800", `discMag`="20.36", `discMagFilter`="z-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhr", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczz", `raDeg`="192.0123375", `raSex`="12:48:02.961", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczy" ,"AT2020aczy" ,"-12.390303" ,"-12:23:25.09" ,"2020-12-12 14:29:45.600" ,"20.54" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mhn" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczy" ,"178.32587083" ,"11:53:18.209" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczy", `TNSName`="AT2020aczy", `decDeg`="-12.390303", `decSex`="-12:23:25.09", `discDate`="2020-12-12 14:29:45.600", `discMag`="20.54", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhn", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczy", `raDeg`="178.32587083", `raSex`="11:53:18.209", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczx" ,"AT2020aczx" ,"63.778956" ,"+63:46:44.24" ,"2020-11-25 11:58:33.600" ,"20.87" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mhm" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczx" ,"118.96710416666667" ,"07:55:52.105" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczx", `TNSName`="AT2020aczx", `decDeg`="63.778956", `decSex`="+63:46:44.24", `discDate`="2020-11-25 11:58:33.600", `discMag`="20.87", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhm", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczx", `raDeg`="118.96710416666667", `raSex`="07:55:52.105", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczw" ,"AT2020aczw" ,"41.763872" ,"+41:45:49.94" ,"2020-12-12 11:45:36.000" ,"20.61" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mhl" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczw" ,"113.38762083333333" ,"07:33:33.029" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczw", `TNSName`="AT2020aczw", `decDeg`="41.763872", `decSex`="+41:45:49.94", `discDate`="2020-12-12 11:45:36.000", `discMag`="20.61", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhl", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczw", `raDeg`="113.38762083333333", `raSex`="07:33:33.029", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczv" ,"AT2020aczv" ,"-17.331383" ,"-17:19:52.98" ,"2020-12-13 13:25:22.656" ,"18.18" ,"r-ZTF" ,"ZTF" ,"ZTF18acyhkjv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczv" ,"214.3672125" ,"14:17:28.131" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczv", `TNSName`="AT2020aczv", `decDeg`="-17.331383", `decSex`="-17:19:52.98", `discDate`="2020-12-13 13:25:22.656", `discMag`="18.18", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18acyhkjv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczv", `raDeg`="214.3672125", `raSex`="14:17:28.131", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczu" ,"AT2020aczu" ,"-16.712064" ,"-16:42:43.43" ,"2020-12-13 13:18:36.576" ,"18.98" ,"r-ZTF" ,"ZTF" ,"ZTF18acxexkz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczu" ,"213.43580416666666" ,"14:13:44.593" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczu", `TNSName`="AT2020aczu", `decDeg`="-16.712064", `decSex`="-16:42:43.43", `discDate`="2020-12-13 13:18:36.576", `discMag`="18.98", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18acxexkz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczu", `raDeg`="213.43580416666666", `raSex`="14:13:44.593", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczt" ,"AT2020aczt" ,"-2.444064" ,"-02:26:38.63" ,"2020-12-15 05:13:55.200" ,"21.73" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mhk" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczt" ,"358.776" ,"23:55:06.240" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczt", `TNSName`="AT2020aczt", `decDeg`="-2.444064", `decSex`="-02:26:38.63", `discDate`="2020-12-15 05:13:55.200", `discMag`="21.73", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mhk", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczt", `raDeg`="358.776", `raSex`="23:55:06.240", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczs" ,"AT2020aczs" ,"-33.80536" ,"-33:48:19.30" ,"2020-12-17 05:57:07.200" ,"16.12" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fuf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczs" ,"109.83433333333333" ,"07:19:20.240" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczs", `TNSName`="AT2020aczs", `decDeg`="-33.80536", `decSex`="-33:48:19.30", `discDate`="2020-12-17 05:57:07.200", `discMag`="16.12", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fuf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczs", `raDeg`="109.83433333333333", `raSex`="07:19:20.240", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczr" ,"AT2020aczr" ,"-28.786789" ,"-28:47:12.44" ,"2020-12-17 10:59:31.200" ,"18.84" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fue" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczr" ,"171.375375" ,"11:25:30.090" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczr", `TNSName`="AT2020aczr", `decDeg`="-28.786789", `decSex`="-28:47:12.44", `discDate`="2020-12-17 10:59:31.200", `discMag`="18.84", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fue", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczr", `raDeg`="171.375375", `raSex`="11:25:30.090", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczq" ,"AT2020aczq" ,"24.4627" ,"+24:27:45.72" ,"2020-12-17 01:55:12.000" ,"17.16" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fud" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczq" ,"356.8697083" ,"23:47:28.730" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczq", `TNSName`="AT2020aczq", `decDeg`="24.4627", `decSex`="+24:27:45.72", `discDate`="2020-12-17 01:55:12.000", `discMag`="17.16", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fud", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczq", `raDeg`="356.8697083", `raSex`="23:47:28.730", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczp" ,"AT2020aczp" ,"35.649011" ,"+35:38:56.44" ,"2020-12-17 08:39:50.400" ,"18.61" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fuc" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczp" ,"300.6135417" ,"20:02:27.250" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczp", `TNSName`="AT2020aczp", `decDeg`="35.649011", `decSex`="+35:38:56.44", `discDate`="2020-12-17 08:39:50.400", `discMag`="18.61", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fuc", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczp", `raDeg`="300.6135417", `raSex`="20:02:27.250", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczo" ,"AT2020aczo" ,"36.5116" ,"+36:30:41.76" ,"2020-12-17 14:31:12.000" ,"18.73" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20fua" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczo" ,"314.432" ,"20:57:43.680" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczo", `TNSName`="AT2020aczo", `decDeg`="36.5116", `decSex`="+36:30:41.76", `discDate`="2020-12-17 14:31:12.000", `discMag`="18.73", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20fua", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczo", `raDeg`="314.432", `raSex`="20:57:43.680", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczn" ,"AT2020aczn" ,"-22.13605" ,"-22:08:09.78" ,"2020-12-17 06:30:14.400" ,"17.88" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20ftw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczn" ,"184.6775" ,"12:18:42.600" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczn", `TNSName`="AT2020aczn", `decDeg`="-22.13605", `decSex`="-22:08:09.78", `discDate`="2020-12-17 06:30:14.400", `discMag`="17.88", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20ftw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczn", `raDeg`="184.6775", `raSex`="12:18:42.600", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczm" ,"AT2020aczm" ,"15.283831" ,"+15:17:01.79" ,"2020-12-17 01:37:55.200" ,"18.67" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20ftv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczm" ,"15.371375" ,"01:01:29.130" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczm", `TNSName`="AT2020aczm", `decDeg`="15.283831", `decSex`="+15:17:01.79", `discDate`="2020-12-17 01:37:55.200", `discMag`="18.67", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20ftv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczm", `raDeg`="15.371375", `raSex`="01:01:29.130", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczl" ,"AT2020aczl" ,"-34.293011" ,"-34:17:34.84" ,"2020-12-16 23:45:36.000" ,"12.77" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20ftu" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczl" ,"121.266583" ,"08:05:03.980" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczl", `TNSName`="AT2020aczl", `decDeg`="-34.293011", `decSex`="-34:17:34.84", `discDate`="2020-12-16 23:45:36.000", `discMag`="12.77", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20ftu", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczl", `raDeg`="121.266583", `raSex`="08:05:03.980", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczk" ,"AT2020aczk" ,"-14.54075" ,"-14:32:26.70" ,"2020-12-17 10:27:50.400" ,"18.68" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia20ftt" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczk" ,"199.135125" ,"13:16:32.430" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczk", `TNSName`="AT2020aczk", `decDeg`="-14.54075", `decSex`="-14:32:26.70", `discDate`="2020-12-17 10:27:50.400", `discMag`="18.68", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia20ftt", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczk", `raDeg`="199.135125", `raSex`="13:16:32.430", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczj" ,"AT2020aczj" ,"-5.662892" ,"-05:39:46.41" ,"2020-11-28 02:02:24.000" ,"19.11" ,"r-ZTF" ,"ZTF" ,"ZTF20acxuyqs" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczj" ,"330.52767917" ,"22:02:06.643" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczj", `TNSName`="AT2020aczj", `decDeg`="-5.662892", `decSex`="-05:39:46.41", `discDate`="2020-11-28 02:02:24.000", `discMag`="19.11", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxuyqs", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczj", `raDeg`="330.52767917", `raSex`="22:02:06.643", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczi" ,"AT2020aczi" ,"-23.404197" ,"-23:24:15.11" ,"2020-12-13 12:01:26.400" ,"18.09" ,"r-ZTF" ,"ZTF" ,"ZTF20acxkfoh" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczi" ,"164.3195333" ,"10:57:16.688" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczi", `TNSName`="AT2020aczi", `decDeg`="-23.404197", `decSex`="-23:24:15.11", `discDate`="2020-12-13 12:01:26.400", `discMag`="18.09", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxkfoh", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczi", `raDeg`="164.3195333", `raSex`="10:57:16.688", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczg" ,"SN2020aczg" ,"54.789561" ,"+54:47:22.42" ,"2020-12-17 13:46:33.600" ,"19.322" ,"cyan-ATLAS" ,"ATLAS, ZTF" ,"ATLAS20binb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aczg" ,"150.27777083" ,"10:01:06.665" ,"ATLAS, ZTF" ,"SN Ia" ,"0.025", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `TNSName`="SN2020aczg", `decDeg`="54.789561", `decSex`="+54:47:22.42", `discDate`="2020-12-17 13:46:33.600", `discMag`="19.322", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, ZTF", `discoveryName`="ATLAS20binb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczg", `raDeg`="150.27777083", `raSex`="10:01:06.665", `reportingSurvey`="ATLAS, ZTF", `specType`="SN Ia", `transRedshift`="0.025" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aczc" ,"AT2020aczc" ,"-1.067781" ,"-01:04:04.01" ,"2020-12-17 04:33:40.000" ,"20.2055" ,"g-ZTF" ,"ZTF" ,"ZTF20acxoocn" ,"KUG 0330-012" ,"0.030788" ,"http://wis-tns.weizmann.ac.il/object/2020aczc" ,"53.1853417" ,"03:32:44.482" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczc", `TNSName`="AT2020aczc", `decDeg`="-1.067781", `decSex`="-01:04:04.01", `discDate`="2020-12-17 04:33:40.000", `discMag`="20.2055", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxoocn", `hostName`="KUG 0330-012", `hostRedshift`="0.030788", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aczc", `raDeg`="53.1853417", `raSex`="03:32:44.482", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acyw" ,"AT2020acyw" ,"82.579464" ,"+82:34:46.07" ,"2020-12-17 04:48:00.000" ,"18.708" ,"cyan-ATLAS" ,"ATLAS, ZTF" ,"ATLAS20bilz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acyw" ,"321.292583" ,"21:25:10.220" ,"ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acyw", `TNSName`="AT2020acyw", `decDeg`="82.579464", `decSex`="+82:34:46.07", `discDate`="2020-12-17 04:48:00.000", `discMag`="18.708", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, ZTF", `discoveryName`="ATLAS20bilz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acyw", `raDeg`="321.292583", `raSex`="21:25:10.220", `reportingSurvey`="ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acxf" ,"AT2020acxf" ,"50.860708" ,"+50:51:38.55" ,"2020-12-07 14:29:45.600" ,"20.71" ,"g-Sloan" ,"Pan-STARRS1" ,"PS20mfc" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acxf" ,"141.29605416666666" ,"09:25:11.053" ,"YSE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acxf", `TNSName`="AT2020acxf", `decDeg`="50.860708", `decSex`="+50:51:38.55", `discDate`="2020-12-07 14:29:45.600", `discMag`="20.71", `discMagFilter`="g-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mfc", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acxf", `raDeg`="141.29605416666666", `raSex`="09:25:11.053", `reportingSurvey`="YSE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acwv" ,"AT2020acwv" ,"-8.988764" ,"-08:59:19.55" ,"2020-12-16 13:17:48.002" ,"18.9965" ,"r-ZTF" ,"ZTF" ,"ZTF20acxzsxb" ,"SDSS J150535.42-085918.5" ,"0.119" ,"http://wis-tns.weizmann.ac.il/object/2020acwv" ,"226.39734583333333" ,"15:05:35.363" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwv", `TNSName`="AT2020acwv", `decDeg`="-8.988764", `decSex`="-08:59:19.55", `discDate`="2020-12-16 13:17:48.002", `discMag`="18.9965", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxzsxb", `hostName`="SDSS J150535.42-085918.5", `hostRedshift`="0.119", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acwv", `raDeg`="226.39734583333333", `raSex`="15:05:35.363", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acws" ,"AT2020acws" ,"-9.608628" ,"-09:36:31.06" ,"2020-12-16 10:46:33.004" ,"19.4089" ,"r-ZTF" ,"ZTF" ,"ZTF20acxyury" ,"2MASX J09151447-0936374" ,"0.05307" ,"http://wis-tns.weizmann.ac.il/object/2020acws" ,"138.8113083" ,"09:15:14.714" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acws", `TNSName`="AT2020acws", `decDeg`="-9.608628", `decSex`="-09:36:31.06", `discDate`="2020-12-16 10:46:33.004", `discMag`="19.4089", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxyury", `hostName`="2MASX J09151447-0936374", `hostRedshift`="0.05307", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acws", `raDeg`="138.8113083", `raSex`="09:15:14.714", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acwk" ,"AT2020acwk" ,"40.775692" ,"+40:46:32.49" ,"2020-12-16 03:16:14.998" ,"19.5744" ,"r-ZTF" ,"ZTF" ,"ZTF20acxunmt" ,"WISEA J225522.69+404632.5" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acwk" ,"343.8445" ,"22:55:22.680" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwk", `TNSName`="AT2020acwk", `decDeg`="40.775692", `decSex`="+40:46:32.49", `discDate`="2020-12-16 03:16:14.998", `discMag`="19.5744", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxunmt", `hostName`="WISEA J225522.69+404632.5", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acwk", `raDeg`="343.8445", `raSex`="22:55:22.680", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acwg" ,"AT2020acwg" ,"62.996478" ,"+62:59:47.32" ,"2020-12-13 09:16:25.003" ,"20.0595" ,"r-ZTF" ,"ZTF" ,"ZTF20acxilne" ,"WISEA J072122.78+625947.1" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acwg" ,"110.343333" ,"07:21:22.400" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwg", `TNSName`="AT2020acwg", `decDeg`="62.996478", `decSex`="+62:59:47.32", `discDate`="2020-12-13 09:16:25.003", `discMag`="20.0595", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxilne", `hostName`="WISEA J072122.78+625947.1", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acwg", `raDeg`="110.343333", `raSex`="07:21:22.400", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acwd" ,"AT2020acwd" ,"14.835858" ,"+14:50:09.09" ,"2020-12-12 03:59:56.996" ,"20.1102" ,"g-ZTF" ,"ZTF" ,"ZTF20acxuloz" ,"MSPM 07478" ,"0.11754" ,"http://wis-tns.weizmann.ac.il/object/2020acwd" ,"1.927917" ,"00:07:42.700" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `TNSName`="AT2020acwd", `decDeg`="14.835858", `decSex`="+14:50:09.09", `discDate`="2020-12-12 03:59:56.996", `discMag`="20.1102", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxuloz", `hostName`="MSPM 07478", `hostRedshift`="0.11754", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acwd", `raDeg`="1.927917", `raSex`="00:07:42.700", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acvt" ,"AT2020acvt" ,"-13.942386" ,"-13:56:32.59" ,"2020-12-10 04:03:43.001" ,"19.896" ,"g-ZTF" ,"ZTF" ,"ZTF20acxaqar" ,"GALEXASC J003231.62-135632.5" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acvt" ,"8.13155417" ,"00:32:31.573" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `TNSName`="AT2020acvt", `decDeg`="-13.942386", `decSex`="-13:56:32.59", `discDate`="2020-12-10 04:03:43.001", `discMag`="19.896", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxaqar", `hostName`="GALEXASC J003231.62-135632.5", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acvt", `raDeg`="8.13155417", `raSex`="00:32:31.573", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acvm" ,"AT2020acvm" ,"12.460442" ,"+12:27:37.59" ,"2020-12-16 12:26:33.216" ,"18.48" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acxzkkf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acvm" ,"196.6530583" ,"13:06:36.734" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvm", `TNSName`="AT2020acvm", `decDeg`="12.460442", `decSex`="+12:27:37.59", `discDate`="2020-12-16 12:26:33.216", `discMag`="18.48", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acxzkkf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acvm", `raDeg`="196.6530583", `raSex`="13:06:36.734", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acvi" ,"AT2020acvi" ,"41.378086" ,"+41:22:41.11" ,"2020-12-11 10:44:43.008" ,"19.77" ,"g-ZTF" ,"ZTF" ,"ZTF20acwobyt" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acvi" ,"140.28965" ,"09:21:09.516" ,"ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvi", `TNSName`="AT2020acvi", `decDeg`="41.378086", `decSex`="+41:22:41.11", `discDate`="2020-12-11 10:44:43.008", `discMag`="19.77", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwobyt", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acvi", `raDeg`="140.28965", `raSex`="09:21:09.516", `reportingSurvey`="ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acvg" ,"AT2020acvg" ,"42.847211" ,"+42:50:49.96" ,"2020-12-15 20:17:38.112" ,"20.1" ,"L-GOTO" ,"GOTO, ATLAS, ZTF" ,"GOTO20bbf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acvg" ,"9.03865417" ,"00:36:09.277" ,"GOTO, ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvg", `TNSName`="AT2020acvg", `decDeg`="42.847211", `decSex`="+42:50:49.96", `discDate`="2020-12-15 20:17:38.112", `discMag`="20.1", `discMagFilter`="L-GOTO", `discSurvey`="GOTO, ATLAS, ZTF", `discoveryName`="GOTO20bbf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acvg", `raDeg`="9.03865417", `raSex`="00:36:09.277", `reportingSurvey`="GOTO, ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acur" ,"AT2020acur" ,"-1.931236" ,"-01:55:52.45" ,"2020-12-11 03:27:31.104" ,"19.42" ,"r-ZTF" ,"ZTF" ,"ZTF20acwscli" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acur" ,"4.6413416666666665" ,"00:18:33.922" ,"ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acur", `TNSName`="AT2020acur", `decDeg`="-1.931236", `decSex`="-01:55:52.45", `discDate`="2020-12-11 03:27:31.104", `discMag`="19.42", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwscli", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acur", `raDeg`="4.6413416666666665", `raSex`="00:18:33.922", `reportingSurvey`="ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acuo" ,"AT2020acuo" ,"8.011642" ,"+08:00:41.91" ,"2020-12-15 13:17:36.001" ,"19.2316" ,"r-ZTF" ,"ZTF" ,"ZTF20acxtfqs" ,"SDSS J153528.63+080042.8" ,"0.17" ,"http://wis-tns.weizmann.ac.il/object/2020acuo" ,"233.86907917" ,"15:35:28.579" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuo", `TNSName`="AT2020acuo", `decDeg`="8.011642", `decSex`="+08:00:41.91", `discDate`="2020-12-15 13:17:36.001", `discMag`="19.2316", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxtfqs", `hostName`="SDSS J153528.63+080042.8", `hostRedshift`="0.17", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acuo", `raDeg`="233.86907917", `raSex`="15:35:28.579", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acun" ,"AT2020acun" ,"-2.981939" ,"-02:58:54.98" ,"2020-12-15 13:16:55.004" ,"19.5069" ,"r-ZTF" ,"ZTF" ,"ZTF20acxtgek" ,"LCRS B150922.5-024726" ,"0.021595" ,"http://wis-tns.weizmann.ac.il/object/2020acun" ,"227.99084583" ,"15:11:57.803" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acun", `TNSName`="AT2020acun", `decDeg`="-2.981939", `decSex`="-02:58:54.98", `discDate`="2020-12-15 13:16:55.004", `discMag`="19.5069", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxtgek", `hostName`="LCRS B150922.5-024726", `hostRedshift`="0.021595", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acun", `raDeg`="227.99084583", `raSex`="15:11:57.803", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acuk" ,"AT2020acuk" ,"7.622644" ,"+07:37:21.52" ,"2020-12-15 13:02:27.997" ,"19.82" ,"g-ZTF" ,"ZTF" ,"ZTF20acxteqx" ,"SDSS J132321.96+073721.7" ,"0.127" ,"http://wis-tns.weizmann.ac.il/object/2020acuk" ,"200.8414583" ,"13:23:21.950" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuk", `TNSName`="AT2020acuk", `decDeg`="7.622644", `decSex`="+07:37:21.52", `discDate`="2020-12-15 13:02:27.997", `discMag`="19.82", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxteqx", `hostName`="SDSS J132321.96+073721.7", `hostRedshift`="0.127", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acuk", `raDeg`="200.8414583", `raSex`="13:23:21.950", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acui" ,"AT2020acui" ,"28.267967" ,"+28:16:04.68" ,"2020-12-15 12:56:59.997" ,"19.6185" ,"g-ZTF" ,"ZTF" ,"ZTF20acxtdst" ,"WISEA J144919.11+281607.4" ,"0.131219" ,"http://wis-tns.weizmann.ac.il/object/2020acui" ,"222.32959583" ,"14:49:19.103" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acui", `TNSName`="AT2020acui", `decDeg`="28.267967", `decSex`="+28:16:04.68", `discDate`="2020-12-15 12:56:59.997", `discMag`="19.6185", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxtdst", `hostName`="WISEA J144919.11+281607.4", `hostRedshift`="0.131219", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acui", `raDeg`="222.32959583", `raSex`="14:49:19.103", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acug" ,"AT2020acug" ,"9.796122" ,"+09:47:46.04" ,"2020-12-15 12:38:38.000" ,"20.0394" ,"g-ZTF" ,"ZTF" ,"ZTF20acxtdcm" ,"WISEA J121413.98+094747.2" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acug" ,"183.5590125" ,"12:14:14.163" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acug", `TNSName`="AT2020acug", `decDeg`="9.796122", `decSex`="+09:47:46.04", `discDate`="2020-12-15 12:38:38.000", `discMag`="20.0394", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxtdcm", `hostName`="WISEA J121413.98+094747.2", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acug", `raDeg`="183.5590125", `raSex`="12:14:14.163", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acuc" ,"AT2020acuc" ,"13.80144" ,"+13:48:05.20" ,"2020-12-15 11:59:03.002" ,"19.5295" ,"r-ZTF" ,"ZTF" ,"ZTF20acxsxbc" ,"2MASX J13521306+1348055" ,"0.06297" ,"http://wis-tns.weizmann.ac.il/object/2020acuc" ,"208.0571375" ,"13:52:13.713" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `TNSName`="AT2020acuc", `decDeg`="13.80144", `decSex`="+13:48:05.20", `discDate`="2020-12-15 11:59:03.002", `discMag`="19.5295", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxsxbc", `hostName`="2MASX J13521306+1348055", `hostRedshift`="0.06297", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acuc", `raDeg`="208.0571375", `raSex`="13:52:13.713", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acua" ,"AT2020acua" ,"21.7239" ,"+21:43:26.04" ,"2020-12-15 11:27:21.001" ,"18.3259" ,"r-ZTF" ,"ZTF" ,"ZTF18aahfbqp" ,"CGCG 124-021" ,"0.041362" ,"http://wis-tns.weizmann.ac.il/object/2020acua" ,"156.67844583" ,"10:26:42.827" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acua", `TNSName`="AT2020acua", `decDeg`="21.7239", `decSex`="+21:43:26.04", `discDate`="2020-12-15 11:27:21.001", `discMag`="18.3259", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18aahfbqp", `hostName`="CGCG 124-021", `hostRedshift`="0.041362", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acua", `raDeg`="156.67844583", `raSex`="10:26:42.827", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acty" ,"AT2020acty" ,"30.99467" ,"+30:59:40.80" ,"2020-12-15 09:27:01.996" ,"20.2009" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acxqxyw" ,"WISE J092235.65+305937.5" ,"0.04703" ,"http://wis-tns.weizmann.ac.il/object/2020acty" ,"140.6499625" ,"09:22:35.991" ,"ALeRCE, YSE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acty", `TNSName`="AT2020acty", `decDeg`="30.99467", `decSex`="+30:59:40.80", `discDate`="2020-12-15 09:27:01.996", `discMag`="20.2009", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acxqxyw", `hostName`="WISE J092235.65+305937.5", `hostRedshift`="0.04703", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acty", `raDeg`="140.6499625", `raSex`="09:22:35.991", `reportingSurvey`="ALeRCE, YSE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020actn" ,"AT2020actn" ,"10.661069" ,"+10:39:39.85" ,"2020-12-12 12:37:00.998" ,"19.8178" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acxfdjs" ,"WISEA J113910.08+103940.5" ,"0.084241" ,"http://wis-tns.weizmann.ac.il/object/2020actn" ,"174.79267917" ,"11:39:10.243" ,"ALeRCE, YSE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actn", `TNSName`="AT2020actn", `decDeg`="10.661069", `decSex`="+10:39:39.85", `discDate`="2020-12-12 12:37:00.998", `discMag`="19.8178", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acxfdjs", `hostName`="WISEA J113910.08+103940.5", `hostRedshift`="0.084241", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020actn", `raDeg`="174.79267917", `raSex`="11:39:10.243", `reportingSurvey`="ALeRCE, YSE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020actc" ,"AT2020actc" ,"21.096078" ,"+21:05:45.88" ,"2020-12-11 10:40:26.996" ,"20.1343" ,"g-ZTF" ,"ZTF" ,"ZTF20acxtaau" ,"SDSS J100316.36+210545.9" ,"0.145468" ,"http://wis-tns.weizmann.ac.il/object/2020actc" ,"150.81822083333333" ,"10:03:16.373" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actc", `TNSName`="AT2020actc", `decDeg`="21.096078", `decSex`="+21:05:45.88", `discDate`="2020-12-11 10:40:26.996", `discMag`="20.1343", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxtaau", `hostName`="SDSS J100316.36+210545.9", `hostRedshift`="0.145468", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020actc", `raDeg`="150.81822083333333", `raSex`="10:03:16.373", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acsz" ,"AT2020acsz" ,"1.763744" ,"+01:45:49.48" ,"2020-12-10 13:22:37.001" ,"19.7399" ,"r-ZTF" ,"ZTF" ,"ZTF20acxtfta" ,"WISEA J151541.54+014549.0" ,"0.130179" ,"http://wis-tns.weizmann.ac.il/object/2020acsz" ,"228.92142083" ,"15:15:41.141" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsz", `TNSName`="AT2020acsz", `decDeg`="1.763744", `decSex`="+01:45:49.48", `discDate`="2020-12-10 13:22:37.001", `discMag`="19.7399", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxtfta", `hostName`="WISEA J151541.54+014549.0", `hostRedshift`="0.130179", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acsz", `raDeg`="228.92142083", `raSex`="15:15:41.141", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acss" ,"AT2020acss" ,"72.901386" ,"+72:54:04.99" ,"2020-12-10 10:38:50.997" ,"20.6592" ,"g-ZTF" ,"ZTF" ,"ZTF20acxsyvj" ,"WISEA J130224.77+725405.2" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acss" ,"195.6034333" ,"13:02:24.824" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `TNSName`="AT2020acss", `decDeg`="72.901386", `decSex`="+72:54:04.99", `discDate`="2020-12-10 10:38:50.997", `discMag`="20.6592", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acxsyvj", `hostName`="WISEA J130224.77+725405.2", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acss", `raDeg`="195.6034333", `raSex`="13:02:24.824", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acsn" ,"SN2020acsn" ,"30.723986" ,"+30:43:26.35" ,"2020-12-14 06:24:28.800" ,"19.531" ,"cyan-ATLAS" ,"ATLAS, ZTF" ,"ATLAS20biko" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acsn" ,"345.98972917" ,"23:03:57.535" ,"ATLAS, ZTF" ,"SN Ia" ,"0.06", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsn", `TNSName`="SN2020acsn", `decDeg`="30.723986", `decSex`="+30:43:26.35", `discDate`="2020-12-14 06:24:28.800", `discMag`="19.531", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, ZTF", `discoveryName`="ATLAS20biko", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acsn", `raDeg`="345.98972917", `raSex`="23:03:57.535", `reportingSurvey`="ATLAS, ZTF", `specType`="SN Ia", `transRedshift`="0.06" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acse" ,"AT2020acse" ,"-27.256314" ,"-27:15:22.73" ,"2020-12-14 12:28:48.000" ,"19.367" ,"cyan-ATLAS" ,"ATLAS, ZTF" ,"ATLAS20bijj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acse" ,"151.62151666666668" ,"10:06:29.164" ,"ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acse", `TNSName`="AT2020acse", `decDeg`="-27.256314", `decSex`="-27:15:22.73", `discDate`="2020-12-14 12:28:48.000", `discMag`="19.367", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, ZTF", `discoveryName`="ATLAS20bijj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acse", `raDeg`="151.62151666666668", `raSex`="10:06:29.164", `reportingSurvey`="ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acrz" ,"AT2020acrz" ,"-19.117397" ,"-19:07:02.63" ,"2020-12-14 09:48:57.600" ,"19.415" ,"cyan-ATLAS" ,"ATLAS, ZTF" ,"ATLAS20biio" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acrz" ,"83.24689583" ,"05:32:59.255" ,"ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrz", `TNSName`="AT2020acrz", `decDeg`="-19.117397", `decSex`="-19:07:02.63", `discDate`="2020-12-14 09:48:57.600", `discMag`="19.415", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, ZTF", `discoveryName`="ATLAS20biio", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acrz", `raDeg`="83.24689583", `raSex`="05:32:59.255", `reportingSurvey`="ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acrc" ,"AT2020acrc" ,"-2.008031" ,"-02:00:28.91" ,"2020-12-10 11:29:37.824" ,"19.4" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acwpivy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acrc" ,"177.111175" ,"11:48:26.682" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrc", `TNSName`="AT2020acrc", `decDeg`="-2.008031", `decSex`="-02:00:28.91", `discDate`="2020-12-10 11:29:37.824", `discMag`="19.4", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acwpivy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acrc", `raDeg`="177.111175", `raSex`="11:48:26.682", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acqv" ,"AT2020acqv" ,"78.58614" ,"+78:35:10.10" ,"2020-12-15 08:51:06.048" ,"19.02" ,"g-ZTF" ,"ZTF" ,"ZTF20acwqkuz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acqv" ,"196.0129625" ,"13:04:03.111" ,"ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acqv", `TNSName`="AT2020acqv", `decDeg`="78.58614", `decSex`="+78:35:10.10", `discDate`="2020-12-15 08:51:06.048", `discMag`="19.02", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwqkuz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acqv", `raDeg`="196.0129625", `raSex`="13:04:03.111", `reportingSurvey`="ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acpc" ,"SN2020acpc" ,"24.30211" ,"+24:18:07.60" ,"2020-12-12 12:28:48.000" ,"18" ,"g-Sloan" ,"ASAS-SN, ATLAS" ,"ASASSN-20pu" ,"WISEA J094236.66+241835.8" ,"0.051371" ,"http://wis-tns.weizmann.ac.il/object/2020acpc" ,"145.6559625" ,"09:42:37.431" ,"ASAS-SN, ATLAS" ,"SN Ia" ,"0.051371", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpc", `TNSName`="SN2020acpc", `decDeg`="24.30211", `decSex`="+24:18:07.60", `discDate`="2020-12-12 12:28:48.000", `discMag`="18", `discMagFilter`="g-Sloan", `discSurvey`="ASAS-SN, ATLAS", `discoveryName`="ASASSN-20pu", `hostName`="WISEA J094236.66+241835.8", `hostRedshift`="0.051371", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acpc", `raDeg`="145.6559625", `raSex`="09:42:37.431", `reportingSurvey`="ASAS-SN, ATLAS", `specType`="SN Ia", `transRedshift`="0.051371" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acpb" ,"SN2020acpb" ,"4.717375" ,"+04:43:02.55" ,"2020-12-14 02:19:39.003" ,"18.9575" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acxlaih" ,"SDSS J220916.94+044302.9" ,"0.066" ,"http://wis-tns.weizmann.ac.il/object/2020acpb" ,"332.31997083333334" ,"22:09:16.793" ,"ALeRCE, ATLAS, ZTF" ,"SN Ia" ,"0.0388224", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `TNSName`="SN2020acpb", `decDeg`="4.717375", `decSex`="+04:43:02.55", `discDate`="2020-12-14 02:19:39.003", `discMag`="18.9575", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acxlaih", `hostName`="SDSS J220916.94+044302.9", `hostRedshift`="0.066", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acpb", `raDeg`="332.31997083333334", `raSex`="22:09:16.793", `reportingSurvey`="ALeRCE, ATLAS, ZTF", `specType`="SN Ia", `transRedshift`="0.0388224" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acof" ,"AT2020acof" ,"51.86225" ,"+51:51:44.10" ,"2020-12-11 10:20:49.001" ,"20.2589" ,"g-ZTF" ,"ZTF" ,"ZTF20acwxiad" ,"WISEA J073433.93+515149.4" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acof" ,"113.63988333333333" ,"07:34:33.572" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acof", `TNSName`="AT2020acof", `decDeg`="51.86225", `decSex`="+51:51:44.10", `discDate`="2020-12-11 10:20:49.001", `discMag`="20.2589", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwxiad", `hostName`="WISEA J073433.93+515149.4", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acof", `raDeg`="113.63988333333333", `raSex`="07:34:33.572", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acnm" ,"AT2020acnm" ,"15.912025" ,"+15:54:43.29" ,"2020-12-07 04:09:07.200" ,"20.4772" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acxcsyo" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acnm" ,"41.7303" ,"02:46:55.272" ,"ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acnm", `TNSName`="AT2020acnm", `decDeg`="15.912025", `decSex`="+15:54:43.29", `discDate`="2020-12-07 04:09:07.200", `discMag`="20.4772", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acxcsyo", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acnm", `raDeg`="41.7303", `raSex`="02:46:55.272", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acmp" ,"AT2020acmp" ,"26.951756" ,"+26:57:06.32" ,"2020-12-12 12:11:46.000" ,"19.8213" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acxfced" ,"WISEA J123450.56+265707.3" ,"0.067493" ,"http://wis-tns.weizmann.ac.il/object/2020acmp" ,"188.71035" ,"12:34:50.484" ,"ALeRCE, ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmp", `TNSName`="AT2020acmp", `decDeg`="26.951756", `decSex`="+26:57:06.32", `discDate`="2020-12-12 12:11:46.000", `discMag`="19.8213", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acxfced", `hostName`="WISEA J123450.56+265707.3", `hostRedshift`="0.067493", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acmp", `raDeg`="188.71035", `raSex`="12:34:50.484", `reportingSurvey`="ALeRCE, ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acmn" ,"AT2020acmn" ,"4.229142" ,"+04:13:44.91" ,"2020-12-12 05:05:38.003" ,"20.1142" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acxbnjd" ,"SDSS J015926.74+041345.7" ,"0.077" ,"http://wis-tns.weizmann.ac.il/object/2020acmn" ,"29.8619875" ,"01:59:26.877" ,"ALeRCE, ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `TNSName`="AT2020acmn", `decDeg`="4.229142", `decSex`="+04:13:44.91", `discDate`="2020-12-12 05:05:38.003", `discMag`="20.1142", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acxbnjd", `hostName`="SDSS J015926.74+041345.7", `hostRedshift`="0.077", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acmn", `raDeg`="29.8619875", `raSex`="01:59:26.877", `reportingSurvey`="ALeRCE, ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acmm" ,"AT2020acmm" ,"2.170322" ,"+02:10:13.16" ,"2020-12-12 04:06:11.998" ,"19.6643" ,"g-ZTF" ,"ZTF, Pan-STARRS1, ATLAS" ,"ZTF20acxbbaj" ,"SDSS J003651.65+021011.8" ,"0.107" ,"http://wis-tns.weizmann.ac.il/object/2020acmm" ,"9.2143375" ,"00:36:51.441" ,"ALeRCE, Pan-STARRS1, ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `TNSName`="AT2020acmm", `decDeg`="2.170322", `decSex`="+02:10:13.16", `discDate`="2020-12-12 04:06:11.998", `discMag`="19.6643", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS", `discoveryName`="ZTF20acxbbaj", `hostName`="SDSS J003651.65+021011.8", `hostRedshift`="0.107", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acmm", `raDeg`="9.2143375", `raSex`="00:36:51.441", `reportingSurvey`="ALeRCE, Pan-STARRS1, ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acmc" ,"AT2020acmc" ,"-20.280458" ,"-20:16:49.65" ,"2020-12-10 04:03:02.998" ,"20.3824" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acxbadv" ,"GALEXASC J010143.58-201650.0" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acmc" ,"15.431725" ,"01:01:43.614" ,"ALeRCE, ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmc", `TNSName`="AT2020acmc", `decDeg`="-20.280458", `decSex`="-20:16:49.65", `discDate`="2020-12-10 04:03:02.998", `discMag`="20.3824", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acxbadv", `hostName`="GALEXASC J010143.58-201650.0", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acmc", `raDeg`="15.431725", `raSex`="01:01:43.614", `reportingSurvey`="ALeRCE, ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acjw" ,"AT2020acjw" ,"27.24283" ,"+27:14:34.20" ,"2020-12-11 12:25:13.002" ,"19.4447" ,"r-ZTF" ,"ZTF" ,"ZTF20acwqndp" ,"2MASX J11310076+2714419" ,"0.053139" ,"http://wis-tns.weizmann.ac.il/object/2020acjw" ,"172.75382917" ,"11:31:00.919" ,"ALeRCE, ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjw", `TNSName`="AT2020acjw", `decDeg`="27.24283", `decSex`="+27:14:34.20", `discDate`="2020-12-11 12:25:13.002", `discMag`="19.4447", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwqndp", `hostName`="2MASX J11310076+2714419", `hostRedshift`="0.053139", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acjw", `raDeg`="172.75382917", `raSex`="11:31:00.919", `reportingSurvey`="ALeRCE, ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acjm" ,"AT2020acjm" ,"8.875069" ,"+08:52:30.25" ,"2020-12-11 11:08:54.001" ,"20.1397" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acwwcdu" ,"SDSS J081515.03+085229.4" ,"0.13" ,"http://wis-tns.weizmann.ac.il/object/2020acjm" ,"123.8126917" ,"08:15:15.046" ,"ALeRCE, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjm", `TNSName`="AT2020acjm", `decDeg`="8.875069", `decSex`="+08:52:30.25", `discDate`="2020-12-11 11:08:54.001", `discMag`="20.1397", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acwwcdu", `hostName`="SDSS J081515.03+085229.4", `hostRedshift`="0.13", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acjm", `raDeg`="123.8126917", `raSex`="08:15:15.046", `reportingSurvey`="ALeRCE, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acjd" ,"AT2020acjd" ,"27.31881" ,"+27:19:07.70" ,"2020-12-11 10:41:47.996" ,"20.0122" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acwogqz" ,"WISEA J104041.63+271909.0" ,"0.090981" ,"http://wis-tns.weizmann.ac.il/object/2020acjd" ,"160.1732333" ,"10:40:41.576" ,"ALeRCE, ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjd", `TNSName`="AT2020acjd", `decDeg`="27.31881", `decSex`="+27:19:07.70", `discDate`="2020-12-11 10:41:47.996", `discMag`="20.0122", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acwogqz", `hostName`="WISEA J104041.63+271909.0", `hostRedshift`="0.090981", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acjd", `raDeg`="160.1732333", `raSex`="10:40:41.576", `reportingSurvey`="ALeRCE, ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acjb" ,"AT2020acjb" ,"19.302431" ,"+19:18:08.75" ,"2020-12-11 10:40:26.996" ,"19.6186" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acwohcl" ,"SDSS J101056.54+191808.4" ,"0.129" ,"http://wis-tns.weizmann.ac.il/object/2020acjb" ,"152.73559583" ,"10:10:56.543" ,"ALeRCE, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjb", `TNSName`="AT2020acjb", `decDeg`="19.302431", `decSex`="+19:18:08.75", `discDate`="2020-12-11 10:40:26.996", `discMag`="19.6186", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acwohcl", `hostName`="SDSS J101056.54+191808.4", `hostRedshift`="0.129", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acjb", `raDeg`="152.73559583", `raSex`="10:10:56.543", `reportingSurvey`="ALeRCE, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acip" ,"AT2020acip" ,"48.711589" ,"+48:42:41.72" ,"2020-11-23 12:19:35.040" ,"20.3793" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acvkwkp" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acip" ,"191.557425" ,"12:46:13.782" ,"ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acip", `TNSName`="AT2020acip", `decDeg`="48.711589", `decSex`="+48:42:41.72", `discDate`="2020-11-23 12:19:35.040", `discMag`="20.3793", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acvkwkp", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acip", `raDeg`="191.557425", `raSex`="12:46:13.782", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acif" ,"AT2020acif" ,"21.748319" ,"+21:44:53.95" ,"2020-12-09 12:20:52.999" ,"19.54" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acwyihb" ,"WISEA J143815.55+214456.1" ,"0.062157" ,"http://wis-tns.weizmann.ac.il/object/2020acif" ,"219.5642917" ,"14:38:15.430" ,"ALeRCE, ZTF, ATLAS, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `TNSName`="AT2020acif", `decDeg`="21.748319", `decSex`="+21:44:53.95", `discDate`="2020-12-09 12:20:52.999", `discMag`="19.54", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acwyihb", `hostName`="WISEA J143815.55+214456.1", `hostRedshift`="0.062157", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acif", `raDeg`="219.5642917", `raSex`="14:38:15.430", `reportingSurvey`="ALeRCE, ZTF, ATLAS, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acic" ,"AT2020acic" ,"58.093875" ,"+58:05:37.95" ,"2020-12-06 12:30:07.004" ,"20.6089" ,"g-ZTF" ,"ZTF" ,"ZTF20acwoewh" ,"SDSS J103623.81+580538.9" ,"0.115" ,"http://wis-tns.weizmann.ac.il/object/2020acic" ,"159.0990167" ,"10:36:23.764" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acic", `TNSName`="AT2020acic", `decDeg`="58.093875", `decSex`="+58:05:37.95", `discDate`="2020-12-06 12:30:07.004", `discMag`="20.6089", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwoewh", `hostName`="SDSS J103623.81+580538.9", `hostRedshift`="0.115", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acic", `raDeg`="159.0990167", `raSex`="10:36:23.764", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acht" ,"AT2020acht" ,"6.01875" ,"+06:01:07.50" ,"2020-12-05 13:00:27.003" ,"20.2522" ,"g-ZTF" ,"ZTF" ,"ZTF20acwyknf" ,"SDSS J121220.57+060106.0" ,"0.162" ,"http://wis-tns.weizmann.ac.il/object/2020acht" ,"183.0855667" ,"12:12:20.536" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acht", `TNSName`="AT2020acht", `decDeg`="6.01875", `decSex`="+06:01:07.50", `discDate`="2020-12-05 13:00:27.003", `discMag`="20.2522", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwyknf", `hostName`="SDSS J121220.57+060106.0", `hostRedshift`="0.162", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acht", `raDeg`="183.0855667", `raSex`="12:12:20.536", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acgf" ,"AT2020acgf" ,"-23.973836" ,"-23:58:25.81" ,"2020-12-02 07:47:47.040" ,"19.7685" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acwimuf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acgf" ,"71.17447083333333" ,"04:44:41.873" ,"ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acgf", `TNSName`="AT2020acgf", `decDeg`="-23.973836", `decSex`="-23:58:25.81", `discDate`="2020-12-02 07:47:47.040", `discMag`="19.7685", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acwimuf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acgf", `raDeg`="71.17447083333333", `raSex`="04:44:41.873", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acfp" ,"AT2020acfp" ,"47.379431" ,"+47:22:45.95" ,"2020-12-10 10:39:38.880" ,"19.5908" ,"g-ZTF" ,"ZTF" ,"ZTF20acwofhd" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acfp" ,"171.89409583" ,"11:27:34.583" ,"ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acfp", `TNSName`="AT2020acfp", `decDeg`="47.379431", `decSex`="+47:22:45.95", `discDate`="2020-12-10 10:39:38.880", `discMag`="19.5908", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwofhd", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acfp", `raDeg`="171.89409583", `raSex`="11:27:34.583", `reportingSurvey`="ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acez" ,"AT2020acez" ,"58.944794" ,"+58:56:41.26" ,"2020-12-10 12:40:59.998" ,"19.7391" ,"r-ZTF" ,"ZTF" ,"ZTF20acwqlpq" ,"WISEA J142009.01+585645.8" ,"0.071951" ,"http://wis-tns.weizmann.ac.il/object/2020acez" ,"215.03840417" ,"14:20:09.217" ,"ALeRCE, ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acez", `TNSName`="AT2020acez", `decDeg`="58.944794", `decSex`="+58:56:41.26", `discDate`="2020-12-10 12:40:59.998", `discMag`="19.7391", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwqlpq", `hostName`="WISEA J142009.01+585645.8", `hostRedshift`="0.071951", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acez", `raDeg`="215.03840417", `raSex`="14:20:09.217", `reportingSurvey`="ALeRCE, ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acey" ,"AT2020acey" ,"-22.069519" ,"-22:04:10.27" ,"2020-12-10 12:28:14.002" ,"19.3417" ,"r-ZTF" ,"ZTF" ,"ZTF20acwqitw" ,"WISEA J100406.87-220410.1" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acey" ,"151.0286917" ,"10:04:06.886" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acey", `TNSName`="AT2020acey", `decDeg`="-22.069519", `decSex`="-22:04:10.27", `discDate`="2020-12-10 12:28:14.002", `discMag`="19.3417", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwqitw", `hostName`="WISEA J100406.87-220410.1", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acey", `raDeg`="151.0286917", `raSex`="10:04:06.886", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acet" ,"AT2020acet" ,"3.002558" ,"+03:00:09.21" ,"2020-12-10 11:28:58.002" ,"19.7305" ,"g-ZTF" ,"ZTF" ,"ZTF20acwqqax" ,"WISEA J115731.97+030011.3" ,"0.085553" ,"http://wis-tns.weizmann.ac.il/object/2020acet" ,"179.38205" ,"11:57:31.692" ,"ALeRCE, ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acet", `TNSName`="AT2020acet", `decDeg`="3.002558", `decSex`="+03:00:09.21", `discDate`="2020-12-10 11:28:58.002", `discMag`="19.7305", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwqqax", `hostName`="WISEA J115731.97+030011.3", `hostRedshift`="0.085553", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acet", `raDeg`="179.38205", `raSex`="11:57:31.692", `reportingSurvey`="ALeRCE, ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acer" ,"AT2020acer" ,"47.068033" ,"+47:04:04.92" ,"2020-12-10 11:20:10.003" ,"19.4837" ,"g-ZTF" ,"ZTF" ,"ZTF20acwpibn" ,"SDSS J123807.94+470407.2" ,"0.105" ,"http://wis-tns.weizmann.ac.il/object/2020acer" ,"189.5338" ,"12:38:08.112" ,"ALeRCE, ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acer", `TNSName`="AT2020acer", `decDeg`="47.068033", `decSex`="+47:04:04.92", `discDate`="2020-12-10 11:20:10.003", `discMag`="19.4837", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwpibn", `hostName`="SDSS J123807.94+470407.2", `hostRedshift`="0.105", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acer", `raDeg`="189.5338", `raSex`="12:38:08.112", `reportingSurvey`="ALeRCE, ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acej" ,"AT2020acej" ,"14.311725" ,"+14:18:42.21" ,"2020-12-10 11:07:44.000" ,"18.9834" ,"g-ZTF" ,"ZTF" ,"ZTF20acwphqb" ,"SDSS J120214.98+141841.3" ,"0.095" ,"http://wis-tns.weizmann.ac.il/object/2020acej" ,"180.56227916666666" ,"12:02:14.947" ,"ALeRCE, ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acej", `TNSName`="AT2020acej", `decDeg`="14.311725", `decSex`="+14:18:42.21", `discDate`="2020-12-10 11:07:44.000", `discMag`="18.9834", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwphqb", `hostName`="SDSS J120214.98+141841.3", `hostRedshift`="0.095", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acej", `raDeg`="180.56227916666666", `raSex`="12:02:14.947", `reportingSurvey`="ALeRCE, ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aceg" ,"SN2020aceg" ,"58.657592" ,"+58:39:27.33" ,"2020-12-10 10:37:18.998" ,"20.3087" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acwozwz" ,"GALEXASC J110207.76+583928.7" ,null ,"http://wis-tns.weizmann.ac.il/object/2020aceg" ,"165.5343125" ,"11:02:08.235" ,"ALeRCE, ZTF, ATLAS" ,"SN Ia" ,"0.06", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `TNSName`="SN2020aceg", `decDeg`="58.657592", `decSex`="+58:39:27.33", `discDate`="2020-12-10 10:37:18.998", `discMag`="20.3087", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acwozwz", `hostName`="GALEXASC J110207.76+583928.7", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aceg", `raDeg`="165.5343125", `raSex`="11:02:08.235", `reportingSurvey`="ALeRCE, ZTF, ATLAS", `specType`="SN Ia", `transRedshift`="0.06" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acef" ,"SN2020acef" ,"22.979144" ,"+22:58:44.92" ,"2020-12-10 10:07:39.003" ,"19.7194" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acwnrty" ,"SDSS J094424.00+225843.7" ,"0.114" ,"http://wis-tns.weizmann.ac.il/object/2020acef" ,"146.0998875" ,"09:44:23.973" ,"ALeRCE, ATLAS, ZTF, Pan-STARRS1, Fink" ,"SN Ia-91T-like" ,"0.065", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `TNSName`="SN2020acef", `decDeg`="22.979144", `decSex`="+22:58:44.92", `discDate`="2020-12-10 10:07:39.003", `discMag`="19.7194", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acwnrty", `hostName`="SDSS J094424.00+225843.7", `hostRedshift`="0.114", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acef", `raDeg`="146.0998875", `raSex`="09:44:23.973", `reportingSurvey`="ALeRCE, ATLAS, ZTF, Pan-STARRS1, Fink", `specType`="SN Ia-91T-like", `transRedshift`="0.065" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aced" ,"SN2020aced" ,"18.719217" ,"+18:43:09.18" ,"2020-12-10 10:05:36.997" ,"18.3715" ,"g-ZTF" ,"ZTF" ,"ZTF20acwoamm" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aced" ,"127.80620417" ,"08:31:13.489" ,"ALeRCE, ZTF, Fink" ,"SN Ia" ,"0.067", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `TNSName`="SN2020aced", `decDeg`="18.719217", `decSex`="+18:43:09.18", `discDate`="2020-12-10 10:05:36.997", `discMag`="18.3715", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwoamm", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aced", `raDeg`="127.80620417", `raSex`="08:31:13.489", `reportingSurvey`="ALeRCE, ZTF, Fink", `specType`="SN Ia", `transRedshift`="0.067" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acdz" ,"AT2020acdz" ,"-26.79025" ,"-26:47:24.90" ,"2020-12-10 08:01:15.001" ,"18.8967" ,"g-ZTF" ,"ZTF, GaiaAlerts, ATLAS" ,"ZTF20acwlsro" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acdz" ,"93.33175" ,"06:13:19.620" ,"ALeRCE, ZTF, GaiaAlerts, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `TNSName`="AT2020acdz", `decDeg`="-26.79025", `decSex`="-26:47:24.90", `discDate`="2020-12-10 08:01:15.001", `discMag`="18.8967", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, GaiaAlerts, ATLAS", `discoveryName`="ZTF20acwlsro", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acdz", `raDeg`="93.33175", `raSex`="06:13:19.620", `reportingSurvey`="ALeRCE, ZTF, GaiaAlerts, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acdw" ,"AT2020acdw" ,"26.500942" ,"+26:30:03.39" ,"2020-12-10 07:23:32.004" ,"18.9712" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acwkwqn" ,"WISEA J070244.97+263002.7" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acdw" ,"105.68724583" ,"07:02:44.939" ,"ALeRCE, ATLAS, ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `TNSName`="AT2020acdw", `decDeg`="26.500942", `decSex`="+26:30:03.39", `discDate`="2020-12-10 07:23:32.004", `discMag`="18.9712", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acwkwqn", `hostName`="WISEA J070244.97+263002.7", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acdw", `raDeg`="105.68724583", `raSex`="07:02:44.939", `reportingSurvey`="ALeRCE, ATLAS, ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acdv" ,"AT2020acdv" ,"23.62597" ,"+23:37:33.50" ,"2020-12-10 07:23:32.004" ,"18.9601" ,"r-ZTF" ,"ZTF" ,"ZTF20acwkvgj" ,"WISEA J071330.00+233733.9" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acdv" ,"108.3752083" ,"07:13:30.050" ,"ALeRCE, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdv", `TNSName`="AT2020acdv", `decDeg`="23.62597", `decSex`="+23:37:33.50", `discDate`="2020-12-10 07:23:32.004", `discMag`="18.9601", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwkvgj", `hostName`="WISEA J071330.00+233733.9", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acdv", `raDeg`="108.3752083", `raSex`="07:13:30.050", `reportingSurvey`="ALeRCE, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acdu" ,"AT2020acdu" ,"-11.330733" ,"-11:19:50.64" ,"2020-12-10 06:30:05.000" ,"20.1867" ,"r-ZTF" ,"ZTF" ,"ZTF20acwjhpo" ,"SDSS J040010.74-111952.0" ,"0.05" ,"http://wis-tns.weizmann.ac.il/object/2020acdu" ,"60.0446083" ,"04:00:10.706" ,"ALeRCE, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdu", `TNSName`="AT2020acdu", `decDeg`="-11.330733", `decSex`="-11:19:50.64", `discDate`="2020-12-10 06:30:05.000", `discMag`="20.1867", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acwjhpo", `hostName`="SDSS J040010.74-111952.0", `hostRedshift`="0.05", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acdu", `raDeg`="60.0446083", `raSex`="04:00:10.706", `reportingSurvey`="ALeRCE, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acdr" ,"AT2020acdr" ,"-15.424886" ,"-15:25:29.59" ,"2020-12-10 05:55:54.002" ,"19.9193" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acwikji" ,"WISEA J014511.22-152529.9" ,null ,"http://wis-tns.weizmann.ac.il/object/2020acdr" ,"26.2964" ,"01:45:11.136" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdr", `TNSName`="AT2020acdr", `decDeg`="-15.424886", `decSex`="-15:25:29.59", `discDate`="2020-12-10 05:55:54.002", `discMag`="19.9193", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acwikji", `hostName`="WISEA J014511.22-152529.9", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acdr", `raDeg`="26.2964", `raSex`="01:45:11.136", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acca" ,"AT2020acca" ,"-20.31578" ,"-20:18:56.80" ,"2020-12-07 04:20:38.400" ,"20.23" ,"r-ZTF" ,"ZTF, Pan-STARRS1, ATLAS" ,"ZTF20acwijiy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acca" ,"67.9541" ,"04:31:48.984" ,"ZTF, Pan-STARRS1, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `TNSName`="AT2020acca", `decDeg`="-20.31578", `decSex`="-20:18:56.80", `discDate`="2020-12-07 04:20:38.400", `discMag`="20.23", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS", `discoveryName`="ZTF20acwijiy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acca", `raDeg`="67.9541", `raSex`="04:31:48.984", `reportingSurvey`="ZTF, Pan-STARRS1, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acbw" ,"AT2020acbw" ,"56.564675" ,"+56:33:52.83" ,"2020-12-05 10:57:32.832" ,"19.97" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acwofly" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acbw" ,"163.64812917" ,"10:54:35.551" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbw", `TNSName`="AT2020acbw", `decDeg`="56.564675", `decSex`="+56:33:52.83", `discDate`="2020-12-05 10:57:32.832", `discMag`="19.97", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acwofly", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acbw", `raDeg`="163.64812917", `raSex`="10:54:35.551", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acbm" ,"SN2020acbm" ,"2.427069" ,"+02:25:37.45" ,"2020-12-10 04:43:40.800" ,"18.36" ,"g-ZTF" ,"ZTF, ATLAS, GaiaAlerts" ,"ZTF20acwgxhk" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acbm" ,"40.074167" ,"02:40:17.800" ,"ZTF, ATLAS, GaiaAlerts" ,"SN II" ,"0.021", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `TNSName`="SN2020acbm", `decDeg`="2.427069", `decSex`="+02:25:37.45", `discDate`="2020-12-10 04:43:40.800", `discMag`="18.36", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, GaiaAlerts", `discoveryName`="ZTF20acwgxhk", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acbm", `raDeg`="40.074167", `raSex`="02:40:17.800", `reportingSurvey`="ZTF, ATLAS, GaiaAlerts", `specType`="SN II", `transRedshift`="0.021" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acbc" ,"SN2020acbc" ,"-24.834947" ,"-24:50:05.81" ,"2020-12-06 06:15:19.296" ,"20.04" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acwilfu" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acbc" ,"64.17187917" ,"04:16:41.251" ,"ZTF, ATLAS" ,"SN Ia" ,"0.13", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbc", `TNSName`="SN2020acbc", `decDeg`="-24.834947", `decSex`="-24:50:05.81", `discDate`="2020-12-06 06:15:19.296", `discMag`="20.04", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acwilfu", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acbc", `raDeg`="64.17187917", `raSex`="04:16:41.251", `reportingSurvey`="ZTF, ATLAS", `specType`="SN Ia", `transRedshift`="0.13" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acba" ,"AT2020acba" ,"-24.563294" ,"-24:33:47.86" ,"2020-12-10 06:47:47.616" ,"19.48" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acvcxkd" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acba" ,"77.92767083" ,"05:11:42.641" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acba", `TNSName`="AT2020acba", `decDeg`="-24.563294", `decSex`="-24:33:47.86", `discDate`="2020-12-10 06:47:47.616", `discMag`="19.48", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acvcxkd", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acba", `raDeg`="77.92767083", `raSex`="05:11:42.641", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acat" ,"SN2020acat" ,"-10.227469" ,"-10:13:38.89" ,"2020-12-09 15:07:12.000" ,"18.48" ,"orange-ATLAS" ,"ATLAS, ZTF, Pan-STARRS1" ,"ATLAS20bhfe" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020acat" ,"177.67175416666666" ,"11:50:41.221" ,"ATLAS, ZTF, Pan-STARRS1" ,"SN IIb" ,"0.0079", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `TNSName`="SN2020acat", `decDeg`="-10.227469", `decSex`="-10:13:38.89", `discDate`="2020-12-09 15:07:12.000", `discMag`="18.48", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS, ZTF, Pan-STARRS1", `discoveryName`="ATLAS20bhfe", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020acat", `raDeg`="177.67175416666666", `raSex`="11:50:41.221", `reportingSurvey`="ATLAS, ZTF, Pan-STARRS1", `specType`="SN IIb", `transRedshift`="0.0079" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abym" ,"AT2020abym" ,"24.877181" ,"+24:52:37.85" ,"2020-12-08 06:56:09.600" ,"19.142" ,"cyan-ATLAS" ,"ATLAS, GaiaAlerts" ,"ATLAS20bhbd" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abym" ,"16.04225" ,"01:04:10.140" ,"ATLAS, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abym", `TNSName`="AT2020abym", `decDeg`="24.877181", `decSex`="+24:52:37.85", `discDate`="2020-12-08 06:56:09.600", `discMag`="19.142", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, GaiaAlerts", `discoveryName`="ATLAS20bhbd", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abym", `raDeg`="16.04225", `raSex`="01:04:10.140", `reportingSurvey`="ATLAS, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abxh" ,"AT2020abxh" ,"-15.3634" ,"-15:21:48.24" ,"2020-12-07 15:12:57.600" ,"18.307" ,"orange-ATLAS" ,"ATLAS, ZTF, GaiaAlerts" ,"ATLAS20bgze" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abxh" ,"194.81404166666667" ,"12:59:15.370" ,"ATLAS, ZTF, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abxh", `TNSName`="AT2020abxh", `decDeg`="-15.3634", `decSex`="-15:21:48.24", `discDate`="2020-12-07 15:12:57.600", `discMag`="18.307", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS, ZTF, GaiaAlerts", `discoveryName`="ATLAS20bgze", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abxh", `raDeg`="194.81404166666667", `raSex`="12:59:15.370", `reportingSurvey`="ATLAS, ZTF, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abwn" ,"AT2020abwn" ,"-2.153175" ,"-02:09:11.43" ,"2020-12-04 05:38:48.192" ,"20.0811" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acvdfkf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abwn" ,"63.33597083" ,"04:13:20.633" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwn", `TNSName`="AT2020abwn", `decDeg`="-2.153175", `decSex`="-02:09:11.43", `discDate`="2020-12-04 05:38:48.192", `discMag`="20.0811", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acvdfkf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abwn", `raDeg`="63.33597083", `raSex`="04:13:20.633", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abwm" ,"AT2020abwm" ,"-9.479581" ,"-09:28:46.49" ,"2020-12-05 06:40:14.880" ,"20.0544" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acvguvq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abwm" ,"47.7876917" ,"03:11:09.046" ,"ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwm", `TNSName`="AT2020abwm", `decDeg`="-9.479581", `decSex`="-09:28:46.49", `discDate`="2020-12-05 06:40:14.880", `discMag`="20.0544", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acvguvq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abwm", `raDeg`="47.7876917", `raSex`="03:11:09.046", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abwl" ,"AT2020abwl" ,"-1.388019" ,"-01:23:16.87" ,"2020-11-25 08:01:07.968" ,"20.5308" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acvohfs" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abwl" ,"55.19360417" ,"03:40:46.465" ,"ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwl", `TNSName`="AT2020abwl", `decDeg`="-1.388019", `decSex`="-01:23:16.87", `discDate`="2020-11-25 08:01:07.968", `discMag`="20.5308", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acvohfs", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abwl", `raDeg`="55.19360417", `raSex`="03:40:46.465", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abtz" ,"AT2020abtz" ,"-23.352794" ,"-23:21:10.06" ,"2020-12-06 06:28:48.000" ,"19.527" ,"cyan-ATLAS" ,"ATLAS, ZTF" ,"ATLAS20bgrb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abtz" ,"6.180075" ,"00:24:43.218" ,"ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abtz", `TNSName`="AT2020abtz", `decDeg`="-23.352794", `decSex`="-23:21:10.06", `discDate`="2020-12-06 06:28:48.000", `discMag`="19.527", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, ZTF", `discoveryName`="ATLAS20bgrb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abtz", `raDeg`="6.180075", `raSex`="00:24:43.218", `reportingSurvey`="ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020absy" ,"AT2020absy" ,"-10.25755" ,"-10:15:27.18" ,"2020-12-04 13:09:45.216" ,"18.2801" ,"r-ZTF" ,"ZTF, ATLAS, GaiaAlerts" ,"ZTF20acvamqy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020absy" ,"210.75575" ,"14:03:01.380" ,"ZTF, ATLAS, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absy", `TNSName`="AT2020absy", `decDeg`="-10.25755", `decSex`="-10:15:27.18", `discDate`="2020-12-04 13:09:45.216", `discMag`="18.2801", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, GaiaAlerts", `discoveryName`="ZTF20acvamqy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020absy", `raDeg`="210.75575", `raSex`="14:03:01.380", `reportingSurvey`="ZTF, ATLAS, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abst" ,"AT2020abst" ,"4.036678" ,"+04:02:12.04" ,"2020-12-06 04:28:01.632" ,"19.2917" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acuwzwp" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abst" ,"320.02902083" ,"21:20:06.965" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abst", `TNSName`="AT2020abst", `decDeg`="4.036678", `decSex`="+04:02:12.04", `discDate`="2020-12-06 04:28:01.632", `discMag`="19.2917", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acuwzwp", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abst", `raDeg`="320.02902083", `raSex`="21:20:06.965", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020absn" ,"AT2020absn" ,"-1.763106" ,"-01:45:47.18" ,"2020-12-01 03:55:53.184" ,"19.9233" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acvgiee" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020absn" ,"4.5221333" ,"00:18:05.312" ,"ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absn", `TNSName`="AT2020absn", `decDeg`="-1.763106", `decSex`="-01:45:47.18", `discDate`="2020-12-01 03:55:53.184", `discMag`="19.9233", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acvgiee", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020absn", `raDeg`="4.5221333", `raSex`="00:18:05.312", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020absl" ,"AT2020absl" ,"28.705656" ,"+28:42:20.36" ,"2020-12-05 12:51:00.288" ,"18.8985" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acvezau" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020absl" ,"217.4283875" ,"14:29:42.813" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absl", `TNSName`="AT2020absl", `decDeg`="28.705656", `decSex`="+28:42:20.36", `discDate`="2020-12-05 12:51:00.288", `discMag`="18.8985", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acvezau", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020absl", `raDeg`="217.4283875", `raSex`="14:29:42.813", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020absj" ,"AT2020absj" ,"11.873714" ,"+11:52:25.37" ,"2020-12-05 12:55:02.208" ,"19.6979" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20acvezdt" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020absj" ,"197.73220417" ,"13:10:55.729" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absj", `TNSName`="AT2020absj", `decDeg`="11.873714", `decSex`="+11:52:25.37", `discDate`="2020-12-05 12:55:02.208", `discMag`="19.6979", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acvezdt", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020absj", `raDeg`="197.73220417", `raSex`="13:10:55.729", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020absf" ,"AT2020absf" ,"78.485931" ,"+78:29:09.35" ,"2020-12-06 05:23:57.408" ,"19.9009" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acvhazo" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020absf" ,"41.9858083" ,"02:47:56.594" ,"ZTF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absf", `TNSName`="AT2020absf", `decDeg`="78.485931", `decSex`="+78:29:09.35", `discDate`="2020-12-06 05:23:57.408", `discMag`="19.9009", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acvhazo", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020absf", `raDeg`="41.9858083", `raSex`="02:47:56.594", `reportingSurvey`="ZTF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abqx" ,"AT2020abqx" ,"67.547744" ,"+67:32:51.88" ,"2020-12-03 12:50:24.000" ,"19.22" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acvebcu" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abqx" ,"178.10276666666667" ,"11:52:24.664" ,"ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqx", `TNSName`="AT2020abqx", `decDeg`="67.547744", `decSex`="+67:32:51.88", `discDate`="2020-12-03 12:50:24.000", `discMag`="19.22", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acvebcu", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abqx", `raDeg`="178.10276666666667", `raSex`="11:52:24.664", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abqo" ,"AT2020abqo" ,"9.519536" ,"+09:31:10.33" ,"2020-12-05 12:18:46.656" ,"18.77" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acuowxj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abqo" ,"194.258125" ,"12:57:01.950" ,"ZTF, ATLAS, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqo", `TNSName`="AT2020abqo", `decDeg`="9.519536", `decSex`="+09:31:10.33", `discDate`="2020-12-05 12:18:46.656", `discMag`="18.77", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acuowxj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abqo", `raDeg`="194.258125", `raSex`="12:57:01.950", `reportingSurvey`="ZTF, ATLAS, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abpw" ,"AT2020abpw" ,"33.780703" ,"+33:46:50.53" ,"2020-12-05 04:07:47.712" ,"19.6795" ,"g-ZTF" ,"ZTF" ,"ZTF20acvblkk" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abpw" ,"349.7389625" ,"23:18:57.351" ,"ZTF, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpw", `TNSName`="AT2020abpw", `decDeg`="33.780703", `decSex`="+33:46:50.53", `discDate`="2020-12-05 04:07:47.712", `discMag`="19.6795", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acvblkk", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abpw", `raDeg`="349.7389625", `raSex`="23:18:57.351", `reportingSurvey`="ZTF, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abpu" ,"AT2020abpu" ,"46.750031" ,"+46:45:00.11" ,"2020-12-05 05:56:04.128" ,"19.4483" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20acvchhw" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abpu" ,"354.003375" ,"23:36:00.810" ,"ZTF, ATLAS, Fink" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `TNSName`="AT2020abpu", `decDeg`="46.750031", `decSex`="+46:45:00.11", `discDate`="2020-12-05 05:56:04.128", `discMag`="19.4483", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20acvchhw", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abpu", `raDeg`="354.003375", `raSex`="23:36:00.810", `reportingSurvey`="ZTF, ATLAS, Fink", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abpt" ,"SN2020abpt" ,"-1.196847" ,"-01:11:48.65" ,"2020-12-05 04:35:43.872" ,"19.6857" ,"g-ZTF" ,"ZTF, Pan-STARRS1, ATLAS" ,"ZTF20acuxpwz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abpt" ,"40.1061875" ,"02:40:25.485" ,"ZTF, YSE, ATLAS" ,"SN Ia" ,"0.139", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpt", `TNSName`="SN2020abpt", `decDeg`="-1.196847", `decSex`="-01:11:48.65", `discDate`="2020-12-05 04:35:43.872", `discMag`="19.6857", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS", `discoveryName`="ZTF20acuxpwz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abpt", `raDeg`="40.1061875", `raSex`="02:40:25.485", `reportingSurvey`="ZTF, YSE, ATLAS", `specType`="SN Ia", `transRedshift`="0.139" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aboq" ,"AT2020aboq" ,"-35.224761" ,"-35:13:29.14" ,"2020-12-04 11:26:52.800" ,"18.634" ,"orange-ATLAS" ,"ATLAS, GaiaAlerts" ,"ATLAS20bgoz" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aboq" ,"99.598875" ,"06:38:23.730" ,"ATLAS, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aboq", `TNSName`="AT2020aboq", `decDeg`="-35.224761", `decSex`="-35:13:29.14", `discDate`="2020-12-04 11:26:52.800", `discMag`="18.634", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS, GaiaAlerts", `discoveryName`="ATLAS20bgoz", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aboq", `raDeg`="99.598875", `raSex`="06:38:23.730", `reportingSurvey`="ATLAS, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abmp" ,"SN2020abmp" ,"0.405042" ,"+00:24:18.15" ,"2020-12-04 03:03:29.088" ,"19.8954" ,"g-ZTF" ,"ZTF, Pan-STARRS1, ATLAS" ,"ZTF20acuxjus" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abmp" ,"11.8288417" ,"00:47:18.922" ,"ZTF, Pan-STARRS1, ATLAS" ,"SN Ic" ,"0.058", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `TNSName`="SN2020abmp", `decDeg`="0.405042", `decSex`="+00:24:18.15", `discDate`="2020-12-04 03:03:29.088", `discMag`="19.8954", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS", `discoveryName`="ZTF20acuxjus", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abmp", `raDeg`="11.8288417", `raSex`="00:47:18.922", `reportingSurvey`="ZTF, Pan-STARRS1, ATLAS", `specType`="SN Ic", `transRedshift`="0.058" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abmo" ,"AT2020abmo" ,"-3.545683" ,"-03:32:44.46" ,"2020-12-04 03:03:29.088" ,"20.0514" ,"g-ZTF" ,"ZTF" ,"ZTF20acuxjtr" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abmo" ,"9.9021583" ,"00:39:36.518" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmo", `TNSName`="AT2020abmo", `decDeg`="-3.545683", `decSex`="-03:32:44.46", `discDate`="2020-12-04 03:03:29.088", `discMag`="20.0514", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20acuxjtr", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abmo", `raDeg`="9.9021583", `raSex`="00:39:36.518", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abme" ,"AT2020abme" ,"-43.210311" ,"-43:12:37.12" ,"2020-12-02 00:43:12.000" ,"18.86" ,"G-Gaia" ,"GaiaAlerts, ATLAS" ,"Gaia20fny" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abme" ,"45.579833" ,"03:02:19.160" ,"GaiaAlerts, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abme", `TNSName`="AT2020abme", `decDeg`="-43.210311", `decSex`="-43:12:37.12", `discDate`="2020-12-02 00:43:12.000", `discMag`="18.86", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts, ATLAS", `discoveryName`="Gaia20fny", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abme", `raDeg`="45.579833", `raSex`="03:02:19.160", `reportingSurvey`="GaiaAlerts, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abie" ,"AT2020abie" ,"-3.531594" ,"-03:31:53.74" ,"2020-11-29 02:34:23.998" ,"19.8013" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20aculjrg" ,"SDSS J231333.60-033158.7" ,"0.133" ,"http://wis-tns.weizmann.ac.il/object/2020abie" ,"348.3885417" ,"23:13:33.250" ,"ALeRCE, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abie", `TNSName`="AT2020abie", `decDeg`="-3.531594", `decSex`="-03:31:53.74", `discDate`="2020-11-29 02:34:23.998", `discMag`="19.8013", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20aculjrg", `hostName`="SDSS J231333.60-033158.7", `hostRedshift`="0.133", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abie", `raDeg`="348.3885417", `raSex`="23:13:33.250", `reportingSurvey`="ALeRCE, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abdd" ,"AT2020abdd" ,"50.079992" ,"+50:04:47.97" ,"2020-11-25 12:24:29.664" ,"19.06" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acseuvr" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020abdd" ,"140.3241833" ,"09:21:17.804" ,"ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abdd", `TNSName`="AT2020abdd", `decDeg`="50.079992", `decSex`="+50:04:47.97", `discDate`="2020-11-25 12:24:29.664", `discMag`="19.06", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acseuvr", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020abdd", `raDeg`="140.3241833", `raSex`="09:21:17.804", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aawn" ,"AT2020aawn" ,"-25.7072" ,"-25:42:25.92" ,"2020-11-24 11:34:21.000" ,"19.2286" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF20actnran" ,"WISEA J084828.92-254225.7" ,null ,"http://wis-tns.weizmann.ac.il/object/2020aawn" ,"132.120525" ,"08:48:28.926" ,"ALeRCE, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aawn", `TNSName`="AT2020aawn", `decDeg`="-25.7072", `decSex`="-25:42:25.92", `discDate`="2020-11-24 11:34:21.000", `discMag`="19.2286", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20actnran", `hostName`="WISEA J084828.92-254225.7", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aawn", `raDeg`="132.120525", `raSex`="08:48:28.926", `reportingSurvey`="ALeRCE, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aauc" ,"SN2020aauc" ,"-8.451742" ,"-08:27:06.27" ,"2020-11-23 07:08:06.996" ,"19.3927" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20actekrw" ,"WISEA J034717.72-082702.9" ,null ,"http://wis-tns.weizmann.ac.il/object/2020aauc" ,"56.82557917" ,"03:47:18.139" ,"ALeRCE, ZTF, ATLAS, Pan-STARRS1" ,"SN Ic" ,"0.03339", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `TNSName`="SN2020aauc", `decDeg`="-8.451742", `decSex`="-08:27:06.27", `discDate`="2020-11-23 07:08:06.996", `discMag`="19.3927", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20actekrw", `hostName`="WISEA J034717.72-082702.9", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aauc", `raDeg`="56.82557917", `raSex`="03:47:18.139", `reportingSurvey`="ALeRCE, ZTF, ATLAS, Pan-STARRS1", `specType`="SN Ic", `transRedshift`="0.03339" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aarh" ,"AT2020aarh" ,"-3.636542" ,"-03:38:11.55" ,"2020-11-20 02:34:10.001" ,"19.4765" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acrdadi" ,"SDSS J224405.78-033807.3" ,"0.074" ,"http://wis-tns.weizmann.ac.il/object/2020aarh" ,"341.023925" ,"22:44:05.742" ,"ALeRCE, ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aarh", `TNSName`="AT2020aarh", `decDeg`="-3.636542", `decSex`="-03:38:11.55", `discDate`="2020-11-20 02:34:10.001", `discMag`="19.4765", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acrdadi", `hostName`="SDSS J224405.78-033807.3", `hostRedshift`="0.074", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aarh", `raDeg`="341.023925", `raSex`="22:44:05.742", `reportingSurvey`="ALeRCE, ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aabt" ,"AT2020aabt" ,"48.764622" ,"+48:45:52.64" ,"2020-11-10 11:41:16.800" ,"19.08" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acphjfv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020aabt" ,"191.75744583" ,"12:47:01.787" ,"ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aabt", `TNSName`="AT2020aabt", `decDeg`="48.764622", `decSex`="+48:45:52.64", `discDate`="2020-11-10 11:41:16.800", `discMag`="19.08", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acphjfv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020aabt", `raDeg`="191.75744583", `raSex`="12:47:01.787", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zxy" ,"AT2020zxy" ,"21.048725" ,"+21:02:55.41" ,"2020-11-14 07:53:01.000" ,"20.3295" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acqxxcr" ,"SDSS J013912.24+210254.9" ,"0.059" ,"http://wis-tns.weizmann.ac.il/object/2020zxy" ,"24.8009667" ,"01:39:12.232" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zxy", `TNSName`="AT2020zxy", `decDeg`="21.048725", `decSex`="+21:02:55.41", `discDate`="2020-11-14 07:53:01.000", `discMag`="20.3295", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acqxxcr", `hostName`="SDSS J013912.24+210254.9", `hostRedshift`="0.059", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020zxy", `raDeg`="24.8009667", `raSex`="01:39:12.232", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zwq" ,"AT2020zwq" ,"-6.852169" ,"-06:51:07.81" ,"2020-11-02 11:36:41.184" ,"18.78" ,"r-ZTF" ,"ZTF" ,"ZTF20ackijbs" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020zwq" ,"151.239075" ,"10:04:57.378" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zwq", `TNSName`="AT2020zwq", `decDeg`="-6.852169", `decSex`="-06:51:07.81", `discDate`="2020-11-02 11:36:41.184", `discMag`="18.78", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20ackijbs", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020zwq", `raDeg`="151.239075", `raSex`="10:04:57.378", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zqq" ,"AT2020zqq" ,"-5.732075" ,"-05:43:55.47" ,"2020-11-05 11:05:15.936" ,"19.31" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acngwfc" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020zqq" ,"124.00654583333333" ,"08:16:01.571" ,"ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zqq", `TNSName`="AT2020zqq", `decDeg`="-5.732075", `decSex`="-05:43:55.47", `discDate`="2020-11-05 11:05:15.936", `discMag`="19.31", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acngwfc", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020zqq", `raDeg`="124.00654583333333", `raSex`="08:16:01.571", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zpi" ,"SN2020zpi" ,"-1.44686" ,"-01:26:48.70" ,"2020-11-12 07:35:24.000" ,"20.4511" ,"r-ZTF" ,"ZTF, ATLAS, GaiaAlerts" ,"ZTF20acqksdi" ,"CGCG 388-092" ,"0.037056" ,"http://wis-tns.weizmann.ac.il/object/2020zpi" ,"40.0852083" ,"02:40:20.450" ,"ALeRCE, ZTF, ATLAS, Fink, GaiaAlerts" ,"SN Ia" ,"0.04", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `TNSName`="SN2020zpi", `decDeg`="-1.44686", `decSex`="-01:26:48.70", `discDate`="2020-11-12 07:35:24.000", `discMag`="20.4511", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, GaiaAlerts", `discoveryName`="ZTF20acqksdi", `hostName`="CGCG 388-092", `hostRedshift`="0.037056", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020zpi", `raDeg`="40.0852083", `raSex`="02:40:20.450", `reportingSurvey`="ALeRCE, ZTF, ATLAS, Fink, GaiaAlerts", `specType`="SN Ia", `transRedshift`="0.04" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zka" ,"SN2020zka" ,"-4.36165" ,"-04:21:41.94" ,"2020-11-12 10:29:04.998" ,"19.8825" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acpwmui" ,"WISEA J081831.49-042139.0" ,null ,"http://wis-tns.weizmann.ac.il/object/2020zka" ,"124.6302667" ,"08:18:31.264" ,"ALeRCE, Pan-STARRS1, ZTF, Fink" ,"SN Ia" ,"0.095", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `TNSName`="SN2020zka", `decDeg`="-4.36165", `decSex`="-04:21:41.94", `discDate`="2020-11-12 10:29:04.998", `discMag`="19.8825", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acpwmui", `hostName`="WISEA J081831.49-042139.0", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020zka", `raDeg`="124.6302667", `raSex`="08:18:31.264", `reportingSurvey`="ALeRCE, Pan-STARRS1, ZTF, Fink", `specType`="SN Ia", `transRedshift`="0.095" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zjb" ,"AT2020zjb" ,"26.50656" ,"+26:30:23.60" ,"2020-11-12 04:39:51.002" ,"19.8559" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acpqbue" ,"WISEA J024859.34+263039.6" ,"0.057997" ,"http://wis-tns.weizmann.ac.il/object/2020zjb" ,"42.2418625" ,"02:48:58.047" ,"ALeRCE, ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `TNSName`="AT2020zjb", `decDeg`="26.50656", `decSex`="+26:30:23.60", `discDate`="2020-11-12 04:39:51.002", `discMag`="19.8559", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acpqbue", `hostName`="WISEA J024859.34+263039.6", `hostRedshift`="0.057997", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020zjb", `raDeg`="42.2418625", `raSex`="02:48:58.047", `reportingSurvey`="ALeRCE, ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020ziy" ,"AT2020ziy" ,"-5.141703" ,"-05:08:30.13" ,"2020-11-12 04:37:48.996" ,"19.7672" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acppzxx" ,"SDSS J015543.15-050830.1" ,"0.239" ,"http://wis-tns.weizmann.ac.il/object/2020ziy" ,"28.92997083" ,"01:55:43.193" ,"ALeRCE, ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `TNSName`="AT2020ziy", `decDeg`="-5.141703", `decSex`="-05:08:30.13", `discDate`="2020-11-12 04:37:48.996", `discMag`="19.7672", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acppzxx", `hostName`="SDSS J015543.15-050830.1", `hostRedshift`="0.239", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020ziy", `raDeg`="28.92997083", `raSex`="01:55:43.193", `reportingSurvey`="ALeRCE, ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zhz" ,"AT2020zhz" ,"-7.16175" ,"-07:09:42.30" ,"2020-11-11 05:02:55.000" ,"19.5698" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acprazr" ,"SDSS J233237.96-070944.6" ,"0.068" ,"http://wis-tns.weizmann.ac.il/object/2020zhz" ,"353.1584375" ,"23:32:38.025" ,"ALeRCE, ZTF, ATLAS, Fink, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `TNSName`="AT2020zhz", `decDeg`="-7.16175", `decSex`="-07:09:42.30", `discDate`="2020-11-11 05:02:55.000", `discMag`="19.5698", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acprazr", `hostName`="SDSS J233237.96-070944.6", `hostRedshift`="0.068", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020zhz", `raDeg`="353.1584375", `raSex`="23:32:38.025", `reportingSurvey`="ALeRCE, ZTF, ATLAS, Fink, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zgr" ,"AT2020zgr" ,"3.306953" ,"+03:18:25.03" ,"2020-11-05 08:25:35.904" ,"19.87" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acplqcf" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020zgr" ,"50.83602917" ,"03:23:20.647" ,"ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zgr", `TNSName`="AT2020zgr", `decDeg`="3.306953", `decSex`="+03:18:25.03", `discDate`="2020-11-05 08:25:35.904", `discMag`="19.87", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acplqcf", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020zgr", `raDeg`="50.83602917", `raSex`="03:23:20.647", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zcx" ,"AT2020zcx" ,"62.076836" ,"+62:04:36.61" ,"2020-11-04 12:36:36.003" ,"19.7918" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acpgicr" ,"SDSS J094315.52+620435.6" ,"0.114" ,"http://wis-tns.weizmann.ac.il/object/2020zcx" ,"145.81372083333332" ,"09:43:15.293" ,"ALeRCE, ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zcx", `TNSName`="AT2020zcx", `decDeg`="62.076836", `decSex`="+62:04:36.61", `discDate`="2020-11-04 12:36:36.003", `discMag`="19.7918", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acpgicr", `hostName`="SDSS J094315.52+620435.6", `hostRedshift`="0.114", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020zcx", `raDeg`="145.81372083333332", `raSex`="09:43:15.293", `reportingSurvey`="ALeRCE, ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020yzs" ,"SN2020yzs" ,"-10.864458" ,"-10:51:52.05" ,"2020-11-07 09:21:36.000" ,"18.334" ,"orange-ATLAS" ,"ATLAS, ZTF, Pan-STARRS1" ,"ATLAS20bexl" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020yzs" ,"19.008845833333332" ,"01:16:02.123" ,"ATLAS, ZTF, Pan-STARRS1" ,"SN Ia" ,"0.0672", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yzs", `TNSName`="SN2020yzs", `decDeg`="-10.864458", `decSex`="-10:51:52.05", `discDate`="2020-11-07 09:21:36.000", `discMag`="18.334", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS, ZTF, Pan-STARRS1", `discoveryName`="ATLAS20bexl", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020yzs", `raDeg`="19.008845833333332", `raSex`="01:16:02.123", `reportingSurvey`="ATLAS, ZTF, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.0672" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020yyk" ,"SN2020yyk" ,"-1.624478" ,"-01:37:28.12" ,"2020-11-04 05:26:05.004" ,"19.7108" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acopmey" ,"SDSS J222246.77-013728.1" ,"0.204" ,"http://wis-tns.weizmann.ac.il/object/2020yyk" ,"335.69482083" ,"22:22:46.757" ,"ALeRCE, ATLAS, ZTF, Pan-STARRS1" ,"SN Ia-91T-like" ,"0.08", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `TNSName`="SN2020yyk", `decDeg`="-1.624478", `decSex`="-01:37:28.12", `discDate`="2020-11-04 05:26:05.004", `discMag`="19.7108", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acopmey", `hostName`="SDSS J222246.77-013728.1", `hostRedshift`="0.204", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020yyk", `raDeg`="335.69482083", `raSex`="22:22:46.757", `reportingSurvey`="ALeRCE, ATLAS, ZTF, Pan-STARRS1", `specType`="SN Ia-91T-like", `transRedshift`="0.08" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020yyi" ,"AT2020yyi" ,"-13.029542" ,"-13:01:46.35" ,"2020-11-03 06:39:22.003" ,"19.9231" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acpcwwg" ,"WISEA J010708.27-130146.6" ,null ,"http://wis-tns.weizmann.ac.il/object/2020yyi" ,"16.78404583" ,"01:07:08.171" ,"ALeRCE, ATLAS, ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `TNSName`="AT2020yyi", `decDeg`="-13.029542", `decSex`="-13:01:46.35", `discDate`="2020-11-03 06:39:22.003", `discMag`="19.9231", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acpcwwg", `hostName`="WISEA J010708.27-130146.6", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020yyi", `raDeg`="16.78404583", `raSex`="01:07:08.171", `reportingSurvey`="ALeRCE, ATLAS, ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020yui" ,"AT2020yui" ,"31.667883" ,"+31:40:04.38" ,"2020-11-02 11:10:19.200" ,"19.4109" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF18aadsuxd" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020yui" ,"129.53394166666666" ,"08:38:08.146" ,"ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `TNSName`="AT2020yui", `decDeg`="31.667883", `decSex`="+31:40:04.38", `discDate`="2020-11-02 11:10:19.200", `discMag`="19.4109", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF18aadsuxd", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020yui", `raDeg`="129.53394166666666", `raSex`="08:38:08.146", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020yqa" ,"AT2020yqa" ,"-12.490131" ,"-12:29:24.47" ,"2020-10-30 17:29:45.600" ,"18.78" ,"G-Gaia" ,"GaiaAlerts, ZTF, Pan-STARRS1" ,"Gaia20faq" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020yqa" ,"169.102083" ,"11:16:24.500" ,"GaiaAlerts, ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yqa", `TNSName`="AT2020yqa", `decDeg`="-12.490131", `decSex`="-12:29:24.47", `discDate`="2020-10-30 17:29:45.600", `discMag`="18.78", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts, ZTF, Pan-STARRS1", `discoveryName`="Gaia20faq", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020yqa", `raDeg`="169.102083", `raSex`="11:16:24.500", `reportingSurvey`="GaiaAlerts, ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020ypm" ,"SN2020ypm" ,"-5.95958" ,"-05:57:34.50" ,"2020-10-18 07:16:18.336" ,"20.47" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20ackpjmb" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020ypm" ,"29.411625" ,"01:57:38.790" ,"ZTF, Pan-STARRS1" ,"SN Ia" ,"0.135", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ypm", `TNSName`="SN2020ypm", `decDeg`="-5.95958", `decSex`="-05:57:34.50", `discDate`="2020-10-18 07:16:18.336", `discMag`="20.47", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20ackpjmb", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020ypm", `raDeg`="29.411625", `raSex`="01:57:38.790", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.135" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020yhy" ,"SN2020yhy" ,"78.133811" ,"+78:08:01.72" ,"2020-10-28 11:21:31.392" ,"19.49" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acisvli" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020yhy" ,"138.83865" ,"09:15:21.276" ,"ZTF, Pan-STARRS1" ,"SN IIn" ,"0.106", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhy", `TNSName`="SN2020yhy", `decDeg`="78.133811", `decSex`="+78:08:01.72", `discDate`="2020-10-28 11:21:31.392", `discMag`="19.49", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acisvli", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020yhy", `raDeg`="138.83865", `raSex`="09:15:21.276", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`="SN IIn", `transRedshift`="0.106" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020yhl" ,"AT2020yhl" ,"-2.080697" ,"-02:04:50.51" ,"2020-10-24 04:04:30.996" ,"19.9532" ,"r-ZTF" ,"ZTF, Pan-STARRS1, ATLAS" ,"ZTF20acmydwh" ,"WISEA J223723.19-020453.0" ,"0.090782" ,"http://wis-tns.weizmann.ac.il/object/2020yhl" ,"339.34452083" ,"22:37:22.685" ,"ALeRCE, ZTF, Pan-STARRS1, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `TNSName`="AT2020yhl", `decDeg`="-2.080697", `decSex`="-02:04:50.51", `discDate`="2020-10-24 04:04:30.996", `discMag`="19.9532", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS", `discoveryName`="ZTF20acmydwh", `hostName`="WISEA J223723.19-020453.0", `hostRedshift`="0.090782", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020yhl", `raDeg`="339.34452083", `raSex`="22:37:22.685", `reportingSurvey`="ALeRCE, ZTF, Pan-STARRS1, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020xyk" ,"SN2020xyk" ,"21.863569" ,"+21:51:48.85" ,"2020-10-21 08:35:31.200" ,"18.69" ,"g-ZTF" ,"ZTF, Pan-STARRS1, ATLAS, GaiaAlerts" ,"ZTF20acmaaan" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020xyk" ,"5.23225" ,"00:20:55.740" ,"ZTF, Pan-STARRS1, ATLAS, GaiaAlerts" ,"SN II" ,"0.0187", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `TNSName`="SN2020xyk", `decDeg`="21.863569", `decSex`="+21:51:48.85", `discDate`="2020-10-21 08:35:31.200", `discMag`="18.69", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS, GaiaAlerts", `discoveryName`="ZTF20acmaaan", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020xyk", `raDeg`="5.23225", `raSex`="00:20:55.740", `reportingSurvey`="ZTF, Pan-STARRS1, ATLAS, GaiaAlerts", `specType`="SN II", `transRedshift`="0.0187" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020xpm" ,"AT2020xpm" ,"21.379519" ,"+21:22:46.27" ,"2020-10-20 06:53:30.002" ,"20.4705" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acljttk" ,"SDSS J014156.12+212244.0" ,"0.138" ,"http://wis-tns.weizmann.ac.il/object/2020xpm" ,"25.483275" ,"01:41:55.986" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xpm", `TNSName`="AT2020xpm", `decDeg`="21.379519", `decSex`="+21:22:46.27", `discDate`="2020-10-20 06:53:30.002", `discMag`="20.4705", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acljttk", `hostName`="SDSS J014156.12+212244.0", `hostRedshift`="0.138", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020xpm", `raDeg`="25.483275", `raSex`="01:41:55.986", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020wie" ,"SN2020wie" ,"35.047269" ,"+35:02:50.17" ,"2020-10-13 10:15:14.996" ,"18.8688" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acitbmh" ,"WISEA J070037.39+350255.8" ,null ,"http://wis-tns.weizmann.ac.il/object/2020wie" ,"105.15587083" ,"07:00:37.409" ,"ALeRCE, ATLAS, ZTF, Pan-STARRS1" ,"SN Ia" ,"0.07", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `TNSName`="SN2020wie", `decDeg`="35.047269", `decSex`="+35:02:50.17", `discDate`="2020-10-13 10:15:14.996", `discMag`="18.8688", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acitbmh", `hostName`="WISEA J070037.39+350255.8", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020wie", `raDeg`="105.15587083", `raSex`="07:00:37.409", `reportingSurvey`="ALeRCE, ATLAS, ZTF, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.07" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020whq" ,"AT2020whq" ,"79.01755" ,"+79:01:03.18" ,"2020-10-13 11:44:47.996" ,"19.2313" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20aciuubo" ,"SDSS J101322.62+790100.1" ,"0.061" ,"http://wis-tns.weizmann.ac.il/object/2020whq" ,"153.346667" ,"10:13:23.200" ,"ALeRCE, ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020whq", `TNSName`="AT2020whq", `decDeg`="79.01755", `decSex`="+79:01:03.18", `discDate`="2020-10-13 11:44:47.996", `discMag`="19.2313", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20aciuubo", `hostName`="SDSS J101322.62+790100.1", `hostRedshift`="0.061", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020whq", `raDeg`="153.346667", `raSex`="10:13:23.200", `reportingSurvey`="ALeRCE, ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020wcj" ,"SN2020wcj" ,"-1.231031" ,"-01:13:51.71" ,"2020-10-12 09:07:46.560" ,"19.3898" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1, GaiaAlerts" ,"ZTF20acikuon" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020wcj" ,"43.209625" ,"02:52:50.310" ,"ZTF, ATLAS, Pan-STARRS1, GaiaAlerts" ,"SN Ia" ,"0.0237", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `TNSName`="SN2020wcj", `decDeg`="-1.231031", `decSex`="-01:13:51.71", `discDate`="2020-10-12 09:07:46.560", `discMag`="19.3898", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1, GaiaAlerts", `discoveryName`="ZTF20acikuon", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020wcj", `raDeg`="43.209625", `raSex`="02:52:50.310", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1, GaiaAlerts", `specType`="SN Ia", `transRedshift`="0.0237" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020vwl" ,"AT2020vwl" ,"26.982469" ,"+26:58:56.89" ,"2020-10-10 17:28:19.200" ,"17.94" ,"G-Gaia" ,"GaiaAlerts, ATLAS, ZTF" ,"Gaia20etp" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020vwl" ,"232.6575" ,"15:30:37.800" ,"GaiaAlerts, ATLAS, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020vwl", `TNSName`="AT2020vwl", `decDeg`="26.982469", `decSex`="+26:58:56.89", `discDate`="2020-10-10 17:28:19.200", `discMag`="17.94", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts, ATLAS, ZTF", `discoveryName`="Gaia20etp", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020vwl", `raDeg`="232.6575", `raSex`="15:30:37.800", `reportingSurvey`="GaiaAlerts, ATLAS, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020uxz" ,"SN2020uxz" ,"12.921461" ,"+12:55:17.26" ,"2020-10-05 13:45:30.000" ,"16.5" ,"Clear-" ,"ATLAS, ZTF, Pan-STARRS1, GaiaAlerts" ,null ,"NGC 514" ,null ,"http://wis-tns.weizmann.ac.il/object/2020uxz" ,"21.0287083" ,"01:24:06.890" ,"ATLAS, ZTF, YSE, Pan-STARRS1, GaiaAlerts" ,"SN Ia" ,"0.008246", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `TNSName`="SN2020uxz", `decDeg`="12.921461", `decSex`="+12:55:17.26", `discDate`="2020-10-05 13:45:30.000", `discMag`="16.5", `discMagFilter`="Clear-", `discSurvey`="ATLAS, ZTF, Pan-STARRS1, GaiaAlerts", `discoveryName`=null, `hostName`="NGC 514", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020uxz", `raDeg`="21.0287083", `raSex`="01:24:06.890", `reportingSurvey`="ATLAS, ZTF, YSE, Pan-STARRS1, GaiaAlerts", `specType`="SN Ia", `transRedshift`="0.008246" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020ugz" ,"SN2020ugz" ,"72.041439" ,"+72:02:29.18" ,"2020-09-26 12:28:26.003" ,"19.3242" ,"r-ZTF" ,"ZTF, GaiaAlerts, ATLAS, Pan-STARRS1" ,"ZTF20acfasbq" ,"WISEA J080901.12+720238.7" ,null ,"http://wis-tns.weizmann.ac.il/object/2020ugz" ,"122.2537083" ,"08:09:00.890" ,"ALeRCE, ZTF, GaiaAlerts, ATLAS, Pan-STARRS1" ,"SN Ia" ,"0.047", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ugz", `TNSName`="SN2020ugz", `decDeg`="72.041439", `decSex`="+72:02:29.18", `discDate`="2020-09-26 12:28:26.003", `discMag`="19.3242", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, GaiaAlerts, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acfasbq", `hostName`="WISEA J080901.12+720238.7", `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020ugz", `raDeg`="122.2537083", `raSex`="08:09:00.890", `reportingSurvey`="ALeRCE, ZTF, GaiaAlerts, ATLAS, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.047" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020uas" ,"SN2020uas" ,"20.143239" ,"+20:08:35.66" ,"2020-09-23 11:13:55.200" ,"19.476" ,"cyan-ATLAS" ,"ATLAS, Pan-STARRS1, GaiaAlerts" ,"ATLAS20bbps" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020uas" ,"344.911125" ,"22:59:38.670" ,"ATLAS, Pan-STARRS1, GaiaAlerts" ,"SN Ib/c" ,"0.024", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uas", `TNSName`="SN2020uas", `decDeg`="20.143239", `decSex`="+20:08:35.66", `discDate`="2020-09-23 11:13:55.200", `discMag`="19.476", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, Pan-STARRS1, GaiaAlerts", `discoveryName`="ATLAS20bbps", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020uas", `raDeg`="344.911125", `raSex`="22:59:38.670", `reportingSurvey`="ATLAS, Pan-STARRS1, GaiaAlerts", `specType`="SN Ib/c", `transRedshift`="0.024" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020uaq" ,"AT2020uaq" ,"10.977039" ,"+10:58:37.34" ,"2020-09-23 05:29:45.600" ,"18.87" ,"z-Sloan" ,"Pan-STARRS1, GaiaAlerts, ZTF" ,"PS20hsv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020uaq" ,"233.7042917" ,"15:34:49.030" ,"YSE, GaiaAlerts, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uaq", `TNSName`="AT2020uaq", `decDeg`="10.977039", `decSex`="+10:58:37.34", `discDate`="2020-09-23 05:29:45.600", `discMag`="18.87", `discMagFilter`="z-Sloan", `discSurvey`="Pan-STARRS1, GaiaAlerts, ZTF", `discoveryName`="PS20hsv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020uaq", `raDeg`="233.7042917", `raSex`="15:34:49.030", `reportingSurvey`="YSE, GaiaAlerts, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020sbf" ,"AT2020sbf" ,"56.735953" ,"+56:44:09.43" ,"2020-08-25 14:19:40.800" ,"18.726" ,"orange-ATLAS" ,"ATLAS, Pan-STARRS1" ,"ATLAS20ykg" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020sbf" ,"91.0799125" ,"06:04:19.179" ,"ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020sbf", `TNSName`="AT2020sbf", `decDeg`="56.735953", `decSex`="+56:44:09.43", `discDate`="2020-08-25 14:19:40.800", `discMag`="18.726", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS, Pan-STARRS1", `discoveryName`="ATLAS20ykg", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020sbf", `raDeg`="91.0799125", `raSex`="06:04:19.179", `reportingSurvey`="ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020pub" ,"SN2020pub" ,"-22.705289" ,"-22:42:19.04" ,"2020-07-19 17:33:56.160" ,"15.4" ,"Clear-" ,"MASTER, GaiaAlerts, ATLAS, ZTF" ,"MASTER OT J103735.45-224219.8" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020pub" ,"159.39816666666667" ,"10:37:35.560" ,"MASTER, GaiaAlerts, ATLAS, ZTF" ,"SN II" ,"0.011", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `TNSName`="SN2020pub", `decDeg`="-22.705289", `decSex`="-22:42:19.04", `discDate`="2020-07-19 17:33:56.160", `discMag`="15.4", `discMagFilter`="Clear-", `discSurvey`="MASTER, GaiaAlerts, ATLAS, ZTF", `discoveryName`="MASTER OT J103735.45-224219.8", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020pub", `raDeg`="159.39816666666667", `raSex`="10:37:35.560", `reportingSurvey`="MASTER, GaiaAlerts, ATLAS, ZTF", `specType`="SN II", `transRedshift`="0.011" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020nww" ,"AT2020nww" ,"80.922581" ,"+80:55:21.29" ,"2020-06-29 05:25:54.048" ,"16.89" ,"r-ZTF" ,"ZTF" ,"ZTF20aamoalc" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020nww" ,"169.7936875" ,"11:19:10.485" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020nww", `TNSName`="AT2020nww", `decDeg`="80.922581", `decSex`="+80:55:21.29", `discDate`="2020-06-29 05:25:54.048", `discMag`="16.89", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF20aamoalc", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020nww", `raDeg`="169.7936875", `raSex`="11:19:10.485", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020noz" ,"SN2020noz" ,"7.849561" ,"+07:50:58.42" ,"2020-06-22 06:33:07.200" ,"21.03" ,"g-Sloan" ,"Pan-STARRS1, ATLAS, GaiaAlerts, ZTF" ,"PS20eml" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020noz" ,"187.2510417" ,"12:29:00.250" ,"YSE, ATLAS, GaiaAlerts, ZTF" ,"SN IIn" ,"0.025", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020noz", `TNSName`="SN2020noz", `decDeg`="7.849561", `decSex`="+07:50:58.42", `discDate`="2020-06-22 06:33:07.200", `discMag`="21.03", `discMagFilter`="g-Sloan", `discSurvey`="Pan-STARRS1, ATLAS, GaiaAlerts, ZTF", `discoveryName`="PS20eml", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020noz", `raDeg`="187.2510417", `raSex`="12:29:00.250", `reportingSurvey`="YSE, ATLAS, GaiaAlerts, ZTF", `specType`="SN IIn", `transRedshift`="0.025" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020bju" ,"AT2020bju" ,"-14.48285" ,"-14:28:58.26" ,"2020-01-29 00:38:52.000" ,"17.8" ,"G-Gaia" ,"GaiaAlerts, ZTF" ,"Gaia20amt" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2020bju" ,"165.4337917" ,"11:01:44.110" ,"GaiaAlerts, ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020bju", `TNSName`="AT2020bju", `decDeg`="-14.48285", `decSex`="-14:28:58.26", `discDate`="2020-01-29 00:38:52.000", `discMag`="17.8", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts, ZTF", `discoveryName`="Gaia20amt", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020bju", `raDeg`="165.4337917", `raSex`="11:01:44.110", `reportingSurvey`="GaiaAlerts, ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020ahg" ,"AT2020ahg" ,"60.811619" ,"+60:48:41.83" ,"2020-01-16 04:00:18.000" ,"21.007" ,"g-ZTF" ,"ZTF, ATLAS" ,"ZTF20aagqrct" ,"NGC2273" ,"0.006138" ,"http://wis-tns.weizmann.ac.il/object/2020ahg" ,"102.55317917" ,"06:50:12.763" ,"SGLF, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ahg", `TNSName`="AT2020ahg", `decDeg`="60.811619", `decSex`="+60:48:41.83", `discDate`="2020-01-16 04:00:18.000", `discMag`="21.007", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF20aagqrct", `hostName`="NGC2273", `hostRedshift`="0.006138", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2020ahg", `raDeg`="102.55317917", `raSex`="06:50:12.763", `reportingSurvey`="SGLF, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2019aaip" ,"AT2019aaip" ,"0.425869" ,"+00:25:33.13" ,"2019-09-26 06:50:23.000" ,"21.8" ,"w-PS1" ,"Pan-STARRS1" ,"PS20mjv" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2019aaip" ,"330.30709583" ,"22:01:13.703" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2019aaip", `TNSName`="AT2019aaip", `decDeg`="0.425869", `decSex`="+00:25:33.13", `discDate`="2019-09-26 06:50:23.000", `discMag`="21.8", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjv", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2019aaip", `raDeg`="330.30709583", `raSex`="22:01:13.703", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2019aaio" ,"AT2019aaio" ,"47.150089" ,"+47:09:00.32" ,"2019-12-16 12:05:45.600" ,"20.8" ,"i-Sloan" ,"Pan-STARRS1" ,"PS20mjj" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2019aaio" ,"99.8938625" ,"06:39:34.527" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2019aaio", `TNSName`="AT2019aaio", `decDeg`="47.150089", `decSex`="+47:09:00.32", `discDate`="2019-12-16 12:05:45.600", `discMag`="20.8", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20mjj", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2019aaio", `raDeg`="99.8938625", `raSex`="06:39:34.527", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2019aain" ,"AT2019aain" ,"-25.472039" ,"-25:28:19.34" ,"2019-01-30 09:32:55.968" ,"19.4541" ,"r-ZTF" ,"ZTF" ,"ZTF19aagmvtl" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2019aain" ,"126.7973375" ,"08:27:11.361" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2019aain", `TNSName`="AT2019aain", `decDeg`="-25.472039", `decSex`="-25:28:19.34", `discDate`="2019-01-30 09:32:55.968", `discMag`="19.4541", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF19aagmvtl", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2019aain", `raDeg`="126.7973375", `raSex`="08:27:11.361", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2019ddg" ,"AT2019ddg" ,"-22.029436" ,"-22:01:45.97" ,"2019-03-31 05:33:46.000" ,"13.52" ,"r-ZTF" ,"ZTF" ,"ZTF19aanojhy" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2019ddg" ,"146.31349583" ,"09:45:15.239" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2019ddg", `TNSName`="AT2019ddg", `decDeg`="-22.029436", `decSex`="-22:01:45.97", `discDate`="2019-03-31 05:33:46.000", `discMag`="13.52", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF19aanojhy", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2019ddg", `raDeg`="146.31349583", `raSex`="09:45:15.239", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2018lvn" ,"AT2018lvn" ,"15.515058" ,"+15:30:54.21" ,"2018-04-22 06:05:45.600" ,"19.82" ,"r-ZTF" ,"ZTF" ,"ZTF18aakkvea" ,null ,null ,"http://wis-tns.weizmann.ac.il/object/2018lvn" ,"198.52094583" ,"13:14:05.027" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2018lvn", `TNSName`="AT2018lvn", `decDeg`="15.515058", `decSex`="+15:30:54.21", `discDate`="2018-04-22 06:05:45.600", `discMag`="19.82", `discMagFilter`="r-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF18aakkvea", `hostName`=null, `hostRedshift`=null, `objectUrl`="http://wis-tns.weizmann.ac.il/object/2018lvn", `raDeg`="198.52094583", `raSex`="13:14:05.027", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`survey`,`transRedshift`, dateCreated) VALUES ("2014fn" ,"AT2014fn" ,"-1.5281" ,"-01:31:41.16" ,"2014-03-26 07:32:28.000" ,"19.78" ,"r-Sloan" ,null ,null ,"2dFGRS N281Z200" ,"0.080166" ,"http://wis-tns.weizmann.ac.il/object/2014fn" ,"220.011225" ,"14:40:02.694" ,null ,null ,"Cornen" ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2014fn", `TNSName`="AT2014fn", `decDeg`="-1.5281", `decSex`="-01:31:41.16", `discDate`="2014-03-26 07:32:28.000", `discMag`="19.78", `discMagFilter`="r-Sloan", `discSurvey`=null, `discoveryName`=null, `hostName`="2dFGRS N281Z200", `hostRedshift`="0.080166", `objectUrl`="http://wis-tns.weizmann.ac.il/object/2014fn", `raDeg`="220.011225", `raSex`="14:40:02.694", `reportingSurvey`=null, `specType`=null, `survey`="Cornen", `transRedshift`=null ;