CREATE TABLE IF NOT EXISTS `fs_tns_photometry` (
  `primaryId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'An internal counter',
  `TNSId` varchar(20) NOT NULL,
  `dateCreated` datetime DEFAULT CURRENT_TIMESTAMP,
  `exptime` double DEFAULT NULL,
  `filter` varchar(100) DEFAULT NULL,
  `limitingMag` tinyint(4) DEFAULT NULL,
  `mag` double DEFAULT NULL,
  `magErr` double DEFAULT NULL,
  `magUnit` varchar(100) DEFAULT NULL,
  `objectName` varchar(100) DEFAULT NULL,
  `obsdate` datetime DEFAULT NULL,
  `reportAddedDate` datetime DEFAULT NULL,
  `suggestedType` varchar(100) DEFAULT NULL,
  `survey` varchar(100) DEFAULT NULL,
  `telescope` varchar(100) DEFAULT NULL,
  `updated` tinyint(4) DEFAULT '0',
  `dateLastModified` datetime DEFAULT NULL,
  `remarks` VARCHAR(800) NULL DEFAULT NULL,
  `sourceComment` VARCHAR(800) NULL DEFAULT NULL,
  PRIMARY KEY (`primaryId`),
  UNIQUE KEY `tnsid_survey_obsdate` (`TNSId`,`survey`,`obsdate`),
  UNIQUE INDEX `u_tnsid_survey_obsdate` (`TNSId` ASC, `survey` ASC, `obsdate` ASC),
  UNIQUE INDEX `u_tnsid_obsdate_objname` (`TNSId` ASC, `obsdate` ASC, `objectName` ASC)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=latin1;
            
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adiw" ,"30" ,"r-ZTF" ,"0" ,"20.4894" ,null ,"ABMag" ,"ZTF20acxwbrk" ,"2020-12-15 06:08:26" ,"2020-12-21 16:01:37" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4894", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxwbrk", `obsdate`="2020-12-15 06:08:26", `reportAddedDate`="2020-12-21 16:01:37", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adiw" ,"30" ,"r-ZTF" ,"1" ,"19.8841" ,null ,"ABMag" ,"ZTF20acxwbrk" ,"2020-12-12 07:54:30" ,"2020-12-21 16:01:37" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8841", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxwbrk", `obsdate`="2020-12-12 07:54:30", `reportAddedDate`="2020-12-21 16:01:37", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adiv" ,"30" ,"r-ZTF" ,"0" ,"20.4881" ,null ,"ABMag" ,"ZTF20accxjsv" ,"2020-09-16 11:49:29" ,"2020-12-21 16:01:31" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4881", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20accxjsv", `obsdate`="2020-09-16 11:49:29", `reportAddedDate`="2020-12-21 16:01:31", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adiv" ,"30" ,"g-ZTF" ,"1" ,"18.7696" ,null ,"ABMag" ,"ZTF20accxjsv" ,"2020-09-07 10:20:40" ,"2020-12-21 16:01:31" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.7696", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20accxjsv", `obsdate`="2020-09-07 10:20:40", `reportAddedDate`="2020-12-21 16:01:31", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adiu" ,"30" ,"g-ZTF" ,"0" ,"19.9292" ,null ,"ABMag" ,"ZTF20aczaawu" ,"2020-12-21 06:02:29" ,"2020-12-21 16:01:25" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.9292", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczaawu", `obsdate`="2020-12-21 06:02:29", `reportAddedDate`="2020-12-21 16:01:25", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adiu" ,"30" ,"r-ZTF" ,"1" ,"19.8798" ,null ,"ABMag" ,"ZTF20aczaawu" ,"2020-12-19 06:07:55" ,"2020-12-21 16:01:25" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8798", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczaawu", `obsdate`="2020-12-19 06:07:55", `reportAddedDate`="2020-12-21 16:01:25", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adit" ,"30" ,"g-ZTF" ,"0" ,"20.3972" ,null ,"ABMag" ,"ZTF20aczediz" ,"2020-12-20 09:50:53" ,"2020-12-21 16:01:17" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adit", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.3972", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczediz", `obsdate`="2020-12-20 09:50:53", `reportAddedDate`="2020-12-21 16:01:17", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adit" ,"30" ,"r-ZTF" ,"1" ,"19.673" ,null ,"ABMag" ,"ZTF20aczediz" ,"2020-12-17 12:27:08" ,"2020-12-21 16:01:17" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adit", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.673", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczediz", `obsdate`="2020-12-17 12:27:08", `reportAddedDate`="2020-12-21 16:01:17", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adis" ,"30" ,"g-ZTF" ,"0" ,"20.0874" ,null ,"ABMag" ,"ZTF20aczgoml" ,"2020-12-19 12:06:31" ,"2020-12-21 16:01:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adis", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0874", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczgoml", `obsdate`="2020-12-19 12:06:31", `reportAddedDate`="2020-12-21 16:01:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adis" ,"30" ,"g-ZTF" ,"1" ,"20.2464" ,null ,"ABMag" ,"ZTF20aczgoml" ,"2020-12-16 13:04:39" ,"2020-12-21 16:01:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adis", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.2464", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczgoml", `obsdate`="2020-12-16 13:04:39", `reportAddedDate`="2020-12-21 16:01:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adir" ,"30" ,"r-ZTF" ,"0" ,"19.8826" ,null ,"ABMag" ,"ZTF20acwvkve" ,"2020-12-16 09:42:16" ,"2020-12-21 16:01:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adir", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8826", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwvkve", `obsdate`="2020-12-16 09:42:16", `reportAddedDate`="2020-12-21 16:01:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adir" ,"30" ,"r-ZTF" ,"1" ,"20.0062" ,null ,"ABMag" ,"ZTF20acwvkve" ,"2020-12-13 11:36:56" ,"2020-12-21 16:01:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adir", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0062", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwvkve", `obsdate`="2020-12-13 11:36:56", `reportAddedDate`="2020-12-21 16:01:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adiq" ,"30" ,"orange-ATLAS" ,"0" ,"18.754" ,"0.152" ,"ABMag" ,"ATLAS20bhfg" ,"2020-12-20 05:49:55" ,"2020-12-21 15:10:25" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiq", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.754", `magErr`="0.152", `magUnit`="ABMag", `objectName`="ATLAS20bhfg", `obsdate`="2020-12-20 05:49:55", `reportAddedDate`="2020-12-21 15:10:25", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adiq" ,"30" ,"cyan-ATLAS" ,"1" ,"19.54" ,null ,"ABMag" ,"ATLAS20bhfg" ,"2020-12-14 06:18:43" ,"2020-12-21 15:10:25" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adiq", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.54", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhfg", `obsdate`="2020-12-14 06:18:43", `reportAddedDate`="2020-12-21 15:10:25", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adip" ,"30" ,"cyan-ATLAS" ,"0" ,"18.806" ,"0.136" ,"ABMag" ,"ATLAS20bhoo" ,"2020-12-11 05:29:46" ,"2020-12-21 15:09:21" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adip", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.806", `magErr`="0.136", `magUnit`="ABMag", `objectName`="ATLAS20bhoo", `obsdate`="2020-12-11 05:29:46", `reportAddedDate`="2020-12-21 15:09:21", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adip" ,"30" ,"orange-ATLAS" ,"1" ,"19.38" ,null ,"ABMag" ,"ATLAS20bhoo" ,"2020-12-09 06:07:12" ,"2020-12-21 15:09:21" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adip", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.38", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhoo", `obsdate`="2020-12-09 06:07:12", `reportAddedDate`="2020-12-21 15:09:21", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adio" ,"30" ,"cyan-ATLAS" ,"0" ,"18.949" ,"0.139" ,"ABMag" ,"ATLAS20bhfj" ,"2020-12-10 05:42:43" ,"2020-12-21 15:04:54" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adio", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.949", `magErr`="0.139", `magUnit`="ABMag", `objectName`="ATLAS20bhfj", `obsdate`="2020-12-10 05:42:43", `reportAddedDate`="2020-12-21 15:04:54", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adio" ,"30" ,"orange-ATLAS" ,"1" ,"19.44" ,null ,"ABMag" ,"ATLAS20bhfj" ,"2020-12-08 05:58:34" ,"2020-12-21 15:04:54" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adio", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.44", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhfj", `obsdate`="2020-12-08 05:58:34", `reportAddedDate`="2020-12-21 15:04:54", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adin" ,"30" ,"cyan-ATLAS" ,"0" ,"19.145" ,"0.162" ,"ABMag" ,"ATLAS20bhft" ,"2020-12-14 08:21:07" ,"2020-12-21 15:04:06" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adin", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.145", `magErr`="0.162", `magUnit`="ABMag", `objectName`="ATLAS20bhft", `obsdate`="2020-12-14 08:21:07", `reportAddedDate`="2020-12-21 15:04:06", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adin" ,"30" ,"cyan-ATLAS" ,"1" ,"19.5" ,null ,"ABMag" ,"ATLAS20bhft" ,"2020-12-12 08:48:29" ,"2020-12-21 15:04:06" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adin", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhft", `obsdate`="2020-12-12 08:48:29", `reportAddedDate`="2020-12-21 15:04:06", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adim" ,"30" ,"cyan-ATLAS" ,"0" ,"19.587" ,"0.176" ,"ABMag" ,"ATLAS20bhfw" ,"2020-12-10 10:01:55" ,"2020-12-21 15:01:55" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adim", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.587", `magErr`="0.176", `magUnit`="ABMag", `objectName`="ATLAS20bhfw", `obsdate`="2020-12-10 10:01:55", `reportAddedDate`="2020-12-21 15:01:55", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adim" ,"30" ,"orange-ATLAS" ,"1" ,"19.42" ,null ,"ABMag" ,"ATLAS20bhfw" ,"2020-12-09 11:24:00" ,"2020-12-21 15:01:55" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adim", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.42", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhfw", `obsdate`="2020-12-09 11:24:00", `reportAddedDate`="2020-12-21 15:01:55", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adil" ,"30" ,"orange-ATLAS" ,"0" ,"19.331" ,"0.183" ,"ABMag" ,"ATLAS20bhhb" ,"2020-12-10 14:21:07" ,"2020-12-21 14:56:38" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adil", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="19.331", `magErr`="0.183", `magUnit`="ABMag", `objectName`="ATLAS20bhhb", `obsdate`="2020-12-10 14:21:07", `reportAddedDate`="2020-12-21 14:56:38", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adil" ,"30" ,"orange-ATLAS" ,"1" ,"19.11" ,null ,"ABMag" ,"ATLAS20bhhb" ,"2020-12-08 13:55:12" ,"2020-12-21 14:56:38" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adil", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.11", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhhb", `obsdate`="2020-12-08 13:55:12", `reportAddedDate`="2020-12-21 14:56:38", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adik" ,"30" ,"g-ZTF" ,"0" ,"18.97" ,null ,"ABMag" ,"ZTF20aczfwjj" ,"2020-12-21 11:12:29" ,"2020-12-21 14:37:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adik", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.97", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczfwjj", `obsdate`="2020-12-21 11:12:29", `reportAddedDate`="2020-12-21 14:37:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adik" ,"30" ,"g-ZTF" ,"0" ,"19.71" ,null ,"ABMag" ,"ZTF20aczfwjj" ,"2020-12-19 12:01:26" ,"2020-12-21 14:37:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adik", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.71", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczfwjj", `obsdate`="2020-12-19 12:01:26", `reportAddedDate`="2020-12-21 14:37:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adik" ,"30" ,"r-ZTF" ,"1" ,"19.64" ,null ,"ABMag" ,"ZTF20aczfwjj" ,"2020-12-16 12:30:14" ,"2020-12-21 14:37:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adik", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.64", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczfwjj", `obsdate`="2020-12-16 12:30:14", `reportAddedDate`="2020-12-21 14:37:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adij" ,"30" ,"g-ZTF" ,"0" ,"19.501" ,null ,"ABMag" ,"ZTF20acyybwo" ,"2020-12-17 11:22:59" ,"2020-12-21 14:01:12" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adij", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.501", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyybwo", `obsdate`="2020-12-17 11:22:59", `reportAddedDate`="2020-12-21 14:01:12", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adij" ,"30" ,"g-ZTF" ,"1" ,"20.4643" ,null ,"ABMag" ,"ZTF20acyybwo" ,"2020-12-15 12:46:07" ,"2020-12-21 14:01:12" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adij", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4643", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyybwo", `obsdate`="2020-12-15 12:46:07", `reportAddedDate`="2020-12-21 14:01:12", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adii" ,"30" ,"g-ZTF" ,"0" ,"18.4092" ,null ,"ABMag" ,"ZTF20acywbes" ,"2020-12-20 09:45:15" ,"2020-12-21 14:00:54" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adii", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.4092", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acywbes", `obsdate`="2020-12-20 09:45:15", `reportAddedDate`="2020-12-21 14:00:54", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adii" ,"30" ,"r-ZTF" ,"1" ,"19.4747" ,null ,"ABMag" ,"ZTF20acywbes" ,"2020-12-17 12:18:02" ,"2020-12-21 14:00:54" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adii", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.4747", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acywbes", `obsdate`="2020-12-17 12:18:02", `reportAddedDate`="2020-12-21 14:00:54", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adih" ,"30" ,"r-ZTF" ,"0" ,"19.53" ,"0.24" ,"ABMag" ,"ZTF20acxzkds" ,"2020-12-19 12:49:36" ,"2020-12-21 13:19:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adih", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.53", `magErr`="0.24", `magUnit`="ABMag", `objectName`="ZTF20acxzkds", `obsdate`="2020-12-19 12:49:36", `reportAddedDate`="2020-12-21 13:19:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adih" ,"30" ,"g-ZTF" ,"0" ,"19.74" ,"0.18" ,"ABMag" ,"ZTF20acxzkds" ,"2020-12-19 12:13:17" ,"2020-12-21 13:19:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adih", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.74", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acxzkds", `obsdate`="2020-12-19 12:13:17", `reportAddedDate`="2020-12-21 13:19:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adih" ,"30" ,"g-ZTF" ,"1" ,"20.0765" ,null ,"ABMag" ,"ZTF20acxzkds" ,"2020-12-11 13:00:14" ,"2020-12-21 13:19:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adih", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.0765", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxzkds", `obsdate`="2020-12-11 13:00:14", `reportAddedDate`="2020-12-21 13:19:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adig" ,"30" ,"r-ZTF" ,"0" ,"19.36" ,"0.17" ,"ABMag" ,"ZTF20abgoagd" ,"2020-12-10 13:27:22" ,"2020-12-21 13:19:04" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adig", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.36", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20abgoagd", `obsdate`="2020-12-10 13:27:22", `reportAddedDate`="2020-12-21 13:19:04", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adig" ,"30" ,"r-ZTF" ,"0" ,"19.65" ,"0.28" ,"ABMag" ,"ZTF20abgoagd" ,"2020-12-10 13:13:49" ,"2020-12-21 13:19:04" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adig", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.65", `magErr`="0.28", `magUnit`="ABMag", `objectName`="ZTF20abgoagd", `obsdate`="2020-12-10 13:13:49", `reportAddedDate`="2020-12-21 13:19:04", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adig" ,"30" ,"r-ZTF" ,"1" ,"19.517" ,null ,"ABMag" ,"ZTF20abgoagd" ,"2020-12-06 13:28:39" ,"2020-12-21 13:19:04" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adig", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.517", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20abgoagd", `obsdate`="2020-12-06 13:28:39", `reportAddedDate`="2020-12-21 13:19:04", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adif" ,"30" ,"g-ZTF" ,"0" ,"19.36" ,"0.15" ,"ABMag" ,"ZTF20aczefjj" ,"2020-12-21 11:08:55" ,"2020-12-21 12:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adif", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.36", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20aczefjj", `obsdate`="2020-12-21 11:08:55", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adif" ,"30" ,"r-ZTF" ,"0" ,"19.59" ,"0.14" ,"ABMag" ,"ZTF20aczefjj" ,"2020-12-21 10:04:19" ,"2020-12-21 12:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adif", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.59", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20aczefjj", `obsdate`="2020-12-21 10:04:19", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adif" ,"30" ,"r-ZTF" ,"1" ,"19.6291" ,null ,"ABMag" ,"ZTF20aczefjj" ,"2020-12-15 11:33:56" ,"2020-12-21 12:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adif", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6291", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczefjj", `obsdate`="2020-12-15 11:33:56", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adie" ,"30" ,"g-ZTF" ,"0" ,"19.73" ,"0.2" ,"ABMag" ,"ZTF20acrsbgc" ,"2020-12-21 11:14:21" ,"2020-12-21 12:18:53" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adie", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.73", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acrsbgc", `obsdate`="2020-12-21 11:14:21", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adie" ,"30" ,"g-ZTF" ,"0" ,"19.5" ,"0.13" ,"ABMag" ,"ZTF20acrsbgc" ,"2020-12-21 11:13:40" ,"2020-12-21 12:18:53" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adie", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.5", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acrsbgc", `obsdate`="2020-12-21 11:13:40", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adie" ,"30" ,"r-ZTF" ,"1" ,"19.6939" ,null ,"ABMag" ,"ZTF20acrsbgc" ,"2020-12-18 12:21:27" ,"2020-12-21 12:18:53" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adie", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6939", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acrsbgc", `obsdate`="2020-12-18 12:21:27", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adid" ,"30" ,"cyan-ATLAS" ,"0" ,"18.983" ,"0.171" ,"ABMag" ,"ATLAS20bhnb" ,"2020-12-11 15:23:02" ,"2020-12-21 12:05:01" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adid", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.983", `magErr`="0.171", `magUnit`="ABMag", `objectName`="ATLAS20bhnb", `obsdate`="2020-12-11 15:23:02", `reportAddedDate`="2020-12-21 12:05:01", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adid" ,"30" ,"orange-ATLAS" ,"1" ,"18.61" ,null ,"ABMag" ,"ATLAS20bhnb" ,"2020-12-07 15:50:24" ,"2020-12-21 12:05:01" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adid", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.61", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhnb", `obsdate`="2020-12-07 15:50:24", `reportAddedDate`="2020-12-21 12:05:01", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adic" ,"30" ,"cyan-ATLAS" ,"0" ,"19.447" ,"0.15" ,"ABMag" ,"ATLAS20bhnk" ,"2020-12-12 07:00:29" ,"2020-12-21 12:02:46" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adic", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.447", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ATLAS20bhnk", `obsdate`="2020-12-12 07:00:29", `reportAddedDate`="2020-12-21 12:02:46", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adic" ,"30" ,"cyan-ATLAS" ,"1" ,"19.54" ,null ,"ABMag" ,"ATLAS20bhnk" ,"2020-12-10 08:09:36" ,"2020-12-21 12:02:46" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adic", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.54", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhnk", `obsdate`="2020-12-10 08:09:36", `reportAddedDate`="2020-12-21 12:02:46", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adib" ,"30" ,"cyan-ATLAS" ,"0" ,"19.263" ,"0.116" ,"ABMag" ,"ATLAS20bhnm" ,"2020-12-12 08:38:24" ,"2020-12-21 12:01:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adib", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.263", `magErr`="0.116", `magUnit`="ABMag", `objectName`="ATLAS20bhnm", `obsdate`="2020-12-12 08:38:24", `reportAddedDate`="2020-12-21 12:01:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adib" ,"30" ,"cyan-ATLAS" ,"1" ,"19.69" ,null ,"ABMag" ,"ATLAS20bhnm" ,"2020-12-10 09:28:48" ,"2020-12-21 12:01:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adib", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.69", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhnm", `obsdate`="2020-12-10 09:28:48", `reportAddedDate`="2020-12-21 12:01:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adia" ,"160" ,"Clear-" ,"0" ,"17.1" ,null ,"VegaMag" ,"MASTER OT J141825.72-463755.0" ,"2020-12-21 07:12:26" ,"2020-12-21 11:17:04" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adia", `exptime`="160", `filter`="Clear-", `limitingMag`="0", `mag`="17.1", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J141825.72-463755.0", `obsdate`="2020-12-21 07:12:26", `reportAddedDate`="2020-12-21 11:17:04", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adia" ,"70" ,"Clear-" ,"0" ,"17.1" ,null ,"VegaMag" ,"MASTER OT J141825.72-463755.0" ,"2020-12-21 07:10:17" ,"2020-12-21 11:17:04" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adia", `exptime`="70", `filter`="Clear-", `limitingMag`="0", `mag`="17.1", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J141825.72-463755.0", `obsdate`="2020-12-21 07:10:17", `reportAddedDate`="2020-12-21 11:17:04", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adia" ,"540" ,"Clear-" ,"1" ,"19.1" ,null ,"VegaMag" ,"MASTER OT J141825.72-463755.0" ,"2019-12-24 06:56:12" ,"2020-12-21 11:17:04" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adia", `exptime`="540", `filter`="Clear-", `limitingMag`="1", `mag`="19.1", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J141825.72-463755.0", `obsdate`="2019-12-24 06:56:12", `reportAddedDate`="2020-12-21 11:17:04", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhz" ,"30" ,"g-ZTF" ,"0" ,"19.98" ,null ,"ABMag" ,"ZTF20acyybvq" ,"2020-12-20 12:44:38" ,"2020-12-21 08:37:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.98", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyybvq", `obsdate`="2020-12-20 12:44:38", `reportAddedDate`="2020-12-21 08:37:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhz" ,"30" ,"r-ZTF" ,"0" ,"20.05" ,null ,"ABMag" ,"ZTF20acyybvq" ,"2020-12-20 12:08:38" ,"2020-12-21 08:37:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.05", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyybvq", `obsdate`="2020-12-20 12:08:38", `reportAddedDate`="2020-12-21 08:37:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhz" ,"30" ,"r-ZTF" ,"1" ,"19.71" ,null ,"ABMag" ,"ZTF20acyybvq" ,"2020-12-17 12:43:12" ,"2020-12-21 08:37:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.71", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyybvq", `obsdate`="2020-12-17 12:43:12", `reportAddedDate`="2020-12-21 08:37:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhy" ,"30" ,"r-ZTF" ,"0" ,"18.46" ,null ,"ABMag" ,"ZTF20acympvl" ,"2020-12-21 03:11:31" ,"2020-12-21 06:37:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.46", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acympvl", `obsdate`="2020-12-21 03:11:31", `reportAddedDate`="2020-12-21 06:37:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhy" ,"30" ,"g-ZTF" ,"0" ,"18.48" ,null ,"ABMag" ,"ZTF20acympvl" ,"2020-12-19 03:44:38" ,"2020-12-21 06:37:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhy", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.48", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acympvl", `obsdate`="2020-12-19 03:44:38", `reportAddedDate`="2020-12-21 06:37:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhy" ,"30" ,"g-ZTF" ,"1" ,"19.56" ,null ,"ABMag" ,"ZTF20acympvl" ,"2020-12-16 04:22:05" ,"2020-12-21 06:37:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhy", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.56", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acympvl", `obsdate`="2020-12-16 04:22:05", `reportAddedDate`="2020-12-21 06:37:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhx" ,"30" ,"g-ZTF" ,"0" ,"19.5" ,"0.21" ,"ABMag" ,"ZTF20acynjyj" ,"2020-12-19 04:31:56" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhx", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.5", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF20acynjyj", `obsdate`="2020-12-19 04:31:56", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhx" ,"30" ,"g-ZTF" ,"0" ,"19.75" ,"0.26" ,"ABMag" ,"ZTF20acynjyj" ,"2020-12-16 04:31:38" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhx", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.75", `magErr`="0.26", `magUnit`="ABMag", `objectName`="ZTF20acynjyj", `obsdate`="2020-12-16 04:31:38", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhx" ,"30" ,"r-ZTF" ,"1" ,"20.0028" ,null ,"ABMag" ,"ZTF20acynjyj" ,"2020-12-12 05:02:15" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhx", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0028", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynjyj", `obsdate`="2020-12-12 05:02:15", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhw" ,"30" ,"r-ZTF" ,"0" ,"19.9" ,"0.22" ,"ABMag" ,"ZTF20acvziru" ,"2020-12-11 06:04:34" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acvziru", `obsdate`="2020-12-11 06:04:34", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhw" ,"30" ,"g-ZTF" ,"0" ,"20.13" ,"0.25" ,"ABMag" ,"ZTF20acvziru" ,"2020-12-11 05:03:39" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.13", `magErr`="0.25", `magUnit`="ABMag", `objectName`="ZTF20acvziru", `obsdate`="2020-12-11 05:03:39", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhw" ,"30" ,"g-ZTF" ,"1" ,"19.7623" ,null ,"ABMag" ,"ZTF20acvziru" ,"2020-12-09 05:07:25" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7623", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvziru", `obsdate`="2020-12-09 05:07:25", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhv" ,"30" ,"r-ZTF" ,"0" ,"19.35" ,"0.12" ,"ABMag" ,"ZTF17aabvqrn" ,"2020-12-21 04:55:59" ,"2020-12-21 05:19:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.35", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF17aabvqrn", `obsdate`="2020-12-21 04:55:59", `reportAddedDate`="2020-12-21 05:19:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhv" ,"30" ,"r-ZTF" ,"0" ,"19.51" ,"0.14" ,"ABMag" ,"ZTF17aabvqrn" ,"2020-12-19 06:54:02" ,"2020-12-21 05:19:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.51", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF17aabvqrn", `obsdate`="2020-12-19 06:54:02", `reportAddedDate`="2020-12-21 05:19:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhv" ,"30" ,"g-ZTF" ,"1" ,"20.3859" ,null ,"ABMag" ,"ZTF17aabvqrn" ,"2020-12-19 04:35:20" ,"2020-12-21 05:19:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3859", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF17aabvqrn", `obsdate`="2020-12-19 04:35:20", `reportAddedDate`="2020-12-21 05:19:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhu" ,"30" ,"r-ZTF" ,"0" ,"19.22" ,"0.17" ,"ABMag" ,"ZTF20acxuibv" ,"2020-12-21 03:58:29" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.22", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxuibv", `obsdate`="2020-12-21 03:58:29", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhu" ,"30" ,"g-ZTF" ,"0" ,"19.54" ,"0.17" ,"ABMag" ,"ZTF20acxuibv" ,"2020-12-21 02:55:57" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.54", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxuibv", `obsdate`="2020-12-21 02:55:57", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhu" ,"30" ,"g-ZTF" ,"1" ,"19.8192" ,null ,"ABMag" ,"ZTF20acxuibv" ,"2020-12-16 03:54:38" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8192", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxuibv", `obsdate`="2020-12-16 03:54:38", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adht" ,"30" ,"r-ZTF" ,"0" ,"19.46" ,"0.13" ,"ABMag" ,"ZTF20acxnsim" ,"2020-12-19 03:27:16" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adht", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.46", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxnsim", `obsdate`="2020-12-19 03:27:16", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adht" ,"30" ,"g-ZTF" ,"0" ,"19.9" ,"0.22" ,"ABMag" ,"ZTF20acxnsim" ,"2020-12-16 04:07:16" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adht", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.9", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acxnsim", `obsdate`="2020-12-16 04:07:16", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adht" ,"30" ,"g-ZTF" ,"1" ,"20.526" ,null ,"ABMag" ,"ZTF20acxnsim" ,"2020-12-12 04:19:39" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adht", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.526", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxnsim", `obsdate`="2020-12-12 04:19:39", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhs" ,"30" ,"r-ZTF" ,"0" ,"19.55" ,"0.14" ,"ABMag" ,"ZTF20acxcwkr" ,"2020-12-21 04:06:27" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhs", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.55", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acxcwkr", `obsdate`="2020-12-21 04:06:27", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhs" ,"30" ,"r-ZTF" ,"0" ,"19.41" ,"0.14" ,"ABMag" ,"ZTF20acxcwkr" ,"2020-12-19 06:54:45" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhs", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.41", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acxcwkr", `obsdate`="2020-12-19 06:54:45", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhs" ,"30" ,"g-ZTF" ,"1" ,"20.1969" ,null ,"ABMag" ,"ZTF20acxcwkr" ,"2020-12-19 05:29:01" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhs", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.1969", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxcwkr", `obsdate`="2020-12-19 05:29:01", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhr" ,"30" ,"g-ZTF" ,"0" ,"19.64" ,"0.24" ,"ABMag" ,"ZTF20acwzxxy" ,"2020-12-16 03:59:22" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhr", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.64", `magErr`="0.24", `magUnit`="ABMag", `objectName`="ZTF20acwzxxy", `obsdate`="2020-12-16 03:59:22", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhr" ,"30" ,"r-ZTF" ,"0" ,"19.66" ,"0.16" ,"ABMag" ,"ZTF20acwzxxy" ,"2020-12-16 02:38:06" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.66", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acwzxxy", `obsdate`="2020-12-16 02:38:06", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhr" ,"30" ,"r-ZTF" ,"1" ,"19.5088" ,null ,"ABMag" ,"ZTF20acwzxxy" ,"2020-12-10 02:53:45" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5088", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwzxxy", `obsdate`="2020-12-10 02:53:45", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhq" ,"30" ,"r-ZTF" ,"0" ,"19.48" ,"0.18" ,"ABMag" ,"ZTF20acxuxdd" ,"2020-12-19 03:09:41" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.48", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acxuxdd", `obsdate`="2020-12-19 03:09:41", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhq" ,"30" ,"g-ZTF" ,"0" ,"19.68" ,"0.19" ,"ABMag" ,"ZTF20acxuxdd" ,"2020-12-16 04:06:35" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.68", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acxuxdd", `obsdate`="2020-12-16 04:06:35", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhq" ,"30" ,"g-ZTF" ,"1" ,"20.4935" ,null ,"ABMag" ,"ZTF20acxuxdd" ,"2020-12-12 03:59:57" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4935", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxuxdd", `obsdate`="2020-12-12 03:59:57", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhp" ,"30" ,"g-ZTF" ,"0" ,"19.51" ,"0.16" ,"ABMag" ,"ZTF20acxuhys" ,"2020-12-19 04:20:51" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.51", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acxuhys", `obsdate`="2020-12-19 04:20:51", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhp" ,"30" ,"g-ZTF" ,"0" ,"19.47" ,"0.16" ,"ABMag" ,"ZTF20acxuhys" ,"2020-12-19 04:20:11" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.47", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acxuhys", `obsdate`="2020-12-19 04:20:11", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhp" ,"30" ,"r-ZTF" ,"1" ,"20.1556" ,null ,"ABMag" ,"ZTF20acxuhys" ,"2020-12-19 02:21:38" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1556", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxuhys", `obsdate`="2020-12-19 02:21:38", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adho" ,"30" ,"g-ZTF" ,"0" ,"19.08" ,"0.27" ,"ABMag" ,"ZTF20acxnjat" ,"2020-12-16 03:37:39" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adho", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.08", `magErr`="0.27", `magUnit`="ABMag", `objectName`="ZTF20acxnjat", `obsdate`="2020-12-16 03:37:39", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adho" ,"30" ,"r-ZTF" ,"0" ,"19.18" ,"0.15" ,"ABMag" ,"ZTF20acxnjat" ,"2020-12-16 02:14:35" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adho", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.18", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acxnjat", `obsdate`="2020-12-16 02:14:35", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adho" ,"30" ,"r-ZTF" ,"1" ,"19.7903" ,null ,"ABMag" ,"ZTF20acxnjat" ,"2020-12-11 02:57:04" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adho", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7903", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxnjat", `obsdate`="2020-12-11 02:57:04", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhn" ,"30" ,"g-ZTF" ,"0" ,"18.85" ,"0.14" ,"ABMag" ,"ZTF20acxbskl" ,"2020-12-21 02:34:17" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.85", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acxbskl", `obsdate`="2020-12-21 02:34:17", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhn" ,"30" ,"g-ZTF" ,"0" ,"19.04" ,"0.15" ,"ABMag" ,"ZTF20acxbskl" ,"2020-12-19 04:39:24" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.04", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acxbskl", `obsdate`="2020-12-19 04:39:24", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhn" ,"30" ,"r-ZTF" ,"1" ,"19.6937" ,null ,"ABMag" ,"ZTF20acxbskl" ,"2020-12-19 03:04:16" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6937", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbskl", `obsdate`="2020-12-19 03:04:16", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhm" ,"30" ,"r-ZTF" ,"0" ,"16.76" ,"0.11" ,"ABMag" ,"ZTF19aazlvbw" ,"2020-12-21 03:03:53" ,"2020-12-21 03:18:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="16.76", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF19aazlvbw", `obsdate`="2020-12-21 03:03:53", `reportAddedDate`="2020-12-21 03:18:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhm" ,"30" ,"g-ZTF" ,"0" ,"17.29" ,"0.15" ,"ABMag" ,"ZTF19aazlvbw" ,"2020-12-21 02:18:30" ,"2020-12-21 03:18:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="17.29", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF19aazlvbw", `obsdate`="2020-12-21 02:18:30", `reportAddedDate`="2020-12-21 03:18:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhm" ,"30" ,"r-ZTF" ,"1" ,"19.6484" ,null ,"ABMag" ,"ZTF19aazlvbw" ,"2020-12-16 02:14:35" ,"2020-12-21 03:18:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6484", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF19aazlvbw", `obsdate`="2020-12-16 02:14:35", `reportAddedDate`="2020-12-21 03:18:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhl" ,"30" ,"g-ZTF" ,"0" ,"20.414" ,"0.252" ,"ABMag" ,"ZTF20acrjifk" ,"2020-11-15 12:09:51" ,"2020-12-21 01:01:52" ,"SGLF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.414", `magErr`="0.252", `magUnit`="ABMag", `objectName`="ZTF20acrjifk", `obsdate`="2020-11-15 12:09:51", `reportAddedDate`="2020-12-21 01:01:52", `reportingGroup`="SGLF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhl" ,"30" ,"g-ZTF" ,"1" ,"20.513" ,null ,"ABMag" ,"ZTF20acrjifk" ,"2020-11-12 12:44:09" ,"2020-12-21 01:01:52" ,"SGLF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.513", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acrjifk", `obsdate`="2020-11-12 12:44:09", `reportAddedDate`="2020-12-21 01:01:52", `reportingGroup`="SGLF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhk" ,"30" ,"g-ZTF" ,"0" ,"19.58" ,"0.158" ,"ABMag" ,"ZTF20actoakk" ,"2020-11-24 12:39:57" ,"2020-12-21 00:23:30" ,"SGLF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.58", `magErr`="0.158", `magUnit`="ABMag", `objectName`="ZTF20actoakk", `obsdate`="2020-11-24 12:39:57", `reportAddedDate`="2020-12-21 00:23:30", `reportingGroup`="SGLF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhk" ,"30" ,"r-ZTF" ,"1" ,"17.731" ,null ,"ABMag" ,"ZTF20actoakk" ,"2020-11-22 12:04:26" ,"2020-12-21 00:23:30" ,"SGLF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="17.731", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20actoakk", `obsdate`="2020-11-22 12:04:26", `reportAddedDate`="2020-12-21 00:23:30", `reportingGroup`="SGLF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhj" ,"30" ,"orange-ATLAS" ,"0" ,"18.893" ,"0.162" ,"ABMag" ,"ATLAS20birq" ,"2020-12-20 07:35:02" ,"2020-12-20 19:22:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhj", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.893", `magErr`="0.162", `magUnit`="ABMag", `objectName`="ATLAS20birq", `obsdate`="2020-12-20 07:35:02", `reportAddedDate`="2020-12-20 19:22:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhj" ,"30" ,"cyan-ATLAS" ,"1" ,"19.57" ,null ,"ABMag" ,"ATLAS20birq" ,"2020-12-14 07:52:19" ,"2020-12-20 19:22:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhj", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.57", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20birq", `obsdate`="2020-12-14 07:52:19", `reportAddedDate`="2020-12-20 19:22:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhi" ,"30" ,"g-ZTF" ,"0" ,"18.94" ,null ,"ABMag" ,"ZTF20acyzsol" ,"2020-12-21 05:35:31" ,"2020-12-21 14:37:52" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.94", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyzsol", `obsdate`="2020-12-21 05:35:31", `reportAddedDate`="2020-12-21 14:37:52", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhi" ,"30" ,"r-ZTF" ,"0" ,"20.29" ,null ,"ABMag" ,"ZTF20acyzsol" ,"2020-12-17 02:32:38" ,"2020-12-21 14:37:52" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.29", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyzsol", `obsdate`="2020-12-17 02:32:38", `reportAddedDate`="2020-12-21 14:37:52", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhi" ,"30" ,"g-ZTF" ,"1" ,"19.67" ,null ,"ABMag" ,"ZTF20acyzsol" ,"2020-12-15 03:31:41" ,"2020-12-21 14:37:52" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.67", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyzsol", `obsdate`="2020-12-15 03:31:41", `reportAddedDate`="2020-12-21 14:37:52", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhi" ,"30" ,"orange-ATLAS" ,"0" ,"19.177" ,"0.191" ,"ABMag" ,"ATLAS20birp" ,"2020-12-20 06:56:10" ,"2020-12-20 19:21:36" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhi", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="19.177", `magErr`="0.191", `magUnit`="ABMag", `objectName`="ATLAS20birp", `obsdate`="2020-12-20 06:56:10", `reportAddedDate`="2020-12-20 19:21:36", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhi" ,"30" ,"cyan-ATLAS" ,"1" ,"19.66" ,null ,"ABMag" ,"ATLAS20birp" ,"2020-12-15 07:10:34" ,"2020-12-20 19:21:36" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhi", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.66", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20birp", `obsdate`="2020-12-15 07:10:34", `reportAddedDate`="2020-12-20 19:21:36", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhh" ,"30" ,"r-ZTF" ,"0" ,"18.4911" ,null ,"ABMag" ,"ZTF20acytgxf" ,"2020-12-20 05:12:07" ,"2020-12-21 14:01:06" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.4911", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acytgxf", `obsdate`="2020-12-20 05:12:07", `reportAddedDate`="2020-12-21 14:01:06", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhh" ,"30" ,"r-ZTF" ,"1" ,"20.5787" ,null ,"ABMag" ,"ZTF20acytgxf" ,"2020-12-17 06:12:28" ,"2020-12-21 14:01:06" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.5787", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acytgxf", `obsdate`="2020-12-17 06:12:28", `reportAddedDate`="2020-12-21 14:01:06", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhh" ,null ,"V-crts-CRTS" ,"0" ,"21" ,null ,"VegaMag" ,null ,"2020-12-17 07:28:42" ,"2020-12-20 19:20:14" ,"SNHunt" ,"PSN" ,"CRTS" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhh", `exptime`=null, `filter`="V-crts-CRTS", `limitingMag`="0", `mag`="21", `magErr`=null, `magUnit`="VegaMag", `objectName`=null, `obsdate`="2020-12-17 07:28:42", `reportAddedDate`="2020-12-20 19:20:14", `reportingGroup`="SNHunt", `suggestedType`="PSN", `survey`="CRTS", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhh" ,null ,"V-crts-CRTS" ,"1" ,"21.5" ,null ,"VegaMag" ,null ,"2020-10-28 07:22:57" ,"2020-12-20 19:20:14" ,"SNHunt" ,"PSN" ,"CRTS" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhh", `exptime`=null, `filter`="V-crts-CRTS", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="VegaMag", `objectName`=null, `obsdate`="2020-10-28 07:22:57", `reportAddedDate`="2020-12-20 19:20:14", `reportingGroup`="SNHunt", `suggestedType`="PSN", `survey`="CRTS", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhg" ,"30" ,"orange-ATLAS" ,"0" ,"18.719" ,"0.147" ,"ABMag" ,"ATLAS20birn" ,"2020-12-20 07:14:53" ,"2020-12-20 19:18:37" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhg", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.719", `magErr`="0.147", `magUnit`="ABMag", `objectName`="ATLAS20birn", `obsdate`="2020-12-20 07:14:53", `reportAddedDate`="2020-12-20 19:18:37", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhg" ,"30" ,"cyan-ATLAS" ,"1" ,"19.47" ,null ,"ABMag" ,"ATLAS20birn" ,"2020-12-14 07:14:53" ,"2020-12-20 19:18:37" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhg", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.47", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20birn", `obsdate`="2020-12-14 07:14:53", `reportAddedDate`="2020-12-20 19:18:37", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhf" ,"30" ,"cyan-ATLAS" ,"0" ,"19.477" ,"0.192" ,"ABMag" ,"ATLAS20biij" ,"2020-12-14 13:27:50" ,"2020-12-20 18:57:38" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhf", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.477", `magErr`="0.192", `magUnit`="ABMag", `objectName`="ATLAS20biij", `obsdate`="2020-12-14 13:27:50", `reportAddedDate`="2020-12-20 18:57:38", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhf" ,"30" ,"cyan-ATLAS" ,"1" ,"19.73" ,null ,"ABMag" ,"ATLAS20biij" ,"2020-12-12 13:56:38" ,"2020-12-20 18:57:38" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhf", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.73", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biij", `obsdate`="2020-12-12 13:56:38", `reportAddedDate`="2020-12-20 18:57:38", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhe" ,"30" ,"cyan-ATLAS" ,"0" ,"17.554" ,"0.063" ,"ABMag" ,"ATLAS20bigq" ,"2020-12-14 15:21:36" ,"2020-12-20 18:55:41" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhe", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="17.554", `magErr`="0.063", `magUnit`="ABMag", `objectName`="ATLAS20bigq", `obsdate`="2020-12-14 15:21:36", `reportAddedDate`="2020-12-20 18:55:41", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhe" ,"30" ,"cyan-ATLAS" ,"1" ,"19.3" ,null ,"ABMag" ,"ATLAS20bigq" ,"2020-05-12 07:14:53" ,"2020-12-20 18:55:41" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhe", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.3", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bigq", `obsdate`="2020-05-12 07:14:53", `reportAddedDate`="2020-12-20 18:55:41", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhd" ,"30" ,"cyan-ATLAS" ,"0" ,"19.479" ,"0.165" ,"ABMag" ,"ATLAS20biht" ,"2020-12-14 11:22:34" ,"2020-12-20 18:55:12" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.479", `magErr`="0.165", `magUnit`="ABMag", `objectName`="ATLAS20biht", `obsdate`="2020-12-14 11:22:34", `reportAddedDate`="2020-12-20 18:55:12", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhd" ,"30" ,"cyan-ATLAS" ,"1" ,"19.71" ,null ,"ABMag" ,"ATLAS20biht" ,"2020-12-12 12:38:53" ,"2020-12-20 18:55:12" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.71", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biht", `obsdate`="2020-12-12 12:38:53", `reportAddedDate`="2020-12-20 18:55:12", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhc" ,"30" ,"cyan-ATLAS" ,"0" ,"19.53" ,"0.183" ,"ABMag" ,"ATLAS20biis" ,"2020-12-14 14:15:22" ,"2020-12-20 18:53:45" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhc", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.53", `magErr`="0.183", `magUnit`="ABMag", `objectName`="ATLAS20biis", `obsdate`="2020-12-14 14:15:22", `reportAddedDate`="2020-12-20 18:53:45", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhc" ,"30" ,"cyan-ATLAS" ,"1" ,"19.55" ,null ,"ABMag" ,"ATLAS20biis" ,"2020-12-12 13:43:41" ,"2020-12-20 18:53:45" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhc", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.55", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biis", `obsdate`="2020-12-12 13:43:41", `reportAddedDate`="2020-12-20 18:53:45", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhb" ,"30" ,"cyan-ATLAS" ,"0" ,"19.33" ,"0.163" ,"ABMag" ,"ATLAS20bilc" ,"2020-12-14 14:38:24" ,"2020-12-20 18:53:19" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.33", `magErr`="0.163", `magUnit`="ABMag", `objectName`="ATLAS20bilc", `obsdate`="2020-12-14 14:38:24", `reportAddedDate`="2020-12-20 18:53:19", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adhb" ,"30" ,"cyan-ATLAS" ,"1" ,"19.33" ,null ,"ABMag" ,"ATLAS20bilc" ,"2020-12-12 15:31:41" ,"2020-12-20 18:53:19" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adhb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.33", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bilc", `obsdate`="2020-12-12 15:31:41", `reportAddedDate`="2020-12-20 18:53:19", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adha" ,"30" ,"cyan-ATLAS" ,"0" ,"19.341" ,"0.182" ,"ABMag" ,"ATLAS20bije" ,"2020-12-14 14:41:17" ,"2020-12-20 18:52:56" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adha", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.341", `magErr`="0.182", `magUnit`="ABMag", `objectName`="ATLAS20bije", `obsdate`="2020-12-14 14:41:17", `reportAddedDate`="2020-12-20 18:52:56", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adha" ,"30" ,"orange-ATLAS" ,"1" ,"19.13" ,null ,"ABMag" ,"ATLAS20bije" ,"2020-12-08 15:47:31" ,"2020-12-20 18:52:56" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adha", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.13", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bije", `obsdate`="2020-12-08 15:47:31", `reportAddedDate`="2020-12-20 18:52:56", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgz" ,"30" ,"cyan-ATLAS" ,"0" ,"19.764" ,"0.199" ,"ABMag" ,"ATLAS20bika" ,"2020-12-14 12:46:05" ,"2020-12-20 18:51:33" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.764", `magErr`="0.199", `magUnit`="ABMag", `objectName`="ATLAS20bika", `obsdate`="2020-12-14 12:46:05", `reportAddedDate`="2020-12-20 18:51:33", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgz" ,"30" ,"cyan-ATLAS" ,"1" ,"19.72" ,null ,"ABMag" ,"ATLAS20bika" ,"2020-12-12 14:41:17" ,"2020-12-20 18:51:33" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.72", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bika", `obsdate`="2020-12-12 14:41:17", `reportAddedDate`="2020-12-20 18:51:33", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgy" ,"30" ,"cyan-ATLAS" ,"0" ,"18.302" ,"0.088" ,"ABMag" ,"ATLAS20bigr" ,"2020-12-14 15:15:50" ,"2020-12-20 18:48:43" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgy", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.302", `magErr`="0.088", `magUnit`="ABMag", `objectName`="ATLAS20bigr", `obsdate`="2020-12-14 15:15:50", `reportAddedDate`="2020-12-20 18:48:43", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgy" ,"30" ,"cyan-ATLAS" ,"1" ,"17.78" ,null ,"ABMag" ,"ATLAS20bigr" ,"2020-12-12 15:51:50" ,"2020-12-20 18:48:43" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgy", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="17.78", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bigr", `obsdate`="2020-12-12 15:51:50", `reportAddedDate`="2020-12-20 18:48:43", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgx" ,"30" ,"cyan-ATLAS" ,"0" ,"19.7" ,"0.179" ,"ABMag" ,"ATLAS20bikd" ,"2020-12-14 12:24:29" ,"2020-12-20 18:48:12" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgx", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.7", `magErr`="0.179", `magUnit`="ABMag", `objectName`="ATLAS20bikd", `obsdate`="2020-12-14 12:24:29", `reportAddedDate`="2020-12-20 18:48:12", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgx" ,"30" ,"cyan-ATLAS" ,"1" ,"19.77" ,null ,"ABMag" ,"ATLAS20bikd" ,"2020-12-12 15:01:26" ,"2020-12-20 18:48:12" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgx", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.77", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bikd", `obsdate`="2020-12-12 15:01:26", `reportAddedDate`="2020-12-20 18:48:12", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgw" ,"30" ,"cyan-ATLAS" ,"0" ,"19.314" ,"0.181" ,"ABMag" ,"ATLAS20biks" ,"2020-12-14 14:21:07" ,"2020-12-20 18:47:44" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgw", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.314", `magErr`="0.181", `magUnit`="ABMag", `objectName`="ATLAS20biks", `obsdate`="2020-12-14 14:21:07", `reportAddedDate`="2020-12-20 18:47:44", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgw" ,"30" ,"cyan-ATLAS" ,"1" ,"19.23" ,null ,"ABMag" ,"ATLAS20biks" ,"2020-12-12 14:51:22" ,"2020-12-20 18:47:44" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgw", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.23", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biks", `obsdate`="2020-12-12 14:51:22", `reportAddedDate`="2020-12-20 18:47:44", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgv" ,"30" ,"cyan-ATLAS" ,"0" ,"19.311" ,"0.185" ,"ABMag" ,"ATLAS20bijg" ,"2020-12-14 10:16:19" ,"2020-12-20 18:46:59" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgv", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.311", `magErr`="0.185", `magUnit`="ABMag", `objectName`="ATLAS20bijg", `obsdate`="2020-12-14 10:16:19", `reportAddedDate`="2020-12-20 18:46:59", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgv" ,"30" ,"orange-ATLAS" ,"1" ,"19.14" ,null ,"ABMag" ,"ATLAS20bijg" ,"2020-12-08 09:11:31" ,"2020-12-20 18:46:59" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgv", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.14", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bijg", `obsdate`="2020-12-08 09:11:31", `reportAddedDate`="2020-12-20 18:46:59", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgu" ,"30" ,"cyan-ATLAS" ,"0" ,"19.636" ,"0.188" ,"ABMag" ,"ATLAS20bioi" ,"2020-12-17 07:55:12" ,"2020-12-20 18:44:53" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgu", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.636", `magErr`="0.188", `magUnit`="ABMag", `objectName`="ATLAS20bioi", `obsdate`="2020-12-17 07:55:12", `reportAddedDate`="2020-12-20 18:44:53", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgu" ,"30" ,"cyan-ATLAS" ,"1" ,"19.28" ,null ,"ABMag" ,"ATLAS20bioi" ,"2020-12-15 08:29:46" ,"2020-12-20 18:44:53" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgu", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.28", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bioi", `obsdate`="2020-12-15 08:29:46", `reportAddedDate`="2020-12-20 18:44:53", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgt" ,"30" ,"cyan-ATLAS" ,"0" ,"19.37" ,"0.179" ,"ABMag" ,"ATLAS20biop" ,"2020-12-17 11:24:00" ,"2020-12-20 18:42:04" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgt", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.37", `magErr`="0.179", `magUnit`="ABMag", `objectName`="ATLAS20biop", `obsdate`="2020-12-17 11:24:00", `reportAddedDate`="2020-12-20 18:42:04", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgt" ,"30" ,"cyan-ATLAS" ,"1" ,"19.56" ,null ,"ABMag" ,"ATLAS20biop" ,"2020-12-11 13:36:29" ,"2020-12-20 18:42:04" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgt", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.56", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biop", `obsdate`="2020-12-11 13:36:29", `reportAddedDate`="2020-12-20 18:42:04", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgs" ,"30" ,"cyan-ATLAS" ,"0" ,"19.407" ,"0.171" ,"ABMag" ,"ATLAS20bire" ,"2020-12-19 14:51:22" ,"2020-12-20 18:38:07" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgs", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.407", `magErr`="0.171", `magUnit`="ABMag", `objectName`="ATLAS20bire", `obsdate`="2020-12-19 14:51:22", `reportAddedDate`="2020-12-20 18:38:07", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgs" ,"30" ,"cyan-ATLAS" ,"1" ,"19.71" ,null ,"ABMag" ,"ATLAS20bire" ,"2020-12-17 12:36:00" ,"2020-12-20 18:38:07" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgs", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.71", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bire", `obsdate`="2020-12-17 12:36:00", `reportAddedDate`="2020-12-20 18:38:07", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgr" ,"45" ,"w-PS1" ,"0" ,"20.49" ,"0.04" ,"ABMag" ,"PS20mlr" ,"2020-12-15 06:11:31" ,"2020-12-20 18:30:41" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgr", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.49", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS20mlr", `obsdate`="2020-12-15 06:11:31", `reportAddedDate`="2020-12-20 18:30:41", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgq" ,"45" ,"w-PS1" ,"0" ,"20.36" ,"0.05" ,"ABMag" ,"PS20mlq" ,"2020-12-10 10:26:24" ,"2020-12-20 18:30:11" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgq", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.36", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS20mlq", `obsdate`="2020-12-10 10:26:24", `reportAddedDate`="2020-12-20 18:30:11", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgp" ,"30" ,"r-ZTF" ,"0" ,"19.4988" ,null ,"ABMag" ,"ZTF20acymtod" ,"2020-12-19 03:05:37" ,"2020-12-20 18:01:04" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4988", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymtod", `obsdate`="2020-12-19 03:05:37", `reportAddedDate`="2020-12-20 18:01:04", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgp" ,"30" ,"g-ZTF" ,"1" ,"19.611" ,null ,"ABMag" ,"ZTF20acymtod" ,"2020-12-16 04:34:20" ,"2020-12-20 18:01:04" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.611", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymtod", `obsdate`="2020-12-16 04:34:20", `reportAddedDate`="2020-12-20 18:01:04", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgo" ,"30" ,"g-ZTF" ,"0" ,"19.0261" ,null ,"ABMag" ,"ZTF20acymsyv" ,"2020-11-20 04:03:56" ,"2020-12-20 18:00:58" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.0261", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymsyv", `obsdate`="2020-11-20 04:03:56", `reportAddedDate`="2020-12-20 18:00:58", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgo" ,"30" ,"r-ZTF" ,"1" ,"20.5" ,null ,"ABMag" ,"ZTF20acymsyv" ,"2018-05-31 12:00:00" ,"2020-12-20 18:00:58" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymsyv", `obsdate`="2018-05-31 12:00:00", `reportAddedDate`="2020-12-20 18:00:58", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgn" ,"30" ,"g-ZTF" ,"0" ,"19.3039" ,null ,"ABMag" ,"ZTF20acyppyp" ,"2020-12-19 08:37:59" ,"2020-12-20 18:00:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.3039", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyppyp", `obsdate`="2020-12-19 08:37:59", `reportAddedDate`="2020-12-20 18:00:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgn" ,"30" ,"g-ZTF" ,"1" ,"20.4754" ,null ,"ABMag" ,"ZTF20acyppyp" ,"2020-12-16 10:06:23" ,"2020-12-20 18:00:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4754", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyppyp", `obsdate`="2020-12-16 10:06:23", `reportAddedDate`="2020-12-20 18:00:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgm" ,null ,"g-Sloan" ,"0" ,"17.4" ,null ,"ABMag" ,"ASASSN-20qc" ,"2020-12-20 06:28:48" ,"2020-12-20 17:51:39" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-3_Paczynski", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgm", `exptime`=null, `filter`="g-Sloan", `limitingMag`="0", `mag`="17.4", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20qc", `obsdate`="2020-12-20 06:28:48", `reportAddedDate`="2020-12-20 17:51:39", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-3_Paczynski" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgm" ,null ,"g-Sloan" ,"1" ,"18.3" ,null ,"ABMag" ,"ASASSN-20qc" ,"2020-12-13 03:07:12" ,"2020-12-20 17:51:39" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-3_Paczynski", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgm", `exptime`=null, `filter`="g-Sloan", `limitingMag`="1", `mag`="18.3", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20qc", `obsdate`="2020-12-13 03:07:12", `reportAddedDate`="2020-12-20 17:51:39", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-3_Paczynski" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgl" ,"30" ,"g-ZTF" ,"0" ,"20.2682" ,null ,"ABMag" ,"ZTF20acymcnb" ,"2020-11-20 11:57:58" ,"2020-12-20 17:00:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2682", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymcnb", `obsdate`="2020-11-20 11:57:58", `reportAddedDate`="2020-12-20 17:00:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgl" ,"30" ,"r-ZTF" ,"1" ,"20.5" ,null ,"ABMag" ,"ZTF20acymcnb" ,"2018-05-31 12:00:00" ,"2020-12-20 17:00:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymcnb", `obsdate`="2018-05-31 12:00:00", `reportAddedDate`="2020-12-20 17:00:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgk" ,"30" ,"cyan-ATLAS" ,"0" ,"17.152" ,"0.038" ,"ABMag" ,"ATLAS20bird" ,"2020-12-19 14:00:58" ,"2020-12-20 18:33:34" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgk", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="17.152", `magErr`="0.038", `magUnit`="ABMag", `objectName`="ATLAS20bird", `obsdate`="2020-12-19 14:00:58", `reportAddedDate`="2020-12-20 18:33:34", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgk" ,"30" ,"cyan-ATLAS" ,"1" ,"19.61" ,null ,"ABMag" ,"ATLAS20bird" ,"2020-12-17 13:39:22" ,"2020-12-20 18:33:34" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgk", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.61", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bird", `obsdate`="2020-12-17 13:39:22", `reportAddedDate`="2020-12-20 18:33:34", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgk" ,"30" ,"g-ZTF" ,"0" ,"16.31" ,null ,"ABMag" ,"ZTF20acypdlh" ,"2020-12-20 07:30:43" ,"2020-12-20 16:39:23" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="16.31", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acypdlh", `obsdate`="2020-12-20 07:30:43", `reportAddedDate`="2020-12-20 16:39:23", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgk" ,"30" ,"r-ZTF" ,"0" ,"18.13" ,null ,"ABMag" ,"ZTF20acypdlh" ,"2020-12-19 07:53:46" ,"2020-12-20 16:39:23" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.13", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acypdlh", `obsdate`="2020-12-19 07:53:46", `reportAddedDate`="2020-12-20 16:39:23", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgk" ,"30" ,"r-ZTF" ,"1" ,"19.39" ,null ,"ABMag" ,"ZTF20acypdlh" ,"2020-12-17 07:59:31" ,"2020-12-20 16:39:23" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.39", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acypdlh", `obsdate`="2020-12-17 07:59:31", `reportAddedDate`="2020-12-20 16:39:23", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgj" ,"30" ,"g-ZTF" ,"0" ,"18.93" ,null ,"ABMag" ,"ZTF20acxpvhu" ,"2020-12-20 07:52:19" ,"2020-12-20 16:39:14" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.93", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxpvhu", `obsdate`="2020-12-20 07:52:19", `reportAddedDate`="2020-12-20 16:39:14", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgj" ,"30" ,"r-ZTF" ,"0" ,"20.12" ,null ,"ABMag" ,"ZTF20acxpvhu" ,"2020-12-15 06:14:24" ,"2020-12-20 16:39:14" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.12", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxpvhu", `obsdate`="2020-12-15 06:14:24", `reportAddedDate`="2020-12-20 16:39:14", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgj" ,"30" ,"g-ZTF" ,"1" ,"20.02" ,null ,"ABMag" ,"ZTF20acxpvhu" ,"2020-12-13 08:23:59" ,"2020-12-20 16:39:14" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.02", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxpvhu", `obsdate`="2020-12-13 08:23:59", `reportAddedDate`="2020-12-20 16:39:14", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgi" ,"30" ,"g-ZTF" ,"0" ,"19.24" ,null ,"ABMag" ,"ZTF20acwmfpw" ,"2020-12-20 08:09:36" ,"2020-12-20 16:39:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.24", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwmfpw", `obsdate`="2020-12-20 08:09:36", `reportAddedDate`="2020-12-20 16:39:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgi" ,"30" ,"r-ZTF" ,"0" ,"20.38" ,null ,"ABMag" ,"ZTF20acwmfpw" ,"2020-12-10 07:26:24" ,"2020-12-20 16:39:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.38", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwmfpw", `obsdate`="2020-12-10 07:26:24", `reportAddedDate`="2020-12-20 16:39:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgi" ,"30" ,"g-ZTF" ,"1" ,"17.26" ,null ,"ABMag" ,"ZTF20acwmfpw" ,"2020-12-09 09:31:41" ,"2020-12-20 16:39:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="17.26", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwmfpw", `obsdate`="2020-12-09 09:31:41", `reportAddedDate`="2020-12-20 16:39:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgh" ,"30" ,"r-ZTF" ,"0" ,"18.65" ,null ,"ABMag" ,"ZTF20acywnjy" ,"2020-12-20 10:14:53" ,"2020-12-20 16:38:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.65", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acywnjy", `obsdate`="2020-12-20 10:14:53", `reportAddedDate`="2020-12-20 16:38:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgh" ,"30" ,"g-ZTF" ,"0" ,"19.35" ,null ,"ABMag" ,"ZTF20acywnjy" ,"2020-12-15 09:02:53" ,"2020-12-20 16:38:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgh", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.35", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acywnjy", `obsdate`="2020-12-15 09:02:53", `reportAddedDate`="2020-12-20 16:38:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgh" ,"30" ,"r-ZTF" ,"1" ,"18.33" ,null ,"ABMag" ,"ZTF20acywnjy" ,"2020-12-13 09:04:19" ,"2020-12-20 16:38:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.33", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acywnjy", `obsdate`="2020-12-13 09:04:19", `reportAddedDate`="2020-12-20 16:38:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgg" ,"30" ,"r-ZTF" ,"0" ,"19.2" ,null ,"ABMag" ,"ZTF20acnviht" ,"2020-12-20 10:17:46" ,"2020-12-20 16:38:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acnviht", `obsdate`="2020-12-20 10:17:46", `reportAddedDate`="2020-12-20 16:38:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgg" ,"30" ,"g-ZTF" ,"0" ,"20.2" ,null ,"ABMag" ,"ZTF20acnviht" ,"2020-10-15 10:56:38" ,"2020-12-20 16:38:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acnviht", `obsdate`="2020-10-15 10:56:38", `reportAddedDate`="2020-12-20 16:38:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgg" ,"30" ,"r-ZTF" ,"1" ,"20.33" ,null ,"ABMag" ,"ZTF20acnviht" ,"2020-10-13 12:07:12" ,"2020-12-20 16:38:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.33", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acnviht", `obsdate`="2020-10-13 12:07:12", `reportAddedDate`="2020-12-20 16:38:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgf" ,null ,"g-Sloan" ,"0" ,"18.1" ,null ,"ABMag" ,"ASASSN-20qb" ,"2020-12-18 19:40:48" ,"2020-12-20 15:44:46" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-5_Payne-Gaposchkin", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgf", `exptime`=null, `filter`="g-Sloan", `limitingMag`="0", `mag`="18.1", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20qb", `obsdate`="2020-12-18 19:40:48", `reportAddedDate`="2020-12-20 15:44:46", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-5_Payne-Gaposchkin" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgf" ,null ,"g-Sloan" ,"1" ,"18.1" ,null ,"ABMag" ,"ASASSN-20qb" ,"2020-12-15 18:43:12" ,"2020-12-20 15:44:46" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-5_Payne-Gaposchkin", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgf", `exptime`=null, `filter`="g-Sloan", `limitingMag`="1", `mag`="18.1", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20qb", `obsdate`="2020-12-15 18:43:12", `reportAddedDate`="2020-12-20 15:44:46", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-5_Payne-Gaposchkin" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adge" ,"30" ,"orange-ATLAS" ,"0" ,"18.734" ,"0.158" ,"ABMag" ,"ATLAS20biri" ,"2020-12-20 06:38:53" ,"2020-12-20 14:35:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adge", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.734", `magErr`="0.158", `magUnit`="ABMag", `objectName`="ATLAS20biri", `obsdate`="2020-12-20 06:38:53", `reportAddedDate`="2020-12-20 14:35:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adge" ,"30" ,"cyan-ATLAS" ,"1" ,"18.7" ,null ,"ABMag" ,"ATLAS20biri" ,"2020-12-14 06:57:36" ,"2020-12-20 14:35:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adge", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="18.7", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biri", `obsdate`="2020-12-14 06:57:36", `reportAddedDate`="2020-12-20 14:35:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgd" ,"30" ,"cyan-ATLAS" ,"0" ,"19.701" ,"0.183" ,"ABMag" ,"ATLAS20biom" ,"2020-12-17 11:51:22" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.701", `magErr`="0.183", `magUnit`="ABMag", `objectName`="ATLAS20biom", `obsdate`="2020-12-17 11:51:22", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgd" ,"30" ,"cyan-ATLAS" ,"1" ,"19.64" ,null ,"ABMag" ,"ATLAS20biom" ,"2020-12-11 12:30:14" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.64", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biom", `obsdate`="2020-12-11 12:30:14", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgc" ,"30" ,"orange-ATLAS" ,"0" ,"17.889" ,"0.056" ,"ABMag" ,"ATLAS20birg" ,"2020-12-20 07:36:29" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgc", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="17.889", `magErr`="0.056", `magUnit`="ABMag", `objectName`="ATLAS20birg", `obsdate`="2020-12-20 07:36:29", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgc" ,"30" ,"orange-ATLAS" ,"1" ,"15" ,null ,"ABMag" ,"ATLAS20birg" ,"2020-12-16 09:02:53" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgc", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="15", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20birg", `obsdate`="2020-12-16 09:02:53", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgb" ,"30" ,"cyan-ATLAS" ,"0" ,"19.378" ,"0.144" ,"ABMag" ,"ATLAS20biow" ,"2020-12-17 14:31:12" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.378", `magErr`="0.144", `magUnit`="ABMag", `objectName`="ATLAS20biow", `obsdate`="2020-12-17 14:31:12", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adgb" ,"30" ,"cyan-ATLAS" ,"1" ,"19.63" ,null ,"ABMag" ,"ATLAS20biow" ,"2020-12-11 14:52:48" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adgb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.63", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biow", `obsdate`="2020-12-11 14:52:48", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adga" ,"30" ,"cyan-ATLAS" ,"0" ,"19.497" ,"0.17" ,"ABMag" ,"ATLAS20bioy" ,"2020-12-17 12:18:43" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adga", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.497", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ATLAS20bioy", `obsdate`="2020-12-17 12:18:43", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adga" ,"30" ,"cyan-ATLAS" ,"1" ,"19.77" ,null ,"ABMag" ,"ATLAS20bioy" ,"2020-12-11 13:12:00" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adga", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.77", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bioy", `obsdate`="2020-12-11 13:12:00", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfz" ,"30" ,"cyan-ATLAS" ,"0" ,"19.458" ,"0.156" ,"ABMag" ,"ATLAS20biqb" ,"2020-12-17 09:46:05" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.458", `magErr`="0.156", `magUnit`="ABMag", `objectName`="ATLAS20biqb", `obsdate`="2020-12-17 09:46:05", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfz" ,"30" ,"cyan-ATLAS" ,"1" ,"18.85" ,null ,"ABMag" ,"ATLAS20biqb" ,"2020-12-15 10:46:34" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="18.85", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biqb", `obsdate`="2020-12-15 10:46:34", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfy" ,"30" ,"cyan-ATLAS" ,"0" ,"19.474" ,"0.184" ,"ABMag" ,"ATLAS20bioh" ,"2020-12-17 12:18:43" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfy", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.474", `magErr`="0.184", `magUnit`="ABMag", `objectName`="ATLAS20bioh", `obsdate`="2020-12-17 12:18:43", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfy" ,"30" ,"cyan-ATLAS" ,"1" ,"19.79" ,null ,"ABMag" ,"ATLAS20bioh" ,"2020-12-11 11:29:46" ,"2020-12-20 14:32:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfy", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.79", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bioh", `obsdate`="2020-12-11 11:29:46", `reportAddedDate`="2020-12-20 14:32:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfx" ,"45" ,"w-PS1" ,"0" ,"21.98" ,"0.3" ,"ABMag" ,"PS20mll" ,"2020-11-16 06:59:02" ,"2020-12-20 14:29:37" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfx", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.98", `magErr`="0.3", `magUnit`="ABMag", `objectName`="PS20mll", `obsdate`="2020-11-16 06:59:02", `reportAddedDate`="2020-12-20 14:29:37", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfw" ,"45" ,"w-PS1" ,"0" ,"20.98" ,"0.09" ,"ABMag" ,"PS20mlk" ,"2020-12-06 05:25:26" ,"2020-12-20 14:27:52" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfw", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.98", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20mlk", `obsdate`="2020-12-06 05:25:26", `reportAddedDate`="2020-12-20 14:27:52", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfv" ,"30" ,"r-ZTF" ,"0" ,"19.82" ,"0.26" ,"ABMag" ,"ZTF20acyxzzf" ,"2020-12-17 13:09:01" ,"2020-12-20 14:19:41" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.82", `magErr`="0.26", `magUnit`="ABMag", `objectName`="ZTF20acyxzzf", `obsdate`="2020-12-17 13:09:01", `reportAddedDate`="2020-12-20 14:19:41", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfv" ,"30" ,"g-ZTF" ,"0" ,"20.23" ,"0.22" ,"ABMag" ,"ZTF20acyxzzf" ,"2020-12-15 13:10:10" ,"2020-12-20 14:19:41" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.23", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acyxzzf", `obsdate`="2020-12-15 13:10:10", `reportAddedDate`="2020-12-20 14:19:41", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfv" ,"30" ,"g-ZTF" ,"1" ,"19.8855" ,null ,"ABMag" ,"ZTF20acyxzzf" ,"2020-12-12 13:04:50" ,"2020-12-20 14:19:41" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8855", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyxzzf", `obsdate`="2020-12-12 13:04:50", `reportAddedDate`="2020-12-20 14:19:41", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfu" ,"30" ,"r-ZTF" ,"0" ,"19.53" ,"0.21" ,"ABMag" ,"ZTF20acxtdtv" ,"2020-12-17 13:11:03" ,"2020-12-20 14:19:41" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.53", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF20acxtdtv", `obsdate`="2020-12-17 13:11:03", `reportAddedDate`="2020-12-20 14:19:41", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfu" ,"30" ,"g-ZTF" ,"0" ,"19.38" ,"0.17" ,"ABMag" ,"ZTF20acxtdtv" ,"2020-12-15 12:57:41" ,"2020-12-20 14:19:41" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.38", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxtdtv", `obsdate`="2020-12-15 12:57:41", `reportAddedDate`="2020-12-20 14:19:41", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfu" ,"30" ,"r-ZTF" ,"1" ,"19.8056" ,null ,"ABMag" ,"ZTF20acxtdtv" ,"2020-12-06 13:32:01" ,"2020-12-20 14:19:41" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8056", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxtdtv", `obsdate`="2020-12-06 13:32:01", `reportAddedDate`="2020-12-20 14:19:41", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adft" ,"30" ,"g-ZTF" ,"0" ,"19.45" ,"0.18" ,"ABMag" ,"ZTF18acycwvv" ,"2020-12-20 13:11:33" ,"2020-12-20 14:19:08" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adft", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.45", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF18acycwvv", `obsdate`="2020-12-20 13:11:33", `reportAddedDate`="2020-12-20 14:19:08", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adft" ,"30" ,"r-ZTF" ,"0" ,"19.27" ,"0.18" ,"ABMag" ,"ZTF18acycwvv" ,"2020-12-20 12:21:42" ,"2020-12-20 14:19:08" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adft", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.27", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF18acycwvv", `obsdate`="2020-12-20 12:21:42", `reportAddedDate`="2020-12-20 14:19:08", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adft" ,"30" ,"r-ZTF" ,"1" ,"20.0126" ,null ,"ABMag" ,"ZTF18acycwvv" ,"2020-12-17 13:10:23" ,"2020-12-20 14:19:08" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adft", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0126", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18acycwvv", `obsdate`="2020-12-17 13:10:23", `reportAddedDate`="2020-12-20 14:19:08", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfs" ,"30" ,"g-ZTF" ,"0" ,"19.78" ,"0.19" ,"ABMag" ,"ZTF18acuehzf" ,"2020-12-20 13:12:54" ,"2020-12-20 14:19:08" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfs", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.78", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF18acuehzf", `obsdate`="2020-12-20 13:12:54", `reportAddedDate`="2020-12-20 14:19:08", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfs" ,"30" ,"r-ZTF" ,"0" ,"19.34" ,"0.22" ,"ABMag" ,"ZTF18acuehzf" ,"2020-12-20 12:23:04" ,"2020-12-20 14:19:08" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfs", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.34", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF18acuehzf", `obsdate`="2020-12-20 12:23:04", `reportAddedDate`="2020-12-20 14:19:08", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfs" ,"30" ,"r-ZTF" ,"1" ,"19.6345" ,null ,"ABMag" ,"ZTF18acuehzf" ,"2020-12-16 13:34:44" ,"2020-12-20 14:19:08" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfs", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6345", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18acuehzf", `obsdate`="2020-12-16 13:34:44", `reportAddedDate`="2020-12-20 14:19:08", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfr" ,"30" ,"r-ZTF" ,"0" ,"19.44" ,"0.21" ,"ABMag" ,"ZTF20acyyaiq" ,"2020-12-20 12:26:26" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.44", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF20acyyaiq", `obsdate`="2020-12-20 12:26:26", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfr" ,"30" ,"g-ZTF" ,"0" ,"20.01" ,"0.28" ,"ABMag" ,"ZTF20acyyaiq" ,"2020-12-15 13:03:10" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfr", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.01", `magErr`="0.28", `magUnit`="ABMag", `objectName`="ZTF20acyyaiq", `obsdate`="2020-12-15 13:03:10", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfr" ,"30" ,"r-ZTF" ,"1" ,"19.6615" ,null ,"ABMag" ,"ZTF20acyyaiq" ,"2020-12-09 13:17:34" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6615", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyyaiq", `obsdate`="2020-12-09 13:17:34", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfq" ,"30" ,"r-ZTF" ,"0" ,"19.47" ,"0.19" ,"ABMag" ,"ZTF20acymcuj" ,"2020-12-20 12:01:40" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.47", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acymcuj", `obsdate`="2020-12-20 12:01:40", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfq" ,"30" ,"g-ZTF" ,"0" ,"20.18" ,"0.3" ,"ABMag" ,"ZTF20acymcuj" ,"2020-12-15 12:34:30" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.18", `magErr`="0.3", `magUnit`="ABMag", `objectName`="ZTF20acymcuj", `obsdate`="2020-12-15 12:34:30", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfq" ,"30" ,"g-ZTF" ,"1" ,"19.9099" ,null ,"ABMag" ,"ZTF20acymcuj" ,"2020-12-12 12:38:22" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.9099", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymcuj", `obsdate`="2020-12-12 12:38:22", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfp" ,"30" ,"r-ZTF" ,"0" ,"19.39" ,"0.17" ,"ABMag" ,"ZTF20acykoxy" ,"2020-12-17 13:11:03" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.39", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acykoxy", `obsdate`="2020-12-17 13:11:03", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfp" ,"30" ,"g-ZTF" ,"0" ,"19.91" ,"0.3" ,"ABMag" ,"ZTF20acykoxy" ,"2020-12-15 12:57:41" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.91", `magErr`="0.3", `magUnit`="ABMag", `objectName`="ZTF20acykoxy", `obsdate`="2020-12-15 12:57:41", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfp" ,"30" ,"r-ZTF" ,"1" ,"19.7839" ,null ,"ABMag" ,"ZTF20acykoxy" ,"2020-12-06 13:32:01" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7839", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acykoxy", `obsdate`="2020-12-06 13:32:01", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfo" ,"30" ,"g-ZTF" ,"0" ,"19.5" ,"0.26" ,"ABMag" ,"ZTF20acxtdcl" ,"2020-12-17 10:46:26" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.5", `magErr`="0.26", `magUnit`="ABMag", `objectName`="ZTF20acxtdcl", `obsdate`="2020-12-17 10:46:26", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfo" ,"30" ,"g-ZTF" ,"0" ,"19.6" ,"0.15" ,"ABMag" ,"ZTF20acxtdcl" ,"2020-12-15 12:38:38" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acxtdcl", `obsdate`="2020-12-15 12:38:38", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfo" ,"30" ,"g-ZTF" ,"1" ,"20.1227" ,null ,"ABMag" ,"ZTF20acxtdcl" ,"2020-12-12 12:41:45" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.1227", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxtdcl", `obsdate`="2020-12-12 12:41:45", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfn" ,"30" ,"g-ZTF" ,"0" ,"19.46" ,"0.37" ,"ABMag" ,"ZTF20acxsnpk" ,"2020-12-17 10:38:50" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.46", `magErr`="0.37", `magUnit`="ABMag", `objectName`="ZTF20acxsnpk", `obsdate`="2020-12-17 10:38:50", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfn" ,"30" ,"g-ZTF" ,"0" ,"19.57" ,"0.15" ,"ABMag" ,"ZTF20acxsnpk" ,"2020-12-15 12:34:30" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.57", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acxsnpk", `obsdate`="2020-12-15 12:34:30", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfn" ,"30" ,"g-ZTF" ,"1" ,"19.9099" ,null ,"ABMag" ,"ZTF20acxsnpk" ,"2020-12-12 12:38:22" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.9099", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxsnpk", `obsdate`="2020-12-12 12:38:22", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfm" ,"30" ,"cyan-ATLAS" ,"0" ,"19.759" ,"0.186" ,"ABMag" ,"ATLAS20biiz" ,"2020-12-14 14:05:17" ,"2020-12-20 18:58:29" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.759", `magErr`="0.186", `magUnit`="ABMag", `objectName`="ATLAS20biiz", `obsdate`="2020-12-14 14:05:17", `reportAddedDate`="2020-12-20 18:58:29", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfm" ,"30" ,"cyan-ATLAS" ,"1" ,"19.73" ,null ,"ABMag" ,"ATLAS20biiz" ,"2020-12-12 15:21:36" ,"2020-12-20 18:58:29" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.73", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biiz", `obsdate`="2020-12-12 15:21:36", `reportAddedDate`="2020-12-20 18:58:29", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfm" ,"30" ,"r-ZTF" ,"0" ,"19.32" ,"0.13" ,"ABMag" ,"ZTF20acliffw" ,"2020-12-20 11:54:39" ,"2020-12-20 13:00:11" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.32", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acliffw", `obsdate`="2020-12-20 11:54:39", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfm" ,"30" ,"r-ZTF" ,"0" ,"19.45" ,"0.22" ,"ABMag" ,"ZTF20acliffw" ,"2020-12-17 12:22:18" ,"2020-12-20 13:00:11" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.45", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acliffw", `obsdate`="2020-12-17 12:22:18", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfm" ,"30" ,"g-ZTF" ,"1" ,"19.7166" ,null ,"ABMag" ,"ZTF20acliffw" ,"2020-12-17 11:15:28" ,"2020-12-20 13:00:11" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7166", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acliffw", `obsdate`="2020-12-17 11:15:28", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfl" ,"30" ,"r-ZTF" ,"0" ,"20.06" ,"0.2" ,"ABMag" ,"ZTF20acwxwcd" ,"2020-12-11 11:34:56" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.06", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acwxwcd", `obsdate`="2020-12-11 11:34:56", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfl" ,"30" ,"g-ZTF" ,"0" ,"20.33" ,"0.31" ,"ABMag" ,"ZTF20acwxwcd" ,"2020-12-11 10:39:06" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.33", `magErr`="0.31", `magUnit`="ABMag", `objectName`="ZTF20acwxwcd", `obsdate`="2020-12-11 10:39:06", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfl" ,"30" ,"g-ZTF" ,"1" ,"19.6163" ,null ,"ABMag" ,"ZTF20acwxwcd" ,"2020-12-02 12:25:15" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.6163", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwxwcd", `obsdate`="2020-12-02 12:25:15", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfk" ,"60" ,"G-Gaia" ,"0" ,"18.76" ,"0.2" ,"ABMag" ,"Gaia20fur" ,"2020-12-19 04:43:41" ,"2020-12-20 11:57:44" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfk", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.76", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fur", `obsdate`="2020-12-19 04:43:41", `reportAddedDate`="2020-12-20 11:57:44", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfk" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fur" ,"2020-07-29 16:58:05" ,"2020-12-20 11:57:44" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfk", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fur", `obsdate`="2020-07-29 16:58:05", `reportAddedDate`="2020-12-20 11:57:44", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfj" ,"30" ,"g-ZTF" ,"0" ,"17.81" ,null ,"ABMag" ,"ZTF20acyqzeu" ,"2020-12-20 08:44:10" ,"2020-12-20 10:38:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="17.81", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyqzeu", `obsdate`="2020-12-20 08:44:10", `reportAddedDate`="2020-12-20 10:38:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfj" ,"30" ,"g-ZTF" ,"0" ,"17.81" ,null ,"ABMag" ,"ZTF20acyqzeu" ,"2020-12-20 08:44:10" ,"2020-12-20 10:38:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="17.81", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyqzeu", `obsdate`="2020-12-20 08:44:10", `reportAddedDate`="2020-12-20 10:38:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfj" ,"30" ,"g-ZTF" ,"1" ,"19.21" ,null ,"ABMag" ,"ZTF20acyqzeu" ,"2020-12-17 09:46:05" ,"2020-12-20 10:38:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.21", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyqzeu", `obsdate`="2020-12-17 09:46:05", `reportAddedDate`="2020-12-20 10:38:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfi" ,"45" ,"w-PS1" ,"0" ,"21.67" ,"0.21" ,"ABMag" ,"PS20mli" ,"2020-12-06 08:21:07" ,"2020-12-20 10:24:57" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfi", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.67", `magErr`="0.21", `magUnit`="ABMag", `objectName`="PS20mli", `obsdate`="2020-12-06 08:21:07", `reportAddedDate`="2020-12-20 10:24:57", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfh" ,"30" ,"g-ZTF" ,"0" ,"20.02" ,"0.14" ,"ABMag" ,"ZTF20acwylnq" ,"2020-12-11 12:48:18" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfh", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.02", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acwylnq", `obsdate`="2020-12-11 12:48:18", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfh" ,"30" ,"r-ZTF" ,"0" ,"20.36" ,"0.2" ,"ABMag" ,"ZTF20acwylnq" ,"2020-12-11 12:25:13" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.36", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acwylnq", `obsdate`="2020-12-11 12:25:13", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfh" ,"30" ,"g-ZTF" ,"1" ,"19.8957" ,null ,"ABMag" ,"ZTF20acwylnq" ,"2020-12-05 12:58:25" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfh", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8957", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwylnq", `obsdate`="2020-12-05 12:58:25", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfg" ,"30" ,"g-ZTF" ,"0" ,"20.22" ,"0.23" ,"ABMag" ,"ZTF20acxglpx" ,"2020-12-17 04:37:42" ,"2020-12-20 07:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.22", `magErr`="0.23", `magUnit`="ABMag", `objectName`="ZTF20acxglpx", `obsdate`="2020-12-17 04:37:42", `reportAddedDate`="2020-12-20 07:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfg" ,"30" ,"g-ZTF" ,"0" ,"20.03" ,"0.15" ,"ABMag" ,"ZTF20acxglpx" ,"2020-12-15 07:47:33" ,"2020-12-20 07:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.03", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acxglpx", `obsdate`="2020-12-15 07:47:33", `reportAddedDate`="2020-12-20 07:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfg" ,"30" ,"r-ZTF" ,"1" ,"19.7091" ,null ,"ABMag" ,"ZTF20acxglpx" ,"2020-12-15 05:42:16" ,"2020-12-20 07:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7091", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxglpx", `obsdate`="2020-12-15 05:42:16", `reportAddedDate`="2020-12-20 07:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adff" ,"30" ,"g-ZTF" ,"0" ,"20.22" ,"0.19" ,"ABMag" ,"ZTF20acwjrim" ,"2020-12-11 07:44:25" ,"2020-12-20 05:58:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adff", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.22", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acwjrim", `obsdate`="2020-12-11 07:44:25", `reportAddedDate`="2020-12-20 05:58:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adff" ,"30" ,"r-ZTF" ,"0" ,"19.95" ,"0.15" ,"ABMag" ,"ZTF20acwjrim" ,"2020-12-11 07:17:45" ,"2020-12-20 05:58:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adff", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.95", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acwjrim", `obsdate`="2020-12-11 07:17:45", `reportAddedDate`="2020-12-20 05:58:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adff" ,"30" ,"g-ZTF" ,"1" ,"19.8333" ,null ,"ABMag" ,"ZTF20acwjrim" ,"2020-12-09 07:04:46" ,"2020-12-20 05:58:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adff", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8333", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwjrim", `obsdate`="2020-12-09 07:04:46", `reportAddedDate`="2020-12-20 05:58:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfe" ,"30" ,"g-ZTF" ,"0" ,"18.01" ,"0.05" ,"ABMag" ,"ZTF20acxncha" ,"2020-12-21 05:12:02" ,"2020-12-21 06:19:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfe", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.01", `magErr`="0.05", `magUnit`="ABMag", `objectName`="ZTF20acxncha", `obsdate`="2020-12-21 05:12:02", `reportAddedDate`="2020-12-21 06:19:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfe" ,"30" ,"r-ZTF" ,"0" ,"18.16" ,"0.06" ,"ABMag" ,"ZTF20acxncha" ,"2020-12-21 04:57:30" ,"2020-12-21 06:19:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfe", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.16", `magErr`="0.06", `magUnit`="ABMag", `objectName`="ZTF20acxncha", `obsdate`="2020-12-21 04:57:30", `reportAddedDate`="2020-12-21 06:19:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfe" ,"30" ,"r-ZTF" ,"1" ,"19.9115" ,null ,"ABMag" ,"ZTF20acxncha" ,"2020-12-21 03:35:46" ,"2020-12-21 06:19:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfe", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.9115", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxncha", `obsdate`="2020-12-21 03:35:46", `reportAddedDate`="2020-12-21 06:19:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfe" ,"30" ,"g-ZTF" ,"0" ,"99" ,null ,"ABMag" ,"ZTF20acxncha" ,"2020-12-19 04:45:07" ,"2020-12-20 04:37:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfe", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="99", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxncha", `obsdate`="2020-12-19 04:45:07", `reportAddedDate`="2020-12-20 04:37:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfe" ,"30" ,"r-ZTF" ,"0" ,"19.82" ,null ,"ABMag" ,"ZTF20acxncha" ,"2020-12-16 03:07:12" ,"2020-12-20 04:37:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfe", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.82", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxncha", `obsdate`="2020-12-16 03:07:12", `reportAddedDate`="2020-12-20 04:37:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfe" ,"30" ,"r-ZTF" ,"1" ,"19.41" ,null ,"ABMag" ,"ZTF20acxncha" ,"2020-12-14 04:53:46" ,"2020-12-20 04:37:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfe", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.41", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxncha", `obsdate`="2020-12-14 04:53:46", `reportAddedDate`="2020-12-20 04:37:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfd" ,"180" ,"Clear-" ,"0" ,"17.1" ,null ,"VegaMag" ,"MASTER OT J071942.54-431553.9" ,"2020-12-17 06:05:12" ,"2020-12-19 21:14:39" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfd", `exptime`="180", `filter`="Clear-", `limitingMag`="0", `mag`="17.1", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J071942.54-431553.9", `obsdate`="2020-12-17 06:05:12", `reportAddedDate`="2020-12-19 21:14:39", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfd" ,"180" ,"Clear-" ,"0" ,"17.3" ,null ,"VegaMag" ,"MASTER OT J071942.54-431553.9" ,"2020-12-17 05:55:12" ,"2020-12-19 21:14:39" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfd", `exptime`="180", `filter`="Clear-", `limitingMag`="0", `mag`="17.3", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J071942.54-431553.9", `obsdate`="2020-12-17 05:55:12", `reportAddedDate`="2020-12-19 21:14:39", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfd" ,"180" ,"Clear-" ,"1" ,"19.5" ,null ,"VegaMag" ,"MASTER OT J071942.54-431553.9" ,"2018-02-21 02:03:56" ,"2020-12-19 21:14:39" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfd", `exptime`="180", `filter`="Clear-", `limitingMag`="1", `mag`="19.5", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J071942.54-431553.9", `obsdate`="2018-02-21 02:03:56", `reportAddedDate`="2020-12-19 21:14:39", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfc" ,"60" ,"Clear-" ,"0" ,"11.9" ,null ,"VegaMag" ,"MASTER OT J060948.76+260110.3" ,"2020-12-19 05:08:40" ,"2020-12-19 21:10:41" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfc", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="11.9", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J060948.76+260110.3", `obsdate`="2020-12-19 05:08:40", `reportAddedDate`="2020-12-19 21:10:41", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfc" ,"60" ,"Clear-" ,"0" ,"11.9" ,null ,"VegaMag" ,"MASTER OT J060948.76+260110.3" ,"2020-12-19 05:03:22" ,"2020-12-19 21:10:41" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfc", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="11.9", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J060948.76+260110.3", `obsdate`="2020-12-19 05:03:22", `reportAddedDate`="2020-12-19 21:10:41", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfc" ,"180" ,"Clear-" ,"1" ,"18.7" ,null ,"VegaMag" ,"MASTER OT J060948.76+260110.3" ,"2018-11-29 03:55:33" ,"2020-12-19 21:10:41" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfc", `exptime`="180", `filter`="Clear-", `limitingMag`="1", `mag`="18.7", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J060948.76+260110.3", `obsdate`="2018-11-29 03:55:33", `reportAddedDate`="2020-12-19 21:10:41", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfb" ,"30" ,"g-ZTF" ,"0" ,"19.7616" ,"0.185495" ,"ABMag" ,"ZTF20acyntiu" ,"2020-12-19 05:29:01" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7616", `magErr`="0.185495", `magUnit`="ABMag", `objectName`="ZTF20acyntiu", `obsdate`="2020-12-19 05:29:01", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfb" ,"30" ,"g-ZTF" ,"1" ,"20.1966" ,null ,"ABMag" ,"ZTF20acyntiu" ,"2020-12-16 06:38:28" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.1966", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyntiu", `obsdate`="2020-12-16 06:38:28", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfa" ,"30" ,"r-ZTF" ,"0" ,"19.4256" ,"0.174184" ,"ABMag" ,"ZTF20acyrupb" ,"2020-12-19 13:10:20" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfa", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4256", `magErr`="0.174184", `magUnit`="ABMag", `objectName`="ZTF20acyrupb", `obsdate`="2020-12-19 13:10:20", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adfa" ,"30" ,"g-ZTF" ,"1" ,"19.8955" ,null ,"ABMag" ,"ZTF20acyrupb" ,"2020-12-19 12:08:33" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adfa", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8955", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyrupb", `obsdate`="2020-12-19 12:08:33", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adez" ,"30" ,"r-ZTF" ,"0" ,"19.9794" ,"0.189609" ,"ABMag" ,"ZTF20acypagb" ,"2020-12-19 07:47:40" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adez", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9794", `magErr`="0.189609", `magUnit`="ABMag", `objectName`="ZTF20acypagb", `obsdate`="2020-12-19 07:47:40", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adez" ,"30" ,"g-ZTF" ,"1" ,"20.3459" ,null ,"ABMag" ,"ZTF20acypagb" ,"2020-12-16 08:14:17" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adez", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3459", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acypagb", `obsdate`="2020-12-16 08:14:17", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adey" ,"30" ,"r-ZTF" ,"0" ,"19.382" ,"0.14376" ,"ABMag" ,"ZTF20acyroek" ,"2020-12-19 12:47:34" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adey", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.382", `magErr`="0.14376", `magUnit`="ABMag", `objectName`="ZTF20acyroek", `obsdate`="2020-12-19 12:47:34", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adey" ,"30" ,"g-ZTF" ,"0" ,"19.4806" ,"0.189213" ,"ABMag" ,"ZTF20acyroek" ,"2020-12-19 12:10:34" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adey", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4806", `magErr`="0.189213", `magUnit`="ABMag", `objectName`="ZTF20acyroek", `obsdate`="2020-12-19 12:10:34", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adex" ,"30" ,"r-ZTF" ,"0" ,"19.052" ,"0.122225" ,"ABMag" ,"ZTF20acyrody" ,"2020-12-19 12:47:34" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adex", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.052", `magErr`="0.122225", `magUnit`="ABMag", `objectName`="ZTF20acyrody", `obsdate`="2020-12-19 12:47:34", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adex" ,"30" ,"g-ZTF" ,"0" ,"18.9701" ,"0.125455" ,"ABMag" ,"ZTF20acyrody" ,"2020-12-19 12:10:34" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adex", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.9701", `magErr`="0.125455", `magUnit`="ABMag", `objectName`="ZTF20acyrody", `obsdate`="2020-12-19 12:10:34", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adew" ,"30" ,"g-ZTF" ,"0" ,"19.8144" ,"0.155716" ,"ABMag" ,"ZTF20acyqnim" ,"2020-12-19 11:57:35" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adew", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8144", `magErr`="0.155716", `magUnit`="ABMag", `objectName`="ZTF20acyqnim", `obsdate`="2020-12-19 11:57:35", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adew" ,"30" ,"r-ZTF" ,"0" ,"19.9508" ,"0.184088" ,"ABMag" ,"ZTF20acyqnim" ,"2020-12-19 09:52:50" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adew", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9508", `magErr`="0.184088", `magUnit`="ABMag", `objectName`="ZTF20acyqnim", `obsdate`="2020-12-19 09:52:50", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adew" ,"30" ,"g-ZTF" ,"1" ,"20.673" ,null ,"ABMag" ,"ZTF20acyqnim" ,"2020-12-16 10:28:14" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adew", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.673", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyqnim", `obsdate`="2020-12-16 10:28:14", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adev" ,"30" ,"r-ZTF" ,"0" ,"18.8716" ,"0.128999" ,"ABMag" ,"ZTF20acyrodz" ,"2020-12-19 13:11:43" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adev", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.8716", `magErr`="0.128999", `magUnit`="ABMag", `objectName`="ZTF20acyrodz", `obsdate`="2020-12-19 13:11:43", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adev" ,"30" ,"g-ZTF" ,"0" ,"18.7486" ,"0.137113" ,"ABMag" ,"ZTF20acyrodz" ,"2020-12-19 12:07:52" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adev", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.7486", `magErr`="0.137113", `magUnit`="ABMag", `objectName`="ZTF20acyrodz", `obsdate`="2020-12-19 12:07:52", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeu" ,"30" ,"r-ZTF" ,"0" ,"20.0012" ,"0.19144" ,"ABMag" ,"ZTF20acyrhbo" ,"2020-12-19 12:36:38" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0012", `magErr`="0.19144", `magUnit`="ABMag", `objectName`="ZTF20acyrhbo", `obsdate`="2020-12-19 12:36:38", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeu" ,"30" ,"g-ZTF" ,"0" ,"19.9268" ,"0.180076" ,"ABMag" ,"ZTF20acyrhbo" ,"2020-12-19 11:36:28" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.9268", `magErr`="0.180076", `magUnit`="ABMag", `objectName`="ZTF20acyrhbo", `obsdate`="2020-12-19 11:36:28", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeu" ,"30" ,"g-ZTF" ,"1" ,"20.4591" ,null ,"ABMag" ,"ZTF20acyrhbo" ,"2020-12-16 12:41:39" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4591", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyrhbo", `obsdate`="2020-12-16 12:41:39", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adet" ,"30" ,"r-ZTF" ,"0" ,"19.7946" ,"0.161038" ,"ABMag" ,"ZTF20acyrsry" ,"2020-12-19 12:57:16" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adet", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7946", `magErr`="0.161038", `magUnit`="ABMag", `objectName`="ZTF20acyrsry", `obsdate`="2020-12-19 12:57:16", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adet" ,"30" ,"g-ZTF" ,"0" ,"20.3201" ,"0.269306" ,"ABMag" ,"ZTF20acyrsry" ,"2020-12-19 12:03:03" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adet", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.3201", `magErr`="0.269306", `magUnit`="ABMag", `objectName`="ZTF20acyrsry", `obsdate`="2020-12-19 12:03:03", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adet" ,"30" ,"g-ZTF" ,"1" ,"20.3423" ,null ,"ABMag" ,"ZTF20acyrsry" ,"2020-12-16 12:59:00" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adet", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3423", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyrsry", `obsdate`="2020-12-16 12:59:00", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ades" ,"30" ,"g-ZTF" ,"0" ,"20.3631" ,"0.203725" ,"ABMag" ,"ZTF20acymbxe" ,"2020-12-18 11:40:33" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ades", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.3631", `magErr`="0.203725", `magUnit`="ABMag", `objectName`="ZTF20acymbxe", `obsdate`="2020-12-18 11:40:33", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ades" ,"30" ,"r-ZTF" ,"1" ,"20.3373" ,null ,"ABMag" ,"ZTF20acymbxe" ,"2020-12-18 11:27:06" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ades", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.3373", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymbxe", `obsdate`="2020-12-18 11:27:06", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ader" ,"30" ,"r-ZTF" ,"0" ,"19.8208" ,"0.165387" ,"ABMag" ,"ZTF20acydasr" ,"2020-12-19 02:40:30" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ader", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8208", `magErr`="0.165387", `magUnit`="ABMag", `objectName`="ZTF20acydasr", `obsdate`="2020-12-19 02:40:30", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ader" ,"30" ,"r-ZTF" ,"0" ,"20.205" ,"0.263777" ,"ABMag" ,"ZTF20acydasr" ,"2020-12-16 02:35:22" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ader", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.205", `magErr`="0.263777", `magUnit`="ABMag", `objectName`="ZTF20acydasr", `obsdate`="2020-12-16 02:35:22", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ader" ,"30" ,"r-ZTF" ,"1" ,"18.468" ,null ,"ABMag" ,"ZTF20acydasr" ,"2020-12-14 04:37:50" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ader", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.468", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acydasr", `obsdate`="2020-12-14 04:37:50", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeq" ,"30" ,"g-ZTF" ,"0" ,"18.83" ,"0.12" ,"ABMag" ,"ZTF20acynllu" ,"2020-12-19 04:38:02" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.83", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acynllu", `obsdate`="2020-12-19 04:38:02", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeq" ,"30" ,"g-ZTF" ,"0" ,"20.02" ,"0.31" ,"ABMag" ,"ZTF20acynllu" ,"2020-12-16 04:33:39" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.02", `magErr`="0.31", `magUnit`="ABMag", `objectName`="ZTF20acynllu", `obsdate`="2020-12-16 04:33:39", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeq" ,"30" ,"r-ZTF" ,"1" ,"20.1105" ,null ,"ABMag" ,"ZTF20acynllu" ,"2020-12-12 04:42:44" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1105", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynllu", `obsdate`="2020-12-12 04:42:44", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeq" ,"30" ,"orange-ATLAS" ,"0" ,"18.937" ,"0.137" ,"ABMag" ,"ATLAS20biro" ,"2020-12-20 06:43:12" ,"2020-12-20 19:21:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeq", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.937", `magErr`="0.137", `magUnit`="ABMag", `objectName`="ATLAS20biro", `obsdate`="2020-12-20 06:43:12", `reportAddedDate`="2020-12-20 19:21:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeq" ,"30" ,"cyan-ATLAS" ,"1" ,"19.64" ,null ,"ABMag" ,"ATLAS20biro" ,"2020-12-15 07:14:53" ,"2020-12-20 19:21:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeq", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.64", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biro", `obsdate`="2020-12-15 07:14:53", `reportAddedDate`="2020-12-20 19:21:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeq" ,"30" ,"g-ZTF" ,"0" ,"18.8306" ,"0.118445" ,"ABMag" ,"ZTF20acynllu" ,"2020-12-19 04:38:02" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.8306", `magErr`="0.118445", `magUnit`="ABMag", `objectName`="ZTF20acynllu", `obsdate`="2020-12-19 04:38:02", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeq" ,"30" ,"g-ZTF" ,"0" ,"20.0231" ,"0.313026" ,"ABMag" ,"ZTF20acynllu" ,"2020-12-16 04:33:39" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0231", `magErr`="0.313026", `magUnit`="ABMag", `objectName`="ZTF20acynllu", `obsdate`="2020-12-16 04:33:39", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeq" ,"30" ,"r-ZTF" ,"1" ,"19.4859" ,null ,"ABMag" ,"ZTF20acynllu" ,"2020-12-16 03:30:34" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.4859", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynllu", `obsdate`="2020-12-16 03:30:34", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adep" ,"30" ,"g-ZTF" ,"0" ,"19.8836" ,"0.2055" ,"ABMag" ,"ZTF20acymxip" ,"2020-12-19 04:25:35" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adep", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8836", `magErr`="0.2055", `magUnit`="ABMag", `objectName`="ZTF20acymxip", `obsdate`="2020-12-19 04:25:35", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adep" ,"30" ,"r-ZTF" ,"0" ,"19.9236" ,"0.151972" ,"ABMag" ,"ZTF20acymxip" ,"2020-12-19 03:11:44" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adep", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9236", `magErr`="0.151972", `magUnit`="ABMag", `objectName`="ZTF20acymxip", `obsdate`="2020-12-19 03:11:44", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adep" ,"30" ,"g-ZTF" ,"0" ,"20.1901" ,"0.246756" ,"ABMag" ,"ZTF20acymxip" ,"2020-12-16 04:10:06" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adep", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1901", `magErr`="0.246756", `magUnit`="ABMag", `objectName`="ZTF20acymxip", `obsdate`="2020-12-16 04:10:06", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adep" ,"30" ,"r-ZTF" ,"1" ,"19.7929" ,null ,"ABMag" ,"ZTF20acymxip" ,"2020-12-16 03:18:17" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adep", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7929", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymxip", `obsdate`="2020-12-16 03:18:17", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeo" ,"30" ,"g-ZTF" ,"0" ,"19.7631" ,"0.155797" ,"ABMag" ,"ZTF20acynqpx" ,"2020-12-19 05:24:57" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7631", `magErr`="0.155797", `magUnit`="ABMag", `objectName`="ZTF20acynqpx", `obsdate`="2020-12-19 05:24:57", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeo" ,"30" ,"g-ZTF" ,"0" ,"20.199" ,"0.278897" ,"ABMag" ,"ZTF20acynqpx" ,"2020-12-16 06:52:20" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.199", `magErr`="0.278897", `magUnit`="ABMag", `objectName`="ZTF20acynqpx", `obsdate`="2020-12-16 06:52:20", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeo" ,"30" ,"r-ZTF" ,"0" ,"20.3341" ,"0.233527" ,"ABMag" ,"ZTF20acynqpx" ,"2020-12-16 05:16:13" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.3341", `magErr`="0.233527", `magUnit`="ABMag", `objectName`="ZTF20acynqpx", `obsdate`="2020-12-16 05:16:13", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeo" ,"30" ,"r-ZTF" ,"1" ,"19.3874" ,null ,"ABMag" ,"ZTF20acynqpx" ,"2020-12-14 05:24:43" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.3874", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynqpx", `obsdate`="2020-12-14 05:24:43", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aden" ,"30" ,"r-ZTF" ,"0" ,"18.52" ,"0.1" ,"ABMag" ,"ZTF20acynlkj" ,"2020-12-21 04:59:43" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aden", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.52", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acynlkj", `obsdate`="2020-12-21 04:59:43", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aden" ,"30" ,"g-ZTF" ,"0" ,"18.67" ,"0.1" ,"ABMag" ,"ZTF20acynlkj" ,"2020-12-19 04:38:02" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aden", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.67", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acynlkj", `obsdate`="2020-12-19 04:38:02", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aden" ,"30" ,"r-ZTF" ,"1" ,"20.2716" ,null ,"ABMag" ,"ZTF20acynlkj" ,"2020-12-12 04:42:44" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aden", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.2716", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynlkj", `obsdate`="2020-12-12 04:42:44", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aden" ,"30" ,"g-ZTF" ,"0" ,"18.674" ,"0.0951534" ,"ABMag" ,"ZTF20acynlkj" ,"2020-12-19 04:38:02" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aden", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.674", `magErr`="0.0951534", `magUnit`="ABMag", `objectName`="ZTF20acynlkj", `obsdate`="2020-12-19 04:38:02", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aden" ,"30" ,"g-ZTF" ,"0" ,"19.8772" ,"0.269866" ,"ABMag" ,"ZTF20acynlkj" ,"2020-12-16 04:33:39" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aden", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8772", `magErr`="0.269866", `magUnit`="ABMag", `objectName`="ZTF20acynlkj", `obsdate`="2020-12-16 04:33:39", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aden" ,"30" ,"r-ZTF" ,"0" ,"19.6701" ,"0.234316" ,"ABMag" ,"ZTF20acynlkj" ,"2020-12-16 03:30:34" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aden", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.6701", `magErr`="0.234316", `magUnit`="ABMag", `objectName`="ZTF20acynlkj", `obsdate`="2020-12-16 03:30:34", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aden" ,"30" ,"r-ZTF" ,"1" ,"17.5158" ,null ,"ABMag" ,"ZTF20acynlkj" ,"2020-12-14 04:33:04" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aden", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="17.5158", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynlkj", `obsdate`="2020-12-14 04:33:04", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adem" ,"30" ,"g-ZTF" ,"0" ,"19.76" ,"0.17" ,"ABMag" ,"ZTF20acxxwun" ,"2020-12-19 11:44:39" ,"2020-12-21 10:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adem", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.76", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxxwun", `obsdate`="2020-12-19 11:44:39", `reportAddedDate`="2020-12-21 10:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adem" ,"30" ,"r-ZTF" ,"0" ,"19.86" ,"0.17" ,"ABMag" ,"ZTF20acxxwun" ,"2020-12-19 09:40:58" ,"2020-12-21 10:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adem", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.86", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxxwun", `obsdate`="2020-12-19 09:40:58", `reportAddedDate`="2020-12-21 10:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adem" ,"30" ,"g-ZTF" ,"1" ,"20.5925" ,null ,"ABMag" ,"ZTF20acxxwun" ,"2020-12-16 10:20:03" ,"2020-12-21 10:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adem", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.5925", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxxwun", `obsdate`="2020-12-16 10:20:03", `reportAddedDate`="2020-12-21 10:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adem" ,"30" ,"g-ZTF" ,"0" ,"19.7567" ,"0.165627" ,"ABMag" ,"ZTF20acxxwun" ,"2020-12-19 11:44:39" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adem", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7567", `magErr`="0.165627", `magUnit`="ABMag", `objectName`="ZTF20acxxwun", `obsdate`="2020-12-19 11:44:39", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adem" ,"30" ,"r-ZTF" ,"0" ,"19.8611" ,"0.168439" ,"ABMag" ,"ZTF20acxxwun" ,"2020-12-19 09:40:58" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adem", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8611", `magErr`="0.168439", `magUnit`="ABMag", `objectName`="ZTF20acxxwun", `obsdate`="2020-12-19 09:40:58", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adem" ,"30" ,"r-ZTF" ,"0" ,"20.3559" ,"0.214873" ,"ABMag" ,"ZTF20acxxwun" ,"2020-12-16 09:27:06" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adem", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.3559", `magErr`="0.214873", `magUnit`="ABMag", `objectName`="ZTF20acxxwun", `obsdate`="2020-12-16 09:27:06", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adem" ,"30" ,"r-ZTF" ,"1" ,"20.0964" ,null ,"ABMag" ,"ZTF20acxxwun" ,"2020-12-13 11:20:49" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adem", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0964", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxxwun", `obsdate`="2020-12-13 11:20:49", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adel" ,"30" ,"r-ZTF" ,"0" ,"19.8508" ,"0.171712" ,"ABMag" ,"ZTF20acyoltw" ,"2020-12-19 09:09:51" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adel", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8508", `magErr`="0.171712", `magUnit`="ABMag", `objectName`="ZTF20acyoltw", `obsdate`="2020-12-19 09:09:51", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adel" ,"30" ,"g-ZTF" ,"0" ,"20.0429" ,"0.24421" ,"ABMag" ,"ZTF20acyoltw" ,"2020-12-19 08:42:12" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adel", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0429", `magErr`="0.24421", `magUnit`="ABMag", `objectName`="ZTF20acyoltw", `obsdate`="2020-12-19 08:42:12", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adel" ,"30" ,"g-ZTF" ,"0" ,"19.8747" ,"0.261253" ,"ABMag" ,"ZTF20acyoltw" ,"2020-12-19 08:12:08" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adel", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8747", `magErr`="0.261253", `magUnit`="ABMag", `objectName`="ZTF20acyoltw", `obsdate`="2020-12-19 08:12:08", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adel" ,"30" ,"r-ZTF" ,"0" ,"19.8452" ,"0.223361" ,"ABMag" ,"ZTF20acyoltw" ,"2020-12-19 07:49:01" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adel", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8452", `magErr`="0.223361", `magUnit`="ABMag", `objectName`="ZTF20acyoltw", `obsdate`="2020-12-19 07:49:01", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adel" ,"30" ,"g-ZTF" ,"0" ,"20.5077" ,"0.282715" ,"ABMag" ,"ZTF20acyoltw" ,"2020-12-16 08:17:01" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adel", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.5077", `magErr`="0.282715", `magUnit`="ABMag", `objectName`="ZTF20acyoltw", `obsdate`="2020-12-16 08:17:01", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adel" ,"30" ,"r-ZTF" ,"1" ,"19.7534" ,null ,"ABMag" ,"ZTF20acyoltw" ,"2020-12-16 07:21:04" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adel", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7534", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyoltw", `obsdate`="2020-12-16 07:21:04", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adek" ,"30" ,"g-ZTF" ,"0" ,"19.8644" ,"0.21395" ,"ABMag" ,"ZTF20acyqlyg" ,"2020-12-19 11:48:01" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adek", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8644", `magErr`="0.21395", `magUnit`="ABMag", `objectName`="ZTF20acyqlyg", `obsdate`="2020-12-19 11:48:01", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adek" ,"30" ,"r-ZTF" ,"0" ,"19.8218" ,"0.177604" ,"ABMag" ,"ZTF20acyqlyg" ,"2020-12-19 09:43:00" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adek", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8218", `magErr`="0.177604", `magUnit`="ABMag", `objectName`="ZTF20acyqlyg", `obsdate`="2020-12-19 09:43:00", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adek" ,"30" ,"g-ZTF" ,"0" ,"20.4416" ,"0.302873" ,"ABMag" ,"ZTF20acyqlyg" ,"2020-12-16 10:23:25" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adek", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.4416", `magErr`="0.302873", `magUnit`="ABMag", `objectName`="ZTF20acyqlyg", `obsdate`="2020-12-16 10:23:25", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adek" ,"30" ,"r-ZTF" ,"0" ,"20.0847" ,"0.253176" ,"ABMag" ,"ZTF20acyqlyg" ,"2020-12-16 09:17:31" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adek", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0847", `magErr`="0.253176", `magUnit`="ABMag", `objectName`="ZTF20acyqlyg", `obsdate`="2020-12-16 09:17:31", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adek" ,"30" ,"g-ZTF" ,"0" ,"20.6508" ,"0.242828" ,"ABMag" ,"ZTF20acyqlyg" ,"2020-12-15 09:20:56" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adek", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.6508", `magErr`="0.242828", `magUnit`="ABMag", `objectName`="ZTF20acyqlyg", `obsdate`="2020-12-15 09:20:56", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adek" ,"30" ,"r-ZTF" ,"1" ,"19.7054" ,null ,"ABMag" ,"ZTF20acyqlyg" ,"2020-12-13 11:56:58" ,"2020-12-19 19:24:55" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adek", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7054", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyqlyg", `obsdate`="2020-12-13 11:56:58", `reportAddedDate`="2020-12-19 19:24:55", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adej" ,"45" ,"i-Sloan" ,"0" ,"20.96" ,"0.18" ,"ABMag" ,"PS20mlh" ,"2020-12-07 11:44:10" ,"2020-12-19 19:12:51" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adej", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.96", `magErr`="0.18", `magUnit`="ABMag", `objectName`="PS20mlh", `obsdate`="2020-12-07 11:44:10", `reportAddedDate`="2020-12-19 19:12:51", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adei" ,"45" ,"w-PS1" ,"0" ,"20.58" ,"0.07" ,"ABMag" ,"PS20mlg" ,"2020-12-07 07:03:22" ,"2020-12-19 19:12:32" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adei", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.58", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS20mlg", `obsdate`="2020-12-07 07:03:22", `reportAddedDate`="2020-12-19 19:12:32", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeh" ,"45" ,"w-PS1" ,"0" ,"22.14" ,"0.22" ,"ABMag" ,"PS20mlf" ,"2020-12-08 08:48:29" ,"2020-12-19 19:11:54" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeh", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="22.14", `magErr`="0.22", `magUnit`="ABMag", `objectName`="PS20mlf", `obsdate`="2020-12-08 08:48:29", `reportAddedDate`="2020-12-19 19:11:54", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeg" ,"45" ,"w-PS1" ,"0" ,"20.59" ,"0.07" ,"ABMag" ,"PS20mle" ,"2020-12-07 08:00:58" ,"2020-12-19 19:11:09" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeg", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.59", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS20mle", `obsdate`="2020-12-07 08:00:58", `reportAddedDate`="2020-12-19 19:11:09", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adef" ,"45" ,"w-PS1" ,"0" ,"21.72" ,"0.13" ,"ABMag" ,"PS20mld" ,"2020-12-06 06:48:58" ,"2020-12-19 19:10:50" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adef", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.72", `magErr`="0.13", `magUnit`="ABMag", `objectName`="PS20mld", `obsdate`="2020-12-06 06:48:58", `reportAddedDate`="2020-12-19 19:10:50", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adee" ,"45" ,"w-PS1" ,"0" ,"20.83" ,"0.05" ,"ABMag" ,"PS20mlc" ,"2020-12-06 07:56:38" ,"2020-12-19 19:10:35" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adee", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.83", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS20mlc", `obsdate`="2020-12-06 07:56:38", `reportAddedDate`="2020-12-19 19:10:35", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aded" ,"45" ,"i-Sloan" ,"0" ,"20.55" ,"0.11" ,"ABMag" ,"PS20mlb" ,"2020-12-07 11:47:02" ,"2020-12-19 19:10:17" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aded", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.55", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20mlb", `obsdate`="2020-12-07 11:47:02", `reportAddedDate`="2020-12-19 19:10:17", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adec" ,"45" ,"w-PS1" ,"0" ,"20.48" ,"0.04" ,"ABMag" ,"PS20mkz" ,"2020-12-07 07:04:48" ,"2020-12-19 19:09:23" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adec", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.48", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS20mkz", `obsdate`="2020-12-07 07:04:48", `reportAddedDate`="2020-12-19 19:09:23", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adeb" ,"45" ,"w-PS1" ,"0" ,"21.68" ,"0.14" ,"ABMag" ,"PS20mky" ,"2020-12-07 05:45:36" ,"2020-12-19 19:08:55" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adeb", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.68", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS20mky", `obsdate`="2020-12-07 05:45:36", `reportAddedDate`="2020-12-19 19:08:55", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adea" ,"45" ,"w-PS1" ,"0" ,"20.98" ,"0.12" ,"ABMag" ,"PS20mkw" ,"2020-12-12 05:00:58" ,"2020-12-19 19:07:20" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adea", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.98", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS20mkw", `obsdate`="2020-12-12 05:00:58", `reportAddedDate`="2020-12-19 19:07:20", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addz" ,"45" ,"w-PS1" ,"0" ,"21.03" ,"0.12" ,"ABMag" ,"PS20mkv" ,"2020-12-12 05:08:10" ,"2020-12-19 19:07:03" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.03", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS20mkv", `obsdate`="2020-12-12 05:08:10", `reportAddedDate`="2020-12-19 19:07:03", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addy" ,"45" ,"w-PS1" ,"0" ,"21.17" ,"0.19" ,"ABMag" ,"PS20mku" ,"2020-12-12 14:35:31" ,"2020-12-19 19:06:47" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addy", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.17", `magErr`="0.19", `magUnit`="ABMag", `objectName`="PS20mku", `obsdate`="2020-12-12 14:35:31", `reportAddedDate`="2020-12-19 19:06:47", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addx" ,"45" ,"w-PS1" ,"0" ,"21.39" ,"0.11" ,"ABMag" ,"PS20mkt" ,"2020-12-07 08:16:47" ,"2020-12-19 19:05:44" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addx", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.39", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20mkt", `obsdate`="2020-12-07 08:16:47", `reportAddedDate`="2020-12-19 19:05:44", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addw" ,"45" ,"w-PS1" ,"0" ,"21.58" ,"0.29" ,"ABMag" ,"PS20mks" ,"2020-12-06 06:34:34" ,"2020-12-19 19:05:01" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addw", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.58", `magErr`="0.29", `magUnit`="ABMag", `objectName`="PS20mks", `obsdate`="2020-12-06 06:34:34", `reportAddedDate`="2020-12-19 19:05:01", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addv" ,"45" ,"w-PS1" ,"0" ,"21.54" ,"0.21" ,"ABMag" ,"PS20mkq" ,"2020-12-06 06:27:22" ,"2020-12-19 19:04:21" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addv", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.54", `magErr`="0.21", `magUnit`="ABMag", `objectName`="PS20mkq", `obsdate`="2020-12-06 06:27:22", `reportAddedDate`="2020-12-19 19:04:21", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addu" ,"45" ,"w-PS1" ,"0" ,"20.9" ,"0.13" ,"ABMag" ,"PS20mkp" ,"2020-12-12 07:33:36" ,"2020-12-19 19:04:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addu", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.9", `magErr`="0.13", `magUnit`="ABMag", `objectName`="PS20mkp", `obsdate`="2020-12-12 07:33:36", `reportAddedDate`="2020-12-19 19:04:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addt" ,"45" ,"w-PS1" ,"0" ,"21.01" ,"0.09" ,"ABMag" ,"PS20mko" ,"2020-12-10 07:55:12" ,"2020-12-19 19:03:42" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addt", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.01", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20mko", `obsdate`="2020-12-10 07:55:12", `reportAddedDate`="2020-12-19 19:03:42", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adds" ,"45" ,"w-PS1" ,"0" ,"21.58" ,"0.12" ,"ABMag" ,"PS20mkk" ,"2020-12-07 05:24:00" ,"2020-12-19 19:01:18" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adds", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.58", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS20mkk", `obsdate`="2020-12-07 05:24:00", `reportAddedDate`="2020-12-19 19:01:18", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addr" ,"30" ,"g-ZTF" ,"0" ,"19.7628" ,null ,"ABMag" ,"ZTF20acyjafq" ,"2020-11-17 10:51:19" ,"2020-12-19 19:01:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addr", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7628", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyjafq", `obsdate`="2020-11-17 10:51:19", `reportAddedDate`="2020-12-19 19:01:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addr" ,"30" ,"r-ZTF" ,"1" ,"20.5" ,null ,"ABMag" ,"ZTF20acyjafq" ,"2018-05-31 12:00:00" ,"2020-12-19 19:01:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyjafq", `obsdate`="2018-05-31 12:00:00", `reportAddedDate`="2020-12-19 19:01:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addq" ,"30" ,"r-ZTF" ,"0" ,"20.462" ,null ,"ABMag" ,"ZTF20acydtwu" ,"2020-12-12 05:10:27" ,"2020-12-19 19:01:06" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.462", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acydtwu", `obsdate`="2020-12-12 05:10:27", `reportAddedDate`="2020-12-19 19:01:06", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addq" ,"30" ,"g-ZTF" ,"1" ,"20.886" ,null ,"ABMag" ,"ZTF20acydtwu" ,"2020-12-12 04:09:00" ,"2020-12-19 19:01:06" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.886", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acydtwu", `obsdate`="2020-12-12 04:09:00", `reportAddedDate`="2020-12-19 19:01:06", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addp" ,"30" ,"g-ZTF" ,"0" ,"19.8115" ,null ,"ABMag" ,"ZTF20acycunv" ,"2020-12-16 04:35:01" ,"2020-12-19 19:00:58" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8115", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acycunv", `obsdate`="2020-12-16 04:35:01", `reportAddedDate`="2020-12-19 19:00:58", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addp" ,"30" ,"r-ZTF" ,"1" ,"19.5442" ,null ,"ABMag" ,"ZTF20acycunv" ,"2020-12-16 03:03:01" ,"2020-12-19 19:00:58" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5442", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acycunv", `obsdate`="2020-12-16 03:03:01", `reportAddedDate`="2020-12-19 19:00:58", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addo" ,"45" ,"w-PS1" ,"0" ,"20.51" ,"0.04" ,"ABMag" ,"PS20mkj" ,"2020-12-06 05:31:12" ,"2020-12-19 19:00:53" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addo", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.51", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS20mkj", `obsdate`="2020-12-06 05:31:12", `reportAddedDate`="2020-12-19 19:00:53", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addn" ,"45" ,"w-PS1" ,"0" ,"20.23" ,"0.05" ,"ABMag" ,"PS20mki" ,"2020-12-06 05:34:05" ,"2020-12-19 19:00:36" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addn", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.23", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS20mki", `obsdate`="2020-12-06 05:34:05", `reportAddedDate`="2020-12-19 19:00:36", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addm" ,"45" ,"w-PS1" ,"0" ,"21.6" ,"0.14" ,"ABMag" ,"PS20mkh" ,"2020-12-06 05:51:22" ,"2020-12-19 18:57:52" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addm", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.6", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS20mkh", `obsdate`="2020-12-06 05:51:22", `reportAddedDate`="2020-12-19 18:57:52", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addl" ,"45" ,"w-PS1" ,"0" ,"20.39" ,"0.03" ,"ABMag" ,"PS20mkg" ,"2020-12-07 05:26:53" ,"2020-12-19 18:56:37" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addl", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.39", `magErr`="0.03", `magUnit`="ABMag", `objectName`="PS20mkg", `obsdate`="2020-12-07 05:26:53", `reportAddedDate`="2020-12-19 18:56:37", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addk" ,"45" ,"w-PS1" ,"0" ,"21.52" ,"0.17" ,"ABMag" ,"PS20mkf" ,"2020-12-06 06:40:19" ,"2020-12-19 18:56:10" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addk", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.52", `magErr`="0.17", `magUnit`="ABMag", `objectName`="PS20mkf", `obsdate`="2020-12-06 06:40:19", `reportAddedDate`="2020-12-19 18:56:10", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addj" ,"45" ,"w-PS1" ,"0" ,"21.2" ,"0.09" ,"ABMag" ,"PS20mkc" ,"2020-12-07 08:05:17" ,"2020-12-19 18:54:12" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addj", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.2", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20mkc", `obsdate`="2020-12-07 08:05:17", `reportAddedDate`="2020-12-19 18:54:12", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addi" ,"45" ,"w-PS1" ,"0" ,"20.74" ,"0.09" ,"ABMag" ,"PS20mkb" ,"2020-12-12 07:30:43" ,"2020-12-19 18:51:23" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addi", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.74", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20mkb", `obsdate`="2020-12-12 07:30:43", `reportAddedDate`="2020-12-19 18:51:23", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addh" ,"45" ,"w-PS1" ,"0" ,"21.93" ,"0.2" ,"ABMag" ,"PS20mka" ,"2020-12-07 07:13:26" ,"2020-12-19 18:50:48" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addh", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.93", `magErr`="0.2", `magUnit`="ABMag", `objectName`="PS20mka", `obsdate`="2020-12-07 07:13:26", `reportAddedDate`="2020-12-19 18:50:48", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addg" ,"45" ,"w-PS1" ,"0" ,"21.48" ,"0.18" ,"ABMag" ,"PS20mjz" ,"2020-12-12 09:04:19" ,"2020-12-19 18:50:34" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addg", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.48", `magErr`="0.18", `magUnit`="ABMag", `objectName`="PS20mjz", `obsdate`="2020-12-12 09:04:19", `reportAddedDate`="2020-12-19 18:50:34", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addf" ,"45" ,"w-PS1" ,"0" ,"20.79" ,"0.14" ,"ABMag" ,"PS20mjx" ,"2020-12-12 14:31:12" ,"2020-12-19 18:50:05" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addf", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.79", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS20mjx", `obsdate`="2020-12-12 14:31:12", `reportAddedDate`="2020-12-19 18:50:05", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adde" ,"45" ,"w-PS1" ,"0" ,"20.98" ,"0.09" ,"ABMag" ,"PS20mjw" ,"2020-12-06 05:28:19" ,"2020-12-19 18:49:02" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adde", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.98", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20mjw", `obsdate`="2020-12-06 05:28:19", `reportAddedDate`="2020-12-19 18:49:02", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addd" ,"45" ,"w-PS1" ,"0" ,"21.58" ,"0.21" ,"ABMag" ,"PS20mju" ,"2020-12-08 06:05:46" ,"2020-12-19 18:42:34" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addd", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.58", `magErr`="0.21", `magUnit`="ABMag", `objectName`="PS20mju", `obsdate`="2020-12-08 06:05:46", `reportAddedDate`="2020-12-19 18:42:34", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addc" ,"45" ,"w-PS1" ,"0" ,"21.51" ,"0.09" ,"ABMag" ,"PS20mjt" ,"2020-12-07 08:15:22" ,"2020-12-19 18:42:17" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addc", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.51", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20mjt", `obsdate`="2020-12-07 08:15:22", `reportAddedDate`="2020-12-19 18:42:17", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addb" ,"30" ,"g-ZTF" ,"0" ,"19.955" ,null ,"ABMag" ,"ZTF20acvkvfj" ,"2020-12-06 12:18:54" ,"2020-12-19 17:00:52" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.955", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvkvfj", `obsdate`="2020-12-06 12:18:54", `reportAddedDate`="2020-12-19 17:00:52", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020addb" ,"30" ,"r-ZTF" ,"1" ,"19.7623" ,null ,"ABMag" ,"ZTF20acvkvfj" ,"2020-12-06 11:27:35" ,"2020-12-19 17:00:52" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020addb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7623", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvkvfj", `obsdate`="2020-12-06 11:27:35", `reportAddedDate`="2020-12-19 17:00:52", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adda" ,"45" ,"w-PS1" ,"0" ,"20.69" ,"0.06" ,"ABMag" ,"PS20mjs" ,"2020-12-10 10:26:24" ,"2020-12-19 14:24:04" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adda", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.69", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20mjs", `obsdate`="2020-12-10 10:26:24", `reportAddedDate`="2020-12-19 14:24:04", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcz" ,"45" ,"w-PS1" ,"0" ,"20.82" ,"0.15" ,"ABMag" ,"PS20mjr" ,"2020-12-06 06:30:14" ,"2020-12-19 14:23:06" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.82", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20mjr", `obsdate`="2020-12-06 06:30:14", `reportAddedDate`="2020-12-19 14:23:06", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcy" ,"60" ,"G-Gaia" ,"0" ,"18.89" ,"0.2" ,"ABMag" ,"Gaia20fuq" ,"2020-12-18 13:24:58" ,"2020-12-19 14:17:54" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcy", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.89", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fuq", `obsdate`="2020-12-18 13:24:58", `reportAddedDate`="2020-12-19 14:17:54", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcy" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fuq" ,"2020-09-13 09:05:46" ,"2020-12-19 14:17:54" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcy", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fuq", `obsdate`="2020-09-13 09:05:46", `reportAddedDate`="2020-12-19 14:17:54", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcx" ,"60" ,"G-Gaia" ,"0" ,"14.06" ,"0.2" ,"ABMag" ,"Gaia20fup" ,"2020-12-18 02:36:58" ,"2020-12-19 14:17:02" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcx", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="14.06", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fup", `obsdate`="2020-12-18 02:36:58", `reportAddedDate`="2020-12-19 14:17:02", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcx" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fup" ,"2020-04-30 23:24:00" ,"2020-12-19 14:17:02" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcx", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fup", `obsdate`="2020-04-30 23:24:00", `reportAddedDate`="2020-12-19 14:17:02", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcw" ,"60" ,"G-Gaia" ,"0" ,"15.96" ,"0.2" ,"ABMag" ,"Gaia20fuo" ,"2020-12-17 20:42:43" ,"2020-12-19 14:16:24" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcw", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="15.96", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fuo", `obsdate`="2020-12-17 20:42:43", `reportAddedDate`="2020-12-19 14:16:24", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcw" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fuo" ,"2020-11-19 04:43:41" ,"2020-12-19 14:16:24" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcw", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fuo", `obsdate`="2020-11-19 04:43:41", `reportAddedDate`="2020-12-19 14:16:24", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcv" ,"60" ,"G-Gaia" ,"0" ,"17.61" ,"0.2" ,"ABMag" ,"Gaia20fum" ,"2020-12-17 20:26:53" ,"2020-12-19 14:15:02" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcv", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.61", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fum", `obsdate`="2020-12-17 20:26:53", `reportAddedDate`="2020-12-19 14:15:02", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcv" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fum" ,"2020-11-14 22:49:26" ,"2020-12-19 14:15:02" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcv", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fum", `obsdate`="2020-11-14 22:49:26", `reportAddedDate`="2020-12-19 14:15:02", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcu" ,"60" ,"G-Gaia" ,"0" ,"17.97" ,"0.2" ,"ABMag" ,"Gaia20fui" ,"2020-12-18 14:55:41" ,"2020-12-19 14:12:22" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcu", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.97", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fui", `obsdate`="2020-12-18 14:55:41", `reportAddedDate`="2020-12-19 14:12:22", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcu" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fui" ,"2020-11-22 16:43:41" ,"2020-12-19 14:12:22" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcu", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fui", `obsdate`="2020-11-22 16:43:41", `reportAddedDate`="2020-12-19 14:12:22", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adct" ,"60" ,"G-Gaia" ,"0" ,"15.82" ,"0.2" ,"ABMag" ,"Gaia20fuh" ,"2020-11-21 22:40:48" ,"2020-12-19 14:11:15" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adct", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="15.82", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fuh", `obsdate`="2020-11-21 22:40:48", `reportAddedDate`="2020-12-19 14:11:15", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adct" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fuh" ,"2020-10-20 05:05:17" ,"2020-12-19 14:11:15" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adct", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fuh", `obsdate`="2020-10-20 05:05:17", `reportAddedDate`="2020-12-19 14:11:15", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcs" ,"60" ,"G-Gaia" ,"0" ,"18.51" ,"0.2" ,"ABMag" ,"Gaia20fug" ,"2020-12-18 04:20:38" ,"2020-12-19 14:10:19" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcs", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.51", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fug", `obsdate`="2020-12-18 04:20:38", `reportAddedDate`="2020-12-19 14:10:19", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcs" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fug" ,"2018-12-17 22:22:05" ,"2020-12-19 14:10:19" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcs", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fug", `obsdate`="2018-12-17 22:22:05", `reportAddedDate`="2020-12-19 14:10:19", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcr" ,"30" ,"r-ZTF" ,"0" ,"15.37" ,"0.03" ,"ABMag" ,"ZTF18acvjwtz" ,"2020-12-13 13:24:02" ,"2020-12-19 13:58:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="15.37", `magErr`="0.03", `magUnit`="ABMag", `objectName`="ZTF18acvjwtz", `obsdate`="2020-12-13 13:24:02", `reportAddedDate`="2020-12-19 13:58:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcr" ,"30" ,"r-ZTF" ,"0" ,"15.98" ,"0.04" ,"ABMag" ,"ZTF18acvjwtz" ,"2020-12-10 13:15:10" ,"2020-12-19 13:58:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="15.98", `magErr`="0.04", `magUnit`="ABMag", `objectName`="ZTF18acvjwtz", `obsdate`="2020-12-10 13:15:10", `reportAddedDate`="2020-12-19 13:58:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcq" ,"30" ,"r-ZTF" ,"0" ,"15.99" ,"0.03" ,"ABMag" ,"ZTF18acvjpck" ,"2020-12-10 13:21:16" ,"2020-12-19 13:58:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="15.99", `magErr`="0.03", `magUnit`="ABMag", `objectName`="ZTF18acvjpck", `obsdate`="2020-12-10 13:21:16", `reportAddedDate`="2020-12-19 13:58:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcq" ,"30" ,"r-ZTF" ,"0" ,"15.69" ,"0.02" ,"ABMag" ,"ZTF18acvjpck" ,"2020-12-10 13:14:30" ,"2020-12-19 13:58:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="15.69", `magErr`="0.02", `magUnit`="ABMag", `objectName`="ZTF18acvjpck", `obsdate`="2020-12-10 13:14:30", `reportAddedDate`="2020-12-19 13:58:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcp" ,"30" ,"g-ZTF" ,"0" ,"19.3" ,"0.13" ,"ABMag" ,"ZTF20acynaba" ,"2020-12-19 04:42:53" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.3", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acynaba", `obsdate`="2020-12-19 04:42:53", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcp" ,"30" ,"r-ZTF" ,"0" ,"19.41" ,"0.11" ,"ABMag" ,"ZTF20acynaba" ,"2020-12-19 03:28:37" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.41", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acynaba", `obsdate`="2020-12-19 03:28:37", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcp" ,"30" ,"r-ZTF" ,"1" ,"19.6222" ,null ,"ABMag" ,"ZTF20acynaba" ,"2020-12-16 03:24:23" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6222", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynaba", `obsdate`="2020-12-16 03:24:23", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcp" ,"30" ,"g-ZTF" ,"0" ,"20.337" ,"0.222" ,"ABMag" ,"ZTF20acynaba" ,"2020-12-16 04:53:37" ,"2020-12-19 13:46:37" ,"SGLF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.337", `magErr`="0.222", `magUnit`="ABMag", `objectName`="ZTF20acynaba", `obsdate`="2020-12-16 04:53:37", `reportAddedDate`="2020-12-19 13:46:37", `reportingGroup`="SGLF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcp" ,"30" ,"r-ZTF" ,"1" ,"19.622" ,null ,"ABMag" ,"ZTF20acynaba" ,"2020-12-16 03:24:22" ,"2020-12-19 13:46:37" ,"SGLF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.622", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynaba", `obsdate`="2020-12-16 03:24:22", `reportAddedDate`="2020-12-19 13:46:37", `reportingGroup`="SGLF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adco" ,"30" ,"r-ZTF" ,"0" ,"19.33" ,"0.21" ,"ABMag" ,"ZTF19aacitvp" ,"2020-12-13 13:19:58" ,"2020-12-19 12:59:25" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adco", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.33", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF19aacitvp", `obsdate`="2020-12-13 13:19:58", `reportAddedDate`="2020-12-19 12:59:25", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adco" ,"30" ,"r-ZTF" ,"0" ,"19.2" ,"0.18" ,"ABMag" ,"ZTF19aacitvp" ,"2020-12-12 13:26:37" ,"2020-12-19 12:59:25" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adco", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF19aacitvp", `obsdate`="2020-12-12 13:26:37", `reportAddedDate`="2020-12-19 12:59:25", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adco" ,"30" ,"r-ZTF" ,"1" ,"19.5097" ,null ,"ABMag" ,"ZTF19aacitvp" ,"2020-12-11 13:32:53" ,"2020-12-19 12:59:25" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adco", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5097", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF19aacitvp", `obsdate`="2020-12-11 13:32:53", `reportAddedDate`="2020-12-19 12:59:25", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcn" ,"45" ,"w-PS1" ,"0" ,"20.7" ,"0.08" ,"ABMag" ,"PS20mjp" ,"2020-12-12 14:22:34" ,"2020-12-19 12:10:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcn", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.7", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS20mjp", `obsdate`="2020-12-12 14:22:34", `reportAddedDate`="2020-12-19 12:10:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcm" ,"45" ,"w-PS1" ,"0" ,"21.1" ,"0.09" ,"ABMag" ,"PS20mjo" ,"2020-12-06 08:00:58" ,"2020-12-19 12:08:48" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcm", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.1", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20mjo", `obsdate`="2020-12-06 08:00:58", `reportAddedDate`="2020-12-19 12:08:48", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcl" ,"45" ,"w-PS1" ,"0" ,"20.36" ,"0.08" ,"ABMag" ,"PS20mjn" ,"2020-12-11 12:08:38" ,"2020-12-19 12:08:29" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcl", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.36", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS20mjn", `obsdate`="2020-12-11 12:08:38", `reportAddedDate`="2020-12-19 12:08:29", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adck" ,"45" ,"w-PS1" ,"0" ,"21.68" ,"0.33" ,"ABMag" ,"PS20mjl" ,"2020-12-06 06:34:34" ,"2020-12-19 12:07:24" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adck", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.68", `magErr`="0.33", `magUnit`="ABMag", `objectName`="PS20mjl", `obsdate`="2020-12-06 06:34:34", `reportAddedDate`="2020-12-19 12:07:24", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcj" ,"45" ,"w-PS1" ,"0" ,"21.77" ,"0.12" ,"ABMag" ,"PS20mjk" ,"2020-12-07 08:19:41" ,"2020-12-19 12:06:59" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcj", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.77", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS20mjk", `obsdate`="2020-12-07 08:19:41", `reportAddedDate`="2020-12-19 12:06:59", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adci" ,"45" ,"w-PS1" ,"0" ,"20.41" ,"0.07" ,"ABMag" ,"PS20mji" ,"2020-12-06 05:19:41" ,"2020-12-19 12:04:48" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adci", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.41", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS20mji", `obsdate`="2020-12-06 05:19:41", `reportAddedDate`="2020-12-19 12:04:48", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adch" ,"45" ,"w-PS1" ,"0" ,"21.76" ,"0.29" ,"ABMag" ,"PS20mjg" ,"2020-11-08 09:25:55" ,"2020-12-19 12:03:40" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adch", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.76", `magErr`="0.29", `magUnit`="ABMag", `objectName`="PS20mjg", `obsdate`="2020-11-08 09:25:55", `reportAddedDate`="2020-12-19 12:03:40", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcg" ,"45" ,"w-PS1" ,"0" ,"20.58" ,"0.07" ,"ABMag" ,"PS20mjf" ,"2020-12-06 05:31:12" ,"2020-12-19 12:03:13" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcg", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.58", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS20mjf", `obsdate`="2020-12-06 05:31:12", `reportAddedDate`="2020-12-19 12:03:13", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcf" ,"30" ,"g-ZTF" ,"0" ,"19.43" ,"0.21" ,"ABMag" ,"ZTF20aavgeip" ,"2020-12-11 12:32:45" ,"2020-12-19 11:58:29" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcf", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.43", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF20aavgeip", `obsdate`="2020-12-11 12:32:45", `reportAddedDate`="2020-12-19 11:58:29", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcf" ,"30" ,"r-ZTF" ,"0" ,"19.86" ,"0.19" ,"ABMag" ,"ZTF20aavgeip" ,"2020-04-25 05:35:25" ,"2020-12-19 11:58:29" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcf", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.86", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20aavgeip", `obsdate`="2020-04-25 05:35:25", `reportAddedDate`="2020-12-19 11:58:29", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adce" ,"45" ,"w-PS1" ,"0" ,"21.12" ,"0.09" ,"ABMag" ,"PS20mje" ,"2020-12-06 05:31:12" ,"2020-12-19 11:47:32" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adce", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.12", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20mje", `obsdate`="2020-12-06 05:31:12", `reportAddedDate`="2020-12-19 11:47:32", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcd" ,"45" ,"w-PS1" ,"0" ,"21.35" ,"0.11" ,"ABMag" ,"PS20mjd" ,"2020-12-07 07:09:07" ,"2020-12-19 11:47:10" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcd", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.35", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20mjd", `obsdate`="2020-12-07 07:09:07", `reportAddedDate`="2020-12-19 11:47:10", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcc" ,"45" ,"w-PS1" ,"0" ,"21.27" ,"0.17" ,"ABMag" ,"PS20mjc" ,"2020-11-17 10:40:48" ,"2020-12-19 11:22:39" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcc", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.27", `magErr`="0.17", `magUnit`="ABMag", `objectName`="PS20mjc", `obsdate`="2020-11-17 10:40:48", `reportAddedDate`="2020-12-19 11:22:39", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcb" ,"30" ,"orange-ATLAS" ,"0" ,"17.404" ,"0.124" ,"ABMag" ,"ATLAS20birs" ,"2020-12-21 04:49:26" ,"2020-12-21 12:33:53" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcb", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="17.404", `magErr`="0.124", `magUnit`="ABMag", `objectName`="ATLAS20birs", `obsdate`="2020-12-21 04:49:26", `reportAddedDate`="2020-12-21 12:33:53", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcb" ,"30" ,"cyan-ATLAS" ,"1" ,"19.59" ,null ,"ABMag" ,"ATLAS20birs" ,"2020-12-15 05:41:17" ,"2020-12-21 12:33:53" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.59", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20birs", `obsdate`="2020-12-15 05:41:17", `reportAddedDate`="2020-12-21 12:33:53", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcb" ,"30" ,"g-ZTF" ,"0" ,"18.62" ,null ,"ABMag" ,"ZTF20acynjjo" ,"2020-12-19 04:26:24" ,"2020-12-19 10:37:52" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.62", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynjjo", `obsdate`="2020-12-19 04:26:24", `reportAddedDate`="2020-12-19 10:37:52", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcb" ,"30" ,"g-ZTF" ,"0" ,"18.62" ,null ,"ABMag" ,"ZTF20acynjjo" ,"2020-12-19 04:26:24" ,"2020-12-19 10:37:52" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.62", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynjjo", `obsdate`="2020-12-19 04:26:24", `reportAddedDate`="2020-12-19 10:37:52", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adcb" ,"30" ,"g-ZTF" ,"1" ,"19.5" ,null ,"ABMag" ,"ZTF20acynjjo" ,"2020-12-16 03:36:00" ,"2020-12-19 10:37:52" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adcb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynjjo", `obsdate`="2020-12-16 03:36:00", `reportAddedDate`="2020-12-19 10:37:52", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adca" ,"30" ,"orange-ATLAS" ,"0" ,"18.948" ,"0.172" ,"ABMag" ,"ATLAS20birj" ,"2020-12-20 06:36:00" ,"2020-12-20 14:35:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adca", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.948", `magErr`="0.172", `magUnit`="ABMag", `objectName`="ATLAS20birj", `obsdate`="2020-12-20 06:36:00", `reportAddedDate`="2020-12-20 14:35:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adca" ,"30" ,"cyan-ATLAS" ,"1" ,"19.56" ,null ,"ABMag" ,"ATLAS20birj" ,"2020-12-14 07:12:00" ,"2020-12-20 14:35:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adca", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.56", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20birj", `obsdate`="2020-12-14 07:12:00", `reportAddedDate`="2020-12-20 14:35:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adca" ,"30" ,"g-ZTF" ,"0" ,"18.66" ,null ,"ABMag" ,"ZTF20acymtcs" ,"2020-12-19 04:39:22" ,"2020-12-19 10:37:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adca", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.66", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymtcs", `obsdate`="2020-12-19 04:39:22", `reportAddedDate`="2020-12-19 10:37:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adca" ,"30" ,"r-ZTF" ,"0" ,"18.88" ,null ,"ABMag" ,"ZTF20acymtcs" ,"2020-12-19 03:04:19" ,"2020-12-19 10:37:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adca", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.88", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymtcs", `obsdate`="2020-12-19 03:04:19", `reportAddedDate`="2020-12-19 10:37:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adca" ,"30" ,"r-ZTF" ,"1" ,"19.08" ,null ,"ABMag" ,"ZTF20acymtcs" ,"2020-12-16 03:01:26" ,"2020-12-19 10:37:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adca", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.08", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acymtcs", `obsdate`="2020-12-16 03:01:26", `reportAddedDate`="2020-12-19 10:37:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbz" ,"30" ,"g-ZTF" ,"0" ,"19.2" ,null ,"ABMag" ,"ZTF20acynudw" ,"2020-12-19 05:31:12" ,"2020-12-19 10:37:35" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.2", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynudw", `obsdate`="2020-12-19 05:31:12", `reportAddedDate`="2020-12-19 10:37:35", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbz" ,"30" ,"g-ZTF" ,"0" ,"19.2" ,null ,"ABMag" ,"ZTF20acynudw" ,"2020-12-19 05:31:12" ,"2020-12-19 10:37:35" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.2", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynudw", `obsdate`="2020-12-19 05:31:12", `reportAddedDate`="2020-12-19 10:37:35", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbz" ,"30" ,"r-ZTF" ,"1" ,"19.76" ,null ,"ABMag" ,"ZTF20acynudw" ,"2020-12-16 05:38:24" ,"2020-12-19 10:37:35" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.76", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acynudw", `obsdate`="2020-12-16 05:38:24", `reportAddedDate`="2020-12-19 10:37:35", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adby" ,"30" ,"cyan-ATLAS" ,"0" ,"19.391" ,"0.165" ,"ABMag" ,"ATLAS20bipg" ,"2020-12-17 10:49:26" ,"2020-12-20 18:44:14" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adby", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.391", `magErr`="0.165", `magUnit`="ABMag", `objectName`="ATLAS20bipg", `obsdate`="2020-12-17 10:49:26", `reportAddedDate`="2020-12-20 18:44:14", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adby" ,"30" ,"cyan-ATLAS" ,"1" ,"19.68" ,null ,"ABMag" ,"ATLAS20bipg" ,"2020-12-11 12:11:31" ,"2020-12-20 18:44:14" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adby", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.68", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bipg", `obsdate`="2020-12-11 12:11:31", `reportAddedDate`="2020-12-20 18:44:14", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adby" ,"30" ,"g-ZTF" ,"0" ,"19.8" ,"0.14" ,"ABMag" ,"ZTF20acxjekh" ,"2020-12-16 10:16:00" ,"2020-12-19 08:58:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adby", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acxjekh", `obsdate`="2020-12-16 10:16:00", `reportAddedDate`="2020-12-19 08:58:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adby" ,"30" ,"r-ZTF" ,"0" ,"19.93" ,"0.19" ,"ABMag" ,"ZTF20acxjekh" ,"2020-12-16 09:23:00" ,"2020-12-19 08:58:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adby", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.93", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acxjekh", `obsdate`="2020-12-16 09:23:00", `reportAddedDate`="2020-12-19 08:58:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adby" ,"30" ,"g-ZTF" ,"1" ,"20.5606" ,null ,"ABMag" ,"ZTF20acxjekh" ,"2020-12-16 08:20:26" ,"2020-12-19 08:58:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adby", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.5606", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxjekh", `obsdate`="2020-12-16 08:20:26", `reportAddedDate`="2020-12-19 08:58:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbx" ,"30" ,"r-ZTF" ,"0" ,"19.17" ,"0.14" ,"ABMag" ,"ZTF20acxooam" ,"2020-12-19 06:59:28" ,"2020-12-19 07:58:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbx", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.17", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acxooam", `obsdate`="2020-12-19 06:59:28", `reportAddedDate`="2020-12-19 07:58:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbx" ,"30" ,"g-ZTF" ,"0" ,"19.22" ,"0.13" ,"ABMag" ,"ZTF20acxooam" ,"2020-12-19 05:42:40" ,"2020-12-19 07:58:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbx", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.22", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxooam", `obsdate`="2020-12-19 05:42:40", `reportAddedDate`="2020-12-19 07:58:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbx" ,"30" ,"r-ZTF" ,"1" ,"20.11" ,null ,"ABMag" ,"ZTF20acxooam" ,"2020-12-12 06:17:16" ,"2020-12-19 07:58:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbx", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.11", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxooam", `obsdate`="2020-12-12 06:17:16", `reportAddedDate`="2020-12-19 07:58:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbw" ,"30" ,"g-ZTF" ,"0" ,"19.05" ,"0.13" ,"ABMag" ,"ZTF18acdygrx" ,"2020-12-16 07:44:40" ,"2020-12-19 07:58:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.05", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF18acdygrx", `obsdate`="2020-12-16 07:44:40", `reportAddedDate`="2020-12-19 07:58:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbw" ,"30" ,"r-ZTF" ,"0" ,"18.4" ,"0.08" ,"ABMag" ,"ZTF18acdygrx" ,"2020-12-16 05:25:28" ,"2020-12-19 07:58:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.4", `magErr`="0.08", `magUnit`="ABMag", `objectName`="ZTF18acdygrx", `obsdate`="2020-12-16 05:25:28", `reportAddedDate`="2020-12-19 07:58:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbw" ,"30" ,"g-ZTF" ,"1" ,"20.4991" ,null ,"ABMag" ,"ZTF18acdygrx" ,"2020-12-12 05:43:20" ,"2020-12-19 07:58:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4991", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18acdygrx", `obsdate`="2020-12-12 05:43:20", `reportAddedDate`="2020-12-19 07:58:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbv" ,"30" ,"r-ZTF" ,"0" ,"19.4" ,"0.18" ,"ABMag" ,"ZTF20acxcbvp" ,"2020-12-15 03:09:37" ,"2020-12-19 06:58:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acxcbvp", `obsdate`="2020-12-15 03:09:37", `reportAddedDate`="2020-12-19 06:58:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbv" ,"30" ,"r-ZTF" ,"0" ,"19.79" ,"0.2" ,"ABMag" ,"ZTF20acxcbvp" ,"2020-12-12 04:59:28" ,"2020-12-19 06:58:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.79", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxcbvp", `obsdate`="2020-12-12 04:59:28", `reportAddedDate`="2020-12-19 06:58:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbv" ,"30" ,"g-ZTF" ,"1" ,"20.2782" ,null ,"ABMag" ,"ZTF20acxcbvp" ,"2020-12-12 04:13:48" ,"2020-12-19 06:58:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.2782", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxcbvp", `obsdate`="2020-12-12 04:13:48", `reportAddedDate`="2020-12-19 06:58:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbu" ,"30" ,"r-ZTF" ,"0" ,"19.46" ,"0.15" ,"ABMag" ,"ZTF20acwsoaw" ,"2020-12-19 06:28:47" ,"2020-12-19 06:58:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.46", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acwsoaw", `obsdate`="2020-12-19 06:28:47", `reportAddedDate`="2020-12-19 06:58:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbu" ,"30" ,"g-ZTF" ,"0" ,"19.6" ,"0.17" ,"ABMag" ,"ZTF20acwsoaw" ,"2020-12-19 04:34:38" ,"2020-12-19 06:58:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acwsoaw", `obsdate`="2020-12-19 04:34:38", `reportAddedDate`="2020-12-19 06:58:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbu" ,"30" ,"g-ZTF" ,"1" ,"20.0158" ,null ,"ABMag" ,"ZTF20acwsoaw" ,"2020-12-19 04:03:05" ,"2020-12-19 06:58:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.0158", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwsoaw", `obsdate`="2020-12-19 04:03:05", `reportAddedDate`="2020-12-19 06:58:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbt" ,"30" ,"g-ZTF" ,"0" ,"19.33" ,"0.21" ,"ABMag" ,"ZTF19aablblo" ,"2020-11-29 05:29:23" ,"2020-12-19 06:58:33" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.33", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF19aablblo", `obsdate`="2020-11-29 05:29:23", `reportAddedDate`="2020-12-19 06:58:33", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbt" ,"30" ,"r-ZTF" ,"0" ,"19.01" ,"0.12" ,"ABMag" ,"ZTF19aablblo" ,"2020-11-25 06:33:12" ,"2020-12-19 06:58:33" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbt", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.01", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF19aablblo", `obsdate`="2020-11-25 06:33:12", `reportAddedDate`="2020-12-19 06:58:33", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbt" ,"30" ,"g-ZTF" ,"1" ,"19.6189" ,null ,"ABMag" ,"ZTF19aablblo" ,"2020-11-25 04:12:13" ,"2020-12-19 06:58:33" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.6189", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF19aablblo", `obsdate`="2020-11-25 04:12:13", `reportAddedDate`="2020-12-19 06:58:33", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbs" ,"30" ,"g-ZTF" ,"0" ,"19.65" ,"0.15" ,"ABMag" ,"ZTF18abuozmg" ,"2020-12-10 04:27:01" ,"2020-12-19 06:58:33" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbs", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.65", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF18abuozmg", `obsdate`="2020-12-10 04:27:01", `reportAddedDate`="2020-12-19 06:58:33", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbs" ,"30" ,"g-ZTF" ,"0" ,"19.66" ,"0.23" ,"ABMag" ,"ZTF18abuozmg" ,"2020-12-06 03:43:49" ,"2020-12-19 06:58:33" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbs", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.66", `magErr`="0.23", `magUnit`="ABMag", `objectName`="ZTF18abuozmg", `obsdate`="2020-12-06 03:43:49", `reportAddedDate`="2020-12-19 06:58:33", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbs" ,"30" ,"r-ZTF" ,"1" ,"19.7659" ,null ,"ABMag" ,"ZTF18abuozmg" ,"2020-12-04 05:30:35" ,"2020-12-19 06:58:33" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbs", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7659", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18abuozmg", `obsdate`="2020-12-04 05:30:35", `reportAddedDate`="2020-12-19 06:58:33", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbr" ,"30" ,"g-ZTF" ,"0" ,"17.61" ,"0.11" ,"ABMag" ,"ZTF20actpcbb" ,"2020-12-19 05:01:05" ,"2020-12-19 05:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbr", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="17.61", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20actpcbb", `obsdate`="2020-12-19 05:01:05", `reportAddedDate`="2020-12-19 05:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbr" ,"30" ,"g-ZTF" ,"0" ,"18.18" ,"0.15" ,"ABMag" ,"ZTF20actpcbb" ,"2020-12-16 06:35:45" ,"2020-12-19 05:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbr", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.18", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20actpcbb", `obsdate`="2020-12-16 06:35:45", `reportAddedDate`="2020-12-19 05:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbr" ,"30" ,"r-ZTF" ,"1" ,"19.7345" ,null ,"ABMag" ,"ZTF20actpcbb" ,"2020-12-16 05:33:06" ,"2020-12-19 05:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7345", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20actpcbb", `obsdate`="2020-12-16 05:33:06", `reportAddedDate`="2020-12-19 05:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbq" ,"45" ,"i-Sloan" ,"0" ,"20.35" ,"0.31" ,"ABMag" ,"PS20mjb" ,"2020-12-04 10:45:07" ,"2020-12-18 23:09:25" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbq", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.35", `magErr`="0.31", `magUnit`="ABMag", `objectName`="PS20mjb", `obsdate`="2020-12-04 10:45:07", `reportAddedDate`="2020-12-18 23:09:25", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbp" ,"30" ,"r-ZTF" ,"0" ,"20.3577" ,null ,"ABMag" ,"ZTF20abhtvor" ,"2020-07-13 11:07:47" ,"2020-12-18 22:15:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.3577", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20abhtvor", `obsdate`="2020-07-13 11:07:47", `reportAddedDate`="2020-12-18 22:15:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbp" ,"30" ,"g-ZTF" ,"1" ,"20.2455" ,null ,"ABMag" ,"ZTF20abhtvor" ,"2020-07-13 08:45:39" ,"2020-12-18 22:15:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.2455", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20abhtvor", `obsdate`="2020-07-13 08:45:39", `reportAddedDate`="2020-12-18 22:15:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbo" ,"30" ,"r-ZTF" ,"0" ,"20.4302" ,null ,"ABMag" ,"ZTF20acxsywg" ,"2020-12-11 11:53:42" ,"2020-12-18 22:12:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4302", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxsywg", `obsdate`="2020-12-11 11:53:42", `reportAddedDate`="2020-12-18 22:12:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbo" ,"30" ,"g-ZTF" ,"1" ,"16.589" ,null ,"ABMag" ,"ZTF20acxsywg" ,"2020-12-09 12:38:46" ,"2020-12-18 22:12:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="16.589", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxsywg", `obsdate`="2020-12-09 12:38:46", `reportAddedDate`="2020-12-18 22:12:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbn" ,"30" ,"r-ZTF" ,"0" ,"20.7212" ,null ,"ABMag" ,"ZTF20acxpmnx" ,"2020-12-11 07:06:59" ,"2020-12-18 22:10:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.7212", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxpmnx", `obsdate`="2020-12-11 07:06:59", `reportAddedDate`="2020-12-18 22:10:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbn" ,"30" ,"g-ZTF" ,"1" ,"20.3779" ,null ,"ABMag" ,"ZTF20acxpmnx" ,"2020-12-11 06:44:04" ,"2020-12-18 22:10:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3779", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxpmnx", `obsdate`="2020-12-11 06:44:04", `reportAddedDate`="2020-12-18 22:10:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbm" ,"30" ,"r-ZTF" ,"0" ,"19.3151" ,"0.15754" ,"ABMag" ,"ZTF20acxzlrc" ,"2020-12-18 12:25:35" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.3151", `magErr`="0.15754", `magUnit`="ABMag", `objectName`="ZTF20acxzlrc", `obsdate`="2020-12-18 12:25:35", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbm" ,"30" ,"g-ZTF" ,"0" ,"19.3436" ,"0.228705" ,"ABMag" ,"ZTF20acxzlrc" ,"2020-12-16 13:01:08" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.3436", `magErr`="0.228705", `magUnit`="ABMag", `objectName`="ZTF20acxzlrc", `obsdate`="2020-12-16 13:01:08", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbm" ,"30" ,"r-ZTF" ,"0" ,"19.2245" ,"0.204407" ,"ABMag" ,"ZTF20acxzlrc" ,"2020-12-16 12:29:55" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2245", `magErr`="0.204407", `magUnit`="ABMag", `objectName`="ZTF20acxzlrc", `obsdate`="2020-12-16 12:29:55", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbm" ,"30" ,"g-ZTF" ,"1" ,"18.9205" ,null ,"ABMag" ,"ZTF20acxzlrc" ,"2020-12-12 13:00:32" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.9205", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxzlrc", `obsdate`="2020-12-12 13:00:32", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbl" ,"30" ,"g-ZTF" ,"0" ,"20.0947" ,"0.2099" ,"ABMag" ,"ZTF20acylmhd" ,"2020-12-18 09:48:09" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0947", `magErr`="0.2099", `magUnit`="ABMag", `objectName`="ZTF20acylmhd", `obsdate`="2020-12-18 09:48:09", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbl" ,"30" ,"g-ZTF" ,"0" ,"20.311" ,"0.273385" ,"ABMag" ,"ZTF20acylmhd" ,"2020-12-16 10:04:22" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.311", `magErr`="0.273385", `magUnit`="ABMag", `objectName`="ZTF20acylmhd", `obsdate`="2020-12-16 10:04:22", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbl" ,"30" ,"r-ZTF" ,"1" ,"19.9389" ,null ,"ABMag" ,"ZTF20acylmhd" ,"2020-12-16 09:34:29" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.9389", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acylmhd", `obsdate`="2020-12-16 09:34:29", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"0" ,"19.79" ,"0.18" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-16 09:46:24" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.79", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-16 09:46:24", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"g-ZTF" ,"0" ,"19.88" ,"0.13" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-16 08:35:39" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.88", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-16 08:35:39", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"1" ,"20.1751" ,null ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-13 11:23:32" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1751", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-13 11:23:32", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"0" ,"19.5041" ,"0.111692" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-18 10:03:24" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5041", `magErr`="0.111692", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-18 10:03:24", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"0" ,"19.792" ,"0.175306" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-16 09:46:24" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.792", `magErr`="0.175306", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-16 09:46:24", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"g-ZTF" ,"0" ,"19.8786" ,"0.132383" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-16 08:35:39" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8786", `magErr`="0.132383", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-16 08:35:39", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"1" ,"20.1751" ,null ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-13 11:23:32" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1751", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-13 11:23:32", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbj" ,"30" ,"g-ZTF" ,"0" ,"20.0573" ,"0.180218" ,"ABMag" ,"ZTF20acyloou" ,"2020-12-18 09:52:16" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0573", `magErr`="0.180218", `magUnit`="ABMag", `objectName`="ZTF20acyloou", `obsdate`="2020-12-18 09:52:16", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbj" ,"30" ,"g-ZTF" ,"0" ,"20.477" ,"0.275258" ,"ABMag" ,"ZTF20acyloou" ,"2020-12-16 08:10:10" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.477", `magErr`="0.275258", `magUnit`="ABMag", `objectName`="ZTF20acyloou", `obsdate`="2020-12-16 08:10:10", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbj" ,"30" ,"g-ZTF" ,"1" ,"20.2809" ,null ,"ABMag" ,"ZTF20acyloou" ,"2020-12-13 10:08:25" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.2809", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyloou", `obsdate`="2020-12-13 10:08:25", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbi" ,"30" ,"r-ZTF" ,"0" ,"19.9695" ,"0.151606" ,"ABMag" ,"ZTF20acylvtk" ,"2020-12-18 10:47:17" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9695", `magErr`="0.151606", `magUnit`="ABMag", `objectName`="ZTF20acylvtk", `obsdate`="2020-12-18 10:47:17", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbi" ,"30" ,"g-ZTF" ,"0" ,"20.2103" ,"0.255131" ,"ABMag" ,"ZTF20acylvtk" ,"2020-12-17 09:52:38" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2103", `magErr`="0.255131", `magUnit`="ABMag", `objectName`="ZTF20acylvtk", `obsdate`="2020-12-17 09:52:38", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbi" ,"30" ,"r-ZTF" ,"0" ,"20.2187" ,"0.229438" ,"ABMag" ,"ZTF20acylvtk" ,"2020-12-16 09:10:27" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.2187", `magErr`="0.229438", `magUnit`="ABMag", `objectName`="ZTF20acylvtk", `obsdate`="2020-12-16 09:10:27", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbi" ,"30" ,"r-ZTF" ,"0" ,"20.3213" ,"0.234051" ,"ABMag" ,"ZTF20acylvtk" ,"2020-12-15 10:58:07" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.3213", `magErr`="0.234051", `magUnit`="ABMag", `objectName`="ZTF20acylvtk", `obsdate`="2020-12-15 10:58:07", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbi" ,"30" ,"g-ZTF" ,"0" ,"20.5257" ,"0.287097" ,"ABMag" ,"ZTF20acylvtk" ,"2020-12-13 10:58:04" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.5257", `magErr`="0.287097", `magUnit`="ABMag", `objectName`="ZTF20acylvtk", `obsdate`="2020-12-13 10:58:04", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbi" ,"30" ,"r-ZTF" ,"1" ,"19.377" ,null ,"ABMag" ,"ZTF20acylvtk" ,"2020-12-12 11:11:47" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.377", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acylvtk", `obsdate`="2020-12-12 11:11:47", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbh" ,"30" ,"g-ZTF" ,"0" ,"20.3297" ,null ,"ABMag" ,"ZTF20acqvgaz" ,"2020-11-15 12:20:38" ,"2020-12-18 21:07:33" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbh", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.3297", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acqvgaz", `obsdate`="2020-11-15 12:20:38", `reportAddedDate`="2020-12-18 21:07:33", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbh" ,"30" ,"g-ZTF" ,"1" ,"20.7744" ,null ,"ABMag" ,"ZTF20acqvgaz" ,"2020-11-12 12:41:26" ,"2020-12-18 21:07:33" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbh", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.7744", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acqvgaz", `obsdate`="2020-11-12 12:41:26", `reportAddedDate`="2020-12-18 21:07:33", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbg" ,"45" ,"w-PS1" ,"0" ,"20.66" ,"0.15" ,"ABMag" ,"PS20mja" ,"2020-11-17 05:25:26" ,"2020-12-18 20:15:32" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbg", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.66", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20mja", `obsdate`="2020-11-17 05:25:26", `reportAddedDate`="2020-12-18 20:15:32", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbf" ,"45" ,"w-PS1" ,"0" ,"21.98" ,"0.34" ,"ABMag" ,"PS20miy" ,"2020-11-20 11:19:41" ,"2020-12-18 20:12:53" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbf", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.98", `magErr`="0.34", `magUnit`="ABMag", `objectName`="PS20miy", `obsdate`="2020-11-20 11:19:41", `reportAddedDate`="2020-12-18 20:12:53", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbe" ,"45" ,"i-Sloan" ,"0" ,"19.68" ,"0.06" ,"ABMag" ,"PS20mix" ,"2020-12-07 14:42:43" ,"2020-12-18 20:10:31" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbe", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.68", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20mix", `obsdate`="2020-12-07 14:42:43", `reportAddedDate`="2020-12-18 20:10:31", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbd" ,"30" ,"g-ZTF" ,"0" ,"20.0185" ,null ,"ABMag" ,"ZTF20acwxgcy" ,"2020-12-11 10:40:27" ,"2020-12-18 20:09:43" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0185", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwxgcy", `obsdate`="2020-12-11 10:40:27", `reportAddedDate`="2020-12-18 20:09:43", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbd" ,"30" ,"g-ZTF" ,"1" ,"19.2625" ,null ,"ABMag" ,"ZTF20acwxgcy" ,"2020-12-09 12:58:02" ,"2020-12-18 20:09:43" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.2625", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwxgcy", `obsdate`="2020-12-09 12:58:02", `reportAddedDate`="2020-12-18 20:09:43", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbc" ,"30" ,"r-ZTF" ,"0" ,"19.2689" ,null ,"ABMag" ,"ZTF19acttscy" ,"2020-12-02 03:32:13" ,"2020-12-18 20:05:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2689", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF19acttscy", `obsdate`="2020-12-02 03:32:13", `reportAddedDate`="2020-12-18 20:05:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbc" ,"30" ,"g-ZTF" ,"1" ,"19.6848" ,null ,"ABMag" ,"ZTF19acttscy" ,"2020-12-02 02:32:20" ,"2020-12-18 20:05:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.6848", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF19acttscy", `obsdate`="2020-12-02 02:32:20", `reportAddedDate`="2020-12-18 20:05:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbb" ,"30" ,"r-ZTF" ,"0" ,"17.8158" ,null ,"ABMag" ,"ZTF20acxroig" ,"2020-11-16 12:03:20" ,"2020-12-18 20:02:59" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="17.8158", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxroig", `obsdate`="2020-11-16 12:03:20", `reportAddedDate`="2020-12-18 20:02:59", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbb" ,"30" ,"g-ZTF" ,"1" ,"19.9299" ,null ,"ABMag" ,"ZTF20acxroig" ,"2020-11-16 11:04:57" ,"2020-12-18 20:02:59" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.9299", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxroig", `obsdate`="2020-11-16 11:04:57", `reportAddedDate`="2020-12-18 20:02:59", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adba" ,"30" ,"r-ZTF" ,"0" ,"17.7986" ,null ,"ABMag" ,"ZTF20acxrpri" ,"2020-12-07 10:03:50" ,"2020-12-18 20:00:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adba", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="17.7986", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxrpri", `obsdate`="2020-12-07 10:03:50", `reportAddedDate`="2020-12-18 20:00:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adba" ,"30" ,"g-ZTF" ,"1" ,"19.691" ,null ,"ABMag" ,"ZTF20acxrpri" ,"2020-12-07 08:32:49" ,"2020-12-18 20:00:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adba", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.691", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxrpri", `obsdate`="2020-12-07 08:32:49", `reportAddedDate`="2020-12-18 20:00:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adaz" ,"45" ,"w-PS1" ,"0" ,"21.35" ,"0.08" ,"ABMag" ,"PS20miv" ,"2020-12-10 12:54:43" ,"2020-12-18 20:00:20" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.35", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS20miv", `obsdate`="2020-12-10 12:54:43", `reportAddedDate`="2020-12-18 20:00:20", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aday" ,"45" ,"w-PS1" ,"0" ,"20.54" ,"0.09" ,"ABMag" ,"PS20miu" ,"2020-12-12 12:56:10" ,"2020-12-18 19:58:38" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aday", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.54", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20miu", `obsdate`="2020-12-12 12:56:10", `reportAddedDate`="2020-12-18 19:58:38", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adax" ,"45" ,"i-Sloan" ,"0" ,"20.45" ,"0.17" ,"ABMag" ,"PS20mis" ,"2020-12-02 11:12:29" ,"2020-12-18 19:56:58" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adax", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.45", `magErr`="0.17", `magUnit`="ABMag", `objectName`="PS20mis", `obsdate`="2020-12-02 11:12:29", `reportAddedDate`="2020-12-18 19:56:58", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adaw" ,"45" ,"w-PS1" ,"0" ,"20.56" ,"0.13" ,"ABMag" ,"PS20mir" ,"2020-12-08 07:19:12" ,"2020-12-18 19:56:30" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaw", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.56", `magErr`="0.13", `magUnit`="ABMag", `objectName`="PS20mir", `obsdate`="2020-12-08 07:19:12", `reportAddedDate`="2020-12-18 19:56:30", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adav" ,"45" ,"w-PS1" ,"0" ,"21.09" ,"0.13" ,"ABMag" ,"PS20mip" ,"2020-12-08 06:00:00" ,"2020-12-18 19:54:14" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adav", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.09", `magErr`="0.13", `magUnit`="ABMag", `objectName`="PS20mip", `obsdate`="2020-12-08 06:00:00", `reportAddedDate`="2020-12-18 19:54:14", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adau" ,"45" ,"w-PS1" ,"0" ,"20.96" ,"0.17" ,"ABMag" ,"PS20mio" ,"2020-12-12 14:22:34" ,"2020-12-18 19:53:52" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adau", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.96", `magErr`="0.17", `magUnit`="ABMag", `objectName`="PS20mio", `obsdate`="2020-12-12 14:22:34", `reportAddedDate`="2020-12-18 19:53:52", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adat" ,"45" ,"i-Sloan" ,"0" ,"19.99" ,"0.16" ,"ABMag" ,"PS20min" ,"2020-11-28 14:42:43" ,"2020-12-18 19:53:05" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adat", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.99", `magErr`="0.16", `magUnit`="ABMag", `objectName`="PS20min", `obsdate`="2020-11-28 14:42:43", `reportAddedDate`="2020-12-18 19:53:05", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adas" ,"45" ,"i-Sloan" ,"0" ,"20.27" ,"0.1" ,"ABMag" ,"PS20mim" ,"2020-12-07 14:45:36" ,"2020-12-18 19:52:42" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adas", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.27", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS20mim", `obsdate`="2020-12-07 14:45:36", `reportAddedDate`="2020-12-18 19:52:42", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adar" ,"45" ,"w-PS1" ,"0" ,"21.14" ,"0.1" ,"ABMag" ,"PS20mil" ,"2020-12-12 05:09:36" ,"2020-12-18 19:52:21" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adar", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.14", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS20mil", `obsdate`="2020-12-12 05:09:36", `reportAddedDate`="2020-12-18 19:52:21", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adaq" ,"45" ,"w-PS1" ,"0" ,"21.45" ,"0.15" ,"ABMag" ,"PS20mik" ,"2020-12-12 04:59:31" ,"2020-12-18 19:49:16" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaq", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.45", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20mik", `obsdate`="2020-12-12 04:59:31", `reportAddedDate`="2020-12-18 19:49:16", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adap" ,"45" ,"w-PS1" ,"0" ,"21.16" ,"0.14" ,"ABMag" ,"PS20mij" ,"2020-12-07 07:12:00" ,"2020-12-18 19:48:54" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adap", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.16", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS20mij", `obsdate`="2020-12-07 07:12:00", `reportAddedDate`="2020-12-18 19:48:54", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adao" ,"45" ,"w-PS1" ,"0" ,"21.06" ,"0.16" ,"ABMag" ,"PS20mii" ,"2020-12-12 14:28:19" ,"2020-12-18 19:48:32" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adao", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.06", `magErr`="0.16", `magUnit`="ABMag", `objectName`="PS20mii", `obsdate`="2020-12-12 14:28:19", `reportAddedDate`="2020-12-18 19:48:32", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adan" ,"45" ,"w-PS1" ,"0" ,"21.09" ,"0.21" ,"ABMag" ,"PS20mih" ,"2020-09-19 13:37:55" ,"2020-12-18 19:48:10" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adan", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.09", `magErr`="0.21", `magUnit`="ABMag", `objectName`="PS20mih", `obsdate`="2020-09-19 13:37:55", `reportAddedDate`="2020-12-18 19:48:10", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adam" ,"45" ,"w-PS1" ,"0" ,"21.78" ,"0.26" ,"ABMag" ,"PS20mig" ,"2020-11-20 10:40:48" ,"2020-12-18 19:47:44" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adam", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.78", `magErr`="0.26", `magUnit`="ABMag", `objectName`="PS20mig", `obsdate`="2020-11-20 10:40:48", `reportAddedDate`="2020-12-18 19:47:44", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adal" ,"45" ,"i-Sloan" ,"0" ,"20.68" ,"0.23" ,"ABMag" ,"PS20mif" ,"2020-12-06 14:13:55" ,"2020-12-18 19:46:55" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adal", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.68", `magErr`="0.23", `magUnit`="ABMag", `objectName`="PS20mif", `obsdate`="2020-12-06 14:13:55", `reportAddedDate`="2020-12-18 19:46:55", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adak" ,"45" ,"i-Sloan" ,"0" ,"20.23" ,"0.11" ,"ABMag" ,"PS20mic" ,"2020-12-06 14:13:55" ,"2020-12-18 19:45:41" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adak", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.23", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20mic", `obsdate`="2020-12-06 14:13:55", `reportAddedDate`="2020-12-18 19:45:41", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adaj" ,"45" ,"w-PS1" ,"0" ,"21.23" ,"0.09" ,"ABMag" ,"PS20mia" ,"2020-12-07 06:59:02" ,"2020-12-18 19:45:06" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaj", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.23", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20mia", `obsdate`="2020-12-07 06:59:02", `reportAddedDate`="2020-12-18 19:45:06", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adai" ,"45" ,"w-PS1" ,"0" ,"20.93" ,"0.15" ,"ABMag" ,"PS20mhz" ,"2020-12-08 07:19:12" ,"2020-12-18 19:44:49" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adai", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.93", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20mhz", `obsdate`="2020-12-08 07:19:12", `reportAddedDate`="2020-12-18 19:44:49", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adah" ,"1200" ,"Clear-" ,"0" ,"20.58" ,"0.23" ,"ABMag" ,"GSNST-20dk" ,"2020-12-18 19:34:15" ,"2020-12-18 19:35:01" ,"GSNST" ,"PSN" ,"GSNST" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adah", `exptime`="1200", `filter`="Clear-", `limitingMag`="0", `mag`="20.58", `magErr`="0.23", `magUnit`="ABMag", `objectName`="GSNST-20dk", `obsdate`="2020-12-18 19:34:15", `reportAddedDate`="2020-12-18 19:35:01", `reportingGroup`="GSNST", `suggestedType`="PSN", `survey`="GSNST", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adah" ,"300" ,"Clear-" ,"1" ,"21" ,null ,"ABMag" ,"GSNST-20dk" ,"2019-12-13 23:03:33" ,"2020-12-18 19:35:01" ,"GSNST" ,"PSN" ,"GSNST" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adah", `exptime`="300", `filter`="Clear-", `limitingMag`="1", `mag`="21", `magErr`=null, `magUnit`="ABMag", `objectName`="GSNST-20dk", `obsdate`="2019-12-13 23:03:33", `reportAddedDate`="2020-12-18 19:35:01", `reportingGroup`="GSNST", `suggestedType`="PSN", `survey`="GSNST", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adag" ,null ,"g-Sloan" ,"0" ,"18.1" ,null ,"ABMag" ,"ASASSN-20qa" ,"2020-12-17 06:57:36" ,"2020-12-18 18:49:11" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-1_Brutus", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adag", `exptime`=null, `filter`="g-Sloan", `limitingMag`="0", `mag`="18.1", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20qa", `obsdate`="2020-12-17 06:57:36", `reportAddedDate`="2020-12-18 18:49:11", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-1_Brutus" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adag" ,null ,"g-Sloan" ,"1" ,"18.7" ,null ,"ABMag" ,"ASASSN-20qa" ,"2020-12-09 08:52:48" ,"2020-12-18 18:49:11" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-1_Brutus", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adag", `exptime`=null, `filter`="g-Sloan", `limitingMag`="1", `mag`="18.7", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20qa", `obsdate`="2020-12-09 08:52:48", `reportAddedDate`="2020-12-18 18:49:11", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-1_Brutus" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adaf" ,null ,"g-Sloan" ,"0" ,"17.9" ,null ,"ABMag" ,"ASASSN-20pz" ,"2020-12-14 01:55:12" ,"2020-12-18 17:44:34" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-3_Paczynski", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaf", `exptime`=null, `filter`="g-Sloan", `limitingMag`="0", `mag`="17.9", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20pz", `obsdate`="2020-12-14 01:55:12", `reportAddedDate`="2020-12-18 17:44:34", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-3_Paczynski" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adaf" ,null ,"g-Sloan" ,"1" ,"18.5" ,null ,"ABMag" ,"ASASSN-20pz" ,"2020-12-09 01:26:24" ,"2020-12-18 17:44:34" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-2_Cassius", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaf", `exptime`=null, `filter`="g-Sloan", `limitingMag`="1", `mag`="18.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20pz", `obsdate`="2020-12-09 01:26:24", `reportAddedDate`="2020-12-18 17:44:34", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-2_Cassius" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adae" ,"45" ,"w-PS1" ,"0" ,"20.56" ,"0.08" ,"ABMag" ,"PS20mhx" ,"2020-12-12 07:45:07" ,"2020-12-18 16:35:32" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adae", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.56", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS20mhx", `obsdate`="2020-12-12 07:45:07", `reportAddedDate`="2020-12-18 16:35:32", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adad" ,"120" ,"z-Sloan" ,"0" ,"20.97" ,"0.29" ,"ABMag" ,"PS20mhw" ,"2020-11-25 15:30:14" ,"2020-12-18 15:18:19" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adad", `exptime`="120", `filter`="z-Sloan", `limitingMag`="0", `mag`="20.97", `magErr`="0.29", `magUnit`="ABMag", `objectName`="PS20mhw", `obsdate`="2020-11-25 15:30:14", `reportAddedDate`="2020-12-18 15:18:19", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adac" ,"45" ,"i-Sloan" ,"0" ,"20.88" ,"0.14" ,"ABMag" ,"PS20mhu" ,"2020-12-07 14:45:36" ,"2020-12-18 15:17:43" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adac", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.88", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS20mhu", `obsdate`="2020-12-07 14:45:36", `reportAddedDate`="2020-12-18 15:17:43", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adab" ,"45" ,"w-PS1" ,"0" ,"21.98" ,"0.14" ,"ABMag" ,"PS20mht" ,"2020-12-07 08:03:50" ,"2020-12-18 15:17:11" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adab", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.98", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS20mht", `obsdate`="2020-12-07 08:03:50", `reportAddedDate`="2020-12-18 15:17:11", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adaa" ,"45" ,"i-Sloan" ,"0" ,"20.91" ,"0.1" ,"ABMag" ,"PS20mhs" ,"2020-12-07 11:28:19" ,"2020-12-18 15:16:55" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adaa", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.91", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS20mhs", `obsdate`="2020-12-07 11:28:19", `reportAddedDate`="2020-12-18 15:16:55", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczz" ,"120" ,"z-Sloan" ,"0" ,"20.36" ,"0.12" ,"ABMag" ,"PS20mhr" ,"2020-12-06 15:38:53" ,"2020-12-18 15:16:25" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczz", `exptime`="120", `filter`="z-Sloan", `limitingMag`="0", `mag`="20.36", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS20mhr", `obsdate`="2020-12-06 15:38:53", `reportAddedDate`="2020-12-18 15:16:25", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczy" ,"45" ,"w-PS1" ,"0" ,"20.54" ,"0.15" ,"ABMag" ,"PS20mhn" ,"2020-12-12 14:29:46" ,"2020-12-18 15:13:54" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczy", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.54", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20mhn", `obsdate`="2020-12-12 14:29:46", `reportAddedDate`="2020-12-18 15:13:54", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczx" ,"45" ,"i-Sloan" ,"0" ,"20.87" ,"0.24" ,"ABMag" ,"PS20mhm" ,"2020-11-25 11:58:34" ,"2020-12-18 15:13:33" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczx", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.87", `magErr`="0.24", `magUnit`="ABMag", `objectName`="PS20mhm", `obsdate`="2020-11-25 11:58:34", `reportAddedDate`="2020-12-18 15:13:33", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczw" ,"45" ,"w-PS1" ,"0" ,"20.61" ,"0.11" ,"ABMag" ,"PS20mhl" ,"2020-12-12 11:45:36" ,"2020-12-18 15:13:16" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczw", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.61", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20mhl", `obsdate`="2020-12-12 11:45:36", `reportAddedDate`="2020-12-18 15:13:16", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczv" ,"30" ,"r-ZTF" ,"0" ,"18.14" ,"0.21" ,"ABMag" ,"ZTF18acyhkjv" ,"2020-12-13 13:32:10" ,"2020-12-18 13:58:15" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.14", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF18acyhkjv", `obsdate`="2020-12-13 13:32:10", `reportAddedDate`="2020-12-18 13:58:15", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczv" ,"30" ,"r-ZTF" ,"0" ,"18.18" ,"0.18" ,"ABMag" ,"ZTF18acyhkjv" ,"2020-12-13 13:25:23" ,"2020-12-18 13:58:15" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.18", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF18acyhkjv", `obsdate`="2020-12-13 13:25:23", `reportAddedDate`="2020-12-18 13:58:15", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczu" ,"30" ,"r-ZTF" ,"0" ,"19.24" ,"0.18" ,"ABMag" ,"ZTF18acxexkz" ,"2020-12-16 13:23:14" ,"2020-12-18 13:58:15" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.24", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF18acxexkz", `obsdate`="2020-12-16 13:23:14", `reportAddedDate`="2020-12-18 13:58:15", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczu" ,"30" ,"r-ZTF" ,"0" ,"18.98" ,"0.21" ,"ABMag" ,"ZTF18acxexkz" ,"2020-12-13 13:18:37" ,"2020-12-18 13:58:15" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.98", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF18acxexkz", `obsdate`="2020-12-13 13:18:37", `reportAddedDate`="2020-12-18 13:58:15", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczt" ,"45" ,"w-PS1" ,"0" ,"21.73" ,"0.18" ,"ABMag" ,"PS20mhk" ,"2020-12-15 05:13:55" ,"2020-12-18 12:15:12" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczt", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.73", `magErr`="0.18", `magUnit`="ABMag", `objectName`="PS20mhk", `obsdate`="2020-12-15 05:13:55", `reportAddedDate`="2020-12-18 12:15:12", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczs" ,"60" ,"G-Gaia" ,"0" ,"16.12" ,"0.2" ,"ABMag" ,"Gaia20fuf" ,"2020-12-17 05:57:07" ,"2020-12-18 10:29:12" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczs", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="16.12", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fuf", `obsdate`="2020-12-17 05:57:07", `reportAddedDate`="2020-12-18 10:29:12", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczs" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fuf" ,"2020-01-22 15:10:05" ,"2020-12-18 10:29:12" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczs", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fuf", `obsdate`="2020-01-22 15:10:05", `reportAddedDate`="2020-12-18 10:29:12", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczr" ,"60" ,"G-Gaia" ,"0" ,"18.84" ,"0.2" ,"ABMag" ,"Gaia20fue" ,"2020-12-17 10:59:31" ,"2020-12-18 10:28:37" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczr", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.84", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fue", `obsdate`="2020-12-17 10:59:31", `reportAddedDate`="2020-12-18 10:28:37", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczr" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fue" ,"2020-11-05 17:52:48" ,"2020-12-18 10:28:37" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczr", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fue", `obsdate`="2020-11-05 17:52:48", `reportAddedDate`="2020-12-18 10:28:37", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczq" ,"60" ,"G-Gaia" ,"0" ,"17.16" ,"0.2" ,"ABMag" ,"Gaia20fud" ,"2020-12-17 01:55:12" ,"2020-12-18 10:27:50" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczq", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.16", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fud", `obsdate`="2020-12-17 01:55:12", `reportAddedDate`="2020-12-18 10:27:50", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczq" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fud" ,"2018-12-16 15:43:12" ,"2020-12-18 10:27:50" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczq", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fud", `obsdate`="2018-12-16 15:43:12", `reportAddedDate`="2020-12-18 10:27:50", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczp" ,"60" ,"G-Gaia" ,"0" ,"18.61" ,"0.2" ,"ABMag" ,"Gaia20fuc" ,"2020-12-17 08:39:50" ,"2020-12-18 10:27:37" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczp", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.61", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fuc", `obsdate`="2020-12-17 08:39:50", `reportAddedDate`="2020-12-18 10:27:37", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczp" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fuc" ,"2020-06-28 23:54:14" ,"2020-12-18 10:27:37" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczp", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fuc", `obsdate`="2020-06-28 23:54:14", `reportAddedDate`="2020-12-18 10:27:37", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczo" ,"60" ,"G-Gaia" ,"0" ,"18.73" ,"0.2" ,"ABMag" ,"Gaia20fua" ,"2020-12-17 14:31:12" ,"2020-12-18 10:26:51" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczo", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.73", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fua", `obsdate`="2020-12-17 14:31:12", `reportAddedDate`="2020-12-18 10:26:51", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczo" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fua" ,"2020-11-16 03:00:00" ,"2020-12-18 10:26:51" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczo", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fua", `obsdate`="2020-11-16 03:00:00", `reportAddedDate`="2020-12-18 10:26:51", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczn" ,"60" ,"G-Gaia" ,"0" ,"17.88" ,"0.2" ,"ABMag" ,"Gaia20ftw" ,"2020-12-17 06:30:14" ,"2020-12-18 10:21:55" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczn", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.88", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20ftw", `obsdate`="2020-12-17 06:30:14", `reportAddedDate`="2020-12-18 10:21:55", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczn" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20ftw" ,"2019-01-12 16:33:35" ,"2020-12-18 10:21:55" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczn", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20ftw", `obsdate`="2019-01-12 16:33:35", `reportAddedDate`="2020-12-18 10:21:55", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczm" ,"60" ,"G-Gaia" ,"0" ,"18.67" ,"0.2" ,"ABMag" ,"Gaia20ftv" ,"2020-12-17 01:37:55" ,"2020-12-18 10:21:26" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczm", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.67", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20ftv", `obsdate`="2020-12-17 01:37:55", `reportAddedDate`="2020-12-18 10:21:26", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczm" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20ftv" ,"2020-07-31 14:16:48" ,"2020-12-18 10:21:26" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczm", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20ftv", `obsdate`="2020-07-31 14:16:48", `reportAddedDate`="2020-12-18 10:21:26", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczl" ,"60" ,"G-Gaia" ,"0" ,"12.77" ,"0.2" ,"ABMag" ,"Gaia20ftu" ,"2020-12-16 23:45:36" ,"2020-12-18 10:20:54" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczl", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="12.77", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20ftu", `obsdate`="2020-12-16 23:45:36", `reportAddedDate`="2020-12-18 10:20:54", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczl" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20ftu" ,"2020-09-12 07:09:07" ,"2020-12-18 10:20:54" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczl", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20ftu", `obsdate`="2020-09-12 07:09:07", `reportAddedDate`="2020-12-18 10:20:54", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczk" ,"60" ,"G-Gaia" ,"0" ,"18.68" ,"0.2" ,"ABMag" ,"Gaia20ftt" ,"2020-12-17 10:27:50" ,"2020-12-18 10:19:57" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczk", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.68", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20ftt", `obsdate`="2020-12-17 10:27:50", `reportAddedDate`="2020-12-18 10:19:57", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczk" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20ftt" ,"2019-06-19 10:58:05" ,"2020-12-18 10:19:57" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczk", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20ftt", `obsdate`="2019-06-19 10:58:05", `reportAddedDate`="2020-12-18 10:19:57", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczj" ,"30" ,"g-ZTF" ,"0" ,"18.66" ,null ,"ABMag" ,"ZTF20acxuyqs" ,"2020-12-16 04:26:24" ,"2020-12-18 04:39:13" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.66", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxuyqs", `obsdate`="2020-12-16 04:26:24", `reportAddedDate`="2020-12-18 04:39:13", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczj" ,"30" ,"r-ZTF" ,"0" ,"19.11" ,null ,"ABMag" ,"ZTF20acxuyqs" ,"2020-11-28 02:02:24" ,"2020-12-18 04:39:13" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.11", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxuyqs", `obsdate`="2020-11-28 02:02:24", `reportAddedDate`="2020-12-18 04:39:13", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczj" ,"30" ,"g-ZTF" ,"1" ,"19.55" ,null ,"ABMag" ,"ZTF20acxuyqs" ,"2020-11-26 03:04:19" ,"2020-12-18 04:39:13" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.55", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxuyqs", `obsdate`="2020-11-26 03:04:19", `reportAddedDate`="2020-12-18 04:39:13", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczi" ,"30" ,"g-ZTF" ,"0" ,"18.81" ,null ,"ABMag" ,"ZTF20acxkfoh" ,"2020-12-16 12:33:07" ,"2020-12-18 04:38:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.81", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxkfoh", `obsdate`="2020-12-16 12:33:07", `reportAddedDate`="2020-12-18 04:38:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczi" ,"30" ,"r-ZTF" ,"0" ,"18.09" ,null ,"ABMag" ,"ZTF20acxkfoh" ,"2020-12-13 12:01:26" ,"2020-12-18 04:38:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.09", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxkfoh", `obsdate`="2020-12-13 12:01:26", `reportAddedDate`="2020-12-18 04:38:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczg" ,"30" ,"g-ZTF" ,"0" ,"20.13" ,"0.2" ,"ABMag" ,"ZTF20acxzqyp" ,"2020-12-16 12:50:20" ,"2020-12-21 11:19:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.13", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxzqyp", `obsdate`="2020-12-16 12:50:20", `reportAddedDate`="2020-12-21 11:19:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczg" ,"30" ,"r-ZTF" ,"0" ,"20.31" ,"0.28" ,"ABMag" ,"ZTF20acxzqyp" ,"2020-12-16 09:13:13" ,"2020-12-21 11:19:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.31", `magErr`="0.28", `magUnit`="ABMag", `objectName`="ZTF20acxzqyp", `obsdate`="2020-12-16 09:13:13", `reportAddedDate`="2020-12-21 11:19:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczg" ,"30" ,"r-ZTF" ,"1" ,"20.1007" ,null ,"ABMag" ,"ZTF20acxzqyp" ,"2020-12-13 12:00:28" ,"2020-12-21 11:19:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1007", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxzqyp", `obsdate`="2020-12-13 12:00:28", `reportAddedDate`="2020-12-21 11:19:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczg" ,"30" ,"g-ZTF" ,"0" ,"18.43" ,null ,"ABMag" ,"ZTF20acxzqyp" ,"2020-12-19 11:52:48" ,"2020-12-19 12:37:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.43", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxzqyp", `obsdate`="2020-12-19 11:52:48", `reportAddedDate`="2020-12-19 12:37:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczg" ,"30" ,"r-ZTF" ,"0" ,"20.31" ,null ,"ABMag" ,"ZTF20acxzqyp" ,"2020-12-16 09:12:58" ,"2020-12-19 12:37:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.31", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxzqyp", `obsdate`="2020-12-16 09:12:58", `reportAddedDate`="2020-12-19 12:37:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczg" ,"30" ,"r-ZTF" ,"1" ,"20.1" ,null ,"ABMag" ,"ZTF20acxzqyp" ,"2020-12-13 12:00:00" ,"2020-12-19 12:37:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxzqyp", `obsdate`="2020-12-13 12:00:00", `reportAddedDate`="2020-12-19 12:37:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczg" ,"30" ,"cyan-ATLAS" ,"0" ,"19.322" ,"0.13" ,"ABMag" ,"ATLAS20binb" ,"2020-12-17 13:46:34" ,"2020-12-17 20:31:14" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.322", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ATLAS20binb", `obsdate`="2020-12-17 13:46:34", `reportAddedDate`="2020-12-17 20:31:14", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczg" ,"30" ,"cyan-ATLAS" ,"1" ,"19.76" ,null ,"ABMag" ,"ATLAS20binb" ,"2020-12-11 14:09:36" ,"2020-12-17 20:31:14" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczg", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.76", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20binb", `obsdate`="2020-12-11 14:09:36", `reportAddedDate`="2020-12-17 20:31:14", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczc" ,"30" ,"r-ZTF" ,"0" ,"19.47" ,"0.18" ,"ABMag" ,"ZTF20acxoocn" ,"2020-12-19 06:56:46" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.47", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acxoocn", `obsdate`="2020-12-19 06:56:46", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczc" ,"30" ,"r-ZTF" ,"0" ,"19.52" ,"0.15" ,"ABMag" ,"ZTF20acxoocn" ,"2020-12-17 05:41:57" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.52", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acxoocn", `obsdate`="2020-12-17 05:41:57", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczc" ,"30" ,"r-ZTF" ,"1" ,"19.8468" ,null ,"ABMag" ,"ZTF20acxoocn" ,"2020-12-15 05:07:37" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8468", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxoocn", `obsdate`="2020-12-15 05:07:37", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczc" ,"30" ,"r-ZTF" ,"0" ,"19.5203" ,"0.150912" ,"ABMag" ,"ZTF20acxoocn" ,"2020-12-17 05:41:57" ,"2020-12-17 17:22:47" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5203", `magErr`="0.150912", `magUnit`="ABMag", `objectName`="ZTF20acxoocn", `obsdate`="2020-12-17 05:41:57", `reportAddedDate`="2020-12-17 17:22:47", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczc" ,"30" ,"g-ZTF" ,"0" ,"20.2055" ,"0.33572" ,"ABMag" ,"ZTF20acxoocn" ,"2020-12-17 04:33:40" ,"2020-12-17 17:22:47" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2055", `magErr`="0.33572", `magUnit`="ABMag", `objectName`="ZTF20acxoocn", `obsdate`="2020-12-17 04:33:40", `reportAddedDate`="2020-12-17 17:22:47", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aczc" ,"30" ,"r-ZTF" ,"1" ,"19.8468" ,null ,"ABMag" ,"ZTF20acxoocn" ,"2020-12-15 05:07:37" ,"2020-12-17 17:22:47" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aczc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8468", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxoocn", `obsdate`="2020-12-15 05:07:37", `reportAddedDate`="2020-12-17 17:22:47", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acyw" ,"30" ,"r-ZTF" ,"0" ,"18.86" ,"0.11" ,"ABMag" ,"ZTF20acxnjzy" ,"2020-12-16 05:38:21" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acyw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.86", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acxnjzy", `obsdate`="2020-12-16 05:38:21", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acyw" ,"30" ,"g-ZTF" ,"0" ,"18.79" ,"0.09" ,"ABMag" ,"ZTF20acxnjzy" ,"2020-12-16 04:44:46" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acyw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.79", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acxnjzy", `obsdate`="2020-12-16 04:44:46", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acyw" ,"30" ,"g-ZTF" ,"1" ,"19.954" ,null ,"ABMag" ,"ZTF20acxnjzy" ,"2020-12-12 05:39:37" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acyw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.954", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxnjzy", `obsdate`="2020-12-12 05:39:37", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acyw" ,"30" ,"r-ZTF" ,"0" ,"18.86" ,null ,"ABMag" ,"ZTF20acxnjzy" ,"2020-12-16 05:38:24" ,"2020-12-18 04:39:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acyw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.86", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxnjzy", `obsdate`="2020-12-16 05:38:24", `reportAddedDate`="2020-12-18 04:39:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acyw" ,"30" ,"g-ZTF" ,"0" ,"18.79" ,null ,"ABMag" ,"ZTF20acxnjzy" ,"2020-12-16 04:45:07" ,"2020-12-18 04:39:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acyw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.79", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxnjzy", `obsdate`="2020-12-16 04:45:07", `reportAddedDate`="2020-12-18 04:39:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acyw" ,"30" ,"r-ZTF" ,"1" ,"18.33" ,null ,"ABMag" ,"ZTF20acxnjzy" ,"2020-12-14 05:41:17" ,"2020-12-18 04:39:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acyw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.33", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxnjzy", `obsdate`="2020-12-14 05:41:17", `reportAddedDate`="2020-12-18 04:39:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acyw" ,"30" ,"cyan-ATLAS" ,"0" ,"18.708" ,"0.132" ,"ABMag" ,"ATLAS20bilz" ,"2020-12-17 04:48:00" ,"2020-12-17 14:27:39" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acyw", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.708", `magErr`="0.132", `magUnit`="ABMag", `objectName`="ATLAS20bilz", `obsdate`="2020-12-17 04:48:00", `reportAddedDate`="2020-12-17 14:27:39", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acyw" ,"30" ,"cyan-ATLAS" ,"1" ,"19.6" ,null ,"ABMag" ,"ATLAS20bilz" ,"2020-12-11 06:14:24" ,"2020-12-17 14:27:39" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acyw", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.6", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bilz", `obsdate`="2020-12-11 06:14:24", `reportAddedDate`="2020-12-17 14:27:39", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acxf" ,"45" ,"i-Sloan" ,"0" ,"20.48" ,"0.1" ,"ABMag" ,"PS20mfc" ,"2020-12-07 15:00:00" ,"2020-12-18 19:47:13" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acxf", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.48", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS20mfc", `obsdate`="2020-12-07 15:00:00", `reportAddedDate`="2020-12-18 19:47:13", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acxf" ,"27" ,"g-Sloan" ,"0" ,"20.71" ,"0.21" ,"ABMag" ,"PS20mfc" ,"2020-12-07 14:29:46" ,"2020-12-16 20:38:59" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acxf", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="20.71", `magErr`="0.21", `magUnit`="ABMag", `objectName`="PS20mfc", `obsdate`="2020-12-07 14:29:46", `reportAddedDate`="2020-12-16 20:38:59", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwv" ,"30" ,"r-ZTF" ,"0" ,"18.89" ,"0.17" ,"ABMag" ,"ZTF20acxzsxb" ,"2020-12-16 13:24:34" ,"2020-12-20 14:19:41" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.89", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxzsxb", `obsdate`="2020-12-16 13:24:34", `reportAddedDate`="2020-12-20 14:19:41", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwv" ,"30" ,"r-ZTF" ,"0" ,"19" ,"0.16" ,"ABMag" ,"ZTF20acxzsxb" ,"2020-12-16 13:17:48" ,"2020-12-20 14:19:41" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acxzsxb", `obsdate`="2020-12-16 13:17:48", `reportAddedDate`="2020-12-20 14:19:41", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwv" ,"30" ,"r-ZTF" ,"0" ,"18.8941" ,"0.167299" ,"ABMag" ,"ZTF20acxzsxb" ,"2020-12-16 13:24:34" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.8941", `magErr`="0.167299", `magUnit`="ABMag", `objectName`="ZTF20acxzsxb", `obsdate`="2020-12-16 13:24:34", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwv" ,"30" ,"r-ZTF" ,"0" ,"18.9965" ,"0.160217" ,"ABMag" ,"ZTF20acxzsxb" ,"2020-12-16 13:17:48" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.9965", `magErr`="0.160217", `magUnit`="ABMag", `objectName`="ZTF20acxzsxb", `obsdate`="2020-12-16 13:17:48", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acws" ,"30" ,"g-ZTF" ,"0" ,"19.13" ,"0.13" ,"ABMag" ,"ZTF20acxyury" ,"2020-12-16 12:39:37" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acws", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.13", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxyury", `obsdate`="2020-12-16 12:39:37", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acws" ,"30" ,"r-ZTF" ,"0" ,"19.41" ,"0.14" ,"ABMag" ,"ZTF20acxyury" ,"2020-12-16 10:46:33" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acws", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.41", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acxyury", `obsdate`="2020-12-16 10:46:33", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acws" ,"30" ,"g-ZTF" ,"1" ,"20.0128" ,null ,"ABMag" ,"ZTF20acxyury" ,"2020-12-13 10:33:51" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acws", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.0128", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxyury", `obsdate`="2020-12-13 10:33:51", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acws" ,"30" ,"g-ZTF" ,"0" ,"19.1293" ,"0.129627" ,"ABMag" ,"ZTF20acxyury" ,"2020-12-16 12:39:37" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acws", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.1293", `magErr`="0.129627", `magUnit`="ABMag", `objectName`="ZTF20acxyury", `obsdate`="2020-12-16 12:39:37", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acws" ,"30" ,"r-ZTF" ,"0" ,"19.4089" ,"0.142359" ,"ABMag" ,"ZTF20acxyury" ,"2020-12-16 10:46:33" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acws", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4089", `magErr`="0.142359", `magUnit`="ABMag", `objectName`="ZTF20acxyury", `obsdate`="2020-12-16 10:46:33", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acws" ,"30" ,"g-ZTF" ,"1" ,"20.0128" ,null ,"ABMag" ,"ZTF20acxyury" ,"2020-12-13 10:33:51" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acws", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.0128", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxyury", `obsdate`="2020-12-13 10:33:51", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwk" ,"30" ,"g-ZTF" ,"0" ,"19.58" ,"0.13" ,"ABMag" ,"ZTF20acxunmt" ,"2020-12-16 04:11:29" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.58", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxunmt", `obsdate`="2020-12-16 04:11:29", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwk" ,"30" ,"r-ZTF" ,"0" ,"19.57" ,"0.2" ,"ABMag" ,"ZTF20acxunmt" ,"2020-12-16 03:16:15" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.57", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxunmt", `obsdate`="2020-12-16 03:16:15", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwk" ,"30" ,"r-ZTF" ,"1" ,"19.5755" ,null ,"ABMag" ,"ZTF20acxunmt" ,"2020-12-12 02:50:05" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5755", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxunmt", `obsdate`="2020-12-12 02:50:05", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwk" ,"30" ,"g-ZTF" ,"0" ,"19.576" ,"0.129126" ,"ABMag" ,"ZTF20acxunmt" ,"2020-12-16 04:11:29" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.576", `magErr`="0.129126", `magUnit`="ABMag", `objectName`="ZTF20acxunmt", `obsdate`="2020-12-16 04:11:29", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwk" ,"30" ,"r-ZTF" ,"0" ,"19.5744" ,"0.201431" ,"ABMag" ,"ZTF20acxunmt" ,"2020-12-16 03:16:15" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5744", `magErr`="0.201431", `magUnit`="ABMag", `objectName`="ZTF20acxunmt", `obsdate`="2020-12-16 03:16:15", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwk" ,"30" ,"r-ZTF" ,"1" ,"18.5699" ,null ,"ABMag" ,"ZTF20acxunmt" ,"2020-12-14 04:24:01" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.5699", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxunmt", `obsdate`="2020-12-14 04:24:01", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwg" ,"30" ,"r-ZTF" ,"0" ,"19.57" ,"0.2" ,"ABMag" ,"ZTF20acxilne" ,"2020-12-16 07:16:57" ,"2020-12-19 08:58:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.57", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxilne", `obsdate`="2020-12-16 07:16:57", `reportAddedDate`="2020-12-19 08:58:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwg" ,"30" ,"r-ZTF" ,"0" ,"20.06" ,"0.31" ,"ABMag" ,"ZTF20acxilne" ,"2020-12-13 09:16:25" ,"2020-12-19 08:58:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.06", `magErr`="0.31", `magUnit`="ABMag", `objectName`="ZTF20acxilne", `obsdate`="2020-12-13 09:16:25", `reportAddedDate`="2020-12-19 08:58:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwg" ,"30" ,"r-ZTF" ,"1" ,"20.3675" ,null ,"ABMag" ,"ZTF20acxilne" ,"2020-12-10 12:11:44" ,"2020-12-19 08:58:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.3675", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxilne", `obsdate`="2020-12-10 12:11:44", `reportAddedDate`="2020-12-19 08:58:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwg" ,"30" ,"g-ZTF" ,"0" ,"19.3523" ,"0.108379" ,"ABMag" ,"ZTF20acxilne" ,"2020-12-16 08:27:12" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.3523", `magErr`="0.108379", `magUnit`="ABMag", `objectName`="ZTF20acxilne", `obsdate`="2020-12-16 08:27:12", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwg" ,"30" ,"r-ZTF" ,"0" ,"19.5715" ,"0.203686" ,"ABMag" ,"ZTF20acxilne" ,"2020-12-16 07:16:57" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5715", `magErr`="0.203686", `magUnit`="ABMag", `objectName`="ZTF20acxilne", `obsdate`="2020-12-16 07:16:57", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwg" ,"30" ,"g-ZTF" ,"0" ,"19.995" ,"0.240623" ,"ABMag" ,"ZTF20acxilne" ,"2020-12-13 09:44:30" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.995", `magErr`="0.240623", `magUnit`="ABMag", `objectName`="ZTF20acxilne", `obsdate`="2020-12-13 09:44:30", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwg" ,"30" ,"r-ZTF" ,"0" ,"20.0595" ,"0.307647" ,"ABMag" ,"ZTF20acxilne" ,"2020-12-13 09:16:25" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0595", `magErr`="0.307647", `magUnit`="ABMag", `objectName`="ZTF20acxilne", `obsdate`="2020-12-13 09:16:25", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwg" ,"30" ,"r-ZTF" ,"1" ,"20.3675" ,null ,"ABMag" ,"ZTF20acxilne" ,"2020-12-10 12:11:44" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.3675", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxilne", `obsdate`="2020-12-10 12:11:44", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwd" ,"30" ,"r-ZTF" ,"0" ,"19.52" ,"0.15" ,"ABMag" ,"ZTF20acxuloz" ,"2020-12-16 03:05:45" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.52", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acxuloz", `obsdate`="2020-12-16 03:05:45", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwd" ,"30" ,"g-ZTF" ,"0" ,"20.11" ,"0.22" ,"ABMag" ,"ZTF20acxuloz" ,"2020-12-12 03:59:57" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.11", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acxuloz", `obsdate`="2020-12-12 03:59:57", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwd" ,"30" ,"r-ZTF" ,"1" ,"19.5763" ,null ,"ABMag" ,"ZTF20acxuloz" ,"2020-12-05 05:46:54" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5763", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxuloz", `obsdate`="2020-12-05 05:46:54", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwd" ,"30" ,"r-ZTF" ,"0" ,"19.52" ,"0.15" ,"ABMag" ,"ZTF20acxuloz" ,"2020-12-16 03:05:45" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.52", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acxuloz", `obsdate`="2020-12-16 03:05:45", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwd" ,"30" ,"g-ZTF" ,"0" ,"20.11" ,"0.22" ,"ABMag" ,"ZTF20acxuloz" ,"2020-12-12 03:59:57" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.11", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acxuloz", `obsdate`="2020-12-12 03:59:57", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwd" ,"30" ,"r-ZTF" ,"1" ,"19.5763" ,null ,"ABMag" ,"ZTF20acxuloz" ,"2020-12-05 05:46:54" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5763", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxuloz", `obsdate`="2020-12-05 05:46:54", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwd" ,"30" ,"r-ZTF" ,"0" ,"19.5217" ,"0.14677" ,"ABMag" ,"ZTF20acxuloz" ,"2020-12-16 03:05:45" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5217", `magErr`="0.14677", `magUnit`="ABMag", `objectName`="ZTF20acxuloz", `obsdate`="2020-12-16 03:05:45", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwd" ,"30" ,"g-ZTF" ,"0" ,"20.1102" ,"0.220334" ,"ABMag" ,"ZTF20acxuloz" ,"2020-12-12 03:59:57" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1102", `magErr`="0.220334", `magUnit`="ABMag", `objectName`="ZTF20acxuloz", `obsdate`="2020-12-12 03:59:57", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acwd" ,"30" ,"r-ZTF" ,"1" ,"18.8013" ,null ,"ABMag" ,"ZTF20acxuloz" ,"2020-12-10 02:52:20" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acwd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.8013", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxuloz", `obsdate`="2020-12-10 02:52:20", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"g-ZTF" ,"0" ,"19.7" ,"0.19" ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-12 03:36:16" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-12 03:36:16", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"r-ZTF" ,"0" ,"19.86" ,"0.22" ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-10 05:30:13" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.86", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-10 05:30:13", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"r-ZTF" ,"1" ,"19.8538" ,null ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-06 04:31:47" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8538", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-06 04:31:47", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"g-ZTF" ,"0" ,"19.4654" ,"0.198051" ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-16 04:34:20" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4654", `magErr`="0.198051", `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-16 04:34:20", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"r-ZTF" ,"0" ,"19.7818" ,"0.249714" ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-16 03:02:20" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7818", `magErr`="0.249714", `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-16 03:02:20", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"r-ZTF" ,"0" ,"19.8359" ,"0.181115" ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-12 04:45:26" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8359", `magErr`="0.181115", `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-12 04:45:26", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"g-ZTF" ,"0" ,"19.6971" ,"0.191259" ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-12 03:36:16" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6971", `magErr`="0.191259", `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-12 03:36:16", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"r-ZTF" ,"0" ,"19.8552" ,"0.215204" ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-10 05:30:13" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8552", `magErr`="0.215204", `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-10 05:30:13", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"g-ZTF" ,"0" ,"19.896" ,"0.262922" ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-10 04:03:43" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.896", `magErr`="0.262922", `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-10 04:03:43", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvt" ,"30" ,"r-ZTF" ,"1" ,"19.8538" ,null ,"ABMag" ,"ZTF20acxaqar" ,"2020-12-06 04:31:47" ,"2020-12-16 20:15:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvt", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8538", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxaqar", `obsdate`="2020-12-06 04:31:47", `reportAddedDate`="2020-12-16 20:15:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvm" ,"30" ,"cyan-ATLAS" ,"0" ,"18.97" ,"0.109" ,"ABMag" ,"ATLAS20bikz" ,"2020-12-14 14:38:24" ,"2020-12-20 18:54:09" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.97", `magErr`="0.109", `magUnit`="ABMag", `objectName`="ATLAS20bikz", `obsdate`="2020-12-14 14:38:24", `reportAddedDate`="2020-12-20 18:54:09", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvm" ,"30" ,"orange-ATLAS" ,"1" ,"18.99" ,null ,"ABMag" ,"ATLAS20bikz" ,"2020-12-08 15:47:31" ,"2020-12-20 18:54:09" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvm", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.99", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bikz", `obsdate`="2020-12-08 15:47:31", `reportAddedDate`="2020-12-20 18:54:09", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvm" ,"30" ,"g-ZTF" ,"0" ,"18.38" ,"0.08" ,"ABMag" ,"ZTF20acxzkkf" ,"2020-12-16 12:59:00" ,"2020-12-16 13:58:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.38", `magErr`="0.08", `magUnit`="ABMag", `objectName`="ZTF20acxzkkf", `obsdate`="2020-12-16 12:59:00", `reportAddedDate`="2020-12-16 13:58:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvm" ,"30" ,"r-ZTF" ,"0" ,"18.48" ,"0.08" ,"ABMag" ,"ZTF20acxzkkf" ,"2020-12-16 12:26:33" ,"2020-12-16 13:58:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.48", `magErr`="0.08", `magUnit`="ABMag", `objectName`="ZTF20acxzkkf", `obsdate`="2020-12-16 12:26:33", `reportAddedDate`="2020-12-16 13:58:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvm" ,"30" ,"g-ZTF" ,"1" ,"19.7108" ,null ,"ABMag" ,"ZTF20acxzkkf" ,"2020-12-05 13:01:47" ,"2020-12-16 13:58:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7108", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxzkkf", `obsdate`="2020-12-05 13:01:47", `reportAddedDate`="2020-12-16 13:58:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvi" ,"30" ,"g-ZTF" ,"0" ,"19.7664" ,"0.160917" ,"ABMag" ,"ZTF20acwobyt" ,"2020-12-11 10:44:43" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7664", `magErr`="0.160917", `magUnit`="ABMag", `objectName`="ZTF20acwobyt", `obsdate`="2020-12-11 10:44:43", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvi" ,"30" ,"g-ZTF" ,"1" ,"18.4992" ,null ,"ABMag" ,"ZTF20acwobyt" ,"2020-12-09 09:56:20" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.4992", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwobyt", `obsdate`="2020-12-09 09:56:20", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvi" ,"30" ,"r-ZTF" ,"0" ,"20.01" ,"0.2" ,"ABMag" ,"ZTF20acwobyt" ,"2020-12-11 11:22:22" ,"2020-12-16 10:58:16" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.01", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acwobyt", `obsdate`="2020-12-11 11:22:22", `reportAddedDate`="2020-12-16 10:58:16", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvi" ,"30" ,"g-ZTF" ,"0" ,"19.77" ,"0.16" ,"ABMag" ,"ZTF20acwobyt" ,"2020-12-11 10:44:43" ,"2020-12-16 10:58:16" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.77", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acwobyt", `obsdate`="2020-12-11 10:44:43", `reportAddedDate`="2020-12-16 10:58:16", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvi" ,"30" ,"g-ZTF" ,"1" ,"19.791" ,null ,"ABMag" ,"ZTF20acwobyt" ,"2020-12-06 11:54:45" ,"2020-12-16 10:58:16" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.791", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwobyt", `obsdate`="2020-12-06 11:54:45", `reportAddedDate`="2020-12-16 10:58:16", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvg" ,"30" ,"r-ZTF" ,"0" ,"19.4" ,"0.11" ,"ABMag" ,"ZTF20acxntom" ,"2020-12-19 03:15:06" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acxntom", `obsdate`="2020-12-19 03:15:06", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvg" ,"30" ,"g-ZTF" ,"0" ,"19.4" ,"0.11" ,"ABMag" ,"ZTF20acxntom" ,"2020-12-16 04:50:15" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acxntom", `obsdate`="2020-12-16 04:50:15", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvg" ,"30" ,"r-ZTF" ,"1" ,"20.5239" ,null ,"ABMag" ,"ZTF20acxntom" ,"2020-12-12 05:10:27" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.5239", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxntom", `obsdate`="2020-12-12 05:10:27", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvg" ,"30" ,"cyan-ATLAS" ,"0" ,"19.416" ,"0.141" ,"ABMag" ,"ATLAS20bima" ,"2020-12-17 06:30:14" ,"2020-12-17 14:29:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvg", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.416", `magErr`="0.141", `magUnit`="ABMag", `objectName`="ATLAS20bima", `obsdate`="2020-12-17 06:30:14", `reportAddedDate`="2020-12-17 14:29:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvg" ,"30" ,"cyan-ATLAS" ,"1" ,"19.76" ,null ,"ABMag" ,"ATLAS20bima" ,"2020-12-11 07:52:19" ,"2020-12-17 14:29:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvg", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.76", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bima", `obsdate`="2020-12-11 07:52:19", `reportAddedDate`="2020-12-17 14:29:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvg" ,"360" ,"L-GOTO" ,"0" ,"20.1" ,"0.14" ,"ABMag" ,"GOTO20bbf" ,"2020-12-15 20:17:38" ,"2020-12-16 10:04:46" ,"GOTO" ,"PSN" ,"GOTO" ,"GOTO-N_GOTO-1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvg", `exptime`="360", `filter`="L-GOTO", `limitingMag`="0", `mag`="20.1", `magErr`="0.14", `magUnit`="ABMag", `objectName`="GOTO20bbf", `obsdate`="2020-12-15 20:17:38", `reportAddedDate`="2020-12-16 10:04:46", `reportingGroup`="GOTO", `suggestedType`="PSN", `survey`="GOTO", `telescope`="GOTO-N_GOTO-1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acvg" ,"360" ,"L-GOTO" ,"1" ,"20.5" ,null ,"ABMag" ,"GOTO20bbf" ,"2020-12-13 23:00:28" ,"2020-12-16 10:04:46" ,"GOTO" ,"PSN" ,"GOTO" ,"GOTO-N_GOTO-1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acvg", `exptime`="360", `filter`="L-GOTO", `limitingMag`="1", `mag`="20.5", `magErr`=null, `magUnit`="ABMag", `objectName`="GOTO20bbf", `obsdate`="2020-12-13 23:00:28", `reportAddedDate`="2020-12-16 10:04:46", `reportingGroup`="GOTO", `suggestedType`="PSN", `survey`="GOTO", `telescope`="GOTO-N_GOTO-1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acur" ,"30" ,"g-ZTF" ,"0" ,"20.6054" ,"0.424982" ,"ABMag" ,"ZTF20acwscli" ,"2020-12-06 03:10:18" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acur", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.6054", `magErr`="0.424982", `magUnit`="ABMag", `objectName`="ZTF20acwscli", `obsdate`="2020-12-06 03:10:18", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acur" ,"30" ,"g-ZTF" ,"1" ,"20.3092" ,null ,"ABMag" ,"ZTF20acwscli" ,"2020-12-04 03:00:28" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acur", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3092", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwscli", `obsdate`="2020-12-04 03:00:28", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acur" ,"30" ,"g-ZTF" ,"0" ,"19.36" ,"0.17" ,"ABMag" ,"ZTF20acwscli" ,"2020-12-11 04:58:41" ,"2020-12-16 02:57:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acur", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.36", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acwscli", `obsdate`="2020-12-11 04:58:41", `reportAddedDate`="2020-12-16 02:57:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acur" ,"30" ,"r-ZTF" ,"0" ,"19.42" ,"0.12" ,"ABMag" ,"ZTF20acwscli" ,"2020-12-11 03:27:31" ,"2020-12-16 02:57:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acur", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.42", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acwscli", `obsdate`="2020-12-11 03:27:31", `reportAddedDate`="2020-12-16 02:57:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acur" ,"30" ,"r-ZTF" ,"1" ,"19.9068" ,null ,"ABMag" ,"ZTF20acwscli" ,"2020-12-04 03:34:07" ,"2020-12-16 02:57:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acur", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.9068", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwscli", `obsdate`="2020-12-04 03:34:07", `reportAddedDate`="2020-12-16 02:57:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuo" ,"30" ,"r-ZTF" ,"0" ,"19.3" ,"0.22" ,"ABMag" ,"ZTF20acxtfqs" ,"2020-12-15 13:24:23" ,"2020-12-21 14:18:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.3", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acxtfqs", `obsdate`="2020-12-15 13:24:23", `reportAddedDate`="2020-12-21 14:18:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuo" ,"30" ,"r-ZTF" ,"0" ,"19.23" ,"0.22" ,"ABMag" ,"ZTF20acxtfqs" ,"2020-12-15 13:17:36" ,"2020-12-21 14:18:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.23", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acxtfqs", `obsdate`="2020-12-15 13:17:36", `reportAddedDate`="2020-12-21 14:18:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuo" ,"30" ,"r-ZTF" ,"0" ,"18.9367" ,"0.175829" ,"ABMag" ,"ZTF20acxtfqs" ,"2020-12-15 13:31:11" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.9367", `magErr`="0.175829", `magUnit`="ABMag", `objectName`="ZTF20acxtfqs", `obsdate`="2020-12-15 13:31:11", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuo" ,"30" ,"r-ZTF" ,"0" ,"19.3016" ,"0.215261" ,"ABMag" ,"ZTF20acxtfqs" ,"2020-12-15 13:24:23" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.3016", `magErr`="0.215261", `magUnit`="ABMag", `objectName`="ZTF20acxtfqs", `obsdate`="2020-12-15 13:24:23", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuo" ,"30" ,"r-ZTF" ,"0" ,"19.2316" ,"0.215548" ,"ABMag" ,"ZTF20acxtfqs" ,"2020-12-15 13:17:36" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2316", `magErr`="0.215548", `magUnit`="ABMag", `objectName`="ZTF20acxtfqs", `obsdate`="2020-12-15 13:17:36", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acun" ,"30" ,"r-ZTF" ,"0" ,"19.14" ,"0.2" ,"ABMag" ,"ZTF20acxtgek" ,"2020-12-16 13:25:15" ,"2020-12-19 13:58:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acun", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.14", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxtgek", `obsdate`="2020-12-16 13:25:15", `reportAddedDate`="2020-12-19 13:58:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acun" ,"30" ,"r-ZTF" ,"0" ,"19.2" ,"0.17" ,"ABMag" ,"ZTF20acxtgek" ,"2020-12-16 13:18:29" ,"2020-12-19 13:58:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acun", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxtgek", `obsdate`="2020-12-16 13:18:29", `reportAddedDate`="2020-12-19 13:58:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acun" ,"30" ,"r-ZTF" ,"0" ,"19.3245" ,"0.18943" ,"ABMag" ,"ZTF20acxtgek" ,"2020-12-15 13:23:43" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acun", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.3245", `magErr`="0.18943", `magUnit`="ABMag", `objectName`="ZTF20acxtgek", `obsdate`="2020-12-15 13:23:43", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acun" ,"30" ,"r-ZTF" ,"0" ,"19.5069" ,"0.255122" ,"ABMag" ,"ZTF20acxtgek" ,"2020-12-15 13:16:55" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acun", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5069", `magErr`="0.255122", `magUnit`="ABMag", `objectName`="ZTF20acxtgek", `obsdate`="2020-12-15 13:16:55", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuk" ,"30" ,"r-ZTF" ,"0" ,"19.71" ,"0.26" ,"ABMag" ,"ZTF20acxteqx" ,"2020-12-17 13:02:49" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.71", `magErr`="0.26", `magUnit`="ABMag", `objectName`="ZTF20acxteqx", `obsdate`="2020-12-17 13:02:49", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuk" ,"30" ,"g-ZTF" ,"0" ,"19.82" ,"0.21" ,"ABMag" ,"ZTF20acxteqx" ,"2020-12-15 13:02:28" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.82", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF20acxteqx", `obsdate`="2020-12-15 13:02:28", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuk" ,"30" ,"r-ZTF" ,"1" ,"19.6627" ,null ,"ABMag" ,"ZTF20acxteqx" ,"2020-12-15 12:00:24" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6627", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxteqx", `obsdate`="2020-12-15 12:00:24", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuk" ,"30" ,"g-ZTF" ,"0" ,"19.82" ,"0.205497" ,"ABMag" ,"ZTF20acxteqx" ,"2020-12-15 13:02:28" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.82", `magErr`="0.205497", `magUnit`="ABMag", `objectName`="ZTF20acxteqx", `obsdate`="2020-12-15 13:02:28", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuk" ,"30" ,"r-ZTF" ,"1" ,"19.6627" ,null ,"ABMag" ,"ZTF20acxteqx" ,"2020-12-15 12:00:24" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6627", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxteqx", `obsdate`="2020-12-15 12:00:24", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acui" ,"30" ,"g-ZTF" ,"0" ,"19.47" ,"0.19" ,"ABMag" ,"ZTF20acxtdst" ,"2020-12-16 13:03:58" ,"2020-12-19 13:58:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acui", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.47", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acxtdst", `obsdate`="2020-12-16 13:03:58", `reportAddedDate`="2020-12-19 13:58:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acui" ,"30" ,"g-ZTF" ,"0" ,"19.62" ,"0.17" ,"ABMag" ,"ZTF20acxtdst" ,"2020-12-15 12:57:00" ,"2020-12-19 13:58:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acui", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.62", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxtdst", `obsdate`="2020-12-15 12:57:00", `reportAddedDate`="2020-12-19 13:58:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acui" ,"30" ,"r-ZTF" ,"1" ,"19.5986" ,null ,"ABMag" ,"ZTF20acxtdst" ,"2020-12-15 11:55:00" ,"2020-12-19 13:58:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acui", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5986", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxtdst", `obsdate`="2020-12-15 11:55:00", `reportAddedDate`="2020-12-19 13:58:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acui" ,"30" ,"g-ZTF" ,"0" ,"19.6185" ,"0.174947" ,"ABMag" ,"ZTF20acxtdst" ,"2020-12-15 12:57:00" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acui", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6185", `magErr`="0.174947", `magUnit`="ABMag", `objectName`="ZTF20acxtdst", `obsdate`="2020-12-15 12:57:00", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acui" ,"30" ,"r-ZTF" ,"1" ,"19.5986" ,null ,"ABMag" ,"ZTF20acxtdst" ,"2020-12-15 11:55:00" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acui", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5986", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxtdst", `obsdate`="2020-12-15 11:55:00", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acug" ,"30" ,"r-ZTF" ,"0" ,"19.32" ,"0.2" ,"ABMag" ,"ZTF20acxtdcm" ,"2020-12-17 12:37:22" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acug", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.32", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxtdcm", `obsdate`="2020-12-17 12:37:22", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acug" ,"30" ,"g-ZTF" ,"0" ,"19.27" ,"0.26" ,"ABMag" ,"ZTF20acxtdcm" ,"2020-12-17 10:46:26" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acug", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.27", `magErr`="0.26", `magUnit`="ABMag", `objectName`="ZTF20acxtdcm", `obsdate`="2020-12-17 10:46:26", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acug" ,"30" ,"r-ZTF" ,"1" ,"20.0213" ,null ,"ABMag" ,"ZTF20acxtdcm" ,"2020-12-15 11:05:57" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acug", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0213", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxtdcm", `obsdate`="2020-12-15 11:05:57", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acug" ,"30" ,"g-ZTF" ,"0" ,"20.0394" ,"0.187008" ,"ABMag" ,"ZTF20acxtdcm" ,"2020-12-15 12:38:38" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acug", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0394", `magErr`="0.187008", `magUnit`="ABMag", `objectName`="ZTF20acxtdcm", `obsdate`="2020-12-15 12:38:38", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acug" ,"30" ,"r-ZTF" ,"1" ,"20.0213" ,null ,"ABMag" ,"ZTF20acxtdcm" ,"2020-12-15 11:05:57" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acug", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0213", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxtdcm", `obsdate`="2020-12-15 11:05:57", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"r-ZTF" ,"0" ,"19.49" ,"0.16" ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-20 12:25:46" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.49", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-20 12:25:46", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"r-ZTF" ,"0" ,"19.16" ,"0.14" ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-17 13:03:30" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.16", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-17 13:03:30", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"g-ZTF" ,"1" ,"20.2776" ,null ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-15 13:03:51" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.2776", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-15 13:03:51", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"r-ZTF" ,"0" ,"19.5295" ,"0.190354" ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-15 11:59:03" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5295", `magErr`="0.190354", `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-15 11:59:03", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"g-ZTF" ,"1" ,"19.9541" ,null ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-11 13:02:39" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.9541", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-11 13:02:39", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acua" ,"30" ,"g-ZTF" ,"0" ,"18.29" ,"0.07" ,"ABMag" ,"ZTF18aahfbqp" ,"2020-12-15 12:23:39" ,"2020-12-20 11:58:58" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acua", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.29", `magErr`="0.07", `magUnit`="ABMag", `objectName`="ZTF18aahfbqp", `obsdate`="2020-12-15 12:23:39", `reportAddedDate`="2020-12-20 11:58:58", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acua" ,"30" ,"r-ZTF" ,"0" ,"18.33" ,"0.11" ,"ABMag" ,"ZTF18aahfbqp" ,"2020-12-15 11:27:21" ,"2020-12-20 11:58:58" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acua", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.33", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF18aahfbqp", `obsdate`="2020-12-15 11:27:21", `reportAddedDate`="2020-12-20 11:58:58", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acua" ,"30" ,"g-ZTF" ,"1" ,"20.5665" ,null ,"ABMag" ,"ZTF18aahfbqp" ,"2020-12-11 10:41:07" ,"2020-12-20 11:58:58" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acua", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.5665", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18aahfbqp", `obsdate`="2020-12-11 10:41:07", `reportAddedDate`="2020-12-20 11:58:58", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acua" ,"30" ,"g-ZTF" ,"0" ,"18.2894" ,"0.0742468" ,"ABMag" ,"ZTF18aahfbqp" ,"2020-12-15 12:23:39" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acua", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.2894", `magErr`="0.0742468", `magUnit`="ABMag", `objectName`="ZTF18aahfbqp", `obsdate`="2020-12-15 12:23:39", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acua" ,"30" ,"r-ZTF" ,"0" ,"18.3259" ,"0.109834" ,"ABMag" ,"ZTF18aahfbqp" ,"2020-12-15 11:27:21" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acua", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.3259", `magErr`="0.109834", `magUnit`="ABMag", `objectName`="ZTF18aahfbqp", `obsdate`="2020-12-15 11:27:21", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acua" ,"30" ,"g-ZTF" ,"1" ,"20.5665" ,null ,"ABMag" ,"ZTF18aahfbqp" ,"2020-12-11 10:41:07" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acua", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.5665", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18aahfbqp", `obsdate`="2020-12-11 10:41:07", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acty" ,"30" ,"r-ZTF" ,"0" ,"19.85" ,"0.14" ,"ABMag" ,"ZTF20acxqxyw" ,"2020-12-15 10:38:58" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acty", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.85", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acxqxyw", `obsdate`="2020-12-15 10:38:58", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acty" ,"30" ,"g-ZTF" ,"0" ,"20.2" ,"0.2" ,"ABMag" ,"ZTF20acxqxyw" ,"2020-12-15 09:27:02" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acty", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxqxyw", `obsdate`="2020-12-15 09:27:02", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acty" ,"30" ,"r-ZTF" ,"1" ,"20.528" ,null ,"ABMag" ,"ZTF20acxqxyw" ,"2020-12-10 11:43:50" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acty", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.528", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxqxyw", `obsdate`="2020-12-10 11:43:50", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acty" ,"27" ,"g-Sloan" ,"0" ,"19.54" ,"0.08" ,"ABMag" ,"PS20mhf" ,"2020-12-17 13:46:34" ,"2020-12-17 16:07:36" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acty", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="19.54", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS20mhf", `obsdate`="2020-12-17 13:46:34", `reportAddedDate`="2020-12-17 16:07:36", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acty" ,"30" ,"r-ZTF" ,"0" ,"19.8519" ,"0.144501" ,"ABMag" ,"ZTF20acxqxyw" ,"2020-12-15 10:38:58" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acty", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8519", `magErr`="0.144501", `magUnit`="ABMag", `objectName`="ZTF20acxqxyw", `obsdate`="2020-12-15 10:38:58", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acty" ,"30" ,"g-ZTF" ,"0" ,"20.2009" ,"0.19556" ,"ABMag" ,"ZTF20acxqxyw" ,"2020-12-15 09:27:02" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acty", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2009", `magErr`="0.19556", `magUnit`="ABMag", `objectName`="ZTF20acxqxyw", `obsdate`="2020-12-15 09:27:02", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acty" ,"30" ,"r-ZTF" ,"1" ,"19.32" ,null ,"ABMag" ,"ZTF20acxqxyw" ,"2020-12-12 11:15:10" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acty", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.32", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxqxyw", `obsdate`="2020-12-12 11:15:10", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actn" ,"27" ,"g-Sloan" ,"0" ,"20.17" ,"0.1" ,"ABMag" ,"PS20mhy" ,"2020-12-11 15:25:55" ,"2020-12-18 18:23:55" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actn", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="20.17", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS20mhy", `obsdate`="2020-12-11 15:25:55", `reportAddedDate`="2020-12-18 18:23:55", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actn" ,"30" ,"g-ZTF" ,"0" ,"19.8892" ,"0.191289" ,"ABMag" ,"ZTF20acxfdjs" ,"2020-12-15 12:36:33" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8892", `magErr`="0.191289", `magUnit`="ABMag", `objectName`="ZTF20acxfdjs", `obsdate`="2020-12-15 12:36:33", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actn" ,"30" ,"r-ZTF" ,"0" ,"19.8565" ,"0.219708" ,"ABMag" ,"ZTF20acxfdjs" ,"2020-12-15 11:35:17" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8565", `magErr`="0.219708", `magUnit`="ABMag", `objectName`="ZTF20acxfdjs", `obsdate`="2020-12-15 11:35:17", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actn" ,"30" ,"g-ZTF" ,"0" ,"19.8178" ,"0.206457" ,"ABMag" ,"ZTF20acxfdjs" ,"2020-12-12 12:37:01" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8178", `magErr`="0.206457", `magUnit`="ABMag", `objectName`="ZTF20acxfdjs", `obsdate`="2020-12-12 12:37:01", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actn" ,"30" ,"r-ZTF" ,"1" ,"20.0471" ,null ,"ABMag" ,"ZTF20acxfdjs" ,"2020-12-12 11:39:58" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0471", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxfdjs", `obsdate`="2020-12-12 11:39:58", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actc" ,"30" ,"g-ZTF" ,"0" ,"19.69" ,"0.3" ,"ABMag" ,"ZTF20acxtaau" ,"2020-12-17 10:42:14" ,"2020-12-20 10:58:55" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.69", `magErr`="0.3", `magUnit`="ABMag", `objectName`="ZTF20acxtaau", `obsdate`="2020-12-17 10:42:14", `reportAddedDate`="2020-12-20 10:58:55", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actc" ,"30" ,"g-ZTF" ,"0" ,"19.81" ,"0.18" ,"ABMag" ,"ZTF20acxtaau" ,"2020-12-15 12:25:00" ,"2020-12-20 10:58:55" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.81", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acxtaau", `obsdate`="2020-12-15 12:25:00", `reportAddedDate`="2020-12-20 10:58:55", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actc" ,"30" ,"r-ZTF" ,"1" ,"20.2163" ,null ,"ABMag" ,"ZTF20acxtaau" ,"2020-12-15 11:28:02" ,"2020-12-20 10:58:55" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.2163", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxtaau", `obsdate`="2020-12-15 11:28:02", `reportAddedDate`="2020-12-20 10:58:55", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actc" ,"30" ,"g-ZTF" ,"0" ,"19.8065" ,"0.18351" ,"ABMag" ,"ZTF20acxtaau" ,"2020-12-15 12:25:00" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8065", `magErr`="0.18351", `magUnit`="ABMag", `objectName`="ZTF20acxtaau", `obsdate`="2020-12-15 12:25:00", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actc" ,"30" ,"g-ZTF" ,"0" ,"20.1343" ,"0.217987" ,"ABMag" ,"ZTF20acxtaau" ,"2020-12-11 10:40:27" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1343", `magErr`="0.217987", `magUnit`="ABMag", `objectName`="ZTF20acxtaau", `obsdate`="2020-12-11 10:40:27", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020actc" ,"30" ,"g-ZTF" ,"1" ,"19.7707" ,null ,"ABMag" ,"ZTF20acxtaau" ,"2020-12-09 12:58:02" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020actc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7707", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxtaau", `obsdate`="2020-12-09 12:58:02", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsz" ,"30" ,"r-ZTF" ,"0" ,"19.54" ,"0.28" ,"ABMag" ,"ZTF20acxtfta" ,"2020-12-16 13:35:25" ,"2020-12-21 14:18:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.54", `magErr`="0.28", `magUnit`="ABMag", `objectName`="ZTF20acxtfta", `obsdate`="2020-12-16 13:35:25", `reportAddedDate`="2020-12-21 14:18:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsz" ,"30" ,"r-ZTF" ,"0" ,"19.73" ,"0.27" ,"ABMag" ,"ZTF20acxtfta" ,"2020-12-11 13:22:38" ,"2020-12-21 14:18:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.73", `magErr`="0.27", `magUnit`="ABMag", `objectName`="ZTF20acxtfta", `obsdate`="2020-12-11 13:22:38", `reportAddedDate`="2020-12-21 14:18:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsz" ,"30" ,"r-ZTF" ,"0" ,"19.681" ,"0.211179" ,"ABMag" ,"ZTF20acxtfta" ,"2020-12-15 13:20:18" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.681", `magErr`="0.211179", `magUnit`="ABMag", `objectName`="ZTF20acxtfta", `obsdate`="2020-12-15 13:20:18", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsz" ,"30" ,"r-ZTF" ,"0" ,"19.4774" ,"0.335147" ,"ABMag" ,"ZTF20acxtfta" ,"2020-12-13 13:23:21" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4774", `magErr`="0.335147", `magUnit`="ABMag", `objectName`="ZTF20acxtfta", `obsdate`="2020-12-13 13:23:21", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsz" ,"30" ,"r-ZTF" ,"0" ,"19.7315" ,"0.269937" ,"ABMag" ,"ZTF20acxtfta" ,"2020-12-11 13:22:38" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7315", `magErr`="0.269937", `magUnit`="ABMag", `objectName`="ZTF20acxtfta", `obsdate`="2020-12-11 13:22:38", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsz" ,"30" ,"r-ZTF" ,"0" ,"19.7399" ,"0.266546" ,"ABMag" ,"ZTF20acxtfta" ,"2020-12-10 13:22:37" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7399", `magErr`="0.266546", `magUnit`="ABMag", `objectName`="ZTF20acxtfta", `obsdate`="2020-12-10 13:22:37", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsz" ,"30" ,"r-ZTF" ,"1" ,"19.4554" ,null ,"ABMag" ,"ZTF20acxtfta" ,"2020-12-10 13:15:51" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.4554", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxtfta", `obsdate`="2020-12-10 13:15:51", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"g-ZTF" ,"0" ,"19.86" ,"0.2" ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-15 12:12:41" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.86", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-15 12:12:41", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"g-ZTF" ,"0" ,"19.82" ,"0.16" ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-15 12:12:00" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.82", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-15 12:12:00", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"r-ZTF" ,"1" ,"20.449" ,null ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-10 12:38:17" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.449", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-10 12:38:17", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"g-ZTF" ,"0" ,"19.8634" ,"0.198721" ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-15 12:12:41" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8634", `magErr`="0.198721", `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-15 12:12:41", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"g-ZTF" ,"0" ,"19.8174" ,"0.162872" ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-15 12:12:00" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8174", `magErr`="0.162872", `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-15 12:12:00", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"r-ZTF" ,"0" ,"20.0304" ,"0.2583" ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-15 11:12:57" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0304", `magErr`="0.2583", `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-15 11:12:57", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"g-ZTF" ,"0" ,"20.456" ,"0.307049" ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-11 12:58:48" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.456", `magErr`="0.307049", `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-11 12:58:48", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"r-ZTF" ,"0" ,"20.5548" ,"0.326556" ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-11 11:53:42" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.5548", `magErr`="0.326556", `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-11 11:53:42", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"g-ZTF" ,"0" ,"20.6592" ,"0.289203" ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-10 10:38:51" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.6592", `magErr`="0.289203", `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-10 10:38:51", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acss" ,"30" ,"g-ZTF" ,"1" ,"17.6902" ,null ,"ABMag" ,"ZTF20acxsyvj" ,"2020-12-09 12:38:46" ,"2020-12-15 22:03:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acss", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="17.6902", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxsyvj", `obsdate`="2020-12-09 12:38:46", `reportAddedDate`="2020-12-15 22:03:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsn" ,"30" ,"g-ZTF" ,"0" ,"18.76" ,"0.11" ,"ABMag" ,"ZTF20acxnafa" ,"2020-12-16 03:54:38" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.76", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acxnafa", `obsdate`="2020-12-16 03:54:38", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsn" ,"30" ,"r-ZTF" ,"0" ,"18.99" ,"0.08" ,"ABMag" ,"ZTF20acxnafa" ,"2020-12-16 02:48:23" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.99", `magErr`="0.08", `magUnit`="ABMag", `objectName`="ZTF20acxnafa", `obsdate`="2020-12-16 02:48:23", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsn" ,"30" ,"g-ZTF" ,"1" ,"19.5223" ,null ,"ABMag" ,"ZTF20acxnafa" ,"2020-12-12 03:18:41" ,"2020-12-21 03:18:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.5223", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxnafa", `obsdate`="2020-12-12 03:18:41", `reportAddedDate`="2020-12-21 03:18:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsn" ,"30" ,"cyan-ATLAS" ,"0" ,"19.531" ,"0.154" ,"ABMag" ,"ATLAS20biko" ,"2020-12-14 06:24:29" ,"2020-12-15 21:52:52" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsn", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.531", `magErr`="0.154", `magUnit`="ABMag", `objectName`="ATLAS20biko", `obsdate`="2020-12-14 06:24:29", `reportAddedDate`="2020-12-15 21:52:52", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acsn" ,"30" ,"cyan-ATLAS" ,"1" ,"19.64" ,null ,"ABMag" ,"ATLAS20biko" ,"2020-12-12 07:17:46" ,"2020-12-15 21:52:52" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acsn", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.64", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biko", `obsdate`="2020-12-12 07:17:46", `reportAddedDate`="2020-12-15 21:52:52", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acse" ,"30" ,"r-ZTF" ,"0" ,"19.67" ,"0.36" ,"ABMag" ,"ZTF20aczghif" ,"2020-12-12 11:31:49" ,"2020-12-21 12:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acse", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.67", `magErr`="0.36", `magUnit`="ABMag", `objectName`="ZTF20aczghif", `obsdate`="2020-12-12 11:31:49", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acse" ,"30" ,"r-ZTF" ,"0" ,"19.69" ,"0.22" ,"ABMag" ,"ZTF20aczghif" ,"2020-12-10 12:28:14" ,"2020-12-21 12:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acse", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.69", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20aczghif", `obsdate`="2020-12-10 12:28:14", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acse" ,"30" ,"cyan-ATLAS" ,"0" ,"19.367" ,"0.164" ,"ABMag" ,"ATLAS20bijj" ,"2020-12-14 12:28:48" ,"2020-12-15 20:26:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acse", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.367", `magErr`="0.164", `magUnit`="ABMag", `objectName`="ATLAS20bijj", `obsdate`="2020-12-14 12:28:48", `reportAddedDate`="2020-12-15 20:26:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acse" ,"30" ,"cyan-ATLAS" ,"1" ,"19.63" ,null ,"ABMag" ,"ATLAS20bijj" ,"2020-12-12 14:41:17" ,"2020-12-15 20:26:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acse", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.63", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bijj", `obsdate`="2020-12-12 14:41:17", `reportAddedDate`="2020-12-15 20:26:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrz" ,"30" ,"r-ZTF" ,"0" ,"19.19" ,"0.26" ,"ABMag" ,"ZTF20acwujgz" ,"2020-12-15 06:34:28" ,"2020-12-20 05:58:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.19", `magErr`="0.26", `magUnit`="ABMag", `objectName`="ZTF20acwujgz", `obsdate`="2020-12-15 06:34:28", `reportAddedDate`="2020-12-20 05:58:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrz" ,"30" ,"r-ZTF" ,"0" ,"19.08" ,"0.13" ,"ABMag" ,"ZTF20acwujgz" ,"2020-12-15 06:12:31" ,"2020-12-20 05:58:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.08", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acwujgz", `obsdate`="2020-12-15 06:12:31", `reportAddedDate`="2020-12-20 05:58:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrz" ,"30" ,"g-ZTF" ,"1" ,"19.5184" ,null ,"ABMag" ,"ZTF20acwujgz" ,"2020-12-10 10:49:55" ,"2020-12-20 05:58:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.5184", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwujgz", `obsdate`="2020-12-10 10:49:55", `reportAddedDate`="2020-12-20 05:58:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrz" ,"30" ,"cyan-ATLAS" ,"0" ,"19.415" ,"0.147" ,"ABMag" ,"ATLAS20biio" ,"2020-12-14 09:48:58" ,"2020-12-15 20:05:09" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.415", `magErr`="0.147", `magUnit`="ABMag", `objectName`="ATLAS20biio", `obsdate`="2020-12-14 09:48:58", `reportAddedDate`="2020-12-15 20:05:09", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrz" ,"30" ,"cyan-ATLAS" ,"1" ,"19.73" ,null ,"ABMag" ,"ATLAS20biio" ,"2020-12-12 12:14:24" ,"2020-12-15 20:05:09" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.73", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biio", `obsdate`="2020-12-12 12:14:24", `reportAddedDate`="2020-12-15 20:05:09", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrc" ,"30" ,"cyan-ATLAS" ,"0" ,"19.357" ,"0.17" ,"ABMag" ,"ATLAS20bhpc" ,"2020-12-11 15:02:53" ,"2020-12-21 12:03:30" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrc", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.357", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ATLAS20bhpc", `obsdate`="2020-12-11 15:02:53", `reportAddedDate`="2020-12-21 12:03:30", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrc" ,"30" ,"orange-ATLAS" ,"1" ,"19.05" ,null ,"ABMag" ,"ATLAS20bhpc" ,"2020-12-09 15:18:43" ,"2020-12-21 12:03:30" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrc", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.05", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhpc", `obsdate`="2020-12-09 15:18:43", `reportAddedDate`="2020-12-21 12:03:30", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrc" ,"30" ,"r-ZTF" ,"0" ,"19.52" ,"0.11" ,"ABMag" ,"ZTF20acwpivy" ,"2020-12-10 12:56:44" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.52", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acwpivy", `obsdate`="2020-12-10 12:56:44", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrc" ,"30" ,"g-ZTF" ,"0" ,"19.4" ,"0.21" ,"ABMag" ,"ZTF20acwpivy" ,"2020-12-10 11:29:38" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF20acwpivy", `obsdate`="2020-12-10 11:29:38", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acrc" ,"30" ,"r-ZTF" ,"1" ,"19.6274" ,null ,"ABMag" ,"ZTF20acwpivy" ,"2020-12-02 12:55:24" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acrc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6274", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwpivy", `obsdate`="2020-12-02 12:55:24", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acqv" ,"30" ,"g-ZTF" ,"0" ,"20.186" ,"0.239737" ,"ABMag" ,"ZTF20acwqkuz" ,"2020-12-10 10:38:51" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acqv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.186", `magErr`="0.239737", `magUnit`="ABMag", `objectName`="ZTF20acwqkuz", `obsdate`="2020-12-10 10:38:51", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acqv" ,"30" ,"g-ZTF" ,"1" ,"19.7126" ,null ,"ABMag" ,"ZTF20acwqkuz" ,"2020-12-05 11:00:22" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acqv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7126", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqkuz", `obsdate`="2020-12-05 11:00:22", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acqv" ,"30" ,"r-ZTF" ,"0" ,"19.26" ,"0.15" ,"ABMag" ,"ZTF20acwqkuz" ,"2020-12-15 10:43:15" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acqv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.26", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acwqkuz", `obsdate`="2020-12-15 10:43:15", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acqv" ,"30" ,"g-ZTF" ,"0" ,"19.02" ,"0.15" ,"ABMag" ,"ZTF20acwqkuz" ,"2020-12-15 08:51:06" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acqv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.02", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acwqkuz", `obsdate`="2020-12-15 08:51:06", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acqv" ,"30" ,"r-ZTF" ,"1" ,"19.6933" ,null ,"ABMag" ,"ZTF20acwqkuz" ,"2020-12-12 11:47:50" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acqv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6933", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqkuz", `obsdate`="2020-12-12 11:47:50", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpc" ,"30" ,"orange-ATLAS" ,"0" ,"18.469" ,"0.099" ,"ABMag" ,"ATLAS20bhkh" ,"2020-12-10 13:27:50" ,"2020-12-21 15:00:00" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpc", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.469", `magErr`="0.099", `magUnit`="ABMag", `objectName`="ATLAS20bhkh", `obsdate`="2020-12-10 13:27:50", `reportAddedDate`="2020-12-21 15:00:00", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpc" ,"30" ,"orange-ATLAS" ,"1" ,"19.1" ,null ,"ABMag" ,"ATLAS20bhkh" ,"2020-12-08 13:43:41" ,"2020-12-21 15:00:00" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpc", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.1", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhkh", `obsdate`="2020-12-08 13:43:41", `reportAddedDate`="2020-12-21 15:00:00", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpc" ,null ,"g-Sloan" ,"0" ,"18" ,null ,"ABMag" ,"ASASSN-20pu" ,"2020-12-12 12:28:48" ,"2020-12-14 17:04:33" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-1_Brutus", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpc", `exptime`=null, `filter`="g-Sloan", `limitingMag`="0", `mag`="18", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20pu", `obsdate`="2020-12-12 12:28:48", `reportAddedDate`="2020-12-14 17:04:33", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-1_Brutus" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpc" ,null ,"g-Sloan" ,"1" ,"18" ,null ,"ABMag" ,"ASASSN-20pu" ,"2020-12-08 11:02:24" ,"2020-12-14 17:04:33" ,"ASAS-SN" ,"PSN" ,"ASAS-SN" ,"ASASSN-1_Brutus", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpc", `exptime`=null, `filter`="g-Sloan", `limitingMag`="1", `mag`="18", `magErr`=null, `magUnit`="ABMag", `objectName`="ASASSN-20pu", `obsdate`="2020-12-08 11:02:24", `reportAddedDate`="2020-12-14 17:04:33", `reportingGroup`="ASAS-SN", `suggestedType`="PSN", `survey`="ASAS-SN", `telescope`="ASASSN-1_Brutus" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"r-ZTF" ,"0" ,"18.28" ,"0.06" ,"ABMag" ,"ZTF20acxlaih" ,"2020-12-16 02:40:52" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.28", `magErr`="0.06", `magUnit`="ABMag", `objectName`="ZTF20acxlaih", `obsdate`="2020-12-16 02:40:52", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"g-ZTF" ,"0" ,"18.96" ,"0.17" ,"ABMag" ,"ZTF20acxlaih" ,"2020-12-14 02:19:39" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.96", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxlaih", `obsdate`="2020-12-14 02:19:39", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"r-ZTF" ,"1" ,"20.0516" ,null ,"ABMag" ,"ZTF20acxlaih" ,"2020-12-11 02:56:23" ,"2020-12-21 04:18:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0516", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxlaih", `obsdate`="2020-12-11 02:56:23", `reportAddedDate`="2020-12-21 04:18:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"r-ZTF" ,"0" ,"18.28" ,"0.06" ,"ABMag" ,"ZTF20acxlaih" ,"2020-12-16 02:40:52" ,"2020-12-19 02:58:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.28", `magErr`="0.06", `magUnit`="ABMag", `objectName`="ZTF20acxlaih", `obsdate`="2020-12-16 02:40:52", `reportAddedDate`="2020-12-19 02:58:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"g-ZTF" ,"0" ,"18.96" ,"0.17" ,"ABMag" ,"ZTF20acxlaih" ,"2020-12-14 02:19:39" ,"2020-12-19 02:58:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.96", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxlaih", `obsdate`="2020-12-14 02:19:39", `reportAddedDate`="2020-12-19 02:58:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"r-ZTF" ,"1" ,"20.0516" ,null ,"ABMag" ,"ZTF20acxlaih" ,"2020-12-11 02:56:23" ,"2020-12-19 02:58:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0516", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxlaih", `obsdate`="2020-12-11 02:56:23", `reportAddedDate`="2020-12-19 02:58:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"cyan-ATLAS" ,"0" ,"18.517" ,"0.114" ,"ABMag" ,"ATLAS20biho" ,"2020-12-15 04:50:53" ,"2020-12-15 17:21:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.517", `magErr`="0.114", `magUnit`="ABMag", `objectName`="ATLAS20biho", `obsdate`="2020-12-15 04:50:53", `reportAddedDate`="2020-12-15 17:21:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"cyan-ATLAS" ,"1" ,"19.65" ,null ,"ABMag" ,"ATLAS20biho" ,"2020-12-11 06:17:17" ,"2020-12-15 17:21:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.65", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biho", `obsdate`="2020-12-11 06:17:17", `reportAddedDate`="2020-12-15 17:21:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"cyan-ATLAS" ,"0" ,"18.517" ,"0.114" ,"ABMag" ,"ATLAS20biho" ,"2020-12-15 04:50:53" ,"2020-12-15 17:21:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.517", `magErr`="0.114", `magUnit`="ABMag", `objectName`="ATLAS20biho", `obsdate`="2020-12-15 04:50:53", `reportAddedDate`="2020-12-15 17:21:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"cyan-ATLAS" ,"1" ,"19.65" ,null ,"ABMag" ,"ATLAS20biho" ,"2020-12-11 06:17:17" ,"2020-12-15 17:21:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.65", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biho", `obsdate`="2020-12-11 06:17:17", `reportAddedDate`="2020-12-15 17:21:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"g-ZTF" ,"0" ,"18.9575" ,"0.166078" ,"ABMag" ,"ZTF20acxlaih" ,"2020-12-14 02:19:39" ,"2020-12-14 16:46:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.9575", `magErr`="0.166078", `magUnit`="ABMag", `objectName`="ZTF20acxlaih", `obsdate`="2020-12-14 02:19:39", `reportAddedDate`="2020-12-14 16:46:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acpb" ,"30" ,"r-ZTF" ,"1" ,"20.0516" ,null ,"ABMag" ,"ZTF20acxlaih" ,"2020-12-11 02:56:23" ,"2020-12-14 16:46:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acpb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0516", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxlaih", `obsdate`="2020-12-11 02:56:23", `reportAddedDate`="2020-12-14 16:46:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acof" ,"30" ,"g-ZTF" ,"0" ,"19.89" ,"0.15" ,"ABMag" ,"ZTF20acwxiad" ,"2020-12-13 10:24:52" ,"2020-12-19 08:58:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acof", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.89", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acwxiad", `obsdate`="2020-12-13 10:24:52", `reportAddedDate`="2020-12-19 08:58:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acof" ,"30" ,"r-ZTF" ,"0" ,"20.1" ,"0.28" ,"ABMag" ,"ZTF20acwxiad" ,"2020-12-13 09:10:17" ,"2020-12-19 08:58:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acof", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1", `magErr`="0.28", `magUnit`="ABMag", `objectName`="ZTF20acwxiad", `obsdate`="2020-12-13 09:10:17", `reportAddedDate`="2020-12-19 08:58:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acof" ,"30" ,"r-ZTF" ,"1" ,"19.9806" ,null ,"ABMag" ,"ZTF20acwxiad" ,"2020-12-11 09:18:39" ,"2020-12-19 08:58:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acof", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.9806", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwxiad", `obsdate`="2020-12-11 09:18:39", `reportAddedDate`="2020-12-19 08:58:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acof" ,"30" ,"g-ZTF" ,"0" ,"19.8941" ,"0.151834" ,"ABMag" ,"ZTF20acwxiad" ,"2020-12-13 10:24:52" ,"2020-12-13 21:08:47" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acof", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8941", `magErr`="0.151834", `magUnit`="ABMag", `objectName`="ZTF20acwxiad", `obsdate`="2020-12-13 10:24:52", `reportAddedDate`="2020-12-13 21:08:47", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acof" ,"30" ,"r-ZTF" ,"0" ,"20.0973" ,"0.282774" ,"ABMag" ,"ZTF20acwxiad" ,"2020-12-13 09:10:17" ,"2020-12-13 21:08:47" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acof", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0973", `magErr`="0.282774", `magUnit`="ABMag", `objectName`="ZTF20acwxiad", `obsdate`="2020-12-13 09:10:17", `reportAddedDate`="2020-12-13 21:08:47", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acof" ,"30" ,"g-ZTF" ,"0" ,"20.2589" ,"0.260983" ,"ABMag" ,"ZTF20acwxiad" ,"2020-12-11 10:20:49" ,"2020-12-13 21:08:47" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acof", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2589", `magErr`="0.260983", `magUnit`="ABMag", `objectName`="ZTF20acwxiad", `obsdate`="2020-12-11 10:20:49", `reportAddedDate`="2020-12-13 21:08:47", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acof" ,"30" ,"r-ZTF" ,"1" ,"19.9806" ,null ,"ABMag" ,"ZTF20acwxiad" ,"2020-12-11 09:18:39" ,"2020-12-13 21:08:47" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acof", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.9806", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwxiad", `obsdate`="2020-12-11 09:18:39", `reportAddedDate`="2020-12-13 21:08:47", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acnm" ,"45" ,"w-PS1" ,"0" ,"20.63" ,"0.06" ,"ABMag" ,"PS20mkr" ,"2020-12-08 06:04:19" ,"2020-12-19 19:04:45" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acnm", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.63", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20mkr", `obsdate`="2020-12-08 06:04:19", `reportAddedDate`="2020-12-19 19:04:45", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acnm" ,"30" ,"r-ZTF" ,"0" ,"20.4772" ,null ,"ABMag" ,"ZTF20acxcsyo" ,"2020-12-07 04:09:07" ,"2020-12-13 05:02:35" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acnm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4772", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxcsyo", `obsdate`="2020-12-07 04:09:07", `reportAddedDate`="2020-12-13 05:02:35", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acnm" ,"30" ,"r-ZTF" ,"1" ,"19.7878" ,null ,"ABMag" ,"ZTF20acxcsyo" ,"2020-12-05 06:28:21" ,"2020-12-13 05:02:35" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acnm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7878", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxcsyo", `obsdate`="2020-12-05 06:28:21", `reportAddedDate`="2020-12-13 05:02:35", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmp" ,"30" ,"g-ZTF" ,"0" ,"19.61" ,"0.18" ,"ABMag" ,"ZTF20acxfced" ,"2020-12-12 13:11:03" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.61", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acxfced", `obsdate`="2020-12-12 13:11:03", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmp" ,"30" ,"r-ZTF" ,"0" ,"19.82" ,"0.15" ,"ABMag" ,"ZTF20acxfced" ,"2020-12-12 12:11:46" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.82", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acxfced", `obsdate`="2020-12-12 12:11:46", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmp" ,"30" ,"g-ZTF" ,"1" ,"19.8667" ,null ,"ABMag" ,"ZTF20acxfced" ,"2020-12-06 12:15:31" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8667", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxfced", `obsdate`="2020-12-06 12:15:31", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmp" ,"30" ,"cyan-ATLAS" ,"0" ,"19.641" ,"0.187" ,"ABMag" ,"ATLAS20bike" ,"2020-12-14 14:15:22" ,"2020-12-15 20:38:03" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmp", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.641", `magErr`="0.187", `magUnit`="ABMag", `objectName`="ATLAS20bike", `obsdate`="2020-12-14 14:15:22", `reportAddedDate`="2020-12-15 20:38:03", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmp" ,"30" ,"orange-ATLAS" ,"1" ,"19.31" ,null ,"ABMag" ,"ATLAS20bike" ,"2020-12-10 15:50:24" ,"2020-12-15 20:38:03" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmp", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.31", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bike", `obsdate`="2020-12-10 15:50:24", `reportAddedDate`="2020-12-15 20:38:03", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmp" ,"30" ,"g-ZTF" ,"0" ,"19.6074" ,"0.177408" ,"ABMag" ,"ZTF20acxfced" ,"2020-12-12 13:11:03" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6074", `magErr`="0.177408", `magUnit`="ABMag", `objectName`="ZTF20acxfced", `obsdate`="2020-12-12 13:11:03", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmp" ,"30" ,"r-ZTF" ,"0" ,"19.8213" ,"0.145421" ,"ABMag" ,"ZTF20acxfced" ,"2020-12-12 12:11:46" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8213", `magErr`="0.145421", `magUnit`="ABMag", `objectName`="ZTF20acxfced", `obsdate`="2020-12-12 12:11:46", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmp" ,"30" ,"r-ZTF" ,"1" ,"17.7652" ,null ,"ABMag" ,"ZTF20acxfced" ,"2020-12-09 12:18:07" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="17.7652", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxfced", `obsdate`="2020-12-09 12:18:07", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"g-ZTF" ,"0" ,"19.36" ,"0.13" ,"ABMag" ,"ZTF20acxbnjd" ,"2020-12-16 04:58:26" ,"2020-12-19 06:58:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.36", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxbnjd", `obsdate`="2020-12-16 04:58:26", `reportAddedDate`="2020-12-19 06:58:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"r-ZTF" ,"0" ,"19.29" ,"0.2" ,"ABMag" ,"ZTF20acxbnjd" ,"2020-12-16 03:26:29" ,"2020-12-19 06:58:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.29", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxbnjd", `obsdate`="2020-12-16 03:26:29", `reportAddedDate`="2020-12-19 06:58:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"g-ZTF" ,"1" ,"20.311" ,null ,"ABMag" ,"ZTF20acxbnjd" ,"2020-12-12 05:50:53" ,"2020-12-19 06:58:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.311", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbnjd", `obsdate`="2020-12-12 05:50:53", `reportAddedDate`="2020-12-19 06:58:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"g-ZTF" ,"0" ,"19.36" ,"0.13" ,"ABMag" ,"ZTF20acxbnjd" ,"2020-12-16 04:58:26" ,"2020-12-19 05:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.36", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxbnjd", `obsdate`="2020-12-16 04:58:26", `reportAddedDate`="2020-12-19 05:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"r-ZTF" ,"0" ,"19.29" ,"0.2" ,"ABMag" ,"ZTF20acxbnjd" ,"2020-12-16 03:26:29" ,"2020-12-19 05:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.29", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acxbnjd", `obsdate`="2020-12-16 03:26:29", `reportAddedDate`="2020-12-19 05:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"g-ZTF" ,"1" ,"20.311" ,null ,"ABMag" ,"ZTF20acxbnjd" ,"2020-12-12 05:50:53" ,"2020-12-19 05:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.311", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbnjd", `obsdate`="2020-12-12 05:50:53", `reportAddedDate`="2020-12-19 05:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"cyan-ATLAS" ,"0" ,"19.251" ,"0.165" ,"ABMag" ,"ATLAS20bily" ,"2020-12-17 07:33:36" ,"2020-12-17 12:46:55" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.251", `magErr`="0.165", `magUnit`="ABMag", `objectName`="ATLAS20bily", `obsdate`="2020-12-17 07:33:36", `reportAddedDate`="2020-12-17 12:46:55", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"cyan-ATLAS" ,"1" ,"19.75" ,null ,"ABMag" ,"ATLAS20bily" ,"2020-12-15 07:27:50" ,"2020-12-17 12:46:55" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.75", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bily", `obsdate`="2020-12-15 07:27:50", `reportAddedDate`="2020-12-17 12:46:55", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"r-ZTF" ,"0" ,"20.1142" ,"0.153514" ,"ABMag" ,"ZTF20acxbnjd" ,"2020-12-12 05:05:38" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1142", `magErr`="0.153514", `magUnit`="ABMag", `objectName`="ZTF20acxbnjd", `obsdate`="2020-12-12 05:05:38", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmn" ,"30" ,"r-ZTF" ,"1" ,"20.6081" ,null ,"ABMag" ,"ZTF20acxbnjd" ,"2020-12-12 04:40:43" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.6081", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbnjd", `obsdate`="2020-12-12 04:40:43", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"r-ZTF" ,"0" ,"19.8" ,"0.13" ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-12 04:49:30" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-12 04:49:30", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"g-ZTF" ,"0" ,"19.66" ,"0.1" ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-12 04:06:12" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.66", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-12 04:06:12", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"r-ZTF" ,"1" ,"19.9785" ,null ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-10 05:27:31" ,"2020-12-21 05:20:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.9785", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-10 05:27:31", `reportAddedDate`="2020-12-21 05:20:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"r-ZTF" ,"0" ,"19.8" ,"0.13" ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-12 04:49:30" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-12 04:49:30", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"g-ZTF" ,"0" ,"19.66" ,"0.1" ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-12 04:06:12" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.66", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-12 04:06:12", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"r-ZTF" ,"1" ,"19.9785" ,null ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-10 05:27:31" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.9785", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-10 05:27:31", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"r-ZTF" ,"0" ,"19.8" ,"0.13" ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-12 04:49:30" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-12 04:49:30", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"g-ZTF" ,"0" ,"19.66" ,"0.1" ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-12 04:06:12" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.66", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-12 04:06:12", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"r-ZTF" ,"1" ,"19.9785" ,null ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-10 05:27:31" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.9785", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-10 05:27:31", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"cyan-ATLAS" ,"0" ,"18.63" ,"0.107" ,"ABMag" ,"ATLAS20bihn" ,"2020-12-15 06:00:00" ,"2020-12-15 12:21:18" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.63", `magErr`="0.107", `magUnit`="ABMag", `objectName`="ATLAS20bihn", `obsdate`="2020-12-15 06:00:00", `reportAddedDate`="2020-12-15 12:21:18", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"cyan-ATLAS" ,"1" ,"19.7" ,null ,"ABMag" ,"ATLAS20bihn" ,"2020-12-11 07:45:07" ,"2020-12-15 12:21:18" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.7", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bihn", `obsdate`="2020-12-11 07:45:07", `reportAddedDate`="2020-12-15 12:21:18", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"45" ,"w-PS1" ,"0" ,"19.86" ,"0.06" ,"ABMag" ,"PS20mef" ,"2020-12-12 05:06:43" ,"2020-12-15 11:53:01" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.86", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20mef", `obsdate`="2020-12-12 05:06:43", `reportAddedDate`="2020-12-15 11:53:01", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"r-ZTF" ,"0" ,"19.7987" ,"0.133667" ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-12 04:49:30" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7987", `magErr`="0.133667", `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-12 04:49:30", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"g-ZTF" ,"0" ,"19.6643" ,"0.103107" ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-12 04:06:12" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6643", `magErr`="0.103107", `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-12 04:06:12", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmm" ,"30" ,"r-ZTF" ,"1" ,"19.9785" ,null ,"ABMag" ,"ZTF20acxbbaj" ,"2020-12-10 05:27:31" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.9785", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbbaj", `obsdate`="2020-12-10 05:27:31", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmc" ,"30" ,"orange-ATLAS" ,"0" ,"18.822" ,"0.116" ,"ABMag" ,"ATLAS20birk" ,"2020-12-20 06:43:12" ,"2020-12-20 14:36:15" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmc", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.822", `magErr`="0.116", `magUnit`="ABMag", `objectName`="ATLAS20birk", `obsdate`="2020-12-20 06:43:12", `reportAddedDate`="2020-12-20 14:36:15", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmc" ,"30" ,"cyan-ATLAS" ,"1" ,"19.68" ,null ,"ABMag" ,"ATLAS20birk" ,"2020-12-14 07:36:29" ,"2020-12-20 14:36:15" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmc", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.68", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20birk", `obsdate`="2020-12-14 07:36:29", `reportAddedDate`="2020-12-20 14:36:15", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmc" ,"30" ,"g-ZTF" ,"0" ,"19.29" ,"0.17" ,"ABMag" ,"ZTF20acxbadv" ,"2020-12-16 04:33:39" ,"2020-12-16 04:59:07" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.29", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acxbadv", `obsdate`="2020-12-16 04:33:39", `reportAddedDate`="2020-12-16 04:59:07", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmc" ,"30" ,"r-ZTF" ,"0" ,"19.36" ,"0.22" ,"ABMag" ,"ZTF20acxbadv" ,"2020-12-16 03:30:34" ,"2020-12-16 04:59:07" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.36", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acxbadv", `obsdate`="2020-12-16 03:30:34", `reportAddedDate`="2020-12-16 04:59:07", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmc" ,"30" ,"r-ZTF" ,"1" ,"20.1471" ,null ,"ABMag" ,"ZTF20acxbadv" ,"2020-12-12 04:42:44" ,"2020-12-16 04:59:07" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1471", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbadv", `obsdate`="2020-12-12 04:42:44", `reportAddedDate`="2020-12-16 04:59:07", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmc" ,"30" ,"g-ZTF" ,"0" ,"19.9866" ,"0.169695" ,"ABMag" ,"ZTF20acxbadv" ,"2020-12-12 04:04:11" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.9866", `magErr`="0.169695", `magUnit`="ABMag", `objectName`="ZTF20acxbadv", `obsdate`="2020-12-12 04:04:11", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmc" ,"30" ,"g-ZTF" ,"0" ,"20.3824" ,"0.278033" ,"ABMag" ,"ZTF20acxbadv" ,"2020-12-10 04:03:03" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.3824", `magErr`="0.278033", `magUnit`="ABMag", `objectName`="ZTF20acxbadv", `obsdate`="2020-12-10 04:03:03", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acmc" ,"30" ,"g-ZTF" ,"1" ,"19.8152" ,null ,"ABMag" ,"ZTF20acxbadv" ,"2020-12-05 04:28:02" ,"2020-12-12 22:10:45" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acmc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8152", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxbadv", `obsdate`="2020-12-05 04:28:02", `reportAddedDate`="2020-12-12 22:10:45", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjw" ,"30" ,"r-ZTF" ,"0" ,"19.4447" ,"0.123903" ,"ABMag" ,"ZTF20acwqndp" ,"2020-12-11 12:25:13" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4447", `magErr`="0.123903", `magUnit`="ABMag", `objectName`="ZTF20acwqndp", `obsdate`="2020-12-11 12:25:13", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjw" ,"30" ,"r-ZTF" ,"1" ,"19.022" ,null ,"ABMag" ,"ZTF20acwqndp" ,"2020-12-09 12:10:00" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.022", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqndp", `obsdate`="2020-12-09 12:10:00", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjw" ,"30" ,"g-ZTF" ,"0" ,"19.55" ,"0.12" ,"ABMag" ,"ZTF20acwqndp" ,"2020-12-11 12:48:18" ,"2020-12-17 10:58:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.55", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acwqndp", `obsdate`="2020-12-11 12:48:18", `reportAddedDate`="2020-12-17 10:58:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjw" ,"30" ,"r-ZTF" ,"0" ,"19.44" ,"0.12" ,"ABMag" ,"ZTF20acwqndp" ,"2020-12-11 12:25:13" ,"2020-12-17 10:58:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.44", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acwqndp", `obsdate`="2020-12-11 12:25:13", `reportAddedDate`="2020-12-17 10:58:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjw" ,"30" ,"g-ZTF" ,"1" ,"19.8748" ,null ,"ABMag" ,"ZTF20acwqndp" ,"2020-12-05 12:58:25" ,"2020-12-17 10:58:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8748", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqndp", `obsdate`="2020-12-05 12:58:25", `reportAddedDate`="2020-12-17 10:58:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjw" ,"30" ,"g-ZTF" ,"0" ,"19.5524" ,"0.124709" ,"ABMag" ,"ZTF20acwqndp" ,"2020-12-11 12:48:18" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.5524", `magErr`="0.124709", `magUnit`="ABMag", `objectName`="ZTF20acwqndp", `obsdate`="2020-12-11 12:48:18", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjw" ,"30" ,"r-ZTF" ,"0" ,"19.4447" ,"0.123903" ,"ABMag" ,"ZTF20acwqndp" ,"2020-12-11 12:25:13" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4447", `magErr`="0.123903", `magUnit`="ABMag", `objectName`="ZTF20acwqndp", `obsdate`="2020-12-11 12:25:13", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjw" ,"30" ,"r-ZTF" ,"1" ,"19.022" ,null ,"ABMag" ,"ZTF20acwqndp" ,"2020-12-09 12:10:00" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.022", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqndp", `obsdate`="2020-12-09 12:10:00", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjm" ,"30" ,"cyan-ATLAS" ,"0" ,"19.553" ,"0.162" ,"ABMag" ,"ATLAS20bios" ,"2020-12-17 10:42:14" ,"2020-12-20 18:43:47" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.553", `magErr`="0.162", `magUnit`="ABMag", `objectName`="ATLAS20bios", `obsdate`="2020-12-17 10:42:14", `reportAddedDate`="2020-12-20 18:43:47", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjm" ,"30" ,"cyan-ATLAS" ,"1" ,"18.35" ,null ,"ABMag" ,"ATLAS20bios" ,"2020-12-15 12:01:26" ,"2020-12-20 18:43:47" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="18.35", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bios", `obsdate`="2020-12-15 12:01:26", `reportAddedDate`="2020-12-20 18:43:47", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjm" ,"30" ,"r-ZTF" ,"0" ,"20.1397" ,"0.167037" ,"ABMag" ,"ZTF20acwwcdu" ,"2020-12-11 11:08:54" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1397", `magErr`="0.167037", `magUnit`="ABMag", `objectName`="ZTF20acwwcdu", `obsdate`="2020-12-11 11:08:54", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjm" ,"30" ,"g-ZTF" ,"1" ,"19.9867" ,null ,"ABMag" ,"ZTF20acwwcdu" ,"2020-12-11 10:03:34" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.9867", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwwcdu", `obsdate`="2020-12-11 10:03:34", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjd" ,"30" ,"cyan-ATLAS" ,"0" ,"19.57" ,"0.18" ,"ABMag" ,"ATLAS20biiq" ,"2020-12-14 13:26:24" ,"2020-12-20 18:54:37" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.57", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ATLAS20biiq", `obsdate`="2020-12-14 13:26:24", `reportAddedDate`="2020-12-20 18:54:37", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjd" ,"30" ,"cyan-ATLAS" ,"1" ,"19.79" ,null ,"ABMag" ,"ATLAS20biiq" ,"2020-12-12 14:29:46" ,"2020-12-20 18:54:37" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.79", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20biiq", `obsdate`="2020-12-12 14:29:46", `reportAddedDate`="2020-12-20 18:54:37", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjd" ,"30" ,"r-ZTF" ,"0" ,"19.77" ,"0.14" ,"ABMag" ,"ZTF20acwogqz" ,"2020-12-11 11:59:54" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.77", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acwogqz", `obsdate`="2020-12-11 11:59:54", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjd" ,"30" ,"g-ZTF" ,"0" ,"20.01" ,"0.19" ,"ABMag" ,"ZTF20acwogqz" ,"2020-12-11 10:41:48" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.01", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acwogqz", `obsdate`="2020-12-11 10:41:48", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjd" ,"30" ,"r-ZTF" ,"1" ,"19.5674" ,null ,"ABMag" ,"ZTF20acwogqz" ,"2020-12-04 11:45:18" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5674", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwogqz", `obsdate`="2020-12-04 11:45:18", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjd" ,"30" ,"r-ZTF" ,"0" ,"19.7671" ,"0.138777" ,"ABMag" ,"ZTF20acwogqz" ,"2020-12-11 11:59:54" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7671", `magErr`="0.138777", `magUnit`="ABMag", `objectName`="ZTF20acwogqz", `obsdate`="2020-12-11 11:59:54", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjd" ,"30" ,"g-ZTF" ,"0" ,"20.0122" ,"0.185938" ,"ABMag" ,"ZTF20acwogqz" ,"2020-12-11 10:41:48" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0122", `magErr`="0.185938", `magUnit`="ABMag", `objectName`="ZTF20acwogqz", `obsdate`="2020-12-11 10:41:48", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjd" ,"30" ,"r-ZTF" ,"1" ,"16.157" ,null ,"ABMag" ,"ZTF20acwogqz" ,"2020-12-09 11:49:19" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="16.157", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwogqz", `obsdate`="2020-12-09 11:49:19", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjb" ,"30" ,"orange-ATLAS" ,"0" ,"18.85" ,"0.167" ,"ABMag" ,"ATLAS20bhjs" ,"2020-12-10 13:39:22" ,"2020-12-21 14:57:50" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjb", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.85", `magErr`="0.167", `magUnit`="ABMag", `objectName`="ATLAS20bhjs", `obsdate`="2020-12-10 13:39:22", `reportAddedDate`="2020-12-21 14:57:50", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjb" ,"30" ,"orange-ATLAS" ,"1" ,"19.38" ,null ,"ABMag" ,"ATLAS20bhjs" ,"2020-12-08 14:03:50" ,"2020-12-21 14:57:50" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjb", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.38", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhjs", `obsdate`="2020-12-08 14:03:50", `reportAddedDate`="2020-12-21 14:57:50", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjb" ,"30" ,"g-ZTF" ,"0" ,"19.6186" ,"0.170922" ,"ABMag" ,"ZTF20acwohcl" ,"2020-12-11 10:40:27" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6186", `magErr`="0.170922", `magUnit`="ABMag", `objectName`="ZTF20acwohcl", `obsdate`="2020-12-11 10:40:27", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acjb" ,"30" ,"g-ZTF" ,"1" ,"19.3126" ,null ,"ABMag" ,"ZTF20acwohcl" ,"2020-12-04 12:29:15" ,"2020-12-11 20:24:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acjb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.3126", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwohcl", `obsdate`="2020-12-04 12:29:15", `reportAddedDate`="2020-12-11 20:24:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acip" ,"120" ,"z-Sloan" ,"0" ,"20.02" ,"0.11" ,"ABMag" ,"PS20mla" ,"2020-12-06 15:57:36" ,"2020-12-19 19:09:49" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acip", `exptime`="120", `filter`="z-Sloan", `limitingMag`="0", `mag`="20.02", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20mla", `obsdate`="2020-12-06 15:57:36", `reportAddedDate`="2020-12-19 19:09:49", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acip" ,"30" ,"g-ZTF" ,"0" ,"20.3793" ,null ,"ABMag" ,"ZTF20acvkwkp" ,"2020-11-23 12:19:35" ,"2020-12-11 20:02:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acip", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.3793", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvkwkp", `obsdate`="2020-11-23 12:19:35", `reportAddedDate`="2020-12-11 20:02:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acip" ,"30" ,"r-ZTF" ,"1" ,"19.5872" ,null ,"ABMag" ,"ZTF20acvkwkp" ,"2020-11-20 12:39:57" ,"2020-12-11 20:02:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acip", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5872", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvkwkp", `obsdate`="2020-11-20 12:39:57", `reportAddedDate`="2020-12-11 20:02:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acif" ,"30" ,"r-ZTF" ,"0" ,"19.54" ,"0.256266" ,"ABMag" ,"ZTF20acwyihb" ,"2020-12-09 12:20:53" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.54", `magErr`="0.256266", `magUnit`="ABMag", `objectName`="ZTF20acwyihb", `obsdate`="2020-12-09 12:20:53", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acif" ,"30" ,"cyan-ATLAS" ,"0" ,"18.377" ,"0.082" ,"ABMag" ,"ATLAS20bihu" ,"2020-12-14 15:10:05" ,"2020-12-15 19:33:37" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.377", `magErr`="0.082", `magUnit`="ABMag", `objectName`="ATLAS20bihu", `obsdate`="2020-12-14 15:10:05", `reportAddedDate`="2020-12-15 19:33:37", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acif" ,"30" ,"orange-ATLAS" ,"1" ,"17.77" ,null ,"ABMag" ,"ATLAS20bihu" ,"2020-10-01 05:06:43" ,"2020-12-15 19:33:37" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="17.77", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bihu", `obsdate`="2020-10-01 05:06:43", `reportAddedDate`="2020-12-15 19:33:37", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acif" ,"30" ,"g-ZTF" ,"0" ,"18.73" ,"0.13" ,"ABMag" ,"ZTF20acwyihb" ,"2020-12-11 13:03:20" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.73", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acwyihb", `obsdate`="2020-12-11 13:03:20", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acif" ,"30" ,"r-ZTF" ,"0" ,"18.82" ,"0.12" ,"ABMag" ,"ZTF20acwyihb" ,"2020-12-11 12:17:06" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.82", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acwyihb", `obsdate`="2020-12-11 12:17:06", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acif" ,"30" ,"g-ZTF" ,"0" ,"18.7346" ,"0.13197" ,"ABMag" ,"ZTF20acwyihb" ,"2020-12-11 13:03:20" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.7346", `magErr`="0.13197", `magUnit`="ABMag", `objectName`="ZTF20acwyihb", `obsdate`="2020-12-11 13:03:20", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acif" ,"30" ,"r-ZTF" ,"0" ,"18.8213" ,"0.123682" ,"ABMag" ,"ZTF20acwyihb" ,"2020-12-11 12:17:06" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.8213", `magErr`="0.123682", `magUnit`="ABMag", `objectName`="ZTF20acwyihb", `obsdate`="2020-12-11 12:17:06", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acif" ,"30" ,"g-ZTF" ,"0" ,"19.4599" ,"0.241527" ,"ABMag" ,"ZTF20acwyihb" ,"2020-12-09 13:02:30" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4599", `magErr`="0.241527", `magUnit`="ABMag", `objectName`="ZTF20acwyihb", `obsdate`="2020-12-09 13:02:30", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acif" ,"30" ,"r-ZTF" ,"0" ,"19.54" ,"0.256266" ,"ABMag" ,"ZTF20acwyihb" ,"2020-12-09 12:20:53" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acif", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.54", `magErr`="0.256266", `magUnit`="ABMag", `objectName`="ZTF20acwyihb", `obsdate`="2020-12-09 12:20:53", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acic" ,"30" ,"r-ZTF" ,"0" ,"19.71" ,"0.33" ,"ABMag" ,"ZTF20acwoewh" ,"2020-12-17 12:15:19" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acic", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.71", `magErr`="0.33", `magUnit`="ABMag", `objectName`="ZTF20acwoewh", `obsdate`="2020-12-17 12:15:19", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acic" ,"30" ,"g-ZTF" ,"0" ,"19.65" ,"0.12" ,"ABMag" ,"ZTF20acwoewh" ,"2020-12-15 12:15:27" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acic", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.65", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acwoewh", `obsdate`="2020-12-15 12:15:27", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acic" ,"30" ,"r-ZTF" ,"1" ,"20.2937" ,null ,"ABMag" ,"ZTF20acwoewh" ,"2020-12-15 11:18:33" ,"2020-12-20 11:59:34" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acic", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.2937", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwoewh", `obsdate`="2020-12-15 11:18:33", `reportAddedDate`="2020-12-20 11:59:34", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acic" ,"30" ,"g-ZTF" ,"0" ,"19.8439" ,"0.205797" ,"ABMag" ,"ZTF20acwoewh" ,"2020-12-11 10:48:55" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acic", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8439", `magErr`="0.205797", `magUnit`="ABMag", `objectName`="ZTF20acwoewh", `obsdate`="2020-12-11 10:48:55", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acic" ,"30" ,"g-ZTF" ,"0" ,"20.6089" ,"0.350874" ,"ABMag" ,"ZTF20acwoewh" ,"2020-12-06 12:30:07" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acic", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.6089", `magErr`="0.350874", `magUnit`="ABMag", `objectName`="ZTF20acwoewh", `obsdate`="2020-12-06 12:30:07", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acic" ,"30" ,"r-ZTF" ,"1" ,"18.5872" ,null ,"ABMag" ,"ZTF20acwoewh" ,"2020-12-06 11:00:10" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acic", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.5872", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwoewh", `obsdate`="2020-12-06 11:00:10", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acht" ,"30" ,"r-ZTF" ,"0" ,"20.03" ,"0.18" ,"ABMag" ,"ZTF20acwyknf" ,"2020-12-11 12:23:11" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acht", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.03", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acwyknf", `obsdate`="2020-12-11 12:23:11", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acht" ,"30" ,"g-ZTF" ,"0" ,"20.25" ,"0.27" ,"ABMag" ,"ZTF20acwyknf" ,"2020-12-05 13:00:27" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acht", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.25", `magErr`="0.27", `magUnit`="ABMag", `objectName`="ZTF20acwyknf", `obsdate`="2020-12-05 13:00:27", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acht" ,"30" ,"r-ZTF" ,"1" ,"19.7656" ,null ,"ABMag" ,"ZTF20acwyknf" ,"2020-12-05 12:15:26" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acht", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7656", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwyknf", `obsdate`="2020-12-05 12:15:26", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acht" ,"30" ,"g-ZTF" ,"0" ,"19.7213" ,"0.17014" ,"ABMag" ,"ZTF20acwyknf" ,"2020-12-11 13:10:38" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acht", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7213", `magErr`="0.17014", `magUnit`="ABMag", `objectName`="ZTF20acwyknf", `obsdate`="2020-12-11 13:10:38", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acht" ,"30" ,"r-ZTF" ,"0" ,"20.0297" ,"0.175628" ,"ABMag" ,"ZTF20acwyknf" ,"2020-12-11 12:23:11" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acht", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0297", `magErr`="0.175628", `magUnit`="ABMag", `objectName`="ZTF20acwyknf", `obsdate`="2020-12-11 12:23:11", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acht" ,"30" ,"g-ZTF" ,"0" ,"20.2522" ,"0.268592" ,"ABMag" ,"ZTF20acwyknf" ,"2020-12-05 13:00:27" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acht", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2522", `magErr`="0.268592", `magUnit`="ABMag", `objectName`="ZTF20acwyknf", `obsdate`="2020-12-05 13:00:27", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acht" ,"30" ,"r-ZTF" ,"1" ,"19.7656" ,null ,"ABMag" ,"ZTF20acwyknf" ,"2020-12-05 12:15:26" ,"2020-12-11 19:58:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acht", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7656", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwyknf", `obsdate`="2020-12-05 12:15:26", `reportAddedDate`="2020-12-11 19:58:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acgf" ,"45" ,"w-PS1" ,"0" ,"20.11" ,"0.06" ,"ABMag" ,"PS20mie" ,"2020-12-12 09:07:12" ,"2020-12-18 19:46:22" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acgf", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.11", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20mie", `obsdate`="2020-12-12 09:07:12", `reportAddedDate`="2020-12-18 19:46:22", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acgf" ,"30" ,"r-ZTF" ,"0" ,"19.7685" ,null ,"ABMag" ,"ZTF20acwimuf" ,"2020-12-02 07:47:47" ,"2020-12-11 08:35:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acgf", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7685", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwimuf", `obsdate`="2020-12-02 07:47:47", `reportAddedDate`="2020-12-11 08:35:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acgf" ,"30" ,"g-ZTF" ,"1" ,"19.0614" ,null ,"ABMag" ,"ZTF20acwimuf" ,"2020-12-02 07:24:05" ,"2020-12-11 08:35:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acgf", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.0614", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwimuf", `obsdate`="2020-12-02 07:24:05", `reportAddedDate`="2020-12-11 08:35:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acfp" ,"30" ,"g-ZTF" ,"0" ,"19.3237" ,"0.125365" ,"ABMag" ,"ZTF20acwofhd" ,"2020-12-11 10:47:26" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acfp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.3237", `magErr`="0.125365", `magUnit`="ABMag", `objectName`="ZTF20acwofhd", `obsdate`="2020-12-11 10:47:26", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acfp" ,"30" ,"g-ZTF" ,"1" ,"18.1387" ,null ,"ABMag" ,"ZTF20acwofhd" ,"2020-12-09 12:36:40" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acfp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.1387", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwofhd", `obsdate`="2020-12-09 12:36:40", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acfp" ,"30" ,"g-ZTF" ,"0" ,"19.5908" ,null ,"ABMag" ,"ZTF20acwofhd" ,"2020-12-10 10:39:39" ,"2020-12-11 07:15:58" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acfp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.5908", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwofhd", `obsdate`="2020-12-10 10:39:39", `reportAddedDate`="2020-12-11 07:15:58", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acfp" ,"30" ,"g-ZTF" ,"1" ,"18.1387" ,null ,"ABMag" ,"ZTF20acwofhd" ,"2020-12-09 12:36:40" ,"2020-12-11 07:15:58" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acfp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.1387", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwofhd", `obsdate`="2020-12-09 12:36:40", `reportAddedDate`="2020-12-11 07:15:58", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acez" ,"30" ,"r-ZTF" ,"0" ,"19.7391" ,"0.143004" ,"ABMag" ,"ZTF20acwqlpq" ,"2020-12-10 12:41:00" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acez", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7391", `magErr`="0.143004", `magUnit`="ABMag", `objectName`="ZTF20acwqlpq", `obsdate`="2020-12-10 12:41:00", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acez" ,"30" ,"r-ZTF" ,"1" ,"19.5831" ,null ,"ABMag" ,"ZTF20acwqlpq" ,"2020-12-01 12:27:55" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acez", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5831", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqlpq", `obsdate`="2020-12-01 12:27:55", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acez" ,"30" ,"g-ZTF" ,"0" ,"19.67" ,"0.16" ,"ABMag" ,"ZTF20acwqlpq" ,"2020-12-10 13:09:29" ,"2020-12-15 11:56:42" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acez", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.67", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acwqlpq", `obsdate`="2020-12-10 13:09:29", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acez" ,"30" ,"r-ZTF" ,"0" ,"19.74" ,"0.14" ,"ABMag" ,"ZTF20acwqlpq" ,"2020-12-10 12:41:00" ,"2020-12-15 11:56:42" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acez", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.74", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acwqlpq", `obsdate`="2020-12-10 12:41:00", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acez" ,"30" ,"g-ZTF" ,"1" ,"19.7637" ,null ,"ABMag" ,"ZTF20acwqlpq" ,"2020-12-05 12:48:17" ,"2020-12-15 11:56:42" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acez", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7637", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqlpq", `obsdate`="2020-12-05 12:48:17", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acez" ,"30" ,"g-ZTF" ,"0" ,"19.6705" ,"0.159476" ,"ABMag" ,"ZTF20acwqlpq" ,"2020-12-10 13:09:29" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acez", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6705", `magErr`="0.159476", `magUnit`="ABMag", `objectName`="ZTF20acwqlpq", `obsdate`="2020-12-10 13:09:29", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acez" ,"30" ,"r-ZTF" ,"0" ,"19.7391" ,"0.143004" ,"ABMag" ,"ZTF20acwqlpq" ,"2020-12-10 12:41:00" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acez", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7391", `magErr`="0.143004", `magUnit`="ABMag", `objectName`="ZTF20acwqlpq", `obsdate`="2020-12-10 12:41:00", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acez" ,"30" ,"g-ZTF" ,"1" ,"19.7637" ,null ,"ABMag" ,"ZTF20acwqlpq" ,"2020-12-05 12:48:17" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acez", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7637", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqlpq", `obsdate`="2020-12-05 12:48:17", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acey" ,"30" ,"g-ZTF" ,"0" ,"19.29" ,"0.18" ,"ABMag" ,"ZTF20acwqitw" ,"2020-12-10 13:02:52" ,"2020-12-21 11:19:09" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acey", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.29", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acwqitw", `obsdate`="2020-12-10 13:02:52", `reportAddedDate`="2020-12-21 11:19:09", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acey" ,"30" ,"r-ZTF" ,"0" ,"19.34" ,"0.17" ,"ABMag" ,"ZTF20acwqitw" ,"2020-12-10 12:28:14" ,"2020-12-21 11:19:09" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acey", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.34", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acwqitw", `obsdate`="2020-12-10 12:28:14", `reportAddedDate`="2020-12-21 11:19:09", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acey" ,"30" ,"g-ZTF" ,"0" ,"19.2909" ,"0.176493" ,"ABMag" ,"ZTF20acwqitw" ,"2020-12-10 13:02:52" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acey", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.2909", `magErr`="0.176493", `magUnit`="ABMag", `objectName`="ZTF20acwqitw", `obsdate`="2020-12-10 13:02:52", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acey" ,"30" ,"r-ZTF" ,"0" ,"19.3417" ,"0.172921" ,"ABMag" ,"ZTF20acwqitw" ,"2020-12-10 12:28:14" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acey", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.3417", `magErr`="0.172921", `magUnit`="ABMag", `objectName`="ZTF20acwqitw", `obsdate`="2020-12-10 12:28:14", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acey" ,"30" ,"g-ZTF" ,"1" ,"19.3335" ,null ,"ABMag" ,"ZTF20acwqitw" ,"2020-12-05 12:33:14" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acey", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.3335", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqitw", `obsdate`="2020-12-05 12:33:14", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acet" ,"30" ,"g-ZTF" ,"0" ,"19.7305" ,"0.222318" ,"ABMag" ,"ZTF20acwqqax" ,"2020-12-10 11:28:58" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acet", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7305", `magErr`="0.222318", `magUnit`="ABMag", `objectName`="ZTF20acwqqax", `obsdate`="2020-12-10 11:28:58", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acet" ,"30" ,"g-ZTF" ,"1" ,"18.6503" ,null ,"ABMag" ,"ZTF20acwqqax" ,"2020-12-03 12:33:25" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acet", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.6503", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqqax", `obsdate`="2020-12-03 12:33:25", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acet" ,"30" ,"r-ZTF" ,"0" ,"19.68" ,"0.14" ,"ABMag" ,"ZTF20acwqqax" ,"2020-12-10 12:55:22" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acet", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.68", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acwqqax", `obsdate`="2020-12-10 12:55:22", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acet" ,"30" ,"g-ZTF" ,"0" ,"19.73" ,"0.22" ,"ABMag" ,"ZTF20acwqqax" ,"2020-12-10 11:28:58" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acet", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.73", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acwqqax", `obsdate`="2020-12-10 11:28:58", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acet" ,"30" ,"r-ZTF" ,"1" ,"19.7801" ,null ,"ABMag" ,"ZTF20acwqqax" ,"2020-12-05 12:12:44" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acet", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7801", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqqax", `obsdate`="2020-12-05 12:12:44", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acet" ,"30" ,"r-ZTF" ,"0" ,"19.6783" ,"0.13755" ,"ABMag" ,"ZTF20acwqqax" ,"2020-12-10 12:55:22" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acet", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.6783", `magErr`="0.13755", `magUnit`="ABMag", `objectName`="ZTF20acwqqax", `obsdate`="2020-12-10 12:55:22", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acet" ,"30" ,"g-ZTF" ,"0" ,"19.7305" ,"0.222318" ,"ABMag" ,"ZTF20acwqqax" ,"2020-12-10 11:28:58" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acet", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7305", `magErr`="0.222318", `magUnit`="ABMag", `objectName`="ZTF20acwqqax", `obsdate`="2020-12-10 11:28:58", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acet" ,"30" ,"r-ZTF" ,"1" ,"19.7801" ,null ,"ABMag" ,"ZTF20acwqqax" ,"2020-12-05 12:12:44" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acet", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7801", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqqax", `obsdate`="2020-12-05 12:12:44", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acer" ,"30" ,"g-ZTF" ,"0" ,"19.4837" ,"0.188006" ,"ABMag" ,"ZTF20acwpibn" ,"2020-12-10 11:20:10" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acer", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4837", `magErr`="0.188006", `magUnit`="ABMag", `objectName`="ZTF20acwpibn", `obsdate`="2020-12-10 11:20:10", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acer" ,"30" ,"g-ZTF" ,"1" ,"19.8841" ,null ,"ABMag" ,"ZTF20acwpibn" ,"2020-12-05 12:43:21" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acer", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8841", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwpibn", `obsdate`="2020-12-05 12:43:21", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acer" ,"30" ,"r-ZTF" ,"0" ,"19.53" ,"0.11" ,"ABMag" ,"ZTF20acwpibn" ,"2020-12-10 12:20:21" ,"2020-12-15 13:57:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acer", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.53", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acwpibn", `obsdate`="2020-12-10 12:20:21", `reportAddedDate`="2020-12-15 13:57:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acer" ,"30" ,"g-ZTF" ,"0" ,"19.48" ,"0.19" ,"ABMag" ,"ZTF20acwpibn" ,"2020-12-10 11:20:10" ,"2020-12-15 13:57:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acer", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.48", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acwpibn", `obsdate`="2020-12-10 11:20:10", `reportAddedDate`="2020-12-15 13:57:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acer" ,"30" ,"g-ZTF" ,"1" ,"19.8841" ,null ,"ABMag" ,"ZTF20acwpibn" ,"2020-12-05 12:43:21" ,"2020-12-15 13:57:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acer", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8841", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwpibn", `obsdate`="2020-12-05 12:43:21", `reportAddedDate`="2020-12-15 13:57:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acer" ,"30" ,"r-ZTF" ,"0" ,"19.532" ,"0.111752" ,"ABMag" ,"ZTF20acwpibn" ,"2020-12-10 12:20:21" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acer", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.532", `magErr`="0.111752", `magUnit`="ABMag", `objectName`="ZTF20acwpibn", `obsdate`="2020-12-10 12:20:21", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acer" ,"30" ,"g-ZTF" ,"0" ,"19.4837" ,"0.188006" ,"ABMag" ,"ZTF20acwpibn" ,"2020-12-10 11:20:10" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acer", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4837", `magErr`="0.188006", `magUnit`="ABMag", `objectName`="ZTF20acwpibn", `obsdate`="2020-12-10 11:20:10", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acer" ,"30" ,"r-ZTF" ,"1" ,"16.3958" ,null ,"ABMag" ,"ZTF20acwpibn" ,"2020-12-07 11:12:08" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acer", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="16.3958", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwpibn", `obsdate`="2020-12-07 11:12:08", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acej" ,"30" ,"g-ZTF" ,"0" ,"18.9834" ,"0.110894" ,"ABMag" ,"ZTF20acwphqb" ,"2020-12-10 11:07:44" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acej", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.9834", `magErr`="0.110894", `magUnit`="ABMag", `objectName`="ZTF20acwphqb", `obsdate`="2020-12-10 11:07:44", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acej" ,"30" ,"g-ZTF" ,"1" ,"19.8762" ,null ,"ABMag" ,"ZTF20acwphqb" ,"2020-12-05 12:59:46" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acej", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8762", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwphqb", `obsdate`="2020-12-05 12:59:46", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acej" ,"30" ,"r-ZTF" ,"0" ,"19.21" ,"0.11" ,"ABMag" ,"ZTF20acwphqb" ,"2020-12-10 12:53:20" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acej", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.21", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acwphqb", `obsdate`="2020-12-10 12:53:20", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acej" ,"30" ,"g-ZTF" ,"0" ,"18.98" ,"0.11" ,"ABMag" ,"ZTF20acwphqb" ,"2020-12-10 11:07:44" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acej", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.98", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acwphqb", `obsdate`="2020-12-10 11:07:44", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acej" ,"30" ,"g-ZTF" ,"1" ,"19.8762" ,null ,"ABMag" ,"ZTF20acwphqb" ,"2020-12-05 12:59:46" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acej", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8762", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwphqb", `obsdate`="2020-12-05 12:59:46", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acej" ,"30" ,"r-ZTF" ,"0" ,"19.2074" ,"0.110926" ,"ABMag" ,"ZTF20acwphqb" ,"2020-12-10 12:53:20" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acej", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2074", `magErr`="0.110926", `magUnit`="ABMag", `objectName`="ZTF20acwphqb", `obsdate`="2020-12-10 12:53:20", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acej" ,"30" ,"g-ZTF" ,"0" ,"18.9834" ,"0.110894" ,"ABMag" ,"ZTF20acwphqb" ,"2020-12-10 11:07:44" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acej", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.9834", `magErr`="0.110894", `magUnit`="ABMag", `objectName`="ZTF20acwphqb", `obsdate`="2020-12-10 11:07:44", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acej" ,"30" ,"g-ZTF" ,"1" ,"19.8762" ,null ,"ABMag" ,"ZTF20acwphqb" ,"2020-12-05 12:59:46" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acej", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8762", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwphqb", `obsdate`="2020-12-05 12:59:46", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aceg" ,"30" ,"cyan-ATLAS" ,"0" ,"18.245" ,"0.112" ,"ABMag" ,"ATLAS20bior" ,"2020-12-17 14:48:29" ,"2020-12-21 12:01:13" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.245", `magErr`="0.112", `magUnit`="ABMag", `objectName`="ATLAS20bior", `obsdate`="2020-12-17 14:48:29", `reportAddedDate`="2020-12-21 12:01:13", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aceg" ,"30" ,"cyan-ATLAS" ,"1" ,"19.59" ,null ,"ABMag" ,"ATLAS20bior" ,"2020-12-11 15:07:12" ,"2020-12-21 12:01:13" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.59", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bior", `obsdate`="2020-12-11 15:07:12", `reportAddedDate`="2020-12-21 12:01:13", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aceg" ,"30" ,"r-ZTF" ,"0" ,"20.6" ,"0.21" ,"ABMag" ,"ZTF20acwozwz" ,"2020-12-10 12:17:15" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.6", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF20acwozwz", `obsdate`="2020-12-10 12:17:15", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aceg" ,"30" ,"g-ZTF" ,"0" ,"20.31" ,"0.17" ,"ABMag" ,"ZTF20acwozwz" ,"2020-12-10 10:37:19" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.31", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acwozwz", `obsdate`="2020-12-10 10:37:19", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aceg" ,"30" ,"g-ZTF" ,"1" ,"19.7359" ,null ,"ABMag" ,"ZTF20acwozwz" ,"2020-12-05 10:56:53" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7359", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwozwz", `obsdate`="2020-12-05 10:56:53", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aceg" ,"30" ,"r-ZTF" ,"0" ,"20.6039" ,"0.212929" ,"ABMag" ,"ZTF20acwozwz" ,"2020-12-10 12:17:15" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.6039", `magErr`="0.212929", `magUnit`="ABMag", `objectName`="ZTF20acwozwz", `obsdate`="2020-12-10 12:17:15", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aceg" ,"30" ,"g-ZTF" ,"0" ,"20.3087" ,"0.172015" ,"ABMag" ,"ZTF20acwozwz" ,"2020-12-10 10:37:19" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.3087", `magErr`="0.172015", `magUnit`="ABMag", `objectName`="ZTF20acwozwz", `obsdate`="2020-12-10 10:37:19", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aceg" ,"30" ,"g-ZTF" ,"1" ,"19.7359" ,null ,"ABMag" ,"ZTF20acwozwz" ,"2020-12-05 10:56:53" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aceg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7359", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwozwz", `obsdate`="2020-12-05 10:56:53", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"g-ZTF" ,"0" ,"19.7194" ,"0.158116" ,"ABMag" ,"ZTF20acwnrty" ,"2020-12-10 10:07:39" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7194", `magErr`="0.158116", `magUnit`="ABMag", `objectName`="ZTF20acwnrty", `obsdate`="2020-12-10 10:07:39", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"g-ZTF" ,"1" ,"19.0861" ,null ,"ABMag" ,"ZTF20acwnrty" ,"2020-12-04 09:09:16" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.0861", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwnrty", `obsdate`="2020-12-04 09:09:16", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"45" ,"w-PS1" ,"0" ,"19.13" ,"0.06" ,"ABMag" ,"PS20mhi" ,"2020-12-12 12:24:29" ,"2020-12-17 20:02:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.13", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20mhi", `obsdate`="2020-12-12 12:24:29", `reportAddedDate`="2020-12-17 20:02:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"r-ZTF" ,"0" ,"19.77" ,"0.18" ,"ABMag" ,"ZTF20acwnrty" ,"2020-12-10 12:03:50" ,"2020-12-15 09:55:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.77", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acwnrty", `obsdate`="2020-12-10 12:03:50", `reportAddedDate`="2020-12-15 09:55:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"g-ZTF" ,"0" ,"19.72" ,"0.16" ,"ABMag" ,"ZTF20acwnrty" ,"2020-12-10 10:07:39" ,"2020-12-15 09:55:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.72", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acwnrty", `obsdate`="2020-12-10 10:07:39", `reportAddedDate`="2020-12-15 09:55:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"g-ZTF" ,"1" ,"19.7547" ,null ,"ABMag" ,"ZTF20acwnrty" ,"2020-12-02 11:42:12" ,"2020-12-15 09:55:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7547", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwnrty", `obsdate`="2020-12-02 11:42:12", `reportAddedDate`="2020-12-15 09:55:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"cyan-ATLAS" ,"0" ,"19.192" ,"0.131" ,"ABMag" ,"ATLAS20bhob" ,"2020-12-12 12:37:26" ,"2020-12-12 22:08:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.192", `magErr`="0.131", `magUnit`="ABMag", `objectName`="ATLAS20bhob", `obsdate`="2020-12-12 12:37:26", `reportAddedDate`="2020-12-12 22:08:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"orange-ATLAS" ,"1" ,"19.75" ,null ,"ABMag" ,"ATLAS20bhob" ,"2020-12-10 13:49:26" ,"2020-12-12 22:08:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.75", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhob", `obsdate`="2020-12-10 13:49:26", `reportAddedDate`="2020-12-12 22:08:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"r-ZTF" ,"0" ,"19.7748" ,"0.175379" ,"ABMag" ,"ZTF20acwnrty" ,"2020-12-10 12:03:50" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7748", `magErr`="0.175379", `magUnit`="ABMag", `objectName`="ZTF20acwnrty", `obsdate`="2020-12-10 12:03:50", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"g-ZTF" ,"0" ,"19.7194" ,"0.158116" ,"ABMag" ,"ZTF20acwnrty" ,"2020-12-10 10:07:39" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7194", `magErr`="0.158116", `magUnit`="ABMag", `objectName`="ZTF20acwnrty", `obsdate`="2020-12-10 10:07:39", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acef" ,"30" ,"r-ZTF" ,"1" ,"17.1691" ,null ,"ABMag" ,"ZTF20acwnrty" ,"2020-12-07 11:08:37" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acef", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="17.1691", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwnrty", `obsdate`="2020-12-07 11:08:37", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aced" ,"30" ,"g-ZTF" ,"0" ,"18.3715" ,"0.062838" ,"ABMag" ,"ZTF20acwoamm" ,"2020-12-10 10:05:37" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.3715", `magErr`="0.062838", `magUnit`="ABMag", `objectName`="ZTF20acwoamm", `obsdate`="2020-12-10 10:05:37", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aced" ,"30" ,"g-ZTF" ,"1" ,"19.4903" ,null ,"ABMag" ,"ZTF20acwoamm" ,"2020-12-02 10:39:51" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.4903", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwoamm", `obsdate`="2020-12-02 10:39:51", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aced" ,"30" ,"r-ZTF" ,"0" ,"18.55" ,"0.06" ,"ABMag" ,"ZTF20acwoamm" ,"2020-12-10 11:38:51" ,"2020-12-15 09:55:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.55", `magErr`="0.06", `magUnit`="ABMag", `objectName`="ZTF20acwoamm", `obsdate`="2020-12-10 11:38:51", `reportAddedDate`="2020-12-15 09:55:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aced" ,"30" ,"g-ZTF" ,"0" ,"18.37" ,"0.06" ,"ABMag" ,"ZTF20acwoamm" ,"2020-12-10 10:05:37" ,"2020-12-15 09:55:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.37", `magErr`="0.06", `magUnit`="ABMag", `objectName`="ZTF20acwoamm", `obsdate`="2020-12-10 10:05:37", `reportAddedDate`="2020-12-15 09:55:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aced" ,"30" ,"g-ZTF" ,"1" ,"19.8395" ,null ,"ABMag" ,"ZTF20acwoamm" ,"2020-11-28 12:29:56" ,"2020-12-15 09:55:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8395", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwoamm", `obsdate`="2020-11-28 12:29:56", `reportAddedDate`="2020-12-15 09:55:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aced" ,"30" ,"r-ZTF" ,"0" ,"18.547" ,"0.0558012" ,"ABMag" ,"ZTF20acwoamm" ,"2020-12-10 11:38:51" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.547", `magErr`="0.0558012", `magUnit`="ABMag", `objectName`="ZTF20acwoamm", `obsdate`="2020-12-10 11:38:51", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aced" ,"30" ,"g-ZTF" ,"0" ,"18.3715" ,"0.0628379" ,"ABMag" ,"ZTF20acwoamm" ,"2020-12-10 10:05:37" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.3715", `magErr`="0.0628379", `magUnit`="ABMag", `objectName`="ZTF20acwoamm", `obsdate`="2020-12-10 10:05:37", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aced" ,"30" ,"r-ZTF" ,"1" ,"18.053" ,null ,"ABMag" ,"ZTF20acwoamm" ,"2020-12-07 10:49:34" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aced", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.053", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwoamm", `obsdate`="2020-12-07 10:49:34", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,"30" ,"cyan-ATLAS" ,"0" ,"18.848" ,"0.105" ,"ABMag" ,"ATLAS20bhor" ,"2020-12-10 11:34:05" ,"2020-12-21 15:00:57" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.848", `magErr`="0.105", `magUnit`="ABMag", `objectName`="ATLAS20bhor", `obsdate`="2020-12-10 11:34:05", `reportAddedDate`="2020-12-21 15:00:57", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,"30" ,"orange-ATLAS" ,"1" ,"19.3" ,null ,"ABMag" ,"ATLAS20bhor" ,"2020-12-08 10:45:07" ,"2020-12-21 15:00:57" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.3", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhor", `obsdate`="2020-12-08 10:45:07", `reportAddedDate`="2020-12-21 15:00:57", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,"60" ,"G-Gaia" ,"0" ,"18.54" ,"0.2" ,"ABMag" ,"Gaia20fth" ,"2020-12-15 07:58:05" ,"2020-12-16 15:20:33" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.54", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fth", `obsdate`="2020-12-15 07:58:05", `reportAddedDate`="2020-12-16 15:20:33", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fth" ,"2020-12-15 06:11:31" ,"2020-12-16 15:20:33" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fth", `obsdate`="2020-12-15 06:11:31", `reportAddedDate`="2020-12-16 15:20:33", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,"30" ,"g-ZTF" ,"0" ,"18.94" ,"0.17" ,"ABMag" ,"ZTF20acwlsro" ,"2020-12-10 08:45:04" ,"2020-12-15 08:55:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.94", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acwlsro", `obsdate`="2020-12-10 08:45:04", `reportAddedDate`="2020-12-15 08:55:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,"30" ,"g-ZTF" ,"0" ,"18.9" ,"0.09" ,"ABMag" ,"ZTF20acwlsro" ,"2020-12-10 08:01:15" ,"2020-12-15 08:55:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.9", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acwlsro", `obsdate`="2020-12-10 08:01:15", `reportAddedDate`="2020-12-15 08:55:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,"30" ,"g-ZTF" ,"1" ,"19.597" ,null ,"ABMag" ,"ZTF20acwlsro" ,"2020-12-07 08:32:49" ,"2020-12-15 08:55:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.597", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwlsro", `obsdate`="2020-12-07 08:32:49", `reportAddedDate`="2020-12-15 08:55:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,"30" ,"g-ZTF" ,"0" ,"18.9417" ,"0.165488" ,"ABMag" ,"ZTF20acwlsro" ,"2020-12-10 08:45:04" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.9417", `magErr`="0.165488", `magUnit`="ABMag", `objectName`="ZTF20acwlsro", `obsdate`="2020-12-10 08:45:04", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,"30" ,"g-ZTF" ,"0" ,"18.8967" ,"0.0850496" ,"ABMag" ,"ZTF20acwlsro" ,"2020-12-10 08:01:15" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.8967", `magErr`="0.0850496", `magUnit`="ABMag", `objectName`="ZTF20acwlsro", `obsdate`="2020-12-10 08:01:15", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdz" ,"30" ,"r-ZTF" ,"1" ,"15.1253" ,null ,"ABMag" ,"ZTF20acwlsro" ,"2020-12-07 10:04:30" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="15.1253", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwlsro", `obsdate`="2020-12-07 10:04:30", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"r-ZTF" ,"0" ,"18.9712" ,"0.077135" ,"ABMag" ,"ZTF20acwkwqn" ,"2020-12-10 07:23:32" ,"2020-12-18 20:10:39" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.9712", `magErr`="0.077135", `magUnit`="ABMag", `objectName`="ZTF20acwkwqn", `obsdate`="2020-12-10 07:23:32", `reportAddedDate`="2020-12-18 20:10:39", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"r-ZTF" ,"1" ,"16.906" ,null ,"ABMag" ,"ZTF20acwkwqn" ,"2020-12-07 10:28:30" ,"2020-12-18 20:10:39" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="16.906", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwkwqn", `obsdate`="2020-12-07 10:28:30", `reportAddedDate`="2020-12-18 20:10:39", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"g-ZTF" ,"0" ,"18.84" ,"0.07" ,"ABMag" ,"ZTF20acwkwqn" ,"2020-12-10 10:26:16" ,"2020-12-16 07:58:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.84", `magErr`="0.07", `magUnit`="ABMag", `objectName`="ZTF20acwkwqn", `obsdate`="2020-12-10 10:26:16", `reportAddedDate`="2020-12-16 07:58:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"r-ZTF" ,"0" ,"18.97" ,"0.08" ,"ABMag" ,"ZTF20acwkwqn" ,"2020-12-10 07:23:32" ,"2020-12-16 07:58:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.97", `magErr`="0.08", `magUnit`="ABMag", `objectName`="ZTF20acwkwqn", `obsdate`="2020-12-10 07:23:32", `reportAddedDate`="2020-12-16 07:58:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"g-ZTF" ,"1" ,"19.7082" ,null ,"ABMag" ,"ZTF20acwkwqn" ,"2020-12-05 10:41:18" ,"2020-12-16 07:58:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7082", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwkwqn", `obsdate`="2020-12-05 10:41:18", `reportAddedDate`="2020-12-16 07:58:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"cyan-ATLAS" ,"0" ,"19.187" ,"0.133" ,"ABMag" ,"ATLAS20bhkw" ,"2020-12-09 10:58:05" ,"2020-12-12 00:32:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.187", `magErr`="0.133", `magUnit`="ABMag", `objectName`="ATLAS20bhkw", `obsdate`="2020-12-09 10:58:05", `reportAddedDate`="2020-12-12 00:32:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"orange-ATLAS" ,"1" ,"19.56" ,null ,"ABMag" ,"ATLAS20bhkw" ,"2020-12-08 11:12:29" ,"2020-12-12 00:32:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.56", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhkw", `obsdate`="2020-12-08 11:12:29", `reportAddedDate`="2020-12-12 00:32:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"g-ZTF" ,"0" ,"18.84" ,"0.0715957" ,"ABMag" ,"ZTF20acwkwqn" ,"2020-12-10 10:26:16" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.84", `magErr`="0.0715957", `magUnit`="ABMag", `objectName`="ZTF20acwkwqn", `obsdate`="2020-12-10 10:26:16", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"r-ZTF" ,"0" ,"18.9712" ,"0.0771345" ,"ABMag" ,"ZTF20acwkwqn" ,"2020-12-10 07:23:32" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.9712", `magErr`="0.0771345", `magUnit`="ABMag", `objectName`="ZTF20acwkwqn", `obsdate`="2020-12-10 07:23:32", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdw" ,"30" ,"r-ZTF" ,"1" ,"16.906" ,null ,"ABMag" ,"ZTF20acwkwqn" ,"2020-12-07 10:28:30" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="16.906", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwkwqn", `obsdate`="2020-12-07 10:28:30", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdv" ,"30" ,"r-ZTF" ,"0" ,"18.9601" ,"0.09705" ,"ABMag" ,"ZTF20acwkvgj" ,"2020-12-10 07:23:32" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.9601", `magErr`="0.09705", `magUnit`="ABMag", `objectName`="ZTF20acwkvgj", `obsdate`="2020-12-10 07:23:32", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdv" ,"30" ,"r-ZTF" ,"1" ,"17.1352" ,null ,"ABMag" ,"ZTF20acwkvgj" ,"2020-12-07 10:28:30" ,"2020-12-20 20:13:23" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="17.1352", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwkvgj", `obsdate`="2020-12-07 10:28:30", `reportAddedDate`="2020-12-20 20:13:23", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdv" ,"30" ,"g-ZTF" ,"0" ,"18.9608" ,"0.0771641" ,"ABMag" ,"ZTF20acwkvgj" ,"2020-12-10 10:26:16" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.9608", `magErr`="0.0771641", `magUnit`="ABMag", `objectName`="ZTF20acwkvgj", `obsdate`="2020-12-10 10:26:16", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdv" ,"30" ,"r-ZTF" ,"0" ,"18.9601" ,"0.0970504" ,"ABMag" ,"ZTF20acwkvgj" ,"2020-12-10 07:23:32" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.9601", `magErr`="0.0970504", `magUnit`="ABMag", `objectName`="ZTF20acwkvgj", `obsdate`="2020-12-10 07:23:32", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdv" ,"30" ,"r-ZTF" ,"1" ,"17.1352" ,null ,"ABMag" ,"ZTF20acwkvgj" ,"2020-12-07 10:28:30" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="17.1352", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwkvgj", `obsdate`="2020-12-07 10:28:30", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdu" ,"30" ,"g-ZTF" ,"0" ,"20.47" ,"0.25" ,"ABMag" ,"ZTF20acwjhpo" ,"2020-12-10 07:55:46" ,"2020-12-19 07:58:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.47", `magErr`="0.25", `magUnit`="ABMag", `objectName`="ZTF20acwjhpo", `obsdate`="2020-12-10 07:55:46", `reportAddedDate`="2020-12-19 07:58:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdu" ,"30" ,"r-ZTF" ,"0" ,"20.19" ,"0.17" ,"ABMag" ,"ZTF20acwjhpo" ,"2020-12-10 06:30:05" ,"2020-12-19 07:58:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.19", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acwjhpo", `obsdate`="2020-12-10 06:30:05", `reportAddedDate`="2020-12-19 07:58:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdu" ,"30" ,"g-ZTF" ,"1" ,"20.3896" ,null ,"ABMag" ,"ZTF20acwjhpo" ,"2020-12-07 06:35:09" ,"2020-12-19 07:58:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3896", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwjhpo", `obsdate`="2020-12-07 06:35:09", `reportAddedDate`="2020-12-19 07:58:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdu" ,"30" ,"g-ZTF" ,"0" ,"20.47" ,"0.25" ,"ABMag" ,"ZTF20acwjhpo" ,"2020-12-10 07:55:46" ,"2020-12-19 05:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.47", `magErr`="0.25", `magUnit`="ABMag", `objectName`="ZTF20acwjhpo", `obsdate`="2020-12-10 07:55:46", `reportAddedDate`="2020-12-19 05:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdu" ,"30" ,"r-ZTF" ,"0" ,"20.19" ,"0.17" ,"ABMag" ,"ZTF20acwjhpo" ,"2020-12-10 06:30:05" ,"2020-12-19 05:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.19", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acwjhpo", `obsdate`="2020-12-10 06:30:05", `reportAddedDate`="2020-12-19 05:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdu" ,"30" ,"g-ZTF" ,"1" ,"20.3896" ,null ,"ABMag" ,"ZTF20acwjhpo" ,"2020-12-07 06:35:09" ,"2020-12-19 05:58:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3896", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwjhpo", `obsdate`="2020-12-07 06:35:09", `reportAddedDate`="2020-12-19 05:58:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdu" ,"30" ,"r-ZTF" ,"0" ,"20.1867" ,"0.174191" ,"ABMag" ,"ZTF20acwjhpo" ,"2020-12-10 06:30:05" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1867", `magErr`="0.174191", `magUnit`="ABMag", `objectName`="ZTF20acwjhpo", `obsdate`="2020-12-10 06:30:05", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdu" ,"30" ,"g-ZTF" ,"1" ,"20.3896" ,null ,"ABMag" ,"ZTF20acwjhpo" ,"2020-12-07 06:35:09" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3896", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwjhpo", `obsdate`="2020-12-07 06:35:09", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdr" ,"45" ,"w-PS1" ,"0" ,"20.5" ,"0.05" ,"ABMag" ,"PS20mkl" ,"2020-12-06 06:46:05" ,"2020-12-19 19:02:26" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdr", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.5", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS20mkl", `obsdate`="2020-12-06 06:46:05", `reportAddedDate`="2020-12-19 19:02:26", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdr" ,"30" ,"r-ZTF" ,"0" ,"19.9193" ,"0.147287" ,"ABMag" ,"ZTF20acwikji" ,"2020-12-10 05:55:54" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9193", `magErr`="0.147287", `magUnit`="ABMag", `objectName`="ZTF20acwikji", `obsdate`="2020-12-10 05:55:54", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acdr" ,"30" ,"r-ZTF" ,"1" ,"19.998" ,null ,"ABMag" ,"ZTF20acwikji" ,"2020-12-10 05:41:58" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acdr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.998", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwikji", `obsdate`="2020-12-10 05:41:58", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acca" ,"30" ,"cyan-ATLAS" ,"0" ,"19.45" ,"0.158" ,"ABMag" ,"ATLAS20bhgb" ,"2020-12-10 09:40:19" ,"2020-12-21 15:02:22" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.45", `magErr`="0.158", `magUnit`="ABMag", `objectName`="ATLAS20bhgb", `obsdate`="2020-12-10 09:40:19", `reportAddedDate`="2020-12-21 15:02:22", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acca" ,"30" ,"orange-ATLAS" ,"1" ,"19.41" ,null ,"ABMag" ,"ATLAS20bhgb" ,"2020-12-08 11:09:36" ,"2020-12-21 15:02:22" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.41", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhgb", `obsdate`="2020-12-08 11:09:36", `reportAddedDate`="2020-12-21 15:02:22", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acca" ,"45" ,"w-PS1" ,"0" ,"19.39" ,"0.05" ,"ABMag" ,"PS20meh" ,"2020-12-12 09:00:00" ,"2020-12-15 11:54:16" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.39", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS20meh", `obsdate`="2020-12-12 09:00:00", `reportAddedDate`="2020-12-15 11:54:16", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acca" ,"30" ,"r-ZTF" ,"0" ,"19.69" ,"0.18" ,"ABMag" ,"ZTF20acwijiy" ,"2020-12-10 06:02:18" ,"2020-12-12 06:54:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.69", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acwijiy", `obsdate`="2020-12-10 06:02:18", `reportAddedDate`="2020-12-12 06:54:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acca" ,"30" ,"r-ZTF" ,"0" ,"20.23" ,"0.32" ,"ABMag" ,"ZTF20acwijiy" ,"2020-12-07 04:20:36" ,"2020-12-12 06:54:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.23", `magErr`="0.32", `magUnit`="ABMag", `objectName`="ZTF20acwijiy", `obsdate`="2020-12-07 04:20:36", `reportAddedDate`="2020-12-12 06:54:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acca" ,"30" ,"g-ZTF" ,"1" ,"20.2283" ,null ,"ABMag" ,"ZTF20acwijiy" ,"2020-11-23 08:57:42" ,"2020-12-12 06:54:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.2283", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwijiy", `obsdate`="2020-11-23 08:57:42", `reportAddedDate`="2020-12-12 06:54:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acca" ,"30" ,"g-ZTF" ,"0" ,"19.49" ,null ,"ABMag" ,"ZTF20acwijiy" ,"2020-12-10 07:59:31" ,"2020-12-10 12:45:14" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.49", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwijiy", `obsdate`="2020-12-10 07:59:31", `reportAddedDate`="2020-12-10 12:45:14", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acca" ,"30" ,"r-ZTF" ,"0" ,"20.23" ,null ,"ABMag" ,"ZTF20acwijiy" ,"2020-12-07 04:20:38" ,"2020-12-10 12:45:14" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.23", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwijiy", `obsdate`="2020-12-07 04:20:38", `reportAddedDate`="2020-12-10 12:45:14", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acca" ,"30" ,"g-ZTF" ,"1" ,"19.22" ,null ,"ABMag" ,"ZTF20acwijiy" ,"2020-12-04 08:09:36" ,"2020-12-10 12:45:14" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acca", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.22", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwijiy", `obsdate`="2020-12-04 08:09:36", `reportAddedDate`="2020-12-10 12:45:14", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbw" ,"30" ,"cyan-ATLAS" ,"0" ,"19.176" ,"0.153" ,"ABMag" ,"ATLAS20bhpd" ,"2020-12-17 14:29:46" ,"2020-12-21 12:03:58" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbw", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.176", `magErr`="0.153", `magUnit`="ABMag", `objectName`="ATLAS20bhpd", `obsdate`="2020-12-17 14:29:46", `reportAddedDate`="2020-12-21 12:03:58", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbw" ,"30" ,"cyan-ATLAS" ,"1" ,"19.64" ,null ,"ABMag" ,"ATLAS20bhpd" ,"2020-12-11 14:47:02" ,"2020-12-21 12:03:58" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbw", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.64", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhpd", `obsdate`="2020-12-11 14:47:02", `reportAddedDate`="2020-12-21 12:03:58", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbw" ,"30" ,"g-ZTF" ,"0" ,"19.34" ,"0.12" ,"ABMag" ,"ZTF20acwofly" ,"2020-12-10 11:19:27" ,"2020-12-10 12:37:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.34", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acwofly", `obsdate`="2020-12-10 11:19:27", `reportAddedDate`="2020-12-10 12:37:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbw" ,"30" ,"g-ZTF" ,"0" ,"19.97" ,"0.25" ,"ABMag" ,"ZTF20acwofly" ,"2020-12-05 10:57:33" ,"2020-12-10 12:37:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.97", `magErr`="0.25", `magUnit`="ABMag", `objectName`="ZTF20acwofly", `obsdate`="2020-12-05 10:57:33", `reportAddedDate`="2020-12-10 12:37:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbw" ,"30" ,"r-ZTF" ,"1" ,"19.7206" ,null ,"ABMag" ,"ZTF20acwofly" ,"2020-12-05 09:17:35" ,"2020-12-10 12:37:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7206", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwofly", `obsdate`="2020-12-05 09:17:35", `reportAddedDate`="2020-12-10 12:37:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,"60" ,"G-Gaia" ,"0" ,"17.11" ,"0.2" ,"ABMag" ,"Gaia20ful" ,"2020-12-18 07:13:26" ,"2020-12-19 14:14:28" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.11", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20ful", `obsdate`="2020-12-18 07:13:26", `reportAddedDate`="2020-12-19 14:14:28", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20ful" ,"2020-08-07 14:24:00" ,"2020-12-19 14:14:28" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20ful", `obsdate`="2020-08-07 14:24:00", `reportAddedDate`="2020-12-19 14:14:28", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,"30" ,"cyan-ATLAS" ,"0" ,"17.104" ,"0.043" ,"ABMag" ,"ATLAS20bigs" ,"2020-12-15 07:26:24" ,"2020-12-15 09:40:59" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="17.104", `magErr`="0.043", `magUnit`="ABMag", `objectName`="ATLAS20bigs", `obsdate`="2020-12-15 07:26:24", `reportAddedDate`="2020-12-15 09:40:59", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,"30" ,"cyan-ATLAS" ,"1" ,"18.68" ,null ,"ABMag" ,"ATLAS20bigs" ,"2020-12-13 10:01:55" ,"2020-12-15 09:40:59" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="18.68", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bigs", `obsdate`="2020-12-13 10:01:55", `reportAddedDate`="2020-12-15 09:40:59", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,"30" ,"r-ZTF" ,"0" ,"18.75" ,"0.11" ,"ABMag" ,"ZTF20acwgxhk" ,"2020-12-10 05:38:35" ,"2020-12-14 05:54:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.75", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acwgxhk", `obsdate`="2020-12-10 05:38:35", `reportAddedDate`="2020-12-14 05:54:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,"30" ,"g-ZTF" ,"0" ,"18.36" ,"0.07" ,"ABMag" ,"ZTF20acwgxhk" ,"2020-12-10 04:44:06" ,"2020-12-14 05:54:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.36", `magErr`="0.07", `magUnit`="ABMag", `objectName`="ZTF20acwgxhk", `obsdate`="2020-12-10 04:44:06", `reportAddedDate`="2020-12-14 05:54:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,"30" ,"r-ZTF" ,"1" ,"20.2951" ,null ,"ABMag" ,"ZTF20acwgxhk" ,"2020-12-06 05:08:22" ,"2020-12-14 05:54:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.2951", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwgxhk", `obsdate`="2020-12-06 05:08:22", `reportAddedDate`="2020-12-14 05:54:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,"30" ,"r-ZTF" ,"0" ,"18.75" ,null ,"ABMag" ,"ZTF20acwgxhk" ,"2020-12-10 05:38:24" ,"2020-12-10 10:44:06" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.75", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwgxhk", `obsdate`="2020-12-10 05:38:24", `reportAddedDate`="2020-12-10 10:44:06", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,"30" ,"g-ZTF" ,"0" ,"18.36" ,null ,"ABMag" ,"ZTF20acwgxhk" ,"2020-12-10 04:43:41" ,"2020-12-10 10:44:06" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.36", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwgxhk", `obsdate`="2020-12-10 04:43:41", `reportAddedDate`="2020-12-10 10:44:06", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbm" ,"30" ,"g-ZTF" ,"1" ,"18.1" ,null ,"ABMag" ,"ZTF20acwgxhk" ,"2020-12-08 05:34:05" ,"2020-12-10 10:44:06" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.1", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwgxhk", `obsdate`="2020-12-08 05:34:05", `reportAddedDate`="2020-12-10 10:44:06", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbc" ,"30" ,"cyan-ATLAS" ,"0" ,"19.136" ,"0.106" ,"ABMag" ,"ATLAS20bhni" ,"2020-12-12 09:17:17" ,"2020-12-20 18:59:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbc", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.136", `magErr`="0.106", `magUnit`="ABMag", `objectName`="ATLAS20bhni", `obsdate`="2020-12-12 09:17:17", `reportAddedDate`="2020-12-20 18:59:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbc" ,"30" ,"cyan-ATLAS" ,"1" ,"19.75" ,null ,"ABMag" ,"ATLAS20bhni" ,"2020-12-10 09:54:43" ,"2020-12-20 18:59:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbc", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.75", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhni", `obsdate`="2020-12-10 09:54:43", `reportAddedDate`="2020-12-20 18:59:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbc" ,"30" ,"r-ZTF" ,"0" ,"19.57" ,"0.15" ,"ABMag" ,"ZTF20acwilfu" ,"2020-12-10 06:01:38" ,"2020-12-10 08:36:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.57", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acwilfu", `obsdate`="2020-12-10 06:01:38", `reportAddedDate`="2020-12-10 08:36:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbc" ,"30" ,"r-ZTF" ,"0" ,"20.04" ,"0.28" ,"ABMag" ,"ZTF20acwilfu" ,"2020-12-06 06:15:19" ,"2020-12-10 08:36:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.04", `magErr`="0.28", `magUnit`="ABMag", `objectName`="ZTF20acwilfu", `obsdate`="2020-12-06 06:15:19", `reportAddedDate`="2020-12-10 08:36:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acbc" ,"30" ,"g-ZTF" ,"1" ,"19.8962" ,null ,"ABMag" ,"ZTF20acwilfu" ,"2020-11-24 09:05:39" ,"2020-12-10 08:36:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acbc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8962", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwilfu", `obsdate`="2020-11-24 09:05:39", `reportAddedDate`="2020-12-10 08:36:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acba" ,"30" ,"orange-ATLAS" ,"0" ,"18.227" ,"0.165" ,"ABMag" ,"ATLAS20bhky" ,"2020-02-20 08:32:38" ,"2020-12-21 15:00:31" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acba", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.227", `magErr`="0.165", `magUnit`="ABMag", `objectName`="ATLAS20bhky", `obsdate`="2020-02-20 08:32:38", `reportAddedDate`="2020-12-21 15:00:31", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acba" ,"30" ,"orange-ATLAS" ,"1" ,"18.49" ,null ,"ABMag" ,"ATLAS20bhky" ,"2020-02-12 09:27:22" ,"2020-12-21 15:00:31" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acba", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.49", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhky", `obsdate`="2020-02-12 09:27:22", `reportAddedDate`="2020-12-21 15:00:31", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acba" ,"30" ,"g-ZTF" ,"0" ,"19.46" ,"0.16" ,"ABMag" ,"ZTF20acvcxkd" ,"2020-12-10 08:05:58" ,"2020-12-10 08:36:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acba", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.46", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acvcxkd", `obsdate`="2020-12-10 08:05:58", `reportAddedDate`="2020-12-10 08:36:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acba" ,"30" ,"r-ZTF" ,"0" ,"19.48" ,"0.14" ,"ABMag" ,"ZTF20acvcxkd" ,"2020-12-10 06:47:48" ,"2020-12-10 08:36:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acba", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.48", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acvcxkd", `obsdate`="2020-12-10 06:47:48", `reportAddedDate`="2020-12-10 08:36:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acba" ,"30" ,"r-ZTF" ,"1" ,"19.6464" ,null ,"ABMag" ,"ZTF20acvcxkd" ,"2020-11-24 08:16:21" ,"2020-12-10 08:36:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acba", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6464", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvcxkd", `obsdate`="2020-11-24 08:16:21", `reportAddedDate`="2020-12-10 08:36:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acat" ,"45" ,"w-PS1" ,"0" ,"16.08" ,"0.01" ,"ABMag" ,"PS20mhj" ,"2020-12-15 13:55:12" ,"2020-12-18 11:12:23" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="16.08", `magErr`="0.01", `magUnit`="ABMag", `objectName`="PS20mhj", `obsdate`="2020-12-15 13:55:12", `reportAddedDate`="2020-12-18 11:12:23", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acat" ,"30" ,"r-ZTF" ,"0" ,"16.87" ,"0.04" ,"ABMag" ,"ZTF20acwqqjs" ,"2020-12-12 11:37:55" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="16.87", `magErr`="0.04", `magUnit`="ABMag", `objectName`="ZTF20acwqqjs", `obsdate`="2020-12-12 11:37:55", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acat" ,"30" ,"r-ZTF" ,"0" ,"17.84" ,"0.05" ,"ABMag" ,"ZTF20acwqqjs" ,"2020-12-10 12:59:26" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="17.84", `magErr`="0.05", `magUnit`="ABMag", `objectName`="ZTF20acwqqjs", `obsdate`="2020-12-10 12:59:26", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acat" ,"30" ,"r-ZTF" ,"1" ,"19.5326" ,null ,"ABMag" ,"ZTF20acwqqjs" ,"2020-12-02 12:57:26" ,"2020-12-15 12:57:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5326", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqqjs", `obsdate`="2020-12-02 12:57:26", `reportAddedDate`="2020-12-15 12:57:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acat" ,"30" ,"r-ZTF" ,"0" ,"17.8354" ,null ,"ABMag" ,"ZTF20acwqqjs" ,"2020-12-10 12:59:26" ,"2020-12-13 05:02:14" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="17.8354", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqqjs", `obsdate`="2020-12-10 12:59:26", `reportAddedDate`="2020-12-13 05:02:14", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acat" ,"30" ,"g-ZTF" ,"1" ,"19.1816" ,null ,"ABMag" ,"ZTF20acwqqjs" ,"2020-12-06 12:10:44" ,"2020-12-13 05:02:14" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.1816", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqqjs", `obsdate`="2020-12-06 12:10:44", `reportAddedDate`="2020-12-13 05:02:14", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acat" ,"30" ,"orange-ATLAS" ,"0" ,"18.48" ,"0.141" ,"ABMag" ,"ATLAS20bhfe" ,"2020-12-09 15:07:12" ,"2020-12-10 00:28:05" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.48", `magErr`="0.141", `magUnit`="ABMag", `objectName`="ATLAS20bhfe", `obsdate`="2020-12-09 15:07:12", `reportAddedDate`="2020-12-10 00:28:05", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acat" ,"30" ,"orange-ATLAS" ,"1" ,"19.07" ,null ,"ABMag" ,"ATLAS20bhfe" ,"2020-12-07 14:36:58" ,"2020-12-10 00:28:05" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acat", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.07", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhfe", `obsdate`="2020-12-07 14:36:58", `reportAddedDate`="2020-12-10 00:28:05", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abym" ,"60" ,"G-Gaia" ,"0" ,"18.9" ,"0.2" ,"ABMag" ,"Gaia20fus" ,"2020-12-19 07:45:07" ,"2020-12-20 11:57:59" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abym", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.9", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fus", `obsdate`="2020-12-19 07:45:07", `reportAddedDate`="2020-12-20 11:57:59", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abym" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fus" ,"2020-07-31 02:06:43" ,"2020-12-20 11:57:59" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abym", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fus", `obsdate`="2020-07-31 02:06:43", `reportAddedDate`="2020-12-20 11:57:59", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abym" ,"30" ,"cyan-ATLAS" ,"0" ,"19.142" ,"0.122" ,"ABMag" ,"ATLAS20bhbd" ,"2020-12-08 06:56:10" ,"2020-12-08 14:14:36" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abym", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.142", `magErr`="0.122", `magUnit`="ABMag", `objectName`="ATLAS20bhbd", `obsdate`="2020-12-08 06:56:10", `reportAddedDate`="2020-12-08 14:14:36", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abym" ,"30" ,"orange-ATLAS" ,"1" ,"19.83" ,null ,"ABMag" ,"ATLAS20bhbd" ,"2020-12-06 07:32:10" ,"2020-12-08 14:14:36" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abym", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.83", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhbd", `obsdate`="2020-12-06 07:32:10", `reportAddedDate`="2020-12-08 14:14:36", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abxh" ,"60" ,"G-Gaia" ,"0" ,"18.67" ,"0.2" ,"ABMag" ,"Gaia20ftz" ,"2020-12-17 00:17:17" ,"2020-12-18 10:26:28" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abxh", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.67", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20ftz", `obsdate`="2020-12-17 00:17:17", `reportAddedDate`="2020-12-18 10:26:28", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abxh" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20ftz" ,"2020-07-31 11:11:02" ,"2020-12-18 10:26:28" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abxh", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20ftz", `obsdate`="2020-07-31 11:11:02", `reportAddedDate`="2020-12-18 10:26:28", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abxh" ,"30" ,"r-ZTF" ,"0" ,"18.47" ,"0.11" ,"ABMag" ,"ZTF20actvrbc" ,"2020-12-16 12:29:55" ,"2020-12-16 13:58:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abxh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.47", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20actvrbc", `obsdate`="2020-12-16 12:29:55", `reportAddedDate`="2020-12-16 13:58:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abxh" ,"30" ,"g-ZTF" ,"0" ,"19.03" ,"0.28" ,"ABMag" ,"ZTF20actvrbc" ,"2020-12-12 13:00:32" ,"2020-12-16 13:58:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abxh", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.03", `magErr`="0.28", `magUnit`="ABMag", `objectName`="ZTF20actvrbc", `obsdate`="2020-12-12 13:00:32", `reportAddedDate`="2020-12-16 13:58:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abxh" ,"30" ,"orange-ATLAS" ,"0" ,"18.307" ,"0.161" ,"ABMag" ,"ATLAS20bgze" ,"2020-12-07 15:12:58" ,"2020-12-07 22:11:30" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abxh", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.307", `magErr`="0.161", `magUnit`="ABMag", `objectName`="ATLAS20bgze", `obsdate`="2020-12-07 15:12:58", `reportAddedDate`="2020-12-07 22:11:30", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abxh" ,"30" ,"orange-ATLAS" ,"1" ,"19.05" ,null ,"ABMag" ,"ATLAS20bgze" ,"2020-08-11 06:12:58" ,"2020-12-07 22:11:30" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abxh", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.05", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bgze", `obsdate`="2020-08-11 06:12:58", `reportAddedDate`="2020-12-07 22:11:30", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwn" ,"30" ,"cyan-ATLAS" ,"0" ,"19.625" ,"0.168" ,"ABMag" ,"ATLAS20bhkx" ,"2020-12-11 09:56:10" ,"2020-12-21 12:08:34" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwn", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.625", `magErr`="0.168", `magUnit`="ABMag", `objectName`="ATLAS20bhkx", `obsdate`="2020-12-11 09:56:10", `reportAddedDate`="2020-12-21 12:08:34", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwn" ,"30" ,"cyan-ATLAS" ,"1" ,"19.75" ,null ,"ABMag" ,"ATLAS20bhkx" ,"2020-12-10 10:40:48" ,"2020-12-21 12:08:34" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwn", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.75", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhkx", `obsdate`="2020-12-10 10:40:48", `reportAddedDate`="2020-12-21 12:08:34", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwn" ,"30" ,"r-ZTF" ,"0" ,"20.0811" ,null ,"ABMag" ,"ZTF20acvdfkf" ,"2020-12-04 05:38:48" ,"2020-12-07 09:43:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0811", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvdfkf", `obsdate`="2020-12-04 05:38:48", `reportAddedDate`="2020-12-07 09:43:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwn" ,"30" ,"g-ZTF" ,"1" ,"19.5202" ,null ,"ABMag" ,"ZTF20acvdfkf" ,"2020-12-04 04:58:56" ,"2020-12-07 09:43:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.5202", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvdfkf", `obsdate`="2020-12-04 04:58:56", `reportAddedDate`="2020-12-07 09:43:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwm" ,"45" ,"w-PS1" ,"0" ,"19.88" ,"0.03" ,"ABMag" ,"PS20mhq" ,"2020-12-07 08:45:36" ,"2020-12-18 15:15:28" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwm", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.88", `magErr`="0.03", `magUnit`="ABMag", `objectName`="PS20mhq", `obsdate`="2020-12-07 08:45:36", `reportAddedDate`="2020-12-18 15:15:28", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwm" ,"30" ,"g-ZTF" ,"0" ,"19.52" ,"0.3" ,"ABMag" ,"ZTF20acvguvq" ,"2020-12-10 04:41:24" ,"2020-12-12 05:56:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.52", `magErr`="0.3", `magUnit`="ABMag", `objectName`="ZTF20acvguvq", `obsdate`="2020-12-10 04:41:24", `reportAddedDate`="2020-12-12 05:56:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwm" ,"30" ,"r-ZTF" ,"0" ,"19.94" ,"0.18" ,"ABMag" ,"ZTF20acvguvq" ,"2020-12-07 04:22:37" ,"2020-12-12 05:56:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.94", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acvguvq", `obsdate`="2020-12-07 04:22:37", `reportAddedDate`="2020-12-12 05:56:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwm" ,"30" ,"g-ZTF" ,"1" ,"19.7011" ,null ,"ABMag" ,"ZTF20acvguvq" ,"2020-12-05 05:08:40" ,"2020-12-12 05:56:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7011", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvguvq", `obsdate`="2020-12-05 05:08:40", `reportAddedDate`="2020-12-12 05:56:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwm" ,"30" ,"cyan-ATLAS" ,"0" ,"19.356" ,"0.138" ,"ABMag" ,"ATLAS20bhfq" ,"2020-12-10 08:42:43" ,"2020-12-10 16:02:04" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.356", `magErr`="0.138", `magUnit`="ABMag", `objectName`="ATLAS20bhfq", `obsdate`="2020-12-10 08:42:43", `reportAddedDate`="2020-12-10 16:02:04", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwm" ,"30" ,"orange-ATLAS" ,"1" ,"19.58" ,null ,"ABMag" ,"ATLAS20bhfq" ,"2020-12-09 09:38:53" ,"2020-12-10 16:02:04" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwm", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.58", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhfq", `obsdate`="2020-12-09 09:38:53", `reportAddedDate`="2020-12-10 16:02:04", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwm" ,"30" ,"r-ZTF" ,"0" ,"20.0544" ,null ,"ABMag" ,"ZTF20acvguvq" ,"2020-12-05 06:40:15" ,"2020-12-07 09:31:33" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0544", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvguvq", `obsdate`="2020-12-05 06:40:15", `reportAddedDate`="2020-12-07 09:31:33", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwm" ,"30" ,"g-ZTF" ,"1" ,"19.7011" ,null ,"ABMag" ,"ZTF20acvguvq" ,"2020-12-05 05:08:40" ,"2020-12-07 09:31:33" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7011", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvguvq", `obsdate`="2020-12-05 05:08:40", `reportAddedDate`="2020-12-07 09:31:33", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwl" ,"45" ,"w-PS1" ,"0" ,"19.89" ,"0.04" ,"ABMag" ,"PS20mln" ,"2020-12-10 07:55:12" ,"2020-12-20 18:27:32" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwl", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.89", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS20mln", `obsdate`="2020-12-10 07:55:12", `reportAddedDate`="2020-12-20 18:27:32", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwl" ,"30" ,"r-ZTF" ,"0" ,"20.5308" ,null ,"ABMag" ,"ZTF20acvohfs" ,"2020-11-25 08:01:08" ,"2020-12-07 09:31:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.5308", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvohfs", `obsdate`="2020-11-25 08:01:08", `reportAddedDate`="2020-12-07 09:31:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwl" ,"30" ,"g-ZTF" ,"1" ,"20.5694" ,null ,"ABMag" ,"ZTF20acvohfs" ,"2020-11-23 08:15:03" ,"2020-12-07 09:31:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.5694", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvohfs", `obsdate`="2020-11-23 08:15:03", `reportAddedDate`="2020-12-07 09:31:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abtz" ,"30" ,"r-ZTF" ,"0" ,"19.47" ,"0.14" ,"ABMag" ,"ZTF20acwgayz" ,"2020-12-19 03:04:16" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abtz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.47", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acwgayz", `obsdate`="2020-12-19 03:04:16", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abtz" ,"30" ,"r-ZTF" ,"0" ,"19.69" ,"0.2" ,"ABMag" ,"ZTF20acwgayz" ,"2020-12-12 04:44:05" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abtz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.69", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acwgayz", `obsdate`="2020-12-12 04:44:05", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abtz" ,"30" ,"r-ZTF" ,"1" ,"19.5701" ,null ,"ABMag" ,"ZTF20acwgayz" ,"2020-12-07 03:33:33" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abtz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5701", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwgayz", `obsdate`="2020-12-07 03:33:33", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abtz" ,"30" ,"r-ZTF" ,"0" ,"19.47" ,"0.14" ,"ABMag" ,"ZTF20acwgayz" ,"2020-12-19 03:04:16" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abtz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.47", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acwgayz", `obsdate`="2020-12-19 03:04:16", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abtz" ,"30" ,"r-ZTF" ,"0" ,"19.69" ,"0.2" ,"ABMag" ,"ZTF20acwgayz" ,"2020-12-12 04:44:05" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abtz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.69", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acwgayz", `obsdate`="2020-12-12 04:44:05", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abtz" ,"30" ,"r-ZTF" ,"1" ,"19.5701" ,null ,"ABMag" ,"ZTF20acwgayz" ,"2020-12-07 03:33:33" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abtz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5701", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwgayz", `obsdate`="2020-12-07 03:33:33", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abtz" ,"30" ,"cyan-ATLAS" ,"0" ,"19.527" ,"0.195" ,"ABMag" ,"ATLAS20bgrb" ,"2020-12-06 06:28:48" ,"2020-12-06 16:35:34" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abtz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.527", `magErr`="0.195", `magUnit`="ABMag", `objectName`="ATLAS20bgrb", `obsdate`="2020-12-06 06:28:48", `reportAddedDate`="2020-12-06 16:35:34", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abtz" ,"30" ,"orange-ATLAS" ,"1" ,"19.14" ,null ,"ABMag" ,"ATLAS20bgrb" ,"2020-12-04 07:27:50" ,"2020-12-06 16:35:34" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abtz", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.14", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bgrb", `obsdate`="2020-12-04 07:27:50", `reportAddedDate`="2020-12-06 16:35:34", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absy" ,"60" ,"G-Gaia" ,"0" ,"18.84" ,"0.2" ,"ABMag" ,"Gaia20fuj" ,"2020-12-18 10:16:19" ,"2020-12-19 14:13:09" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absy", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.84", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fuj", `obsdate`="2020-12-18 10:16:19", `reportAddedDate`="2020-12-19 14:13:09", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absy" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fuj" ,"2020-08-04 17:15:22" ,"2020-12-19 14:13:09" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absy", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fuj", `obsdate`="2020-08-04 17:15:22", `reportAddedDate`="2020-12-19 14:13:09", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absy" ,"30" ,"cyan-ATLAS" ,"0" ,"18.625" ,"0.16" ,"ABMag" ,"ATLAS20bilr" ,"2020-12-15 15:14:24" ,"2020-12-16 23:35:52" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absy", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.625", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ATLAS20bilr", `obsdate`="2020-12-15 15:14:24", `reportAddedDate`="2020-12-16 23:35:52", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absy" ,"30" ,"orange-ATLAS" ,"1" ,"18.65" ,null ,"ABMag" ,"ATLAS20bilr" ,"2020-08-29 05:48:29" ,"2020-12-16 23:35:52" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absy", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.65", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bilr", `obsdate`="2020-08-29 05:48:29", `reportAddedDate`="2020-12-16 23:35:52", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absy" ,"30" ,"r-ZTF" ,"0" ,"17.91" ,"0.16" ,"ABMag" ,"ZTF20acvamqy" ,"2020-12-04 13:16:31" ,"2020-12-09 13:39:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="17.91", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acvamqy", `obsdate`="2020-12-04 13:16:31", `reportAddedDate`="2020-12-09 13:39:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absy" ,"30" ,"r-ZTF" ,"0" ,"18.28" ,"0.19" ,"ABMag" ,"ZTF20acvamqy" ,"2020-12-04 13:09:45" ,"2020-12-09 13:39:22" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.28", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acvamqy", `obsdate`="2020-12-04 13:09:45", `reportAddedDate`="2020-12-09 13:39:22", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absy" ,"30" ,"r-ZTF" ,"0" ,"18.2801" ,null ,"ABMag" ,"ZTF20acvamqy" ,"2020-12-04 13:09:45" ,"2020-12-06 08:56:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.2801", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvamqy", `obsdate`="2020-12-04 13:09:45", `reportAddedDate`="2020-12-06 08:56:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absy" ,"30" ,"r-ZTF" ,"1" ,"20.5" ,null ,"ABMag" ,"ZTF20acvamqy" ,"2018-05-31 12:00:00" ,"2020-12-06 08:56:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvamqy", `obsdate`="2018-05-31 12:00:00", `reportAddedDate`="2020-12-06 08:56:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abst" ,"30" ,"cyan-ATLAS" ,"0" ,"19.285" ,"0.15" ,"ABMag" ,"ATLAS20bhka" ,"2020-12-11 05:24:00" ,"2020-12-21 14:53:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abst", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.285", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ATLAS20bhka", `obsdate`="2020-12-11 05:24:00", `reportAddedDate`="2020-12-21 14:53:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abst" ,"30" ,"orange-ATLAS" ,"1" ,"19.15" ,null ,"ABMag" ,"ATLAS20bhka" ,"2020-12-09 06:01:26" ,"2020-12-21 14:53:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abst", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.15", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhka", `obsdate`="2020-12-09 06:01:26", `reportAddedDate`="2020-12-21 14:53:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abst" ,"30" ,"g-ZTF" ,"0" ,"19.53" ,"0.14" ,"ABMag" ,"ZTF20acuwzwp" ,"2020-12-11 02:20:10" ,"2020-12-11 02:36:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abst", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.53", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acuwzwp", `obsdate`="2020-12-11 02:20:10", `reportAddedDate`="2020-12-11 02:36:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abst" ,"30" ,"r-ZTF" ,"0" ,"19.29" ,"0.14" ,"ABMag" ,"ZTF20acuwzwp" ,"2020-12-06 04:28:02" ,"2020-12-11 02:36:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abst", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.29", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acuwzwp", `obsdate`="2020-12-06 04:28:02", `reportAddedDate`="2020-12-11 02:36:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abst" ,"30" ,"r-ZTF" ,"1" ,"19.5985" ,null ,"ABMag" ,"ZTF20acuwzwp" ,"2020-11-30 01:45:41" ,"2020-12-11 02:36:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abst", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5985", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuwzwp", `obsdate`="2020-11-30 01:45:41", `reportAddedDate`="2020-12-11 02:36:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abst" ,"30" ,"r-ZTF" ,"0" ,"19.2917" ,null ,"ABMag" ,"ZTF20acuwzwp" ,"2020-12-06 04:28:02" ,"2020-12-06 08:56:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abst", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2917", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuwzwp", `obsdate`="2020-12-06 04:28:02", `reportAddedDate`="2020-12-06 08:56:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abst" ,"30" ,"r-ZTF" ,"1" ,"18.8311" ,null ,"ABMag" ,"ZTF20acuwzwp" ,"2020-12-04 04:19:30" ,"2020-12-06 08:56:19" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abst", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.8311", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuwzwp", `obsdate`="2020-12-04 04:19:30", `reportAddedDate`="2020-12-06 08:56:19", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absn" ,"30" ,"g-ZTF" ,"0" ,"19.21" ,"0.14" ,"ABMag" ,"ZTF20acvgiee" ,"2020-12-19 04:06:28" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.21", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acvgiee", `obsdate`="2020-12-19 04:06:28", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absn" ,"30" ,"r-ZTF" ,"0" ,"19.18" ,"0.09" ,"ABMag" ,"ZTF20acvgiee" ,"2020-12-19 02:34:21" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.18", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acvgiee", `obsdate`="2020-12-19 02:34:21", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absn" ,"30" ,"g-ZTF" ,"1" ,"19.7682" ,null ,"ABMag" ,"ZTF20acvgiee" ,"2020-12-16 04:05:54" ,"2020-12-19 04:59:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7682", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvgiee", `obsdate`="2020-12-16 04:05:54", `reportAddedDate`="2020-12-19 04:59:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absn" ,"45" ,"w-PS1" ,"0" ,"19.61" ,"0.06" ,"ABMag" ,"PS20lyn" ,"2020-12-05 06:11:31" ,"2020-12-08 18:09:25" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absn", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.61", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20lyn", `obsdate`="2020-12-05 06:11:31", `reportAddedDate`="2020-12-08 18:09:25", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absn" ,"30" ,"cyan-ATLAS" ,"0" ,"19.272" ,"0.149" ,"ABMag" ,"ATLAS20bgvs" ,"2020-12-06 07:43:41" ,"2020-12-07 00:51:05" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absn", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.272", `magErr`="0.149", `magUnit`="ABMag", `objectName`="ATLAS20bgvs", `obsdate`="2020-12-06 07:43:41", `reportAddedDate`="2020-12-07 00:51:05", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absn" ,"30" ,"orange-ATLAS" ,"1" ,"19.03" ,null ,"ABMag" ,"ATLAS20bgvs" ,"2020-12-05 06:57:36" ,"2020-12-07 00:51:05" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absn", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.03", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bgvs", `obsdate`="2020-12-05 06:57:36", `reportAddedDate`="2020-12-07 00:51:05", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absn" ,"30" ,"g-ZTF" ,"0" ,"19.9233" ,null ,"ABMag" ,"ZTF20acvgiee" ,"2020-12-01 03:55:53" ,"2020-12-06 08:55:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.9233", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvgiee", `obsdate`="2020-12-01 03:55:53", `reportAddedDate`="2020-12-06 08:55:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absn" ,"30" ,"r-ZTF" ,"1" ,"19.7263" ,null ,"ABMag" ,"ZTF20acvgiee" ,"2020-12-01 02:56:28" ,"2020-12-06 08:55:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7263", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvgiee", `obsdate`="2020-12-01 02:56:28", `reportAddedDate`="2020-12-06 08:55:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absl" ,"30" ,"cyan-ATLAS" ,"0" ,"18.266" ,"0.086" ,"ABMag" ,"ATLAS20bihz" ,"2020-12-14 13:59:31" ,"2020-12-20 18:49:26" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absl", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.266", `magErr`="0.086", `magUnit`="ABMag", `objectName`="ATLAS20bihz", `obsdate`="2020-12-14 13:59:31", `reportAddedDate`="2020-12-20 18:49:26", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absl" ,"30" ,"orange-ATLAS" ,"1" ,"19.09" ,null ,"ABMag" ,"ATLAS20bihz" ,"2020-12-06 15:04:19" ,"2020-12-20 18:49:26" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absl", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.09", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bihz", `obsdate`="2020-12-06 15:04:19", `reportAddedDate`="2020-12-20 18:49:26", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absl" ,"30" ,"r-ZTF" ,"0" ,"18.58" ,"0.12" ,"ABMag" ,"ZTF20acvezau" ,"2020-12-09 12:21:33" ,"2020-12-11 12:54:59" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.58", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acvezau", `obsdate`="2020-12-09 12:21:33", `reportAddedDate`="2020-12-11 12:54:59", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absl" ,"30" ,"g-ZTF" ,"0" ,"18.9" ,"0.13" ,"ABMag" ,"ZTF20acvezau" ,"2020-12-05 12:51:00" ,"2020-12-11 12:54:59" ,"ZTF" ,"AGN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.9", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acvezau", `obsdate`="2020-12-05 12:51:00", `reportAddedDate`="2020-12-11 12:54:59", `reportingGroup`="ZTF", `suggestedType`="AGN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absl" ,"30" ,"g-ZTF" ,"0" ,"18.8985" ,null ,"ABMag" ,"ZTF20acvezau" ,"2020-12-05 12:51:00" ,"2020-12-06 08:55:27" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.8985", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvezau", `obsdate`="2020-12-05 12:51:00", `reportAddedDate`="2020-12-06 08:55:27", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absl" ,"30" ,"r-ZTF" ,"1" ,"20.5" ,null ,"ABMag" ,"ZTF20acvezau" ,"2018-05-31 12:00:00" ,"2020-12-06 08:55:27" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvezau", `obsdate`="2018-05-31 12:00:00", `reportAddedDate`="2020-12-06 08:55:27", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absj" ,"30" ,"cyan-ATLAS" ,"0" ,"18.885" ,"0.122" ,"ABMag" ,"ATLAS20bijc" ,"2020-12-14 14:38:24" ,"2020-12-20 18:52:22" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absj", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.885", `magErr`="0.122", `magUnit`="ABMag", `objectName`="ATLAS20bijc", `obsdate`="2020-12-14 14:38:24", `reportAddedDate`="2020-12-20 18:52:22", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absj" ,"30" ,"orange-ATLAS" ,"1" ,"19.02" ,null ,"ABMag" ,"ATLAS20bijc" ,"2020-12-08 15:46:05" ,"2020-12-20 18:52:22" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absj", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.02", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bijc", `obsdate`="2020-12-08 15:46:05", `reportAddedDate`="2020-12-20 18:52:22", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absj" ,"30" ,"r-ZTF" ,"0" ,"18.9" ,"0.14" ,"ABMag" ,"ZTF20acvezdt" ,"2020-12-16 12:25:52" ,"2020-12-16 12:57:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.9", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acvezdt", `obsdate`="2020-12-16 12:25:52", `reportAddedDate`="2020-12-16 12:57:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absj" ,"30" ,"r-ZTF" ,"0" ,"19.03" ,"0.13" ,"ABMag" ,"ZTF20acvezdt" ,"2020-12-11 12:18:27" ,"2020-12-16 12:57:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.03", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acvezdt", `obsdate`="2020-12-11 12:18:27", `reportAddedDate`="2020-12-16 12:57:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absj" ,"30" ,"r-ZTF" ,"1" ,"19.6328" ,null ,"ABMag" ,"ZTF20acvezdt" ,"2020-12-05 12:20:08" ,"2020-12-16 12:57:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6328", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvezdt", `obsdate`="2020-12-05 12:20:08", `reportAddedDate`="2020-12-16 12:57:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absj" ,"30" ,"g-ZTF" ,"0" ,"19.6979" ,null ,"ABMag" ,"ZTF20acvezdt" ,"2020-12-05 12:55:02" ,"2020-12-06 08:55:12" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6979", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvezdt", `obsdate`="2020-12-05 12:55:02", `reportAddedDate`="2020-12-06 08:55:12", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absj" ,"30" ,"r-ZTF" ,"1" ,"19.6328" ,null ,"ABMag" ,"ZTF20acvezdt" ,"2020-12-05 12:20:08" ,"2020-12-06 08:55:12" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6328", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvezdt", `obsdate`="2020-12-05 12:20:08", `reportAddedDate`="2020-12-06 08:55:12", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absf" ,"30" ,"cyan-ATLAS" ,"0" ,"19.512" ,"0.173" ,"ABMag" ,"ATLAS20bhkb" ,"2020-12-11 09:24:29" ,"2020-12-21 12:09:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absf", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.512", `magErr`="0.173", `magUnit`="ABMag", `objectName`="ATLAS20bhkb", `obsdate`="2020-12-11 09:24:29", `reportAddedDate`="2020-12-21 12:09:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absf" ,"30" ,"cyan-ATLAS" ,"1" ,"19.61" ,null ,"ABMag" ,"ATLAS20bhkb" ,"2020-12-09 09:59:02" ,"2020-12-21 12:09:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absf", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.61", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhkb", `obsdate`="2020-12-09 09:59:02", `reportAddedDate`="2020-12-21 12:09:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absf" ,"30" ,"r-ZTF" ,"0" ,"19.9009" ,null ,"ABMag" ,"ZTF20acvhazo" ,"2020-12-06 05:23:57" ,"2020-12-06 08:54:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absf", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9009", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvhazo", `obsdate`="2020-12-06 05:23:57", `reportAddedDate`="2020-12-06 08:54:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020absf" ,"30" ,"r-ZTF" ,"1" ,"19.003" ,null ,"ABMag" ,"ZTF20acvhazo" ,"2020-12-04 10:27:43" ,"2020-12-06 08:54:45" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020absf", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.003", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvhazo", `obsdate`="2020-12-04 10:27:43", `reportAddedDate`="2020-12-06 08:54:45", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqx" ,"45" ,"i-Sloan" ,"0" ,"18.89" ,"0.06" ,"ABMag" ,"PS20mkm" ,"2020-12-06 14:16:48" ,"2020-12-19 19:02:49" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqx", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="18.89", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20mkm", `obsdate`="2020-12-06 14:16:48", `reportAddedDate`="2020-12-19 19:02:49", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqx" ,"30" ,"orange-ATLAS" ,"0" ,"18.952" ,"0.176" ,"ABMag" ,"ATLAS20bgye" ,"2020-12-07 13:56:38" ,"2020-12-07 21:48:29" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqx", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.952", `magErr`="0.176", `magUnit`="ABMag", `objectName`="ATLAS20bgye", `obsdate`="2020-12-07 13:56:38", `reportAddedDate`="2020-12-07 21:48:29", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqx" ,"30" ,"orange-ATLAS" ,"1" ,"18.68" ,null ,"ABMag" ,"ATLAS20bgye" ,"2020-12-01 14:31:12" ,"2020-12-07 21:48:29" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqx", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.68", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bgye", `obsdate`="2020-12-01 14:31:12", `reportAddedDate`="2020-12-07 21:48:29", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqx" ,"30" ,"g-ZTF" ,"0" ,"18.98" ,null ,"ABMag" ,"ZTF20acvebcu" ,"2020-12-05 10:58:05" ,"2020-12-05 14:37:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqx", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.98", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvebcu", `obsdate`="2020-12-05 10:58:05", `reportAddedDate`="2020-12-05 14:37:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqx" ,"30" ,"g-ZTF" ,"0" ,"19.22" ,null ,"ABMag" ,"ZTF20acvebcu" ,"2020-12-03 12:50:24" ,"2020-12-05 14:37:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqx", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.22", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvebcu", `obsdate`="2020-12-03 12:50:24", `reportAddedDate`="2020-12-05 14:37:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqx" ,"30" ,"g-ZTF" ,"1" ,"19.43" ,null ,"ABMag" ,"ZTF20acvebcu" ,"2020-12-01 10:45:07" ,"2020-12-05 14:37:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqx", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.43", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvebcu", `obsdate`="2020-12-01 10:45:07", `reportAddedDate`="2020-12-05 14:37:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqo" ,"30" ,"g-ZTF" ,"0" ,"19.316" ,"0.207934" ,"ABMag" ,"ZTF20acuowxj" ,"2020-12-01 12:39:49" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.316", `magErr`="0.207934", `magUnit`="ABMag", `objectName`="ZTF20acuowxj", `obsdate`="2020-12-01 12:39:49", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqo" ,"30" ,"g-ZTF" ,"1" ,"18.4158" ,null ,"ABMag" ,"ZTF20acuowxj" ,"2020-11-27 11:33:44" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.4158", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuowxj", `obsdate`="2020-11-27 11:33:44", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqo" ,"30" ,"orange-ATLAS" ,"0" ,"18.799" ,"0.161" ,"ABMag" ,"ATLAS20bguz" ,"2020-12-06 15:10:05" ,"2020-12-07 00:39:12" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqo", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.799", `magErr`="0.161", `magUnit`="ABMag", `objectName`="ATLAS20bguz", `obsdate`="2020-12-06 15:10:05", `reportAddedDate`="2020-12-07 00:39:12", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqo" ,"30" ,"orange-ATLAS" ,"1" ,"18.62" ,null ,"ABMag" ,"ATLAS20bguz" ,"2020-11-30 15:24:29" ,"2020-12-07 00:39:12" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqo", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.62", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bguz", `obsdate`="2020-11-30 15:24:29", `reportAddedDate`="2020-12-07 00:39:12", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqo" ,"30" ,"g-ZTF" ,"0" ,"18.58" ,"0.1" ,"ABMag" ,"ZTF20acuowxj" ,"2020-12-05 13:01:47" ,"2020-12-05 13:38:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.58", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acuowxj", `obsdate`="2020-12-05 13:01:47", `reportAddedDate`="2020-12-05 13:38:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqo" ,"30" ,"r-ZTF" ,"0" ,"18.77" ,"0.11" ,"ABMag" ,"ZTF20acuowxj" ,"2020-12-05 12:18:47" ,"2020-12-05 13:38:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.77", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acuowxj", `obsdate`="2020-12-05 12:18:47", `reportAddedDate`="2020-12-05 13:38:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abqo" ,"30" ,"g-ZTF" ,"1" ,"20.0753" ,null ,"ABMag" ,"ZTF20acuowxj" ,"2020-11-24 12:39:18" ,"2020-12-05 13:38:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abqo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.0753", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuowxj", `obsdate`="2020-11-24 12:39:18", `reportAddedDate`="2020-12-05 13:38:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpw" ,"30" ,"g-ZTF" ,"0" ,"19.6795" ,"0.121721" ,"ABMag" ,"ZTF20acvblkk" ,"2020-12-05 04:07:48" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6795", `magErr`="0.121721", `magUnit`="ABMag", `objectName`="ZTF20acvblkk", `obsdate`="2020-12-05 04:07:48", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpw" ,"30" ,"g-ZTF" ,"1" ,"19.8445" ,null ,"ABMag" ,"ZTF20acvblkk" ,"2020-12-03 03:20:56" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8445", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvblkk", `obsdate`="2020-12-03 03:20:56", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpw" ,"30" ,"g-ZTF" ,"0" ,"18.87" ,"0.13" ,"ABMag" ,"ZTF20acvblkk" ,"2020-12-10 03:55:17" ,"2020-12-10 04:37:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.87", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acvblkk", `obsdate`="2020-12-10 03:55:17", `reportAddedDate`="2020-12-10 04:37:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpw" ,"30" ,"r-ZTF" ,"0" ,"19.18" ,"0.09" ,"ABMag" ,"ZTF20acvblkk" ,"2020-12-07 03:45:21" ,"2020-12-10 04:37:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.18", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acvblkk", `obsdate`="2020-12-07 03:45:21", `reportAddedDate`="2020-12-10 04:37:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpw" ,"30" ,"r-ZTF" ,"1" ,"19.7497" ,null ,"ABMag" ,"ZTF20acvblkk" ,"2020-12-05 05:58:06" ,"2020-12-10 04:37:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7497", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvblkk", `obsdate`="2020-12-05 05:58:06", `reportAddedDate`="2020-12-10 04:37:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpw" ,"30" ,"g-ZTF" ,"0" ,"19.6795" ,null ,"ABMag" ,"ZTF20acvblkk" ,"2020-12-05 04:07:48" ,"2020-12-05 08:22:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpw", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6795", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvblkk", `obsdate`="2020-12-05 04:07:48", `reportAddedDate`="2020-12-05 08:22:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpw" ,"30" ,"r-ZTF" ,"1" ,"19.0461" ,null ,"ABMag" ,"ZTF20acvblkk" ,"2020-12-03 06:00:03" ,"2020-12-05 08:22:56" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpw", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.0461", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvblkk", `obsdate`="2020-12-03 06:00:03", `reportAddedDate`="2020-12-05 08:22:56", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpu" ,"30" ,"r-ZTF" ,"0" ,"19.4483" ,"0.153051" ,"ABMag" ,"ZTF20acvchhw" ,"2020-12-05 05:56:04" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4483", `magErr`="0.153051", `magUnit`="ABMag", `objectName`="ZTF20acvchhw", `obsdate`="2020-12-05 05:56:04", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpu" ,"30" ,"r-ZTF" ,"1" ,"18.7992" ,null ,"ABMag" ,"ZTF20acvchhw" ,"2020-12-03 06:15:13" ,"2020-12-19 20:14:38" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.7992", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvchhw", `obsdate`="2020-12-03 06:15:13", `reportAddedDate`="2020-12-19 20:14:38", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpu" ,"30" ,"r-ZTF" ,"0" ,"19.13" ,"0.05" ,"ABMag" ,"ZTF20acvchhw" ,"2020-12-07 03:46:42" ,"2020-12-10 04:37:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.13", `magErr`="0.05", `magUnit`="ABMag", `objectName`="ZTF20acvchhw", `obsdate`="2020-12-07 03:46:42", `reportAddedDate`="2020-12-10 04:37:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpu" ,"30" ,"r-ZTF" ,"0" ,"19.45" ,"0.15" ,"ABMag" ,"ZTF20acvchhw" ,"2020-12-05 05:56:04" ,"2020-12-10 04:37:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.45", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acvchhw", `obsdate`="2020-12-05 05:56:04", `reportAddedDate`="2020-12-10 04:37:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpu" ,"30" ,"g-ZTF" ,"1" ,"20.4505" ,null ,"ABMag" ,"ZTF20acvchhw" ,"2020-12-05 04:09:09" ,"2020-12-10 04:37:49" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4505", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvchhw", `obsdate`="2020-12-05 04:09:09", `reportAddedDate`="2020-12-10 04:37:49", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpu" ,"30" ,"orange-ATLAS" ,"0" ,"19.301" ,"0.157" ,"ABMag" ,"ATLAS20bhav" ,"2020-12-07 06:00:00" ,"2020-12-07 23:03:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="19.301", `magErr`="0.157", `magUnit`="ABMag", `objectName`="ATLAS20bhav", `obsdate`="2020-12-07 06:00:00", `reportAddedDate`="2020-12-07 23:03:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpu" ,"30" ,"orange-ATLAS" ,"1" ,"18.84" ,null ,"ABMag" ,"ATLAS20bhav" ,"2020-12-03 08:36:58" ,"2020-12-07 23:03:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.84", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhav", `obsdate`="2020-12-03 08:36:58", `reportAddedDate`="2020-12-07 23:03:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpu" ,"30" ,"r-ZTF" ,"0" ,"19.4483" ,null ,"ABMag" ,"ZTF20acvchhw" ,"2020-12-05 05:56:04" ,"2020-12-05 08:22:43" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4483", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvchhw", `obsdate`="2020-12-05 05:56:04", `reportAddedDate`="2020-12-05 08:22:43", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpu" ,"30" ,"g-ZTF" ,"1" ,"20.4505" ,null ,"ABMag" ,"ZTF20acvchhw" ,"2020-12-05 04:09:09" ,"2020-12-05 08:22:43" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpu", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4505", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acvchhw", `obsdate`="2020-12-05 04:09:09", `reportAddedDate`="2020-12-05 08:22:43", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpt" ,"30" ,"cyan-ATLAS" ,"0" ,"19.703" ,"0.184" ,"ABMag" ,"ATLAS20bhnh" ,"2020-12-11 08:39:50" ,"2020-12-21 12:01:13" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpt", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.703", `magErr`="0.184", `magUnit`="ABMag", `objectName`="ATLAS20bhnh", `obsdate`="2020-12-11 08:39:50", `reportAddedDate`="2020-12-21 12:01:13", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpt" ,"30" ,"cyan-ATLAS" ,"1" ,"19.71" ,null ,"ABMag" ,"ATLAS20bhnh" ,"2020-12-10 08:49:55" ,"2020-12-21 12:01:13" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpt", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.71", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhnh", `obsdate`="2020-12-10 08:49:55", `reportAddedDate`="2020-12-21 12:01:13", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpt" ,"27" ,"r-Sloan" ,"0" ,"19.96" ,"0.11" ,"ABMag" ,"PS20lwn" ,"2020-12-01 07:26:24" ,"2020-12-06 17:55:03" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpt", `exptime`="27", `filter`="r-Sloan", `limitingMag`="0", `mag`="19.96", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20lwn", `obsdate`="2020-12-01 07:26:24", `reportAddedDate`="2020-12-06 17:55:03", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpt" ,"30" ,"g-ZTF" ,"0" ,"19.6857" ,null ,"ABMag" ,"ZTF20acuxpwz" ,"2020-12-05 04:35:44" ,"2020-12-05 07:47:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6857", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuxpwz", `obsdate`="2020-12-05 04:35:44", `reportAddedDate`="2020-12-05 07:47:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abpt" ,"30" ,"g-ZTF" ,"1" ,"18.7955" ,null ,"ABMag" ,"ZTF20acuxpwz" ,"2020-12-03 04:56:27" ,"2020-12-05 07:47:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abpt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.7955", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuxpwz", `obsdate`="2020-12-03 04:56:27", `reportAddedDate`="2020-12-05 07:47:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aboq" ,"60" ,"G-Gaia" ,"0" ,"18.02" ,"0.2" ,"ABMag" ,"Gaia20fuk" ,"2020-12-18 13:52:19" ,"2020-12-19 14:13:42" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aboq", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.02", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fuk", `obsdate`="2020-12-18 13:52:19", `reportAddedDate`="2020-12-19 14:13:42", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aboq" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fuk" ,"2020-11-23 07:49:26" ,"2020-12-19 14:13:42" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aboq", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fuk", `obsdate`="2020-11-23 07:49:26", `reportAddedDate`="2020-12-19 14:13:42", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aboq" ,"30" ,"orange-ATLAS" ,"0" ,"18.634" ,"0.139" ,"ABMag" ,"ATLAS20bgoz" ,"2020-12-04 11:26:53" ,"2020-12-04 21:20:25" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aboq", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.634", `magErr`="0.139", `magUnit`="ABMag", `objectName`="ATLAS20bgoz", `obsdate`="2020-12-04 11:26:53", `reportAddedDate`="2020-12-04 21:20:25", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aboq" ,"30" ,"orange-ATLAS" ,"1" ,"18.79" ,null ,"ABMag" ,"ATLAS20bgoz" ,"2020-12-02 11:55:41" ,"2020-12-04 21:20:25" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aboq", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.79", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bgoz", `obsdate`="2020-12-02 11:55:41", `reportAddedDate`="2020-12-04 21:20:25", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmp" ,"30" ,"r-ZTF" ,"0" ,"19.5" ,"0.13" ,"ABMag" ,"ZTF20acuxjus" ,"2020-12-12 04:50:11" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acuxjus", `obsdate`="2020-12-12 04:50:11", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmp" ,"30" ,"g-ZTF" ,"0" ,"19.74" ,"0.22" ,"ABMag" ,"ZTF20acuxjus" ,"2020-12-06 03:37:24" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.74", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acuxjus", `obsdate`="2020-12-06 03:37:24", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmp" ,"30" ,"r-ZTF" ,"1" ,"19.7074" ,null ,"ABMag" ,"ZTF20acuxjus" ,"2020-12-04 03:34:47" ,"2020-12-19 04:00:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7074", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuxjus", `obsdate`="2020-12-04 03:34:47", `reportAddedDate`="2020-12-19 04:00:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmp" ,"30" ,"cyan-ATLAS" ,"0" ,"19.493" ,"0.17" ,"ABMag" ,"ATLAS20bhjx" ,"2020-12-11 07:16:19" ,"2020-12-11 14:06:03" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.493", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ATLAS20bhjx", `obsdate`="2020-12-11 07:16:19", `reportAddedDate`="2020-12-11 14:06:03", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmp" ,"30" ,"orange-ATLAS" ,"1" ,"19.51" ,null ,"ABMag" ,"ATLAS20bhjx" ,"2020-12-09 08:12:29" ,"2020-12-11 14:06:03" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.51", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhjx", `obsdate`="2020-12-09 08:12:29", `reportAddedDate`="2020-12-11 14:06:03", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmp" ,"45" ,"w-PS1" ,"0" ,"19.75" ,"0.05" ,"ABMag" ,"PS20lyg" ,"2020-12-05 06:28:48" ,"2020-12-08 14:28:06" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.75", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS20lyg", `obsdate`="2020-12-05 06:28:48", `reportAddedDate`="2020-12-08 14:28:06", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmp" ,"30" ,"g-ZTF" ,"0" ,"19.8954" ,null ,"ABMag" ,"ZTF20acuxjus" ,"2020-12-04 03:03:29" ,"2020-12-04 05:31:12" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8954", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuxjus", `obsdate`="2020-12-04 03:03:29", `reportAddedDate`="2020-12-04 05:31:12", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmp" ,"30" ,"r-ZTF" ,"1" ,"19.1318" ,null ,"ABMag" ,"ZTF20acuxjus" ,"2020-12-01 06:39:17" ,"2020-12-04 05:31:12" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.1318", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuxjus", `obsdate`="2020-12-01 06:39:17", `reportAddedDate`="2020-12-04 05:31:12", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmo" ,"30" ,"r-ZTF" ,"0" ,"19.63" ,"0.19" ,"ABMag" ,"ZTF20aaiugrc" ,"2020-12-04 03:34:47" ,"2020-12-19 03:59:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.63", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20aaiugrc", `obsdate`="2020-12-04 03:34:47", `reportAddedDate`="2020-12-19 03:59:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmo" ,"30" ,"g-ZTF" ,"0" ,"20.05" ,"0.17" ,"ABMag" ,"ZTF20aaiugrc" ,"2020-12-04 03:03:29" ,"2020-12-19 03:59:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.05", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20aaiugrc", `obsdate`="2020-12-04 03:03:29", `reportAddedDate`="2020-12-19 03:59:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmo" ,"30" ,"g-ZTF" ,"1" ,"19.5582" ,null ,"ABMag" ,"ZTF20aaiugrc" ,"2020-12-01 04:06:34" ,"2020-12-19 03:59:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.5582", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aaiugrc", `obsdate`="2020-12-01 04:06:34", `reportAddedDate`="2020-12-19 03:59:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmo" ,"30" ,"r-ZTF" ,"0" ,"19.63" ,"0.19" ,"ABMag" ,"ZTF20acuxjtr" ,"2020-12-04 03:34:47" ,"2020-12-12 05:56:16" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.63", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acuxjtr", `obsdate`="2020-12-04 03:34:47", `reportAddedDate`="2020-12-12 05:56:16", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmo" ,"30" ,"g-ZTF" ,"0" ,"20.05" ,"0.17" ,"ABMag" ,"ZTF20acuxjtr" ,"2020-12-04 03:03:29" ,"2020-12-12 05:56:16" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.05", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acuxjtr", `obsdate`="2020-12-04 03:03:29", `reportAddedDate`="2020-12-12 05:56:16", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmo" ,"30" ,"g-ZTF" ,"1" ,"19.5582" ,null ,"ABMag" ,"ZTF20acuxjtr" ,"2020-12-01 04:06:34" ,"2020-12-12 05:56:16" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.5582", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuxjtr", `obsdate`="2020-12-01 04:06:34", `reportAddedDate`="2020-12-12 05:56:16", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmo" ,"30" ,"g-ZTF" ,"0" ,"20.0514" ,null ,"ABMag" ,"ZTF20acuxjtr" ,"2020-12-04 03:03:29" ,"2020-12-04 05:31:06" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0514", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuxjtr", `obsdate`="2020-12-04 03:03:29", `reportAddedDate`="2020-12-04 05:31:06", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abmo" ,"30" ,"r-ZTF" ,"1" ,"19.3254" ,null ,"ABMag" ,"ZTF20acuxjtr" ,"2020-12-01 06:39:17" ,"2020-12-04 05:31:06" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abmo", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.3254", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acuxjtr", `obsdate`="2020-12-01 06:39:17", `reportAddedDate`="2020-12-04 05:31:06", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abme" ,"30" ,"cyan-ATLAS" ,"0" ,"19.507" ,"0.194" ,"ABMag" ,"ATLAS20bhns" ,"2020-12-12 08:16:47" ,"2020-12-21 12:02:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abme", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.507", `magErr`="0.194", `magUnit`="ABMag", `objectName`="ATLAS20bhns", `obsdate`="2020-12-12 08:16:47", `reportAddedDate`="2020-12-21 12:02:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abme" ,"30" ,"orange-ATLAS" ,"1" ,"18.65" ,null ,"ABMag" ,"ATLAS20bhns" ,"2020-12-02 09:48:58" ,"2020-12-21 12:02:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abme", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.65", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhns", `obsdate`="2020-12-02 09:48:58", `reportAddedDate`="2020-12-21 12:02:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abme" ,"60" ,"G-Gaia" ,"0" ,"18.86" ,"0.2" ,"ABMag" ,"Gaia20fny" ,"2020-12-02 00:43:12" ,"2020-12-03 21:54:52" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abme", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.86", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fny", `obsdate`="2020-12-02 00:43:12", `reportAddedDate`="2020-12-03 21:54:52", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abme" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fny" ,"2020-10-19 19:09:07" ,"2020-12-03 21:54:52" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abme", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fny", `obsdate`="2020-10-19 19:09:07", `reportAddedDate`="2020-12-03 21:54:52", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abie" ,"45" ,"w-PS1" ,"0" ,"20.08" ,"0.07" ,"ABMag" ,"PS20mlo" ,"2020-12-15 05:03:50" ,"2020-12-20 18:28:10" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abie", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.08", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS20mlo", `obsdate`="2020-12-15 05:03:50", `reportAddedDate`="2020-12-20 18:28:10", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abie" ,"30" ,"cyan-ATLAS" ,"0" ,"19.595" ,"0.18" ,"ABMag" ,"ATLAS20bhaw" ,"2020-12-07 06:07:12" ,"2020-12-07 23:03:55" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abie", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.595", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ATLAS20bhaw", `obsdate`="2020-12-07 06:07:12", `reportAddedDate`="2020-12-07 23:03:55", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abie" ,"30" ,"orange-ATLAS" ,"1" ,"19.21" ,null ,"ABMag" ,"ATLAS20bhaw" ,"2020-12-05 06:40:19" ,"2020-12-07 23:03:55" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abie", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.21", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhaw", `obsdate`="2020-12-05 06:40:19", `reportAddedDate`="2020-12-07 23:03:55", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abie" ,"30" ,"r-ZTF" ,"0" ,"19.6923" ,"0.214849" ,"ABMag" ,"ZTF20aculjrg" ,"2020-12-01 02:35:23" ,"2020-12-01 18:39:41" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abie", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.6923", `magErr`="0.214849", `magUnit`="ABMag", `objectName`="ZTF20aculjrg", `obsdate`="2020-12-01 02:35:23", `reportAddedDate`="2020-12-01 18:39:41", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abie" ,"30" ,"r-ZTF" ,"0" ,"19.8013" ,"0.245" ,"ABMag" ,"ZTF20aculjrg" ,"2020-11-29 02:34:24" ,"2020-12-01 18:39:41" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abie", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8013", `magErr`="0.245", `magUnit`="ABMag", `objectName`="ZTF20aculjrg", `obsdate`="2020-11-29 02:34:24", `reportAddedDate`="2020-12-01 18:39:41", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abie" ,"30" ,"g-ZTF" ,"1" ,"18.862" ,null ,"ABMag" ,"ZTF20aculjrg" ,"2020-11-27 03:05:40" ,"2020-12-01 18:39:41" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abie", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.862", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aculjrg", `obsdate`="2020-11-27 03:05:40", `reportAddedDate`="2020-12-01 18:39:41", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abdd" ,"45" ,"i-Sloan" ,"0" ,"19.08" ,"0.03" ,"ABMag" ,"PS20miq" ,"2020-12-07 14:44:10" ,"2020-12-18 19:55:50" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abdd", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.08", `magErr`="0.03", `magUnit`="ABMag", `objectName`="PS20miq", `obsdate`="2020-12-07 14:44:10", `reportAddedDate`="2020-12-18 19:55:50", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abdd" ,"30" ,"orange-ATLAS" ,"0" ,"19.403" ,"0.163" ,"ABMag" ,"ATLAS20bghj" ,"2020-11-25 14:25:26" ,"2020-11-30 15:35:25" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abdd", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="19.403", `magErr`="0.163", `magUnit`="ABMag", `objectName`="ATLAS20bghj", `obsdate`="2020-11-25 14:25:26", `reportAddedDate`="2020-11-30 15:35:25", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abdd" ,"30" ,"cyan-ATLAS" ,"1" ,"19.65" ,null ,"ABMag" ,"ATLAS20bghj" ,"2020-11-19 15:23:02" ,"2020-11-30 15:35:25" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abdd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.65", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bghj", `obsdate`="2020-11-19 15:23:02", `reportAddedDate`="2020-11-30 15:35:25", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abdd" ,"30" ,"g-ZTF" ,"0" ,"18.87" ,"0.12" ,"ABMag" ,"ZTF20acseuvr" ,"2020-11-27 12:22:52" ,"2020-11-29 12:19:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abdd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.87", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acseuvr", `obsdate`="2020-11-27 12:22:52", `reportAddedDate`="2020-11-29 12:19:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abdd" ,"30" ,"g-ZTF" ,"0" ,"19.06" ,"0.07" ,"ABMag" ,"ZTF20acseuvr" ,"2020-11-25 12:24:30" ,"2020-11-29 12:19:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abdd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.06", `magErr`="0.07", `magUnit`="ABMag", `objectName`="ZTF20acseuvr", `obsdate`="2020-11-25 12:24:30", `reportAddedDate`="2020-11-29 12:19:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abdd" ,"30" ,"r-ZTF" ,"1" ,"19.6617" ,null ,"ABMag" ,"ZTF20acseuvr" ,"2020-11-22 11:44:38" ,"2020-11-29 12:19:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abdd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6617", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acseuvr", `obsdate`="2020-11-22 11:44:38", `reportAddedDate`="2020-11-29 12:19:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aawn" ,"30" ,"cyan-ATLAS" ,"0" ,"19.128" ,"0.135" ,"ABMag" ,"ATLAS20bikp" ,"2020-12-14 13:01:55" ,"2020-12-20 18:50:52" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aawn", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.128", `magErr`="0.135", `magUnit`="ABMag", `objectName`="ATLAS20bikp", `obsdate`="2020-12-14 13:01:55", `reportAddedDate`="2020-12-20 18:50:52", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aawn" ,"30" ,"cyan-ATLAS" ,"1" ,"19.52" ,null ,"ABMag" ,"ATLAS20bikp" ,"2020-12-12 13:01:55" ,"2020-12-20 18:50:52" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aawn", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.52", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bikp", `obsdate`="2020-12-12 13:01:55", `reportAddedDate`="2020-12-20 18:50:52", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aawn" ,"30" ,"g-ZTF" ,"0" ,"19.2145" ,"0.161268" ,"ABMag" ,"ZTF20actnran" ,"2020-11-24 12:09:33" ,"2020-11-24 19:58:15" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aawn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.2145", `magErr`="0.161268", `magUnit`="ABMag", `objectName`="ZTF20actnran", `obsdate`="2020-11-24 12:09:33", `reportAddedDate`="2020-11-24 19:58:15", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aawn" ,"30" ,"r-ZTF" ,"0" ,"19.2286" ,"0.11008" ,"ABMag" ,"ZTF20actnran" ,"2020-11-24 11:34:21" ,"2020-11-24 19:58:15" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aawn", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2286", `magErr`="0.11008", `magUnit`="ABMag", `objectName`="ZTF20actnran", `obsdate`="2020-11-24 11:34:21", `reportAddedDate`="2020-11-24 19:58:15", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aawn" ,"30" ,"g-ZTF" ,"1" ,"16.6646" ,null ,"ABMag" ,"ZTF20actnran" ,"2020-11-22 12:33:01" ,"2020-11-24 19:58:15" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aawn", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="16.6646", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20actnran", `obsdate`="2020-11-22 12:33:01", `reportAddedDate`="2020-11-24 19:58:15", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aauc" ,"45" ,"w-PS1" ,"0" ,"18.47" ,"0.01" ,"ABMag" ,"PS20mho" ,"2020-12-07 08:13:55" ,"2020-12-18 15:14:47" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="18.47", `magErr`="0.01", `magUnit`="ABMag", `objectName`="PS20mho", `obsdate`="2020-12-07 08:13:55", `reportAddedDate`="2020-12-18 15:14:47", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aauc" ,"30" ,"orange-ATLAS" ,"0" ,"18.582" ,"0.136" ,"ABMag" ,"ATLAS20bgmw" ,"2020-12-03 10:40:48" ,"2020-12-03 23:17:17" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.582", `magErr`="0.136", `magUnit`="ABMag", `objectName`="ATLAS20bgmw", `obsdate`="2020-12-03 10:40:48", `reportAddedDate`="2020-12-03 23:17:17", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aauc" ,"30" ,"orange-ATLAS" ,"1" ,"18.58" ,null ,"ABMag" ,"ATLAS20bgmw" ,"2020-12-01 11:52:48" ,"2020-12-03 23:17:17" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.58", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bgmw", `obsdate`="2020-12-01 11:52:48", `reportAddedDate`="2020-12-03 23:17:17", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aauc" ,"30" ,"g-ZTF" ,"0" ,"19.74" ,"0.15" ,"ABMag" ,"ZTF20actekrw" ,"2020-11-23 08:59:03" ,"2020-11-29 09:18:54" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.74", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20actekrw", `obsdate`="2020-11-23 08:59:03", `reportAddedDate`="2020-11-29 09:18:54", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aauc" ,"30" ,"r-ZTF" ,"0" ,"19.39" ,"0.15" ,"ABMag" ,"ZTF20actekrw" ,"2020-11-23 07:08:07" ,"2020-11-29 09:18:54" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.39", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20actekrw", `obsdate`="2020-11-23 07:08:07", `reportAddedDate`="2020-11-29 09:18:54", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aauc" ,"30" ,"g-ZTF" ,"1" ,"20.5924" ,null ,"ABMag" ,"ZTF20actekrw" ,"2020-11-18 08:13:04" ,"2020-11-29 09:18:54" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.5924", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20actekrw", `obsdate`="2020-11-18 08:13:04", `reportAddedDate`="2020-11-29 09:18:54", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aauc" ,"30" ,"g-ZTF" ,"0" ,"19.7433" ,"0.152622" ,"ABMag" ,"ZTF20actekrw" ,"2020-11-23 08:59:03" ,"2020-11-23 18:38:26" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7433", `magErr`="0.152622", `magUnit`="ABMag", `objectName`="ZTF20actekrw", `obsdate`="2020-11-23 08:59:03", `reportAddedDate`="2020-11-23 18:38:26", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aauc" ,"30" ,"r-ZTF" ,"0" ,"19.3927" ,"0.148568" ,"ABMag" ,"ZTF20actekrw" ,"2020-11-23 07:08:07" ,"2020-11-23 18:38:26" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.3927", `magErr`="0.148568", `magUnit`="ABMag", `objectName`="ZTF20actekrw", `obsdate`="2020-11-23 07:08:07", `reportAddedDate`="2020-11-23 18:38:26", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aauc" ,"30" ,"g-ZTF" ,"1" ,"19.3599" ,null ,"ABMag" ,"ZTF20actekrw" ,"2020-11-21 07:41:31" ,"2020-11-23 18:38:26" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aauc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.3599", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20actekrw", `obsdate`="2020-11-21 07:41:31", `reportAddedDate`="2020-11-23 18:38:26", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aarh" ,"45" ,"w-PS1" ,"0" ,"18.88" ,"0.02" ,"ABMag" ,"PS20mke" ,"2020-12-06 05:29:46" ,"2020-12-19 18:55:29" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aarh", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="18.88", `magErr`="0.02", `magUnit`="ABMag", `objectName`="PS20mke", `obsdate`="2020-12-06 05:29:46", `reportAddedDate`="2020-12-19 18:55:29", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aarh" ,"30" ,"orange-ATLAS" ,"0" ,"18.574" ,"0.159" ,"ABMag" ,"ATLAS20bgip" ,"2020-11-29 06:14:24" ,"2020-11-30 16:09:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aarh", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.574", `magErr`="0.159", `magUnit`="ABMag", `objectName`="ATLAS20bgip", `obsdate`="2020-11-29 06:14:24", `reportAddedDate`="2020-11-30 16:09:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aarh" ,"30" ,"orange-ATLAS" ,"1" ,"19.02" ,null ,"ABMag" ,"ATLAS20bgip" ,"2020-11-27 06:12:58" ,"2020-11-30 16:09:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aarh", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.02", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bgip", `obsdate`="2020-11-27 06:12:58", `reportAddedDate`="2020-11-30 16:09:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aarh" ,"30" ,"g-ZTF" ,"0" ,"18.76" ,"0.1" ,"ABMag" ,"ZTF20acrdadi" ,"2020-11-25 03:46:00" ,"2020-11-25 04:18:02" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aarh", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.76", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acrdadi", `obsdate`="2020-11-25 03:46:00", `reportAddedDate`="2020-11-25 04:18:02", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aarh" ,"30" ,"r-ZTF" ,"0" ,"19.48" ,"0.11" ,"ABMag" ,"ZTF20acrdadi" ,"2020-11-20 02:34:10" ,"2020-11-25 04:18:02" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aarh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.48", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acrdadi", `obsdate`="2020-11-20 02:34:10", `reportAddedDate`="2020-11-25 04:18:02", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aarh" ,"30" ,"r-ZTF" ,"1" ,"20.3223" ,null ,"ABMag" ,"ZTF20acrdadi" ,"2020-11-18 02:33:40" ,"2020-11-25 04:18:02" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aarh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.3223", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acrdadi", `obsdate`="2020-11-18 02:33:40", `reportAddedDate`="2020-11-25 04:18:02", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aarh" ,"30" ,"r-ZTF" ,"0" ,"19.4765" ,"0.106542" ,"ABMag" ,"ZTF20acrdadi" ,"2020-11-20 02:34:10" ,"2020-11-21 02:04:34" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aarh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4765", `magErr`="0.106542", `magUnit`="ABMag", `objectName`="ZTF20acrdadi", `obsdate`="2020-11-20 02:34:10", `reportAddedDate`="2020-11-21 02:04:34", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aarh" ,"30" ,"r-ZTF" ,"1" ,"20.3223" ,null ,"ABMag" ,"ZTF20acrdadi" ,"2020-11-18 02:33:40" ,"2020-11-21 02:04:34" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aarh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.3223", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acrdadi", `obsdate`="2020-11-18 02:33:40", `reportAddedDate`="2020-11-21 02:04:34", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aabt" ,"120" ,"z-Sloan" ,"0" ,"19.67" ,"0.08" ,"ABMag" ,"PS20mjh" ,"2020-12-06 15:57:36" ,"2020-12-19 12:04:14" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aabt", `exptime`="120", `filter`="z-Sloan", `limitingMag`="0", `mag`="19.67", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS20mjh", `obsdate`="2020-12-06 15:57:36", `reportAddedDate`="2020-12-19 12:04:14", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aabt" ,"30" ,"r-ZTF" ,"0" ,"18.97" ,"0.09" ,"ABMag" ,"ZTF20acphjfv" ,"2020-11-10 12:35:42" ,"2020-11-17 12:19:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aabt", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.97", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acphjfv", `obsdate`="2020-11-10 12:35:42", `reportAddedDate`="2020-11-17 12:19:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aabt" ,"30" ,"g-ZTF" ,"0" ,"19.08" ,"0.11" ,"ABMag" ,"ZTF20acphjfv" ,"2020-11-10 11:40:35" ,"2020-11-17 12:19:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aabt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.08", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acphjfv", `obsdate`="2020-11-10 11:40:35", `reportAddedDate`="2020-11-17 12:19:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aabt" ,"30" ,"r-ZTF" ,"0" ,"18.72" ,null ,"ABMag" ,"ZTF20acphjfv" ,"2020-11-15 12:48:58" ,"2020-11-17 06:28:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aabt", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.72", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acphjfv", `obsdate`="2020-11-15 12:48:58", `reportAddedDate`="2020-11-17 06:28:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aabt" ,"30" ,"g-ZTF" ,"0" ,"19.08" ,null ,"ABMag" ,"ZTF20acphjfv" ,"2020-11-10 11:41:17" ,"2020-11-17 06:28:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aabt", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.08", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acphjfv", `obsdate`="2020-11-10 11:41:17", `reportAddedDate`="2020-11-17 06:28:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zxy" ,"45" ,"w-PS1" ,"0" ,"21.24" ,"0.18" ,"ABMag" ,"PS20mit" ,"2020-12-12 07:58:05" ,"2020-12-18 19:57:47" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zxy", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.24", `magErr`="0.18", `magUnit`="ABMag", `objectName`="PS20mit", `obsdate`="2020-12-12 07:58:05", `reportAddedDate`="2020-12-18 19:57:47", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zxy" ,"30" ,"r-ZTF" ,"0" ,"20.0668" ,"0.135097" ,"ABMag" ,"ZTF20acqxxcr" ,"2020-11-16 07:00:08" ,"2020-11-16 18:20:28" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zxy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0668", `magErr`="0.135097", `magUnit`="ABMag", `objectName`="ZTF20acqxxcr", `obsdate`="2020-11-16 07:00:08", `reportAddedDate`="2020-11-16 18:20:28", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zxy" ,"30" ,"g-ZTF" ,"0" ,"20.1197" ,"0.205892" ,"ABMag" ,"ZTF20acqxxcr" ,"2020-11-16 05:54:58" ,"2020-11-16 18:20:28" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zxy", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1197", `magErr`="0.205892", `magUnit`="ABMag", `objectName`="ZTF20acqxxcr", `obsdate`="2020-11-16 05:54:58", `reportAddedDate`="2020-11-16 18:20:28", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zxy" ,"30" ,"g-ZTF" ,"0" ,"20.3295" ,"0.282077" ,"ABMag" ,"ZTF20acqxxcr" ,"2020-11-14 07:53:01" ,"2020-11-16 18:20:28" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zxy", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.3295", `magErr`="0.282077", `magUnit`="ABMag", `objectName`="ZTF20acqxxcr", `obsdate`="2020-11-14 07:53:01", `reportAddedDate`="2020-11-16 18:20:28", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zxy" ,"30" ,"r-ZTF" ,"1" ,"20.212" ,null ,"ABMag" ,"ZTF20acqxxcr" ,"2020-11-14 05:21:38" ,"2020-11-16 18:20:28" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zxy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.212", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acqxxcr", `obsdate`="2020-11-14 05:21:38", `reportAddedDate`="2020-11-16 18:20:28", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zwq" ,"30" ,"g-ZTF" ,"0" ,"19.34" ,"0.18" ,"ABMag" ,"ZTF20acywaqn" ,"2020-12-20 09:35:14" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zwq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.34", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acywaqn", `obsdate`="2020-12-20 09:35:14", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zwq" ,"30" ,"g-ZTF" ,"0" ,"19.19" ,"0.18" ,"ABMag" ,"ZTF20acywaqn" ,"2020-12-17 10:33:24" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zwq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.19", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acywaqn", `obsdate`="2020-12-17 10:33:24", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zwq" ,"30" ,"g-ZTF" ,"1" ,"20.4317" ,null ,"ABMag" ,"ZTF20acywaqn" ,"2020-12-15 12:29:43" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zwq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4317", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acywaqn", `obsdate`="2020-12-15 12:29:43", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zwq" ,"30" ,"r-ZTF" ,"0" ,"18.77" ,"0.12" ,"ABMag" ,"ZTF20ackijbs" ,"2020-11-03 13:10:01" ,"2020-11-16 12:03:31" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zwq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.77", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20ackijbs", `obsdate`="2020-11-03 13:10:01", `reportAddedDate`="2020-11-16 12:03:31", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zwq" ,"30" ,"r-ZTF" ,"0" ,"18.78" ,"0.13" ,"ABMag" ,"ZTF20ackijbs" ,"2020-11-02 11:36:41" ,"2020-11-16 12:03:31" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zwq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.78", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20ackijbs", `obsdate`="2020-11-02 11:36:41", `reportAddedDate`="2020-11-16 12:03:31", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zqq" ,"45" ,"w-PS1" ,"0" ,"20.62" ,"0.06" ,"ABMag" ,"PS20law" ,"2020-12-10 13:06:14" ,"2020-12-20 18:29:29" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zqq", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.62", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20law", `obsdate`="2020-12-10 13:06:14", `reportAddedDate`="2020-12-20 18:29:29", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zqq" ,"45" ,"w-PS1" ,"0" ,"19.55" ,"0.15" ,"ABMag" ,"PS20law" ,"2020-11-14 13:29:17" ,"2020-11-15 18:17:17" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zqq", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.55", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20law", `obsdate`="2020-11-14 13:29:17", `reportAddedDate`="2020-11-15 18:17:17", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zqq" ,"30" ,"r-ZTF" ,"0" ,"19.39" ,"0.26" ,"ABMag" ,"ZTF20acngwfc" ,"2020-11-05 12:08:21" ,"2020-11-15 12:02:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zqq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.39", `magErr`="0.26", `magUnit`="ABMag", `objectName`="ZTF20acngwfc", `obsdate`="2020-11-05 12:08:21", `reportAddedDate`="2020-11-15 12:02:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zqq" ,"30" ,"g-ZTF" ,"0" ,"19.31" ,"0.2" ,"ABMag" ,"ZTF20acngwfc" ,"2020-11-05 11:05:16" ,"2020-11-15 12:02:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zqq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.31", `magErr`="0.2", `magUnit`="ABMag", `objectName`="ZTF20acngwfc", `obsdate`="2020-11-05 11:05:16", `reportAddedDate`="2020-11-15 12:02:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zqq" ,"30" ,"r-ZTF" ,"1" ,"19.6935" ,null ,"ABMag" ,"ZTF20acngwfc" ,"2020-10-31 11:34:50" ,"2020-11-15 12:02:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zqq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6935", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acngwfc", `obsdate`="2020-10-31 11:34:50", `reportAddedDate`="2020-11-15 12:02:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"60" ,"G-Gaia" ,"0" ,"18.14" ,"0.2" ,"ABMag" ,"Gaia20ftx" ,"2020-12-17 01:10:34" ,"2020-12-18 10:22:33" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.14", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20ftx", `obsdate`="2020-12-17 01:10:34", `reportAddedDate`="2020-12-18 10:22:33", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20ftx" ,"2020-08-08 02:28:19" ,"2020-12-18 10:22:33" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20ftx", `obsdate`="2020-08-08 02:28:19", `reportAddedDate`="2020-12-18 10:22:33", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"r-ZTF" ,"0" ,"20.4511" ,"0.235068" ,"ABMag" ,"ZTF20acqksdi" ,"2020-11-12 07:35:24" ,"2020-11-23 09:19:47" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4511", `magErr`="0.235068", `magUnit`="ABMag", `objectName`="ZTF20acqksdi", `obsdate`="2020-11-12 07:35:24", `reportAddedDate`="2020-11-23 09:19:47", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"r-ZTF" ,"1" ,"19.5851" ,null ,"ABMag" ,"ZTF20acqksdi" ,"2020-11-05 08:17:30" ,"2020-11-23 09:19:47" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5851", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acqksdi", `obsdate`="2020-11-05 08:17:30", `reportAddedDate`="2020-11-23 09:19:47", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"cyan-ATLAS" ,"0" ,"18.443" ,"0.073" ,"ABMag" ,"ATLAS20bfov" ,"2020-11-17 08:44:10" ,"2020-11-17 23:31:19" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.443", `magErr`="0.073", `magUnit`="ABMag", `objectName`="ATLAS20bfov", `obsdate`="2020-11-17 08:44:10", `reportAddedDate`="2020-11-17 23:31:19", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"orange-ATLAS" ,"1" ,"18.94" ,null ,"ABMag" ,"ATLAS20bfov" ,"2020-11-11 14:02:24" ,"2020-11-17 23:31:19" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.94", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bfov", `obsdate`="2020-11-11 14:02:24", `reportAddedDate`="2020-11-17 23:31:19", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"r-ZTF" ,"0" ,"19.66" ,"0.13" ,"ABMag" ,"ZTF20acqksdi" ,"2020-11-14 05:39:36" ,"2020-11-16 08:02:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.66", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acqksdi", `obsdate`="2020-11-14 05:39:36", `reportAddedDate`="2020-11-16 08:02:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"r-ZTF" ,"0" ,"20.45" ,"0.24" ,"ABMag" ,"ZTF20acqksdi" ,"2020-11-12 07:35:23" ,"2020-11-16 08:02:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.45", `magErr`="0.24", `magUnit`="ABMag", `objectName`="ZTF20acqksdi", `obsdate`="2020-11-12 07:35:23", `reportAddedDate`="2020-11-16 08:02:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"g-ZTF" ,"1" ,"20.6647" ,null ,"ABMag" ,"ZTF20acqksdi" ,"2020-11-12 07:06:45" ,"2020-11-16 08:02:39" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.6647", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acqksdi", `obsdate`="2020-11-12 07:06:45", `reportAddedDate`="2020-11-16 08:02:39", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"g-ZTF" ,"0" ,"19.6128" ,"0.141418" ,"ABMag" ,"ZTF20acqksdi" ,"2020-11-14 07:46:54" ,"2020-11-14 20:46:17" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6128", `magErr`="0.141418", `magUnit`="ABMag", `objectName`="ZTF20acqksdi", `obsdate`="2020-11-14 07:46:54", `reportAddedDate`="2020-11-14 20:46:17", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"r-ZTF" ,"0" ,"19.6565" ,"0.130308" ,"ABMag" ,"ZTF20acqksdi" ,"2020-11-14 05:39:36" ,"2020-11-14 20:46:17" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.6565", `magErr`="0.130308", `magUnit`="ABMag", `objectName`="ZTF20acqksdi", `obsdate`="2020-11-14 05:39:36", `reportAddedDate`="2020-11-14 20:46:17", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"r-ZTF" ,"0" ,"20.4511" ,"0.235068" ,"ABMag" ,"ZTF20acqksdi" ,"2020-11-12 07:35:24" ,"2020-11-14 20:46:17" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4511", `magErr`="0.235068", `magUnit`="ABMag", `objectName`="ZTF20acqksdi", `obsdate`="2020-11-12 07:35:24", `reportAddedDate`="2020-11-14 20:46:17", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zpi" ,"30" ,"g-ZTF" ,"1" ,"20.6647" ,null ,"ABMag" ,"ZTF20acqksdi" ,"2020-11-12 07:06:45" ,"2020-11-14 20:46:17" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zpi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.6647", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acqksdi", `obsdate`="2020-11-12 07:06:45", `reportAddedDate`="2020-11-14 20:46:17", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"45" ,"w-PS1" ,"0" ,"19.86" ,"0.04" ,"ABMag" ,"PS20laq" ,"2020-12-10 12:47:31" ,"2020-12-20 18:31:14" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.86", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS20laq", `obsdate`="2020-12-10 12:47:31", `reportAddedDate`="2020-12-20 18:31:14", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"30" ,"r-ZTF" ,"0" ,"19.8825" ,"0.17081" ,"ABMag" ,"ZTF20acpwmui" ,"2020-11-12 10:29:05" ,"2020-11-24 06:27:36" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8825", `magErr`="0.17081", `magUnit`="ABMag", `objectName`="ZTF20acpwmui", `obsdate`="2020-11-12 10:29:05", `reportAddedDate`="2020-11-24 06:27:36", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"30" ,"r-ZTF" ,"1" ,"18.96" ,null ,"ABMag" ,"ZTF20acpwmui" ,"2020-11-05 12:08:21" ,"2020-11-24 06:27:36" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.96", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpwmui", `obsdate`="2020-11-05 12:08:21", `reportAddedDate`="2020-11-24 06:27:36", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"30" ,"g-ZTF" ,"0" ,"19.67" ,"0.13" ,"ABMag" ,"ZTF20acpwmui" ,"2020-11-12 10:59:28" ,"2020-11-17 12:19:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.67", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acpwmui", `obsdate`="2020-11-12 10:59:28", `reportAddedDate`="2020-11-17 12:19:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"30" ,"r-ZTF" ,"0" ,"19.88" ,"0.17" ,"ABMag" ,"ZTF20acpwmui" ,"2020-11-12 10:29:05" ,"2020-11-17 12:19:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.88", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acpwmui", `obsdate`="2020-11-12 10:29:05", `reportAddedDate`="2020-11-17 12:19:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"30" ,"r-ZTF" ,"1" ,"19.7537" ,null ,"ABMag" ,"ZTF20acpwmui" ,"2020-10-31 11:34:50" ,"2020-11-17 12:19:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7537", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpwmui", `obsdate`="2020-10-31 11:34:50", `reportAddedDate`="2020-11-17 12:19:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"45" ,"w-PS1" ,"0" ,"19.61" ,"0.09" ,"ABMag" ,"PS20laq" ,"2020-11-14 13:27:50" ,"2020-11-15 18:11:46" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.61", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20laq", `obsdate`="2020-11-14 13:27:50", `reportAddedDate`="2020-11-15 18:11:46", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"30" ,"g-ZTF" ,"0" ,"19.6702" ,"0.13168" ,"ABMag" ,"ZTF20acpwmui" ,"2020-11-12 10:59:28" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6702", `magErr`="0.13168", `magUnit`="ABMag", `objectName`="ZTF20acpwmui", `obsdate`="2020-11-12 10:59:28", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"30" ,"r-ZTF" ,"0" ,"19.8825" ,"0.17081" ,"ABMag" ,"ZTF20acpwmui" ,"2020-11-12 10:29:05" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8825", `magErr`="0.17081", `magUnit`="ABMag", `objectName`="ZTF20acpwmui", `obsdate`="2020-11-12 10:29:05", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zka" ,"30" ,"r-ZTF" ,"1" ,"18.96" ,null ,"ABMag" ,"ZTF20acpwmui" ,"2020-11-05 12:08:21" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zka", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.96", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpwmui", `obsdate`="2020-11-05 12:08:21", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zjb" ,"45" ,"w-PS1" ,"0" ,"21.02" ,"0.07" ,"ABMag" ,"PS20mid" ,"2020-12-07 05:35:31" ,"2020-12-18 19:45:56" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.02", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS20mid", `obsdate`="2020-12-07 05:35:31", `reportAddedDate`="2020-12-18 19:45:56", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zjb" ,"30" ,"g-ZTF" ,"0" ,"20.11" ,"0.17" ,"ABMag" ,"ZTF20acpqbue" ,"2020-11-12 04:40:32" ,"2020-11-16 07:02:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.11", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acpqbue", `obsdate`="2020-11-12 04:40:32", `reportAddedDate`="2020-11-16 07:02:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zjb" ,"30" ,"g-ZTF" ,"0" ,"19.86" ,"0.14" ,"ABMag" ,"ZTF20acpqbue" ,"2020-11-12 04:39:51" ,"2020-11-16 07:02:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.86", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acpqbue", `obsdate`="2020-11-12 04:39:51", `reportAddedDate`="2020-11-16 07:02:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zjb" ,"30" ,"r-ZTF" ,"1" ,"19.8105" ,null ,"ABMag" ,"ZTF20acpqbue" ,"2020-11-05 08:12:46" ,"2020-11-16 07:02:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8105", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpqbue", `obsdate`="2020-11-05 08:12:46", `reportAddedDate`="2020-11-16 07:02:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zjb" ,"30" ,"r-ZTF" ,"0" ,"19.4675" ,"0.103621" ,"ABMag" ,"ZTF20acpqbue" ,"2020-11-12 07:45:32" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4675", `magErr`="0.103621", `magUnit`="ABMag", `objectName`="ZTF20acpqbue", `obsdate`="2020-11-12 07:45:32", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zjb" ,"30" ,"r-ZTF" ,"0" ,"19.5425" ,"0.116604" ,"ABMag" ,"ZTF20acpqbue" ,"2020-11-12 05:23:58" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5425", `magErr`="0.116604", `magUnit`="ABMag", `objectName`="ZTF20acpqbue", `obsdate`="2020-11-12 05:23:58", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zjb" ,"30" ,"g-ZTF" ,"0" ,"20.1087" ,"0.170446" ,"ABMag" ,"ZTF20acpqbue" ,"2020-11-12 04:40:32" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1087", `magErr`="0.170446", `magUnit`="ABMag", `objectName`="ZTF20acpqbue", `obsdate`="2020-11-12 04:40:32", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zjb" ,"30" ,"g-ZTF" ,"0" ,"19.8559" ,"0.140248" ,"ABMag" ,"ZTF20acpqbue" ,"2020-11-12 04:39:51" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8559", `magErr`="0.140248", `magUnit`="ABMag", `objectName`="ZTF20acpqbue", `obsdate`="2020-11-12 04:39:51", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zjb" ,"30" ,"r-ZTF" ,"1" ,"19.8105" ,null ,"ABMag" ,"ZTF20acpqbue" ,"2020-11-05 08:12:46" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zjb", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8105", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpqbue", `obsdate`="2020-11-05 08:12:46", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ziy" ,"45" ,"w-PS1" ,"0" ,"19.85" ,"0.03" ,"ABMag" ,"PS20mlp" ,"2020-12-07 06:59:02" ,"2020-12-20 18:28:40" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.85", `magErr`="0.03", `magUnit`="ABMag", `objectName`="PS20mlp", `obsdate`="2020-12-07 06:59:02", `reportAddedDate`="2020-12-20 18:28:40", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ziy" ,"30" ,"cyan-ATLAS" ,"0" ,"19.408" ,"0.171" ,"ABMag" ,"ATLAS20bfxd" ,"2020-11-20 08:52:48" ,"2020-11-20 14:05:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.408", `magErr`="0.171", `magUnit`="ABMag", `objectName`="ATLAS20bfxd", `obsdate`="2020-11-20 08:52:48", `reportAddedDate`="2020-11-20 14:05:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ziy" ,"30" ,"orange-ATLAS" ,"1" ,"19.4" ,null ,"ABMag" ,"ATLAS20bfxd" ,"2020-11-19 09:38:53" ,"2020-11-20 14:05:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.4", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bfxd", `obsdate`="2020-11-19 09:38:53", `reportAddedDate`="2020-11-20 14:05:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ziy" ,"30" ,"g-ZTF" ,"0" ,"19.38" ,"0.09" ,"ABMag" ,"ZTF20acppzxx" ,"2020-11-16 06:00:21" ,"2020-11-16 07:02:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.38", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acppzxx", `obsdate`="2020-11-16 06:00:21", `reportAddedDate`="2020-11-16 07:02:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ziy" ,"30" ,"g-ZTF" ,"0" ,"19.61" ,"0.13" ,"ABMag" ,"ZTF20acppzxx" ,"2020-11-14 07:48:15" ,"2020-11-16 07:02:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.61", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acppzxx", `obsdate`="2020-11-14 07:48:15", `reportAddedDate`="2020-11-16 07:02:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ziy" ,"30" ,"r-ZTF" ,"1" ,"20.0701" ,null ,"ABMag" ,"ZTF20acppzxx" ,"2020-11-14 05:43:38" ,"2020-11-16 07:02:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0701", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acppzxx", `obsdate`="2020-11-14 05:43:38", `reportAddedDate`="2020-11-16 07:02:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ziy" ,"30" ,"r-ZTF" ,"0" ,"19.9649" ,"0.111533" ,"ABMag" ,"ZTF20acppzxx" ,"2020-11-12 05:34:29" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9649", `magErr`="0.111533", `magUnit`="ABMag", `objectName`="ZTF20acppzxx", `obsdate`="2020-11-12 05:34:29", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ziy" ,"30" ,"g-ZTF" ,"0" ,"19.7672" ,"0.119436" ,"ABMag" ,"ZTF20acppzxx" ,"2020-11-12 04:37:49" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7672", `magErr`="0.119436", `magUnit`="ABMag", `objectName`="ZTF20acppzxx", `obsdate`="2020-11-12 04:37:49", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ziy" ,"30" ,"r-ZTF" ,"1" ,"19.6765" ,null ,"ABMag" ,"ZTF20acppzxx" ,"2020-11-05 08:06:06" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ziy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6765", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acppzxx", `obsdate`="2020-11-05 08:06:06", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"45" ,"w-PS1" ,"0" ,"19.72" ,"0.04" ,"ABMag" ,"PS20mlm" ,"2020-12-15 05:11:02" ,"2020-12-20 18:26:57" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.72", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS20mlm", `obsdate`="2020-12-15 05:11:02", `reportAddedDate`="2020-12-20 18:26:57", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"g-ZTF" ,"0" ,"19.5698" ,"0.341116" ,"ABMag" ,"ZTF20acprazr" ,"2020-11-11 05:02:55" ,"2020-12-03 06:20:09" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.5698", `magErr`="0.341116", `magUnit`="ABMag", `objectName`="ZTF20acprazr", `obsdate`="2020-11-11 05:02:55", `reportAddedDate`="2020-12-03 06:20:09", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"g-ZTF" ,"1" ,"19.5904" ,null ,"ABMag" ,"ZTF20acprazr" ,"2020-11-05 04:37:26" ,"2020-12-03 06:20:09" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.5904", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acprazr", `obsdate`="2020-11-05 04:37:26", `reportAddedDate`="2020-12-03 06:20:09", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"cyan-ATLAS" ,"0" ,"18.945" ,"0.11" ,"ABMag" ,"ATLAS20bfsz" ,"2020-11-17 07:06:14" ,"2020-11-18 00:21:29" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.945", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ATLAS20bfsz", `obsdate`="2020-11-17 07:06:14", `reportAddedDate`="2020-11-18 00:21:29", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"cyan-ATLAS" ,"1" ,"19.41" ,null ,"ABMag" ,"ATLAS20bfsz" ,"2020-11-08 08:38:24" ,"2020-11-18 00:21:29" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.41", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bfsz", `obsdate`="2020-11-08 08:38:24", `reportAddedDate`="2020-11-18 00:21:29", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"r-ZTF" ,"0" ,"19.54" ,"0.12" ,"ABMag" ,"ZTF20acprazr" ,"2020-11-12 05:11:02" ,"2020-11-16 05:05:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.54", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acprazr", `obsdate`="2020-11-12 05:11:02", `reportAddedDate`="2020-11-16 05:05:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"g-ZTF" ,"0" ,"19.42" ,"0.1" ,"ABMag" ,"ZTF20acprazr" ,"2020-11-12 04:08:29" ,"2020-11-16 05:05:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.42", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acprazr", `obsdate`="2020-11-12 04:08:29", `reportAddedDate`="2020-11-16 05:05:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"r-ZTF" ,"1" ,"19.6859" ,null ,"ABMag" ,"ZTF20acprazr" ,"2020-11-05 05:24:14" ,"2020-11-16 05:05:32" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6859", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acprazr", `obsdate`="2020-11-05 05:24:14", `reportAddedDate`="2020-11-16 05:05:32", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"r-ZTF" ,"0" ,"19.539" ,"0.123918" ,"ABMag" ,"ZTF20acprazr" ,"2020-11-12 05:11:02" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.539", `magErr`="0.123918", `magUnit`="ABMag", `objectName`="ZTF20acprazr", `obsdate`="2020-11-12 05:11:02", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"g-ZTF" ,"0" ,"19.4203" ,"0.0988447" ,"ABMag" ,"ZTF20acprazr" ,"2020-11-12 04:08:29" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4203", `magErr`="0.0988447", `magUnit`="ABMag", `objectName`="ZTF20acprazr", `obsdate`="2020-11-12 04:08:29", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"g-ZTF" ,"0" ,"19.5698" ,"0.341116" ,"ABMag" ,"ZTF20acprazr" ,"2020-11-11 05:02:55" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.5698", `magErr`="0.341116", `magUnit`="ABMag", `objectName`="ZTF20acprazr", `obsdate`="2020-11-11 05:02:55", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zhz" ,"30" ,"r-ZTF" ,"1" ,"19.6859" ,null ,"ABMag" ,"ZTF20acprazr" ,"2020-11-05 05:24:14" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zhz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6859", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acprazr", `obsdate`="2020-11-05 05:24:14", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zgr" ,"45" ,"w-PS1" ,"0" ,"19.94" ,"0.07" ,"ABMag" ,"PS20miz" ,"2020-11-12 11:22:34" ,"2020-12-18 20:14:43" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zgr", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.94", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS20miz", `obsdate`="2020-11-12 11:22:34", `reportAddedDate`="2020-12-18 20:14:43", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zgr" ,"30" ,"cyan-ATLAS" ,"0" ,"19.507" ,"0.193" ,"ABMag" ,"ATLAS20bfsm" ,"2020-11-17 10:14:53" ,"2020-11-18 00:07:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zgr", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.507", `magErr`="0.193", `magUnit`="ABMag", `objectName`="ATLAS20bfsm", `obsdate`="2020-11-17 10:14:53", `reportAddedDate`="2020-11-18 00:07:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zgr" ,"30" ,"orange-ATLAS" ,"1" ,"19.01" ,null ,"ABMag" ,"ATLAS20bfsm" ,"2020-11-11 15:01:26" ,"2020-11-18 00:07:20" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zgr", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.01", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bfsm", `obsdate`="2020-11-11 15:01:26", `reportAddedDate`="2020-11-18 00:07:20", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zgr" ,"30" ,"g-ZTF" ,"0" ,"19.37" ,"0.13" ,"ABMag" ,"ZTF20acplqcf" ,"2020-11-12 07:10:07" ,"2020-11-12 08:01:23" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zgr", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.37", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acplqcf", `obsdate`="2020-11-12 07:10:07", `reportAddedDate`="2020-11-12 08:01:23", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zgr" ,"30" ,"r-ZTF" ,"0" ,"19.87" ,"0.27" ,"ABMag" ,"ZTF20acplqcf" ,"2020-11-05 08:25:36" ,"2020-11-12 08:01:23" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zgr", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.87", `magErr`="0.27", `magUnit`="ABMag", `objectName`="ZTF20acplqcf", `obsdate`="2020-11-05 08:25:36", `reportAddedDate`="2020-11-12 08:01:23", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zgr" ,"30" ,"g-ZTF" ,"1" ,"19.6705" ,null ,"ABMag" ,"ZTF20acplqcf" ,"2020-11-05 06:43:37" ,"2020-11-12 08:01:23" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zgr", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.6705", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acplqcf", `obsdate`="2020-11-05 06:43:37", `reportAddedDate`="2020-11-12 08:01:23", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zcx" ,"45" ,"i-Sloan" ,"0" ,"20.58" ,"0.12" ,"ABMag" ,"PS20mjy" ,"2020-12-06 12:53:17" ,"2020-12-19 18:50:19" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zcx", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.58", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS20mjy", `obsdate`="2020-12-06 12:53:17", `reportAddedDate`="2020-12-19 18:50:19", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zcx" ,"30" ,"r-ZTF" ,"0" ,"19.51" ,"0.14" ,"ABMag" ,"ZTF20acpgicr" ,"2020-11-12 10:18:52" ,"2020-11-14 12:02:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zcx", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.51", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acpgicr", `obsdate`="2020-11-12 10:18:52", `reportAddedDate`="2020-11-14 12:02:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zcx" ,"30" ,"g-ZTF" ,"0" ,"19.57" ,"0.13" ,"ABMag" ,"ZTF20acpgicr" ,"2020-11-12 09:20:54" ,"2020-11-14 12:02:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zcx", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.57", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acpgicr", `obsdate`="2020-11-12 09:20:54", `reportAddedDate`="2020-11-14 12:02:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zcx" ,"30" ,"g-ZTF" ,"1" ,"20.0806" ,null ,"ABMag" ,"ZTF20acpgicr" ,"2020-11-06 12:38:26" ,"2020-11-14 12:02:01" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zcx", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.0806", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpgicr", `obsdate`="2020-11-06 12:38:26", `reportAddedDate`="2020-11-14 12:02:01", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zcx" ,"30" ,"r-ZTF" ,"0" ,"19.7262" ,"0.208059" ,"ABMag" ,"ZTF20acpgicr" ,"2020-11-06 11:27:45" ,"2020-11-10 17:24:29" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zcx", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7262", `magErr`="0.208059", `magUnit`="ABMag", `objectName`="ZTF20acpgicr", `obsdate`="2020-11-06 11:27:45", `reportAddedDate`="2020-11-10 17:24:29", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zcx" ,"30" ,"g-ZTF" ,"0" ,"19.7918" ,"0.225325" ,"ABMag" ,"ZTF20acpgicr" ,"2020-11-04 12:36:36" ,"2020-11-10 17:24:29" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zcx", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7918", `magErr`="0.225325", `magUnit`="ABMag", `objectName`="ZTF20acpgicr", `obsdate`="2020-11-04 12:36:36", `reportAddedDate`="2020-11-10 17:24:29", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zcx" ,"30" ,"r-ZTF" ,"1" ,"19.6725" ,null ,"ABMag" ,"ZTF20acpgicr" ,"2020-11-04 11:45:32" ,"2020-11-10 17:24:29" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zcx", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6725", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpgicr", `obsdate`="2020-11-04 11:45:32", `reportAddedDate`="2020-11-10 17:24:29", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yzs" ,"45" ,"i-Sloan" ,"0" ,"19.9" ,"0.31" ,"ABMag" ,"PS20mkd" ,"2020-11-02 08:48:29" ,"2020-12-19 18:55:03" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yzs", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.9", `magErr`="0.31", `magUnit`="ABMag", `objectName`="PS20mkd", `obsdate`="2020-11-02 08:48:29", `reportAddedDate`="2020-12-19 18:55:03", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yzs" ,"30" ,"g-ZTF" ,"0" ,"19.1" ,"0.15" ,"ABMag" ,"ZTF20acovrzx" ,"2020-11-05 06:54:26" ,"2020-11-11 07:01:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yzs", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.1", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acovrzx", `obsdate`="2020-11-05 06:54:26", `reportAddedDate`="2020-11-11 07:01:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yzs" ,"30" ,"r-ZTF" ,"0" ,"19.17" ,"0.11" ,"ABMag" ,"ZTF20acovrzx" ,"2020-11-05 05:05:19" ,"2020-11-11 07:01:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yzs", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.17", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acovrzx", `obsdate`="2020-11-05 05:05:19", `reportAddedDate`="2020-11-11 07:01:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yzs" ,"30" ,"g-ZTF" ,"1" ,"20.8225" ,null ,"ABMag" ,"ZTF20acovrzx" ,"2020-10-22 07:34:47" ,"2020-11-11 07:01:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yzs", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.8225", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acovrzx", `obsdate`="2020-10-22 07:34:47", `reportAddedDate`="2020-11-11 07:01:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yzs" ,"30" ,"orange-ATLAS" ,"0" ,"18.334" ,"0.114" ,"ABMag" ,"ATLAS20bexl" ,"2020-11-07 09:21:36" ,"2020-11-07 22:23:56" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yzs", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.334", `magErr`="0.114", `magUnit`="ABMag", `objectName`="ATLAS20bexl", `obsdate`="2020-11-07 09:21:36", `reportAddedDate`="2020-11-07 22:23:56", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yzs" ,"30" ,"orange-ATLAS" ,"1" ,"19.24" ,null ,"ABMag" ,"ATLAS20bexl" ,"2020-11-05 10:22:05" ,"2020-11-07 22:23:56" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yzs", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.24", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bexl", `obsdate`="2020-11-05 10:22:05", `reportAddedDate`="2020-11-07 22:23:56", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"45" ,"w-PS1" ,"0" ,"19.84" ,"0.04" ,"ABMag" ,"PS20mkn" ,"2020-12-06 05:26:53" ,"2020-12-19 19:03:25" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.84", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS20mkn", `obsdate`="2020-12-06 05:26:53", `reportAddedDate`="2020-12-19 19:03:25", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"30" ,"r-ZTF" ,"0" ,"19.53" ,"0.15" ,"ABMag" ,"ZTF20acopmey" ,"2020-11-05 03:20:02" ,"2020-11-11 04:01:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.53", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acopmey", `obsdate`="2020-11-05 03:20:02", `reportAddedDate`="2020-11-11 04:01:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"30" ,"r-ZTF" ,"0" ,"19.71" ,"0.17" ,"ABMag" ,"ZTF20acopmey" ,"2020-11-04 05:26:05" ,"2020-11-11 04:01:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.71", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20acopmey", `obsdate`="2020-11-04 05:26:05", `reportAddedDate`="2020-11-11 04:01:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"30" ,"r-ZTF" ,"1" ,"19.766" ,null ,"ABMag" ,"ZTF20acopmey" ,"2020-11-01 03:35:17" ,"2020-11-11 04:01:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.766", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acopmey", `obsdate`="2020-11-01 03:35:17", `reportAddedDate`="2020-11-11 04:01:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"30" ,"orange-ATLAS" ,"0" ,"19.411" ,"0.17" ,"ABMag" ,"ATLAS20bfbm" ,"2020-11-07 07:49:26" ,"2020-11-08 14:40:32" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="19.411", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ATLAS20bfbm", `obsdate`="2020-11-07 07:49:26", `reportAddedDate`="2020-11-08 14:40:32", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"30" ,"cyan-ATLAS" ,"1" ,"17.7" ,null ,"ABMag" ,"ATLAS20bfbm" ,"2020-11-06 07:13:26" ,"2020-11-08 14:40:32" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="17.7", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bfbm", `obsdate`="2020-11-06 07:13:26", `reportAddedDate`="2020-11-08 14:40:32", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"30" ,"g-ZTF" ,"0" ,"19.5518" ,"0.155352" ,"ABMag" ,"ZTF20acopmey" ,"2020-11-05 03:34:22" ,"2020-11-05 21:32:37" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.5518", `magErr`="0.155352", `magUnit`="ABMag", `objectName`="ZTF20acopmey", `obsdate`="2020-11-05 03:34:22", `reportAddedDate`="2020-11-05 21:32:37", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"30" ,"r-ZTF" ,"0" ,"19.5289" ,"0.153989" ,"ABMag" ,"ZTF20acopmey" ,"2020-11-05 03:20:02" ,"2020-11-05 21:32:37" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5289", `magErr`="0.153989", `magUnit`="ABMag", `objectName`="ZTF20acopmey", `obsdate`="2020-11-05 03:20:02", `reportAddedDate`="2020-11-05 21:32:37", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"30" ,"r-ZTF" ,"0" ,"19.7108" ,"0.165366" ,"ABMag" ,"ZTF20acopmey" ,"2020-11-04 05:26:05" ,"2020-11-05 21:32:37" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7108", `magErr`="0.165366", `magUnit`="ABMag", `objectName`="ZTF20acopmey", `obsdate`="2020-11-04 05:26:05", `reportAddedDate`="2020-11-05 21:32:37", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyk" ,"30" ,"g-ZTF" ,"1" ,"19.0587" ,null ,"ABMag" ,"ZTF20acopmey" ,"2020-11-01 06:38:38" ,"2020-11-05 21:32:37" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.0587", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acopmey", `obsdate`="2020-11-01 06:38:38", `reportAddedDate`="2020-11-05 21:32:37", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"45" ,"w-PS1" ,"0" ,"20.26" ,"0.11" ,"ABMag" ,"PS20mjm" ,"2020-12-06 06:28:48" ,"2020-12-19 12:07:58" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.26", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20mjm", `obsdate`="2020-12-06 06:28:48", `reportAddedDate`="2020-12-19 12:07:58", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"30" ,"g-ZTF" ,"0" ,"19.17" ,"0.14" ,"ABMag" ,"ZTF20acpcwwg" ,"2020-11-11 06:29:41" ,"2020-11-11 08:02:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.17", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acpcwwg", `obsdate`="2020-11-11 06:29:41", `reportAddedDate`="2020-11-11 08:02:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"30" ,"r-ZTF" ,"0" ,"19.54" ,"0.14" ,"ABMag" ,"ZTF20acpcwwg" ,"2020-11-05 05:05:19" ,"2020-11-11 08:02:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.54", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acpcwwg", `obsdate`="2020-11-05 05:05:19", `reportAddedDate`="2020-11-11 08:02:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"30" ,"r-ZTF" ,"1" ,"19.6366" ,null ,"ABMag" ,"ZTF20acpcwwg" ,"2020-11-02 05:33:02" ,"2020-11-11 08:02:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6366", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpcwwg", `obsdate`="2020-11-02 05:33:02", `reportAddedDate`="2020-11-11 08:02:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"30" ,"cyan-ATLAS" ,"0" ,"19.391" ,"0.16" ,"ABMag" ,"ATLAS20bfen" ,"2020-11-08 09:14:24" ,"2020-11-09 01:54:16" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.391", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ATLAS20bfen", `obsdate`="2020-11-08 09:14:24", `reportAddedDate`="2020-11-09 01:54:16", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"30" ,"orange-ATLAS" ,"1" ,"19.49" ,null ,"ABMag" ,"ATLAS20bfen" ,"2020-11-07 09:37:26" ,"2020-11-09 01:54:16" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.49", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bfen", `obsdate`="2020-11-07 09:37:26", `reportAddedDate`="2020-11-09 01:54:16", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"30" ,"g-ZTF" ,"0" ,"19.5437" ,"0.190748" ,"ABMag" ,"ZTF20acpcwwg" ,"2020-11-05 06:54:26" ,"2020-11-05 21:32:37" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.5437", `magErr`="0.190748", `magUnit`="ABMag", `objectName`="ZTF20acpcwwg", `obsdate`="2020-11-05 06:54:26", `reportAddedDate`="2020-11-05 21:32:37", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"30" ,"r-ZTF" ,"0" ,"19.5384" ,"0.138164" ,"ABMag" ,"ZTF20acpcwwg" ,"2020-11-05 05:05:19" ,"2020-11-05 21:32:37" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5384", `magErr`="0.138164", `magUnit`="ABMag", `objectName`="ZTF20acpcwwg", `obsdate`="2020-11-05 05:05:19", `reportAddedDate`="2020-11-05 21:32:37", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"30" ,"r-ZTF" ,"0" ,"19.9231" ,"0.251672" ,"ABMag" ,"ZTF20acpcwwg" ,"2020-11-03 06:39:22" ,"2020-11-05 21:32:37" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9231", `magErr`="0.251672", `magUnit`="ABMag", `objectName`="ZTF20acpcwwg", `obsdate`="2020-11-03 06:39:22", `reportAddedDate`="2020-11-05 21:32:37", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yyi" ,"30" ,"r-ZTF" ,"1" ,"19.6366" ,null ,"ABMag" ,"ZTF20acpcwwg" ,"2020-11-02 05:33:02" ,"2020-11-05 21:32:37" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yyi", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6366", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpcwwg", `obsdate`="2020-11-02 05:33:02", `reportAddedDate`="2020-11-05 21:32:37", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"30" ,"r-ZTF" ,"0" ,"17.1377" ,null ,"ABMag" ,"ZTF18aaefvaq" ,"2020-11-20 10:09:25" ,"2020-12-21 14:01:00" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="17.1377", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18aaefvaq", `obsdate`="2020-11-20 10:09:25", `reportAddedDate`="2020-12-21 14:01:00", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"30" ,"r-ZTF" ,"1" ,"20.5" ,null ,"ABMag" ,"ZTF18aaefvaq" ,"2018-05-31 12:00:00" ,"2020-12-21 14:01:00" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18aaefvaq", `obsdate`="2018-05-31 12:00:00", `reportAddedDate`="2020-12-21 14:01:00", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"45" ,"i-Sloan" ,"0" ,"18.56" ,"0.06" ,"ABMag" ,"PS20kyb" ,"2020-11-04 14:49:55" ,"2020-11-13 15:33:27" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="18.56", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20kyb", `obsdate`="2020-11-04 14:49:55", `reportAddedDate`="2020-11-13 15:33:27", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"30" ,"g-ZTF" ,"0" ,"18.97" ,"0.12" ,"ABMag" ,"ZTF18aadsuxd" ,"2020-11-02 12:14:15" ,"2020-11-12 11:01:35" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.97", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF18aadsuxd", `obsdate`="2020-11-02 12:14:15", `reportAddedDate`="2020-11-12 11:01:35", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"30" ,"r-ZTF" ,"0" ,"19.41" ,"0.14" ,"ABMag" ,"ZTF18aadsuxd" ,"2020-11-02 11:10:15" ,"2020-11-12 11:01:35" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.41", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF18aadsuxd", `obsdate`="2020-11-02 11:10:15", `reportAddedDate`="2020-11-12 11:01:35", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"30" ,"g-ZTF" ,"1" ,"19.6656" ,null ,"ABMag" ,"ZTF18aadsuxd" ,"2020-10-31 12:26:09" ,"2020-11-12 11:01:35" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.6656", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18aadsuxd", `obsdate`="2020-10-31 12:26:09", `reportAddedDate`="2020-11-12 11:01:35", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"30" ,"orange-ATLAS" ,"0" ,"18.755" ,"0.176" ,"ABMag" ,"ATLAS20bfcp" ,"2020-11-03 14:34:05" ,"2020-11-08 16:21:36" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.755", `magErr`="0.176", `magUnit`="ABMag", `objectName`="ATLAS20bfcp", `obsdate`="2020-11-03 14:34:05", `reportAddedDate`="2020-11-08 16:21:36", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"30" ,"orange-ATLAS" ,"1" ,"16.63" ,null ,"ABMag" ,"ATLAS20bfcp" ,"2020-11-02 15:27:22" ,"2020-11-08 16:21:36" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="16.63", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bfcp", `obsdate`="2020-11-02 15:27:22", `reportAddedDate`="2020-11-08 16:21:36", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"30" ,"r-ZTF" ,"0" ,"19.4109" ,null ,"ABMag" ,"ZTF18aadsuxd" ,"2020-11-02 11:10:19" ,"2020-11-03 16:01:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4109", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18aadsuxd", `obsdate`="2020-11-02 11:10:19", `reportAddedDate`="2020-11-03 16:01:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yui" ,"30" ,"g-ZTF" ,"1" ,"19.6656" ,null ,"ABMag" ,"ZTF18aadsuxd" ,"2020-10-31 12:26:12" ,"2020-11-03 16:01:09" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yui", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.6656", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18aadsuxd", `obsdate`="2020-10-31 12:26:12", `reportAddedDate`="2020-11-03 16:01:09", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yqa" ,"45" ,"w-PS1" ,"0" ,"20.65" ,"0.13" ,"ABMag" ,"PS20mlj" ,"2020-12-12 14:24:00" ,"2020-12-20 14:27:14" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yqa", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.65", `magErr`="0.13", `magUnit`="ABMag", `objectName`="PS20mlj", `obsdate`="2020-12-12 14:24:00", `reportAddedDate`="2020-12-20 14:27:14", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yqa" ,"30" ,"r-ZTF" ,"0" ,"19.26" ,null ,"ABMag" ,"ZTF20acodppm" ,"2020-11-17 13:23:31" ,"2020-11-29 23:05:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yqa", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.26", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acodppm", `obsdate`="2020-11-17 13:23:31", `reportAddedDate`="2020-11-29 23:05:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yqa" ,"30" ,"r-ZTF" ,"0" ,"19.28" ,null ,"ABMag" ,"ZTF20acodppm" ,"2020-11-16 12:41:46" ,"2020-11-29 23:05:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yqa", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.28", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acodppm", `obsdate`="2020-11-16 12:41:46", `reportAddedDate`="2020-11-29 23:05:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yqa" ,"30" ,"g-ZTF" ,"1" ,"19.73" ,null ,"ABMag" ,"ZTF20acodppm" ,"2020-11-16 11:39:50" ,"2020-11-29 23:05:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yqa", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.73", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acodppm", `obsdate`="2020-11-16 11:39:50", `reportAddedDate`="2020-11-29 23:05:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yqa" ,"60" ,"G-Gaia" ,"0" ,"18.78" ,"0.2" ,"ABMag" ,"Gaia20faq" ,"2020-10-30 17:29:46" ,"2020-11-01 14:34:48" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yqa", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.78", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20faq", `obsdate`="2020-10-30 17:29:46", `reportAddedDate`="2020-11-01 14:34:48", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yqa" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20faq" ,"2020-06-23 11:16:48" ,"2020-11-01 14:34:48" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yqa", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20faq", `obsdate`="2020-06-23 11:16:48", `reportAddedDate`="2020-11-01 14:34:48", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ypm" ,"45" ,"w-PS1" ,"0" ,"20.97" ,"0.15" ,"ABMag" ,"PS20mkx" ,"2020-12-12 06:21:36" ,"2020-12-19 19:07:54" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ypm", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.97", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20mkx", `obsdate`="2020-12-12 06:21:36", `reportAddedDate`="2020-12-19 19:07:54", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ypm" ,"30" ,"r-ZTF" ,"0" ,"20.28" ,"0.17" ,"ABMag" ,"ZTF20ackpjmb" ,"2020-10-20 06:51:29" ,"2020-11-01 07:58:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ypm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.28", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20ackpjmb", `obsdate`="2020-10-20 06:51:29", `reportAddedDate`="2020-11-01 07:58:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ypm" ,"30" ,"g-ZTF" ,"0" ,"20.47" ,"0.21" ,"ABMag" ,"ZTF20ackpjmb" ,"2020-10-18 07:16:18" ,"2020-11-01 07:58:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ypm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.47", `magErr`="0.21", `magUnit`="ABMag", `objectName`="ZTF20ackpjmb", `obsdate`="2020-10-18 07:16:18", `reportAddedDate`="2020-11-01 07:58:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ypm" ,"30" ,"g-ZTF" ,"1" ,"20.3514" ,null ,"ABMag" ,"ZTF20ackpjmb" ,"2020-10-16 08:39:41" ,"2020-11-01 07:58:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ypm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3514", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20ackpjmb", `obsdate`="2020-10-16 08:39:41", `reportAddedDate`="2020-11-01 07:58:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhy" ,"45" ,"i-Sloan" ,"0" ,"19.9" ,"0.14" ,"ABMag" ,"PS20mjq" ,"2020-12-06 13:09:07" ,"2020-12-19 14:22:38" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhy", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.9", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS20mjq", `obsdate`="2020-12-06 13:09:07", `reportAddedDate`="2020-12-19 14:22:38", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhy" ,"30" ,"r-ZTF" ,"0" ,"19.74" ,"0.16" ,"ABMag" ,"ZTF20acisvli" ,"2020-10-28 11:23:38" ,"2020-10-28 21:00:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.74", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acisvli", `obsdate`="2020-10-28 11:23:38", `reportAddedDate`="2020-10-28 21:00:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhy" ,"30" ,"r-ZTF" ,"0" ,"19.49" ,"0.15" ,"ABMag" ,"ZTF20acisvli" ,"2020-10-28 11:21:31" ,"2020-10-28 21:00:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhy", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.49", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acisvli", `obsdate`="2020-10-28 11:21:31", `reportAddedDate`="2020-10-28 21:00:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhy" ,"30" ,"g-ZTF" ,"1" ,"19.5188" ,null ,"ABMag" ,"ZTF20acisvli" ,"2020-10-28 09:46:54" ,"2020-10-28 21:00:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhy", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.5188", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acisvli", `obsdate`="2020-10-28 09:46:54", `reportAddedDate`="2020-10-28 21:00:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"45" ,"w-PS1" ,"0" ,"20.17" ,"0.05" ,"ABMag" ,"PS20ktv" ,"2020-12-06 05:28:19" ,"2020-12-19 19:05:18" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.17", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS20ktv", `obsdate`="2020-12-06 05:28:19", `reportAddedDate`="2020-12-19 19:05:18", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"30" ,"orange-ATLAS" ,"0" ,"18.954" ,"0.127" ,"ABMag" ,"ATLAS20bewc" ,"2020-11-03 07:26:24" ,"2020-11-04 13:18:14" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.954", `magErr`="0.127", `magUnit`="ABMag", `objectName`="ATLAS20bewc", `obsdate`="2020-11-03 07:26:24", `reportAddedDate`="2020-11-04 13:18:14", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"30" ,"orange-ATLAS" ,"1" ,"18.55" ,null ,"ABMag" ,"ATLAS20bewc" ,"2020-11-01 09:37:26" ,"2020-11-04 13:18:14" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.55", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bewc", `obsdate`="2020-11-01 09:37:26", `reportAddedDate`="2020-11-04 13:18:14", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"45" ,"w-PS1" ,"0" ,"21.72" ,"0.32" ,"ABMag" ,"PS20ktv" ,"2020-10-20 05:13:55" ,"2020-11-02 20:25:41" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.72", `magErr`="0.32", `magUnit`="ABMag", `objectName`="PS20ktv", `obsdate`="2020-10-20 05:13:55", `reportAddedDate`="2020-11-02 20:25:41", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"30" ,"g-ZTF" ,"0" ,"19.13" ,"0.16" ,"ABMag" ,"ZTF20acmydwh" ,"2020-10-30 05:40:31" ,"2020-10-30 05:57:46" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.13", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acmydwh", `obsdate`="2020-10-30 05:40:31", `reportAddedDate`="2020-10-30 05:57:46", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"30" ,"r-ZTF" ,"0" ,"19.26" ,"0.15" ,"ABMag" ,"ZTF20acmydwh" ,"2020-10-30 04:53:33" ,"2020-10-30 05:57:46" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.26", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ZTF20acmydwh", `obsdate`="2020-10-30 04:53:33", `reportAddedDate`="2020-10-30 05:57:46", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"30" ,"g-ZTF" ,"1" ,"19.8016" ,null ,"ABMag" ,"ZTF20acmydwh" ,"2020-10-22 04:26:39" ,"2020-10-30 05:57:46" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8016", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acmydwh", `obsdate`="2020-10-22 04:26:39", `reportAddedDate`="2020-10-30 05:57:46", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"30" ,"r-ZTF" ,"0" ,"19.1773" ,"0.202009" ,"ABMag" ,"ZTF20acmydwh" ,"2020-10-28 06:05:04" ,"2020-10-28 20:36:53" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.1773", `magErr`="0.202009", `magUnit`="ABMag", `objectName`="ZTF20acmydwh", `obsdate`="2020-10-28 06:05:04", `reportAddedDate`="2020-10-28 20:36:53", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"30" ,"r-ZTF" ,"0" ,"19.9532" ,"0.226955" ,"ABMag" ,"ZTF20acmydwh" ,"2020-10-24 04:04:31" ,"2020-10-28 20:36:53" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9532", `magErr`="0.226955", `magUnit`="ABMag", `objectName`="ZTF20acmydwh", `obsdate`="2020-10-24 04:04:31", `reportAddedDate`="2020-10-28 20:36:53", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020yhl" ,"30" ,"g-ZTF" ,"1" ,"19.8016" ,null ,"ABMag" ,"ZTF20acmydwh" ,"2020-10-22 04:26:39" ,"2020-10-28 20:36:53" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020yhl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.8016", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acmydwh", `obsdate`="2020-10-22 04:26:39", `reportAddedDate`="2020-10-28 20:36:53", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"60" ,"G-Gaia" ,"0" ,"18.71" ,"0.2" ,"ABMag" ,"Gaia20fub" ,"2020-12-17 07:48:00" ,"2020-12-18 10:27:13" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.71", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fub", `obsdate`="2020-12-17 07:48:00", `reportAddedDate`="2020-12-18 10:27:13", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fub" ,"2020-06-27 00:43:12" ,"2020-12-18 10:27:13" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fub", `obsdate`="2020-06-27 00:43:12", `reportAddedDate`="2020-12-18 10:27:13", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"45" ,"i-Sloan" ,"0" ,"18.5" ,"0.17" ,"ABMag" ,"PS20khn" ,"2020-11-02 09:59:02" ,"2020-12-11 13:10:12" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="18.5", `magErr`="0.17", `magUnit`="ABMag", `objectName`="PS20khn", `obsdate`="2020-11-02 09:59:02", `reportAddedDate`="2020-12-11 13:10:12", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"30" ,"r-ZTF" ,"0" ,"18.58" ,"0.08" ,"ABMag" ,"ZTF20acmaaan" ,"2020-10-22 05:08:40" ,"2020-10-27 06:47:17" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.58", `magErr`="0.08", `magUnit`="ABMag", `objectName`="ZTF20acmaaan", `obsdate`="2020-10-22 05:08:40", `reportAddedDate`="2020-10-27 06:47:17", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"30" ,"g-ZTF" ,"0" ,"18.69" ,"0.07" ,"ABMag" ,"ZTF20acmaaan" ,"2020-10-21 08:36:13" ,"2020-10-27 06:47:17" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.69", `magErr`="0.07", `magUnit`="ABMag", `objectName`="ZTF20acmaaan", `obsdate`="2020-10-21 08:36:13", `reportAddedDate`="2020-10-27 06:47:17", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"30" ,"r-ZTF" ,"1" ,"20.6101" ,null ,"ABMag" ,"ZTF20acmaaan" ,"2020-10-21 05:10:34" ,"2020-10-27 06:47:17" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.6101", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acmaaan", `obsdate`="2020-10-21 05:10:34", `reportAddedDate`="2020-10-27 06:47:17", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"30" ,"orange-ATLAS" ,"0" ,"18.407" ,"0.065" ,"ABMag" ,"ATLAS20berr" ,"2020-10-23 09:36:00" ,"2020-10-25 17:09:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.407", `magErr`="0.065", `magUnit`="ABMag", `objectName`="ATLAS20berr", `obsdate`="2020-10-23 09:36:00", `reportAddedDate`="2020-10-25 17:09:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"30" ,"cyan-ATLAS" ,"1" ,"17.98" ,null ,"ABMag" ,"ATLAS20berr" ,"2020-10-21 10:39:22" ,"2020-10-25 17:09:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="17.98", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20berr", `obsdate`="2020-10-21 10:39:22", `reportAddedDate`="2020-10-25 17:09:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"45" ,"w-PS1" ,"0" ,"18.7" ,"0.03" ,"ABMag" ,"PS20khn" ,"2020-10-21 06:33:07" ,"2020-10-23 16:34:29" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="18.7", `magErr`="0.03", `magUnit`="ABMag", `objectName`="PS20khn", `obsdate`="2020-10-21 06:33:07", `reportAddedDate`="2020-10-23 16:34:29", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"30" ,"g-ZTF" ,"0" ,"18.5" ,null ,"ABMag" ,"ZTF20acmaaan" ,"2020-10-22 07:58:05" ,"2020-10-22 08:40:54" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.5", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acmaaan", `obsdate`="2020-10-22 07:58:05", `reportAddedDate`="2020-10-22 08:40:54", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"30" ,"g-ZTF" ,"0" ,"18.69" ,null ,"ABMag" ,"ZTF20acmaaan" ,"2020-10-21 08:35:31" ,"2020-10-22 08:40:54" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.69", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acmaaan", `obsdate`="2020-10-21 08:35:31", `reportAddedDate`="2020-10-22 08:40:54", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xyk" ,"30" ,"r-ZTF" ,"1" ,"20.61" ,null ,"ABMag" ,"ZTF20acmaaan" ,"2020-10-21 05:11:02" ,"2020-10-22 08:40:54" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xyk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.61", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acmaaan", `obsdate`="2020-10-21 05:11:02", `reportAddedDate`="2020-10-22 08:40:54", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xpm" ,"45" ,"w-PS1" ,"0" ,"20.58" ,"0.22" ,"ABMag" ,"PS20mhv" ,"2020-10-18 12:15:50" ,"2020-12-18 15:18:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xpm", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.58", `magErr`="0.22", `magUnit`="ABMag", `objectName`="PS20mhv", `obsdate`="2020-10-18 12:15:50", `reportAddedDate`="2020-12-18 15:18:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xpm" ,"30" ,"r-ZTF" ,"0" ,"20.4705" ,"0.203523" ,"ABMag" ,"ZTF20acljttk" ,"2020-10-20 06:53:30" ,"2020-10-20 19:25:18" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xpm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4705", `magErr`="0.203523", `magUnit`="ABMag", `objectName`="ZTF20acljttk", `obsdate`="2020-10-20 06:53:30", `reportAddedDate`="2020-10-20 19:25:18", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020xpm" ,"30" ,"g-ZTF" ,"1" ,"20.9785" ,null ,"ABMag" ,"ZTF20acljttk" ,"2020-10-18 07:07:26" ,"2020-10-20 19:25:18" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xpm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.9785", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acljttk", `obsdate`="2020-10-18 07:07:26", `reportAddedDate`="2020-10-20 19:25:18", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"45" ,"w-PS1" ,"0" ,"20.54" ,"0.09" ,"ABMag" ,"PS20kuw" ,"2020-12-12 11:36:58" ,"2020-12-19 18:52:05" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.54", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20kuw", `obsdate`="2020-12-12 11:36:58", `reportAddedDate`="2020-12-19 18:52:05", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"45" ,"w-PS1" ,"0" ,"18.49" ,"0.02" ,"ABMag" ,"PS20kuw" ,"2020-10-25 14:13:55" ,"2020-11-05 01:39:32" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="18.49", `magErr`="0.02", `magUnit`="ABMag", `objectName`="PS20kuw", `obsdate`="2020-10-25 14:13:55", `reportAddedDate`="2020-11-05 01:39:32", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"30" ,"r-ZTF" ,"0" ,"19.04" ,"0.09" ,"ABMag" ,"ZTF20acitbmh" ,"2020-10-13 11:39:14" ,"2020-10-17 11:44:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.04", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acitbmh", `obsdate`="2020-10-13 11:39:14", `reportAddedDate`="2020-10-17 11:44:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"30" ,"g-ZTF" ,"0" ,"18.87" ,"0.09" ,"ABMag" ,"ZTF20acitbmh" ,"2020-10-13 10:15:15" ,"2020-10-17 11:44:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.87", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acitbmh", `obsdate`="2020-10-13 10:15:15", `reportAddedDate`="2020-10-17 11:44:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"30" ,"r-ZTF" ,"1" ,"20.0689" ,null ,"ABMag" ,"ZTF20acitbmh" ,"2020-10-07 11:52:35" ,"2020-10-17 11:44:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0689", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acitbmh", `obsdate`="2020-10-07 11:52:35", `reportAddedDate`="2020-10-17 11:44:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"30" ,"cyan-ATLAS" ,"0" ,"18.781" ,"0.105" ,"ABMag" ,"ATLAS20bdnn" ,"2020-10-14 14:29:46" ,"2020-10-16 08:32:16" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.781", `magErr`="0.105", `magUnit`="ABMag", `objectName`="ATLAS20bdnn", `obsdate`="2020-10-14 14:29:46", `reportAddedDate`="2020-10-16 08:32:16", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"30" ,"orange-ATLAS" ,"1" ,"18.35" ,null ,"ABMag" ,"ATLAS20bdnn" ,"2020-10-11 15:08:38" ,"2020-10-16 08:32:16" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.35", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bdnn", `obsdate`="2020-10-11 15:08:38", `reportAddedDate`="2020-10-16 08:32:16", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"30" ,"r-ZTF" ,"0" ,"19.04" ,"0.0874159" ,"ABMag" ,"ZTF20acitbmh" ,"2020-10-13 11:39:14" ,"2020-10-13 21:59:38" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.04", `magErr`="0.0874159", `magUnit`="ABMag", `objectName`="ZTF20acitbmh", `obsdate`="2020-10-13 11:39:14", `reportAddedDate`="2020-10-13 21:59:38", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"30" ,"g-ZTF" ,"0" ,"18.8688" ,"0.0867893" ,"ABMag" ,"ZTF20acitbmh" ,"2020-10-13 10:15:15" ,"2020-10-13 21:59:38" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.8688", `magErr`="0.0867893", `magUnit`="ABMag", `objectName`="ZTF20acitbmh", `obsdate`="2020-10-13 10:15:15", `reportAddedDate`="2020-10-13 21:59:38", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wie" ,"30" ,"r-ZTF" ,"1" ,"20.0689" ,null ,"ABMag" ,"ZTF20acitbmh" ,"2020-10-07 11:52:35" ,"2020-10-13 21:59:38" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wie", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0689", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acitbmh", `obsdate`="2020-10-07 11:52:35", `reportAddedDate`="2020-10-13 21:59:38", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020whq" ,"45" ,"i-Sloan" ,"0" ,"19.89" ,"0.25" ,"ABMag" ,"PS20mib" ,"2020-11-28 13:27:50" ,"2020-12-18 19:45:26" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020whq", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.89", `magErr`="0.25", `magUnit`="ABMag", `objectName`="PS20mib", `obsdate`="2020-11-28 13:27:50", `reportAddedDate`="2020-12-18 19:45:26", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020whq" ,"30" ,"g-ZTF" ,"0" ,"20.35" ,"0.24" ,"ABMag" ,"ZTF20aciuubo" ,"2020-10-20 11:51:55" ,"2020-10-20 16:45:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020whq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.35", `magErr`="0.24", `magUnit`="ABMag", `objectName`="ZTF20aciuubo", `obsdate`="2020-10-20 11:51:55", `reportAddedDate`="2020-10-20 16:45:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020whq" ,"30" ,"r-ZTF" ,"0" ,"19.22" ,"0.12" ,"ABMag" ,"ZTF20aciuubo" ,"2020-10-18 12:47:34" ,"2020-10-20 16:45:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020whq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.22", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20aciuubo", `obsdate`="2020-10-18 12:47:34", `reportAddedDate`="2020-10-20 16:45:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020whq" ,"30" ,"g-ZTF" ,"1" ,"20.3016" ,null ,"ABMag" ,"ZTF20aciuubo" ,"2020-10-18 12:18:20" ,"2020-10-20 16:45:30" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020whq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.3016", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aciuubo", `obsdate`="2020-10-18 12:18:20", `reportAddedDate`="2020-10-20 16:45:30", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020whq" ,"30" ,"r-ZTF" ,"0" ,"19.2313" ,"0.100893" ,"ABMag" ,"ZTF20aciuubo" ,"2020-10-13 11:44:48" ,"2020-10-13 21:59:38" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020whq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2313", `magErr`="0.100893", `magUnit`="ABMag", `objectName`="ZTF20aciuubo", `obsdate`="2020-10-13 11:44:48", `reportAddedDate`="2020-10-13 21:59:38", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020whq" ,"30" ,"g-ZTF" ,"1" ,"20.4238" ,null ,"ABMag" ,"ZTF20aciuubo" ,"2020-10-13 11:09:21" ,"2020-10-13 21:59:38" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020whq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4238", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aciuubo", `obsdate`="2020-10-13 11:09:21", `reportAddedDate`="2020-10-13 21:59:38", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wcj" ,"60" ,"G-Gaia" ,"0" ,"18.8" ,"0.2" ,"ABMag" ,"Gaia20fun" ,"2020-12-17 20:55:41" ,"2020-12-19 14:15:55" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.8", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fun", `obsdate`="2020-12-17 20:55:41", `reportAddedDate`="2020-12-19 14:15:55", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wcj" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fun" ,"2020-08-08 18:40:19" ,"2020-12-19 14:15:55" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fun", `obsdate`="2020-08-08 18:40:19", `reportAddedDate`="2020-12-19 14:15:55", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wcj" ,"200" ,"w-PS1" ,"0" ,"17.12" ,"0.01" ,"ABMag" ,"PS20jur" ,"2020-11-14 10:29:17" ,"2020-12-10 13:34:03" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `exptime`="200", `filter`="w-PS1", `limitingMag`="0", `mag`="17.12", `magErr`="0.01", `magUnit`="ABMag", `objectName`="PS20jur", `obsdate`="2020-11-14 10:29:17", `reportAddedDate`="2020-12-10 13:34:03", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wcj" ,"45" ,"w-PS1" ,"0" ,"17.59" ,"0.01" ,"ABMag" ,"PS20jur" ,"2020-10-15 12:17:17" ,"2020-10-18 10:22:49" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="17.59", `magErr`="0.01", `magUnit`="ABMag", `objectName`="PS20jur", `obsdate`="2020-10-15 12:17:17", `reportAddedDate`="2020-10-18 10:22:49", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wcj" ,"30" ,"orange-ATLAS" ,"0" ,"19.301" ,"0.183" ,"ABMag" ,"ATLAS20bdgn" ,"2020-10-12 13:42:14" ,"2020-10-12 22:32:27" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="19.301", `magErr`="0.183", `magUnit`="ABMag", `objectName`="ATLAS20bdgn", `obsdate`="2020-10-12 13:42:14", `reportAddedDate`="2020-10-12 22:32:27", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wcj" ,"30" ,"orange-ATLAS" ,"1" ,"19.68" ,null ,"ABMag" ,"ATLAS20bdgn" ,"2020-10-10 11:36:58" ,"2020-10-12 22:32:27" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.68", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bdgn", `obsdate`="2020-10-10 11:36:58", `reportAddedDate`="2020-10-12 22:32:27", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wcj" ,"30" ,"g-ZTF" ,"0" ,"19.3898" ,null ,"ABMag" ,"ZTF20acikuon" ,"2020-10-12 09:07:47" ,"2020-10-12 18:01:05" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.3898", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acikuon", `obsdate`="2020-10-12 09:07:47", `reportAddedDate`="2020-10-12 18:01:05", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020wcj" ,"30" ,"r-ZTF" ,"1" ,"20.3367" ,null ,"ABMag" ,"ZTF20acikuon" ,"2020-10-08 10:08:33" ,"2020-10-12 18:01:05" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020wcj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.3367", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acikuon", `obsdate`="2020-10-08 10:08:33", `reportAddedDate`="2020-10-12 18:01:05", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020vwl" ,"30" ,"g-ZTF" ,"0" ,"17.61" ,null ,"ABMag" ,"ZTF20achpcvt" ,"2020-12-20 12:56:10" ,"2020-12-20 16:38:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020vwl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="17.61", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20achpcvt", `obsdate`="2020-12-20 12:56:10", `reportAddedDate`="2020-12-20 16:38:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020vwl" ,"30" ,"r-ZTF" ,"0" ,"17.66" ,null ,"ABMag" ,"ZTF20achpcvt" ,"2020-12-20 12:15:50" ,"2020-12-20 16:38:10" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020vwl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="17.66", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20achpcvt", `obsdate`="2020-12-20 12:15:50", `reportAddedDate`="2020-12-20 16:38:10", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020vwl" ,"30" ,"orange-ATLAS" ,"0" ,"18.52" ,"0.143" ,"ABMag" ,"ATLAS20bdgk" ,"2020-10-11 04:58:05" ,"2020-10-12 15:44:42" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020vwl", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.52", `magErr`="0.143", `magUnit`="ABMag", `objectName`="ATLAS20bdgk", `obsdate`="2020-10-11 04:58:05", `reportAddedDate`="2020-10-12 15:44:42", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020vwl" ,"30" ,"cyan-ATLAS" ,"1" ,"19.28" ,null ,"ABMag" ,"ATLAS20bdgk" ,"2020-10-09 05:25:26" ,"2020-10-12 15:44:42" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020vwl", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.28", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bdgk", `obsdate`="2020-10-09 05:25:26", `reportAddedDate`="2020-10-12 15:44:42", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020vwl" ,"60" ,"G-Gaia" ,"0" ,"17.94" ,"0.2" ,"ABMag" ,"Gaia20etp" ,"2020-10-10 17:28:19" ,"2020-10-12 09:34:13" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020vwl", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.94", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20etp", `obsdate`="2020-10-10 17:28:19", `reportAddedDate`="2020-10-12 09:34:13", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020vwl" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20etp" ,"2020-10-10 15:41:46" ,"2020-10-12 09:34:13" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020vwl", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20etp", `obsdate`="2020-10-10 15:41:46", `reportAddedDate`="2020-10-12 09:34:13", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020uxz" ,"60" ,"G-Gaia" ,"0" ,"16.09" ,"0.2" ,"ABMag" ,"Gaia20fty" ,"2020-12-17 07:32:10" ,"2020-12-18 10:24:54" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="16.09", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20fty", `obsdate`="2020-12-17 07:32:10", `reportAddedDate`="2020-12-18 10:24:54", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020uxz" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20fty" ,"2020-08-02 02:18:14" ,"2020-12-18 10:24:54" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20fty", `obsdate`="2020-08-02 02:18:14", `reportAddedDate`="2020-12-18 10:24:54", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020uxz" ,"45" ,"w-PS1" ,"0" ,"13.74" ,null ,"ABMag" ,"PS20idl" ,"2020-10-16 11:24:00" ,"2020-10-20 09:56:03" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="13.74", `magErr`=null, `magUnit`="ABMag", `objectName`="PS20idl", `obsdate`="2020-10-16 11:24:00", `reportAddedDate`="2020-10-20 09:56:03", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020uxz" ,"30" ,"g-ZTF" ,"0" ,"15.71" ,"0.03" ,"ABMag" ,"ZTF20achlced" ,"2020-10-07 08:35:33" ,"2020-10-12 07:43:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="15.71", `magErr`="0.03", `magUnit`="ABMag", `objectName`="ZTF20achlced", `obsdate`="2020-10-07 08:35:33", `reportAddedDate`="2020-10-12 07:43:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020uxz" ,"30" ,"r-ZTF" ,"0" ,"15.77" ,"0.03" ,"ABMag" ,"ZTF20achlced" ,"2020-10-07 06:22:21" ,"2020-10-12 07:43:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="15.77", `magErr`="0.03", `magUnit`="ABMag", `objectName`="ZTF20achlced", `obsdate`="2020-10-07 06:22:21", `reportAddedDate`="2020-10-12 07:43:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020uxz" ,"30" ,"g-ZTF" ,"1" ,"19.5686" ,null ,"ABMag" ,"ZTF20achlced" ,"2020-09-29 07:24:42" ,"2020-10-12 07:43:47" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.5686", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20achlced", `obsdate`="2020-09-29 07:24:42", `reportAddedDate`="2020-10-12 07:43:47", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020uxz" ,"27" ,"g-Sloan" ,"0" ,"15.6" ,"0.01" ,"ABMag" ,"PS20idl" ,"2020-10-07 12:24:29" ,"2020-10-11 01:01:57" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="15.6", `magErr`="0.01", `magUnit`="ABMag", `objectName`="PS20idl", `obsdate`="2020-10-07 12:24:29", `reportAddedDate`="2020-10-11 01:01:57", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020uxz" ,"300" ,"R-Cousins" ,"0" ,"15.5" ,null ,"VegaMag" ,null ,"2020-10-09 09:40:00" ,"2020-10-09 11:58:56" ,null ,"PSN" ,"Fumitake Watanabe" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020uxz", `exptime`="300", `filter`="R-Cousins", `limitingMag`="0", `mag`="15.5", `magErr`=null, `magUnit`="VegaMag", `objectName`=null, `obsdate`="2020-10-09 09:40:00", `reportAddedDate`="2020-10-09 11:58:56", `reportingGroup`=null, `suggestedType`="PSN", `survey`="Fumitake Watanabe", 