"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginAccessIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const cloudfront_generated_1 = require("./cloudfront.generated");
class OriginAccessIdentityBase extends cdk.Resource {
    /**
     * The ARN to include in S3 bucket policy to allow CloudFront access.
     *
     * @stability stable
     */
    arn() {
        return cdk.Stack.of(this).formatArn({
            service: 'iam',
            region: '',
            account: 'cloudfront',
            resource: 'user',
            resourceName: `CloudFront Origin Access Identity ${this.originAccessIdentityName}`,
        });
    }
}
/**
 * An origin access identity is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of your Amazon S3 content.
 *
 * @stability stable
 * @resource AWS::CloudFront::CloudFrontOriginAccessIdentity
 */
class OriginAccessIdentity extends OriginAccessIdentityBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        // Comment has a max length of 128.
        const comment = ((_b = props === null || props === void 0 ? void 0 : props.comment) !== null && _b !== void 0 ? _b : 'Allows CloudFront to reach the bucket').substr(0, 128);
        this.resource = new cloudfront_generated_1.CfnCloudFrontOriginAccessIdentity(this, 'Resource', {
            cloudFrontOriginAccessIdentityConfig: { comment },
        });
        // physical id - OAI name
        this.originAccessIdentityName = this.getResourceNameAttribute(this.resource.ref);
        // Canonical user to grant access to in the S3 Bucket Policy
        this.cloudFrontOriginAccessIdentityS3CanonicalUserId = this.resource.attrS3CanonicalUserId;
        // The principal for must be either the canonical user or a special ARN
        // with the CloudFront Origin Access Id (see `arn()` method). For
        // import/export the OAI is anyway required so the principal is constructed
        // with it. But for the normal case the S3 Canonical User as a nicer
        // interface and does not require constructing the ARN.
        this.grantPrincipal = new iam.CanonicalUserPrincipal(this.cloudFrontOriginAccessIdentityS3CanonicalUserId);
    }
    /**
     * Creates a OriginAccessIdentity by providing the OriginAccessIdentityName.
     *
     * @stability stable
     */
    static fromOriginAccessIdentityName(scope, id, originAccessIdentityName) {
        class Import extends OriginAccessIdentityBase {
            constructor(s, i) {
                super(s, i, { physicalName: originAccessIdentityName });
                this.originAccessIdentityName = originAccessIdentityName;
                this.grantPrincipal = new iam.ArnPrincipal(this.arn());
            }
        }
        return new Import(scope, id);
    }
}
exports.OriginAccessIdentity = OriginAccessIdentity;
_a = JSII_RTTI_SYMBOL_1;
OriginAccessIdentity[_a] = { fqn: "@aws-cdk/aws-cloudfront.OriginAccessIdentity", version: "1.113.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3JpZ2luLWFjY2Vzcy1pZGVudGl0eS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm9yaWdpbi1hY2Nlc3MtaWRlbnRpdHkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSx3Q0FBd0M7QUFDeEMscUNBQXFDO0FBRXJDLGlFQUEyRTtBQWMzRSxNQUFlLHdCQUF5QixTQUFRLEdBQUcsQ0FBQyxRQUFROzs7Ozs7SUFXaEQsR0FBRztRQUNYLE9BQU8sR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUNqQztZQUNFLE9BQU8sRUFBRSxLQUFLO1lBQ2QsTUFBTSxFQUFFLEVBQUU7WUFDVixPQUFPLEVBQUUsWUFBWTtZQUNyQixRQUFRLEVBQUUsTUFBTTtZQUNoQixZQUFZLEVBQUUscUNBQXFDLElBQUksQ0FBQyx3QkFBd0IsRUFBRTtTQUNuRixDQUNGLENBQUM7SUFDSixDQUFDO0NBQ0Y7Ozs7Ozs7QUFHRCxNQUFhLG9CQUFxQixTQUFRLHdCQUF3Qjs7OztJQWdDaEUsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFpQzs7UUFDekUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixtQ0FBbUM7UUFDbkMsTUFBTSxPQUFPLEdBQUcsT0FBQyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTyxtQ0FBSSx1Q0FBdUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDM0YsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLHdEQUFpQyxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDdEUsb0NBQW9DLEVBQUUsRUFBRSxPQUFPLEVBQUU7U0FDbEQsQ0FBQyxDQUFDO1FBQ0gseUJBQXlCO1FBQ3pCLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxJQUFJLENBQUMsd0JBQXdCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUVqRiw0REFBNEQ7UUFDNUQsSUFBSSxDQUFDLCtDQUErQyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMscUJBQXFCLENBQUM7UUFDM0YsdUVBQXVFO1FBQ3ZFLGlFQUFpRTtRQUNqRSwyRUFBMkU7UUFDM0Usb0VBQW9FO1FBQ3BFLHVEQUF1RDtRQUN2RCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksR0FBRyxDQUFDLHNCQUFzQixDQUFDLElBQUksQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO0lBQzdHLENBQUM7Ozs7OztJQWpETSxNQUFNLENBQUMsNEJBQTRCLENBQ3hDLEtBQWdCLEVBQ2hCLEVBQVUsRUFDVix3QkFBZ0M7UUFFaEMsTUFBTSxNQUFPLFNBQVEsd0JBQXdCO1lBRzNDLFlBQVksQ0FBWSxFQUFFLENBQVM7Z0JBQ2pDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsWUFBWSxFQUFFLHdCQUF3QixFQUFFLENBQUMsQ0FBQztnQkFIMUMsNkJBQXdCLEdBQUcsd0JBQXdCLENBQUM7Z0JBQ3BELG1CQUFjLEdBQUcsSUFBSSxHQUFHLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO1lBR2xFLENBQUM7U0FDRjtRQUVELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQy9CLENBQUM7O0FBaEJILG9EQW9EQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuQ2xvdWRGcm9udE9yaWdpbkFjY2Vzc0lkZW50aXR5IH0gZnJvbSAnLi9jbG91ZGZyb250LmdlbmVyYXRlZCc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIE9yaWdpbkFjY2Vzc0lkZW50aXR5UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb21tZW50Pzogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBJT3JpZ2luQWNjZXNzSWRlbnRpdHkgZXh0ZW5kcyBjZGsuSVJlc291cmNlLCBpYW0uSUdyYW50YWJsZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgb3JpZ2luQWNjZXNzSWRlbnRpdHlOYW1lOiBzdHJpbmc7XG59XG5cbmFic3RyYWN0IGNsYXNzIE9yaWdpbkFjY2Vzc0lkZW50aXR5QmFzZSBleHRlbmRzIGNkay5SZXNvdXJjZSB7XG4gIC8qKlxuICAgKiBUaGUgT3JpZ2luIEFjY2VzcyBJZGVudGl0eSBOYW1lIChwaHlzaWNhbCBpZClcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBvcmlnaW5BY2Nlc3NJZGVudGl0eU5hbWU6IHN0cmluZztcbiAgLyoqXG4gICAqIERlcml2ZWQgcHJpbmNpcGFsIHZhbHVlIGZvciBidWNrZXQgYWNjZXNzXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgZ3JhbnRQcmluY2lwYWw6IGlhbS5JUHJpbmNpcGFsO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHByb3RlY3RlZCBhcm4oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gY2RrLlN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybihcbiAgICAgIHtcbiAgICAgICAgc2VydmljZTogJ2lhbScsXG4gICAgICAgIHJlZ2lvbjogJycsIC8vIGdsb2JhbFxuICAgICAgICBhY2NvdW50OiAnY2xvdWRmcm9udCcsXG4gICAgICAgIHJlc291cmNlOiAndXNlcicsXG4gICAgICAgIHJlc291cmNlTmFtZTogYENsb3VkRnJvbnQgT3JpZ2luIEFjY2VzcyBJZGVudGl0eSAke3RoaXMub3JpZ2luQWNjZXNzSWRlbnRpdHlOYW1lfWAsXG4gICAgICB9LFxuICAgICk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgT3JpZ2luQWNjZXNzSWRlbnRpdHkgZXh0ZW5kcyBPcmlnaW5BY2Nlc3NJZGVudGl0eUJhc2UgaW1wbGVtZW50cyBJT3JpZ2luQWNjZXNzSWRlbnRpdHkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tT3JpZ2luQWNjZXNzSWRlbnRpdHlOYW1lKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgaWQ6IHN0cmluZyxcbiAgICBvcmlnaW5BY2Nlc3NJZGVudGl0eU5hbWU6IHN0cmluZyk6IElPcmlnaW5BY2Nlc3NJZGVudGl0eSB7XG5cbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBPcmlnaW5BY2Nlc3NJZGVudGl0eUJhc2Uge1xuICAgICAgcHVibGljIHJlYWRvbmx5IG9yaWdpbkFjY2Vzc0lkZW50aXR5TmFtZSA9IG9yaWdpbkFjY2Vzc0lkZW50aXR5TmFtZTtcbiAgICAgIHB1YmxpYyByZWFkb25seSBncmFudFByaW5jaXBhbCA9IG5ldyBpYW0uQXJuUHJpbmNpcGFsKHRoaXMuYXJuKCkpO1xuICAgICAgY29uc3RydWN0b3IoczogQ29uc3RydWN0LCBpOiBzdHJpbmcpIHtcbiAgICAgICAgc3VwZXIocywgaSwgeyBwaHlzaWNhbE5hbWU6IG9yaWdpbkFjY2Vzc0lkZW50aXR5TmFtZSB9KTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgY2xvdWRGcm9udE9yaWdpbkFjY2Vzc0lkZW50aXR5UzNDYW5vbmljYWxVc2VySWQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgZ3JhbnRQcmluY2lwYWw6IGlhbS5JUHJpbmNpcGFsO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgb3JpZ2luQWNjZXNzSWRlbnRpdHlOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIENESyBMMSByZXNvdXJjZVxuICAgKi9cbiAgcHJpdmF0ZSByZWFkb25seSByZXNvdXJjZTogQ2ZuQ2xvdWRGcm9udE9yaWdpbkFjY2Vzc0lkZW50aXR5O1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogT3JpZ2luQWNjZXNzSWRlbnRpdHlQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAvLyBDb21tZW50IGhhcyBhIG1heCBsZW5ndGggb2YgMTI4LlxuICAgIGNvbnN0IGNvbW1lbnQgPSAocHJvcHM/LmNvbW1lbnQgPz8gJ0FsbG93cyBDbG91ZEZyb250IHRvIHJlYWNoIHRoZSBidWNrZXQnKS5zdWJzdHIoMCwgMTI4KTtcbiAgICB0aGlzLnJlc291cmNlID0gbmV3IENmbkNsb3VkRnJvbnRPcmlnaW5BY2Nlc3NJZGVudGl0eSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBjbG91ZEZyb250T3JpZ2luQWNjZXNzSWRlbnRpdHlDb25maWc6IHsgY29tbWVudCB9LFxuICAgIH0pO1xuICAgIC8vIHBoeXNpY2FsIGlkIC0gT0FJIG5hbWVcbiAgICB0aGlzLm9yaWdpbkFjY2Vzc0lkZW50aXR5TmFtZSA9IHRoaXMuZ2V0UmVzb3VyY2VOYW1lQXR0cmlidXRlKHRoaXMucmVzb3VyY2UucmVmKTtcblxuICAgIC8vIENhbm9uaWNhbCB1c2VyIHRvIGdyYW50IGFjY2VzcyB0byBpbiB0aGUgUzMgQnVja2V0IFBvbGljeVxuICAgIHRoaXMuY2xvdWRGcm9udE9yaWdpbkFjY2Vzc0lkZW50aXR5UzNDYW5vbmljYWxVc2VySWQgPSB0aGlzLnJlc291cmNlLmF0dHJTM0Nhbm9uaWNhbFVzZXJJZDtcbiAgICAvLyBUaGUgcHJpbmNpcGFsIGZvciBtdXN0IGJlIGVpdGhlciB0aGUgY2Fub25pY2FsIHVzZXIgb3IgYSBzcGVjaWFsIEFSTlxuICAgIC8vIHdpdGggdGhlIENsb3VkRnJvbnQgT3JpZ2luIEFjY2VzcyBJZCAoc2VlIGBhcm4oKWAgbWV0aG9kKS4gRm9yXG4gICAgLy8gaW1wb3J0L2V4cG9ydCB0aGUgT0FJIGlzIGFueXdheSByZXF1aXJlZCBzbyB0aGUgcHJpbmNpcGFsIGlzIGNvbnN0cnVjdGVkXG4gICAgLy8gd2l0aCBpdC4gQnV0IGZvciB0aGUgbm9ybWFsIGNhc2UgdGhlIFMzIENhbm9uaWNhbCBVc2VyIGFzIGEgbmljZXJcbiAgICAvLyBpbnRlcmZhY2UgYW5kIGRvZXMgbm90IHJlcXVpcmUgY29uc3RydWN0aW5nIHRoZSBBUk4uXG4gICAgdGhpcy5ncmFudFByaW5jaXBhbCA9IG5ldyBpYW0uQ2Fub25pY2FsVXNlclByaW5jaXBhbCh0aGlzLmNsb3VkRnJvbnRPcmlnaW5BY2Nlc3NJZGVudGl0eVMzQ2Fub25pY2FsVXNlcklkKTtcbiAgfVxufVxuIl19