import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as lambda from '@aws-cdk/aws-lambda';
import { ConstructNode, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * Properties for creating a Lambda@Edge function.
 *
 * @stability stable
 */
export interface EdgeFunctionProps extends lambda.FunctionProps {
    /**
     * The stack ID of Lambda@Edge function.
     *
     * @default - `edge-lambda-stack-${region}`
     * @stability stable
     */
    readonly stackId?: string;
}
/**
 * A Lambda@Edge function.
 *
 * Convenience resource for requesting a Lambda function in the 'us-east-1' region for use with Lambda@Edge.
 * Implements several restrictions enforced by Lambda@Edge.
 *
 * Note that this construct requires that the 'us-east-1' region has been bootstrapped.
 * See https://docs.aws.amazon.com/cdk/latest/guide/bootstrapping.html or 'cdk bootstrap --help' for options.
 *
 * @stability stable
 * @resource AWS::Lambda::Function
 */
export declare class EdgeFunction extends Resource implements lambda.IVersion {
    private static readonly EDGE_REGION;
    /**
     * The ARN of the version for Lambda@Edge.
     *
     * @stability stable
     */
    readonly edgeArn: string;
    /**
     * The name of the function.
     *
     * @stability stable
     */
    readonly functionName: string;
    /**
     * The ARN fo the function.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * The principal to grant permissions to.
     *
     * @stability stable
     */
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * Whether or not this Lambda function was bound to a VPC.
     *
     * If this is is `false`, trying to access the `connections` object will fail.
     *
     * @stability stable
     */
    readonly isBoundToVpc = false;
    /**
     * The construct node where permissions are attached.
     *
     * @stability stable
     */
    readonly permissionsNode: ConstructNode;
    /**
     * The IAM role associated with this function.
     *
     * @stability stable
     */
    readonly role?: iam.IRole;
    /**
     * The most recently deployed version of this function.
     *
     * @stability stable
     */
    readonly version: string;
    private readonly _edgeFunction;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: EdgeFunctionProps);
    /**
     * The underlying AWS Lambda function.
     *
     * @stability stable
     */
    get lambda(): lambda.IFunction;
    /**
     * Convenience method to make `EdgeFunction` conform to the same interface as `Function`.
     *
     * @stability stable
     */
    get currentVersion(): lambda.IVersion;
    /**
     * Defines an alias for this version.
     *
     * @stability stable
     */
    addAlias(aliasName: string, options?: lambda.AliasOptions): lambda.Alias;
    /**
     * Not supported.
     *
     * Connections are only applicable to VPC-enabled functions.
     *
     * @stability stable
     */
    get connections(): ec2.Connections;
    /**
     * The `$LATEST` version of this function.
     *
     * Note that this is reference to a non-specific AWS Lambda version, which
     * means the function this version refers to can return different results in
     * different invocations.
     *
     * To obtain a reference to an explicit version which references the current
     * function configuration, use `lambdaFunction.currentVersion` instead.
     *
     * @stability stable
     */
    get latestVersion(): lambda.IVersion;
    /**
     * Adds an event source that maps to this AWS Lambda function.
     *
     * @stability stable
     */
    addEventSourceMapping(id: string, options: lambda.EventSourceMappingOptions): lambda.EventSourceMapping;
    /**
     * Adds a permission to the Lambda resource policy.
     *
     * @stability stable
     */
    addPermission(id: string, permission: lambda.Permission): void;
    /**
     * Adds a statement to the IAM role assumed by the instance.
     *
     * @stability stable
     */
    addToRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * Grant the given identity permissions to invoke this Lambda.
     *
     * @stability stable
     */
    grantInvoke(identity: iam.IGrantable): iam.Grant;
    /**
     * Return the given named metric for this Lambda Return the given named metric for this Function.
     *
     * Return the given named metric for this Lambda Return the given named metric for this Function.
     *
     * @stability stable
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Metric for the Duration of this Lambda How long execution of this Lambda takes.
     *
     * Average over 5 minutes
     * Metric for the Duration of this Lambda How long execution of this Lambda takes.
     *
     * Average over 5 minutes
     *
     * @stability stable
     */
    metricDuration(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * How many invocations of this Lambda fail.
     *
     * Sum over 5 minutes
     *
     * @stability stable
     */
    metricErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Metric for the number of invocations of this Lambda How often this Lambda is invoked.
     *
     * Sum over 5 minutes
     * Metric for the number of invocations of this Lambda How often this Lambda is invoked.
     *
     * Sum over 5 minutes
     *
     * @stability stable
     */
    metricInvocations(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
     *
     * Sum over 5 minutes
     * Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
     *
     * Sum over 5 minutes
     *
     * @stability stable
     */
    metricThrottles(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * Adds an event source to this function.
     *
     * @stability stable
     */
    addEventSource(source: lambda.IEventSource): void;
    /**
     * Configures options for asynchronous invocation.
     *
     * @stability stable
     */
    configureAsyncInvoke(options: lambda.EventInvokeConfigOptions): void;
    /** Create a function in-region */
    private createInRegionFunction;
    /** Create a support stack and function in us-east-1, and a SSM reader in-region */
    private createCrossRegionFunction;
    private createCrossRegionArnReader;
    private edgeStack;
}
