from typing import Optional

from requests.exceptions import HTTPError as RequestsHTTPError
from requests.exceptions import RequestException

class APIError(Exception): ...
class UnsupportedQbittorrentVersion(APIError): ...
class FileError(IOError, APIError): ...
class TorrentFileError(FileError): ...
class TorrentFileNotFoundError(TorrentFileError): ...
class TorrentFilePermissionError(TorrentFileError): ...
class APIConnectionError(RequestException, APIError): ...
class LoginFailed(APIConnectionError): ...

class HTTPError(RequestsHTTPError, APIConnectionError):
    http_status_code: Optional[int] = None

class HTTP4XXError(HTTPError): ...
class HTTP5XXError(HTTPError): ...
class HTTP400Error(HTTP4XXError): ...
class HTTP401Error(HTTP4XXError): ...
class HTTP403Error(HTTP4XXError): ...
class HTTP404Error(HTTP4XXError): ...
class HTTP405Error(HTTP4XXError): ...
class HTTP409Error(HTTP4XXError): ...
class HTTP415Error(HTTP4XXError): ...
class HTTP500Error(HTTP5XXError): ...
class MissingRequiredParameters400Error(HTTP400Error): ...
class InvalidRequest400Error(HTTP400Error): ...
class Unauthorized401Error(HTTP401Error): ...
class Forbidden403Error(HTTP403Error): ...
class NotFound404Error(HTTP404Error): ...
class MethodNotAllowed405Error(HTTP404Error): ...
class Conflict409Error(HTTP409Error): ...
class UnsupportedMediaType415Error(HTTP415Error): ...
class InternalServerError500Error(HTTP500Error): ...
