"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegManifestWriter = void 0;
const fs = require("fs");
const path = require("path");
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
class IntegManifestWriter {
    static write(manifest, filePath) {
        cloud_assembly_schema_1.Manifest.saveIntegManifest(manifest, getFinalLocation(filePath));
    }
}
IntegManifestWriter.DEFAULT_FILENAME = 'integ.json';
exports.IntegManifestWriter = IntegManifestWriter;
function getFinalLocation(filePath) {
    try {
        const st = fs.statSync(filePath);
        return st.isDirectory()
            ? path.join(filePath, IntegManifestWriter.DEFAULT_FILENAME)
            : filePath;
    }
    catch (e) {
        if (e.code === 'ENOENT') {
            return filePath;
        }
        throw new Error(`Cannot write integ manifest to '${filePath}': ${e.message}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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