#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = ['Click>=7.0', 'rich', 'gpflow<2.6.0', ]

test_requirements = ['pytest>=3', ]

setup(
    author="Louis Tiao",
    author_email='louistiao@gmail.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Various extensions and mods for GPflow",
    entry_points={
        'console_scripts': [
            'gptk_run=gptk.cli:main',
        ],
    },
    install_requires=requirements,
    extras_require={
        # "spherical": [
        #     "Spherical_Harmonics @ git+https://github.com/vdutor/SphericalHarmonics.git",
        # ],
        "datasets": [
            'scikit-learn', 'pandas'
        ]
    },
    license="MIT license",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='gptk',
    name='gp-toolkit',
    packages=find_packages(include=['gptk', 'gptk.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/ltiao/gp-toolkit',
    version='0.1.1',
    zip_safe=False,
)
