import pytest

from square_matrix_converter import convert_matrix


@pytest.mark.parametrize(
    "matrix,square_matrix",
    [
        (
            "",
            ValueError,
        ),
        (
            "+-----+\n"
            "|     |\n"
            "+-----+",
            ValueError,
        ),
        (
            "+-----+\n"
            "|  10 |\n"
            "+-----+",
            [[10]],
        ),
        (
            "+-----+-----+\n"
            "|     |     |\n"
            "+-----+-----+",
            ValueError,
        ),
        (
            "+-----+-----+\n"
            "|  10 |  20 |\n"
            "+-----+-----+\n"
            "|  30 |  40 |\n"
            "+-----+-----+",
            [[10, 20], [30, 40]],
        ),
        (
            "+-----+-----+\n"
            "|     |     |\n"
            "+-----+-----+\n"
            "|     |     |\n"
            "+-----+-----+",
            ValueError,
        ),
        (
            "+-----+-----+-----+\n"
            "|  10 |  20 |  30 |\n"
            "+-----+-----+-----+\n"
            "|  40 |  50 |  60 |\n"
            "+-----+-----+-----+\n"
            "|  70 |  80 |  90 |\n"
            "+-----+-----+-----+",
            [[10, 20, 30], [40, 50, 60], [70, 80, 90]],
        ),
        (
            "+-----+-----+-----+-----+\n"
            "|  10 |  20 |  30 |  40 |\n"
            "+-----+-----+-----+-----+\n"
            "|  50 |  60 |  70 |  80 |\n"
            "+-----+-----+-----+-----+\n"
            "|  90 | 100 | 110 | 120 |\n"
            "+-----+-----+-----+-----+\n"
            "| 130 | 140 | 150 | 160 |\n"
            "+-----+-----+-----+-----+",
            [
                [10, 20, 30, 40],
                [50, 60, 70, 80],
                [90, 100, 110, 120],
                [130, 140, 150, 160],
            ],
        ),
        (
            "+-----+-----+-----+-----+-----+\n"
            "|  10 |  20 |  30 |  40 |  50 |\n"
            "+-----+-----+-----+-----+-----+\n"
            "|  60 |  70 |  80 |  90 | 100 |\n"
            "+-----+-----+-----+-----+-----+\n"
            "| 110 | 120 | 130 | 140 | 150 |\n"
            "+-----+-----+-----+-----+-----+\n"
            "| 160 | 170 | 180 | 190 | 200 |\n"
            "+-----+-----+-----+-----+-----+\n"
            "| 210 | 220 | 230 | 240 | 250 |\n"
            "+-----+-----+-----+-----+-----+",
            [
                [10, 20, 30, 40, 50],
                [60, 70, 80, 90, 100],
                [110, 120, 130, 140, 150],
                [160, 170, 180, 190, 200],
                [210, 220, 230, 240, 250],
            ],
        ),
    ],
)
def test_convert_matrix(matrix: str, square_matrix: list[list[int]]) -> None:
    if isinstance(square_matrix, list):
        assert convert_matrix(matrix) == square_matrix
    else:
        with pytest.raises(
            ValueError,
            match="Unfortunately, the string matrix representation is empty.",
        ):
            convert_matrix(matrix)
