# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SlackReader(pydantic.BaseModel):
    """
    Slack reader.

    Reads conversations from channels. If an earliest_date is provided, an
    optional latest_date can also be provided. If no latest_date is provided,
    we assume the latest date is the current timestamp.

    Args:
    slack_token (Optional[str]): Slack token. If not provided, we
    assume the environment variable `SLACK_BOT_TOKEN` is set.
    ssl (Optional[str]): Custom SSL context. If not provided, it is assumed
    there is already an SSL context available.
    earliest_date (Optional[datetime]): Earliest date from which
    to read conversations. If not provided, we read all messages.
    latest_date (Optional[datetime]): Latest date from which to
    read conversations. If not provided, defaults to current timestamp
    in combination with earliest_date.
    """

    is_remote: typing.Optional[bool]
    slack_token: str
    earliest_date_timestamp: typing.Optional[float]
    latest_date_timestamp: float
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
