# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .share_point_reader_file_extractor_value import SharePointReaderFileExtractorValue

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SharePointReader(pydantic.BaseModel):
    """
    SharePoint reader.

    Reads folders from the SharePoint site from a folder under documents.

    Args:
    client_id (str): The Application ID for the app registered in Microsoft Azure Portal.
    The application must also be configured with MS Graph permissions "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
    client_secret (str): The application secret for the app registered in Azure.
    tenant_id (str): Unique identifier of the Azure Active Directory Instance.
    sharepoint_site_name (Optional[str]): The name of the SharePoint site to download from.
    sharepoint_folder_path (Optional[str]): The path of the SharePoint folder to download from.
    sharepoint_folder_id (Optional[str]): The ID of the SharePoint folder to download from. Overrides sharepoint_folder_path.
    file_extractor (Optional[Dict[str, BaseReader]]): A mapping of file extension to a BaseReader class that specifies how to convert that
    file to text. See `SimpleDirectoryReader` for more details.
    """

    is_remote: typing.Optional[bool] = pydantic.Field(
        description="Whether the data is loaded from a remote API or a local file."
    )
    client_id: typing.Optional[str]
    client_secret: typing.Optional[str]
    tenant_id: typing.Optional[str]
    sharepoint_site_name: typing.Optional[str]
    sharepoint_folder_path: typing.Optional[str]
    sharepoint_folder_id: typing.Optional[str]
    file_extractor: typing.Optional[typing.Dict[str, SharePointReaderFileExtractorValue]]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
