# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .job_names import JobNames
from .status_enum import StatusEnum

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class RawFileManagedIngestionJobRecord(pydantic.BaseModel):
    """
    Schema for job that executes managed pipeline ingestion a Raw File linked to a pipeline.
    """

    id: typing.Optional[str] = pydantic.Field(description="Unique identifier")
    job_name: JobNames
    status: StatusEnum
    started_at: typing.Optional[dt.datetime]
    ended_at: typing.Optional[dt.datetime]
    created_at: typing.Optional[dt.datetime] = pydantic.Field(description="Creation datetime")
    updated_at: typing.Optional[dt.datetime] = pydantic.Field(description="Update datetime")
    partitions: typing.Dict[str, str] = pydantic.Field(description="The partitions for this execution.")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
