# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class QdrantVectorStore(pydantic.BaseModel):
    """
    Qdrant Vector Store.

    In this vector store, embeddings and docs are stored within a
    Qdrant collection.

    During query time, the index uses Qdrant to query for the top
    k most similar nodes.

    Args:
    collection_name: (str): name of the Qdrant collection
    client (Optional[Any]): QdrantClient instance from `qdrant-client` package
    aclient (Optional[Any]): AsyncQdrantClient instance from `qdrant-client` package
    url (Optional[str]): url of the Qdrant instance
    api_key (Optional[str]): API key for authenticating with Qdrant
    batch_size (int): number of points to upload in a single request to Qdrant. Defaults to 64
    parallel (int): number of parallel processes to use during upload. Defaults to 1
    max_retries (int): maximum number of retries in case of a failure. Defaults to 3
    client_kwargs (Optional[dict]): additional kwargs for QdrantClient and AsyncQdrantClient
    enable_hybrid (bool): whether to enable hybrid search using dense and sparse vectors
    sparse_doc_fn (Optional[SparseEncoderCallable]): function to encode sparse vectors
    sparse_query_fn (Optional[SparseEncoderCallable]): function to encode sparse queries
    hybrid_fusion_fn (Optional[HybridFusionCallable]): function to fuse hybrid search results

    Examples:
    `pip install llama-index-vector-stores-qdrant`

        ```python
        import qdrant_client
        from llama_index.vector_stores.qdrant import QdrantVectorStore

        client = qdrant_client.QdrantClient()

        vector_store = QdrantVectorStore(
            collection_name="example_collection", client=client
        )
        ```
    """

    stores_text: typing.Optional[bool]
    is_embedding_query: typing.Optional[bool]
    flat_metadata: typing.Optional[bool]
    collection_name: str
    path: typing.Optional[str]
    url: typing.Optional[str]
    api_key: typing.Optional[str]
    batch_size: int
    parallel: int
    max_retries: int
    client_kwargs: typing.Optional[typing.Dict[str, typing.Any]]
    enable_hybrid: bool
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
