# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .prompt_spec import PromptSpec

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PromptMixinPrompts(pydantic.BaseModel):
    """
    Schema for the prompts derived from the PromptMixin.
    """

    project_id: str = pydantic.Field(description="The ID of the project.")
    id: typing.Optional[str] = pydantic.Field(description="The ID of the prompt set.")
    name: str = pydantic.Field(description="The name of the prompt set.")
    prompts: typing.List[PromptSpec] = pydantic.Field(description="The prompts.")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
