# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PresetRetrievalParams(pydantic.BaseModel):
    """
    Schema for the search params for an retrieval execution that can be preset for a pipeline.
    """

    dense_similarity_top_k: typing.Optional[int] = pydantic.Field(description="Number of nodes for dense retrieval.")
    sparse_similarity_top_k: typing.Optional[int] = pydantic.Field(description="Number of nodes for sparse retrieval.")
    enable_reranking: typing.Optional[bool] = pydantic.Field(description="Enable reranking for retrieval")
    rerank_top_n: typing.Optional[int] = pydantic.Field(description="Number of reranked nodes for returning.")
    alpha: typing.Optional[float] = pydantic.Field(
        description="Alpha value for hybrid retrieval to determine the weights between dense and sparse retrieval. 0 is sparse retrieval and 1 is dense retrieval."
    )
    search_filters: typing.Optional[typing.Dict[str, typing.List[typing.Any]]] = pydantic.Field(
        description="Search filters for retrieval. the format of search_filters is a dict of {key: (operator, value)}"
    )
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
