# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .configured_transformation_item import ConfiguredTransformationItem
from .data_sink_create import DataSinkCreate
from .data_source_create import DataSourceCreate
from .eval_execution_params import EvalExecutionParams
from .pipeline_type import PipelineType
from .preset_retrieval_params import PresetRetrievalParams

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PipelineCreate(pydantic.BaseModel):
    """
    Schema for creating a pipeline.
    """

    configured_transformations: typing.Optional[typing.List[ConfiguredTransformationItem]] = pydantic.Field(
        description="List of configured transformations."
    )
    data_source_ids: typing.Optional[typing.List[str]] = pydantic.Field(
        description="List of data source IDs. When provided instead of data_sources, the data sources will be looked up by ID."
    )
    data_sources: typing.Optional[typing.List[DataSourceCreate]] = pydantic.Field(
        description="List of data sources. When provided instead of data_source_ids, the data sources will be created."
    )
    data_sink_ids: typing.Optional[typing.List[str]] = pydantic.Field(
        description="List of data sink IDs. When provided instead of data_sinks, the data sinks will be looked up by ID."
    )
    data_sinks: typing.Optional[typing.List[DataSinkCreate]] = pydantic.Field(
        description="List of data sinks. When provided instead of data_sink_ids, the data sinks will be created."
    )
    raw_file_names: typing.Optional[typing.List[str]] = pydantic.Field(
        description="List of raw file names to be used as pipeline inputs."
    )
    preset_retrieval_parameters: typing.Optional[PresetRetrievalParams] = pydantic.Field(
        description="Preset retrieval parameters for the pipeline."
    )
    eval_parameters: typing.Optional[EvalExecutionParams] = pydantic.Field(
        description="Eval parameters for the pipeline."
    )
    llama_parse_enabled: typing.Optional[bool] = pydantic.Field(
        description="Whether to use LlamaParse during pipeline execution."
    )
    name: str
    pipeline_type: typing.Optional[PipelineType] = pydantic.Field(
        description="Type of pipeline. Either PLAYGROUND or MANAGED."
    )
    managed_pipeline_id: typing.Optional[str] = pydantic.Field(
        description="The ID of the ManagedPipeline this playground pipeline is linked to."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
