# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .configured_transformation_item import ConfiguredTransformationItem
from .data_sink import DataSink
from .data_source import DataSource
from .eval_execution_params import EvalExecutionParams
from .managed_ingestion_status import ManagedIngestionStatus
from .pipeline_type import PipelineType
from .preset_retrieval_params import PresetRetrievalParams

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Pipeline(pydantic.BaseModel):
    """
    Schema for a pipeline.
    """

    configured_transformations: typing.List[ConfiguredTransformationItem]
    id: str = pydantic.Field(description="Unique identifier")
    created_at: typing.Optional[dt.datetime] = pydantic.Field(description="Creation datetime")
    updated_at: typing.Optional[dt.datetime] = pydantic.Field(description="Update datetime")
    name: str
    project_id: str
    pipeline_type: typing.Optional[PipelineType] = pydantic.Field(
        description="Type of pipeline. Either PLAYGROUND or MANAGED."
    )
    managed_pipeline_id: typing.Optional[str] = pydantic.Field(
        description="The ID of the ManagedPipeline this playground pipeline is linked to."
    )
    preset_retrieval_parameters: typing.Optional[PresetRetrievalParams] = pydantic.Field(
        description="Preset retrieval parameters for the pipeline."
    )
    eval_parameters: typing.Optional[EvalExecutionParams] = pydantic.Field(
        description="Eval parameters for the pipeline."
    )
    llama_parse_enabled: typing.Optional[bool] = pydantic.Field(
        description="Whether to use LlamaParse during pipeline execution."
    )
    managed_ingestion_status: typing.Optional[ManagedIngestionStatus] = pydantic.Field(
        description="Status of Managed Ingestion."
    )
    data_sources: typing.List[DataSource]
    data_sinks: typing.List[DataSink]
    raw_file_names: typing.Optional[typing.List[str]] = pydantic.Field(
        description="List of raw file names to be used as pipeline inputs."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
