# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PineconeVectorStore(pydantic.BaseModel):
    """
    Pinecone Vector Store.

    In this vector store, embeddings and docs are stored within a
    Pinecone index.

    During query time, the index uses Pinecone to query for the top
    k most similar nodes.

    Args:
    pinecone_index (Optional[Union[pinecone.Pinecone.Index, pinecone.Index]]): Pinecone index instance,
    pinecone.Pinecone.Index for clients >= 3.0.0; pinecone.Index for older clients.
    insert_kwargs (Optional[Dict]): insert kwargs during `upsert` call.
    add_sparse_vector (bool): whether to add sparse vector to index.
    tokenizer (Optional[Callable]): tokenizer to use to generate sparse
    default_empty_query_vector (Optional[List[float]]): default empty query vector.
    Defaults to None. If not None, then this vector will be used as the query
    vector if the query is empty.
    """

    stores_text: typing.Optional[bool]
    is_embedding_query: typing.Optional[bool]
    flat_metadata: typing.Optional[bool]
    api_key: typing.Optional[str]
    index_name: typing.Optional[str]
    environment: typing.Optional[str]
    namespace: typing.Optional[str]
    insert_kwargs: typing.Optional[typing.Dict[str, typing.Any]]
    add_sparse_vector: bool
    text_key: str
    batch_size: int
    remove_text_from_metadata: bool
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
