# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .one_drive_reader_file_extractor_value import OneDriveReaderFileExtractorValue

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class OneDriveReader(pydantic.BaseModel):
    """
    Microsoft OneDrive reader.

    Initializes a new instance of the OneDriveReader.

    :param client_id: The Application (client) ID for the app registered in the Azure Entra (formerly Azure Active directory) portal with MS Graph permission "Files.Read.All".
    :param tenant_id: The Directory (tenant) ID of the Azure Active Directory (AAD) tenant the app is registered with.
    Defaults to "consumers" for multi-tenant applications and OneDrive personal.
    :param client_secret: The Application Secret for the app registered in the Azure portal.
    If provided, the MSAL client credential flow will be used for authentication (ConfidentialClientApplication).
    If not provided, interactive authentication will be used (Not recommended for CI/CD or scenarios where manual interaction for authentication is not feasible).
    Required for App authentication.
    :param userprinciplename: The user principal name (normally organization provided email) whose OneDrive will be accessed. Required for App authentication. Will be used if the
    parameter is not provided when calling load_data().
    :param folder_id: The folder ID of the folder to fetch from OneDrive. Will be used if the parameter is not provided when calling load_data().
    :param file_ids: A list of file IDs of files to fetch from OneDrive. Will be used if the parameter is not provided when calling load_data().
    :param folder_path (str, optional): The relative path of the OneDrive folder to download. If provided, files within the folder are downloaded. Will be used if the parameter is
    not provided when calling load_data().
    :param file_paths (List[str], optional): List of specific file paths to download. Will be used if the parameter is not provided when calling load_data().
    :param file_extractor (Optional[Dict[str, BaseReader]]): A mapping of file extension to a BaseReader class that specifies how to convert that file to text.
    See `SimpleDirectoryReader` for more details.

    For interactive authentication to work, a browser is used to authenticate, hence the registered application should have a redirect URI set to 'https://localhost'
    for mobile and native applications.
    """

    is_remote: typing.Optional[bool] = pydantic.Field(
        description="Whether the data is loaded from a remote API or a local file."
    )
    client_id: str
    client_secret: typing.Optional[str]
    tenant_id: typing.Optional[str]
    userprincipalname: typing.Optional[str]
    folder_id: typing.Optional[str]
    file_ids: typing.Optional[typing.List[str]]
    folder_path: typing.Optional[str]
    file_paths: typing.Optional[typing.List[str]]
    file_extractor: typing.Optional[typing.Dict[str, OneDriveReaderFileExtractorValue]]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
