# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .llm import Llm
from .node_parser import NodeParser

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MarkdownElementNodeParser(pydantic.BaseModel):
    """
    Markdown element node parser.

    Splits a markdown document into Text Nodes and Index Nodes corresponding to embedded objects
    (e.g. tables).
    """

    include_metadata: typing.Optional[bool] = pydantic.Field(
        description="Whether or not to consider metadata when splitting."
    )
    include_prev_next_rel: typing.Optional[bool] = pydantic.Field(description="Include prev/next node relationships.")
    callback_manager: typing.Optional[typing.Dict[str, typing.Any]]
    llm: typing.Optional[Llm] = pydantic.Field(description="LLM model to use for summarization.")
    summary_query_str: typing.Optional[str] = pydantic.Field(description="Query string to use for summarization.")
    num_workers: typing.Optional[int] = pydantic.Field(description="Num of workers for async jobs.")
    show_progress: typing.Optional[bool] = pydantic.Field(description="Whether to show progress.")
    nested_node_parser: typing.Optional[NodeParser] = pydantic.Field(
        description="Other types of node parsers to handle some types of nodes."
    )
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
