# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class LocalEval(pydantic.BaseModel):
    """
    Evaluation result, EvaluationResult from llama_index.

    Output of an BaseEvaluator.
    """

    query: typing.Optional[str] = pydantic.Field(description="Query string")
    contexts: typing.Optional[typing.List[str]] = pydantic.Field(description="Context strings")
    response: typing.Optional[str] = pydantic.Field(description="Response string")
    passing: typing.Optional[bool] = pydantic.Field(description="Binary evaluation result (passing or not)")
    feedback: typing.Optional[str] = pydantic.Field(description="Feedback or reasoning for the response")
    score: typing.Optional[float] = pydantic.Field(description="Score for the response")
    pairwise_source: typing.Optional[str] = pydantic.Field(
        description="Used only for pairwise and specifies whether it is from original order of presented answers or flipped order"
    )
    invalid_result: typing.Optional[bool] = pydantic.Field(
        description="Whether the evaluation result is an invalid one."
    )
    invalid_reason: typing.Optional[str] = pydantic.Field(description="Reason for invalid evaluation.")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
