# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class LoadedFile(pydantic.BaseModel):
    """
    Schema for reading a loaded file.
    """

    id: str = pydantic.Field(description="Unique identifier")
    created_at: typing.Optional[dt.datetime] = pydantic.Field(description="Creation datetime")
    updated_at: typing.Optional[dt.datetime] = pydantic.Field(description="Update datetime")
    name: str
    file_size: typing.Optional[int] = pydantic.Field(description="Size of the file in bytes")
    file_type: typing.Optional[str] = pydantic.Field(description="File type (e.g. PDF, DOCX, etc.)")
    num_pages: typing.Optional[int] = pydantic.Field(description="Number of pages in the file")
    data_source_id: typing.Optional[str]
    raw_file_name: typing.Optional[str]
    pipeline_id: str

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
