# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .base_prompt_template import BasePromptTemplate
from .pydantic_program_mode import PydanticProgramMode

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Llm(pydantic.BaseModel):
    """
    The LLM class is the main class for interacting with language models.

    Attributes:
    system_prompt (Optional[str]):
    System prompt for LLM calls.
    messages_to_prompt (Callable):
    Function to convert a list of messages to an LLM prompt.
    completion_to_prompt (Callable):
    Function to convert a completion to an LLM prompt.
    output_parser (Optional[BaseOutputParser]):
    Output parser to parse, validate, and correct errors programmatically.
    pydantic_program_mode (PydanticProgramMode):
    Pydantic program mode to use for structured prediction.
    """

    callback_manager: typing.Optional[typing.Dict[str, typing.Any]]
    system_prompt: typing.Optional[str] = pydantic.Field(description="System prompt for LLM calls.")
    output_parser: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(
        description="Output parser to parse, validate, and correct errors programmatically."
    )
    pydantic_program_mode: typing.Optional[PydanticProgramMode]
    query_wrapper_prompt: typing.Optional[BasePromptTemplate] = pydantic.Field(
        description="Query wrapper prompt for LLM calls."
    )
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
