# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class JobNames(str, enum.Enum):
    """
    Enum for executable pipeline job names.
    """

    LOAD_DOCUMENTS_JOB = "load_documents_job"
    LOAD_RAW_FILES_JOB = "load_raw_files_job"
    PLAYGROUND_JOB = "playground_job"
    EVAL_DATASET_JOB = "eval_dataset_job"
    PIPELINE_MANAGED_INGESTION_JOB = "pipeline_managed_ingestion_job"
    DATA_SOURCE_MANAGED_INGESTION_JOB = "data_source_managed_ingestion_job"
    RAW_FILE_MANAGED_INGESTION_JOB = "raw_file_managed_ingestion_job"

    def visit(
        self,
        load_documents_job: typing.Callable[[], T_Result],
        load_raw_files_job: typing.Callable[[], T_Result],
        playground_job: typing.Callable[[], T_Result],
        eval_dataset_job: typing.Callable[[], T_Result],
        pipeline_managed_ingestion_job: typing.Callable[[], T_Result],
        data_source_managed_ingestion_job: typing.Callable[[], T_Result],
        raw_file_managed_ingestion_job: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is JobNames.LOAD_DOCUMENTS_JOB:
            return load_documents_job()
        if self is JobNames.LOAD_RAW_FILES_JOB:
            return load_raw_files_job()
        if self is JobNames.PLAYGROUND_JOB:
            return playground_job()
        if self is JobNames.EVAL_DATASET_JOB:
            return eval_dataset_job()
        if self is JobNames.PIPELINE_MANAGED_INGESTION_JOB:
            return pipeline_managed_ingestion_job()
        if self is JobNames.DATA_SOURCE_MANAGED_INGESTION_JOB:
            return data_source_managed_ingestion_job()
        if self is JobNames.RAW_FILE_MANAGED_INGESTION_JOB:
            return raw_file_managed_ingestion_job()
