# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .google_drive_reader_file_extractor_value import GoogleDriveReaderFileExtractorValue

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class GoogleDriveReader(pydantic.BaseModel):
    """
    Google Drive Reader.

    Reads files from Google Drive. Credentials passed directly to the constructor
    will take precedence over those passed as file paths.

    Args:
    drive_id (Optional[str]): Drive id of the shared drive in google drive.
    folder_id (Optional[str]): Folder id of the folder in google drive.
    file_ids (Optional[str]): File ids of the files in google drive.
    query_string: A more generic query string to filter the documents, e.g. "name contains 'test'".
    It gives more flexibility to filter the documents. More info: https://developers.google.com/drive/api/v3/search-files
    is_cloud (Optional[bool]): Whether the reader is being used in
    a cloud environment. Will not save credentials to disk if so.
    Defaults to False.
    credentials_path (Optional[str]): Path to client config file.
    Defaults to None.
    token_path (Optional[str]): Path to authorized user info file. Defaults
    to None.
    service_account_key_path (Optional[str]): Path to service account key
    file. Defaults to None.
    client_config (Optional[dict]): Dictionary containing client config.
    Defaults to None.
    authorized_user_info (Optional[dict]): Dicstionary containing authorized
    user info. Defaults to None.
    service_account_key (Optional[dict]): Dictionary containing service
    account key. Defaults to None.
    file_extractor (Optional[Dict[str, BaseReader]]): A mapping of file
    extension to a BaseReader class that specifies how to convert that
    file to text. See `SimpleDirectoryReader` for more details.
    """

    is_remote: typing.Optional[bool] = pydantic.Field(
        description="Whether the data is loaded from a remote API or a local file."
    )
    drive_id: typing.Optional[str]
    folder_id: typing.Optional[str]
    file_ids: typing.Optional[typing.List[str]]
    query_string: typing.Optional[str]
    client_config: typing.Optional[typing.Dict[str, typing.Any]]
    authorized_user_info: typing.Optional[typing.Dict[str, typing.Any]]
    service_account_key: typing.Optional[typing.Dict[str, typing.Any]]
    token_path: typing.Optional[str]
    file_extractor: typing.Optional[typing.Dict[str, GoogleDriveReaderFileExtractorValue]]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
