# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .gcs_reader_file_extractor_value import GcsReaderFileExtractorValue

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class GcsReader(pydantic.BaseModel):
    """
    General reader for any GCS file or directory.

    If key is not set, the entire bucket (filtered by prefix) is parsed.

    Args:
    bucket (str): the name of your GCS bucket
    key (Optional[str]): the name of the specific file. If none is provided,
    this loader will iterate through the entire bucket.
    prefix (Optional[str]): the prefix to filter by in the case that the loader
    iterates through the entire bucket. Defaults to empty string.
    recursive (bool): Whether to recursively search in subdirectories.
    True by default.
    file_extractor (Optional[Dict[str, BaseReader]]): A mapping of file
    extension to a BaseReader class that specifies how to convert that file
    to text. See `SimpleDirectoryReader` for more details.
    required_exts (Optional[List[str]]): List of required extensions.
    Default is None.
    num_files_limit (Optional[int]): Maximum number of files to read.
    Default is None.
    file_metadata (Optional[Callable[str, Dict]]): A function that takes
    in a filename and returns a Dict of metadata for the Document.
    Default is None.
    service_account_key (Optional[Dict[str, str]]): provide GCP service account key directly.
    service_account_key_json (Optional[str]): provide GCP service account key as a JSON string.
    """

    is_remote: typing.Optional[bool]
    bucket: str
    key: typing.Optional[str]
    prefix: typing.Optional[str]
    recursive: typing.Optional[bool]
    file_extractor: typing.Optional[typing.Dict[str, GcsReaderFileExtractorValue]]
    required_exts: typing.Optional[typing.List[str]]
    filename_as_id: typing.Optional[bool]
    num_files_limit: typing.Optional[int]
    service_account_key: typing.Optional[typing.Dict[str, str]]
    service_account_key_json: typing.Optional[str]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
